/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jde.debugger.DebuggeeProcess;
import jde.debugger.JDEException;
import jde.debugger.command.DebugCommand;

public abstract class DebugProcessCommand
extends DebugCommand {
    DebuggeeProcess proc;
    protected Map identifiableEventRequests = Collections.synchronizedMap(new HashMap());

    public void init(Integer procID, Integer cmdID, String cmdName, List args) throws JDEException {
        super.init(procID, cmdID, cmdName, args);
        if (!this.procRegistry.processExists(procID)) {
            throw new JDEException("Application " + procID + " does not exist");
        }
        this.proc = this.procRegistry.getProcess(procID);
    }

    protected Long addIdentifiableRequest(EventRequest e) {
        Long id;
        Map map = this.identifiableEventRequests;
        synchronized (map) {
            id = this.proc.generateObjectID();
            this.identifiableEventRequests.put(id, e);
        }
        e.enable();
        return id;
    }

    protected void deleteIdentifiableRequest(Long id) throws JDEException {
        EventRequestManager erm = this.proc.getVM().eventRequestManager();
        Map map = this.identifiableEventRequests;
        synchronized (map) {
            if (!this.identifiableEventRequests.containsKey(id)) {
                throw new JDEException("Invalid request ID");
            }
            Object e = this.identifiableEventRequests.get(id);
            if (e == null) {
                throw new JDEException("No such event request");
            }
            if (!(e instanceof EventRequest)) {
                throw new JDEException("Not an event request");
            }
            ((EventRequest)e).disable();
            erm.deleteEventRequest((EventRequest)e);
        }
    }
}

