/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.lang.reflect.Method;
import java.util.Hashtable;
import jde.wizards.ClassRegistry;
import jde.wizards.DefaultNameFactory;
import jde.wizards.NameFactory;
import jde.wizards.Signature;

public class MethodFactory
implements ClassRegistry {
    protected Hashtable imports = new Hashtable();
    protected NameFactory namefactory = null;

    public MethodFactory() {
        this(new DefaultNameFactory());
    }

    public MethodFactory(NameFactory factory) {
        this.namefactory = factory;
    }

    public void setNameFactory(NameFactory factory) {
        this.namefactory = factory;
    }

    public NameFactory getNameFactory() {
        return this.namefactory;
    }

    public Hashtable getImports() {
        return this.imports;
    }

    public void registerImport(Class register) {
        if (register.isArray()) {
            try {
                Class<?> cl = register;
                while (cl.isArray()) {
                    cl = cl.getComponentType();
                }
                register = cl;
            }
            catch (Throwable t) {
                throw new RuntimeException("Caught error walking up an Array object: " + t);
            }
        }
        if (this.shouldImport(register)) {
            this.imports.put(register, "");
        }
    }

    private final boolean shouldImport(Class c) {
        if (c.isPrimitive()) {
            return false;
        }
        String name = c.getName();
        if (name.startsWith("java.lang")) {
            char[] n = name.toCharArray();
            int i = 10;
            while (i < n.length) {
                if (n[i] == '.') {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public String getMethodSkeleton(Signature sig, boolean javadoc, boolean newline, String todo) {
        String res = "";
        res = res + "\n";
        if (javadoc) {
            res = res + sig.toJavaDoc() + "\n";
        }
        if (newline) {
            res = res + sig + "\n";
            res = res + "{\n";
        } else {
            res = res + sig + " {\n";
        }
        res = res + todo;
        Method m = sig.getMethod();
        Class<?> cl = m.getReturnType();
        if (!cl.getName().equals("void")) {
            res = res + "  return null;\n";
        }
        res = res + "}\n";
        return res;
    }

    public void flush() {
        this.imports.clear();
    }

    public static void println(String s) {
        System.out.print(s + "\n");
        System.out.flush();
    }
}

