;;; ucs-hangul.el --- UCS table of Hangul Syllables

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, Hangul Syllables

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

(ucs-set-char #xAC00 ?$(C0!(B) ; KS0-C-3021
(ucs-set-char #xAC01 ?$(C0"(B) ; KS0-C-3022
(ucs-set-char #xAC04 ?$(C0#(B) ; KS0-C-3023
(ucs-set-char #xAC07 ?$(C0$(B) ; KS0-C-3024
(ucs-set-char #xAC08 ?$(C0%(B) ; KS0-C-3025
(ucs-set-char #xAC09 ?$(C0&(B) ; KS0-C-3026
(ucs-set-char #xAC0A ?$(C0'(B) ; KS0-C-3027
(ucs-set-char #xAC10 ?$(C0((B) ; KS0-C-3028
(ucs-set-char #xAC11 ?$(C0)(B) ; KS0-C-3029
(ucs-set-char #xAC12 ?$(C0*(B) ; KS0-C-302A
(ucs-set-char #xAC13 ?$(C0+(B) ; KS0-C-302B
(ucs-set-char #xAC14 ?$(C0,(B) ; KS0-C-302C
(ucs-set-char #xAC15 ?$(C0-(B) ; KS0-C-302D
(ucs-set-char #xAC16 ?$(C0.(B) ; KS0-C-302E
(ucs-set-char #xAC17 ?$(C0/(B) ; KS0-C-302F
(ucs-set-char #xAC19 ?$(C00(B) ; KS0-C-3030
(ucs-set-char #xAC1A ?$(C01(B) ; KS0-C-3031
(ucs-set-char #xAC1B ?$(C02(B) ; KS0-C-3032
(ucs-set-char #xAC1C ?$(C03(B) ; KS0-C-3033
(ucs-set-char #xAC1D ?$(C04(B) ; KS0-C-3034
(ucs-set-char #xAC20 ?$(C05(B) ; KS0-C-3035
(ucs-set-char #xAC24 ?$(C06(B) ; KS0-C-3036
(ucs-set-char #xAC2C ?$(C07(B) ; KS0-C-3037
(ucs-set-char #xAC2D ?$(C08(B) ; KS0-C-3038
(ucs-set-char #xAC2F ?$(C09(B) ; KS0-C-3039
(ucs-set-char #xAC30 ?$(C0:(B) ; KS0-C-303A
(ucs-set-char #xAC31 ?$(C0;(B) ; KS0-C-303B
(ucs-set-char #xAC38 ?$(C0<(B) ; KS0-C-303C
(ucs-set-char #xAC39 ?$(C0=(B) ; KS0-C-303D
(ucs-set-char #xAC3C ?$(C0>(B) ; KS0-C-303E
(ucs-set-char #xAC40 ?$(C0?(B) ; KS0-C-303F
(ucs-set-char #xAC4B ?$(C0@(B) ; KS0-C-3040
(ucs-set-char #xAC4D ?$(C0A(B) ; KS0-C-3041
(ucs-set-char #xAC54 ?$(C0B(B) ; KS0-C-3042
(ucs-set-char #xAC58 ?$(C0C(B) ; KS0-C-3043
(ucs-set-char #xAC5C ?$(C0D(B) ; KS0-C-3044
(ucs-set-char #xAC70 ?$(C0E(B) ; KS0-C-3045
(ucs-set-char #xAC71 ?$(C0F(B) ; KS0-C-3046
(ucs-set-char #xAC74 ?$(C0G(B) ; KS0-C-3047
(ucs-set-char #xAC77 ?$(C0H(B) ; KS0-C-3048
(ucs-set-char #xAC78 ?$(C0I(B) ; KS0-C-3049
(ucs-set-char #xAC7A ?$(C0J(B) ; KS0-C-304A
(ucs-set-char #xAC80 ?$(C0K(B) ; KS0-C-304B
(ucs-set-char #xAC81 ?$(C0L(B) ; KS0-C-304C
(ucs-set-char #xAC83 ?$(C0M(B) ; KS0-C-304D
(ucs-set-char #xAC84 ?$(C0N(B) ; KS0-C-304E
(ucs-set-char #xAC85 ?$(C0O(B) ; KS0-C-304F
(ucs-set-char #xAC86 ?$(C0P(B) ; KS0-C-3050
(ucs-set-char #xAC89 ?$(C0Q(B) ; KS0-C-3051
(ucs-set-char #xAC8A ?$(C0R(B) ; KS0-C-3052
(ucs-set-char #xAC8B ?$(C0S(B) ; KS0-C-3053
(ucs-set-char #xAC8C ?$(C0T(B) ; KS0-C-3054
(ucs-set-char #xAC90 ?$(C0U(B) ; KS0-C-3055
(ucs-set-char #xAC94 ?$(C0V(B) ; KS0-C-3056
(ucs-set-char #xAC9C ?$(C0W(B) ; KS0-C-3057
(ucs-set-char #xAC9D ?$(C0X(B) ; KS0-C-3058
(ucs-set-char #xAC9F ?$(C0Y(B) ; KS0-C-3059
(ucs-set-char #xACA0 ?$(C0Z(B) ; KS0-C-305A
(ucs-set-char #xACA1 ?$(C0[(B) ; KS0-C-305B
(ucs-set-char #xACA8 ?$(C0\(B) ; KS0-C-305C
(ucs-set-char #xACA9 ?$(C0](B) ; KS0-C-305D
(ucs-set-char #xACAA ?$(C0^(B) ; KS0-C-305E
(ucs-set-char #xACAC ?$(C0_(B) ; KS0-C-305F
(ucs-set-char #xACAF ?$(C0`(B) ; KS0-C-3060
(ucs-set-char #xACB0 ?$(C0a(B) ; KS0-C-3061
(ucs-set-char #xACB8 ?$(C0b(B) ; KS0-C-3062
(ucs-set-char #xACB9 ?$(C0c(B) ; KS0-C-3063
(ucs-set-char #xACBB ?$(C0d(B) ; KS0-C-3064
(ucs-set-char #xACBC ?$(C0e(B) ; KS0-C-3065
(ucs-set-char #xACBD ?$(C0f(B) ; KS0-C-3066
(ucs-set-char #xACC1 ?$(C0g(B) ; KS0-C-3067
(ucs-set-char #xACC4 ?$(C0h(B) ; KS0-C-3068
(ucs-set-char #xACC8 ?$(C0i(B) ; KS0-C-3069
(ucs-set-char #xACCC ?$(C0j(B) ; KS0-C-306A
(ucs-set-char #xACD5 ?$(C0k(B) ; KS0-C-306B
(ucs-set-char #xACD7 ?$(C0l(B) ; KS0-C-306C
(ucs-set-char #xACE0 ?$(C0m(B) ; KS0-C-306D
(ucs-set-char #xACE1 ?$(C0n(B) ; KS0-C-306E
(ucs-set-char #xACE4 ?$(C0o(B) ; KS0-C-306F
(ucs-set-char #xACE7 ?$(C0p(B) ; KS0-C-3070
(ucs-set-char #xACE8 ?$(C0q(B) ; KS0-C-3071
(ucs-set-char #xACEA ?$(C0r(B) ; KS0-C-3072
(ucs-set-char #xACEC ?$(C0s(B) ; KS0-C-3073
(ucs-set-char #xACEF ?$(C0t(B) ; KS0-C-3074
(ucs-set-char #xACF0 ?$(C0u(B) ; KS0-C-3075
(ucs-set-char #xACF1 ?$(C0v(B) ; KS0-C-3076
(ucs-set-char #xACF3 ?$(C0w(B) ; KS0-C-3077
(ucs-set-char #xACF5 ?$(C0x(B) ; KS0-C-3078
(ucs-set-char #xACF6 ?$(C0y(B) ; KS0-C-3079
(ucs-set-char #xACFC ?$(C0z(B) ; KS0-C-307A
(ucs-set-char #xACFD ?$(C0{(B) ; KS0-C-307B
(ucs-set-char #xAD00 ?$(C0|(B) ; KS0-C-307C
(ucs-set-char #xAD04 ?$(C0}(B) ; KS0-C-307D
(ucs-set-char #xAD06 ?$(C0~(B) ; KS0-C-307E
(ucs-set-char #xAD0C ?$(C1!(B) ; KS0-C-3121
(ucs-set-char #xAD0D ?$(C1"(B) ; KS0-C-3122
(ucs-set-char #xAD0F ?$(C1#(B) ; KS0-C-3123
(ucs-set-char #xAD11 ?$(C1$(B) ; KS0-C-3124
(ucs-set-char #xAD18 ?$(C1%(B) ; KS0-C-3125
(ucs-set-char #xAD1C ?$(C1&(B) ; KS0-C-3126
(ucs-set-char #xAD20 ?$(C1'(B) ; KS0-C-3127
(ucs-set-char #xAD29 ?$(C1((B) ; KS0-C-3128
(ucs-set-char #xAD2C ?$(C1)(B) ; KS0-C-3129
(ucs-set-char #xAD2D ?$(C1*(B) ; KS0-C-312A
(ucs-set-char #xAD34 ?$(C1+(B) ; KS0-C-312B
(ucs-set-char #xAD35 ?$(C1,(B) ; KS0-C-312C
(ucs-set-char #xAD38 ?$(C1-(B) ; KS0-C-312D
(ucs-set-char #xAD3C ?$(C1.(B) ; KS0-C-312E
(ucs-set-char #xAD44 ?$(C1/(B) ; KS0-C-312F
(ucs-set-char #xAD45 ?$(C10(B) ; KS0-C-3130
(ucs-set-char #xAD47 ?$(C11(B) ; KS0-C-3131
(ucs-set-char #xAD49 ?$(C12(B) ; KS0-C-3132
(ucs-set-char #xAD50 ?$(C13(B) ; KS0-C-3133
(ucs-set-char #xAD54 ?$(C14(B) ; KS0-C-3134
(ucs-set-char #xAD58 ?$(C15(B) ; KS0-C-3135
(ucs-set-char #xAD61 ?$(C16(B) ; KS0-C-3136
(ucs-set-char #xAD63 ?$(C17(B) ; KS0-C-3137
(ucs-set-char #xAD6C ?$(C18(B) ; KS0-C-3138
(ucs-set-char #xAD6D ?$(C19(B) ; KS0-C-3139
(ucs-set-char #xAD70 ?$(C1:(B) ; KS0-C-313A
(ucs-set-char #xAD73 ?$(C1;(B) ; KS0-C-313B
(ucs-set-char #xAD74 ?$(C1<(B) ; KS0-C-313C
(ucs-set-char #xAD75 ?$(C1=(B) ; KS0-C-313D
(ucs-set-char #xAD76 ?$(C1>(B) ; KS0-C-313E
(ucs-set-char #xAD7B ?$(C1?(B) ; KS0-C-313F
(ucs-set-char #xAD7C ?$(C1@(B) ; KS0-C-3140
(ucs-set-char #xAD7D ?$(C1A(B) ; KS0-C-3141
(ucs-set-char #xAD7F ?$(C1B(B) ; KS0-C-3142
(ucs-set-char #xAD81 ?$(C1C(B) ; KS0-C-3143
(ucs-set-char #xAD82 ?$(C1D(B) ; KS0-C-3144
(ucs-set-char #xAD88 ?$(C1E(B) ; KS0-C-3145
(ucs-set-char #xAD89 ?$(C1F(B) ; KS0-C-3146
(ucs-set-char #xAD8C ?$(C1G(B) ; KS0-C-3147
(ucs-set-char #xAD90 ?$(C1H(B) ; KS0-C-3148
(ucs-set-char #xAD9C ?$(C1I(B) ; KS0-C-3149
(ucs-set-char #xAD9D ?$(C1J(B) ; KS0-C-314A
(ucs-set-char #xADA4 ?$(C1K(B) ; KS0-C-314B
(ucs-set-char #xADB7 ?$(C1L(B) ; KS0-C-314C
(ucs-set-char #xADC0 ?$(C1M(B) ; KS0-C-314D
(ucs-set-char #xADC1 ?$(C1N(B) ; KS0-C-314E
(ucs-set-char #xADC4 ?$(C1O(B) ; KS0-C-314F
(ucs-set-char #xADC8 ?$(C1P(B) ; KS0-C-3150
(ucs-set-char #xADD0 ?$(C1Q(B) ; KS0-C-3151
(ucs-set-char #xADD1 ?$(C1R(B) ; KS0-C-3152
(ucs-set-char #xADD3 ?$(C1S(B) ; KS0-C-3153
(ucs-set-char #xADDC ?$(C1T(B) ; KS0-C-3154
(ucs-set-char #xADE0 ?$(C1U(B) ; KS0-C-3155
(ucs-set-char #xADE4 ?$(C1V(B) ; KS0-C-3156
(ucs-set-char #xADF8 ?$(C1W(B) ; KS0-C-3157
(ucs-set-char #xADF9 ?$(C1X(B) ; KS0-C-3158
(ucs-set-char #xADFC ?$(C1Y(B) ; KS0-C-3159
(ucs-set-char #xADFF ?$(C1Z(B) ; KS0-C-315A
(ucs-set-char #xAE00 ?$(C1[(B) ; KS0-C-315B
(ucs-set-char #xAE01 ?$(C1\(B) ; KS0-C-315C
(ucs-set-char #xAE08 ?$(C1](B) ; KS0-C-315D
(ucs-set-char #xAE09 ?$(C1^(B) ; KS0-C-315E
(ucs-set-char #xAE0B ?$(C1_(B) ; KS0-C-315F
(ucs-set-char #xAE0D ?$(C1`(B) ; KS0-C-3160
(ucs-set-char #xAE14 ?$(C1a(B) ; KS0-C-3161
(ucs-set-char #xAE30 ?$(C1b(B) ; KS0-C-3162
(ucs-set-char #xAE31 ?$(C1c(B) ; KS0-C-3163
(ucs-set-char #xAE34 ?$(C1d(B) ; KS0-C-3164
(ucs-set-char #xAE37 ?$(C1e(B) ; KS0-C-3165
(ucs-set-char #xAE38 ?$(C1f(B) ; KS0-C-3166
(ucs-set-char #xAE3A ?$(C1g(B) ; KS0-C-3167
(ucs-set-char #xAE40 ?$(C1h(B) ; KS0-C-3168
(ucs-set-char #xAE41 ?$(C1i(B) ; KS0-C-3169
(ucs-set-char #xAE43 ?$(C1j(B) ; KS0-C-316A
(ucs-set-char #xAE45 ?$(C1k(B) ; KS0-C-316B
(ucs-set-char #xAE46 ?$(C1l(B) ; KS0-C-316C
(ucs-set-char #xAE4A ?$(C1m(B) ; KS0-C-316D
(ucs-set-char #xAE4C ?$(C1n(B) ; KS0-C-316E
(ucs-set-char #xAE4D ?$(C1o(B) ; KS0-C-316F
(ucs-set-char #xAE4E ?$(C1p(B) ; KS0-C-3170
(ucs-set-char #xAE50 ?$(C1q(B) ; KS0-C-3171
(ucs-set-char #xAE54 ?$(C1r(B) ; KS0-C-3172
(ucs-set-char #xAE56 ?$(C1s(B) ; KS0-C-3173
(ucs-set-char #xAE5C ?$(C1t(B) ; KS0-C-3174
(ucs-set-char #xAE5D ?$(C1u(B) ; KS0-C-3175
(ucs-set-char #xAE5F ?$(C1v(B) ; KS0-C-3176
(ucs-set-char #xAE60 ?$(C1w(B) ; KS0-C-3177
(ucs-set-char #xAE61 ?$(C1x(B) ; KS0-C-3178
(ucs-set-char #xAE65 ?$(C1y(B) ; KS0-C-3179
(ucs-set-char #xAE68 ?$(C1z(B) ; KS0-C-317A
(ucs-set-char #xAE69 ?$(C1{(B) ; KS0-C-317B
(ucs-set-char #xAE6C ?$(C1|(B) ; KS0-C-317C
(ucs-set-char #xAE70 ?$(C1}(B) ; KS0-C-317D
(ucs-set-char #xAE78 ?$(C1~(B) ; KS0-C-317E
(ucs-set-char #xAE79 ?$(C2!(B) ; KS0-C-3221
(ucs-set-char #xAE7B ?$(C2"(B) ; KS0-C-3222
(ucs-set-char #xAE7C ?$(C2#(B) ; KS0-C-3223
(ucs-set-char #xAE7D ?$(C2$(B) ; KS0-C-3224
(ucs-set-char #xAE84 ?$(C2%(B) ; KS0-C-3225
(ucs-set-char #xAE85 ?$(C2&(B) ; KS0-C-3226
(ucs-set-char #xAE8C ?$(C2'(B) ; KS0-C-3227
(ucs-set-char #xAEBC ?$(C2((B) ; KS0-C-3228
(ucs-set-char #xAEBD ?$(C2)(B) ; KS0-C-3229
(ucs-set-char #xAEBE ?$(C2*(B) ; KS0-C-322A
(ucs-set-char #xAEC0 ?$(C2+(B) ; KS0-C-322B
(ucs-set-char #xAEC4 ?$(C2,(B) ; KS0-C-322C
(ucs-set-char #xAECC ?$(C2-(B) ; KS0-C-322D
(ucs-set-char #xAECD ?$(C2.(B) ; KS0-C-322E
(ucs-set-char #xAECF ?$(C2/(B) ; KS0-C-322F
(ucs-set-char #xAED0 ?$(C20(B) ; KS0-C-3230
(ucs-set-char #xAED1 ?$(C21(B) ; KS0-C-3231
(ucs-set-char #xAED8 ?$(C22(B) ; KS0-C-3232
(ucs-set-char #xAED9 ?$(C23(B) ; KS0-C-3233
(ucs-set-char #xAEDC ?$(C24(B) ; KS0-C-3234
(ucs-set-char #xAEE8 ?$(C25(B) ; KS0-C-3235
(ucs-set-char #xAEEB ?$(C26(B) ; KS0-C-3236
(ucs-set-char #xAEED ?$(C27(B) ; KS0-C-3237
(ucs-set-char #xAEF4 ?$(C28(B) ; KS0-C-3238
(ucs-set-char #xAEF8 ?$(C29(B) ; KS0-C-3239
(ucs-set-char #xAEFC ?$(C2:(B) ; KS0-C-323A
(ucs-set-char #xAF07 ?$(C2;(B) ; KS0-C-323B
(ucs-set-char #xAF08 ?$(C2<(B) ; KS0-C-323C
(ucs-set-char #xAF0D ?$(C2=(B) ; KS0-C-323D
(ucs-set-char #xAF10 ?$(C2>(B) ; KS0-C-323E
(ucs-set-char #xAF2C ?$(C2?(B) ; KS0-C-323F
(ucs-set-char #xAF2D ?$(C2@(B) ; KS0-C-3240
(ucs-set-char #xAF30 ?$(C2A(B) ; KS0-C-3241
(ucs-set-char #xAF32 ?$(C2B(B) ; KS0-C-3242
(ucs-set-char #xAF34 ?$(C2C(B) ; KS0-C-3243
(ucs-set-char #xAF3C ?$(C2D(B) ; KS0-C-3244
(ucs-set-char #xAF3D ?$(C2E(B) ; KS0-C-3245
(ucs-set-char #xAF3F ?$(C2F(B) ; KS0-C-3246
(ucs-set-char #xAF41 ?$(C2G(B) ; KS0-C-3247
(ucs-set-char #xAF42 ?$(C2H(B) ; KS0-C-3248
(ucs-set-char #xAF43 ?$(C2I(B) ; KS0-C-3249
(ucs-set-char #xAF48 ?$(C2J(B) ; KS0-C-324A
(ucs-set-char #xAF49 ?$(C2K(B) ; KS0-C-324B
(ucs-set-char #xAF50 ?$(C2L(B) ; KS0-C-324C
(ucs-set-char #xAF5C ?$(C2M(B) ; KS0-C-324D
(ucs-set-char #xAF5D ?$(C2N(B) ; KS0-C-324E
(ucs-set-char #xAF64 ?$(C2O(B) ; KS0-C-324F
(ucs-set-char #xAF65 ?$(C2P(B) ; KS0-C-3250
(ucs-set-char #xAF79 ?$(C2Q(B) ; KS0-C-3251
(ucs-set-char #xAF80 ?$(C2R(B) ; KS0-C-3252
(ucs-set-char #xAF84 ?$(C2S(B) ; KS0-C-3253
(ucs-set-char #xAF88 ?$(C2T(B) ; KS0-C-3254
(ucs-set-char #xAF90 ?$(C2U(B) ; KS0-C-3255
(ucs-set-char #xAF91 ?$(C2V(B) ; KS0-C-3256
(ucs-set-char #xAF95 ?$(C2W(B) ; KS0-C-3257
(ucs-set-char #xAF9C ?$(C2X(B) ; KS0-C-3258
(ucs-set-char #xAFB8 ?$(C2Y(B) ; KS0-C-3259
(ucs-set-char #xAFB9 ?$(C2Z(B) ; KS0-C-325A
(ucs-set-char #xAFBC ?$(C2[(B) ; KS0-C-325B
(ucs-set-char #xAFC0 ?$(C2\(B) ; KS0-C-325C
(ucs-set-char #xAFC7 ?$(C2](B) ; KS0-C-325D
(ucs-set-char #xAFC8 ?$(C2^(B) ; KS0-C-325E
(ucs-set-char #xAFC9 ?$(C2_(B) ; KS0-C-325F
(ucs-set-char #xAFCB ?$(C2`(B) ; KS0-C-3260
(ucs-set-char #xAFCD ?$(C2a(B) ; KS0-C-3261
(ucs-set-char #xAFCE ?$(C2b(B) ; KS0-C-3262
(ucs-set-char #xAFD4 ?$(C2c(B) ; KS0-C-3263
(ucs-set-char #xAFDC ?$(C2d(B) ; KS0-C-3264
(ucs-set-char #xAFE8 ?$(C2e(B) ; KS0-C-3265
(ucs-set-char #xAFE9 ?$(C2f(B) ; KS0-C-3266
(ucs-set-char #xAFF0 ?$(C2g(B) ; KS0-C-3267
(ucs-set-char #xAFF1 ?$(C2h(B) ; KS0-C-3268
(ucs-set-char #xAFF4 ?$(C2i(B) ; KS0-C-3269
(ucs-set-char #xAFF8 ?$(C2j(B) ; KS0-C-326A
(ucs-set-char #xB000 ?$(C2k(B) ; KS0-C-326B
(ucs-set-char #xB001 ?$(C2l(B) ; KS0-C-326C
(ucs-set-char #xB004 ?$(C2m(B) ; KS0-C-326D
(ucs-set-char #xB00C ?$(C2n(B) ; KS0-C-326E
(ucs-set-char #xB010 ?$(C2o(B) ; KS0-C-326F
(ucs-set-char #xB014 ?$(C2p(B) ; KS0-C-3270
(ucs-set-char #xB01C ?$(C2q(B) ; KS0-C-3271
(ucs-set-char #xB01D ?$(C2r(B) ; KS0-C-3272
(ucs-set-char #xB028 ?$(C2s(B) ; KS0-C-3273
(ucs-set-char #xB044 ?$(C2t(B) ; KS0-C-3274
(ucs-set-char #xB045 ?$(C2u(B) ; KS0-C-3275
(ucs-set-char #xB048 ?$(C2v(B) ; KS0-C-3276
(ucs-set-char #xB04A ?$(C2w(B) ; KS0-C-3277
(ucs-set-char #xB04C ?$(C2x(B) ; KS0-C-3278
(ucs-set-char #xB04E ?$(C2y(B) ; KS0-C-3279
(ucs-set-char #xB053 ?$(C2z(B) ; KS0-C-327A
(ucs-set-char #xB054 ?$(C2{(B) ; KS0-C-327B
(ucs-set-char #xB055 ?$(C2|(B) ; KS0-C-327C
(ucs-set-char #xB057 ?$(C2}(B) ; KS0-C-327D
(ucs-set-char #xB059 ?$(C2~(B) ; KS0-C-327E
(ucs-set-char #xB05D ?$(C3!(B) ; KS0-C-3321
(ucs-set-char #xB07C ?$(C3"(B) ; KS0-C-3322
(ucs-set-char #xB07D ?$(C3#(B) ; KS0-C-3323
(ucs-set-char #xB080 ?$(C3$(B) ; KS0-C-3324
(ucs-set-char #xB084 ?$(C3%(B) ; KS0-C-3325
(ucs-set-char #xB08C ?$(C3&(B) ; KS0-C-3326
(ucs-set-char #xB08D ?$(C3'(B) ; KS0-C-3327
(ucs-set-char #xB08F ?$(C3((B) ; KS0-C-3328
(ucs-set-char #xB091 ?$(C3)(B) ; KS0-C-3329
(ucs-set-char #xB098 ?$(C3*(B) ; KS0-C-332A
(ucs-set-char #xB099 ?$(C3+(B) ; KS0-C-332B
(ucs-set-char #xB09A ?$(C3,(B) ; KS0-C-332C
(ucs-set-char #xB09C ?$(C3-(B) ; KS0-C-332D
(ucs-set-char #xB09F ?$(C3.(B) ; KS0-C-332E
(ucs-set-char #xB0A0 ?$(C3/(B) ; KS0-C-332F
(ucs-set-char #xB0A1 ?$(C30(B) ; KS0-C-3330
(ucs-set-char #xB0A2 ?$(C31(B) ; KS0-C-3331
(ucs-set-char #xB0A8 ?$(C32(B) ; KS0-C-3332
(ucs-set-char #xB0A9 ?$(C33(B) ; KS0-C-3333
(ucs-set-char #xB0AB ?$(C34(B) ; KS0-C-3334
(ucs-set-char #xB0AC ?$(C35(B) ; KS0-C-3335
(ucs-set-char #xB0AD ?$(C36(B) ; KS0-C-3336
(ucs-set-char #xB0AE ?$(C37(B) ; KS0-C-3337
(ucs-set-char #xB0AF ?$(C38(B) ; KS0-C-3338
(ucs-set-char #xB0B1 ?$(C39(B) ; KS0-C-3339
(ucs-set-char #xB0B3 ?$(C3:(B) ; KS0-C-333A
(ucs-set-char #xB0B4 ?$(C3;(B) ; KS0-C-333B
(ucs-set-char #xB0B5 ?$(C3<(B) ; KS0-C-333C
(ucs-set-char #xB0B8 ?$(C3=(B) ; KS0-C-333D
(ucs-set-char #xB0BC ?$(C3>(B) ; KS0-C-333E
(ucs-set-char #xB0C4 ?$(C3?(B) ; KS0-C-333F
(ucs-set-char #xB0C5 ?$(C3@(B) ; KS0-C-3340
(ucs-set-char #xB0C7 ?$(C3A(B) ; KS0-C-3341
(ucs-set-char #xB0C8 ?$(C3B(B) ; KS0-C-3342
(ucs-set-char #xB0C9 ?$(C3C(B) ; KS0-C-3343
(ucs-set-char #xB0D0 ?$(C3D(B) ; KS0-C-3344
(ucs-set-char #xB0D1 ?$(C3E(B) ; KS0-C-3345
(ucs-set-char #xB0D4 ?$(C3F(B) ; KS0-C-3346
(ucs-set-char #xB0D8 ?$(C3G(B) ; KS0-C-3347
(ucs-set-char #xB0E0 ?$(C3H(B) ; KS0-C-3348
(ucs-set-char #xB0E5 ?$(C3I(B) ; KS0-C-3349
(ucs-set-char #xB108 ?$(C3J(B) ; KS0-C-334A
(ucs-set-char #xB109 ?$(C3K(B) ; KS0-C-334B
(ucs-set-char #xB10B ?$(C3L(B) ; KS0-C-334C
(ucs-set-char #xB10C ?$(C3M(B) ; KS0-C-334D
(ucs-set-char #xB110 ?$(C3N(B) ; KS0-C-334E
(ucs-set-char #xB112 ?$(C3O(B) ; KS0-C-334F
(ucs-set-char #xB113 ?$(C3P(B) ; KS0-C-3350
(ucs-set-char #xB118 ?$(C3Q(B) ; KS0-C-3351
(ucs-set-char #xB119 ?$(C3R(B) ; KS0-C-3352
(ucs-set-char #xB11B ?$(C3S(B) ; KS0-C-3353
(ucs-set-char #xB11C ?$(C3T(B) ; KS0-C-3354
(ucs-set-char #xB11D ?$(C3U(B) ; KS0-C-3355
(ucs-set-char #xB123 ?$(C3V(B) ; KS0-C-3356
(ucs-set-char #xB124 ?$(C3W(B) ; KS0-C-3357
(ucs-set-char #xB125 ?$(C3X(B) ; KS0-C-3358
(ucs-set-char #xB128 ?$(C3Y(B) ; KS0-C-3359
(ucs-set-char #xB12C ?$(C3Z(B) ; KS0-C-335A
(ucs-set-char #xB134 ?$(C3[(B) ; KS0-C-335B
(ucs-set-char #xB135 ?$(C3\(B) ; KS0-C-335C
(ucs-set-char #xB137 ?$(C3](B) ; KS0-C-335D
(ucs-set-char #xB138 ?$(C3^(B) ; KS0-C-335E
(ucs-set-char #xB139 ?$(C3_(B) ; KS0-C-335F
(ucs-set-char #xB140 ?$(C3`(B) ; KS0-C-3360
(ucs-set-char #xB141 ?$(C3a(B) ; KS0-C-3361
(ucs-set-char #xB144 ?$(C3b(B) ; KS0-C-3362
(ucs-set-char #xB148 ?$(C3c(B) ; KS0-C-3363
(ucs-set-char #xB150 ?$(C3d(B) ; KS0-C-3364
(ucs-set-char #xB151 ?$(C3e(B) ; KS0-C-3365
(ucs-set-char #xB154 ?$(C3f(B) ; KS0-C-3366
(ucs-set-char #xB155 ?$(C3g(B) ; KS0-C-3367
(ucs-set-char #xB158 ?$(C3h(B) ; KS0-C-3368
(ucs-set-char #xB15C ?$(C3i(B) ; KS0-C-3369
(ucs-set-char #xB160 ?$(C3j(B) ; KS0-C-336A
(ucs-set-char #xB178 ?$(C3k(B) ; KS0-C-336B
(ucs-set-char #xB179 ?$(C3l(B) ; KS0-C-336C
(ucs-set-char #xB17C ?$(C3m(B) ; KS0-C-336D
(ucs-set-char #xB180 ?$(C3n(B) ; KS0-C-336E
(ucs-set-char #xB182 ?$(C3o(B) ; KS0-C-336F
(ucs-set-char #xB188 ?$(C3p(B) ; KS0-C-3370
(ucs-set-char #xB189 ?$(C3q(B) ; KS0-C-3371
(ucs-set-char #xB18B ?$(C3r(B) ; KS0-C-3372
(ucs-set-char #xB18D ?$(C3s(B) ; KS0-C-3373
(ucs-set-char #xB192 ?$(C3t(B) ; KS0-C-3374
(ucs-set-char #xB193 ?$(C3u(B) ; KS0-C-3375
(ucs-set-char #xB194 ?$(C3v(B) ; KS0-C-3376
(ucs-set-char #xB198 ?$(C3w(B) ; KS0-C-3377
(ucs-set-char #xB19C ?$(C3x(B) ; KS0-C-3378
(ucs-set-char #xB1A8 ?$(C3y(B) ; KS0-C-3379
(ucs-set-char #xB1CC ?$(C3z(B) ; KS0-C-337A
(ucs-set-char #xB1D0 ?$(C3{(B) ; KS0-C-337B
(ucs-set-char #xB1D4 ?$(C3|(B) ; KS0-C-337C
(ucs-set-char #xB1DC ?$(C3}(B) ; KS0-C-337D
(ucs-set-char #xB1DD ?$(C3~(B) ; KS0-C-337E
(ucs-set-char #xB1DF ?$(C4!(B) ; KS0-C-3421
(ucs-set-char #xB1E8 ?$(C4"(B) ; KS0-C-3422
(ucs-set-char #xB1E9 ?$(C4#(B) ; KS0-C-3423
(ucs-set-char #xB1EC ?$(C4$(B) ; KS0-C-3424
(ucs-set-char #xB1F0 ?$(C4%(B) ; KS0-C-3425
(ucs-set-char #xB1F9 ?$(C4&(B) ; KS0-C-3426
(ucs-set-char #xB1FB ?$(C4'(B) ; KS0-C-3427
(ucs-set-char #xB1FD ?$(C4((B) ; KS0-C-3428
(ucs-set-char #xB204 ?$(C4)(B) ; KS0-C-3429
(ucs-set-char #xB205 ?$(C4*(B) ; KS0-C-342A
(ucs-set-char #xB208 ?$(C4+(B) ; KS0-C-342B
(ucs-set-char #xB20B ?$(C4,(B) ; KS0-C-342C
(ucs-set-char #xB20C ?$(C4-(B) ; KS0-C-342D
(ucs-set-char #xB214 ?$(C4.(B) ; KS0-C-342E
(ucs-set-char #xB215 ?$(C4/(B) ; KS0-C-342F
(ucs-set-char #xB217 ?$(C40(B) ; KS0-C-3430
(ucs-set-char #xB219 ?$(C41(B) ; KS0-C-3431
(ucs-set-char #xB220 ?$(C42(B) ; KS0-C-3432
(ucs-set-char #xB234 ?$(C43(B) ; KS0-C-3433
(ucs-set-char #xB23C ?$(C44(B) ; KS0-C-3434
(ucs-set-char #xB258 ?$(C45(B) ; KS0-C-3435
(ucs-set-char #xB25C ?$(C46(B) ; KS0-C-3436
(ucs-set-char #xB260 ?$(C47(B) ; KS0-C-3437
(ucs-set-char #xB268 ?$(C48(B) ; KS0-C-3438
(ucs-set-char #xB269 ?$(C49(B) ; KS0-C-3439
(ucs-set-char #xB274 ?$(C4:(B) ; KS0-C-343A
(ucs-set-char #xB275 ?$(C4;(B) ; KS0-C-343B
(ucs-set-char #xB27C ?$(C4<(B) ; KS0-C-343C
(ucs-set-char #xB284 ?$(C4=(B) ; KS0-C-343D
(ucs-set-char #xB285 ?$(C4>(B) ; KS0-C-343E
(ucs-set-char #xB289 ?$(C4?(B) ; KS0-C-343F
(ucs-set-char #xB290 ?$(C4@(B) ; KS0-C-3440
(ucs-set-char #xB291 ?$(C4A(B) ; KS0-C-3441
(ucs-set-char #xB294 ?$(C4B(B) ; KS0-C-3442
(ucs-set-char #xB298 ?$(C4C(B) ; KS0-C-3443
(ucs-set-char #xB299 ?$(C4D(B) ; KS0-C-3444
(ucs-set-char #xB29A ?$(C4E(B) ; KS0-C-3445
(ucs-set-char #xB2A0 ?$(C4F(B) ; KS0-C-3446
(ucs-set-char #xB2A1 ?$(C4G(B) ; KS0-C-3447
(ucs-set-char #xB2A3 ?$(C4H(B) ; KS0-C-3448
(ucs-set-char #xB2A5 ?$(C4I(B) ; KS0-C-3449
(ucs-set-char #xB2A6 ?$(C4J(B) ; KS0-C-344A
(ucs-set-char #xB2AA ?$(C4K(B) ; KS0-C-344B
(ucs-set-char #xB2AC ?$(C4L(B) ; KS0-C-344C
(ucs-set-char #xB2B0 ?$(C4M(B) ; KS0-C-344D
(ucs-set-char #xB2B4 ?$(C4N(B) ; KS0-C-344E
(ucs-set-char #xB2C8 ?$(C4O(B) ; KS0-C-344F
(ucs-set-char #xB2C9 ?$(C4P(B) ; KS0-C-3450
(ucs-set-char #xB2CC ?$(C4Q(B) ; KS0-C-3451
(ucs-set-char #xB2D0 ?$(C4R(B) ; KS0-C-3452
(ucs-set-char #xB2D2 ?$(C4S(B) ; KS0-C-3453
(ucs-set-char #xB2D8 ?$(C4T(B) ; KS0-C-3454
(ucs-set-char #xB2D9 ?$(C4U(B) ; KS0-C-3455
(ucs-set-char #xB2DB ?$(C4V(B) ; KS0-C-3456
(ucs-set-char #xB2DD ?$(C4W(B) ; KS0-C-3457
(ucs-set-char #xB2E2 ?$(C4X(B) ; KS0-C-3458
(ucs-set-char #xB2E4 ?$(C4Y(B) ; KS0-C-3459
(ucs-set-char #xB2E5 ?$(C4Z(B) ; KS0-C-345A
(ucs-set-char #xB2E6 ?$(C4[(B) ; KS0-C-345B
(ucs-set-char #xB2E8 ?$(C4\(B) ; KS0-C-345C
(ucs-set-char #xB2EB ?$(C4](B) ; KS0-C-345D
(ucs-set-char #xB2EC ?$(C4^(B) ; KS0-C-345E
(ucs-set-char #xB2ED ?$(C4_(B) ; KS0-C-345F
(ucs-set-char #xB2EE ?$(C4`(B) ; KS0-C-3460
(ucs-set-char #xB2EF ?$(C4a(B) ; KS0-C-3461
(ucs-set-char #xB2F3 ?$(C4b(B) ; KS0-C-3462
(ucs-set-char #xB2F4 ?$(C4c(B) ; KS0-C-3463
(ucs-set-char #xB2F5 ?$(C4d(B) ; KS0-C-3464
(ucs-set-char #xB2F7 ?$(C4e(B) ; KS0-C-3465
(ucs-set-char #xB2F8 ?$(C4f(B) ; KS0-C-3466
(ucs-set-char #xB2F9 ?$(C4g(B) ; KS0-C-3467
(ucs-set-char #xB2FA ?$(C4h(B) ; KS0-C-3468
(ucs-set-char #xB2FB ?$(C4i(B) ; KS0-C-3469
(ucs-set-char #xB2FF ?$(C4j(B) ; KS0-C-346A
(ucs-set-char #xB300 ?$(C4k(B) ; KS0-C-346B
(ucs-set-char #xB301 ?$(C4l(B) ; KS0-C-346C
(ucs-set-char #xB304 ?$(C4m(B) ; KS0-C-346D
(ucs-set-char #xB308 ?$(C4n(B) ; KS0-C-346E
(ucs-set-char #xB310 ?$(C4o(B) ; KS0-C-346F
(ucs-set-char #xB311 ?$(C4p(B) ; KS0-C-3470
(ucs-set-char #xB313 ?$(C4q(B) ; KS0-C-3471
(ucs-set-char #xB314 ?$(C4r(B) ; KS0-C-3472
(ucs-set-char #xB315 ?$(C4s(B) ; KS0-C-3473
(ucs-set-char #xB31C ?$(C4t(B) ; KS0-C-3474
(ucs-set-char #xB354 ?$(C4u(B) ; KS0-C-3475
(ucs-set-char #xB355 ?$(C4v(B) ; KS0-C-3476
(ucs-set-char #xB356 ?$(C4w(B) ; KS0-C-3477
(ucs-set-char #xB358 ?$(C4x(B) ; KS0-C-3478
(ucs-set-char #xB35B ?$(C4y(B) ; KS0-C-3479
(ucs-set-char #xB35C ?$(C4z(B) ; KS0-C-347A
(ucs-set-char #xB35E ?$(C4{(B) ; KS0-C-347B
(ucs-set-char #xB35F ?$(C4|(B) ; KS0-C-347C
(ucs-set-char #xB364 ?$(C4}(B) ; KS0-C-347D
(ucs-set-char #xB365 ?$(C4~(B) ; KS0-C-347E
(ucs-set-char #xB367 ?$(C5!(B) ; KS0-C-3521
(ucs-set-char #xB369 ?$(C5"(B) ; KS0-C-3522
(ucs-set-char #xB36B ?$(C5#(B) ; KS0-C-3523
(ucs-set-char #xB36E ?$(C5$(B) ; KS0-C-3524
(ucs-set-char #xB370 ?$(C5%(B) ; KS0-C-3525
(ucs-set-char #xB371 ?$(C5&(B) ; KS0-C-3526
(ucs-set-char #xB374 ?$(C5'(B) ; KS0-C-3527
(ucs-set-char #xB378 ?$(C5((B) ; KS0-C-3528
(ucs-set-char #xB380 ?$(C5)(B) ; KS0-C-3529
(ucs-set-char #xB381 ?$(C5*(B) ; KS0-C-352A
(ucs-set-char #xB383 ?$(C5+(B) ; KS0-C-352B
(ucs-set-char #xB384 ?$(C5,(B) ; KS0-C-352C
(ucs-set-char #xB385 ?$(C5-(B) ; KS0-C-352D
(ucs-set-char #xB38C ?$(C5.(B) ; KS0-C-352E
(ucs-set-char #xB390 ?$(C5/(B) ; KS0-C-352F
(ucs-set-char #xB394 ?$(C50(B) ; KS0-C-3530
(ucs-set-char #xB3A0 ?$(C51(B) ; KS0-C-3531
(ucs-set-char #xB3A1 ?$(C52(B) ; KS0-C-3532
(ucs-set-char #xB3A8 ?$(C53(B) ; KS0-C-3533
(ucs-set-char #xB3AC ?$(C54(B) ; KS0-C-3534
(ucs-set-char #xB3C4 ?$(C55(B) ; KS0-C-3535
(ucs-set-char #xB3C5 ?$(C56(B) ; KS0-C-3536
(ucs-set-char #xB3C8 ?$(C57(B) ; KS0-C-3537
(ucs-set-char #xB3CB ?$(C58(B) ; KS0-C-3538
(ucs-set-char #xB3CC ?$(C59(B) ; KS0-C-3539
(ucs-set-char #xB3CE ?$(C5:(B) ; KS0-C-353A
(ucs-set-char #xB3D0 ?$(C5;(B) ; KS0-C-353B
(ucs-set-char #xB3D4 ?$(C5<(B) ; KS0-C-353C
(ucs-set-char #xB3D5 ?$(C5=(B) ; KS0-C-353D
(ucs-set-char #xB3D7 ?$(C5>(B) ; KS0-C-353E
(ucs-set-char #xB3D9 ?$(C5?(B) ; KS0-C-353F
(ucs-set-char #xB3DB ?$(C5@(B) ; KS0-C-3540
(ucs-set-char #xB3DD ?$(C5A(B) ; KS0-C-3541
(ucs-set-char #xB3E0 ?$(C5B(B) ; KS0-C-3542
(ucs-set-char #xB3E4 ?$(C5C(B) ; KS0-C-3543
(ucs-set-char #xB3E8 ?$(C5D(B) ; KS0-C-3544
(ucs-set-char #xB3FC ?$(C5E(B) ; KS0-C-3545
(ucs-set-char #xB410 ?$(C5F(B) ; KS0-C-3546
(ucs-set-char #xB418 ?$(C5G(B) ; KS0-C-3547
(ucs-set-char #xB41C ?$(C5H(B) ; KS0-C-3548
(ucs-set-char #xB420 ?$(C5I(B) ; KS0-C-3549
(ucs-set-char #xB428 ?$(C5J(B) ; KS0-C-354A
(ucs-set-char #xB429 ?$(C5K(B) ; KS0-C-354B
(ucs-set-char #xB42B ?$(C5L(B) ; KS0-C-354C
(ucs-set-char #xB434 ?$(C5M(B) ; KS0-C-354D
(ucs-set-char #xB450 ?$(C5N(B) ; KS0-C-354E
(ucs-set-char #xB451 ?$(C5O(B) ; KS0-C-354F
(ucs-set-char #xB454 ?$(C5P(B) ; KS0-C-3550
(ucs-set-char #xB458 ?$(C5Q(B) ; KS0-C-3551
(ucs-set-char #xB460 ?$(C5R(B) ; KS0-C-3552
(ucs-set-char #xB461 ?$(C5S(B) ; KS0-C-3553
(ucs-set-char #xB463 ?$(C5T(B) ; KS0-C-3554
(ucs-set-char #xB465 ?$(C5U(B) ; KS0-C-3555
(ucs-set-char #xB46C ?$(C5V(B) ; KS0-C-3556
(ucs-set-char #xB480 ?$(C5W(B) ; KS0-C-3557
(ucs-set-char #xB488 ?$(C5X(B) ; KS0-C-3558
(ucs-set-char #xB49D ?$(C5Y(B) ; KS0-C-3559
(ucs-set-char #xB4A4 ?$(C5Z(B) ; KS0-C-355A
(ucs-set-char #xB4A8 ?$(C5[(B) ; KS0-C-355B
(ucs-set-char #xB4AC ?$(C5\(B) ; KS0-C-355C
(ucs-set-char #xB4B5 ?$(C5](B) ; KS0-C-355D
(ucs-set-char #xB4B7 ?$(C5^(B) ; KS0-C-355E
(ucs-set-char #xB4B9 ?$(C5_(B) ; KS0-C-355F
(ucs-set-char #xB4C0 ?$(C5`(B) ; KS0-C-3560
(ucs-set-char #xB4C4 ?$(C5a(B) ; KS0-C-3561
(ucs-set-char #xB4C8 ?$(C5b(B) ; KS0-C-3562
(ucs-set-char #xB4D0 ?$(C5c(B) ; KS0-C-3563
(ucs-set-char #xB4D5 ?$(C5d(B) ; KS0-C-3564
(ucs-set-char #xB4DC ?$(C5e(B) ; KS0-C-3565
(ucs-set-char #xB4DD ?$(C5f(B) ; KS0-C-3566
(ucs-set-char #xB4E0 ?$(C5g(B) ; KS0-C-3567
(ucs-set-char #xB4E3 ?$(C5h(B) ; KS0-C-3568
(ucs-set-char #xB4E4 ?$(C5i(B) ; KS0-C-3569
(ucs-set-char #xB4E6 ?$(C5j(B) ; KS0-C-356A
(ucs-set-char #xB4EC ?$(C5k(B) ; KS0-C-356B
(ucs-set-char #xB4ED ?$(C5l(B) ; KS0-C-356C
(ucs-set-char #xB4EF ?$(C5m(B) ; KS0-C-356D
(ucs-set-char #xB4F1 ?$(C5n(B) ; KS0-C-356E
(ucs-set-char #xB4F8 ?$(C5o(B) ; KS0-C-356F
(ucs-set-char #xB514 ?$(C5p(B) ; KS0-C-3570
(ucs-set-char #xB515 ?$(C5q(B) ; KS0-C-3571
(ucs-set-char #xB518 ?$(C5r(B) ; KS0-C-3572
(ucs-set-char #xB51B ?$(C5s(B) ; KS0-C-3573
(ucs-set-char #xB51C ?$(C5t(B) ; KS0-C-3574
(ucs-set-char #xB524 ?$(C5u(B) ; KS0-C-3575
(ucs-set-char #xB525 ?$(C5v(B) ; KS0-C-3576
(ucs-set-char #xB527 ?$(C5w(B) ; KS0-C-3577
(ucs-set-char #xB528 ?$(C5x(B) ; KS0-C-3578
(ucs-set-char #xB529 ?$(C5y(B) ; KS0-C-3579
(ucs-set-char #xB52A ?$(C5z(B) ; KS0-C-357A
(ucs-set-char #xB530 ?$(C5{(B) ; KS0-C-357B
(ucs-set-char #xB531 ?$(C5|(B) ; KS0-C-357C
(ucs-set-char #xB534 ?$(C5}(B) ; KS0-C-357D
(ucs-set-char #xB538 ?$(C5~(B) ; KS0-C-357E
(ucs-set-char #xB540 ?$(C6!(B) ; KS0-C-3621
(ucs-set-char #xB541 ?$(C6"(B) ; KS0-C-3622
(ucs-set-char #xB543 ?$(C6#(B) ; KS0-C-3623
(ucs-set-char #xB544 ?$(C6$(B) ; KS0-C-3624
(ucs-set-char #xB545 ?$(C6%(B) ; KS0-C-3625
(ucs-set-char #xB54B ?$(C6&(B) ; KS0-C-3626
(ucs-set-char #xB54C ?$(C6'(B) ; KS0-C-3627
(ucs-set-char #xB54D ?$(C6((B) ; KS0-C-3628
(ucs-set-char #xB550 ?$(C6)(B) ; KS0-C-3629
(ucs-set-char #xB554 ?$(C6*(B) ; KS0-C-362A
(ucs-set-char #xB55C ?$(C6+(B) ; KS0-C-362B
(ucs-set-char #xB55D ?$(C6,(B) ; KS0-C-362C
(ucs-set-char #xB55F ?$(C6-(B) ; KS0-C-362D
(ucs-set-char #xB560 ?$(C6.(B) ; KS0-C-362E
(ucs-set-char #xB561 ?$(C6/(B) ; KS0-C-362F
(ucs-set-char #xB5A0 ?$(C60(B) ; KS0-C-3630
(ucs-set-char #xB5A1 ?$(C61(B) ; KS0-C-3631
(ucs-set-char #xB5A4 ?$(C62(B) ; KS0-C-3632
(ucs-set-char #xB5A8 ?$(C63(B) ; KS0-C-3633
(ucs-set-char #xB5AA ?$(C64(B) ; KS0-C-3634
(ucs-set-char #xB5AB ?$(C65(B) ; KS0-C-3635
(ucs-set-char #xB5B0 ?$(C66(B) ; KS0-C-3636
(ucs-set-char #xB5B1 ?$(C67(B) ; KS0-C-3637
(ucs-set-char #xB5B3 ?$(C68(B) ; KS0-C-3638
(ucs-set-char #xB5B4 ?$(C69(B) ; KS0-C-3639
(ucs-set-char #xB5B5 ?$(C6:(B) ; KS0-C-363A
(ucs-set-char #xB5BB ?$(C6;(B) ; KS0-C-363B
(ucs-set-char #xB5BC ?$(C6<(B) ; KS0-C-363C
(ucs-set-char #xB5BD ?$(C6=(B) ; KS0-C-363D
(ucs-set-char #xB5C0 ?$(C6>(B) ; KS0-C-363E
(ucs-set-char #xB5C4 ?$(C6?(B) ; KS0-C-363F
(ucs-set-char #xB5CC ?$(C6@(B) ; KS0-C-3640
(ucs-set-char #xB5CD ?$(C6A(B) ; KS0-C-3641
(ucs-set-char #xB5CF ?$(C6B(B) ; KS0-C-3642
(ucs-set-char #xB5D0 ?$(C6C(B) ; KS0-C-3643
(ucs-set-char #xB5D1 ?$(C6D(B) ; KS0-C-3644
(ucs-set-char #xB5D8 ?$(C6E(B) ; KS0-C-3645
(ucs-set-char #xB5EC ?$(C6F(B) ; KS0-C-3646
(ucs-set-char #xB610 ?$(C6G(B) ; KS0-C-3647
(ucs-set-char #xB611 ?$(C6H(B) ; KS0-C-3648
(ucs-set-char #xB614 ?$(C6I(B) ; KS0-C-3649
(ucs-set-char #xB618 ?$(C6J(B) ; KS0-C-364A
(ucs-set-char #xB625 ?$(C6K(B) ; KS0-C-364B
(ucs-set-char #xB62C ?$(C6L(B) ; KS0-C-364C
(ucs-set-char #xB634 ?$(C6M(B) ; KS0-C-364D
(ucs-set-char #xB648 ?$(C6N(B) ; KS0-C-364E
(ucs-set-char #xB664 ?$(C6O(B) ; KS0-C-364F
(ucs-set-char #xB668 ?$(C6P(B) ; KS0-C-3650
(ucs-set-char #xB69C ?$(C6Q(B) ; KS0-C-3651
(ucs-set-char #xB69D ?$(C6R(B) ; KS0-C-3652
(ucs-set-char #xB6A0 ?$(C6S(B) ; KS0-C-3653
(ucs-set-char #xB6A4 ?$(C6T(B) ; KS0-C-3654
(ucs-set-char #xB6AB ?$(C6U(B) ; KS0-C-3655
(ucs-set-char #xB6AC ?$(C6V(B) ; KS0-C-3656
(ucs-set-char #xB6B1 ?$(C6W(B) ; KS0-C-3657
(ucs-set-char #xB6D4 ?$(C6X(B) ; KS0-C-3658
(ucs-set-char #xB6F0 ?$(C6Y(B) ; KS0-C-3659
(ucs-set-char #xB6F4 ?$(C6Z(B) ; KS0-C-365A
(ucs-set-char #xB6F8 ?$(C6[(B) ; KS0-C-365B
(ucs-set-char #xB700 ?$(C6\(B) ; KS0-C-365C
(ucs-set-char #xB701 ?$(C6](B) ; KS0-C-365D
(ucs-set-char #xB705 ?$(C6^(B) ; KS0-C-365E
(ucs-set-char #xB728 ?$(C6_(B) ; KS0-C-365F
(ucs-set-char #xB729 ?$(C6`(B) ; KS0-C-3660
(ucs-set-char #xB72C ?$(C6a(B) ; KS0-C-3661
(ucs-set-char #xB72F ?$(C6b(B) ; KS0-C-3662
(ucs-set-char #xB730 ?$(C6c(B) ; KS0-C-3663
(ucs-set-char #xB738 ?$(C6d(B) ; KS0-C-3664
(ucs-set-char #xB739 ?$(C6e(B) ; KS0-C-3665
(ucs-set-char #xB73B ?$(C6f(B) ; KS0-C-3666
(ucs-set-char #xB744 ?$(C6g(B) ; KS0-C-3667
(ucs-set-char #xB748 ?$(C6h(B) ; KS0-C-3668
(ucs-set-char #xB74C ?$(C6i(B) ; KS0-C-3669
(ucs-set-char #xB754 ?$(C6j(B) ; KS0-C-366A
(ucs-set-char #xB755 ?$(C6k(B) ; KS0-C-366B
(ucs-set-char #xB760 ?$(C6l(B) ; KS0-C-366C
(ucs-set-char #xB764 ?$(C6m(B) ; KS0-C-366D
(ucs-set-char #xB768 ?$(C6n(B) ; KS0-C-366E
(ucs-set-char #xB770 ?$(C6o(B) ; KS0-C-366F
(ucs-set-char #xB771 ?$(C6p(B) ; KS0-C-3670
(ucs-set-char #xB773 ?$(C6q(B) ; KS0-C-3671
(ucs-set-char #xB775 ?$(C6r(B) ; KS0-C-3672
(ucs-set-char #xB77C ?$(C6s(B) ; KS0-C-3673
(ucs-set-char #xB77D ?$(C6t(B) ; KS0-C-3674
(ucs-set-char #xB780 ?$(C6u(B) ; KS0-C-3675
(ucs-set-char #xB784 ?$(C6v(B) ; KS0-C-3676
(ucs-set-char #xB78C ?$(C6w(B) ; KS0-C-3677
(ucs-set-char #xB78D ?$(C6x(B) ; KS0-C-3678
(ucs-set-char #xB78F ?$(C6y(B) ; KS0-C-3679
(ucs-set-char #xB790 ?$(C6z(B) ; KS0-C-367A
(ucs-set-char #xB791 ?$(C6{(B) ; KS0-C-367B
(ucs-set-char #xB792 ?$(C6|(B) ; KS0-C-367C
(ucs-set-char #xB796 ?$(C6}(B) ; KS0-C-367D
(ucs-set-char #xB797 ?$(C6~(B) ; KS0-C-367E
(ucs-set-char #xB798 ?$(C7!(B) ; KS0-C-3721
(ucs-set-char #xB799 ?$(C7"(B) ; KS0-C-3722
(ucs-set-char #xB79C ?$(C7#(B) ; KS0-C-3723
(ucs-set-char #xB7A0 ?$(C7$(B) ; KS0-C-3724
(ucs-set-char #xB7A8 ?$(C7%(B) ; KS0-C-3725
(ucs-set-char #xB7A9 ?$(C7&(B) ; KS0-C-3726
(ucs-set-char #xB7AB ?$(C7'(B) ; KS0-C-3727
(ucs-set-char #xB7AC ?$(C7((B) ; KS0-C-3728
(ucs-set-char #xB7AD ?$(C7)(B) ; KS0-C-3729
(ucs-set-char #xB7B4 ?$(C7*(B) ; KS0-C-372A
(ucs-set-char #xB7B5 ?$(C7+(B) ; KS0-C-372B
(ucs-set-char #xB7B8 ?$(C7,(B) ; KS0-C-372C
(ucs-set-char #xB7C7 ?$(C7-(B) ; KS0-C-372D
(ucs-set-char #xB7C9 ?$(C7.(B) ; KS0-C-372E
(ucs-set-char #xB7EC ?$(C7/(B) ; KS0-C-372F
(ucs-set-char #xB7ED ?$(C70(B) ; KS0-C-3730
(ucs-set-char #xB7F0 ?$(C71(B) ; KS0-C-3731
(ucs-set-char #xB7F4 ?$(C72(B) ; KS0-C-3732
(ucs-set-char #xB7FC ?$(C73(B) ; KS0-C-3733
(ucs-set-char #xB7FD ?$(C74(B) ; KS0-C-3734
(ucs-set-char #xB7FF ?$(C75(B) ; KS0-C-3735
(ucs-set-char #xB800 ?$(C76(B) ; KS0-C-3736
(ucs-set-char #xB801 ?$(C77(B) ; KS0-C-3737
(ucs-set-char #xB807 ?$(C78(B) ; KS0-C-3738
(ucs-set-char #xB808 ?$(C79(B) ; KS0-C-3739
(ucs-set-char #xB809 ?$(C7:(B) ; KS0-C-373A
(ucs-set-char #xB80C ?$(C7;(B) ; KS0-C-373B
(ucs-set-char #xB810 ?$(C7<(B) ; KS0-C-373C
(ucs-set-char #xB818 ?$(C7=(B) ; KS0-C-373D
(ucs-set-char #xB819 ?$(C7>(B) ; KS0-C-373E
(ucs-set-char #xB81B ?$(C7?(B) ; KS0-C-373F
(ucs-set-char #xB81D ?$(C7@(B) ; KS0-C-3740
(ucs-set-char #xB824 ?$(C7A(B) ; KS0-C-3741
(ucs-set-char #xB825 ?$(C7B(B) ; KS0-C-3742
(ucs-set-char #xB828 ?$(C7C(B) ; KS0-C-3743
(ucs-set-char #xB82C ?$(C7D(B) ; KS0-C-3744
(ucs-set-char #xB834 ?$(C7E(B) ; KS0-C-3745
(ucs-set-char #xB835 ?$(C7F(B) ; KS0-C-3746
(ucs-set-char #xB837 ?$(C7G(B) ; KS0-C-3747
(ucs-set-char #xB838 ?$(C7H(B) ; KS0-C-3748
(ucs-set-char #xB839 ?$(C7I(B) ; KS0-C-3749
(ucs-set-char #xB840 ?$(C7J(B) ; KS0-C-374A
(ucs-set-char #xB844 ?$(C7K(B) ; KS0-C-374B
(ucs-set-char #xB851 ?$(C7L(B) ; KS0-C-374C
(ucs-set-char #xB853 ?$(C7M(B) ; KS0-C-374D
(ucs-set-char #xB85C ?$(C7N(B) ; KS0-C-374E
(ucs-set-char #xB85D ?$(C7O(B) ; KS0-C-374F
(ucs-set-char #xB860 ?$(C7P(B) ; KS0-C-3750
(ucs-set-char #xB864 ?$(C7Q(B) ; KS0-C-3751
(ucs-set-char #xB86C ?$(C7R(B) ; KS0-C-3752
(ucs-set-char #xB86D ?$(C7S(B) ; KS0-C-3753
(ucs-set-char #xB86F ?$(C7T(B) ; KS0-C-3754
(ucs-set-char #xB871 ?$(C7U(B) ; KS0-C-3755
(ucs-set-char #xB878 ?$(C7V(B) ; KS0-C-3756
(ucs-set-char #xB87C ?$(C7W(B) ; KS0-C-3757
(ucs-set-char #xB88D ?$(C7X(B) ; KS0-C-3758
(ucs-set-char #xB8A8 ?$(C7Y(B) ; KS0-C-3759
(ucs-set-char #xB8B0 ?$(C7Z(B) ; KS0-C-375A
(ucs-set-char #xB8B4 ?$(C7[(B) ; KS0-C-375B
(ucs-set-char #xB8B8 ?$(C7\(B) ; KS0-C-375C
(ucs-set-char #xB8C0 ?$(C7](B) ; KS0-C-375D
(ucs-set-char #xB8C1 ?$(C7^(B) ; KS0-C-375E
(ucs-set-char #xB8C3 ?$(C7_(B) ; KS0-C-375F
(ucs-set-char #xB8C5 ?$(C7`(B) ; KS0-C-3760
(ucs-set-char #xB8CC ?$(C7a(B) ; KS0-C-3761
(ucs-set-char #xB8D0 ?$(C7b(B) ; KS0-C-3762
(ucs-set-char #xB8D4 ?$(C7c(B) ; KS0-C-3763
(ucs-set-char #xB8DD ?$(C7d(B) ; KS0-C-3764
(ucs-set-char #xB8DF ?$(C7e(B) ; KS0-C-3765
(ucs-set-char #xB8E1 ?$(C7f(B) ; KS0-C-3766
(ucs-set-char #xB8E8 ?$(C7g(B) ; KS0-C-3767
(ucs-set-char #xB8E9 ?$(C7h(B) ; KS0-C-3768
(ucs-set-char #xB8EC ?$(C7i(B) ; KS0-C-3769
(ucs-set-char #xB8F0 ?$(C7j(B) ; KS0-C-376A
(ucs-set-char #xB8F8 ?$(C7k(B) ; KS0-C-376B
(ucs-set-char #xB8F9 ?$(C7l(B) ; KS0-C-376C
(ucs-set-char #xB8FB ?$(C7m(B) ; KS0-C-376D
(ucs-set-char #xB8FD ?$(C7n(B) ; KS0-C-376E
(ucs-set-char #xB904 ?$(C7o(B) ; KS0-C-376F
(ucs-set-char #xB918 ?$(C7p(B) ; KS0-C-3770
(ucs-set-char #xB920 ?$(C7q(B) ; KS0-C-3771
(ucs-set-char #xB93C ?$(C7r(B) ; KS0-C-3772
(ucs-set-char #xB93D ?$(C7s(B) ; KS0-C-3773
(ucs-set-char #xB940 ?$(C7t(B) ; KS0-C-3774
(ucs-set-char #xB944 ?$(C7u(B) ; KS0-C-3775
(ucs-set-char #xB94C ?$(C7v(B) ; KS0-C-3776
(ucs-set-char #xB94F ?$(C7w(B) ; KS0-C-3777
(ucs-set-char #xB951 ?$(C7x(B) ; KS0-C-3778
(ucs-set-char #xB958 ?$(C7y(B) ; KS0-C-3779
(ucs-set-char #xB959 ?$(C7z(B) ; KS0-C-377A
(ucs-set-char #xB95C ?$(C7{(B) ; KS0-C-377B
(ucs-set-char #xB960 ?$(C7|(B) ; KS0-C-377C
(ucs-set-char #xB968 ?$(C7}(B) ; KS0-C-377D
(ucs-set-char #xB969 ?$(C7~(B) ; KS0-C-377E
(ucs-set-char #xB96B ?$(C8!(B) ; KS0-C-3821
(ucs-set-char #xB96D ?$(C8"(B) ; KS0-C-3822
(ucs-set-char #xB974 ?$(C8#(B) ; KS0-C-3823
(ucs-set-char #xB975 ?$(C8$(B) ; KS0-C-3824
(ucs-set-char #xB978 ?$(C8%(B) ; KS0-C-3825
(ucs-set-char #xB97C ?$(C8&(B) ; KS0-C-3826
(ucs-set-char #xB984 ?$(C8'(B) ; KS0-C-3827
(ucs-set-char #xB985 ?$(C8((B) ; KS0-C-3828
(ucs-set-char #xB987 ?$(C8)(B) ; KS0-C-3829
(ucs-set-char #xB989 ?$(C8*(B) ; KS0-C-382A
(ucs-set-char #xB98A ?$(C8+(B) ; KS0-C-382B
(ucs-set-char #xB98D ?$(C8,(B) ; KS0-C-382C
(ucs-set-char #xB98E ?$(C8-(B) ; KS0-C-382D
(ucs-set-char #xB9AC ?$(C8.(B) ; KS0-C-382E
(ucs-set-char #xB9AD ?$(C8/(B) ; KS0-C-382F
(ucs-set-char #xB9B0 ?$(C80(B) ; KS0-C-3830
(ucs-set-char #xB9B4 ?$(C81(B) ; KS0-C-3831
(ucs-set-char #xB9BC ?$(C82(B) ; KS0-C-3832
(ucs-set-char #xB9BD ?$(C83(B) ; KS0-C-3833
(ucs-set-char #xB9BF ?$(C84(B) ; KS0-C-3834
(ucs-set-char #xB9C1 ?$(C85(B) ; KS0-C-3835
(ucs-set-char #xB9C8 ?$(C86(B) ; KS0-C-3836
(ucs-set-char #xB9C9 ?$(C87(B) ; KS0-C-3837
(ucs-set-char #xB9CC ?$(C88(B) ; KS0-C-3838
(ucs-set-char #xB9CE ?$(C89(B) ; KS0-C-3839
(ucs-set-char #xB9CF ?$(C8:(B) ; KS0-C-383A
(ucs-set-char #xB9D0 ?$(C8;(B) ; KS0-C-383B
(ucs-set-char #xB9D1 ?$(C8<(B) ; KS0-C-383C
(ucs-set-char #xB9D2 ?$(C8=(B) ; KS0-C-383D
(ucs-set-char #xB9D8 ?$(C8>(B) ; KS0-C-383E
(ucs-set-char #xB9D9 ?$(C8?(B) ; KS0-C-383F
(ucs-set-char #xB9DB ?$(C8@(B) ; KS0-C-3840
(ucs-set-char #xB9DD ?$(C8A(B) ; KS0-C-3841
(ucs-set-char #xB9DE ?$(C8B(B) ; KS0-C-3842
(ucs-set-char #xB9E1 ?$(C8C(B) ; KS0-C-3843
(ucs-set-char #xB9E3 ?$(C8D(B) ; KS0-C-3844
(ucs-set-char #xB9E4 ?$(C8E(B) ; KS0-C-3845
(ucs-set-char #xB9E5 ?$(C8F(B) ; KS0-C-3846
(ucs-set-char #xB9E8 ?$(C8G(B) ; KS0-C-3847
(ucs-set-char #xB9EC ?$(C8H(B) ; KS0-C-3848
(ucs-set-char #xB9F4 ?$(C8I(B) ; KS0-C-3849
(ucs-set-char #xB9F5 ?$(C8J(B) ; KS0-C-384A
(ucs-set-char #xB9F7 ?$(C8K(B) ; KS0-C-384B
(ucs-set-char #xB9F8 ?$(C8L(B) ; KS0-C-384C
(ucs-set-char #xB9F9 ?$(C8M(B) ; KS0-C-384D
(ucs-set-char #xB9FA ?$(C8N(B) ; KS0-C-384E
(ucs-set-char #xBA00 ?$(C8O(B) ; KS0-C-384F
(ucs-set-char #xBA01 ?$(C8P(B) ; KS0-C-3850
(ucs-set-char #xBA08 ?$(C8Q(B) ; KS0-C-3851
(ucs-set-char #xBA15 ?$(C8R(B) ; KS0-C-3852
(ucs-set-char #xBA38 ?$(C8S(B) ; KS0-C-3853
(ucs-set-char #xBA39 ?$(C8T(B) ; KS0-C-3854
(ucs-set-char #xBA3C ?$(C8U(B) ; KS0-C-3855
(ucs-set-char #xBA40 ?$(C8V(B) ; KS0-C-3856
(ucs-set-char #xBA42 ?$(C8W(B) ; KS0-C-3857
(ucs-set-char #xBA48 ?$(C8X(B) ; KS0-C-3858
(ucs-set-char #xBA49 ?$(C8Y(B) ; KS0-C-3859
(ucs-set-char #xBA4B ?$(C8Z(B) ; KS0-C-385A
(ucs-set-char #xBA4D ?$(C8[(B) ; KS0-C-385B
(ucs-set-char #xBA4E ?$(C8\(B) ; KS0-C-385C
(ucs-set-char #xBA53 ?$(C8](B) ; KS0-C-385D
(ucs-set-char #xBA54 ?$(C8^(B) ; KS0-C-385E
(ucs-set-char #xBA55 ?$(C8_(B) ; KS0-C-385F
(ucs-set-char #xBA58 ?$(C8`(B) ; KS0-C-3860
(ucs-set-char #xBA5C ?$(C8a(B) ; KS0-C-3861
(ucs-set-char #xBA64 ?$(C8b(B) ; KS0-C-3862
(ucs-set-char #xBA65 ?$(C8c(B) ; KS0-C-3863
(ucs-set-char #xBA67 ?$(C8d(B) ; KS0-C-3864
(ucs-set-char #xBA68 ?$(C8e(B) ; KS0-C-3865
(ucs-set-char #xBA69 ?$(C8f(B) ; KS0-C-3866
(ucs-set-char #xBA70 ?$(C8g(B) ; KS0-C-3867
(ucs-set-char #xBA71 ?$(C8h(B) ; KS0-C-3868
(ucs-set-char #xBA74 ?$(C8i(B) ; KS0-C-3869
(ucs-set-char #xBA78 ?$(C8j(B) ; KS0-C-386A
(ucs-set-char #xBA83 ?$(C8k(B) ; KS0-C-386B
(ucs-set-char #xBA84 ?$(C8l(B) ; KS0-C-386C
(ucs-set-char #xBA85 ?$(C8m(B) ; KS0-C-386D
(ucs-set-char #xBA87 ?$(C8n(B) ; KS0-C-386E
(ucs-set-char #xBA8C ?$(C8o(B) ; KS0-C-386F
(ucs-set-char #xBAA8 ?$(C8p(B) ; KS0-C-3870
(ucs-set-char #xBAA9 ?$(C8q(B) ; KS0-C-3871
(ucs-set-char #xBAAB ?$(C8r(B) ; KS0-C-3872
(ucs-set-char #xBAAC ?$(C8s(B) ; KS0-C-3873
(ucs-set-char #xBAB0 ?$(C8t(B) ; KS0-C-3874
(ucs-set-char #xBAB2 ?$(C8u(B) ; KS0-C-3875
(ucs-set-char #xBAB8 ?$(C8v(B) ; KS0-C-3876
(ucs-set-char #xBAB9 ?$(C8w(B) ; KS0-C-3877
(ucs-set-char #xBABB ?$(C8x(B) ; KS0-C-3878
(ucs-set-char #xBABD ?$(C8y(B) ; KS0-C-3879
(ucs-set-char #xBAC4 ?$(C8z(B) ; KS0-C-387A
(ucs-set-char #xBAC8 ?$(C8{(B) ; KS0-C-387B
(ucs-set-char #xBAD8 ?$(C8|(B) ; KS0-C-387C
(ucs-set-char #xBAD9 ?$(C8}(B) ; KS0-C-387D
(ucs-set-char #xBAFC ?$(C8~(B) ; KS0-C-387E
(ucs-set-char #xBB00 ?$(C9!(B) ; KS0-C-3921
(ucs-set-char #xBB04 ?$(C9"(B) ; KS0-C-3922
(ucs-set-char #xBB0D ?$(C9#(B) ; KS0-C-3923
(ucs-set-char #xBB0F ?$(C9$(B) ; KS0-C-3924
(ucs-set-char #xBB11 ?$(C9%(B) ; KS0-C-3925
(ucs-set-char #xBB18 ?$(C9&(B) ; KS0-C-3926
(ucs-set-char #xBB1C ?$(C9'(B) ; KS0-C-3927
(ucs-set-char #xBB20 ?$(C9((B) ; KS0-C-3928
(ucs-set-char #xBB29 ?$(C9)(B) ; KS0-C-3929
(ucs-set-char #xBB2B ?$(C9*(B) ; KS0-C-392A
(ucs-set-char #xBB34 ?$(C9+(B) ; KS0-C-392B
(ucs-set-char #xBB35 ?$(C9,(B) ; KS0-C-392C
(ucs-set-char #xBB36 ?$(C9-(B) ; KS0-C-392D
(ucs-set-char #xBB38 ?$(C9.(B) ; KS0-C-392E
(ucs-set-char #xBB3B ?$(C9/(B) ; KS0-C-392F
(ucs-set-char #xBB3C ?$(C90(B) ; KS0-C-3930
(ucs-set-char #xBB3D ?$(C91(B) ; KS0-C-3931
(ucs-set-char #xBB3E ?$(C92(B) ; KS0-C-3932
(ucs-set-char #xBB44 ?$(C93(B) ; KS0-C-3933
(ucs-set-char #xBB45 ?$(C94(B) ; KS0-C-3934
(ucs-set-char #xBB47 ?$(C95(B) ; KS0-C-3935
(ucs-set-char #xBB49 ?$(C96(B) ; KS0-C-3936
(ucs-set-char #xBB4D ?$(C97(B) ; KS0-C-3937
(ucs-set-char #xBB4F ?$(C98(B) ; KS0-C-3938
(ucs-set-char #xBB50 ?$(C99(B) ; KS0-C-3939
(ucs-set-char #xBB54 ?$(C9:(B) ; KS0-C-393A
(ucs-set-char #xBB58 ?$(C9;(B) ; KS0-C-393B
(ucs-set-char #xBB61 ?$(C9<(B) ; KS0-C-393C
(ucs-set-char #xBB63 ?$(C9=(B) ; KS0-C-393D
(ucs-set-char #xBB6C ?$(C9>(B) ; KS0-C-393E
(ucs-set-char #xBB88 ?$(C9?(B) ; KS0-C-393F
(ucs-set-char #xBB8C ?$(C9@(B) ; KS0-C-3940
(ucs-set-char #xBB90 ?$(C9A(B) ; KS0-C-3941
(ucs-set-char #xBBA4 ?$(C9B(B) ; KS0-C-3942
(ucs-set-char #xBBA8 ?$(C9C(B) ; KS0-C-3943
(ucs-set-char #xBBAC ?$(C9D(B) ; KS0-C-3944
(ucs-set-char #xBBB4 ?$(C9E(B) ; KS0-C-3945
(ucs-set-char #xBBB7 ?$(C9F(B) ; KS0-C-3946
(ucs-set-char #xBBC0 ?$(C9G(B) ; KS0-C-3947
(ucs-set-char #xBBC4 ?$(C9H(B) ; KS0-C-3948
(ucs-set-char #xBBC8 ?$(C9I(B) ; KS0-C-3949
(ucs-set-char #xBBD0 ?$(C9J(B) ; KS0-C-394A
(ucs-set-char #xBBD3 ?$(C9K(B) ; KS0-C-394B
(ucs-set-char #xBBF8 ?$(C9L(B) ; KS0-C-394C
(ucs-set-char #xBBF9 ?$(C9M(B) ; KS0-C-394D
(ucs-set-char #xBBFC ?$(C9N(B) ; KS0-C-394E
(ucs-set-char #xBBFF ?$(C9O(B) ; KS0-C-394F
(ucs-set-char #xBC00 ?$(C9P(B) ; KS0-C-3950
(ucs-set-char #xBC02 ?$(C9Q(B) ; KS0-C-3951
(ucs-set-char #xBC08 ?$(C9R(B) ; KS0-C-3952
(ucs-set-char #xBC09 ?$(C9S(B) ; KS0-C-3953
(ucs-set-char #xBC0B ?$(C9T(B) ; KS0-C-3954
(ucs-set-char #xBC0C ?$(C9U(B) ; KS0-C-3955
(ucs-set-char #xBC0D ?$(C9V(B) ; KS0-C-3956
(ucs-set-char #xBC0F ?$(C9W(B) ; KS0-C-3957
(ucs-set-char #xBC11 ?$(C9X(B) ; KS0-C-3958
(ucs-set-char #xBC14 ?$(C9Y(B) ; KS0-C-3959
(ucs-set-char #xBC15 ?$(C9Z(B) ; KS0-C-395A
(ucs-set-char #xBC16 ?$(C9[(B) ; KS0-C-395B
(ucs-set-char #xBC17 ?$(C9\(B) ; KS0-C-395C
(ucs-set-char #xBC18 ?$(C9](B) ; KS0-C-395D
(ucs-set-char #xBC1B ?$(C9^(B) ; KS0-C-395E
(ucs-set-char #xBC1C ?$(C9_(B) ; KS0-C-395F
(ucs-set-char #xBC1D ?$(C9`(B) ; KS0-C-3960
(ucs-set-char #xBC1E ?$(C9a(B) ; KS0-C-3961
(ucs-set-char #xBC1F ?$(C9b(B) ; KS0-C-3962
(ucs-set-char #xBC24 ?$(C9c(B) ; KS0-C-3963
(ucs-set-char #xBC25 ?$(C9d(B) ; KS0-C-3964
(ucs-set-char #xBC27 ?$(C9e(B) ; KS0-C-3965
(ucs-set-char #xBC29 ?$(C9f(B) ; KS0-C-3966
(ucs-set-char #xBC2D ?$(C9g(B) ; KS0-C-3967
(ucs-set-char #xBC30 ?$(C9h(B) ; KS0-C-3968
(ucs-set-char #xBC31 ?$(C9i(B) ; KS0-C-3969
(ucs-set-char #xBC34 ?$(C9j(B) ; KS0-C-396A
(ucs-set-char #xBC38 ?$(C9k(B) ; KS0-C-396B
(ucs-set-char #xBC40 ?$(C9l(B) ; KS0-C-396C
(ucs-set-char #xBC41 ?$(C9m(B) ; KS0-C-396D
(ucs-set-char #xBC43 ?$(C9n(B) ; KS0-C-396E
(ucs-set-char #xBC44 ?$(C9o(B) ; KS0-C-396F
(ucs-set-char #xBC45 ?$(C9p(B) ; KS0-C-3970
(ucs-set-char #xBC49 ?$(C9q(B) ; KS0-C-3971
(ucs-set-char #xBC4C ?$(C9r(B) ; KS0-C-3972
(ucs-set-char #xBC4D ?$(C9s(B) ; KS0-C-3973
(ucs-set-char #xBC50 ?$(C9t(B) ; KS0-C-3974
(ucs-set-char #xBC5D ?$(C9u(B) ; KS0-C-3975
(ucs-set-char #xBC84 ?$(C9v(B) ; KS0-C-3976
(ucs-set-char #xBC85 ?$(C9w(B) ; KS0-C-3977
(ucs-set-char #xBC88 ?$(C9x(B) ; KS0-C-3978
(ucs-set-char #xBC8B ?$(C9y(B) ; KS0-C-3979
(ucs-set-char #xBC8C ?$(C9z(B) ; KS0-C-397A
(ucs-set-char #xBC8E ?$(C9{(B) ; KS0-C-397B
(ucs-set-char #xBC94 ?$(C9|(B) ; KS0-C-397C
(ucs-set-char #xBC95 ?$(C9}(B) ; KS0-C-397D
(ucs-set-char #xBC97 ?$(C9~(B) ; KS0-C-397E
(ucs-set-char #xBC99 ?$(C:!(B) ; KS0-C-3A21
(ucs-set-char #xBC9A ?$(C:"(B) ; KS0-C-3A22
(ucs-set-char #xBCA0 ?$(C:#(B) ; KS0-C-3A23
(ucs-set-char #xBCA1 ?$(C:$(B) ; KS0-C-3A24
(ucs-set-char #xBCA4 ?$(C:%(B) ; KS0-C-3A25
(ucs-set-char #xBCA7 ?$(C:&(B) ; KS0-C-3A26
(ucs-set-char #xBCA8 ?$(C:'(B) ; KS0-C-3A27
(ucs-set-char #xBCB0 ?$(C:((B) ; KS0-C-3A28
(ucs-set-char #xBCB1 ?$(C:)(B) ; KS0-C-3A29
(ucs-set-char #xBCB3 ?$(C:*(B) ; KS0-C-3A2A
(ucs-set-char #xBCB4 ?$(C:+(B) ; KS0-C-3A2B
(ucs-set-char #xBCB5 ?$(C:,(B) ; KS0-C-3A2C
(ucs-set-char #xBCBC ?$(C:-(B) ; KS0-C-3A2D
(ucs-set-char #xBCBD ?$(C:.(B) ; KS0-C-3A2E
(ucs-set-char #xBCC0 ?$(C:/(B) ; KS0-C-3A2F
(ucs-set-char #xBCC4 ?$(C:0(B) ; KS0-C-3A30
(ucs-set-char #xBCCD ?$(C:1(B) ; KS0-C-3A31
(ucs-set-char #xBCCF ?$(C:2(B) ; KS0-C-3A32
(ucs-set-char #xBCD0 ?$(C:3(B) ; KS0-C-3A33
(ucs-set-char #xBCD1 ?$(C:4(B) ; KS0-C-3A34
(ucs-set-char #xBCD5 ?$(C:5(B) ; KS0-C-3A35
(ucs-set-char #xBCD8 ?$(C:6(B) ; KS0-C-3A36
(ucs-set-char #xBCDC ?$(C:7(B) ; KS0-C-3A37
(ucs-set-char #xBCF4 ?$(C:8(B) ; KS0-C-3A38
(ucs-set-char #xBCF5 ?$(C:9(B) ; KS0-C-3A39
(ucs-set-char #xBCF6 ?$(C::(B) ; KS0-C-3A3A
(ucs-set-char #xBCF8 ?$(C:;(B) ; KS0-C-3A3B
(ucs-set-char #xBCFC ?$(C:<(B) ; KS0-C-3A3C
(ucs-set-char #xBD04 ?$(C:=(B) ; KS0-C-3A3D
(ucs-set-char #xBD05 ?$(C:>(B) ; KS0-C-3A3E
(ucs-set-char #xBD07 ?$(C:?(B) ; KS0-C-3A3F
(ucs-set-char #xBD09 ?$(C:@(B) ; KS0-C-3A40
(ucs-set-char #xBD10 ?$(C:A(B) ; KS0-C-3A41
(ucs-set-char #xBD14 ?$(C:B(B) ; KS0-C-3A42
(ucs-set-char #xBD24 ?$(C:C(B) ; KS0-C-3A43
(ucs-set-char #xBD2C ?$(C:D(B) ; KS0-C-3A44
(ucs-set-char #xBD40 ?$(C:E(B) ; KS0-C-3A45
(ucs-set-char #xBD48 ?$(C:F(B) ; KS0-C-3A46
(ucs-set-char #xBD49 ?$(C:G(B) ; KS0-C-3A47
(ucs-set-char #xBD4C ?$(C:H(B) ; KS0-C-3A48
(ucs-set-char #xBD50 ?$(C:I(B) ; KS0-C-3A49
(ucs-set-char #xBD58 ?$(C:J(B) ; KS0-C-3A4A
(ucs-set-char #xBD59 ?$(C:K(B) ; KS0-C-3A4B
(ucs-set-char #xBD64 ?$(C:L(B) ; KS0-C-3A4C
(ucs-set-char #xBD68 ?$(C:M(B) ; KS0-C-3A4D
(ucs-set-char #xBD80 ?$(C:N(B) ; KS0-C-3A4E
(ucs-set-char #xBD81 ?$(C:O(B) ; KS0-C-3A4F
(ucs-set-char #xBD84 ?$(C:P(B) ; KS0-C-3A50
(ucs-set-char #xBD87 ?$(C:Q(B) ; KS0-C-3A51
(ucs-set-char #xBD88 ?$(C:R(B) ; KS0-C-3A52
(ucs-set-char #xBD89 ?$(C:S(B) ; KS0-C-3A53
(ucs-set-char #xBD8A ?$(C:T(B) ; KS0-C-3A54
(ucs-set-char #xBD90 ?$(C:U(B) ; KS0-C-3A55
(ucs-set-char #xBD91 ?$(C:V(B) ; KS0-C-3A56
(ucs-set-char #xBD93 ?$(C:W(B) ; KS0-C-3A57
(ucs-set-char #xBD95 ?$(C:X(B) ; KS0-C-3A58
(ucs-set-char #xBD99 ?$(C:Y(B) ; KS0-C-3A59
(ucs-set-char #xBD9A ?$(C:Z(B) ; KS0-C-3A5A
(ucs-set-char #xBD9C ?$(C:[(B) ; KS0-C-3A5B
(ucs-set-char #xBDA4 ?$(C:\(B) ; KS0-C-3A5C
(ucs-set-char #xBDB0 ?$(C:](B) ; KS0-C-3A5D
(ucs-set-char #xBDB8 ?$(C:^(B) ; KS0-C-3A5E
(ucs-set-char #xBDD4 ?$(C:_(B) ; KS0-C-3A5F
(ucs-set-char #xBDD5 ?$(C:`(B) ; KS0-C-3A60
(ucs-set-char #xBDD8 ?$(C:a(B) ; KS0-C-3A61
(ucs-set-char #xBDDC ?$(C:b(B) ; KS0-C-3A62
(ucs-set-char #xBDE9 ?$(C:c(B) ; KS0-C-3A63
(ucs-set-char #xBDF0 ?$(C:d(B) ; KS0-C-3A64
(ucs-set-char #xBDF4 ?$(C:e(B) ; KS0-C-3A65
(ucs-set-char #xBDF8 ?$(C:f(B) ; KS0-C-3A66
(ucs-set-char #xBE00 ?$(C:g(B) ; KS0-C-3A67
(ucs-set-char #xBE03 ?$(C:h(B) ; KS0-C-3A68
(ucs-set-char #xBE05 ?$(C:i(B) ; KS0-C-3A69
(ucs-set-char #xBE0C ?$(C:j(B) ; KS0-C-3A6A
(ucs-set-char #xBE0D ?$(C:k(B) ; KS0-C-3A6B
(ucs-set-char #xBE10 ?$(C:l(B) ; KS0-C-3A6C
(ucs-set-char #xBE14 ?$(C:m(B) ; KS0-C-3A6D
(ucs-set-char #xBE1C ?$(C:n(B) ; KS0-C-3A6E
(ucs-set-char #xBE1D ?$(C:o(B) ; KS0-C-3A6F
(ucs-set-char #xBE1F ?$(C:p(B) ; KS0-C-3A70
(ucs-set-char #xBE44 ?$(C:q(B) ; KS0-C-3A71
(ucs-set-char #xBE45 ?$(C:r(B) ; KS0-C-3A72
(ucs-set-char #xBE48 ?$(C:s(B) ; KS0-C-3A73
(ucs-set-char #xBE4C ?$(C:t(B) ; KS0-C-3A74
(ucs-set-char #xBE4E ?$(C:u(B) ; KS0-C-3A75
(ucs-set-char #xBE54 ?$(C:v(B) ; KS0-C-3A76
(ucs-set-char #xBE55 ?$(C:w(B) ; KS0-C-3A77
(ucs-set-char #xBE57 ?$(C:x(B) ; KS0-C-3A78
(ucs-set-char #xBE59 ?$(C:y(B) ; KS0-C-3A79
(ucs-set-char #xBE5A ?$(C:z(B) ; KS0-C-3A7A
(ucs-set-char #xBE5B ?$(C:{(B) ; KS0-C-3A7B
(ucs-set-char #xBE60 ?$(C:|(B) ; KS0-C-3A7C
(ucs-set-char #xBE61 ?$(C:}(B) ; KS0-C-3A7D
(ucs-set-char #xBE64 ?$(C:~(B) ; KS0-C-3A7E
(ucs-set-char #xBE68 ?$(C;!(B) ; KS0-C-3B21
(ucs-set-char #xBE6A ?$(C;"(B) ; KS0-C-3B22
(ucs-set-char #xBE70 ?$(C;#(B) ; KS0-C-3B23
(ucs-set-char #xBE71 ?$(C;$(B) ; KS0-C-3B24
(ucs-set-char #xBE73 ?$(C;%(B) ; KS0-C-3B25
(ucs-set-char #xBE74 ?$(C;&(B) ; KS0-C-3B26
(ucs-set-char #xBE75 ?$(C;'(B) ; KS0-C-3B27
(ucs-set-char #xBE7B ?$(C;((B) ; KS0-C-3B28
(ucs-set-char #xBE7C ?$(C;)(B) ; KS0-C-3B29
(ucs-set-char #xBE7D ?$(C;*(B) ; KS0-C-3B2A
(ucs-set-char #xBE80 ?$(C;+(B) ; KS0-C-3B2B
(ucs-set-char #xBE84 ?$(C;,(B) ; KS0-C-3B2C
(ucs-set-char #xBE8C ?$(C;-(B) ; KS0-C-3B2D
(ucs-set-char #xBE8D ?$(C;.(B) ; KS0-C-3B2E
(ucs-set-char #xBE8F ?$(C;/(B) ; KS0-C-3B2F
(ucs-set-char #xBE90 ?$(C;0(B) ; KS0-C-3B30
(ucs-set-char #xBE91 ?$(C;1(B) ; KS0-C-3B31
(ucs-set-char #xBE98 ?$(C;2(B) ; KS0-C-3B32
(ucs-set-char #xBE99 ?$(C;3(B) ; KS0-C-3B33
(ucs-set-char #xBEA8 ?$(C;4(B) ; KS0-C-3B34
(ucs-set-char #xBED0 ?$(C;5(B) ; KS0-C-3B35
(ucs-set-char #xBED1 ?$(C;6(B) ; KS0-C-3B36
(ucs-set-char #xBED4 ?$(C;7(B) ; KS0-C-3B37
(ucs-set-char #xBED7 ?$(C;8(B) ; KS0-C-3B38
(ucs-set-char #xBED8 ?$(C;9(B) ; KS0-C-3B39
(ucs-set-char #xBEE0 ?$(C;:(B) ; KS0-C-3B3A
(ucs-set-char #xBEE3 ?$(C;;(B) ; KS0-C-3B3B
(ucs-set-char #xBEE4 ?$(C;<(B) ; KS0-C-3B3C
(ucs-set-char #xBEE5 ?$(C;=(B) ; KS0-C-3B3D
(ucs-set-char #xBEEC ?$(C;>(B) ; KS0-C-3B3E
(ucs-set-char #xBF01 ?$(C;?(B) ; KS0-C-3B3F
(ucs-set-char #xBF08 ?$(C;@(B) ; KS0-C-3B40
(ucs-set-char #xBF09 ?$(C;A(B) ; KS0-C-3B41
(ucs-set-char #xBF18 ?$(C;B(B) ; KS0-C-3B42
(ucs-set-char #xBF19 ?$(C;C(B) ; KS0-C-3B43
(ucs-set-char #xBF1B ?$(C;D(B) ; KS0-C-3B44
(ucs-set-char #xBF1C ?$(C;E(B) ; KS0-C-3B45
(ucs-set-char #xBF1D ?$(C;F(B) ; KS0-C-3B46
(ucs-set-char #xBF40 ?$(C;G(B) ; KS0-C-3B47
(ucs-set-char #xBF41 ?$(C;H(B) ; KS0-C-3B48
(ucs-set-char #xBF44 ?$(C;I(B) ; KS0-C-3B49
(ucs-set-char #xBF48 ?$(C;J(B) ; KS0-C-3B4A
(ucs-set-char #xBF50 ?$(C;K(B) ; KS0-C-3B4B
(ucs-set-char #xBF51 ?$(C;L(B) ; KS0-C-3B4C
(ucs-set-char #xBF55 ?$(C;M(B) ; KS0-C-3B4D
(ucs-set-char #xBF94 ?$(C;N(B) ; KS0-C-3B4E
(ucs-set-char #xBFB0 ?$(C;O(B) ; KS0-C-3B4F
(ucs-set-char #xBFC5 ?$(C;P(B) ; KS0-C-3B50
(ucs-set-char #xBFCC ?$(C;Q(B) ; KS0-C-3B51
(ucs-set-char #xBFCD ?$(C;R(B) ; KS0-C-3B52
(ucs-set-char #xBFD0 ?$(C;S(B) ; KS0-C-3B53
(ucs-set-char #xBFD4 ?$(C;T(B) ; KS0-C-3B54
(ucs-set-char #xBFDC ?$(C;U(B) ; KS0-C-3B55
(ucs-set-char #xBFDF ?$(C;V(B) ; KS0-C-3B56
(ucs-set-char #xBFE1 ?$(C;W(B) ; KS0-C-3B57
(ucs-set-char #xC03C ?$(C;X(B) ; KS0-C-3B58
(ucs-set-char #xC051 ?$(C;Y(B) ; KS0-C-3B59
(ucs-set-char #xC058 ?$(C;Z(B) ; KS0-C-3B5A
(ucs-set-char #xC05C ?$(C;[(B) ; KS0-C-3B5B
(ucs-set-char #xC060 ?$(C;\(B) ; KS0-C-3B5C
(ucs-set-char #xC068 ?$(C;](B) ; KS0-C-3B5D
(ucs-set-char #xC069 ?$(C;^(B) ; KS0-C-3B5E
(ucs-set-char #xC090 ?$(C;_(B) ; KS0-C-3B5F
(ucs-set-char #xC091 ?$(C;`(B) ; KS0-C-3B60
(ucs-set-char #xC094 ?$(C;a(B) ; KS0-C-3B61
(ucs-set-char #xC098 ?$(C;b(B) ; KS0-C-3B62
(ucs-set-char #xC0A0 ?$(C;c(B) ; KS0-C-3B63
(ucs-set-char #xC0A1 ?$(C;d(B) ; KS0-C-3B64
(ucs-set-char #xC0A3 ?$(C;e(B) ; KS0-C-3B65
(ucs-set-char #xC0A5 ?$(C;f(B) ; KS0-C-3B66
(ucs-set-char #xC0AC ?$(C;g(B) ; KS0-C-3B67
(ucs-set-char #xC0AD ?$(C;h(B) ; KS0-C-3B68
(ucs-set-char #xC0AF ?$(C;i(B) ; KS0-C-3B69
(ucs-set-char #xC0B0 ?$(C;j(B) ; KS0-C-3B6A
(ucs-set-char #xC0B3 ?$(C;k(B) ; KS0-C-3B6B
(ucs-set-char #xC0B4 ?$(C;l(B) ; KS0-C-3B6C
(ucs-set-char #xC0B5 ?$(C;m(B) ; KS0-C-3B6D
(ucs-set-char #xC0B6 ?$(C;n(B) ; KS0-C-3B6E
(ucs-set-char #xC0BC ?$(C;o(B) ; KS0-C-3B6F
(ucs-set-char #xC0BD ?$(C;p(B) ; KS0-C-3B70
(ucs-set-char #xC0BF ?$(C;q(B) ; KS0-C-3B71
(ucs-set-char #xC0C0 ?$(C;r(B) ; KS0-C-3B72
(ucs-set-char #xC0C1 ?$(C;s(B) ; KS0-C-3B73
(ucs-set-char #xC0C5 ?$(C;t(B) ; KS0-C-3B74
(ucs-set-char #xC0C8 ?$(C;u(B) ; KS0-C-3B75
(ucs-set-char #xC0C9 ?$(C;v(B) ; KS0-C-3B76
(ucs-set-char #xC0CC ?$(C;w(B) ; KS0-C-3B77
(ucs-set-char #xC0D0 ?$(C;x(B) ; KS0-C-3B78
(ucs-set-char #xC0D8 ?$(C;y(B) ; KS0-C-3B79
(ucs-set-char #xC0D9 ?$(C;z(B) ; KS0-C-3B7A
(ucs-set-char #xC0DB ?$(C;{(B) ; KS0-C-3B7B
(ucs-set-char #xC0DC ?$(C;|(B) ; KS0-C-3B7C
(ucs-set-char #xC0DD ?$(C;}(B) ; KS0-C-3B7D
(ucs-set-char #xC0E4 ?$(C;~(B) ; KS0-C-3B7E
(ucs-set-char #xC0E5 ?$(C<!(B) ; KS0-C-3C21
(ucs-set-char #xC0E8 ?$(C<"(B) ; KS0-C-3C22
(ucs-set-char #xC0EC ?$(C<#(B) ; KS0-C-3C23
(ucs-set-char #xC0F4 ?$(C<$(B) ; KS0-C-3C24
(ucs-set-char #xC0F5 ?$(C<%(B) ; KS0-C-3C25
(ucs-set-char #xC0F7 ?$(C<&(B) ; KS0-C-3C26
(ucs-set-char #xC0F9 ?$(C<'(B) ; KS0-C-3C27
(ucs-set-char #xC100 ?$(C<((B) ; KS0-C-3C28
(ucs-set-char #xC104 ?$(C<)(B) ; KS0-C-3C29
(ucs-set-char #xC108 ?$(C<*(B) ; KS0-C-3C2A
(ucs-set-char #xC110 ?$(C<+(B) ; KS0-C-3C2B
(ucs-set-char #xC115 ?$(C<,(B) ; KS0-C-3C2C
(ucs-set-char #xC11C ?$(C<-(B) ; KS0-C-3C2D
(ucs-set-char #xC11D ?$(C<.(B) ; KS0-C-3C2E
(ucs-set-char #xC11E ?$(C</(B) ; KS0-C-3C2F
(ucs-set-char #xC11F ?$(C<0(B) ; KS0-C-3C30
(ucs-set-char #xC120 ?$(C<1(B) ; KS0-C-3C31
(ucs-set-char #xC123 ?$(C<2(B) ; KS0-C-3C32
(ucs-set-char #xC124 ?$(C<3(B) ; KS0-C-3C33
(ucs-set-char #xC126 ?$(C<4(B) ; KS0-C-3C34
(ucs-set-char #xC127 ?$(C<5(B) ; KS0-C-3C35
(ucs-set-char #xC12C ?$(C<6(B) ; KS0-C-3C36
(ucs-set-char #xC12D ?$(C<7(B) ; KS0-C-3C37
(ucs-set-char #xC12F ?$(C<8(B) ; KS0-C-3C38
(ucs-set-char #xC130 ?$(C<9(B) ; KS0-C-3C39
(ucs-set-char #xC131 ?$(C<:(B) ; KS0-C-3C3A
(ucs-set-char #xC136 ?$(C<;(B) ; KS0-C-3C3B
(ucs-set-char #xC138 ?$(C<<(B) ; KS0-C-3C3C
(ucs-set-char #xC139 ?$(C<=(B) ; KS0-C-3C3D
(ucs-set-char #xC13C ?$(C<>(B) ; KS0-C-3C3E
(ucs-set-char #xC140 ?$(C<?(B) ; KS0-C-3C3F
(ucs-set-char #xC148 ?$(C<@(B) ; KS0-C-3C40
(ucs-set-char #xC149 ?$(C<A(B) ; KS0-C-3C41
(ucs-set-char #xC14B ?$(C<B(B) ; KS0-C-3C42
(ucs-set-char #xC14C ?$(C<C(B) ; KS0-C-3C43
(ucs-set-char #xC14D ?$(C<D(B) ; KS0-C-3C44
(ucs-set-char #xC154 ?$(C<E(B) ; KS0-C-3C45
(ucs-set-char #xC155 ?$(C<F(B) ; KS0-C-3C46
(ucs-set-char #xC158 ?$(C<G(B) ; KS0-C-3C47
(ucs-set-char #xC15C ?$(C<H(B) ; KS0-C-3C48
(ucs-set-char #xC164 ?$(C<I(B) ; KS0-C-3C49
(ucs-set-char #xC165 ?$(C<J(B) ; KS0-C-3C4A
(ucs-set-char #xC167 ?$(C<K(B) ; KS0-C-3C4B
(ucs-set-char #xC168 ?$(C<L(B) ; KS0-C-3C4C
(ucs-set-char #xC169 ?$(C<M(B) ; KS0-C-3C4D
(ucs-set-char #xC170 ?$(C<N(B) ; KS0-C-3C4E
(ucs-set-char #xC174 ?$(C<O(B) ; KS0-C-3C4F
(ucs-set-char #xC178 ?$(C<P(B) ; KS0-C-3C50
(ucs-set-char #xC185 ?$(C<Q(B) ; KS0-C-3C51
(ucs-set-char #xC18C ?$(C<R(B) ; KS0-C-3C52
(ucs-set-char #xC18D ?$(C<S(B) ; KS0-C-3C53
(ucs-set-char #xC18E ?$(C<T(B) ; KS0-C-3C54
(ucs-set-char #xC190 ?$(C<U(B) ; KS0-C-3C55
(ucs-set-char #xC194 ?$(C<V(B) ; KS0-C-3C56
(ucs-set-char #xC196 ?$(C<W(B) ; KS0-C-3C57
(ucs-set-char #xC19C ?$(C<X(B) ; KS0-C-3C58
(ucs-set-char #xC19D ?$(C<Y(B) ; KS0-C-3C59
(ucs-set-char #xC19F ?$(C<Z(B) ; KS0-C-3C5A
(ucs-set-char #xC1A1 ?$(C<[(B) ; KS0-C-3C5B
(ucs-set-char #xC1A5 ?$(C<\(B) ; KS0-C-3C5C
(ucs-set-char #xC1A8 ?$(C<](B) ; KS0-C-3C5D
(ucs-set-char #xC1A9 ?$(C<^(B) ; KS0-C-3C5E
(ucs-set-char #xC1AC ?$(C<_(B) ; KS0-C-3C5F
(ucs-set-char #xC1B0 ?$(C<`(B) ; KS0-C-3C60
(ucs-set-char #xC1BD ?$(C<a(B) ; KS0-C-3C61
(ucs-set-char #xC1C4 ?$(C<b(B) ; KS0-C-3C62
(ucs-set-char #xC1C8 ?$(C<c(B) ; KS0-C-3C63
(ucs-set-char #xC1CC ?$(C<d(B) ; KS0-C-3C64
(ucs-set-char #xC1D4 ?$(C<e(B) ; KS0-C-3C65
(ucs-set-char #xC1D7 ?$(C<f(B) ; KS0-C-3C66
(ucs-set-char #xC1D8 ?$(C<g(B) ; KS0-C-3C67
(ucs-set-char #xC1E0 ?$(C<h(B) ; KS0-C-3C68
(ucs-set-char #xC1E4 ?$(C<i(B) ; KS0-C-3C69
(ucs-set-char #xC1E8 ?$(C<j(B) ; KS0-C-3C6A
(ucs-set-char #xC1F0 ?$(C<k(B) ; KS0-C-3C6B
(ucs-set-char #xC1F1 ?$(C<l(B) ; KS0-C-3C6C
(ucs-set-char #xC1F3 ?$(C<m(B) ; KS0-C-3C6D
(ucs-set-char #xC1FC ?$(C<n(B) ; KS0-C-3C6E
(ucs-set-char #xC1FD ?$(C<o(B) ; KS0-C-3C6F
(ucs-set-char #xC200 ?$(C<p(B) ; KS0-C-3C70
(ucs-set-char #xC204 ?$(C<q(B) ; KS0-C-3C71
(ucs-set-char #xC20C ?$(C<r(B) ; KS0-C-3C72
(ucs-set-char #xC20D ?$(C<s(B) ; KS0-C-3C73
(ucs-set-char #xC20F ?$(C<t(B) ; KS0-C-3C74
(ucs-set-char #xC211 ?$(C<u(B) ; KS0-C-3C75
(ucs-set-char #xC218 ?$(C<v(B) ; KS0-C-3C76
(ucs-set-char #xC219 ?$(C<w(B) ; KS0-C-3C77
(ucs-set-char #xC21C ?$(C<x(B) ; KS0-C-3C78
(ucs-set-char #xC21F ?$(C<y(B) ; KS0-C-3C79
(ucs-set-char #xC220 ?$(C<z(B) ; KS0-C-3C7A
(ucs-set-char #xC228 ?$(C<{(B) ; KS0-C-3C7B
(ucs-set-char #xC229 ?$(C<|(B) ; KS0-C-3C7C
(ucs-set-char #xC22B ?$(C<}(B) ; KS0-C-3C7D
(ucs-set-char #xC22D ?$(C<~(B) ; KS0-C-3C7E
(ucs-set-char #xC22F ?$(C=!(B) ; KS0-C-3D21
(ucs-set-char #xC231 ?$(C="(B) ; KS0-C-3D22
(ucs-set-char #xC232 ?$(C=#(B) ; KS0-C-3D23
(ucs-set-char #xC234 ?$(C=$(B) ; KS0-C-3D24
(ucs-set-char #xC248 ?$(C=%(B) ; KS0-C-3D25
(ucs-set-char #xC250 ?$(C=&(B) ; KS0-C-3D26
(ucs-set-char #xC251 ?$(C='(B) ; KS0-C-3D27
(ucs-set-char #xC254 ?$(C=((B) ; KS0-C-3D28
(ucs-set-char #xC258 ?$(C=)(B) ; KS0-C-3D29
(ucs-set-char #xC260 ?$(C=*(B) ; KS0-C-3D2A
(ucs-set-char #xC265 ?$(C=+(B) ; KS0-C-3D2B
(ucs-set-char #xC26C ?$(C=,(B) ; KS0-C-3D2C
(ucs-set-char #xC26D ?$(C=-(B) ; KS0-C-3D2D
(ucs-set-char #xC270 ?$(C=.(B) ; KS0-C-3D2E
(ucs-set-char #xC274 ?$(C=/(B) ; KS0-C-3D2F
(ucs-set-char #xC27C ?$(C=0(B) ; KS0-C-3D30
(ucs-set-char #xC27D ?$(C=1(B) ; KS0-C-3D31
(ucs-set-char #xC27F ?$(C=2(B) ; KS0-C-3D32
(ucs-set-char #xC281 ?$(C=3(B) ; KS0-C-3D33
(ucs-set-char #xC288 ?$(C=4(B) ; KS0-C-3D34
(ucs-set-char #xC289 ?$(C=5(B) ; KS0-C-3D35
(ucs-set-char #xC290 ?$(C=6(B) ; KS0-C-3D36
(ucs-set-char #xC298 ?$(C=7(B) ; KS0-C-3D37
(ucs-set-char #xC29B ?$(C=8(B) ; KS0-C-3D38
(ucs-set-char #xC29D ?$(C=9(B) ; KS0-C-3D39
(ucs-set-char #xC2A4 ?$(C=:(B) ; KS0-C-3D3A
(ucs-set-char #xC2A5 ?$(C=;(B) ; KS0-C-3D3B
(ucs-set-char #xC2A8 ?$(C=<(B) ; KS0-C-3D3C
(ucs-set-char #xC2AC ?$(C==(B) ; KS0-C-3D3D
(ucs-set-char #xC2AD ?$(C=>(B) ; KS0-C-3D3E
(ucs-set-char #xC2B4 ?$(C=?(B) ; KS0-C-3D3F
(ucs-set-char #xC2B5 ?$(C=@(B) ; KS0-C-3D40
(ucs-set-char #xC2B7 ?$(C=A(B) ; KS0-C-3D41
(ucs-set-char #xC2B9 ?$(C=B(B) ; KS0-C-3D42
(ucs-set-char #xC2DC ?$(C=C(B) ; KS0-C-3D43
(ucs-set-char #xC2DD ?$(C=D(B) ; KS0-C-3D44
(ucs-set-char #xC2E0 ?$(C=E(B) ; KS0-C-3D45
(ucs-set-char #xC2E3 ?$(C=F(B) ; KS0-C-3D46
(ucs-set-char #xC2E4 ?$(C=G(B) ; KS0-C-3D47
(ucs-set-char #xC2EB ?$(C=H(B) ; KS0-C-3D48
(ucs-set-char #xC2EC ?$(C=I(B) ; KS0-C-3D49
(ucs-set-char #xC2ED ?$(C=J(B) ; KS0-C-3D4A
(ucs-set-char #xC2EF ?$(C=K(B) ; KS0-C-3D4B
(ucs-set-char #xC2F1 ?$(C=L(B) ; KS0-C-3D4C
(ucs-set-char #xC2F6 ?$(C=M(B) ; KS0-C-3D4D
(ucs-set-char #xC2F8 ?$(C=N(B) ; KS0-C-3D4E
(ucs-set-char #xC2F9 ?$(C=O(B) ; KS0-C-3D4F
(ucs-set-char #xC2FB ?$(C=P(B) ; KS0-C-3D50
(ucs-set-char #xC2FC ?$(C=Q(B) ; KS0-C-3D51
(ucs-set-char #xC300 ?$(C=R(B) ; KS0-C-3D52
(ucs-set-char #xC308 ?$(C=S(B) ; KS0-C-3D53
(ucs-set-char #xC309 ?$(C=T(B) ; KS0-C-3D54
(ucs-set-char #xC30C ?$(C=U(B) ; KS0-C-3D55
(ucs-set-char #xC30D ?$(C=V(B) ; KS0-C-3D56
(ucs-set-char #xC313 ?$(C=W(B) ; KS0-C-3D57
(ucs-set-char #xC314 ?$(C=X(B) ; KS0-C-3D58
(ucs-set-char #xC315 ?$(C=Y(B) ; KS0-C-3D59
(ucs-set-char #xC318 ?$(C=Z(B) ; KS0-C-3D5A
(ucs-set-char #xC31C ?$(C=[(B) ; KS0-C-3D5B
(ucs-set-char #xC324 ?$(C=\(B) ; KS0-C-3D5C
(ucs-set-char #xC325 ?$(C=](B) ; KS0-C-3D5D
(ucs-set-char #xC328 ?$(C=^(B) ; KS0-C-3D5E
(ucs-set-char #xC329 ?$(C=_(B) ; KS0-C-3D5F
(ucs-set-char #xC345 ?$(C=`(B) ; KS0-C-3D60
(ucs-set-char #xC368 ?$(C=a(B) ; KS0-C-3D61
(ucs-set-char #xC369 ?$(C=b(B) ; KS0-C-3D62
(ucs-set-char #xC36C ?$(C=c(B) ; KS0-C-3D63
(ucs-set-char #xC370 ?$(C=d(B) ; KS0-C-3D64
(ucs-set-char #xC372 ?$(C=e(B) ; KS0-C-3D65
(ucs-set-char #xC378 ?$(C=f(B) ; KS0-C-3D66
(ucs-set-char #xC379 ?$(C=g(B) ; KS0-C-3D67
(ucs-set-char #xC37C ?$(C=h(B) ; KS0-C-3D68
(ucs-set-char #xC37D ?$(C=i(B) ; KS0-C-3D69
(ucs-set-char #xC384 ?$(C=j(B) ; KS0-C-3D6A
(ucs-set-char #xC388 ?$(C=k(B) ; KS0-C-3D6B
(ucs-set-char #xC38C ?$(C=l(B) ; KS0-C-3D6C
(ucs-set-char #xC3C0 ?$(C=m(B) ; KS0-C-3D6D
(ucs-set-char #xC3D8 ?$(C=n(B) ; KS0-C-3D6E
(ucs-set-char #xC3D9 ?$(C=o(B) ; KS0-C-3D6F
(ucs-set-char #xC3DC ?$(C=p(B) ; KS0-C-3D70
(ucs-set-char #xC3DF ?$(C=q(B) ; KS0-C-3D71
(ucs-set-char #xC3E0 ?$(C=r(B) ; KS0-C-3D72
(ucs-set-char #xC3E2 ?$(C=s(B) ; KS0-C-3D73
(ucs-set-char #xC3E8 ?$(C=t(B) ; KS0-C-3D74
(ucs-set-char #xC3E9 ?$(C=u(B) ; KS0-C-3D75
(ucs-set-char #xC3ED ?$(C=v(B) ; KS0-C-3D76
(ucs-set-char #xC3F4 ?$(C=w(B) ; KS0-C-3D77
(ucs-set-char #xC3F5 ?$(C=x(B) ; KS0-C-3D78
(ucs-set-char #xC3F8 ?$(C=y(B) ; KS0-C-3D79
(ucs-set-char #xC408 ?$(C=z(B) ; KS0-C-3D7A
(ucs-set-char #xC410 ?$(C={(B) ; KS0-C-3D7B
(ucs-set-char #xC424 ?$(C=|(B) ; KS0-C-3D7C
(ucs-set-char #xC42C ?$(C=}(B) ; KS0-C-3D7D
(ucs-set-char #xC430 ?$(C=~(B) ; KS0-C-3D7E
(ucs-set-char #xC434 ?$(C>!(B) ; KS0-C-3E21
(ucs-set-char #xC43C ?$(C>"(B) ; KS0-C-3E22
(ucs-set-char #xC43D ?$(C>#(B) ; KS0-C-3E23
(ucs-set-char #xC448 ?$(C>$(B) ; KS0-C-3E24
(ucs-set-char #xC464 ?$(C>%(B) ; KS0-C-3E25
(ucs-set-char #xC465 ?$(C>&(B) ; KS0-C-3E26
(ucs-set-char #xC468 ?$(C>'(B) ; KS0-C-3E27
(ucs-set-char #xC46C ?$(C>((B) ; KS0-C-3E28
(ucs-set-char #xC474 ?$(C>)(B) ; KS0-C-3E29
(ucs-set-char #xC475 ?$(C>*(B) ; KS0-C-3E2A
(ucs-set-char #xC479 ?$(C>+(B) ; KS0-C-3E2B
(ucs-set-char #xC480 ?$(C>,(B) ; KS0-C-3E2C
(ucs-set-char #xC494 ?$(C>-(B) ; KS0-C-3E2D
(ucs-set-char #xC49C ?$(C>.(B) ; KS0-C-3E2E
(ucs-set-char #xC4B8 ?$(C>/(B) ; KS0-C-3E2F
(ucs-set-char #xC4BC ?$(C>0(B) ; KS0-C-3E30
(ucs-set-char #xC4E9 ?$(C>1(B) ; KS0-C-3E31
(ucs-set-char #xC4F0 ?$(C>2(B) ; KS0-C-3E32
(ucs-set-char #xC4F1 ?$(C>3(B) ; KS0-C-3E33
(ucs-set-char #xC4F4 ?$(C>4(B) ; KS0-C-3E34
(ucs-set-char #xC4F8 ?$(C>5(B) ; KS0-C-3E35
(ucs-set-char #xC4FA ?$(C>6(B) ; KS0-C-3E36
(ucs-set-char #xC4FF ?$(C>7(B) ; KS0-C-3E37
(ucs-set-char #xC500 ?$(C>8(B) ; KS0-C-3E38
(ucs-set-char #xC501 ?$(C>9(B) ; KS0-C-3E39
(ucs-set-char #xC50C ?$(C>:(B) ; KS0-C-3E3A
(ucs-set-char #xC510 ?$(C>;(B) ; KS0-C-3E3B
(ucs-set-char #xC514 ?$(C><(B) ; KS0-C-3E3C
(ucs-set-char #xC51C ?$(C>=(B) ; KS0-C-3E3D
(ucs-set-char #xC528 ?$(C>>(B) ; KS0-C-3E3E
(ucs-set-char #xC529 ?$(C>?(B) ; KS0-C-3E3F
(ucs-set-char #xC52C ?$(C>@(B) ; KS0-C-3E40
(ucs-set-char #xC530 ?$(C>A(B) ; KS0-C-3E41
(ucs-set-char #xC538 ?$(C>B(B) ; KS0-C-3E42
(ucs-set-char #xC539 ?$(C>C(B) ; KS0-C-3E43
(ucs-set-char #xC53B ?$(C>D(B) ; KS0-C-3E44
(ucs-set-char #xC53D ?$(C>E(B) ; KS0-C-3E45
(ucs-set-char #xC544 ?$(C>F(B) ; KS0-C-3E46
(ucs-set-char #xC545 ?$(C>G(B) ; KS0-C-3E47
(ucs-set-char #xC548 ?$(C>H(B) ; KS0-C-3E48
(ucs-set-char #xC549 ?$(C>I(B) ; KS0-C-3E49
(ucs-set-char #xC54A ?$(C>J(B) ; KS0-C-3E4A
(ucs-set-char #xC54C ?$(C>K(B) ; KS0-C-3E4B
(ucs-set-char #xC54D ?$(C>L(B) ; KS0-C-3E4C
(ucs-set-char #xC54E ?$(C>M(B) ; KS0-C-3E4D
(ucs-set-char #xC553 ?$(C>N(B) ; KS0-C-3E4E
(ucs-set-char #xC554 ?$(C>O(B) ; KS0-C-3E4F
(ucs-set-char #xC555 ?$(C>P(B) ; KS0-C-3E50
(ucs-set-char #xC557 ?$(C>Q(B) ; KS0-C-3E51
(ucs-set-char #xC558 ?$(C>R(B) ; KS0-C-3E52
(ucs-set-char #xC559 ?$(C>S(B) ; KS0-C-3E53
(ucs-set-char #xC55D ?$(C>T(B) ; KS0-C-3E54
(ucs-set-char #xC55E ?$(C>U(B) ; KS0-C-3E55
(ucs-set-char #xC560 ?$(C>V(B) ; KS0-C-3E56
(ucs-set-char #xC561 ?$(C>W(B) ; KS0-C-3E57
(ucs-set-char #xC564 ?$(C>X(B) ; KS0-C-3E58
(ucs-set-char #xC568 ?$(C>Y(B) ; KS0-C-3E59
(ucs-set-char #xC570 ?$(C>Z(B) ; KS0-C-3E5A
(ucs-set-char #xC571 ?$(C>[(B) ; KS0-C-3E5B
(ucs-set-char #xC573 ?$(C>\(B) ; KS0-C-3E5C
(ucs-set-char #xC574 ?$(C>](B) ; KS0-C-3E5D
(ucs-set-char #xC575 ?$(C>^(B) ; KS0-C-3E5E
(ucs-set-char #xC57C ?$(C>_(B) ; KS0-C-3E5F
(ucs-set-char #xC57D ?$(C>`(B) ; KS0-C-3E60
(ucs-set-char #xC580 ?$(C>a(B) ; KS0-C-3E61
(ucs-set-char #xC584 ?$(C>b(B) ; KS0-C-3E62
(ucs-set-char #xC587 ?$(C>c(B) ; KS0-C-3E63
(ucs-set-char #xC58C ?$(C>d(B) ; KS0-C-3E64
(ucs-set-char #xC58D ?$(C>e(B) ; KS0-C-3E65
(ucs-set-char #xC58F ?$(C>f(B) ; KS0-C-3E66
(ucs-set-char #xC591 ?$(C>g(B) ; KS0-C-3E67
(ucs-set-char #xC595 ?$(C>h(B) ; KS0-C-3E68
(ucs-set-char #xC597 ?$(C>i(B) ; KS0-C-3E69
(ucs-set-char #xC598 ?$(C>j(B) ; KS0-C-3E6A
(ucs-set-char #xC59C ?$(C>k(B) ; KS0-C-3E6B
(ucs-set-char #xC5A0 ?$(C>l(B) ; KS0-C-3E6C
(ucs-set-char #xC5A9 ?$(C>m(B) ; KS0-C-3E6D
(ucs-set-char #xC5B4 ?$(C>n(B) ; KS0-C-3E6E
(ucs-set-char #xC5B5 ?$(C>o(B) ; KS0-C-3E6F
(ucs-set-char #xC5B8 ?$(C>p(B) ; KS0-C-3E70
(ucs-set-char #xC5B9 ?$(C>q(B) ; KS0-C-3E71
(ucs-set-char #xC5BB ?$(C>r(B) ; KS0-C-3E72
(ucs-set-char #xC5BC ?$(C>s(B) ; KS0-C-3E73
(ucs-set-char #xC5BD ?$(C>t(B) ; KS0-C-3E74
(ucs-set-char #xC5BE ?$(C>u(B) ; KS0-C-3E75
(ucs-set-char #xC5C4 ?$(C>v(B) ; KS0-C-3E76
(ucs-set-char #xC5C5 ?$(C>w(B) ; KS0-C-3E77
(ucs-set-char #xC5C6 ?$(C>x(B) ; KS0-C-3E78
(ucs-set-char #xC5C7 ?$(C>y(B) ; KS0-C-3E79
(ucs-set-char #xC5C8 ?$(C>z(B) ; KS0-C-3E7A
(ucs-set-char #xC5C9 ?$(C>{(B) ; KS0-C-3E7B
(ucs-set-char #xC5CA ?$(C>|(B) ; KS0-C-3E7C
(ucs-set-char #xC5CC ?$(C>}(B) ; KS0-C-3E7D
(ucs-set-char #xC5CE ?$(C>~(B) ; KS0-C-3E7E
(ucs-set-char #xC5D0 ?$(C?!(B) ; KS0-C-3F21
(ucs-set-char #xC5D1 ?$(C?"(B) ; KS0-C-3F22
(ucs-set-char #xC5D4 ?$(C?#(B) ; KS0-C-3F23
(ucs-set-char #xC5D8 ?$(C?$(B) ; KS0-C-3F24
(ucs-set-char #xC5E0 ?$(C?%(B) ; KS0-C-3F25
(ucs-set-char #xC5E1 ?$(C?&(B) ; KS0-C-3F26
(ucs-set-char #xC5E3 ?$(C?'(B) ; KS0-C-3F27
(ucs-set-char #xC5E5 ?$(C?((B) ; KS0-C-3F28
(ucs-set-char #xC5EC ?$(C?)(B) ; KS0-C-3F29
(ucs-set-char #xC5ED ?$(C?*(B) ; KS0-C-3F2A
(ucs-set-char #xC5EE ?$(C?+(B) ; KS0-C-3F2B
(ucs-set-char #xC5F0 ?$(C?,(B) ; KS0-C-3F2C
(ucs-set-char #xC5F4 ?$(C?-(B) ; KS0-C-3F2D
(ucs-set-char #xC5F6 ?$(C?.(B) ; KS0-C-3F2E
(ucs-set-char #xC5F7 ?$(C?/(B) ; KS0-C-3F2F
(ucs-set-char #xC5FC ?$(C?0(B) ; KS0-C-3F30
(ucs-set-char #xC5FD ?$(C?1(B) ; KS0-C-3F31
(ucs-set-char #xC5FE ?$(C?2(B) ; KS0-C-3F32
(ucs-set-char #xC5FF ?$(C?3(B) ; KS0-C-3F33
(ucs-set-char #xC600 ?$(C?4(B) ; KS0-C-3F34
(ucs-set-char #xC601 ?$(C?5(B) ; KS0-C-3F35
(ucs-set-char #xC605 ?$(C?6(B) ; KS0-C-3F36
(ucs-set-char #xC606 ?$(C?7(B) ; KS0-C-3F37
(ucs-set-char #xC607 ?$(C?8(B) ; KS0-C-3F38
(ucs-set-char #xC608 ?$(C?9(B) ; KS0-C-3F39
(ucs-set-char #xC60C ?$(C?:(B) ; KS0-C-3F3A
(ucs-set-char #xC610 ?$(C?;(B) ; KS0-C-3F3B
(ucs-set-char #xC618 ?$(C?<(B) ; KS0-C-3F3C
(ucs-set-char #xC619 ?$(C?=(B) ; KS0-C-3F3D
(ucs-set-char #xC61B ?$(C?>(B) ; KS0-C-3F3E
(ucs-set-char #xC61C ?$(C??(B) ; KS0-C-3F3F
(ucs-set-char #xC624 ?$(C?@(B) ; KS0-C-3F40
(ucs-set-char #xC625 ?$(C?A(B) ; KS0-C-3F41
(ucs-set-char #xC628 ?$(C?B(B) ; KS0-C-3F42
(ucs-set-char #xC62C ?$(C?C(B) ; KS0-C-3F43
(ucs-set-char #xC62D ?$(C?D(B) ; KS0-C-3F44
(ucs-set-char #xC62E ?$(C?E(B) ; KS0-C-3F45
(ucs-set-char #xC630 ?$(C?F(B) ; KS0-C-3F46
(ucs-set-char #xC633 ?$(C?G(B) ; KS0-C-3F47
(ucs-set-char #xC634 ?$(C?H(B) ; KS0-C-3F48
(ucs-set-char #xC635 ?$(C?I(B) ; KS0-C-3F49
(ucs-set-char #xC637 ?$(C?J(B) ; KS0-C-3F4A
(ucs-set-char #xC639 ?$(C?K(B) ; KS0-C-3F4B
(ucs-set-char #xC63B ?$(C?L(B) ; KS0-C-3F4C
(ucs-set-char #xC640 ?$(C?M(B) ; KS0-C-3F4D
(ucs-set-char #xC641 ?$(C?N(B) ; KS0-C-3F4E
(ucs-set-char #xC644 ?$(C?O(B) ; KS0-C-3F4F
(ucs-set-char #xC648 ?$(C?P(B) ; KS0-C-3F50
(ucs-set-char #xC650 ?$(C?Q(B) ; KS0-C-3F51
(ucs-set-char #xC651 ?$(C?R(B) ; KS0-C-3F52
(ucs-set-char #xC653 ?$(C?S(B) ; KS0-C-3F53
(ucs-set-char #xC654 ?$(C?T(B) ; KS0-C-3F54
(ucs-set-char #xC655 ?$(C?U(B) ; KS0-C-3F55
(ucs-set-char #xC65C ?$(C?V(B) ; KS0-C-3F56
(ucs-set-char #xC65D ?$(C?W(B) ; KS0-C-3F57
(ucs-set-char #xC660 ?$(C?X(B) ; KS0-C-3F58
(ucs-set-char #xC66C ?$(C?Y(B) ; KS0-C-3F59
(ucs-set-char #xC66F ?$(C?Z(B) ; KS0-C-3F5A
(ucs-set-char #xC671 ?$(C?[(B) ; KS0-C-3F5B
(ucs-set-char #xC678 ?$(C?\(B) ; KS0-C-3F5C
(ucs-set-char #xC679 ?$(C?](B) ; KS0-C-3F5D
(ucs-set-char #xC67C ?$(C?^(B) ; KS0-C-3F5E
(ucs-set-char #xC680 ?$(C?_(B) ; KS0-C-3F5F
(ucs-set-char #xC688 ?$(C?`(B) ; KS0-C-3F60
(ucs-set-char #xC689 ?$(C?a(B) ; KS0-C-3F61
(ucs-set-char #xC68B ?$(C?b(B) ; KS0-C-3F62
(ucs-set-char #xC68D ?$(C?c(B) ; KS0-C-3F63
(ucs-set-char #xC694 ?$(C?d(B) ; KS0-C-3F64
(ucs-set-char #xC695 ?$(C?e(B) ; KS0-C-3F65
(ucs-set-char #xC698 ?$(C?f(B) ; KS0-C-3F66
(ucs-set-char #xC69C ?$(C?g(B) ; KS0-C-3F67
(ucs-set-char #xC6A4 ?$(C?h(B) ; KS0-C-3F68
(ucs-set-char #xC6A5 ?$(C?i(B) ; KS0-C-3F69
(ucs-set-char #xC6A7 ?$(C?j(B) ; KS0-C-3F6A
(ucs-set-char #xC6A9 ?$(C?k(B) ; KS0-C-3F6B
(ucs-set-char #xC6B0 ?$(C?l(B) ; KS0-C-3F6C
(ucs-set-char #xC6B1 ?$(C?m(B) ; KS0-C-3F6D
(ucs-set-char #xC6B4 ?$(C?n(B) ; KS0-C-3F6E
(ucs-set-char #xC6B8 ?$(C?o(B) ; KS0-C-3F6F
(ucs-set-char #xC6B9 ?$(C?p(B) ; KS0-C-3F70
(ucs-set-char #xC6BA ?$(C?q(B) ; KS0-C-3F71
(ucs-set-char #xC6C0 ?$(C?r(B) ; KS0-C-3F72
(ucs-set-char #xC6C1 ?$(C?s(B) ; KS0-C-3F73
(ucs-set-char #xC6C3 ?$(C?t(B) ; KS0-C-3F74
(ucs-set-char #xC6C5 ?$(C?u(B) ; KS0-C-3F75
(ucs-set-char #xC6CC ?$(C?v(B) ; KS0-C-3F76
(ucs-set-char #xC6CD ?$(C?w(B) ; KS0-C-3F77
(ucs-set-char #xC6D0 ?$(C?x(B) ; KS0-C-3F78
(ucs-set-char #xC6D4 ?$(C?y(B) ; KS0-C-3F79
(ucs-set-char #xC6DC ?$(C?z(B) ; KS0-C-3F7A
(ucs-set-char #xC6DD ?$(C?{(B) ; KS0-C-3F7B
(ucs-set-char #xC6E0 ?$(C?|(B) ; KS0-C-3F7C
(ucs-set-char #xC6E1 ?$(C?}(B) ; KS0-C-3F7D
(ucs-set-char #xC6E8 ?$(C?~(B) ; KS0-C-3F7E
(ucs-set-char #xC6E9 ?$(C@!(B) ; KS0-C-4021
(ucs-set-char #xC6EC ?$(C@"(B) ; KS0-C-4022
(ucs-set-char #xC6F0 ?$(C@#(B) ; KS0-C-4023
(ucs-set-char #xC6F8 ?$(C@$(B) ; KS0-C-4024
(ucs-set-char #xC6F9 ?$(C@%(B) ; KS0-C-4025
(ucs-set-char #xC6FD ?$(C@&(B) ; KS0-C-4026
(ucs-set-char #xC704 ?$(C@'(B) ; KS0-C-4027
(ucs-set-char #xC705 ?$(C@((B) ; KS0-C-4028
(ucs-set-char #xC708 ?$(C@)(B) ; KS0-C-4029
(ucs-set-char #xC70C ?$(C@*(B) ; KS0-C-402A
(ucs-set-char #xC714 ?$(C@+(B) ; KS0-C-402B
(ucs-set-char #xC715 ?$(C@,(B) ; KS0-C-402C
(ucs-set-char #xC717 ?$(C@-(B) ; KS0-C-402D
(ucs-set-char #xC719 ?$(C@.(B) ; KS0-C-402E
(ucs-set-char #xC720 ?$(C@/(B) ; KS0-C-402F
(ucs-set-char #xC721 ?$(C@0(B) ; KS0-C-4030
(ucs-set-char #xC724 ?$(C@1(B) ; KS0-C-4031
(ucs-set-char #xC728 ?$(C@2(B) ; KS0-C-4032
(ucs-set-char #xC730 ?$(C@3(B) ; KS0-C-4033
(ucs-set-char #xC731 ?$(C@4(B) ; KS0-C-4034
(ucs-set-char #xC733 ?$(C@5(B) ; KS0-C-4035
(ucs-set-char #xC735 ?$(C@6(B) ; KS0-C-4036
(ucs-set-char #xC737 ?$(C@7(B) ; KS0-C-4037
(ucs-set-char #xC73C ?$(C@8(B) ; KS0-C-4038
(ucs-set-char #xC73D ?$(C@9(B) ; KS0-C-4039
(ucs-set-char #xC740 ?$(C@:(B) ; KS0-C-403A
(ucs-set-char #xC744 ?$(C@;(B) ; KS0-C-403B
(ucs-set-char #xC74A ?$(C@<(B) ; KS0-C-403C
(ucs-set-char #xC74C ?$(C@=(B) ; KS0-C-403D
(ucs-set-char #xC74D ?$(C@>(B) ; KS0-C-403E
(ucs-set-char #xC74F ?$(C@?(B) ; KS0-C-403F
(ucs-set-char #xC751 ?$(C@@(B) ; KS0-C-4040
(ucs-set-char #xC752 ?$(C@A(B) ; KS0-C-4041
(ucs-set-char #xC753 ?$(C@B(B) ; KS0-C-4042
(ucs-set-char #xC754 ?$(C@C(B) ; KS0-C-4043
(ucs-set-char #xC755 ?$(C@D(B) ; KS0-C-4044
(ucs-set-char #xC756 ?$(C@E(B) ; KS0-C-4045
(ucs-set-char #xC757 ?$(C@F(B) ; KS0-C-4046
(ucs-set-char #xC758 ?$(C@G(B) ; KS0-C-4047
(ucs-set-char #xC75C ?$(C@H(B) ; KS0-C-4048
(ucs-set-char #xC760 ?$(C@I(B) ; KS0-C-4049
(ucs-set-char #xC768 ?$(C@J(B) ; KS0-C-404A
(ucs-set-char #xC76B ?$(C@K(B) ; KS0-C-404B
(ucs-set-char #xC774 ?$(C@L(B) ; KS0-C-404C
(ucs-set-char #xC775 ?$(C@M(B) ; KS0-C-404D
(ucs-set-char #xC778 ?$(C@N(B) ; KS0-C-404E
(ucs-set-char #xC77C ?$(C@O(B) ; KS0-C-404F
(ucs-set-char #xC77D ?$(C@P(B) ; KS0-C-4050
(ucs-set-char #xC77E ?$(C@Q(B) ; KS0-C-4051
(ucs-set-char #xC783 ?$(C@R(B) ; KS0-C-4052
(ucs-set-char #xC784 ?$(C@S(B) ; KS0-C-4053
(ucs-set-char #xC785 ?$(C@T(B) ; KS0-C-4054
(ucs-set-char #xC787 ?$(C@U(B) ; KS0-C-4055
(ucs-set-char #xC788 ?$(C@V(B) ; KS0-C-4056
(ucs-set-char #xC789 ?$(C@W(B) ; KS0-C-4057
(ucs-set-char #xC78A ?$(C@X(B) ; KS0-C-4058
(ucs-set-char #xC78E ?$(C@Y(B) ; KS0-C-4059
(ucs-set-char #xC790 ?$(C@Z(B) ; KS0-C-405A
(ucs-set-char #xC791 ?$(C@[(B) ; KS0-C-405B
(ucs-set-char #xC794 ?$(C@\(B) ; KS0-C-405C
(ucs-set-char #xC796 ?$(C@](B) ; KS0-C-405D
(ucs-set-char #xC797 ?$(C@^(B) ; KS0-C-405E
(ucs-set-char #xC798 ?$(C@_(B) ; KS0-C-405F
(ucs-set-char #xC79A ?$(C@`(B) ; KS0-C-4060
(ucs-set-char #xC7A0 ?$(C@a(B) ; KS0-C-4061
(ucs-set-char #xC7A1 ?$(C@b(B) ; KS0-C-4062
(ucs-set-char #xC7A3 ?$(C@c(B) ; KS0-C-4063
(ucs-set-char #xC7A4 ?$(C@d(B) ; KS0-C-4064
(ucs-set-char #xC7A5 ?$(C@e(B) ; KS0-C-4065
(ucs-set-char #xC7A6 ?$(C@f(B) ; KS0-C-4066
(ucs-set-char #xC7AC ?$(C@g(B) ; KS0-C-4067
(ucs-set-char #xC7AD ?$(C@h(B) ; KS0-C-4068
(ucs-set-char #xC7B0 ?$(C@i(B) ; KS0-C-4069
(ucs-set-char #xC7B4 ?$(C@j(B) ; KS0-C-406A
(ucs-set-char #xC7BC ?$(C@k(B) ; KS0-C-406B
(ucs-set-char #xC7BD ?$(C@l(B) ; KS0-C-406C
(ucs-set-char #xC7BF ?$(C@m(B) ; KS0-C-406D
(ucs-set-char #xC7C0 ?$(C@n(B) ; KS0-C-406E
(ucs-set-char #xC7C1 ?$(C@o(B) ; KS0-C-406F
(ucs-set-char #xC7C8 ?$(C@p(B) ; KS0-C-4070
(ucs-set-char #xC7C9 ?$(C@q(B) ; KS0-C-4071
(ucs-set-char #xC7CC ?$(C@r(B) ; KS0-C-4072
(ucs-set-char #xC7CE ?$(C@s(B) ; KS0-C-4073
(ucs-set-char #xC7D0 ?$(C@t(B) ; KS0-C-4074
(ucs-set-char #xC7D8 ?$(C@u(B) ; KS0-C-4075
(ucs-set-char #xC7DD ?$(C@v(B) ; KS0-C-4076
(ucs-set-char #xC7E4 ?$(C@w(B) ; KS0-C-4077
(ucs-set-char #xC7E8 ?$(C@x(B) ; KS0-C-4078
(ucs-set-char #xC7EC ?$(C@y(B) ; KS0-C-4079
(ucs-set-char #xC800 ?$(C@z(B) ; KS0-C-407A
(ucs-set-char #xC801 ?$(C@{(B) ; KS0-C-407B
(ucs-set-char #xC804 ?$(C@|(B) ; KS0-C-407C
(ucs-set-char #xC808 ?$(C@}(B) ; KS0-C-407D
(ucs-set-char #xC80A ?$(C@~(B) ; KS0-C-407E
(ucs-set-char #xC810 ?$(CA!(B) ; KS0-C-4121
(ucs-set-char #xC811 ?$(CA"(B) ; KS0-C-4122
(ucs-set-char #xC813 ?$(CA#(B) ; KS0-C-4123
(ucs-set-char #xC815 ?$(CA$(B) ; KS0-C-4124
(ucs-set-char #xC816 ?$(CA%(B) ; KS0-C-4125
(ucs-set-char #xC81C ?$(CA&(B) ; KS0-C-4126
(ucs-set-char #xC81D ?$(CA'(B) ; KS0-C-4127
(ucs-set-char #xC820 ?$(CA((B) ; KS0-C-4128
(ucs-set-char #xC824 ?$(CA)(B) ; KS0-C-4129
(ucs-set-char #xC82C ?$(CA*(B) ; KS0-C-412A
(ucs-set-char #xC82D ?$(CA+(B) ; KS0-C-412B
(ucs-set-char #xC82F ?$(CA,(B) ; KS0-C-412C
(ucs-set-char #xC831 ?$(CA-(B) ; KS0-C-412D
(ucs-set-char #xC838 ?$(CA.(B) ; KS0-C-412E
(ucs-set-char #xC83C ?$(CA/(B) ; KS0-C-412F
(ucs-set-char #xC840 ?$(CA0(B) ; KS0-C-4130
(ucs-set-char #xC848 ?$(CA1(B) ; KS0-C-4131
(ucs-set-char #xC849 ?$(CA2(B) ; KS0-C-4132
(ucs-set-char #xC84C ?$(CA3(B) ; KS0-C-4133
(ucs-set-char #xC84D ?$(CA4(B) ; KS0-C-4134
(ucs-set-char #xC854 ?$(CA5(B) ; KS0-C-4135
(ucs-set-char #xC870 ?$(CA6(B) ; KS0-C-4136
(ucs-set-char #xC871 ?$(CA7(B) ; KS0-C-4137
(ucs-set-char #xC874 ?$(CA8(B) ; KS0-C-4138
(ucs-set-char #xC878 ?$(CA9(B) ; KS0-C-4139
(ucs-set-char #xC87A ?$(CA:(B) ; KS0-C-413A
(ucs-set-char #xC880 ?$(CA;(B) ; KS0-C-413B
(ucs-set-char #xC881 ?$(CA<(B) ; KS0-C-413C
(ucs-set-char #xC883 ?$(CA=(B) ; KS0-C-413D
(ucs-set-char #xC885 ?$(CA>(B) ; KS0-C-413E
(ucs-set-char #xC886 ?$(CA?(B) ; KS0-C-413F
(ucs-set-char #xC887 ?$(CA@(B) ; KS0-C-4140
(ucs-set-char #xC88B ?$(CAA(B) ; KS0-C-4141
(ucs-set-char #xC88C ?$(CAB(B) ; KS0-C-4142
(ucs-set-char #xC88D ?$(CAC(B) ; KS0-C-4143
(ucs-set-char #xC894 ?$(CAD(B) ; KS0-C-4144
(ucs-set-char #xC89D ?$(CAE(B) ; KS0-C-4145
(ucs-set-char #xC89F ?$(CAF(B) ; KS0-C-4146
(ucs-set-char #xC8A1 ?$(CAG(B) ; KS0-C-4147
(ucs-set-char #xC8A8 ?$(CAH(B) ; KS0-C-4148
(ucs-set-char #xC8BC ?$(CAI(B) ; KS0-C-4149
(ucs-set-char #xC8BD ?$(CAJ(B) ; KS0-C-414A
(ucs-set-char #xC8C4 ?$(CAK(B) ; KS0-C-414B
(ucs-set-char #xC8C8 ?$(CAL(B) ; KS0-C-414C
(ucs-set-char #xC8CC ?$(CAM(B) ; KS0-C-414D
(ucs-set-char #xC8D4 ?$(CAN(B) ; KS0-C-414E
(ucs-set-char #xC8D5 ?$(CAO(B) ; KS0-C-414F
(ucs-set-char #xC8D7 ?$(CAP(B) ; KS0-C-4150
(ucs-set-char #xC8D9 ?$(CAQ(B) ; KS0-C-4151
(ucs-set-char #xC8E0 ?$(CAR(B) ; KS0-C-4152
(ucs-set-char #xC8E1 ?$(CAS(B) ; KS0-C-4153
(ucs-set-char #xC8E4 ?$(CAT(B) ; KS0-C-4154
(ucs-set-char #xC8F5 ?$(CAU(B) ; KS0-C-4155
(ucs-set-char #xC8FC ?$(CAV(B) ; KS0-C-4156
(ucs-set-char #xC8FD ?$(CAW(B) ; KS0-C-4157
(ucs-set-char #xC900 ?$(CAX(B) ; KS0-C-4158
(ucs-set-char #xC904 ?$(CAY(B) ; KS0-C-4159
(ucs-set-char #xC905 ?$(CAZ(B) ; KS0-C-415A
(ucs-set-char #xC906 ?$(CA[(B) ; KS0-C-415B
(ucs-set-char #xC90C ?$(CA\(B) ; KS0-C-415C
(ucs-set-char #xC90D ?$(CA](B) ; KS0-C-415D
(ucs-set-char #xC90F ?$(CA^(B) ; KS0-C-415E
(ucs-set-char #xC911 ?$(CA_(B) ; KS0-C-415F
(ucs-set-char #xC918 ?$(CA`(B) ; KS0-C-4160
(ucs-set-char #xC92C ?$(CAa(B) ; KS0-C-4161
(ucs-set-char #xC934 ?$(CAb(B) ; KS0-C-4162
(ucs-set-char #xC950 ?$(CAc(B) ; KS0-C-4163
(ucs-set-char #xC951 ?$(CAd(B) ; KS0-C-4164
(ucs-set-char #xC954 ?$(CAe(B) ; KS0-C-4165
(ucs-set-char #xC958 ?$(CAf(B) ; KS0-C-4166
(ucs-set-char #xC960 ?$(CAg(B) ; KS0-C-4167
(ucs-set-char #xC961 ?$(CAh(B) ; KS0-C-4168
(ucs-set-char #xC963 ?$(CAi(B) ; KS0-C-4169
(ucs-set-char #xC96C ?$(CAj(B) ; KS0-C-416A
(ucs-set-char #xC970 ?$(CAk(B) ; KS0-C-416B
(ucs-set-char #xC974 ?$(CAl(B) ; KS0-C-416C
(ucs-set-char #xC97C ?$(CAm(B) ; KS0-C-416D
(ucs-set-char #xC988 ?$(CAn(B) ; KS0-C-416E
(ucs-set-char #xC989 ?$(CAo(B) ; KS0-C-416F
(ucs-set-char #xC98C ?$(CAp(B) ; KS0-C-4170
(ucs-set-char #xC990 ?$(CAq(B) ; KS0-C-4171
(ucs-set-char #xC998 ?$(CAr(B) ; KS0-C-4172
(ucs-set-char #xC999 ?$(CAs(B) ; KS0-C-4173
(ucs-set-char #xC99B ?$(CAt(B) ; KS0-C-4174
(ucs-set-char #xC99D ?$(CAu(B) ; KS0-C-4175
(ucs-set-char #xC9C0 ?$(CAv(B) ; KS0-C-4176
(ucs-set-char #xC9C1 ?$(CAw(B) ; KS0-C-4177
(ucs-set-char #xC9C4 ?$(CAx(B) ; KS0-C-4178
(ucs-set-char #xC9C7 ?$(CAy(B) ; KS0-C-4179
(ucs-set-char #xC9C8 ?$(CAz(B) ; KS0-C-417A
(ucs-set-char #xC9CA ?$(CA{(B) ; KS0-C-417B
(ucs-set-char #xC9D0 ?$(CA|(B) ; KS0-C-417C
(ucs-set-char #xC9D1 ?$(CA}(B) ; KS0-C-417D
(ucs-set-char #xC9D3 ?$(CA~(B) ; KS0-C-417E
(ucs-set-char #xC9D5 ?$(CB!(B) ; KS0-C-4221
(ucs-set-char #xC9D6 ?$(CB"(B) ; KS0-C-4222
(ucs-set-char #xC9D9 ?$(CB#(B) ; KS0-C-4223
(ucs-set-char #xC9DA ?$(CB$(B) ; KS0-C-4224
(ucs-set-char #xC9DC ?$(CB%(B) ; KS0-C-4225
(ucs-set-char #xC9DD ?$(CB&(B) ; KS0-C-4226
(ucs-set-char #xC9E0 ?$(CB'(B) ; KS0-C-4227
(ucs-set-char #xC9E2 ?$(CB((B) ; KS0-C-4228
(ucs-set-char #xC9E4 ?$(CB)(B) ; KS0-C-4229
(ucs-set-char #xC9E7 ?$(CB*(B) ; KS0-C-422A
(ucs-set-char #xC9EC ?$(CB+(B) ; KS0-C-422B
(ucs-set-char #xC9ED ?$(CB,(B) ; KS0-C-422C
(ucs-set-char #xC9EF ?$(CB-(B) ; KS0-C-422D
(ucs-set-char #xC9F0 ?$(CB.(B) ; KS0-C-422E
(ucs-set-char #xC9F1 ?$(CB/(B) ; KS0-C-422F
(ucs-set-char #xC9F8 ?$(CB0(B) ; KS0-C-4230
(ucs-set-char #xC9F9 ?$(CB1(B) ; KS0-C-4231
(ucs-set-char #xC9FC ?$(CB2(B) ; KS0-C-4232
(ucs-set-char #xCA00 ?$(CB3(B) ; KS0-C-4233
(ucs-set-char #xCA08 ?$(CB4(B) ; KS0-C-4234
(ucs-set-char #xCA09 ?$(CB5(B) ; KS0-C-4235
(ucs-set-char #xCA0B ?$(CB6(B) ; KS0-C-4236
(ucs-set-char #xCA0C ?$(CB7(B) ; KS0-C-4237
(ucs-set-char #xCA0D ?$(CB8(B) ; KS0-C-4238
(ucs-set-char #xCA14 ?$(CB9(B) ; KS0-C-4239
(ucs-set-char #xCA18 ?$(CB:(B) ; KS0-C-423A
(ucs-set-char #xCA29 ?$(CB;(B) ; KS0-C-423B
(ucs-set-char #xCA4C ?$(CB<(B) ; KS0-C-423C
(ucs-set-char #xCA4D ?$(CB=(B) ; KS0-C-423D
(ucs-set-char #xCA50 ?$(CB>(B) ; KS0-C-423E
(ucs-set-char #xCA54 ?$(CB?(B) ; KS0-C-423F
(ucs-set-char #xCA5C ?$(CB@(B) ; KS0-C-4240
(ucs-set-char #xCA5D ?$(CBA(B) ; KS0-C-4241
(ucs-set-char #xCA5F ?$(CBB(B) ; KS0-C-4242
(ucs-set-char #xCA60 ?$(CBC(B) ; KS0-C-4243
(ucs-set-char #xCA61 ?$(CBD(B) ; KS0-C-4244
(ucs-set-char #xCA68 ?$(CBE(B) ; KS0-C-4245
(ucs-set-char #xCA7D ?$(CBF(B) ; KS0-C-4246
(ucs-set-char #xCA84 ?$(CBG(B) ; KS0-C-4247
(ucs-set-char #xCA98 ?$(CBH(B) ; KS0-C-4248
(ucs-set-char #xCABC ?$(CBI(B) ; KS0-C-4249
(ucs-set-char #xCABD ?$(CBJ(B) ; KS0-C-424A
(ucs-set-char #xCAC0 ?$(CBK(B) ; KS0-C-424B
(ucs-set-char #xCAC4 ?$(CBL(B) ; KS0-C-424C
(ucs-set-char #xCACC ?$(CBM(B) ; KS0-C-424D
(ucs-set-char #xCACD ?$(CBN(B) ; KS0-C-424E
(ucs-set-char #xCACF ?$(CBO(B) ; KS0-C-424F
(ucs-set-char #xCAD1 ?$(CBP(B) ; KS0-C-4250
(ucs-set-char #xCAD3 ?$(CBQ(B) ; KS0-C-4251
(ucs-set-char #xCAD8 ?$(CBR(B) ; KS0-C-4252
(ucs-set-char #xCAD9 ?$(CBS(B) ; KS0-C-4253
(ucs-set-char #xCAE0 ?$(CBT(B) ; KS0-C-4254
(ucs-set-char #xCAEC ?$(CBU(B) ; KS0-C-4255
(ucs-set-char #xCAF4 ?$(CBV(B) ; KS0-C-4256
(ucs-set-char #xCB08 ?$(CBW(B) ; KS0-C-4257
(ucs-set-char #xCB10 ?$(CBX(B) ; KS0-C-4258
(ucs-set-char #xCB14 ?$(CBY(B) ; KS0-C-4259
(ucs-set-char #xCB18 ?$(CBZ(B) ; KS0-C-425A
(ucs-set-char #xCB20 ?$(CB[(B) ; KS0-C-425B
(ucs-set-char #xCB21 ?$(CB\(B) ; KS0-C-425C
(ucs-set-char #xCB41 ?$(CB](B) ; KS0-C-425D
(ucs-set-char #xCB48 ?$(CB^(B) ; KS0-C-425E
(ucs-set-char #xCB49 ?$(CB_(B) ; KS0-C-425F
(ucs-set-char #xCB4C ?$(CB`(B) ; KS0-C-4260
(ucs-set-char #xCB50 ?$(CBa(B) ; KS0-C-4261
(ucs-set-char #xCB58 ?$(CBb(B) ; KS0-C-4262
(ucs-set-char #xCB59 ?$(CBc(B) ; KS0-C-4263
(ucs-set-char #xCB5D ?$(CBd(B) ; KS0-C-4264
(ucs-set-char #xCB64 ?$(CBe(B) ; KS0-C-4265
(ucs-set-char #xCB78 ?$(CBf(B) ; KS0-C-4266
(ucs-set-char #xCB79 ?$(CBg(B) ; KS0-C-4267
(ucs-set-char #xCB9C ?$(CBh(B) ; KS0-C-4268
(ucs-set-char #xCBB8 ?$(CBi(B) ; KS0-C-4269
(ucs-set-char #xCBD4 ?$(CBj(B) ; KS0-C-426A
(ucs-set-char #xCBE4 ?$(CBk(B) ; KS0-C-426B
(ucs-set-char #xCBE7 ?$(CBl(B) ; KS0-C-426C
(ucs-set-char #xCBE9 ?$(CBm(B) ; KS0-C-426D
(ucs-set-char #xCC0C ?$(CBn(B) ; KS0-C-426E
(ucs-set-char #xCC0D ?$(CBo(B) ; KS0-C-426F
(ucs-set-char #xCC10 ?$(CBp(B) ; KS0-C-4270
(ucs-set-char #xCC14 ?$(CBq(B) ; KS0-C-4271
(ucs-set-char #xCC1C ?$(CBr(B) ; KS0-C-4272
(ucs-set-char #xCC1D ?$(CBs(B) ; KS0-C-4273
(ucs-set-char #xCC21 ?$(CBt(B) ; KS0-C-4274
(ucs-set-char #xCC22 ?$(CBu(B) ; KS0-C-4275
(ucs-set-char #xCC27 ?$(CBv(B) ; KS0-C-4276
(ucs-set-char #xCC28 ?$(CBw(B) ; KS0-C-4277
(ucs-set-char #xCC29 ?$(CBx(B) ; KS0-C-4278
(ucs-set-char #xCC2C ?$(CBy(B) ; KS0-C-4279
(ucs-set-char #xCC2E ?$(CBz(B) ; KS0-C-427A
(ucs-set-char #xCC30 ?$(CB{(B) ; KS0-C-427B
(ucs-set-char #xCC38 ?$(CB|(B) ; KS0-C-427C
(ucs-set-char #xCC39 ?$(CB}(B) ; KS0-C-427D
(ucs-set-char #xCC3B ?$(CB~(B) ; KS0-C-427E
(ucs-set-char #xCC3C ?$(CC!(B) ; KS0-C-4321
(ucs-set-char #xCC3D ?$(CC"(B) ; KS0-C-4322
(ucs-set-char #xCC3E ?$(CC#(B) ; KS0-C-4323
(ucs-set-char #xCC44 ?$(CC$(B) ; KS0-C-4324
(ucs-set-char #xCC45 ?$(CC%(B) ; KS0-C-4325
(ucs-set-char #xCC48 ?$(CC&(B) ; KS0-C-4326
(ucs-set-char #xCC4C ?$(CC'(B) ; KS0-C-4327
(ucs-set-char #xCC54 ?$(CC((B) ; KS0-C-4328
(ucs-set-char #xCC55 ?$(CC)(B) ; KS0-C-4329
(ucs-set-char #xCC57 ?$(CC*(B) ; KS0-C-432A
(ucs-set-char #xCC58 ?$(CC+(B) ; KS0-C-432B
(ucs-set-char #xCC59 ?$(CC,(B) ; KS0-C-432C
(ucs-set-char #xCC60 ?$(CC-(B) ; KS0-C-432D
(ucs-set-char #xCC64 ?$(CC.(B) ; KS0-C-432E
(ucs-set-char #xCC66 ?$(CC/(B) ; KS0-C-432F
(ucs-set-char #xCC68 ?$(CC0(B) ; KS0-C-4330
(ucs-set-char #xCC70 ?$(CC1(B) ; KS0-C-4331
(ucs-set-char #xCC75 ?$(CC2(B) ; KS0-C-4332
(ucs-set-char #xCC98 ?$(CC3(B) ; KS0-C-4333
(ucs-set-char #xCC99 ?$(CC4(B) ; KS0-C-4334
(ucs-set-char #xCC9C ?$(CC5(B) ; KS0-C-4335
(ucs-set-char #xCCA0 ?$(CC6(B) ; KS0-C-4336
(ucs-set-char #xCCA8 ?$(CC7(B) ; KS0-C-4337
(ucs-set-char #xCCA9 ?$(CC8(B) ; KS0-C-4338
(ucs-set-char #xCCAB ?$(CC9(B) ; KS0-C-4339
(ucs-set-char #xCCAC ?$(CC:(B) ; KS0-C-433A
(ucs-set-char #xCCAD ?$(CC;(B) ; KS0-C-433B
(ucs-set-char #xCCB4 ?$(CC<(B) ; KS0-C-433C
(ucs-set-char #xCCB5 ?$(CC=(B) ; KS0-C-433D
(ucs-set-char #xCCB8 ?$(CC>(B) ; KS0-C-433E
(ucs-set-char #xCCBC ?$(CC?(B) ; KS0-C-433F
(ucs-set-char #xCCC4 ?$(CC@(B) ; KS0-C-4340
(ucs-set-char #xCCC5 ?$(CCA(B) ; KS0-C-4341
(ucs-set-char #xCCC7 ?$(CCB(B) ; KS0-C-4342
(ucs-set-char #xCCC9 ?$(CCC(B) ; KS0-C-4343
(ucs-set-char #xCCD0 ?$(CCD(B) ; KS0-C-4344
(ucs-set-char #xCCD4 ?$(CCE(B) ; KS0-C-4345
(ucs-set-char #xCCE4 ?$(CCF(B) ; KS0-C-4346
(ucs-set-char #xCCEC ?$(CCG(B) ; KS0-C-4347
(ucs-set-char #xCCF0 ?$(CCH(B) ; KS0-C-4348
(ucs-set-char #xCD01 ?$(CCI(B) ; KS0-C-4349
(ucs-set-char #xCD08 ?$(CCJ(B) ; KS0-C-434A
(ucs-set-char #xCD09 ?$(CCK(B) ; KS0-C-434B
(ucs-set-char #xCD0C ?$(CCL(B) ; KS0-C-434C
(ucs-set-char #xCD10 ?$(CCM(B) ; KS0-C-434D
(ucs-set-char #xCD18 ?$(CCN(B) ; KS0-C-434E
(ucs-set-char #xCD19 ?$(CCO(B) ; KS0-C-434F
(ucs-set-char #xCD1B ?$(CCP(B) ; KS0-C-4350
(ucs-set-char #xCD1D ?$(CCQ(B) ; KS0-C-4351
(ucs-set-char #xCD24 ?$(CCR(B) ; KS0-C-4352
(ucs-set-char #xCD28 ?$(CCS(B) ; KS0-C-4353
(ucs-set-char #xCD2C ?$(CCT(B) ; KS0-C-4354
(ucs-set-char #xCD39 ?$(CCU(B) ; KS0-C-4355
(ucs-set-char #xCD5C ?$(CCV(B) ; KS0-C-4356
(ucs-set-char #xCD60 ?$(CCW(B) ; KS0-C-4357
(ucs-set-char #xCD64 ?$(CCX(B) ; KS0-C-4358
(ucs-set-char #xCD6C ?$(CCY(B) ; KS0-C-4359
(ucs-set-char #xCD6D ?$(CCZ(B) ; KS0-C-435A
(ucs-set-char #xCD6F ?$(CC[(B) ; KS0-C-435B
(ucs-set-char #xCD71 ?$(CC\(B) ; KS0-C-435C
(ucs-set-char #xCD78 ?$(CC](B) ; KS0-C-435D
(ucs-set-char #xCD88 ?$(CC^(B) ; KS0-C-435E
(ucs-set-char #xCD94 ?$(CC_(B) ; KS0-C-435F
(ucs-set-char #xCD95 ?$(CC`(B) ; KS0-C-4360
(ucs-set-char #xCD98 ?$(CCa(B) ; KS0-C-4361
(ucs-set-char #xCD9C ?$(CCb(B) ; KS0-C-4362
(ucs-set-char #xCDA4 ?$(CCc(B) ; KS0-C-4363
(ucs-set-char #xCDA5 ?$(CCd(B) ; KS0-C-4364
(ucs-set-char #xCDA7 ?$(CCe(B) ; KS0-C-4365
(ucs-set-char #xCDA9 ?$(CCf(B) ; KS0-C-4366
(ucs-set-char #xCDB0 ?$(CCg(B) ; KS0-C-4367
(ucs-set-char #xCDC4 ?$(CCh(B) ; KS0-C-4368
(ucs-set-char #xCDCC ?$(CCi(B) ; KS0-C-4369
(ucs-set-char #xCDD0 ?$(CCj(B) ; KS0-C-436A
(ucs-set-char #xCDE8 ?$(CCk(B) ; KS0-C-436B
(ucs-set-char #xCDEC ?$(CCl(B) ; KS0-C-436C
(ucs-set-char #xCDF0 ?$(CCm(B) ; KS0-C-436D
(ucs-set-char #xCDF8 ?$(CCn(B) ; KS0-C-436E
(ucs-set-char #xCDF9 ?$(CCo(B) ; KS0-C-436F
(ucs-set-char #xCDFB ?$(CCp(B) ; KS0-C-4370
(ucs-set-char #xCDFD ?$(CCq(B) ; KS0-C-4371
(ucs-set-char #xCE04 ?$(CCr(B) ; KS0-C-4372
(ucs-set-char #xCE08 ?$(CCs(B) ; KS0-C-4373
(ucs-set-char #xCE0C ?$(CCt(B) ; KS0-C-4374
(ucs-set-char #xCE14 ?$(CCu(B) ; KS0-C-4375
(ucs-set-char #xCE19 ?$(CCv(B) ; KS0-C-4376
(ucs-set-char #xCE20 ?$(CCw(B) ; KS0-C-4377
(ucs-set-char #xCE21 ?$(CCx(B) ; KS0-C-4378
(ucs-set-char #xCE24 ?$(CCy(B) ; KS0-C-4379
(ucs-set-char #xCE28 ?$(CCz(B) ; KS0-C-437A
(ucs-set-char #xCE30 ?$(CC{(B) ; KS0-C-437B
(ucs-set-char #xCE31 ?$(CC|(B) ; KS0-C-437C
(ucs-set-char #xCE33 ?$(CC}(B) ; KS0-C-437D
(ucs-set-char #xCE35 ?$(CC~(B) ; KS0-C-437E
(ucs-set-char #xCE58 ?$(CD!(B) ; KS0-C-4421
(ucs-set-char #xCE59 ?$(CD"(B) ; KS0-C-4422
(ucs-set-char #xCE5C ?$(CD#(B) ; KS0-C-4423
(ucs-set-char #xCE5F ?$(CD$(B) ; KS0-C-4424
(ucs-set-char #xCE60 ?$(CD%(B) ; KS0-C-4425
(ucs-set-char #xCE61 ?$(CD&(B) ; KS0-C-4426
(ucs-set-char #xCE68 ?$(CD'(B) ; KS0-C-4427
(ucs-set-char #xCE69 ?$(CD((B) ; KS0-C-4428
(ucs-set-char #xCE6B ?$(CD)(B) ; KS0-C-4429
(ucs-set-char #xCE6D ?$(CD*(B) ; KS0-C-442A
(ucs-set-char #xCE74 ?$(CD+(B) ; KS0-C-442B
(ucs-set-char #xCE75 ?$(CD,(B) ; KS0-C-442C
(ucs-set-char #xCE78 ?$(CD-(B) ; KS0-C-442D
(ucs-set-char #xCE7C ?$(CD.(B) ; KS0-C-442E
(ucs-set-char #xCE84 ?$(CD/(B) ; KS0-C-442F
(ucs-set-char #xCE85 ?$(CD0(B) ; KS0-C-4430
(ucs-set-char #xCE87 ?$(CD1(B) ; KS0-C-4431
(ucs-set-char #xCE89 ?$(CD2(B) ; KS0-C-4432
(ucs-set-char #xCE90 ?$(CD3(B) ; KS0-C-4433
(ucs-set-char #xCE91 ?$(CD4(B) ; KS0-C-4434
(ucs-set-char #xCE94 ?$(CD5(B) ; KS0-C-4435
(ucs-set-char #xCE98 ?$(CD6(B) ; KS0-C-4436
(ucs-set-char #xCEA0 ?$(CD7(B) ; KS0-C-4437
(ucs-set-char #xCEA1 ?$(CD8(B) ; KS0-C-4438
(ucs-set-char #xCEA3 ?$(CD9(B) ; KS0-C-4439
(ucs-set-char #xCEA4 ?$(CD:(B) ; KS0-C-443A
(ucs-set-char #xCEA5 ?$(CD;(B) ; KS0-C-443B
(ucs-set-char #xCEAC ?$(CD<(B) ; KS0-C-443C
(ucs-set-char #xCEAD ?$(CD=(B) ; KS0-C-443D
(ucs-set-char #xCEC1 ?$(CD>(B) ; KS0-C-443E
(ucs-set-char #xCEE4 ?$(CD?(B) ; KS0-C-443F
(ucs-set-char #xCEE5 ?$(CD@(B) ; KS0-C-4440
(ucs-set-char #xCEE8 ?$(CDA(B) ; KS0-C-4441
(ucs-set-char #xCEEB ?$(CDB(B) ; KS0-C-4442
(ucs-set-char #xCEEC ?$(CDC(B) ; KS0-C-4443
(ucs-set-char #xCEF4 ?$(CDD(B) ; KS0-C-4444
(ucs-set-char #xCEF5 ?$(CDE(B) ; KS0-C-4445
(ucs-set-char #xCEF7 ?$(CDF(B) ; KS0-C-4446
(ucs-set-char #xCEF8 ?$(CDG(B) ; KS0-C-4447
(ucs-set-char #xCEF9 ?$(CDH(B) ; KS0-C-4448
(ucs-set-char #xCF00 ?$(CDI(B) ; KS0-C-4449
(ucs-set-char #xCF01 ?$(CDJ(B) ; KS0-C-444A
(ucs-set-char #xCF04 ?$(CDK(B) ; KS0-C-444B
(ucs-set-char #xCF08 ?$(CDL(B) ; KS0-C-444C
(ucs-set-char #xCF10 ?$(CDM(B) ; KS0-C-444D
(ucs-set-char #xCF11 ?$(CDN(B) ; KS0-C-444E
(ucs-set-char #xCF13 ?$(CDO(B) ; KS0-C-444F
(ucs-set-char #xCF15 ?$(CDP(B) ; KS0-C-4450
(ucs-set-char #xCF1C ?$(CDQ(B) ; KS0-C-4451
(ucs-set-char #xCF20 ?$(CDR(B) ; KS0-C-4452
(ucs-set-char #xCF24 ?$(CDS(B) ; KS0-C-4453
(ucs-set-char #xCF2C ?$(CDT(B) ; KS0-C-4454
(ucs-set-char #xCF2D ?$(CDU(B) ; KS0-C-4455
(ucs-set-char #xCF2F ?$(CDV(B) ; KS0-C-4456
(ucs-set-char #xCF30 ?$(CDW(B) ; KS0-C-4457
(ucs-set-char #xCF31 ?$(CDX(B) ; KS0-C-4458
(ucs-set-char #xCF38 ?$(CDY(B) ; KS0-C-4459
(ucs-set-char #xCF54 ?$(CDZ(B) ; KS0-C-445A
(ucs-set-char #xCF55 ?$(CD[(B) ; KS0-C-445B
(ucs-set-char #xCF58 ?$(CD\(B) ; KS0-C-445C
(ucs-set-char #xCF5C ?$(CD](B) ; KS0-C-445D
(ucs-set-char #xCF64 ?$(CD^(B) ; KS0-C-445E
(ucs-set-char #xCF65 ?$(CD_(B) ; KS0-C-445F
(ucs-set-char #xCF67 ?$(CD`(B) ; KS0-C-4460
(ucs-set-char #xCF69 ?$(CDa(B) ; KS0-C-4461
(ucs-set-char #xCF70 ?$(CDb(B) ; KS0-C-4462
(ucs-set-char #xCF71 ?$(CDc(B) ; KS0-C-4463
(ucs-set-char #xCF74 ?$(CDd(B) ; KS0-C-4464
(ucs-set-char #xCF78 ?$(CDe(B) ; KS0-C-4465
(ucs-set-char #xCF80 ?$(CDf(B) ; KS0-C-4466
(ucs-set-char #xCF85 ?$(CDg(B) ; KS0-C-4467
(ucs-set-char #xCF8C ?$(CDh(B) ; KS0-C-4468
(ucs-set-char #xCFA1 ?$(CDi(B) ; KS0-C-4469
(ucs-set-char #xCFA8 ?$(CDj(B) ; KS0-C-446A
(ucs-set-char #xCFB0 ?$(CDk(B) ; KS0-C-446B
(ucs-set-char #xCFC4 ?$(CDl(B) ; KS0-C-446C
(ucs-set-char #xCFE0 ?$(CDm(B) ; KS0-C-446D
(ucs-set-char #xCFE1 ?$(CDn(B) ; KS0-C-446E
(ucs-set-char #xCFE4 ?$(CDo(B) ; KS0-C-446F
(ucs-set-char #xCFE8 ?$(CDp(B) ; KS0-C-4470
(ucs-set-char #xCFF0 ?$(CDq(B) ; KS0-C-4471
(ucs-set-char #xCFF1 ?$(CDr(B) ; KS0-C-4472
(ucs-set-char #xCFF3 ?$(CDs(B) ; KS0-C-4473
(ucs-set-char #xCFF5 ?$(CDt(B) ; KS0-C-4474
(ucs-set-char #xCFFC ?$(CDu(B) ; KS0-C-4475
(ucs-set-char #xD000 ?$(CDv(B) ; KS0-C-4476
(ucs-set-char #xD004 ?$(CDw(B) ; KS0-C-4477
(ucs-set-char #xD011 ?$(CDx(B) ; KS0-C-4478
(ucs-set-char #xD018 ?$(CDy(B) ; KS0-C-4479
(ucs-set-char #xD02D ?$(CDz(B) ; KS0-C-447A
(ucs-set-char #xD034 ?$(CD{(B) ; KS0-C-447B
(ucs-set-char #xD035 ?$(CD|(B) ; KS0-C-447C
(ucs-set-char #xD038 ?$(CD}(B) ; KS0-C-447D
(ucs-set-char #xD03C ?$(CD~(B) ; KS0-C-447E
(ucs-set-char #xD044 ?$(CE!(B) ; KS0-C-4521
(ucs-set-char #xD045 ?$(CE"(B) ; KS0-C-4522
(ucs-set-char #xD047 ?$(CE#(B) ; KS0-C-4523
(ucs-set-char #xD049 ?$(CE$(B) ; KS0-C-4524
(ucs-set-char #xD050 ?$(CE%(B) ; KS0-C-4525
(ucs-set-char #xD054 ?$(CE&(B) ; KS0-C-4526
(ucs-set-char #xD058 ?$(CE'(B) ; KS0-C-4527
(ucs-set-char #xD060 ?$(CE((B) ; KS0-C-4528
(ucs-set-char #xD06C ?$(CE)(B) ; KS0-C-4529
(ucs-set-char #xD06D ?$(CE*(B) ; KS0-C-452A
(ucs-set-char #xD070 ?$(CE+(B) ; KS0-C-452B
(ucs-set-char #xD074 ?$(CE,(B) ; KS0-C-452C
(ucs-set-char #xD07C ?$(CE-(B) ; KS0-C-452D
(ucs-set-char #xD07D ?$(CE.(B) ; KS0-C-452E
(ucs-set-char #xD081 ?$(CE/(B) ; KS0-C-452F
(ucs-set-char #xD0A4 ?$(CE0(B) ; KS0-C-4530
(ucs-set-char #xD0A5 ?$(CE1(B) ; KS0-C-4531
(ucs-set-char #xD0A8 ?$(CE2(B) ; KS0-C-4532
(ucs-set-char #xD0AC ?$(CE3(B) ; KS0-C-4533
(ucs-set-char #xD0B4 ?$(CE4(B) ; KS0-C-4534
(ucs-set-char #xD0B5 ?$(CE5(B) ; KS0-C-4535
(ucs-set-char #xD0B7 ?$(CE6(B) ; KS0-C-4536
(ucs-set-char #xD0B9 ?$(CE7(B) ; KS0-C-4537
(ucs-set-char #xD0C0 ?$(CE8(B) ; KS0-C-4538
(ucs-set-char #xD0C1 ?$(CE9(B) ; KS0-C-4539
(ucs-set-char #xD0C4 ?$(CE:(B) ; KS0-C-453A
(ucs-set-char #xD0C8 ?$(CE;(B) ; KS0-C-453B
(ucs-set-char #xD0C9 ?$(CE<(B) ; KS0-C-453C
(ucs-set-char #xD0D0 ?$(CE=(B) ; KS0-C-453D
(ucs-set-char #xD0D1 ?$(CE>(B) ; KS0-C-453E
(ucs-set-char #xD0D3 ?$(CE?(B) ; KS0-C-453F
(ucs-set-char #xD0D4 ?$(CE@(B) ; KS0-C-4540
(ucs-set-char #xD0D5 ?$(CEA(B) ; KS0-C-4541
(ucs-set-char #xD0DC ?$(CEB(B) ; KS0-C-4542
(ucs-set-char #xD0DD ?$(CEC(B) ; KS0-C-4543
(ucs-set-char #xD0E0 ?$(CED(B) ; KS0-C-4544
(ucs-set-char #xD0E4 ?$(CEE(B) ; KS0-C-4545
(ucs-set-char #xD0EC ?$(CEF(B) ; KS0-C-4546
(ucs-set-char #xD0ED ?$(CEG(B) ; KS0-C-4547
(ucs-set-char #xD0EF ?$(CEH(B) ; KS0-C-4548
(ucs-set-char #xD0F0 ?$(CEI(B) ; KS0-C-4549
(ucs-set-char #xD0F1 ?$(CEJ(B) ; KS0-C-454A
(ucs-set-char #xD0F8 ?$(CEK(B) ; KS0-C-454B
(ucs-set-char #xD10D ?$(CEL(B) ; KS0-C-454C
(ucs-set-char #xD130 ?$(CEM(B) ; KS0-C-454D
(ucs-set-char #xD131 ?$(CEN(B) ; KS0-C-454E
(ucs-set-char #xD134 ?$(CEO(B) ; KS0-C-454F
(ucs-set-char #xD138 ?$(CEP(B) ; KS0-C-4550
(ucs-set-char #xD13A ?$(CEQ(B) ; KS0-C-4551
(ucs-set-char #xD140 ?$(CER(B) ; KS0-C-4552
(ucs-set-char #xD141 ?$(CES(B) ; KS0-C-4553
(ucs-set-char #xD143 ?$(CET(B) ; KS0-C-4554
(ucs-set-char #xD144 ?$(CEU(B) ; KS0-C-4555
(ucs-set-char #xD145 ?$(CEV(B) ; KS0-C-4556
(ucs-set-char #xD14C ?$(CEW(B) ; KS0-C-4557
(ucs-set-char #xD14D ?$(CEX(B) ; KS0-C-4558
(ucs-set-char #xD150 ?$(CEY(B) ; KS0-C-4559
(ucs-set-char #xD154 ?$(CEZ(B) ; KS0-C-455A
(ucs-set-char #xD15C ?$(CE[(B) ; KS0-C-455B
(ucs-set-char #xD15D ?$(CE\(B) ; KS0-C-455C
(ucs-set-char #xD15F ?$(CE](B) ; KS0-C-455D
(ucs-set-char #xD161 ?$(CE^(B) ; KS0-C-455E
(ucs-set-char #xD168 ?$(CE_(B) ; KS0-C-455F
(ucs-set-char #xD16C ?$(CE`(B) ; KS0-C-4560
(ucs-set-char #xD17C ?$(CEa(B) ; KS0-C-4561
(ucs-set-char #xD184 ?$(CEb(B) ; KS0-C-4562
(ucs-set-char #xD188 ?$(CEc(B) ; KS0-C-4563
(ucs-set-char #xD1A0 ?$(CEd(B) ; KS0-C-4564
(ucs-set-char #xD1A1 ?$(CEe(B) ; KS0-C-4565
(ucs-set-char #xD1A4 ?$(CEf(B) ; KS0-C-4566
(ucs-set-char #xD1A8 ?$(CEg(B) ; KS0-C-4567
(ucs-set-char #xD1B0 ?$(CEh(B) ; KS0-C-4568
(ucs-set-char #xD1B1 ?$(CEi(B) ; KS0-C-4569
(ucs-set-char #xD1B3 ?$(CEj(B) ; KS0-C-456A
(ucs-set-char #xD1B5 ?$(CEk(B) ; KS0-C-456B
(ucs-set-char #xD1BA ?$(CEl(B) ; KS0-C-456C
(ucs-set-char #xD1BC ?$(CEm(B) ; KS0-C-456D
(ucs-set-char #xD1C0 ?$(CEn(B) ; KS0-C-456E
(ucs-set-char #xD1D8 ?$(CEo(B) ; KS0-C-456F
(ucs-set-char #xD1F4 ?$(CEp(B) ; KS0-C-4570
(ucs-set-char #xD1F8 ?$(CEq(B) ; KS0-C-4571
(ucs-set-char #xD207 ?$(CEr(B) ; KS0-C-4572
(ucs-set-char #xD209 ?$(CEs(B) ; KS0-C-4573
(ucs-set-char #xD210 ?$(CEt(B) ; KS0-C-4574
(ucs-set-char #xD22C ?$(CEu(B) ; KS0-C-4575
(ucs-set-char #xD22D ?$(CEv(B) ; KS0-C-4576
(ucs-set-char #xD230 ?$(CEw(B) ; KS0-C-4577
(ucs-set-char #xD234 ?$(CEx(B) ; KS0-C-4578
(ucs-set-char #xD23C ?$(CEy(B) ; KS0-C-4579
(ucs-set-char #xD23D ?$(CEz(B) ; KS0-C-457A
(ucs-set-char #xD23F ?$(CE{(B) ; KS0-C-457B
(ucs-set-char #xD241 ?$(CE|(B) ; KS0-C-457C
(ucs-set-char #xD248 ?$(CE}(B) ; KS0-C-457D
(ucs-set-char #xD25C ?$(CE~(B) ; KS0-C-457E
(ucs-set-char #xD264 ?$(CF!(B) ; KS0-C-4621
(ucs-set-char #xD280 ?$(CF"(B) ; KS0-C-4622
(ucs-set-char #xD281 ?$(CF#(B) ; KS0-C-4623
(ucs-set-char #xD284 ?$(CF$(B) ; KS0-C-4624
(ucs-set-char #xD288 ?$(CF%(B) ; KS0-C-4625
(ucs-set-char #xD290 ?$(CF&(B) ; KS0-C-4626
(ucs-set-char #xD291 ?$(CF'(B) ; KS0-C-4627
(ucs-set-char #xD295 ?$(CF((B) ; KS0-C-4628
(ucs-set-char #xD29C ?$(CF)(B) ; KS0-C-4629
(ucs-set-char #xD2A0 ?$(CF*(B) ; KS0-C-462A
(ucs-set-char #xD2A4 ?$(CF+(B) ; KS0-C-462B
(ucs-set-char #xD2AC ?$(CF,(B) ; KS0-C-462C
(ucs-set-char #xD2B1 ?$(CF-(B) ; KS0-C-462D
(ucs-set-char #xD2B8 ?$(CF.(B) ; KS0-C-462E
(ucs-set-char #xD2B9 ?$(CF/(B) ; KS0-C-462F
(ucs-set-char #xD2BC ?$(CF0(B) ; KS0-C-4630
(ucs-set-char #xD2BF ?$(CF1(B) ; KS0-C-4631
(ucs-set-char #xD2C0 ?$(CF2(B) ; KS0-C-4632
(ucs-set-char #xD2C2 ?$(CF3(B) ; KS0-C-4633
(ucs-set-char #xD2C8 ?$(CF4(B) ; KS0-C-4634
(ucs-set-char #xD2C9 ?$(CF5(B) ; KS0-C-4635
(ucs-set-char #xD2CB ?$(CF6(B) ; KS0-C-4636
(ucs-set-char #xD2D4 ?$(CF7(B) ; KS0-C-4637
(ucs-set-char #xD2D8 ?$(CF8(B) ; KS0-C-4638
(ucs-set-char #xD2DC ?$(CF9(B) ; KS0-C-4639
(ucs-set-char #xD2E4 ?$(CF:(B) ; KS0-C-463A
(ucs-set-char #xD2E5 ?$(CF;(B) ; KS0-C-463B
(ucs-set-char #xD2F0 ?$(CF<(B) ; KS0-C-463C
(ucs-set-char #xD2F1 ?$(CF=(B) ; KS0-C-463D
(ucs-set-char #xD2F4 ?$(CF>(B) ; KS0-C-463E
(ucs-set-char #xD2F8 ?$(CF?(B) ; KS0-C-463F
(ucs-set-char #xD300 ?$(CF@(B) ; KS0-C-4640
(ucs-set-char #xD301 ?$(CFA(B) ; KS0-C-4641
(ucs-set-char #xD303 ?$(CFB(B) ; KS0-C-4642
(ucs-set-char #xD305 ?$(CFC(B) ; KS0-C-4643
(ucs-set-char #xD30C ?$(CFD(B) ; KS0-C-4644
(ucs-set-char #xD30D ?$(CFE(B) ; KS0-C-4645
(ucs-set-char #xD30E ?$(CFF(B) ; KS0-C-4646
(ucs-set-char #xD310 ?$(CFG(B) ; KS0-C-4647
(ucs-set-char #xD314 ?$(CFH(B) ; KS0-C-4648
(ucs-set-char #xD316 ?$(CFI(B) ; KS0-C-4649
(ucs-set-char #xD31C ?$(CFJ(B) ; KS0-C-464A
(ucs-set-char #xD31D ?$(CFK(B) ; KS0-C-464B
(ucs-set-char #xD31F ?$(CFL(B) ; KS0-C-464C
(ucs-set-char #xD320 ?$(CFM(B) ; KS0-C-464D
(ucs-set-char #xD321 ?$(CFN(B) ; KS0-C-464E
(ucs-set-char #xD325 ?$(CFO(B) ; KS0-C-464F
(ucs-set-char #xD328 ?$(CFP(B) ; KS0-C-4650
(ucs-set-char #xD329 ?$(CFQ(B) ; KS0-C-4651
(ucs-set-char #xD32C ?$(CFR(B) ; KS0-C-4652
(ucs-set-char #xD330 ?$(CFS(B) ; KS0-C-4653
(ucs-set-char #xD338 ?$(CFT(B) ; KS0-C-4654
(ucs-set-char #xD339 ?$(CFU(B) ; KS0-C-4655
(ucs-set-char #xD33B ?$(CFV(B) ; KS0-C-4656
(ucs-set-char #xD33C ?$(CFW(B) ; KS0-C-4657
(ucs-set-char #xD33D ?$(CFX(B) ; KS0-C-4658
(ucs-set-char #xD344 ?$(CFY(B) ; KS0-C-4659
(ucs-set-char #xD345 ?$(CFZ(B) ; KS0-C-465A
(ucs-set-char #xD37C ?$(CF[(B) ; KS0-C-465B
(ucs-set-char #xD37D ?$(CF\(B) ; KS0-C-465C
(ucs-set-char #xD380 ?$(CF](B) ; KS0-C-465D
(ucs-set-char #xD384 ?$(CF^(B) ; KS0-C-465E
(ucs-set-char #xD38C ?$(CF_(B) ; KS0-C-465F
(ucs-set-char #xD38D ?$(CF`(B) ; KS0-C-4660
(ucs-set-char #xD38F ?$(CFa(B) ; KS0-C-4661
(ucs-set-char #xD390 ?$(CFb(B) ; KS0-C-4662
(ucs-set-char #xD391 ?$(CFc(B) ; KS0-C-4663
(ucs-set-char #xD398 ?$(CFd(B) ; KS0-C-4664
(ucs-set-char #xD399 ?$(CFe(B) ; KS0-C-4665
(ucs-set-char #xD39C ?$(CFf(B) ; KS0-C-4666
(ucs-set-char #xD3A0 ?$(CFg(B) ; KS0-C-4667
(ucs-set-char #xD3A8 ?$(CFh(B) ; KS0-C-4668
(ucs-set-char #xD3A9 ?$(CFi(B) ; KS0-C-4669
(ucs-set-char #xD3AB ?$(CFj(B) ; KS0-C-466A
(ucs-set-char #xD3AD ?$(CFk(B) ; KS0-C-466B
(ucs-set-char #xD3B4 ?$(CFl(B) ; KS0-C-466C
(ucs-set-char #xD3B8 ?$(CFm(B) ; KS0-C-466D
(ucs-set-char #xD3BC ?$(CFn(B) ; KS0-C-466E
(ucs-set-char #xD3C4 ?$(CFo(B) ; KS0-C-466F
(ucs-set-char #xD3C5 ?$(CFp(B) ; KS0-C-4670
(ucs-set-char #xD3C8 ?$(CFq(B) ; KS0-C-4671
(ucs-set-char #xD3C9 ?$(CFr(B) ; KS0-C-4672
(ucs-set-char #xD3D0 ?$(CFs(B) ; KS0-C-4673
(ucs-set-char #xD3D8 ?$(CFt(B) ; KS0-C-4674
(ucs-set-char #xD3E1 ?$(CFu(B) ; KS0-C-4675
(ucs-set-char #xD3E3 ?$(CFv(B) ; KS0-C-4676
(ucs-set-char #xD3EC ?$(CFw(B) ; KS0-C-4677
(ucs-set-char #xD3ED ?$(CFx(B) ; KS0-C-4678
(ucs-set-char #xD3F0 ?$(CFy(B) ; KS0-C-4679
(ucs-set-char #xD3F4 ?$(CFz(B) ; KS0-C-467A
(ucs-set-char #xD3FC ?$(CF{(B) ; KS0-C-467B
(ucs-set-char #xD3FD ?$(CF|(B) ; KS0-C-467C
(ucs-set-char #xD3FF ?$(CF}(B) ; KS0-C-467D
(ucs-set-char #xD401 ?$(CF~(B) ; KS0-C-467E
(ucs-set-char #xD408 ?$(CG!(B) ; KS0-C-4721
(ucs-set-char #xD41D ?$(CG"(B) ; KS0-C-4722
(ucs-set-char #xD440 ?$(CG#(B) ; KS0-C-4723
(ucs-set-char #xD444 ?$(CG$(B) ; KS0-C-4724
(ucs-set-char #xD45C ?$(CG%(B) ; KS0-C-4725
(ucs-set-char #xD460 ?$(CG&(B) ; KS0-C-4726
(ucs-set-char #xD464 ?$(CG'(B) ; KS0-C-4727
(ucs-set-char #xD46D ?$(CG((B) ; KS0-C-4728
(ucs-set-char #xD46F ?$(CG)(B) ; KS0-C-4729
(ucs-set-char #xD478 ?$(CG*(B) ; KS0-C-472A
(ucs-set-char #xD479 ?$(CG+(B) ; KS0-C-472B
(ucs-set-char #xD47C ?$(CG,(B) ; KS0-C-472C
(ucs-set-char #xD47F ?$(CG-(B) ; KS0-C-472D
(ucs-set-char #xD480 ?$(CG.(B) ; KS0-C-472E
(ucs-set-char #xD482 ?$(CG/(B) ; KS0-C-472F
(ucs-set-char #xD488 ?$(CG0(B) ; KS0-C-4730
(ucs-set-char #xD489 ?$(CG1(B) ; KS0-C-4731
(ucs-set-char #xD48B ?$(CG2(B) ; KS0-C-4732
(ucs-set-char #xD48D ?$(CG3(B) ; KS0-C-4733
(ucs-set-char #xD494 ?$(CG4(B) ; KS0-C-4734
(ucs-set-char #xD4A9 ?$(CG5(B) ; KS0-C-4735
(ucs-set-char #xD4CC ?$(CG6(B) ; KS0-C-4736
(ucs-set-char #xD4D0 ?$(CG7(B) ; KS0-C-4737
(ucs-set-char #xD4D4 ?$(CG8(B) ; KS0-C-4738
(ucs-set-char #xD4DC ?$(CG9(B) ; KS0-C-4739
(ucs-set-char #xD4DF ?$(CG:(B) ; KS0-C-473A
(ucs-set-char #xD4E8 ?$(CG;(B) ; KS0-C-473B
(ucs-set-char #xD4EC ?$(CG<(B) ; KS0-C-473C
(ucs-set-char #xD4F0 ?$(CG=(B) ; KS0-C-473D
(ucs-set-char #xD4F8 ?$(CG>(B) ; KS0-C-473E
(ucs-set-char #xD4FB ?$(CG?(B) ; KS0-C-473F
(ucs-set-char #xD4FD ?$(CG@(B) ; KS0-C-4740
(ucs-set-char #xD504 ?$(CGA(B) ; KS0-C-4741
(ucs-set-char #xD508 ?$(CGB(B) ; KS0-C-4742
(ucs-set-char #xD50C ?$(CGC(B) ; KS0-C-4743
(ucs-set-char #xD514 ?$(CGD(B) ; KS0-C-4744
(ucs-set-char #xD515 ?$(CGE(B) ; KS0-C-4745
(ucs-set-char #xD517 ?$(CGF(B) ; KS0-C-4746
(ucs-set-char #xD53C ?$(CGG(B) ; KS0-C-4747
(ucs-set-char #xD53D ?$(CGH(B) ; KS0-C-4748
(ucs-set-char #xD540 ?$(CGI(B) ; KS0-C-4749
(ucs-set-char #xD544 ?$(CGJ(B) ; KS0-C-474A
(ucs-set-char #xD54C ?$(CGK(B) ; KS0-C-474B
(ucs-set-char #xD54D ?$(CGL(B) ; KS0-C-474C
(ucs-set-char #xD54F ?$(CGM(B) ; KS0-C-474D
(ucs-set-char #xD551 ?$(CGN(B) ; KS0-C-474E
(ucs-set-char #xD558 ?$(CGO(B) ; KS0-C-474F
(ucs-set-char #xD559 ?$(CGP(B) ; KS0-C-4750
(ucs-set-char #xD55C ?$(CGQ(B) ; KS0-C-4751
(ucs-set-char #xD560 ?$(CGR(B) ; KS0-C-4752
(ucs-set-char #xD565 ?$(CGS(B) ; KS0-C-4753
(ucs-set-char #xD568 ?$(CGT(B) ; KS0-C-4754
(ucs-set-char #xD569 ?$(CGU(B) ; KS0-C-4755
(ucs-set-char #xD56B ?$(CGV(B) ; KS0-C-4756
(ucs-set-char #xD56D ?$(CGW(B) ; KS0-C-4757
(ucs-set-char #xD574 ?$(CGX(B) ; KS0-C-4758
(ucs-set-char #xD575 ?$(CGY(B) ; KS0-C-4759
(ucs-set-char #xD578 ?$(CGZ(B) ; KS0-C-475A
(ucs-set-char #xD57C ?$(CG[(B) ; KS0-C-475B
(ucs-set-char #xD584 ?$(CG\(B) ; KS0-C-475C
(ucs-set-char #xD585 ?$(CG](B) ; KS0-C-475D
(ucs-set-char #xD587 ?$(CG^(B) ; KS0-C-475E
(ucs-set-char #xD588 ?$(CG_(B) ; KS0-C-475F
(ucs-set-char #xD589 ?$(CG`(B) ; KS0-C-4760
(ucs-set-char #xD590 ?$(CGa(B) ; KS0-C-4761
(ucs-set-char #xD5A5 ?$(CGb(B) ; KS0-C-4762
(ucs-set-char #xD5C8 ?$(CGc(B) ; KS0-C-4763
(ucs-set-char #xD5C9 ?$(CGd(B) ; KS0-C-4764
(ucs-set-char #xD5CC ?$(CGe(B) ; KS0-C-4765
(ucs-set-char #xD5D0 ?$(CGf(B) ; KS0-C-4766
(ucs-set-char #xD5D2 ?$(CGg(B) ; KS0-C-4767
(ucs-set-char #xD5D8 ?$(CGh(B) ; KS0-C-4768
(ucs-set-char #xD5D9 ?$(CGi(B) ; KS0-C-4769
(ucs-set-char #xD5DB ?$(CGj(B) ; KS0-C-476A
(ucs-set-char #xD5DD ?$(CGk(B) ; KS0-C-476B
(ucs-set-char #xD5E4 ?$(CGl(B) ; KS0-C-476C
(ucs-set-char #xD5E5 ?$(CGm(B) ; KS0-C-476D
(ucs-set-char #xD5E8 ?$(CGn(B) ; KS0-C-476E
(ucs-set-char #xD5EC ?$(CGo(B) ; KS0-C-476F
(ucs-set-char #xD5F4 ?$(CGp(B) ; KS0-C-4770
(ucs-set-char #xD5F5 ?$(CGq(B) ; KS0-C-4771
(ucs-set-char #xD5F7 ?$(CGr(B) ; KS0-C-4772
(ucs-set-char #xD5F9 ?$(CGs(B) ; KS0-C-4773
(ucs-set-char #xD600 ?$(CGt(B) ; KS0-C-4774
(ucs-set-char #xD601 ?$(CGu(B) ; KS0-C-4775
(ucs-set-char #xD604 ?$(CGv(B) ; KS0-C-4776
(ucs-set-char #xD608 ?$(CGw(B) ; KS0-C-4777
(ucs-set-char #xD610 ?$(CGx(B) ; KS0-C-4778
(ucs-set-char #xD611 ?$(CGy(B) ; KS0-C-4779
(ucs-set-char #xD613 ?$(CGz(B) ; KS0-C-477A
(ucs-set-char #xD614 ?$(CG{(B) ; KS0-C-477B
(ucs-set-char #xD615 ?$(CG|(B) ; KS0-C-477C
(ucs-set-char #xD61C ?$(CG}(B) ; KS0-C-477D
(ucs-set-char #xD620 ?$(CG~(B) ; KS0-C-477E
(ucs-set-char #xD624 ?$(CH!(B) ; KS0-C-4821
(ucs-set-char #xD62D ?$(CH"(B) ; KS0-C-4822
(ucs-set-char #xD638 ?$(CH#(B) ; KS0-C-4823
(ucs-set-char #xD639 ?$(CH$(B) ; KS0-C-4824
(ucs-set-char #xD63C ?$(CH%(B) ; KS0-C-4825
(ucs-set-char #xD640 ?$(CH&(B) ; KS0-C-4826
(ucs-set-char #xD645 ?$(CH'(B) ; KS0-C-4827
(ucs-set-char #xD648 ?$(CH((B) ; KS0-C-4828
(ucs-set-char #xD649 ?$(CH)(B) ; KS0-C-4829
(ucs-set-char #xD64B ?$(CH*(B) ; KS0-C-482A
(ucs-set-char #xD64D ?$(CH+(B) ; KS0-C-482B
(ucs-set-char #xD651 ?$(CH,(B) ; KS0-C-482C
(ucs-set-char #xD654 ?$(CH-(B) ; KS0-C-482D
(ucs-set-char #xD655 ?$(CH.(B) ; KS0-C-482E
(ucs-set-char #xD658 ?$(CH/(B) ; KS0-C-482F
(ucs-set-char #xD65C ?$(CH0(B) ; KS0-C-4830
(ucs-set-char #xD667 ?$(CH1(B) ; KS0-C-4831
(ucs-set-char #xD669 ?$(CH2(B) ; KS0-C-4832
(ucs-set-char #xD670 ?$(CH3(B) ; KS0-C-4833
(ucs-set-char #xD671 ?$(CH4(B) ; KS0-C-4834
(ucs-set-char #xD674 ?$(CH5(B) ; KS0-C-4835
(ucs-set-char #xD683 ?$(CH6(B) ; KS0-C-4836
(ucs-set-char #xD685 ?$(CH7(B) ; KS0-C-4837
(ucs-set-char #xD68C ?$(CH8(B) ; KS0-C-4838
(ucs-set-char #xD68D ?$(CH9(B) ; KS0-C-4839
(ucs-set-char #xD690 ?$(CH:(B) ; KS0-C-483A
(ucs-set-char #xD694 ?$(CH;(B) ; KS0-C-483B
(ucs-set-char #xD69D ?$(CH<(B) ; KS0-C-483C
(ucs-set-char #xD69F ?$(CH=(B) ; KS0-C-483D
(ucs-set-char #xD6A1 ?$(CH>(B) ; KS0-C-483E
(ucs-set-char #xD6A8 ?$(CH?(B) ; KS0-C-483F
(ucs-set-char #xD6AC ?$(CH@(B) ; KS0-C-4840
(ucs-set-char #xD6B0 ?$(CHA(B) ; KS0-C-4841
(ucs-set-char #xD6B9 ?$(CHB(B) ; KS0-C-4842
(ucs-set-char #xD6BB ?$(CHC(B) ; KS0-C-4843
(ucs-set-char #xD6C4 ?$(CHD(B) ; KS0-C-4844
(ucs-set-char #xD6C5 ?$(CHE(B) ; KS0-C-4845
(ucs-set-char #xD6C8 ?$(CHF(B) ; KS0-C-4846
(ucs-set-char #xD6CC ?$(CHG(B) ; KS0-C-4847
(ucs-set-char #xD6D1 ?$(CHH(B) ; KS0-C-4848
(ucs-set-char #xD6D4 ?$(CHI(B) ; KS0-C-4849
(ucs-set-char #xD6D7 ?$(CHJ(B) ; KS0-C-484A
(ucs-set-char #xD6D9 ?$(CHK(B) ; KS0-C-484B
(ucs-set-char #xD6E0 ?$(CHL(B) ; KS0-C-484C
(ucs-set-char #xD6E4 ?$(CHM(B) ; KS0-C-484D
(ucs-set-char #xD6E8 ?$(CHN(B) ; KS0-C-484E
(ucs-set-char #xD6F0 ?$(CHO(B) ; KS0-C-484F
(ucs-set-char #xD6F5 ?$(CHP(B) ; KS0-C-4850
(ucs-set-char #xD6FC ?$(CHQ(B) ; KS0-C-4851
(ucs-set-char #xD6FD ?$(CHR(B) ; KS0-C-4852
(ucs-set-char #xD700 ?$(CHS(B) ; KS0-C-4853
(ucs-set-char #xD704 ?$(CHT(B) ; KS0-C-4854
(ucs-set-char #xD711 ?$(CHU(B) ; KS0-C-4855
(ucs-set-char #xD718 ?$(CHV(B) ; KS0-C-4856
(ucs-set-char #xD719 ?$(CHW(B) ; KS0-C-4857
(ucs-set-char #xD71C ?$(CHX(B) ; KS0-C-4858
(ucs-set-char #xD720 ?$(CHY(B) ; KS0-C-4859
(ucs-set-char #xD728 ?$(CHZ(B) ; KS0-C-485A
(ucs-set-char #xD729 ?$(CH[(B) ; KS0-C-485B
(ucs-set-char #xD72B ?$(CH\(B) ; KS0-C-485C
(ucs-set-char #xD72D ?$(CH](B) ; KS0-C-485D
(ucs-set-char #xD734 ?$(CH^(B) ; KS0-C-485E
(ucs-set-char #xD735 ?$(CH_(B) ; KS0-C-485F
(ucs-set-char #xD738 ?$(CH`(B) ; KS0-C-4860
(ucs-set-char #xD73C ?$(CHa(B) ; KS0-C-4861
(ucs-set-char #xD744 ?$(CHb(B) ; KS0-C-4862
(ucs-set-char #xD747 ?$(CHc(B) ; KS0-C-4863
(ucs-set-char #xD749 ?$(CHd(B) ; KS0-C-4864
(ucs-set-char #xD750 ?$(CHe(B) ; KS0-C-4865
(ucs-set-char #xD751 ?$(CHf(B) ; KS0-C-4866
(ucs-set-char #xD754 ?$(CHg(B) ; KS0-C-4867
(ucs-set-char #xD756 ?$(CHh(B) ; KS0-C-4868
(ucs-set-char #xD757 ?$(CHi(B) ; KS0-C-4869
(ucs-set-char #xD758 ?$(CHj(B) ; KS0-C-486A
(ucs-set-char #xD759 ?$(CHk(B) ; KS0-C-486B
(ucs-set-char #xD760 ?$(CHl(B) ; KS0-C-486C
(ucs-set-char #xD761 ?$(CHm(B) ; KS0-C-486D
(ucs-set-char #xD763 ?$(CHn(B) ; KS0-C-486E
(ucs-set-char #xD765 ?$(CHo(B) ; KS0-C-486F
(ucs-set-char #xD769 ?$(CHp(B) ; KS0-C-4870
(ucs-set-char #xD76C ?$(CHq(B) ; KS0-C-4871
(ucs-set-char #xD770 ?$(CHr(B) ; KS0-C-4872
(ucs-set-char #xD774 ?$(CHs(B) ; KS0-C-4873
(ucs-set-char #xD77C ?$(CHt(B) ; KS0-C-4874
(ucs-set-char #xD77D ?$(CHu(B) ; KS0-C-4875
(ucs-set-char #xD781 ?$(CHv(B) ; KS0-C-4876
(ucs-set-char #xD788 ?$(CHw(B) ; KS0-C-4877
(ucs-set-char #xD789 ?$(CHx(B) ; KS0-C-4878
(ucs-set-char #xD78C ?$(CHy(B) ; KS0-C-4879
(ucs-set-char #xD790 ?$(CHz(B) ; KS0-C-487A
(ucs-set-char #xD798 ?$(CH{(B) ; KS0-C-487B
(ucs-set-char #xD799 ?$(CH|(B) ; KS0-C-487C
(ucs-set-char #xD79B ?$(CH}(B) ; KS0-C-487D
(ucs-set-char #xD79D ?$(CH~(B) ; KS0-C-487E

;;; ucs-hangul.el ends here
