;;; ucs-latin-b.el --- UCS table of Latin Extended-B

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, Latin Extended-B

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

(require 'ucs-util)

;; LATIN CAPITAL LETTER O WITH HORN
(ucs-set-char #x01A0 ?.2N=) ; VISCII-1.1-B4

;; LATIN SMALL LETTER O WITH HORN
(ucs-set-char #x01A1 ?.1N=) ; VISCII-1.1-BD

;; LATIN CAPITAL LETTER U WITH HORN
(ucs-set-char #x01AF ?.2N_) ; VISCII-1.1-BF

;; LATIN SMALL LETTER U WITH HORN
(ucs-set-char #x01B0 ?.1N_) ; VISCII-1.1-DF

;; LATIN CAPITAL LETTER A WITH CARON
(ucs-set-char #x01CD ?$(D*&(B) ; J90-D-2A26

;; LATIN SMALL LETTER A WITH CARON
(ucs-set-char #x01CE ?$(D+&(B) ; J90-D-2B26
(ucs-set-char #x01CE ?$A(#(B) ; GB0-A-2823

;; LATIN CAPITAL LETTER I WITH CARON
(ucs-set-char #x01CF ?$(D*C(B) ; J90-D-2A43

;; LATIN SMALL LETTER I WITH CARON
(ucs-set-char #x01D0 ?$(D+C(B) ; J90-D-2B43
(ucs-set-char #x01D0 ?$A(+(B) ; GB0-A-282B

;; LATIN CAPITAL LETTER O WITH CARON
(ucs-set-char #x01D1 ?$(D*U(B) ; J90-D-2A55

;; LATIN SMALL LETTER O WITH CARON
(ucs-set-char #x01D2 ?$(D+U(B) ; J90-D-2B55
(ucs-set-char #x01D2 ?$A(/(B) ; GB0-A-282F

;; LATIN CAPITAL LETTER U WITH CARON
(ucs-set-char #x01D3 ?$(D*g(B) ; J90-D-2A67

;; LATIN SMALL LETTER U WITH CARON
(ucs-set-char #x01D4 ?$(D+g(B) ; J90-D-2B67
(ucs-set-char #x01D4 ?$A(3(B) ; GB0-A-2833

;; LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
(ucs-set-char #x01D5 ?$(D*p(B) ; J90-D-2A70

;; LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
(ucs-set-char #x01D6 ?$(D+p(B) ; J90-D-2B70
(ucs-set-char #x01D6 ?$A(5(B) ; GB0-A-2835

;; LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
(ucs-set-char #x01D7 ?$(D*m(B) ; J90-D-2A6D

;; LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
(ucs-set-char #x01D8 ?$(D+m(B) ; J90-D-2B6D
(ucs-set-char #x01D8 ?$A(6(B) ; GB0-A-2836

;; LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
(ucs-set-char #x01D9 ?$(D*o(B) ; J90-D-2A6F

;; LATIN SMALL LETTER U WITH DIAERESIS AND CARON
(ucs-set-char #x01DA ?$(D+o(B) ; J90-D-2B6F
(ucs-set-char #x01DA ?$A(7(B) ; GB0-A-2837

;; LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
(ucs-set-char #x01DB ?$(D*n(B) ; J90-D-2A6E

;; LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
(ucs-set-char #x01DC ?$(D+n(B) ; J90-D-2B6E
(ucs-set-char #x01DC ?$A(8(B) ; GB0-A-2838

;; LATIN SMALL LETTER G WITH ACUTE
(ucs-set-char #x01F5 ?$(D+9(B) ; J90-D-2B39

;;; ucs-latin-b.el ends here
