/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 *	This file is distributed under license and is confidential
 *
 *	File title and purpose
 *	Author:	 Mark Allender (allender@cs.uiuc.edu)
 *               Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

#include <stdio.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <mbus/api.h>
#include "graph.h"
#include "extern.h"

/*
 *  Some macro definitions...
*/
/* Don't need to worry about flag not being either NODEMASK or EDGEMASK. */
#define ELEMENT_NAME(struct_ptr, flag)\
  ((flag & NODEMASK) ? ((Vertex *)(struct_ptr))->values->i_name\
   : ((Edge *)(struct_ptr))->values->i_name)
   
#define ELEMENT_TYPE(struct_ptr, flag)\
  ((flag & NODEMASK) ? ((Vertex *)(struct_ptr))->values->type :\
   (flag & EDGEMASK) ? ((Edge *)(struct_ptr))->values->type :\
    NULL)

#define WHATAMI(flag)\
  ((flag & NODEMASK) ? "node" : (flag & EDGEMASK) ? "edge" : "unknown")

#define KEYLIST(struct_ptr, flag)\
  ((flag & NODEMASK) ? ((Vertex *)(struct_ptr))->values->key_list :\
   (flag & EDGEMASK) ? ((Edge *)(struct_ptr))->values->key_list :\
    NULL)

char *
LookupKey(key, structure, flag)
     char **key;
     void *structure;
     int flag;
{
  int count;
  char *tail, *lookup_key;
  KeyList *key_list;

  tail = *key;
  if (*tail == NULL)
    return NULL;
  while (isalnum(*tail) || *tail == '.' || *tail == '_' || *tail == '-')
    tail++;
  count = tail - *key;
  lookup_key = (char *)malloc(count + 1);
  strncpy(lookup_key, *key, count);
  *(lookup_key + count) = '\0';
  *key = tail;
  if (!strcmp(lookup_key, WHATAMI(flag)))
    return (ELEMENT_NAME(structure, flag));
  if (!strcmp(lookup_key, "type"))
    return (ELEMENT_TYPE(structure, flag));
  for (key_list = KEYLIST(structure, flag); key_list;
       key_list = key_list->next) {
    if (!strcmp(lookup_key, key_list->key))
    {
      free(lookup_key);	
      return key_list->value;
    }
  }
  free(lookup_key);
  return NULL;
}
	  
/*
 *  SendMessageCallback takes the data for a callback, and makes the
 *  substitutiions in the data string that need to be made.  The string
 *  is returned.  There may be a better way to do this routine, but for
 *  now, I don't have the time to find out....gotta get this up.
*/
int
SendMessageCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{

  int size, inc, count, current_size, flag;
  extern t_mb_connection conn;
  char *tail, *head, *data_part, *value;
  extern char *strchr();
  void *struct_ptr;

  /* Look for a node first */
  FillCallbackInfo(CallbackInfo, NODEMASK);
  if (CallbackInfo->node)
  {
    struct_ptr = (void *)CallbackInfo->node;
    flag = NODEMASK;
  }
  else
  {
    /* If no node, look for an edge */
    FillCallbackInfo(CallbackInfo, EDGEMASK);
    if (CallbackInfo->edge)
    {
      struct_ptr = (void *)CallbackInfo->edge;
      flag = EDGEMASK;
    }
    else
	return 0;		/* Not over an edge or a node */
  }
  
  inc = 1024;
  size = inc;
  current_size = 0;
  data_part = (char *)malloc(size);
  *data_part = '\0';
  head = CallbackData->data;
  while (head && (tail = strchr(head, '?'))) {
    /* Copy the data to this point */
    if ((count = tail - head)) {
      if (count + current_size > size) {
	size += inc;
	data_part = (char *)realloc(data_part, size);
      }
      strncat(data_part, head, count);
      current_size += count;
    }
    if (*(tail + 1) == '?') {
      /* We have ?? */
      tail += 2;
      value = LookupKey(&tail, struct_ptr, flag);
      if (!value) {
	free(data_part);
	return 0;		/* If no value, then don't send */
      }
    } else {
      /* We have ? */
      tail++;
      value = LookupKey(&tail, struct_ptr, flag);
      if (!value)
	value = "nil";
    }
    count = strlen(value);
    if (count + current_size > size) {
      size += inc;
      data_part = (char *)realloc(data_part, size);
    }
    current_size += count;
    strcat (data_part, value);
    head = tail;
  }
  /* Now copy the remainder of the string */
  if (head) {
    count = strlen(head);
    if (count + current_size > size) {
      size += inc;
      data_part = (char *)realloc(data_part, size);
    }
    current_size += count;
    strcat (data_part, head);
  }
  MBtransmit_Cstring(conn, "(");
  MBtransmit_Cstring(conn, CallbackData->tag);
  MBtransmit_Cstring(conn, " ");
  MBtransmit_Cstring(conn, CallbackData->domain);
  MBtransmit_Cstring(conn, " ");
  MBtransmit_Cstring(conn, data_part);
  MBtransmit_Cstring(conn, ")");
  free(data_part);
  return 0;
}

int
RandomizeCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  Vertex *node;

  RandomizeNodes();
  return REDETERMINE;
}

int
RedrawCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  return REDETERMINE;
}

int
ToggleNamesCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
/*
 *  The name callback toggles between the different types of
 *  names that are available:  type, short, and long.
*/
  graph->name_type = (graph->name_type + 1) % MAX_LABELS;
  AssignNodeLabels();
  return REDRAW;
}

/*
 *  MoveNodeCallback is the callback that gets activated when the user
 *  is trying to move a node.  The parameter fix exists so that the user
 *  may move and fix the node at the same time.
*/
int
MoveNodeCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  Vertex *node;
  unsigned int mask;
  unsigned long foreground;
  Window root_return, child_return;
  int root_x, root_y, win_x, win_y, x, y;
  XFontStruct *font;
  Display *dpy;
  Widget widget;
  Window win;

  widget = graph->viewing_area.widget;
  dpy = XtDisplay(widget);
  win = XtWindow(widget);

  /* Check if the mouse button is still down. */
  XQueryPointer (dpy, win,
		 &root_return, &child_return,
		 &root_x, &root_y, &win_x, &win_y, &mask);

  if (!(mask & CallbackInfo->buttonmask))
      return 0;
    
  FillCallbackInfo(CallbackInfo, NODEMASK);
  if (!CallbackInfo->node)
  {
    return 0;			/* No node, get ought'a here */
  }
  
  node = CallbackInfo->node;

  RetTypeInfo(node->values->type, NODEMASK, &foreground, &font);
  XSetForeground(dpy, graph->xor_gc, foreground ^ 
		 graph->xor_gc->values.background);
  XSetFont(dpy, graph->xor_gc, font->fid);
  x = CallbackInfo->start_x;
  y = CallbackInfo->start_y;
  draw_node_box (node, graph->xor_gc, font);
/*
 *  Now, we will continue to move the node around until the button
 *  is released.  We find out this information more or less from
 *  XQueryPointer
*/
  do
  {
    XQueryPointer (dpy, win,
		   &root_return, &child_return,
		   &root_x, &root_y, &win_x, &win_y, &mask);
    if (x != win_x || y != win_y)
    {
      draw_node_box (node, graph->xor_gc, font);
      node->x += VIEWX_INTX(win_x - x);
      node->y += VIEWY_INTY(win_y - y);
      x = win_x;
      y = win_y;
      draw_node_box (node, graph->xor_gc, font);
    }
  } while (mask & CallbackInfo->buttonmask);
/*
 *  Okay.  We are done, so now we just assign the new position of the
 *  node in our coordinate system.
*/
  draw_node_box (node, graph->xor_gc, font);
  SetNodePos(node);
  return REDRAW;
}

/*
 *  Now are the routines that will fix, unfix, fix all, and unfix all
 *  of the nodes in a graph.  These are straightforward routines.
*/

int
FixNodeCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  FillCallbackInfo(CallbackInfo, NODEMASK); /* Get the node */

  FixNode(CallbackInfo->node);
  return REDRAW;		/* Redraw for showing the fixed designation */
}

int
UnfixNodeCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  FillCallbackInfo(CallbackInfo, NODEMASK); /* Get the node */

  UnfixNode(CallbackInfo->node);
  return REDRAW;
}

int
FixAllCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  Vertex *node;

  for (node = graph->v; node != NULL; node = node->next)
      FixNode(node);
  return REDRAW;
}

int
UnfixAllCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  Vertex *node;

  for (node = graph->v; node != NULL; node = node->next)
      UnfixNode(node);
  return REDRAW;
}

int
SelectNodeCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  FillCallbackInfo(CallbackInfo, NODEMASK);
  
  SelectNode(CallbackInfo->node);
  
  return REDRAW;
}

int
UnselectNodeCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  FillCallbackInfo(CallbackInfo, NODEMASK);
  
  UnselectNode(CallbackInfo->node);
  
  return REDRAW;
}

int
SelectEdgeCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  FillCallbackInfo(CallbackInfo, EDGEMASK);
  
  SelectEdge(CallbackInfo->edge);
  
  return REDRAW;
}

int
UnselectEdgeCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  FillCallbackInfo(CallbackInfo, EDGEMASK);
  
  UnselectEdge(CallbackInfo->edge);
  
  return REDRAW;
}

int
SelectSweptNodesCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  NodeList *head;
  /* Go get the swept region and the nodes within that region */
  FillCallbackInfo(CallbackInfo, SWEPT_REGION | SWEPT_NODES);
  
  for (head = CallbackInfo->swept_nodes; head; head = head->next)
      SelectNode(head->node);
  
  return REDRAW;
}

int
UnselectSweptNodesCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  NodeList *head;
  /* Go get the swept region and the nodes within that region */
  FillCallbackInfo(CallbackInfo, SWEPT_REGION | SWEPT_NODES);
  
  for (head = CallbackInfo->swept_nodes; head; head = head->next)
      UnselectNode(head->node);
  
  return REDRAW;
}

int
SelectAllCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  Vertex *node;
  Edge *edge;

  for (node = graph->v; node != NULL; node = node->next)
      SelectNode(node);

  for (edge = graph->edges; edge; edge = edge->next)
      SelectEdge(edge);

  return REDRAW;
}

int
UnselectAllCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  Vertex *node;
  Edge *edge;

  for (node = graph->v; node != NULL; node = node->next)
      UnselectNode(node);

  for (edge = graph->edges; edge; edge = edge->next)
      UnselectEdge(edge);

  return REDRAW;
}

int
MoveSelectedCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  unsigned int mask;
  coord_t minx, miny, maxx, maxy;
  int iminx, iminy, imaxx, imaxy;
  coord_t deltax, deltay, diffx, diffy;
  Display *dpy;
  Widget widget;
  Window win;
  Window root_return, child_return;
  int root_x, root_y, win_x, win_y, x, y;
  NodeList *head;

  widget = graph->viewing_area.widget;
  dpy = XtDisplay(widget);
  win = XtWindow(widget);

  /* Check if the mouse button is still down. */
  XQueryPointer (dpy, win,
		 &root_return, &child_return,
		 &root_x, &root_y, &win_x, &win_y, &mask);

  if (!(mask & CallbackInfo->buttonmask))
      return 0;
    
  x = CallbackInfo->start_x;
  y = CallbackInfo->start_y;
  
  FillCallbackInfo(CallbackInfo, SELECTED_NODES);

  if (BoundingBox(CallbackInfo->selected_nodes, &minx, &miny, &maxx, &maxy)
      && InBox(VIEWX_INTX(x), VIEWY_INTY(y), minx, miny, maxx, maxy))
  {
    XSetForeground(dpy, graph->xor_gc, graph->foreground ^ graph->background);
    DrawSelectedBox(graph->xor_gc, minx, miny, maxx, maxy);
    deltax = 0.0;
    deltay = 0.0;
    do
    {
      XQueryPointer (dpy, win,
		     &root_return, &child_return,
		     &root_x, &root_y, &win_x, &win_y, &mask);
      if (x != win_x || y != win_y)
      {
	DrawSelectedBox(graph->xor_gc, minx, miny, maxx, maxy);
	diffx = VIEWX_INTX(win_x - x);
	diffy = VIEWY_INTY(win_y - y);
	deltax += diffx;
	deltay += diffy;
	minx += diffx;
	maxx += diffx;
	miny += diffy;
	maxy += diffy;
	x = win_x;
	y = win_y;
	DrawSelectedBox(graph->xor_gc, minx, miny, maxx, maxy);
      }
    } while (mask & CallbackInfo->buttonmask);
    DrawSelectedBox(graph->xor_gc, minx, miny, maxx, maxy);
    
    for (head = CallbackInfo->selected_nodes; head; head = head->next)
    {
      head->node->x += deltax;
      head->node->y += deltay;
      SetNodePos(head->node);
    }
    return REDRAW;
  }
  return 0;
}  

int
FixSweptNodesCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  NodeList *head;
  /* Go get the swept region and the nodes within that region */
  FillCallbackInfo(CallbackInfo, SWEPT_REGION | SWEPT_NODES);
  
  for (head = CallbackInfo->swept_nodes; head; head = head->next)
      FixNode(head->node);
  
  return REDRAW;
}

int
UnfixSweptNodesCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  NodeList *head;
  /* Go get the swept region and the nodes within that region */
  FillCallbackInfo(CallbackInfo, SWEPT_REGION | SWEPT_NODES);
  
  for (head = CallbackInfo->swept_nodes; head; head = head->next)
      UnfixNode(head->node);
  
  return REDRAW;
}

int
FixSelectedNodesCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  NodeList *head;
  /* Go get the selected nodes */
  FillCallbackInfo(CallbackInfo, SELECTED_NODES);
  
  for (head = CallbackInfo->selected_nodes; head; head = head->next)
      FixNode(head->node);
  
  return REDRAW;
}

int
UnfixSelectedNodesCallback(CallbackInfo, CallbackData)
  struct CallbackInfo *CallbackInfo;
  struct FunctionBindings *CallbackData;
{
  NodeList *head;
  /* Go get the selected nodes */
  FillCallbackInfo(CallbackInfo, SELECTED_NODES);
  
  for (head = CallbackInfo->selected_nodes; head; head = head->next)
      UnfixNode(head->node);
  
  return REDRAW;
}

int
ChooseActiveCallback(CallbackInfo, CallbackData)
     struct CallbackInfo *CallbackInfo;
     struct FunctionBindings *CallbackData;
{
  FillCallbackInfo(CallbackInfo, NODEMASK);

#if 0
  if (CallbackInfo->node)
    graph->active_type = CallbackInfo->node->values->type;
  else
#endif
    QueryforActiveType(graph, CallbackInfo->node);

  return 0;
}

int SelectActiveCallback(CallbackInfo, CallbackData)
     struct CallbackInfo *CallbackInfo;
     struct FunctionBindings *CallbackData;
{
  Vertex *node;

  if (graph->active_type == NULL)
      return 0;

  for (node = graph->v; node; node = node->next)
    if (!strcmp(node->values->type, graph->active_type))
      SelectNode(node);

  return REDRAW;
}

int UnselectActiveCallback(CallbackInfo, CallbackData)
     struct CallbackInfo *CallbackInfo;
     struct FunctionBindings *CallbackData;
{
  Vertex *node;

  if (graph->active_type == NULL)
      return 0;

  for (node = graph->v; node; node = node->next)
    if (!strcmp(node->values->type, graph->active_type))
      UnselectNode(node);

  return REDRAW;
}

