/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/* Socket operations */
/* $Source: /import/kaplan/kaplan/carroll/cb/mbus/commands/RCS/socket.c,v $ */

static char rcsid[] = "socket.c $Revision: 2.1 $ $Date: 91/07/03 10:17:32 $ $State: Beta $ $Author: carroll $";

/* ------------------------------------------------------------------------- */
#include "header.h"
#include "extern.h"
/* ------------------------------------------------------------------------- */
/* The socket handling code.
 */
/* ------------------------------------------------------------------------- */
int accept_fd = -1;			/* accept socket file descriptor */
/* ------------------------------------------------------------------------- */
void
InitializeSocket()
{
  int sock;
  int flags;
  struct sockaddr_in saddr;

  sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
  if (sock < 0) bomb("Cannot open socket");

  saddr.sin_port = htons(mbus_port);
  saddr.sin_family = AF_INET;
  saddr.sin_addr.s_addr = INADDR_ANY;

  if (bind(sock, (struct sockaddr *) &saddr, sizeof(saddr)))
    bomb("Cannot bind socket");

  listen(sock,5);			/* 5 is magic. See manual. */

  accept_fd = sock;

  /* Make all sockets non-blocking */
  fcntl(sock, F_GETFL, &flags);
  flags |= O_NDELAY;
  fcntl(sock, F_SETFL, flags);

}
/* ------------------------------------------------------------------------- */
