#! /bin/zsh -f

# Written by SL Baur <steve@xemacs.org>
# December, 1998
# This file is part of XEmacs and is used by the maintainers
#  for creating distributions

# CVSGraffito:  Tag the CVS repository
# Usage:  CVSGraffito MAJOR MINOR BUILD

setopt extendedglob
set -e # Exit at the first sign of trouble

if [ $# != 3 ]; then
	echo "Usage: $0: MAJOR MINOR BUILD"
	exit 1
fi

export MAJOR=$1
export MINOR=$2
export BUILD=$3
export BUILDDIR=xemacs-${MAJOR}.${MINOR}

if [ ! -d "$BUILDDIR" ]; then
	echo "XEmacs source tree $BUILDDIR: not found"
	exit 1
fi

cd ${BUILDDIR}

cvs tag r${MAJOR}-${MINOR}-${BUILD}

exit 0
