/*	mpfilt.c 2.2 12/3/88 15:17:17	*/
/*	Copyright (c) 1987, Benjamin G. Zorn */

#include	<stdio.h>
#include	<sys/file.h>
#include	<ctype.h>
#include	<a.out.h>
#include	<stab.h>
#include 	"mprof.h"

extern 	char	*malloc();


/* functions for uniquely recording recording each structure type
 */

#define STHASH_SIZE	2047
struct sthash *sthmem[STHASH_SIZE];

#define	STNIL	NULL

struct stconscell {
    int		car;
    struct stconscell *cdr;
};

struct stconscell
*stcons(car, cdr)
int	car;
struct stconscell *cdr;
{
    struct stconscell *newcons;
    newcons = (struct stconscell *) malloc(sizeof(struct stconscell));
    newcons->car = car;
    newcons->cdr = cdr;
    return newcons;
}
		


struct stconscell
*stmember(item, stlist)
int	item;
struct stconscell *stlist;
{
    struct stconscell *s = stlist;
    
    while (s != STNIL) {
	if (s->car == item)
	    return s;
	s = s->cdr;
    }
    return STNIL;
}


bool
stmatchlist(l1, l2)
struct stconscell *l1, *l2;
{
    struct stconscell *s1, *s2;
    int		len1, len2;

    for (len1 = 0, s1 = l1; s1 != STNIL; len1++, s1 = s1->cdr) ;
    for (len2 = 0, s2 = l2; s2 != STNIL; len2++, s2 = s2->cdr) ;

    if (len1 == len2) {
	for (s1 = l1; s1 != STNIL; s1 = s1->cdr) {
	    if (stmember(s1->car, l2) == STNIL) {
		return FALSE;
	    }
	}
	return TRUE;
    }
    return FALSE;
}

	    
#define	T_STRUCT	0
#define	T_TYPEDEF	1

struct sthash {
    int		kind;
    char 	*str;
    int		size;
    struct stconscell *numlist;
    struct sthash *next;
};

  
struct sthash
*mpf_new_stlink(kind, str, size, numlist, next)
int	kind;
char	*str;
int	size;
struct stconscell *numlist;
struct sthash *next;
{
    struct sthash *new_stl;

    new_stl = (struct sthash *) malloc(sizeof(struct sthash));
    new_stl->kind = kind;
    new_stl->str = str;
    new_stl->size = size;
    new_stl->numlist = numlist;
    new_stl->next = next;
    return new_stl;
}
    
int
mpf_sthash(s, len)
char	*s;
int	len;
{
    int		i;
    int		hash = 0;

    for (i = 0; i < len; i++) {
	hash = hash ^ (((int) *(s+i)) << (i % 6));
    }
    return ((hash >> 3) % STHASH_SIZE);
}

#define	N_EXCEPTIONS	11

char	*struct_exceptions[] = {
    "mp_function_struct",
    "mp_cons_struct",
    "mp_data_struct",
    "mp_sstk_struct",
    "mpheader",
    "_physadr",
    "_iobuf",
    "_quad",
    "flock",
    "fd_set",
    "label_t"};

    
void
mpf_intern_type(s, size, structsize, tnumber)
char	*s;
int	size;
int	structsize;
int	tnumber;
{
    int			hash = mpf_sthash(s, size);
    int			i;
    struct sthash 	*ste = sthmem[hash];
    char		*newstr;

    for (i = 0; i < N_EXCEPTIONS; i++) {
	if (strncmp(s, struct_exceptions[i],
		    strlen(struct_exceptions[i])) == 0) {
	    return;
	}
    }
    while (ste != NULL) {
	if ((strncmp(s, ste->str, size) == 0) &&
	    (*((ste->str)+size) == NULL)) {
	    /* add the number to the list of numbers
	     */
	    if (stmember(tnumber, ste->numlist) == STNIL)
		ste->numlist = stcons(tnumber, ste->numlist);
	    return;
	}
	ste = ste->next;
    }
    newstr = malloc((unsigned) (size + 1));
    strncpy(newstr, s, size);
    *(char *) ((int) newstr + size) = NULL;
    ste = mpf_new_stlink(T_STRUCT,
			 newstr,
			 structsize,
			 stcons(tnumber, STNIL),
			 sthmem[hash]);
    sthmem[hash] = ste;
    return;
}

    
void
mpf_intern_typedef(s, size, tnumber)
char	*s;
int	size;
int	tnumber;
{
    int			hash = mpf_sthash(s, size);
    struct sthash 	*ste = sthmem[hash];
    char		*newstr;

    while (ste != NULL) {
	if ((strncmp(s, ste->str, size) == 0) &&
	    (*((ste->str)+size) == NULL)) {
	    
	    /* add the number to the list of numbers
	     */
	    if (stmember(tnumber, ste->numlist) == STNIL)
		ste->numlist = stcons(tnumber, ste->numlist);
	    return;
	}
	ste = ste->next;
    }
    newstr = malloc(size + 1);
    strncpy(newstr, s, size);
    *(char *) ((int) newstr + size) = NULL;
    ste = mpf_new_stlink(T_TYPEDEF,
			 newstr,
			 0,
			 stcons(tnumber, STNIL),
			 sthmem[hash]);
    sthmem[hash] = ste;
    return;
}

void
print_types()
{
    struct sthash 	*ste, *ste1;
    struct stconscell	*typedefs, *tl, *structs, *sl;
    int		tnum;
    int		i;

    /* first, make a list of all typedefs and structs
     */
    typedefs = STNIL;
    structs = STNIL;
    for (i = 0; i < STHASH_SIZE; i++) {
	ste = sthmem[i];
	while (ste != NULL) {
	    if (ste->kind == T_TYPEDEF) {
		typedefs = stcons((int) ste, typedefs);
	    } else if (ste->kind == T_STRUCT) {
		structs = stcons((int) ste, structs);
	    }
	    ste = ste->next;
	}
    }

    /* for each typedef, if it points to a struct, change to a struct,
     * add the size, and remove the struct
     */
    tl = typedefs;
    while (tl != STNIL) {
	ste = (struct sthash *) tl->car;
	tnum = ste->numlist->car;
	sl = structs;
	while (sl != STNIL) {
	    ste1 = (struct sthash *) sl->car;
	    if ((stmember(tnum, ste1->numlist) != STNIL) &&
		(stmatchlist(ste->numlist, ste1->numlist))) {
		ste->kind = T_STRUCT;
		ste->size = ste1->size;
		ste1->kind = T_TYPEDEF;
		break;
	    }
	    sl = sl->cdr;
	}
	tl = tl->cdr;
    }
    
    printf("(");
    for (i = 0; i < STHASH_SIZE; i++) {
	ste = sthmem[i];
	while (ste != NULL) {
	    if (ste->kind == T_STRUCT) {
		printf("(\"%s\" %d)\n", ste->str, ste->size);
	    }
	    ste = ste->next;
	}
    }
    printf(")\n");
}
	       


struct finfo {
    char 	*name;
    unsigned	addr;
};

#define	stab_name(x)	(stab[(x)].name)
#define	stab_addr(x)	(stab[(x)].addr)
  
#define	ST_SIZE		5000
#define	ST_NOT_FOUND	-1
typedef	int	stindex;

struct	finfo	stab[ST_SIZE];
int	stab_i;

void		st_init();
int		stab_compare();
void		st_read();
void		st_read_structure();
stindex		st_locate();
void		st_print();
void		st_print_one();

char	*st_strings;
bool	mprofing = FALSE;


int
stab_compare(e1, e2)
struct finfo *e1, *e2;
{
    if (e1->addr < e2->addr) {
	return -1;
    } else if (e1-> addr > e2-> addr) {
	return 1;
    } else {
	return 0;
    }
}

void
st_read(exec_name)
char	*exec_name;
{
    int		aout_file = open(exec_name, (O_RDONLY));
    struct	exec	hdr;
    struct	nlist	asym;
    extern char *index();
    extern char *malloc();
    char	*stmp;
    int		string_size;
    unsigned char type;
    char	*fname;
    int		i;
    
    read(aout_file, &hdr, sizeof(hdr));
    if (!hdr.a_syms) {
	fprintf(stdout, "st_read -- no symbols in executable\n");
	exit(1);
    }

    /* read in the string table
     */
    lseek(aout_file, N_STROFF(hdr), L_SET);
    read(aout_file, &string_size, 4);

    st_strings = malloc(string_size);
    
    lseek(aout_file, N_STROFF(hdr), L_SET);
    read(aout_file, st_strings, string_size);

    /* read in the symbols one at a time
     */
    lseek(aout_file, N_SYMOFF(hdr), L_SET);
    for (i = 0; i < hdr.a_syms / sizeof(struct nlist); i++) {
	read(aout_file, &asym, sizeof(asym));
	type = asym.n_type;
	/* check for functions compiled with -g
	 */
	if (type & N_STAB) {
	    if (asym.n_type == N_FUN) {
/*	    
		stab_name(stab_i) = (char *) (st_strings + asym.n_un.n_strx);
		stab_addr(stab_i) = asym.n_value;
		stmp = index(stab_name(stab_i), ':');
		*stmp = NULL;
		stab_i++;
*/
	    } else if ((asym.n_type == N_LSYM) ||
		       (asym.n_type == N_GSYM)) {
		/* a local symbol that may be a structure definition
		 */
		st_read_structure((char *) (st_strings + asym.n_un.n_strx));
	    }
	} else {
	    /* here's a candidate for a function name
	     */
	    if ((type & N_TYPE) == N_TEXT) {
		fname = (char *) (st_strings + asym.n_un.n_strx);
		if ((*fname == '_') & !index(fname, '.')) {
		    /* since there is not '.' in the name, its probably a
		     * function name
		     */
		    stab_name(stab_i) = (char *) ((int) fname + 1);
		    stab_addr(stab_i) = asym.n_value;
		    stab_i++;
		}
	    }
	}
    }
    stab_name(stab_i) = "unknown";
    stab_addr(stab_i) = stab_addr(stab_i - 1) + 0x10000;
    stab_i++;
    stab_name(stab_i) = "end_marker";
    stab_addr(stab_i) = 0xffffffff;
    stab_i++;
    qsort(stab, stab_i, sizeof(struct finfo), stab_compare);
}

void
st_read_structure(symp)
char	*symp;
{
    char	*eqp, *colp;
    int		ssize, tnum;
    extern int	atoi();
    extern char	*index();
    
    eqp = index(symp, '=');
    colp = index(symp, ':');

    if ((eqp == NULL) && (*(colp+1) == 't')) {
	/*
	 * Check for a Sun stabs type definition.
	 */
	if (*(colp+2) == '(') {
	    char *commap;
	    commap = index(symp, ',');
	    *commap = '0';
	    tnum = atoi((char *) index(symp, '(')+1);
	} else {
	    tnum = atoi((char *) (colp+2));
	}
	mpf_intern_typedef(symp, colp - symp, tnum);
	
    } else if ((eqp != NULL) && *(eqp+1) == 's') {
	
	/* we have a structure entry...
	 * 1. get the size, number, and name
	 * 3. enter into the structure hash table
	 */
	/* get the size (follows eqp+1)
	 */
	ssize = atoi((char *) eqp+2);
	
	/*
	 * Get the number (follows :T)
	 */
	
	/*
	 * Check for a Sun stabs type definition.
	 */
	if (*(colp+2) == '(') {
	    char *commap;
	    commap = index(symp, ',');
	    *commap = '0';
	    tnum = atoi((char *) index(symp, '(')+1);
	} else {
	    tnum = atoi((char *) colp+2);
	}
	
	/* enter the name into the structure hash table
	 */
	mpf_intern_type(symp, (index(symp, ':') - symp), ssize, tnum);
    }
}

stindex
st_locate(addr)
unsigned	addr;
{
    int		upper = stab_i - 1;
    int		lower = 0;
    int		middle = (upper + lower) / 2;

    while (!((stab_addr(middle) <= addr) && (stab_addr(middle + 1) > addr))) {
	if (middle == upper || middle == lower) {
	    return ST_NOT_FOUND;
	}
	if (stab_addr(middle) > addr) {
	    upper = middle;
	} else {
	    lower = middle;
	}
	middle = (upper + lower) / 2;
    }
    if (middle >= (stab_i - 2)) {
	return ST_NOT_FOUND;
    } else {
	return middle;
    }
}

void
st_print()
{
    int		i;

    printf("function symbol table:\n");
    for (i = 0; i < stab_i; i++) {
	st_print_one(i);
    }
}

void
st_print_one(i)
stindex		i;
{
    printf(" %d	%-15s  %10d\n", i,stab_name(i), stab_addr(i));
}

void
increment_data(dt, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12)
mpdata	dt;
int	d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12;
{
    dt_b_small(dt) += d1;    
    dt_b_med(dt) += d2;    
    dt_b_large(dt) += d3;    
    dt_b_xlarge(dt) += d4;    
    dt_n_small(dt) += d5;    
    dt_n_med(dt) += d6;    
    dt_n_large(dt) += d7;
    dt_n_xlarge(dt) += d8;
    dt_d_small(dt) += d9;    
    dt_d_med(dt) += d10;   
    dt_d_large(dt) += d11;
    dt_d_xlarge(dt) += d12;
}

void
st_convert(data_filename)
char	*data_filename;
{
    FILE	*f = fopen(data_filename, "r");
    unsigned	faddr, paddr;
    stindex	fx, px;
    mpsym	fsym, psym;
    mpdata	dcell;
    mpcell	ppair;
    int		d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12;
    int		i, x;

    /* handle the stats data first as a special case
     */
    fscanf(f, "alloc=%d free=%d depth=%d same=%d all=%d\n", &d1, &d2, &d3, &d4, &d5);
    fflush(stdout);
    fscanf(f, "fmem=%d dmem=%d lmem=%d smem=%d\n", &d6, &d7, &d8, &d9);
    printf("(%d %d %d %d %d %d %d %d %d)\n",
	   d1, d2, d3, d4, d5, d6, d7, d8, d9);
    fflush(stdout);

    print_types();
    fflush(stdout);

    /* read in the bins and print them back out
     */
    printf("(");
    for (i = 0; i < MP_NUM_BINS; i++) {
	fscanf(f, "%d\n", &x);
	printf("%d\n", x);
    }
    printf(")");
    fflush(stdout);
	 
    printf("(");
    for (i = 0; i < MP_NUM_BINS; i++) {
	fscanf(f, "%d\n", &x);
	printf("%d\n", x);
    }
    printf(")");
    fflush(stdout);

    /* read in the leak table and print it back out
     */
    printf("(");
    fscanf(f, "%d %d %d %d\n", &d1, &d2, &d3, &d4);
    while(d1 != -2) {
	/* print a single leak entry
	 */
	printf("((");
	for (i = 0; i < SHORT_CALLSTACK_SIZE; i++) {
	    fscanf(f, "%d\n", &d5);
	    if (d5 != 0) {
		fx = st_locate(d5);
		fsym = pc_lookup(stab_addr(fx));
		fn_name(fsym) = stab_name(fx);
		printf("(\"%s\" %d) ", fn_name(fsym), d5 - stab_addr(fx));
	    } else {
		printf("(\"\" 0) ");
	    }
	}
	printf(")(%d %d %d %d))\n", d1, d2, d3, d4);
	fscanf(f, "%d %d %d %d", &d1, &d2, &d3, &d4);
    }
	
    printf(")");
    fflush(stdout);
    
    while (fscanf(f, "%d\n", &faddr) != EOF) {
	fx = st_locate(faddr);
	fsym = pc_lookup(stab_addr(fx));
	fn_name(fsym) = stab_name(fx);
	fscanf(f, "%d %d %d %d %d %d %d %d %d %d %d %d\n",
	       &d1, &d2, &d3, &d4, &d5, &d6, &d7, &d8, &d9, &d10, &d11, &d12);
	increment_data(fn_lcount(fsym),
		       d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
	fscanf(f, "%d\n", &paddr);
	while ((int) paddr != MP_NIL) {
	    px = st_locate(paddr);
	    psym = pc_lookup(stab_addr(px));
	    ppair = mp_has_parent(fsym, psym);
	    if (mp_null(ppair)) {
		dcell = mp_new_data();
		ppair = mp_cons((int) psym, (int) dcell);
		fn_parents(fsym) = mp_cons((int) ppair,
					   fn_parents(fsym));
	    } 
	    fscanf(f, "%d %d %d %d %d %d %d %d %d %d %d %d\n",
		   &d1, &d2, &d3, &d4, &d5, &d6,
		   &d7, &d8, &d9, &d10, &d11, &d12);
	    increment_data(mp_cdr(ppair),
			   d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
	    fscanf(f, "%d\n", &paddr);
	}
    }
    mprof_print(1);
}
    

void
usage()
{
    fprintf(stderr, "mpfilt -- usage: mpfilt <a.out-name> <data-name>\n");
    exit(1);
}

int
main(argc, argv)
int argc;
char *argv[];
{
    int		i;

    if (argc != 3) {
	usage();
    }

    mpstruct_init();
    stab_i = 0;
    for (i = 0; i < ST_SIZE; i++) {
	stab_name(i) = NULL;
    }
    st_read(argv[1]);
    st_convert(argv[2]);
}    

