


mprof(1)                 USER COMMANDS                   mprof(1)



NAME
     mprof - display dynamic memory allocation data

SYNTAX
     mprof [ options ] [ a.out [ mprof.data ] ]

     void set_mprof_autosave(count)
     int count;

     void mprof_stop()

     void mprof_restart(filename)
     char *filename;

DESCRIPTION
     The mprof command produces four tables  that  summarize  the
     memory  allocation  behavior of C programs, similar in style
     to the gprof command.  The arguments to mprof are  the  exe-
     cutable  image  (_a._o_u_t  default)  and  the profile data file
     (_m_p_r_o_f._d_a_t_a default).  The _m_p_r_o_f._d_a_t_a file is  generated  by
     linking  a  special version _m_a_l_l_o_c into the executing image.
     This new version, found in the  library  _l_i_b_c__m_p._a  must  be
     linked in at the end of the command that creates the execut-
     able image.  For example:

          cc -g -o test main.o sub1.o sub2.o libc_mp.a


     Users' programs can contain additional  calls  to  customize
     the user interface to mprof. The function _s_e_t__m_p_r_o_f__a_u_t_o_s_a_v_e
     allows users to save the  profile  data  periodically.   The
     _c_o_u_n_t parameter specifies to save after that number of allo-
     cations.  A value of 10,000 or 100,000 is  typical  for  the
     _c_o_u_n_t  parameter  for  long  running programs.  A value of 0
     (the default) causes the the profile data to be written only
     when  the  program  exits.   The  function _m_p_r_o_f__s_t_o_p causes
     memory profiling to be discontinued and the profile data  to
     be  written  to the output file.  The function _m_p_r_o_f__r_e_s_t_a_r_t
     restarts profiling.  The _f_i_l_e_n_a_m_e parameter to _m_p_r_o_f__r_e_s_t_a_r_t
     specifies the name of the file to write the profile data to.

     The output of mprof consists of four tables, the  fields  of
     which are described in detail below.  The first table breaks
     down the memory allocation of the program by the  number  of
     bytes  requested.   For each byte size the number of alloca-
     tions and frees is listed along with the  program  structure
     types that correspond to that byte size.

     The second table lists partial call chains over which memory
     was  allocated  and  never  freed  (call chains resulting in
     memory leaks).  The table shows how much  memory  was  allo-
     cated  by  each chain and how much each chain contributed to



Sun Release 4.0           Last change:                          1






mprof(1)                 USER COMMANDS                   mprof(1)



     the total memory leakage.

     The third table lists  the  functions  in  which  allocation
     occurred  directly (i.e., called _m_a_l_l_o_c), indicates how much
     memory was allocated, shows how much of that was  not  later
     freed, breaks down allocation roughly by size, and shows how
     many times each function was called.

     The fourth table contains  the  subgraph  of  the  program's
     dynamic call graph in which allocation occurred.  This table
     allows  programmers  to   identify   what   functions   were
     indirectly responsible for memory allocation.

     The following options are available:

     -verbose
          Every bin in which memory was allocated is printed; the
          call chain for every memory leak is shown.

     -normal
          Only bins that contributed a reasonable fraction to the
          total  allocation  are  printed;  call chains for leaks
          contributing more than 0.5% to  the  total  are  shown.
          This is the default verbosity setting.

     -terse
          Only bins that contributed a  significant  fraction  to
          the  total allocation are printed.  Call chains contri-
          buting more than 1% to the total leakage are shown.

     -leaktable
          Print out the memory leak table  without  printing  out
          call site offsets.  This is the default.

     -noleaktable
          Do not print out the memory leak table.

     -offsets
          Print out the memory leak table  and  distinguish  dif-
          ferent  call  sites within a function by indicating the
          offset in the function as part of the  path.   This  is
          useful to identify a particular call site in a function
          with many call sites that allocate memory.

FIELDS IN THE OUTPUT
     Often in the tables, percentages are presented in two column
     fields.   In such a field, a blank indicates 0%, a dot indi-
     cates less than 1%, and two stars indicate 100%.

     When data is broken down by size categories, the  categories
     mean the following:
          s = small                x <= 32 bytes



Sun Release 4.0           Last change:                          2






mprof(1)                 USER COMMANDS                   mprof(1)



          m = medium               32 < x <= 256 bytes
          l = large                256 < x <= 2048 bytes
          x = extra large          x > 2048 bytes

     where x is the exact size of the object being allocated by a
     call  to  malloc.  When data is broken into categories, per-
     centages  are  always  given  in  a   two   column   format.
     Throughout  this  document,  we refer to such a listing as a
     ``breakdown''.

TABLE 1: ALLOCATION BINS
     The memory allocation is broken down by the sizes of objects
     requested and freed.

     size          The size in bytes of the object  allocated  or
                   freed.

     allocs        The number of calls to malloc requesting allo-
                   cation of this size.

     bytes (%)     The total number of bytes allocated to objects
                   of  this size.  The percent indicates the per-
                   cent of the total bytes allocated.

     frees         The number of times objects of this size  were
                   freed.

     kept (%)      The number of bytes of objects  of  this  size
                   that  were never freed.  The percent indicates
                   what fraction of unfreed bytes were  allocated
                   to objects of this size.

     types         A list of the program names of structure types
                   or typedefs that define objects of this size.

TABLE 2: MEMORY LEAKS
     The memory leak table lists the partial  call  chains  which
     allocated  memory  that was never freed.  At most five func-
     tions in the call chain are listed.

     kept bytes (%)
                   The number of bytes allocated on this  partial
                   call  chain  and  not subsequently freed.  The
                   table is sorted by decreasing values  in  this
                   field.   The  percent indicates the percent of
                   total bytes not freed.

     allocs        The number of  allocations  that  occurred  on
                   this partial call chain.

     bytes (%)     The number of bytes allocated on this  partial
                   call chain.  The percent indicates the percent



Sun Release 4.0           Last change:                          3






mprof(1)                 USER COMMANDS                   mprof(1)



                   of the total bytes allocated and never freed.

     frees         The number of frees that occurred on this par-
                   tial  call  chain.   If  no objects were freed
                   this and the following field are ommitted.

     bytes (%)     The number of bytes freed on this partial call
                   chain.  This field is omitted if no bytes were
                   freed.

     path          The partial call chain.  Call chains  starting
                   with  "..."  indicate  that  more callers were
                   present, but were ommitted from  the  listing.
                   Call  chains  consist  of  function names (and
                   possible call site offsets) separated by  ">".
                   Call  site  offsets are indicated by a +n fol-
                   lowing the function name, where n is the  dis-
                   tance in bytes of the call site from the start
                   of  the  function.   Call  site  offsets   are
                   printed using the -offset option.

TABLE 3: DIRECT ALLOCATION
     The <TOTAL> row of the direct allocation listing contains  a
     summary  of  all  the  functions  where such a summary makes
     sense.

     % mem         Percentage of the total memory allocated  that
                   was allocated by this function.

     bytes         The total number of bytes  allocated  by  this
                   function.

     % mem(size)   Size breakdown of the memory allocated by this
                   function  as  a percentage of the total memory
                   allocated by the program.  For example, if the
                   values  for  function MAIN are s=5, m=20, l=4,
                   x=0, then direct calls  to  MALLOC  from  MAIN
                   account for 5+20+4+0 = 29% of the total memory
                   allocated by the program.   Moreover,  20%  of
                   the  total memory allocated by the program was
                   of medium sized objects (between  33  and  256
                   bytes)  by the function MAIN.  The <TOTAL> row
                   represents the breakdown by size  of  all  the
                   memory allocated by the program.

     bytes kept    The number of bytes allocated by this function
                   that were never freed (by calls to FREE).

     % all kept    The size breakdown of objects never  freed  by
                   this  function  as a percentage of all objects
                   never freed.  For example,  if  <%  all  kept>
                   values   for  function  MAIN  are  s=2,  m=10,



Sun Release 4.0           Last change:                          4






mprof(1)                 USER COMMANDS                   mprof(1)



                   l=<blank>, x=<blank>, then 10%  of  the  total
                   bytes  not  freed  were  allocated by MAIN and
                   were allocated in  medium-sized  chunks.   The
                   <TOTAL>  row  represents the size breakdown of
                   all the memory allocated but never freed.

     calls         The number of times this function  was  called
                   to allocate an object.

     name          The name of the function.

TABLE 4: ALLOCATION CALL GRAPH
     A star (*) indicates that this field is omitted  for  ances-
     tors or descendents in the same cycle as the function.

     Cycles are listed twice.  The first appearance shows all the
     functions  that  are  members of the cycle and the amount of
     memory allocated locally in  each  function,  including  the
     breakdown  of the local allocation by size and the breakdown
     by size as a  fraction  of  the  total  cycle.   The  second
     appearance  shows what the call graph would look like if all
     the functions in the cycle were merged into a  single  func-
     tion.

     index         A unique index used to aid searching for func-
                   tions in the call graph listing.

     self + desc   The percent of the total allocated memory that
                   was allocated by this function and its descen-
                   dents.

     self (%)      The number of bytes allocated by the  function
                   itself.  The percentage indicates the fraction
                   of the bytes allocated by the function and its
                   descendents  that  were allocated in the func-
                   tion itself.

     size-func     The size breakdown of objects allocated in the
                   function  itself  (not  including  its descen-
                   dents.)

     called        The number of times this function  was  called
                   while allocating memory.

     recur         The number of recursive function  calls  while
                   allocating memory.

     name          The function  name  including  possible  cycle
                   membership and index.

ANCESTOR LISTINGS
     If the word ``all'' appears in the  <self  +  desc>  column,



Sun Release 4.0           Last change:                          5






mprof(1)                 USER COMMANDS                   mprof(1)



     then  this row represents a summary of all the ancestors and
     presents the total number of bytes requested by  all  ances-
     tors in the <bytes> column, and the breakdown of these bytes
     by size in the <self-ances> breakdown columns.  If there  is
     only one ancestor, then this summary is omitted.

     *self (%)     The number of bytes allocated by the  function
                   and  its  descendents  that  were allocated on
                   behalf of this parent.  The  percentage  indi-
                   cates  what  fraction of the total bytes allo-
                   cated by the function and its descendents were
                   allocated on behalf of this parent.

     *size-ances   The size breakdown of the bytes  allocated  by
                   the  function and its descendents on behalf of
                   this parent.

     *frac-ances   The size breakdown of the objects allocated in
                   the  function and its descendents on behalf of
                   this parent as a  percentage  of  all  objects
                   allocated by the function and its descendents.
                   For example if parent P1  of  function  F  has
                   <frac-ances>   values   s=<blank>,  m=<blank>,
                   l=30, x=<blank>, then 30% of all objects allo-
                   cated  by  F  and its descendents are of large
                   objects allocated on behalf of parent P1.

     called        The number of times this  parent  called  this
                   function while requesting memory.

     *total        The number of calls this parent made  request-
                   ing memory from any function.

     ancestors     The name  of  the  parent  including  possible
                   cycle membership and index.

DESCENDENT LISTINGS
     If the word ``all'' appears in the  <self  +  desc>  column,
     then  this  row  represents a summary of all the descendents
     and presents the total number of bytes allocated by all des-
     cendents  in  the <bytes> column, and the breakdown of these
     bytes by size in  the  <self-desc>  breakdown  columns.   If
     there is only one descendent, then this summary is omitted.

     *self (%)     The number of bytes allocated in this  descen-
                   dent that were allocated at the request of the
                   function.  The percentage indicates what frac-
                   tion  of  the total bytes allocated in descen-
                   dents of the function were allocated  in  this
                   descendent.

     *size-ances   The size breakdown of the bytes  allocated  by



Sun Release 4.0           Last change:                          6






mprof(1)                 USER COMMANDS                   mprof(1)



                   this descendent on behalf of the function.

     *frac-desc    The size breakdown of the objects allocated in
                   this descendent on behalf of the function as a
                   percentage of all  objects  allocated  by  all
                   descendents  on  behalf of this function.  For
                   example if descendent C1  of  function  F  has
                   <frac-desc> values s=35, m=<blank>, l=<blank>,
                   x=<blank>, then 35% of all  objects  allocated
                   by  children of F on its behalf were allocated
                   in child C1 and were small objects.

     called        The number of times the function  called  this
                   descendent while requesting memory.

     *total        The number of times this descendent was called
                   during a memory request.

     descendents   The name of the child including possible cycle
                   membership and index.

FILES
     a.out          contains symbol table information.
     mprof.data     memory allocation call graph information.
     libc_mp.a special version of malloc which profiles allocation.
                     (eventually to be put in /lib/local/mprof/libc_mp.a)

SEE ALSO
     cc(1), gprof(1)
     _A _M_e_m_o_r_y _A_l_l_o_c_a_t_i_o_n _P_r_o_f_i_l_e_r _f_o_r _C _a_n_d _L_i_s_p _P_r_o_g_r_a_m_s, Benja-
     min Zorn and Paul Hilfinger, Summer 1988 USENIX Conference.

AUTHOR
     Written by Benjamin Zorn, zorn@ernie.berkeley.edu,  as  part
     of Ph.D.  research sponsored by the SPUR research project.

BUGS
     The code that determines the names and sizes of  user  types
     is  poorly written and depends on the program being compiled
     with the -g option.   In  some  cases  (mostly  very  simple
     cases) the user type names are not correctly determined.

     If the user application calls _v_a_l_l_o_c or _m_e_m_a_l_i_g_n  and  later
     tries  to  free that memory, mprof will cause a segmentation
     fault.










Sun Release 4.0           Last change:                          7



