# plexus-support.pl -- # Plexus support routines used by ArchiePlex.
#
# Need to use these when not running under Plexus.
#
# $Id: plexus-support.pl,v 1.4 1994/09/01 11:36:42 mak Exp $
#

sub main'error {
    local($exception, $msg) = @_;

$code{'bad_request'}      = '400 Bad Request';
$code{'forbidden'}        = '403 Forbidden';
$code{'timed_out'}        = '502 Timed Out';

    if (defined $code{$exception})
    {
       print <<"EOM";
Status: $code{$exception}
Content-type: text/plain

<HEAD>
  <TITLE>Server Error: $code{$exception}</TITLE>
</HEAD>
<BODY>
  <H1>Server Error: $code{$exception}</H1>
    $msg
  <P>
     If you feel this is a server problem and wish to report it, please
     include the error code, the requested URL, which and what version
     browser you are using, and any other facts that might be relevant to:
  <P>
  <ADDRESS>$main'maintainer</ADDRESS>
</BODY>
EOM
	exit;
    }
    else
    {
	die "EXCEPTION: $exception\n$msg\n";
    }
}

# This is the only part that archieplex needs to print:
sub main'add_header {
}

sub main'MIME_header {
	print "Content-type: text/html\n\n";
}
sub main'clear_timeout {
	$SIG{'ALRM'} = '';
	alarm(0);
}
sub main'debug {
    print STDERR @_, "\n" if $debug;
}

1; # for require
