

#! /bin/csh
#
#			Install HTTP Hytelnet daemon
#
#  This script works for regular BSD unix systems.  It will not
#  necessarily work with fancy bells and whistles.
#  Check all the places where BSD is mentioned for differences for sys V
#
#  Installs  service=htnwww, port=8002, server=htngate
#  Tested on: NeXT_3.0
#
#  Supposed to work with NeXT netinfo.
#  Supposed to work with yp
#
#  Read first then run it as root
#  Running it more than once won't harm anything.
#  You can run it if the server is already partially installed,
#  and it will try to fix up what is missing.

set yes = 1
set no = 0

set signal_inetd = $no

#		Copy over daemon


if ( "$WWW_MACH" == "" ) then
    echo You must first setenv WWW_MACH to give your machine type
    exit
endif

if ( -e ../$WWW_MACH/htn2html ) then
    cp -i ../$WWW_MACH/htn2html /usr/etc/htn2html
else
    echo There is no ../$WWW_MACH/htn2html daemon executable file for $WWW_MACH
    echo Try making it first.
    exit 2
endif

if ( -e htngate ) then
    cp -i htngate /usr/etc/htngate
else
    echo There is no htngate daemon script file!!

    exit 2
endif


#   Put htnwww into netinfo or /etc/service if necessary

#   netinfo services:
if ( -d /etc/netinfo ) then
    echo You have netinfo, so we will use that.
    set service = htnwww
    niutil -read . services/htnwww >/dev/null
    if ($status == 0) then
        echo Service htnwww defined already
    else
        niutil -create . services/htnwww
	set signal_inetd = $yes
    endif
    niutil -createprop . services/htnwww port 8002
    niutil -createprop . services/htnwww protocol tcp
else
#    real  /etc/services file
    grep "^[^ \t]*[ \t]*8002/tcp" /etc/services >/dev/null
    if ($status == 0) then
	set service = ( `grep "^[^ \t]*[ \t]*8002/tcp" /etc/services` )
	set service = $service[1]
	echo "  Port 8002 service is already defined as" $service
    else
	set service = htnwww
	echo "Adding service htnwww on port 8002"
	echo "www	8002/tcp	# World-Wide Web information service" /
		 >> /etc/services
	if ( -r /var/yp ) then
	    echo You seem to have yellow pages. Rebuilding yp for services
	    ( cd /var/yp; make )
	endif
    endif
endif

#   		Put htngate into inetd.conf if not in already

grep "^${service}" /etc/inetd.conf > /dev/null
if ($status == 0) then
    set server = ( `grep "^${service}" /etc/inetd.conf` )
#   check the index 6 below if not bsd
    echo $service daemon already defined to be $server[6]
else
    cat <<EOF >> /etc/inetd.conf
#  WorldWide Web service: add -l logfile if logging needed
htnwww	stream	tcp	nowait	nobody	/usr/etc/htngate htngate
EOF
    if ($status != 0) exit;
    echo The daemon has been added to the inetd configuration file.
    set signal_inetd = $yes
endif

#   		Send singal to inetd to make it reread inetd.conf


if ( $signal_inetd ) then
    echo 
#   @@@ BSD only: check which column the process number is in from ps aux!
#   @@@ BSD and the aux should be -el or someting in SysV
    set inetd = ( `ps aux | grep inetd | grep -v grep` )
    echo Sending HUP signal to inetd process $inetd[2] 
    kill -HUP $inetd[2]
endif

#		Test it ... requires www to be installed.

set here = `hostname`
if ( -x ../../LineMode/$WWW_MACH/www ) then
    echo Testing new server...
    ../../LineMode/$WWW_MACH/www -n http://$here:8002/
    if ($status != 0) then
	echo "****" TEST FAILED
	exit 3
    else
	echo WWW3 server on `hostname` Tested aparently OK.
    endif
else
    echo Cannot test it: no www in ../../LineMode/$WWW_MACH
endif

#	    Log it to www team at cern to keep some statistics.

mail -s "$here installed W3 hytelnet gateway " \
	www-log@info.cern.ch < $0
exit
