package App::InteractivePerlTutorial::Chapter::Arrays::Variables;

use v5.14;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Assignment';

1;
__DATA__

=encoding utf-8

=head1 Variables

Unlike scalars variables, arrays are group of containers which hold multiple values. Arrays names start with a @ preceded by a letter or underscore then zero or more letters, digits or underscores, for example:

  @gg_wp
  @_cool
  @Story
  @br0

We declare them with the C<my> function, as we do with scalars.

  my @help;

After this @help has no scalar in it.

=head2 Assignment

There are many ways to set values to every scalar from an array.

=head3 method  1

Because every element of the array is a scalar we can refer to them by C<$>(name of the array)C<[>(position)C<]>. If the array isn't big enough(in our example it's empty) it makes more rooms for the new values. Examples:

  $help[0]=1;           # here position 0 was made and value 1 was saved in it
  $help[5]="Hi Nick!";  # here all position to 5 were made,but only the last is used to save the value of the string "Hi Nick!", others being undefined
  $help[-2]=$x;

Note that first position is 0 and not 1. Also negative numbers can be used to refer to the scalars from the end of the array (-1 is the last element,-2 the last but one and so on). In our example -2 is position 4. It's good to know that you can't extend an array with negative numbers.

=head3 method 2

We can also use list to assign values to arrays like this:

  my @ok;
  @ok=(1, "b", $x);

which is the same with

  my @ok;
  $ok[0]=1;
  $ok[1]="b";
  $ok[2]=$x;

or like this:

  my @okey;
  ($x, @okey, $y)=(1..6);

In the last code line $x took value 1 and @ok all values from 2 to 6. Since no value was left, $y remained with the value before the operation.


=cut
