package Task::Map::Tube;

# Pragmas.
use strict;
use warnings;

# Version.
our $VERSION = 0.34;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Task::Map::Tube - Install the Map::Tube modules.

=head1 SYNOPSIS

 cpanm Task::Map::Tube

=head1 SEE ALSO

L<Task::MapMetro::Maps>.

L<Task::Map::Tube::Metro>.

L<Map::Tube>,
L<Map::Tube::CLI>,
L<Map::Tube::Graph>,
L<Map::Tube::GraphViz>,
L<Map::Tube::Plugin::Formatter>,
L<Map::Tube::Plugin::FuzzyFind>,
L<Map::Tube::Plugin::Graph>,
L<Map::Tube::Text::Shortest>,
L<Map::Tube::Text::Table>,
L<Test::Map::Tube>,

=head1 REPOSITORY

L<https://github.com/tupinek/Task-Map-Tube>

=head1 AUTHOR

Michal Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

 © 2014-2015 Michal Špaček
 Artistic License
 BSD 2-Clause License

=head1 VERSION

0.34

=cut
