#!/usr/bin/perl

package eBay::API::XML::Call::GetSessionID;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSessionID.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSessionID

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSessionID inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetSessionID::GetSessionIDRequestType;
use eBay::API::XML::Call::GetSessionID::GetSessionIDResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetSessionID';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSessionID::GetSessionIDRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSessionID::GetSessionIDResponseType';
}

#
# input properties
#

=head2 setRuName()

The runame provided must match the one that will be used for validation
during the creation of a user token.

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut
       
sub setRuName {
   my $self   = shift;
   my $sRuName = shift;
   $self->getRequestDataType()->setRuName($sRuName);
}



#
# output properties
#

=head2 getSessionID()

A 32-character identifier supplied by eBay to an application. Used to confirm the
identities of the user and the application in a URL redirect during the
process in which the user agrees to let the application wield a user token that
grants the application the right to access eBay data on behalf of the user.
Subsequently also used as input for the FetchToken API call.

  Returned: Always
#    Returns: 'xs:string'

=cut
       
sub getSessionID {
   my $self = shift;
   return $self->getResponseDataType()->getSessionID();
}





1;   
