use ExtUtils::MakeMaker;

my @C = grep { not /test/ } glob "*.c";
my $object = join " ", map { s/\.c$/\$(OBJ_EXT)/; $_ } @C;

WriteMakefile(
    NAME => 'libfmt',
    C => [ @C ],
    OBJECT => $object,
    INC => '-I. -I../libutf',
);

package MY;

# Don't make .bs files
sub dynamic
{
    my $self = shift;
    my $res = $self->SUPER::dynamic(@_);
    $res =~ s/\s*\$\(INST_BOOT\)//;
    $res;
}

# Don't make dynamic libs from the .o files, just the objects
sub dynamic_lib
{
    '$(INST_DYNAMIC): $(OBJECT)' . "\n" .
    "\t" . '$(NOECHO) $(NOOP)' . "\n"
}
