/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.util.Properties;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSCONGLOMERATESRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSCONGLOMERATES";
    protected static final int SYSCONGLOMERATES_COLUMN_COUNT = 8;
    protected static final int SYSCONGLOMERATES_SCHEMAID = 1;
    protected static final int SYSCONGLOMERATES_TABLEID = 2;
    protected static final int SYSCONGLOMERATES_CONGLOMERATENUMBER = 3;
    protected static final int SYSCONGLOMERATES_CONGLOMERATENAME = 4;
    protected static final int SYSCONGLOMERATES_ISINDEX = 5;
    protected static final int SYSCONGLOMERATES_DESCRIPTOR = 6;
    protected static final int SYSCONGLOMERATES_ISCONSTRAINT = 7;
    protected static final int SYSCONGLOMERATES_CONGLOMERATEID = 8;
    protected static final int SYSCONGLOMERATES_INDEX1_ID = 0;
    protected static final int SYSCONGLOMERATES_INDEX2_ID = 1;
    protected static final int SYSCONGLOMERATES_INDEX3_ID = 2;
    private static final boolean[] uniqueness = new boolean[]{false, true, false};
    private static final int[][] indexColumnPositions = new int[][]{{8}, {4, 1}, {2}};
    private static final String[][] indexColumnNames = new String[][]{{"CONGLOMERATE_ID"}, {"CONGLOMERATE_NAME", "SCHEMAID"}, {"TABLEID"}};
    private static final String[] uuids = new String[]{"80000010-00d0-fd77-3ed8-000a0a0b1900", "80000027-00d0-fd77-3ed8-000a0a0b1900", "80000012-00d0-fd77-3ed8-000a0a0b1900", "80000014-00d0-fd77-3ed8-000a0a0b1900", "80000016-00d0-fd77-3ed8-000a0a0b1900"};

    SYSCONGLOMERATESRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, boolean bl) {
        super(uUIDFactory, executionFactory, dataValueFactory, bl);
        this.initInfo(8, TABLENAME_STRING, indexColumnPositions, indexColumnNames, uniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string = null;
        Long l = null;
        String string2 = null;
        Boolean bl = null;
        IndexRowGenerator indexRowGenerator = null;
        Boolean bl2 = null;
        String string3 = null;
        String string4 = null;
        ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)tupleDescriptor;
        if (tupleDescriptor != null) {
            if (tupleDescriptor2 != null) {
                SchemaDescriptor schemaDescriptor = (SchemaDescriptor)tupleDescriptor2;
                string4 = schemaDescriptor.getUUID().toString();
            } else {
                string4 = conglomerateDescriptor.getSchemaID().toString();
            }
            string = conglomerateDescriptor.getTableID().toString();
            l = new Long(conglomerateDescriptor.getConglomerateNumber());
            string2 = conglomerateDescriptor.getConglomerateName();
            string3 = conglomerateDescriptor.getUUID().toString();
            bl = new Boolean(conglomerateDescriptor.isIndex());
            indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
            bl2 = new Boolean(conglomerateDescriptor.isConstraint());
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(8);
        execRow.setColumn(1, this.dvf.getCharDataValue(string4));
        execRow.setColumn(2, this.dvf.getCharDataValue(string));
        execRow.setColumn(3, this.dvf.getDataValue(l));
        execRow.setColumn(4, string2 == null ? this.dvf.getVarcharDataValue(string) : this.dvf.getVarcharDataValue(string2));
        execRow.setColumn(5, this.dvf.getDataValue(bl));
        execRow.setColumn(6, this.dvf.getDataValue(indexRowGenerator == null ? (IndexDescriptor)null : indexRowGenerator.getIndexDescriptor()));
        execRow.setColumn(7, this.dvf.getDataValue(bl2));
        execRow.setColumn(8, this.dvf.getCharDataValue(string3));
        return execRow;
    }

    public ExecRow makeEmptyRow() throws StandardException {
        return this.makeRow(null, null);
    }

    public ExecIndexRow buildEmptyIndexRow(int n, RowLocation rowLocation) throws StandardException {
        int n2 = this.getIndexColumnCount(n);
        ExecIndexRow execIndexRow = this.getExecutionFactory().getIndexableRow(n2 + 1);
        execIndexRow.setColumn(n2 + 1, rowLocation);
        switch (n) {
            case 0: {
                execIndexRow.setColumn(1, this.getDataValueFactory().getCharDataValue(null));
                break;
            }
            case 1: {
                execIndexRow.setColumn(1, this.getDataValueFactory().getVarcharDataValue(null));
                execIndexRow.setColumn(2, this.getDataValueFactory().getCharDataValue(null));
                break;
            }
            case 2: {
                execIndexRow.setColumn(1, this.getDataValueFactory().getCharDataValue(null));
            }
        }
        return execIndexRow;
    }

    public Properties getCreateHeapProperties() {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "4096");
        properties.put("derby.storage.pageReservedSpace", "0");
        properties.put("derby.storage.minimumRecordSize", "1");
        return properties;
    }

    public Properties getCreateIndexProperties(int n) {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "4096");
        return properties;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        String string2 = dataValueDescriptor.getString();
        UUID uUID2 = this.getUUIDFactory().recreateUUID(string2);
        dataValueDescriptor = execRow.getColumn(3);
        long l = dataValueDescriptor.getLong();
        dataValueDescriptor = execRow.getColumn(4);
        String string3 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(5);
        boolean bl = dataValueDescriptor.getBoolean();
        dataValueDescriptor = execRow.getColumn(6);
        IndexRowGenerator indexRowGenerator = new IndexRowGenerator((IndexDescriptor)dataValueDescriptor.getObject());
        dataValueDescriptor = execRow.getColumn(7);
        boolean bl2 = dataValueDescriptor.getBoolean();
        dataValueDescriptor = execRow.getColumn(8);
        String string4 = dataValueDescriptor.getString();
        UUID uUID3 = this.getUUIDFactory().recreateUUID(string4);
        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(l, string3, bl, indexRowGenerator, bl2, uUID3, uUID2, uUID);
        return conglomerateDescriptor;
    }

    protected UUID getConglomerateUUID(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(8);
        String string = dataValueDescriptor.getString();
        return this.getUUIDFactory().recreateUUID(string);
    }

    protected UUID getTableUUID(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(2);
        String string = dataValueDescriptor.getString();
        return this.getUUIDFactory().recreateUUID(string);
    }

    protected UUID getSchemaUUID(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        return this.getUUIDFactory().recreateUUID(string);
    }

    protected String getConglomerateName(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(4);
        return dataValueDescriptor.getString();
    }

    public SystemColumn[] buildColumnList() {
        int n = 0;
        SystemColumn[] systemColumnArray = new SystemColumn[8];
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("SCHEMAID"), 1, 0, 0, false, "CHAR", true, 36);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("TABLEID"), 2, 0, 0, false, "CHAR", true, 36);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("CONGLOMERATENUMBER"), 3, 0, 0, false, "BIGINT", true, 8);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("CONGLOMERATENAME"), 4, true);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("ISINDEX"), 5, 0, 0, false, "BOOLEAN", true, 1);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("DESCRIPTOR"), 6, 0, 0, true, "org.apache.derby.catalog.IndexDescriptor", false, -1);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("ISCONSTRAINT"), 7, 0, 0, true, "BOOLEAN", true, 1);
        systemColumnArray[n++] = new SystemColumnImpl(this.convertIdCase("CONGLOMERATEID"), 8, 0, 0, false, "CHAR", true, 36);
        return systemColumnArray;
    }
}

