/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class PDJpeg
extends PDXObjectImage {
    private static final List DCT_FILTERS = new ArrayList();

    public PDJpeg(PDStream jpeg) {
        super(jpeg, "jpg");
    }

    public PDJpeg(PDDocument doc, InputStream is) throws IOException {
        super(new PDStream(doc, is, true), "jpg");
        COSStream dic = this.getCOSStream();
        dic.setItem(COSName.FILTER, (COSBase)COSName.DCT_DECODE);
        dic.setItem(COSName.SUBTYPE, (COSBase)COSName.IMAGE);
        dic.setItem(COSName.TYPE, (COSBase)COSName.getPDFName("XObject"));
        BufferedImage image = this.getRGBImage();
        if (image != null) {
            this.setBitsPerComponent(8);
            this.setColorSpace(PDDeviceRGB.INSTANCE);
            this.setHeight(image.getHeight());
            this.setWidth(image.getWidth());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDJpeg(PDDocument doc, BufferedImage bi) throws IOException {
        super(new PDStream(doc), "jpg");
        OutputStream os = this.getCOSStream().createFilteredStream();
        try {
            ImageIO.write((RenderedImage)bi, "jpeg", os);
            COSStream dic = this.getCOSStream();
            dic.setItem(COSName.FILTER, (COSBase)COSName.DCT_DECODE);
            dic.setItem(COSName.SUBTYPE, (COSBase)COSName.IMAGE);
            dic.setItem(COSName.TYPE, (COSBase)COSName.getPDFName("XObject"));
            this.setBitsPerComponent(8);
            this.setColorSpace(PDDeviceRGB.INSTANCE);
            this.setHeight(bi.getHeight());
            this.setWidth(bi.getWidth());
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getRGBImage() throws IOException {
        File imgFile = null;
        BufferedImage bi = null;
        boolean readError = false;
        try {
            imgFile = File.createTempFile("pdjpeg", ".jpeg");
            this.write2file(imgFile);
            try {
                bi = ImageIO.read(imgFile);
            }
            catch (IIOException iioe) {
                readError = true;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (bi == null && readError) {
                int read;
                byte[] newImage = this.replaceHeader(imgFile);
                ByteArrayInputStream bai = new ByteArrayInputStream(newImage);
                FileOutputStream o = new FileOutputStream(imgFile);
                byte[] buffer = new byte[512];
                while ((read = bai.read(buffer)) > 0) {
                    o.write(buffer, 0, read);
                }
                bai.close();
                o.close();
                bi = ImageIO.read(imgFile);
            }
        }
        finally {
            if (imgFile != null) {
                imgFile.delete();
            }
        }
        return bi;
    }

    public void write2OutputStream(OutputStream out) throws IOException {
        InputStream data = this.getPDStream().getPartiallyFilteredStream(DCT_FILTERS);
        byte[] buf = new byte[1024];
        int amountRead = -1;
        while ((amountRead = data.read(buf)) != -1) {
            out.write(buf, 0, amountRead);
        }
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File is tooo large");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    private int getHeaderEndPos(byte[] image) {
        for (int i = 0; i < image.length; ++i) {
            byte b = image[i];
            if (b != -37) continue;
            return i - 2;
        }
        return 0;
    }

    private byte[] replaceHeader(File jpegFile) throws IOException {
        byte[] image = PDJpeg.getBytesFromFile(jpegFile);
        int pos = this.getHeaderEndPos(image);
        byte[] header = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 1, 1, 0, 96, 0, 96, 0, 0};
        byte[] newImage = new byte[image.length - pos + header.length - 1];
        System.arraycopy(header, 0, newImage, 0, header.length);
        System.arraycopy(image, pos + 1, newImage, header.length, image.length - pos - 1);
        return newImage;
    }

    static {
        DCT_FILTERS.add(COSName.DCT_DECODE.getName());
        DCT_FILTERS.add(COSName.DCT_DECODE_ABBREVIATION.getName());
    }
}

