# Generated by default/object.tt
package Paws::DynamoDB::ExportDescription;
  use Moose;
  has BilledSizeBytes => (is => 'ro', isa => 'Int');
  has ClientToken => (is => 'ro', isa => 'Str');
  has EndTime => (is => 'ro', isa => 'Str');
  has ExportArn => (is => 'ro', isa => 'Str');
  has ExportFormat => (is => 'ro', isa => 'Str');
  has ExportManifest => (is => 'ro', isa => 'Str');
  has ExportStatus => (is => 'ro', isa => 'Str');
  has ExportTime => (is => 'ro', isa => 'Str');
  has FailureCode => (is => 'ro', isa => 'Str');
  has FailureMessage => (is => 'ro', isa => 'Str');
  has ItemCount => (is => 'ro', isa => 'Int');
  has S3Bucket => (is => 'ro', isa => 'Str');
  has S3BucketOwner => (is => 'ro', isa => 'Str');
  has S3Prefix => (is => 'ro', isa => 'Str');
  has S3SseAlgorithm => (is => 'ro', isa => 'Str');
  has S3SseKmsKeyId => (is => 'ro', isa => 'Str');
  has StartTime => (is => 'ro', isa => 'Str');
  has TableArn => (is => 'ro', isa => 'Str');
  has TableId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DynamoDB::ExportDescription

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DynamoDB::ExportDescription object:

  $service_obj->Method(Att1 => { BilledSizeBytes => $value, ..., TableId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DynamoDB::ExportDescription object:

  $result = $service_obj->Method(...);
  $result->Att1->BilledSizeBytes

=head1 DESCRIPTION

Represents the properties of the exported table.

=head1 ATTRIBUTES


=head2 BilledSizeBytes => Int

The billable size of the table export.


=head2 ClientToken => Str

The client token that was provided for the export task. A client token
makes calls to C<ExportTableToPointInTimeInput> idempotent, meaning
that multiple identical calls have the same effect as one single call.


=head2 EndTime => Str

The time at which the export task completed.


=head2 ExportArn => Str

The Amazon Resource Name (ARN) of the table export.


=head2 ExportFormat => Str

The format of the exported data. Valid values for C<ExportFormat> are
C<DYNAMODB_JSON> or C<ION>.


=head2 ExportManifest => Str

The name of the manifest file for the export task.


=head2 ExportStatus => Str

Export can be in one of the following states: IN_PROGRESS, COMPLETED,
or FAILED.


=head2 ExportTime => Str

Point in time from which table data was exported.


=head2 FailureCode => Str

Status code for the result of the failed export.


=head2 FailureMessage => Str

Export failure reason description.


=head2 ItemCount => Int

The number of items exported.


=head2 S3Bucket => Str

The name of the Amazon S3 bucket containing the export.


=head2 S3BucketOwner => Str

The ID of the AWS account that owns the bucket containing the export.


=head2 S3Prefix => Str

The Amazon S3 bucket prefix used as the file name and path of the
exported snapshot.


=head2 S3SseAlgorithm => Str

Type of encryption used on the bucket where export data is stored.
Valid values for C<S3SseAlgorithm> are:

=over

=item *

C<AES256> - server-side encryption with Amazon S3 managed keys

=item *

C<KMS> - server-side encryption with AWS KMS managed keys

=back



=head2 S3SseKmsKeyId => Str

The ID of the AWS KMS managed key used to encrypt the S3 bucket where
export data is stored (if applicable).


=head2 StartTime => Str

The time at which the export task began.


=head2 TableArn => Str

The Amazon Resource Name (ARN) of the table that was exported.


=head2 TableId => Str

Unique ID of the table that was exported.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DynamoDB>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

