# Generated by default/object.tt
package Paws::Macie2::IpOwner;
  use Moose;
  has Asn => (is => 'ro', isa => 'Str', request_name => 'asn', traits => ['NameInRequest']);
  has AsnOrg => (is => 'ro', isa => 'Str', request_name => 'asnOrg', traits => ['NameInRequest']);
  has Isp => (is => 'ro', isa => 'Str', request_name => 'isp', traits => ['NameInRequest']);
  has Org => (is => 'ro', isa => 'Str', request_name => 'org', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::IpOwner

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::IpOwner object:

  $service_obj->Method(Att1 => { Asn => $value, ..., Org => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::IpOwner object:

  $result = $service_obj->Method(...);
  $result->Att1->Asn

=head1 DESCRIPTION

Provides information about the registered owner of an IP address.

=head1 ATTRIBUTES


=head2 Asn => Str

The autonomous system number (ASN) for the autonomous system that
included the IP address.


=head2 AsnOrg => Str

The organization identifier that's associated with the autonomous
system number (ASN) for the autonomous system that included the IP
address.


=head2 Isp => Str

The name of the internet service provider (ISP) that owned the IP
address.


=head2 Org => Str

The name of the organization that owned the IP address.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

