#!/usr/bin/perl

package eBay::API::XML::Call::UploadSiteHostedPictures::UploadSiteHostedPicturesRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. UploadSiteHostedPicturesRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::UploadSiteHostedPictures::UploadSiteHostedPicturesRequestType

=head1 DESCRIPTION

Uploads a picture to EPS (eBay Picture Services) 
by including a binary attachment.
This call is available only in the XML API (not in the SOAP API).
This call requires that you use HTTP version 1.0.
<br>
<br>
This call will only be successful if a binary attachment is included,
after the XML input, as part of the request.
<br>
<br>
If you want to use this call as part of the My Picture Uploads feature,
see <a href="#Request.PictureUploadPolicy">PictureUploadPolicy</a>.
<br>
<br>
Please see <a href="https://ebay.custhelp.com/cgi-bin/ebay.cfg/php/enduser/std_adp.php?p_faqid=1063" target="_blank">FAQs on eBayPictureServices (EPS) and the UploadSiteHostedPictures API call</a> and see samples at the following locations:
<br>
<br>
<a href="https://ebay.custhelp.com/cgi-bin/ebay.cfg/php/enduser/std_adp.php?p_faqid=1050" target="_blank">Java sample for UploadSiteHostedPictures</a>
<br>
<br>
<a href="https://ebay.custhelp.com/cgi-bin/ebay.cfg/php/enduser/std_adp.php?p_faqid=1093" target="_blank">.NET sample in C# for UploadSiteHostedPictures</a>
<br>
<br>
<a href="https://ebay.custhelp.com/cgi-bin/ebay.cfg/php/enduser/std_adp.php?p_faqid=1092" target="_blank">    PHP sample for UploadSiteHostedPictures</a>
<br>
<br>
<a href="http://ebay.custhelp.com/cgi-bin/ebay.cfg/php/enduser/std_adp.php?p_faqid=1116" target="_blank">    VB6 sample for UploadSiteHostedPictures</a>
<br>
<br>
The binary attachment is image data, including headers,
from a JPG, GIF, PNG, BMP, or TIF format image file.
JPG is recommended. If you use, for example, PNG, it will be converted 
to JPG (or GIF) format. 
<br>
<br>
The binary attachment must be sent after
the XML input as a MIME attachment,
in the same POST request.
<br>
<br>
The only necessary call-specific input is an attachment of a picture.
An EPS (eBay Picture Services) URL is returned for the picture, 
in SiteHostedPictureDetails.FullURL. The value in
SiteHostedPictureDetails.FullURL must be stored
by your application (for use by AddItem, ReviseItem, or RelistItem in the  
Item.PictureDetails.PictureURL field)
because no API call is available for finding a
URL of an uploaded, unassociated picture.
<br>
<br>
That is, your application uses the value in SiteHostedPictureDetails.FullURL to
associate the picture with an item (using 
Item.PictureDetails.PictureURL in AddItem, ReviseItem, or RelistItem).
This must be done within 48 hours; unassociated pictures
are automatically deleted after that period.
<br>
<br>
The maximum picture size is 4 MB.
EPS downscales and compresses the picture to store it at the different sizes in the imageset.
For good quality results, the recommended minimum dimensions of the uploaded picture
are at least 1000 pixels on the longer side. Recommended JPG quality is 90 or greater.
The file size of images meeting these minimum requirements is 200KB-400KB.
Larger dimensions and file sizes will not typically provide better quality
in the final images processed by EPS.
<br>
<br>
If the dimensions of an uploaded picture are less than a size that is stored in EPS,
the upload will be accepted (without warning) and the stored picture
will be the same dimensions as the uploaded picture.
In this case, image quality of the stored picture is likely to be degraded.
<br>
<br>
If end-users use image processing editors or utilities to prepare
pictures for upload (e.g., crop, rotates, brightness correction, etc.),
they should avoid use of Save for the Web commands or options to save
output since these will cause reduced image quality after the uploaded
pictures are processed by EPS. They should use the standard Save command instead.
<br>
<br>
EPS supports upload of image data in JPG, GIF, PNG, BMP, and TIF formats.
Other image formats, such as PSD, will result in an error.
Successfully processed uploads for item pictures are stored
in EPS in JPG format, at sizes and compression settings designed
to provide the best trade-off between image quality and page-load times.
<br>
<br>
If the API request specifies a Supersize imageset and the response confirms
that a Supersize or Large imageset was created, then the AddItem,
ReviseItem, or RelistItem call must specify Supersize or PicturePack
as the PhotoDisplayType. In the case of ReviseItem, if there are existing
pictures for a listing, it is not possible to change the PhotoDisplayType
from Normal to Supersize or PicturePack.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::UploadSiteHostedPictures::UploadSiteHostedPicturesRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::Base64BinaryType;
use eBay::API::XML::DataType::Enum::PictureSetCodeType;
use eBay::API::XML::DataType::Enum::PictureUploadPolicyCodeType;


my @gaProperties = ( [ 'PictureData', 'ns:Base64BinaryType', ''
	     ,'eBay::API::XML::DataType::Base64BinaryType', '1' ]
	, [ 'PictureName', 'xs:string', '', '', '' ]
	, [ 'PictureSet', 'ns:PictureSetCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PictureSetCodeType', '' ]
	, [ 'PictureSystemVersion', 'xs:int', '', '', '' ]
	, [ 'PictureUploadPolicy', 'ns:PictureUploadPolicyCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PictureUploadPolicyCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setPictureData()

An optional reference ID to the binary attachment.
The PictureData field does not contain the binary attachment.
The binary attachment is image data,
including headers, from a JPG, GIF, PNG, BMP, or TIF format image file.
The binary attachment must be sent as a MIME attachment,
in your POST request, after the XML input.

  RequiredInput: No
#    Argument: 'ns:Base64BinaryType'

=cut

sub setPictureData {
  my $self = shift;
  $self->{'PictureData'} = shift
}

=head2 getPictureData()

#    Returns: 'ns:Base64BinaryType'

=cut

sub getPictureData {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PictureData'
		,'eBay::API::XML::DataType::Base64BinaryType');
}


=head2 setPictureName()

A name you provide for the picture. 
Returned as SiteHostedPictureDetails.PictureName in the call response.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setPictureName {
  my $self = shift;
  $self->{'PictureName'} = shift
}

=head2 getPictureName()

#    Returns: 'xs:string'

=cut

sub getPictureName {
  my $self = shift;
  return $self->{'PictureName'};
}


=head2 setPictureSet()

The image sizes that will be generated.

  RequiredInput: No
  AllValuesExcept: Large
  Default: Standard
#    Argument: 'ns:PictureSetCodeType'

=cut

sub setPictureSet {
  my $self = shift;
  $self->{'PictureSet'} = shift
}

=head2 getPictureSet()

#    Returns: 'ns:PictureSetCodeType'

=cut

sub getPictureSet {
  my $self = shift;
  return $self->{'PictureSet'};
}


=head2 setPictureSystemVersion()

Specifies the picture system version. Only version 2 is valid. 
Available to support future changes in the picture system version.

  RequiredInput: No
  Default: 2
#    Argument: 'xs:int'

=cut

sub setPictureSystemVersion {
  my $self = shift;
  $self->{'PictureSystemVersion'} = shift
}

=head2 getPictureSystemVersion()

#    Returns: 'xs:int'

=cut

sub getPictureSystemVersion {
  my $self = shift;
  return $self->{'PictureSystemVersion'};
}


=head2 setPictureUploadPolicy()

When the My Picture Uploads feature is available (see the Trading API Release Notes), applications
(including non-listing apps, such as photo-editors and digital-camera software) will be able to use 
the PictureUploadPolicy field to specify that an uploaded picture is available to a seller on the eBay site. When you use PictureUploadPolicy, you are specifying that the picture you uploaded (and its URL) is stored for 48 hours on the eBay site. (If, within 48 hours, the picture is associated with an item, 
then it persists on the eBay site for the same time length as other pictures uploaded using 
the UploadSiteHostedPictures call).
As a result of the storage on the eBay site, the picture is available to the seller on 
the My Picture Uploads tab within the Sell Your Item (SYI) pages.
A maximum of 25 URLs can be stored.

  RequiredInput: No
#    Argument: 'ns:PictureUploadPolicyCodeType'

=cut

sub setPictureUploadPolicy {
  my $self = shift;
  $self->{'PictureUploadPolicy'} = shift
}

=head2 getPictureUploadPolicy()

#    Returns: 'ns:PictureUploadPolicyCodeType'

=cut

sub getPictureUploadPolicy {
  my $self = shift;
  return $self->{'PictureUploadPolicy'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
