package Net::Amazon::S3::Operation::Object::Upload::Abort::Request;
# ABSTRACT: An internal class to abort a multipart upload
$Net::Amazon::S3::Operation::Object::Upload::Abort::Request::VERSION = '0.96';
use Moose 0.85;

extends 'Net::Amazon::S3::Request::Object';

with 'Net::Amazon::S3::Request::Role::Query::Param::Upload_id';
with 'Net::Amazon::S3::Request::Role::HTTP::Method::DELETE';

__PACKAGE__->meta->make_immutable;

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::Amazon::S3::Operation::Object::Upload::Abort::Request - An internal class to abort a multipart upload

=head1 VERSION

version 0.96

=head1 SYNOPSIS

	my $http_request = Net::Amazon::S3::Operation::Object::Upload::Abort::Request->new (
		s3        => $s3,
		bucket    => $bucket,
		key       => $key
		upload_id => $upload_id,
	);

=head1 DESCRIPTION

This module aborts a multipart upload.

=head1 NAME

Net::Amazon::S3::Operation::Object::Upload::Abort::Request - An internal class to abort a multipart upload

=head1 VERSION

version 0.59

=for test_synopsis no strict 'vars'

=head1 METHODS

=head2 http_request

This method returns a HTTP::Request object.

=head1 AUTHOR

Pedro Figueiredo <me@pedrofigueiredo.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by Amazon Digital Services, Leon Brocard, Brad Fitzpatrick, Pedro Figueiredo.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 AUTHOR

Branislav Zahradník <barney@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by Amazon Digital Services, Leon Brocard, Brad Fitzpatrick, Pedro Figueiredo, Rusty Conover, Branislav Zahradník.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
