######################################################################
#
# 5155_utf8jp_by_utf8jp_RT_DBCS.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xF3\xB0\x84\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x80"],
        ["\xF3\xB0\x84\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x80"],

        ["\xF3\xB0\x84\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x81"],
        ["\xF3\xB0\x84\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x81"],

        ["\xF3\xB0\x84\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x82"],
        ["\xF3\xB0\x84\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x82"],

        ["\xF3\xB0\x84\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x83"],
        ["\xF3\xB0\x84\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x83"],

        ["\xF3\xB0\x84\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x84"],
        ["\xF3\xB0\x84\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x84"],

        ["\xF3\xB0\x84\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x85"],
        ["\xF3\xB0\x84\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x85"],

        ["\xF3\xB0\x84\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x86"],
        ["\xF3\xB0\x84\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x86"],

        ["\xF3\xB0\x84\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x87"],
        ["\xF3\xB0\x84\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x87"],

        ["\xF3\xB0\x84\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x88"],
        ["\xF3\xB0\x84\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x88"],

        ["\xF3\xB0\x84\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x89"],
        ["\xF3\xB0\x84\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x89"],

        ["\xF3\xB0\x84\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8A"],
        ["\xF3\xB0\x84\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8A"],

        ["\xF3\xB0\x84\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8B"],
        ["\xF3\xB0\x84\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8B"],

        ["\xF3\xB0\x84\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8C"],
        ["\xF3\xB0\x84\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8C"],

        ["\xF3\xB0\x84\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8D"],
        ["\xF3\xB0\x84\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8D"],

        ["\xF3\xB0\x84\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8E"],
        ["\xF3\xB0\x84\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8E"],

        ["\xF3\xB0\x84\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8F"],
        ["\xF3\xB0\x84\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8F"],

        ["\xF3\xB0\x84\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x90"],
        ["\xF3\xB0\x84\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x90"],

        ["\xF3\xB0\x84\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x91"],
        ["\xF3\xB0\x84\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x91"],

        ["\xF3\xB0\x84\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x92"],
        ["\xF3\xB0\x84\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x92"],

        ["\xF3\xB0\x84\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x93"],
        ["\xF3\xB0\x84\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x93"],

        ["\xF3\xB0\x84\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x94"],
        ["\xF3\xB0\x84\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x94"],

        ["\xF3\xB0\x84\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x95"],
        ["\xF3\xB0\x84\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x95"],

        ["\xF3\xB0\x84\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x96"],
        ["\xF3\xB0\x84\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x96"],

        ["\xF3\xB0\x84\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x97"],
        ["\xF3\xB0\x84\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x97"],

        ["\xF3\xB0\x84\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x98"],
        ["\xF3\xB0\x84\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x98"],

        ["\xF3\xB0\x84\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x99"],
        ["\xF3\xB0\x84\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x99"],

        ["\xF3\xB0\x84\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9A"],
        ["\xF3\xB0\x84\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9A"],

        ["\xF3\xB0\x84\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9B"],
        ["\xF3\xB0\x84\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9B"],

        ["\xF3\xB0\x84\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9C"],
        ["\xF3\xB0\x84\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9C"],

        ["\xF3\xB0\x84\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9D"],
        ["\xF3\xB0\x84\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9D"],

        ["\xF3\xB0\x84\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9E"],
        ["\xF3\xB0\x84\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9E"],

        ["\xF3\xB0\x84\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9F"],
        ["\xF3\xB0\x84\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9F"],

        ["\xF3\xB0\x84\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA0"],
        ["\xF3\xB0\x84\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA0"],

        ["\xF3\xB0\x84\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA1"],
        ["\xF3\xB0\x84\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA1"],

        ["\xF3\xB0\x84\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA2"],
        ["\xF3\xB0\x84\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA2"],

        ["\xF3\xB0\x84\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA3"],
        ["\xF3\xB0\x84\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA3"],

        ["\xF3\xB0\x84\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA4"],
        ["\xF3\xB0\x84\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA4"],

        ["\xF3\xB0\x84\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA5"],
        ["\xF3\xB0\x84\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA5"],

        ["\xF3\xB0\x84\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA6"],
        ["\xF3\xB0\x84\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA6"],

        ["\xF3\xB0\x84\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA7"],
        ["\xF3\xB0\x84\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA7"],

        ["\xF3\xB0\x84\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA8"],
        ["\xF3\xB0\x84\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA8"],

        ["\xF3\xB0\x84\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA9"],
        ["\xF3\xB0\x84\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA9"],

        ["\xF3\xB0\x84\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAA"],
        ["\xF3\xB0\x84\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAA"],

        ["\xF3\xB0\x84\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAB"],
        ["\xF3\xB0\x84\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAB"],

        ["\xF3\xB0\x84\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAC"],
        ["\xF3\xB0\x84\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAC"],

        ["\xF3\xB0\x84\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAD"],
        ["\xF3\xB0\x84\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAD"],

        ["\xF3\xB0\x84\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAE"],
        ["\xF3\xB0\x84\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAE"],

        ["\xF3\xB0\x84\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAF"],
        ["\xF3\xB0\x84\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAF"],

        ["\xF3\xB0\x84\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB0"],
        ["\xF3\xB0\x84\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB0"],

        ["\xF3\xB0\x84\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB1"],
        ["\xF3\xB0\x84\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB1"],

        ["\xF3\xB0\x84\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB2"],
        ["\xF3\xB0\x84\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB2"],

        ["\xF3\xB0\x84\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB3"],
        ["\xF3\xB0\x84\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB3"],

        ["\xF3\xB0\x84\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB4"],
        ["\xF3\xB0\x84\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB4"],

        ["\xF3\xB0\x84\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB5"],
        ["\xF3\xB0\x84\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB5"],

        ["\xF3\xB0\x84\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB6"],
        ["\xF3\xB0\x84\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB6"],

        ["\xF3\xB0\x84\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB7"],
        ["\xF3\xB0\x84\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB7"],

        ["\xF3\xB0\x84\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB8"],
        ["\xF3\xB0\x84\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB8"],

        ["\xF3\xB0\x84\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB9"],
        ["\xF3\xB0\x84\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB9"],

        ["\xF3\xB0\x84\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBA"],
        ["\xF3\xB0\x84\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBA"],

        ["\xF3\xB0\x84\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBB"],
        ["\xF3\xB0\x84\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBB"],

        ["\xF3\xB0\x84\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBC"],
        ["\xF3\xB0\x84\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBC"],

        ["\xF3\xB0\x84\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBD"],
        ["\xF3\xB0\x84\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBD"],

        ["\xF3\xB0\x84\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBE"],
        ["\xF3\xB0\x84\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBE"],

        ["\xF3\xB0\x84\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBF"],
        ["\xF3\xB0\x84\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBF"],

        ["\xF3\xB0\x85\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x80"],
        ["\xF3\xB0\x85\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x80"],

        ["\xF3\xB0\x85\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x81"],
        ["\xF3\xB0\x85\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x81"],

        ["\xF3\xB0\x85\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x82"],
        ["\xF3\xB0\x85\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x82"],

        ["\xF3\xB0\x85\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x83"],
        ["\xF3\xB0\x85\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x83"],

        ["\xF3\xB0\x85\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x84"],
        ["\xF3\xB0\x85\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x84"],

        ["\xF3\xB0\x85\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x85"],
        ["\xF3\xB0\x85\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x85"],

        ["\xF3\xB0\x85\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x86"],
        ["\xF3\xB0\x85\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x86"],

        ["\xF3\xB0\x85\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x87"],
        ["\xF3\xB0\x85\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x87"],

        ["\xF3\xB0\x85\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x88"],
        ["\xF3\xB0\x85\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x88"],

        ["\xF3\xB0\x85\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x89"],
        ["\xF3\xB0\x85\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x89"],

        ["\xF3\xB0\x85\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8A"],
        ["\xF3\xB0\x85\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8A"],

        ["\xF3\xB0\x85\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8B"],
        ["\xF3\xB0\x85\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8B"],

        ["\xF3\xB0\x85\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8C"],
        ["\xF3\xB0\x85\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8C"],

        ["\xF3\xB0\x85\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8D"],
        ["\xF3\xB0\x85\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8D"],

        ["\xF3\xB0\x85\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8E"],
        ["\xF3\xB0\x85\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8E"],

        ["\xF3\xB0\x85\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8F"],
        ["\xF3\xB0\x85\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8F"],

        ["\xF3\xB0\x85\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x90"],
        ["\xF3\xB0\x85\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x90"],

        ["\xF3\xB0\x85\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x91"],
        ["\xF3\xB0\x85\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x91"],

        ["\xF3\xB0\x85\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x92"],
        ["\xF3\xB0\x85\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x92"],

        ["\xF3\xB0\x85\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x93"],
        ["\xF3\xB0\x85\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x93"],

        ["\xF3\xB0\x85\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x94"],
        ["\xF3\xB0\x85\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x94"],

        ["\xF3\xB0\x85\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x95"],
        ["\xF3\xB0\x85\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x95"],

        ["\xF3\xB0\x85\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x96"],
        ["\xF3\xB0\x85\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x96"],

        ["\xF3\xB0\x85\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x97"],
        ["\xF3\xB0\x85\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x97"],

        ["\xF3\xB0\x85\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x98"],
        ["\xF3\xB0\x85\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x98"],

        ["\xF3\xB0\x85\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x99"],
        ["\xF3\xB0\x85\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x99"],

        ["\xF3\xB0\x85\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9A"],
        ["\xF3\xB0\x85\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9A"],

        ["\xF3\xB0\x85\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9B"],
        ["\xF3\xB0\x85\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9B"],

        ["\xF3\xB0\x85\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9C"],
        ["\xF3\xB0\x85\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9C"],

        ["\xF3\xB0\x85\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9D"],
        ["\xF3\xB0\x85\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9D"],

        ["\xF3\xB0\x85\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9E"],
        ["\xF3\xB0\x85\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9E"],

        ["\xF3\xB0\x85\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9F"],
        ["\xF3\xB0\x85\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9F"],

        ["\xF3\xB0\x85\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA0"],
        ["\xF3\xB0\x85\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA0"],

        ["\xF3\xB0\x85\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA1"],
        ["\xF3\xB0\x85\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA1"],

        ["\xF3\xB0\x85\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA2"],
        ["\xF3\xB0\x85\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA2"],

        ["\xF3\xB0\x85\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA3"],
        ["\xF3\xB0\x85\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA3"],

        ["\xF3\xB0\x85\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA4"],
        ["\xF3\xB0\x85\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA4"],

        ["\xF3\xB0\x85\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA5"],
        ["\xF3\xB0\x85\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA5"],

        ["\xF3\xB0\x85\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA6"],
        ["\xF3\xB0\x85\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA6"],

        ["\xF3\xB0\x85\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA7"],
        ["\xF3\xB0\x85\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA7"],

        ["\xF3\xB0\x85\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA8"],
        ["\xF3\xB0\x85\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA8"],

        ["\xF3\xB0\x85\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA9"],
        ["\xF3\xB0\x85\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA9"],

        ["\xF3\xB0\x85\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAA"],
        ["\xF3\xB0\x85\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAA"],

        ["\xF3\xB0\x85\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAB"],
        ["\xF3\xB0\x85\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAB"],

        ["\xF3\xB0\x85\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB7"],
        ["\xF3\xB0\x85\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB7"],

        ["\xF3\xB0\x85\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB8"],
        ["\xF3\xB0\x85\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB8"],

        ["\xF3\xB0\x85\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB9"],
        ["\xF3\xB0\x85\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB9"],

        ["\xF3\xB0\x85\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBA"],
        ["\xF3\xB0\x85\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBA"],

        ["\xF3\xB0\x85\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBB"],
        ["\xF3\xB0\x85\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBB"],

        ["\xF3\xB0\x85\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBC"],
        ["\xF3\xB0\x85\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBC"],

        ["\xF3\xB0\x85\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBD"],
        ["\xF3\xB0\x85\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBD"],

        ["\xF3\xB0\x85\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBE"],
        ["\xF3\xB0\x85\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBE"],

        ["\xF3\xB0\x86\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x87"],
        ["\xF3\xB0\x86\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x87"],

        ["\xF3\xB0\x86\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x88"],
        ["\xF3\xB0\x86\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x88"],

        ["\xF3\xB0\x86\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x89"],
        ["\xF3\xB0\x86\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x89"],

        ["\xF3\xB0\x86\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8A"],
        ["\xF3\xB0\x86\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8A"],

        ["\xF3\xB0\x86\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8B"],
        ["\xF3\xB0\x86\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8B"],

        ["\xF3\xB0\x86\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8C"],
        ["\xF3\xB0\x86\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8C"],

        ["\xF3\xB0\x86\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8D"],
        ["\xF3\xB0\x86\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8D"],

        ["\xF3\xB0\x86\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x99"],
        ["\xF3\xB0\x86\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x99"],

        ["\xF3\xB0\x86\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9A"],
        ["\xF3\xB0\x86\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9A"],

        ["\xF3\xB0\x86\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9B"],
        ["\xF3\xB0\x86\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9B"],

        ["\xF3\xB0\x86\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9C"],
        ["\xF3\xB0\x86\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9C"],

        ["\xF3\xB0\x86\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9D"],
        ["\xF3\xB0\x86\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9D"],

        ["\xF3\xB0\x86\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9E"],
        ["\xF3\xB0\x86\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9E"],

        ["\xF3\xB0\x86\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9F"],
        ["\xF3\xB0\x86\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9F"],

        ["\xF3\xB0\x86\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA0"],
        ["\xF3\xB0\x86\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA0"],

        ["\xF3\xB0\x86\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA1"],
        ["\xF3\xB0\x86\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA1"],

        ["\xF3\xB0\x86\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA2"],
        ["\xF3\xB0\x86\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA2"],

        ["\xF3\xB0\x86\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA3"],
        ["\xF3\xB0\x86\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA3"],

        ["\xF3\xB0\x86\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA4"],
        ["\xF3\xB0\x86\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA4"],

        ["\xF3\xB0\x86\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA5"],
        ["\xF3\xB0\x86\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA5"],

        ["\xF3\xB0\x86\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA6"],
        ["\xF3\xB0\x86\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA6"],

        ["\xF3\xB0\x86\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA7"],
        ["\xF3\xB0\x86\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA7"],

        ["\xF3\xB0\x86\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xAF"],
        ["\xF3\xB0\x86\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xAF"],

        ["\xF3\xB0\x86\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB0"],
        ["\xF3\xB0\x86\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB0"],

        ["\xF3\xB0\x86\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB1"],
        ["\xF3\xB0\x86\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB1"],

        ["\xF3\xB0\x86\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB2"],
        ["\xF3\xB0\x86\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB2"],

        ["\xF3\xB0\x86\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB3"],
        ["\xF3\xB0\x86\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB3"],

        ["\xF3\xB0\x86\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB4"],
        ["\xF3\xB0\x86\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB4"],

        ["\xF3\xB0\x86\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB5"],
        ["\xF3\xB0\x86\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB5"],

        ["\xF3\xB0\x86\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB6"],
        ["\xF3\xB0\x86\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB6"],

        ["\xF3\xB0\x86\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xBB"],
        ["\xF3\xB0\x86\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xBB"],

        ["\xF3\xB0\x87\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8B"],
        ["\xF3\xB0\x87\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8B"],

        ["\xF3\xB0\x87\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8C"],
        ["\xF3\xB0\x87\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8C"],

        ["\xF3\xB0\x87\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8D"],
        ["\xF3\xB0\x87\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8D"],

        ["\xF3\xB0\x87\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8E"],
        ["\xF3\xB0\x87\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8E"],

        ["\xF3\xB0\x87\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8F"],
        ["\xF3\xB0\x87\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8F"],

        ["\xF3\xB0\x87\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x90"],
        ["\xF3\xB0\x87\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x90"],

        ["\xF3\xB0\x87\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x91"],
        ["\xF3\xB0\x87\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x91"],

        ["\xF3\xB0\x87\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x92"],
        ["\xF3\xB0\x87\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x92"],

        ["\xF3\xB0\x87\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x93"],
        ["\xF3\xB0\x87\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x93"],

        ["\xF3\xB0\x87\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x94"],
        ["\xF3\xB0\x87\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x94"],

        ["\xF3\xB0\x87\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9C"],
        ["\xF3\xB0\x87\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9C"],

        ["\xF3\xB0\x87\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9D"],
        ["\xF3\xB0\x87\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9D"],

        ["\xF3\xB0\x87\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9E"],
        ["\xF3\xB0\x87\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9E"],

        ["\xF3\xB0\x87\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9F"],
        ["\xF3\xB0\x87\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9F"],

        ["\xF3\xB0\x87\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA0"],
        ["\xF3\xB0\x87\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA0"],

        ["\xF3\xB0\x87\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA1"],
        ["\xF3\xB0\x87\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA1"],

        ["\xF3\xB0\x87\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA2"],
        ["\xF3\xB0\x87\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA2"],

        ["\xF3\xB0\x87\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA3"],
        ["\xF3\xB0\x87\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA3"],

        ["\xF3\xB0\x87\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA4"],
        ["\xF3\xB0\x87\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA4"],

        ["\xF3\xB0\x87\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA5"],
        ["\xF3\xB0\x87\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA5"],

        ["\xF3\xB0\x87\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA6"],
        ["\xF3\xB0\x87\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA6"],

        ["\xF3\xB0\x87\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA7"],
        ["\xF3\xB0\x87\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA7"],

        ["\xF3\xB0\x87\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA8"],
        ["\xF3\xB0\x87\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA8"],

        ["\xF3\xB0\x87\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA9"],
        ["\xF3\xB0\x87\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA9"],

        ["\xF3\xB0\x87\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAA"],
        ["\xF3\xB0\x87\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAA"],

        ["\xF3\xB0\x87\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAB"],
        ["\xF3\xB0\x87\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAB"],

        ["\xF3\xB0\x87\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAC"],
        ["\xF3\xB0\x87\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAC"],

        ["\xF3\xB0\x87\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAD"],
        ["\xF3\xB0\x87\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAD"],

        ["\xF3\xB0\x87\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAE"],
        ["\xF3\xB0\x87\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAE"],

        ["\xF3\xB0\x87\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAF"],
        ["\xF3\xB0\x87\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAF"],

        ["\xF3\xB0\x87\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB0"],
        ["\xF3\xB0\x87\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB0"],

        ["\xF3\xB0\x87\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB1"],
        ["\xF3\xB0\x87\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB1"],

        ["\xF3\xB0\x87\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB2"],
        ["\xF3\xB0\x87\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB2"],

        ["\xF3\xB0\x87\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB3"],
        ["\xF3\xB0\x87\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB3"],

        ["\xF3\xB0\x87\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB4"],
        ["\xF3\xB0\x87\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB4"],

        ["\xF3\xB0\x87\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB5"],
        ["\xF3\xB0\x87\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB5"],

        ["\xF3\xB0\x87\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBC"],
        ["\xF3\xB0\x87\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBC"],

        ["\xF3\xB0\x87\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBD"],
        ["\xF3\xB0\x87\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBD"],

        ["\xF3\xB0\x87\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBE"],
        ["\xF3\xB0\x87\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBE"],

        ["\xF3\xB0\x87\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBF"],
        ["\xF3\xB0\x87\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBF"],

        ["\xF3\xB0\x88\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x80"],
        ["\xF3\xB0\x88\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x80"],

        ["\xF3\xB0\x88\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x81"],
        ["\xF3\xB0\x88\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x81"],

        ["\xF3\xB0\x88\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x82"],
        ["\xF3\xB0\x88\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x82"],

        ["\xF3\xB0\x88\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x83"],
        ["\xF3\xB0\x88\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x83"],

        ["\xF3\xB0\x88\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x84"],
        ["\xF3\xB0\x88\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x84"],

        ["\xF3\xB0\x88\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x85"],
        ["\xF3\xB0\x88\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x85"],

        ["\xF3\xB0\x88\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x86"],
        ["\xF3\xB0\x88\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x86"],

        ["\xF3\xB0\x88\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x87"],
        ["\xF3\xB0\x88\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x87"],

        ["\xF3\xB0\x88\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x88"],
        ["\xF3\xB0\x88\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x88"],

        ["\xF3\xB0\x88\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x89"],
        ["\xF3\xB0\x88\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x89"],

        ["\xF3\xB0\x88\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8A"],
        ["\xF3\xB0\x88\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8A"],

        ["\xF3\xB0\x88\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8B"],
        ["\xF3\xB0\x88\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8B"],

        ["\xF3\xB0\x88\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8C"],
        ["\xF3\xB0\x88\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8C"],

        ["\xF3\xB0\x88\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8D"],
        ["\xF3\xB0\x88\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8D"],

        ["\xF3\xB0\x88\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8E"],
        ["\xF3\xB0\x88\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8E"],

        ["\xF3\xB0\x88\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8F"],
        ["\xF3\xB0\x88\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8F"],

        ["\xF3\xB0\x88\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x90"],
        ["\xF3\xB0\x88\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x90"],

        ["\xF3\xB0\x88\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x91"],
        ["\xF3\xB0\x88\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x91"],

        ["\xF3\xB0\x88\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x92"],
        ["\xF3\xB0\x88\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x92"],

        ["\xF3\xB0\x88\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x93"],
        ["\xF3\xB0\x88\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x93"],

        ["\xF3\xB0\x88\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x94"],
        ["\xF3\xB0\x88\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x94"],

        ["\xF3\xB0\x88\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x95"],
        ["\xF3\xB0\x88\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x95"],

        ["\xF3\xB0\x88\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9A"],
        ["\xF3\xB0\x88\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9A"],

        ["\xF3\xB0\x88\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9B"],
        ["\xF3\xB0\x88\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9B"],

        ["\xF3\xB0\x88\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9C"],
        ["\xF3\xB0\x88\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9C"],

        ["\xF3\xB0\x88\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9D"],
        ["\xF3\xB0\x88\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9D"],

        ["\xF3\xB0\x88\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9E"],
        ["\xF3\xB0\x88\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9E"],

        ["\xF3\xB0\x88\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9F"],
        ["\xF3\xB0\x88\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9F"],

        ["\xF3\xB0\x88\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA0"],
        ["\xF3\xB0\x88\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA0"],

        ["\xF3\xB0\x88\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA1"],
        ["\xF3\xB0\x88\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA1"],

        ["\xF3\xB0\x88\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA2"],
        ["\xF3\xB0\x88\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA2"],

        ["\xF3\xB0\x88\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA3"],
        ["\xF3\xB0\x88\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA3"],

        ["\xF3\xB0\x88\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA4"],
        ["\xF3\xB0\x88\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA4"],

        ["\xF3\xB0\x88\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA5"],
        ["\xF3\xB0\x88\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA5"],

        ["\xF3\xB0\x88\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA6"],
        ["\xF3\xB0\x88\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA6"],

        ["\xF3\xB0\x88\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA7"],
        ["\xF3\xB0\x88\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA7"],

        ["\xF3\xB0\x88\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA8"],
        ["\xF3\xB0\x88\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA8"],

        ["\xF3\xB0\x88\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA9"],
        ["\xF3\xB0\x88\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA9"],

        ["\xF3\xB0\x88\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAA"],
        ["\xF3\xB0\x88\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAA"],

        ["\xF3\xB0\x88\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAB"],
        ["\xF3\xB0\x88\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAB"],

        ["\xF3\xB0\x88\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAC"],
        ["\xF3\xB0\x88\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAC"],

        ["\xF3\xB0\x88\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAD"],
        ["\xF3\xB0\x88\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAD"],

        ["\xF3\xB0\x88\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAE"],
        ["\xF3\xB0\x88\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAE"],

        ["\xF3\xB0\x88\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAF"],
        ["\xF3\xB0\x88\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAF"],

        ["\xF3\xB0\x88\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB0"],
        ["\xF3\xB0\x88\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB0"],

        ["\xF3\xB0\x88\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB1"],
        ["\xF3\xB0\x88\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB1"],

        ["\xF3\xB0\x88\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB2"],
        ["\xF3\xB0\x88\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB2"],

        ["\xF3\xB0\x88\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB3"],
        ["\xF3\xB0\x88\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB3"],

        ["\xF3\xB0\x88\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB4"],
        ["\xF3\xB0\x88\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB4"],

        ["\xF3\xB0\x88\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB5"],
        ["\xF3\xB0\x88\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB5"],

        ["\xF3\xB0\x88\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB6"],
        ["\xF3\xB0\x88\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB6"],

        ["\xF3\xB0\x88\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB7"],
        ["\xF3\xB0\x88\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB7"],

        ["\xF3\xB0\x88\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB8"],
        ["\xF3\xB0\x88\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB8"],

        ["\xF3\xB0\x88\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB9"],
        ["\xF3\xB0\x88\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB9"],

        ["\xF3\xB0\x88\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBA"],
        ["\xF3\xB0\x88\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBA"],

        ["\xF3\xB0\x88\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBB"],
        ["\xF3\xB0\x88\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBB"],

        ["\xF3\xB0\x88\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBC"],
        ["\xF3\xB0\x88\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBC"],

        ["\xF3\xB0\x88\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBD"],
        ["\xF3\xB0\x88\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBD"],

        ["\xF3\xB0\x88\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBE"],
        ["\xF3\xB0\x88\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBE"],

        ["\xF3\xB0\x88\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBF"],
        ["\xF3\xB0\x88\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBF"],

        ["\xF3\xB0\x89\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x80"],
        ["\xF3\xB0\x89\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x80"],

        ["\xF3\xB0\x89\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x81"],
        ["\xF3\xB0\x89\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x81"],

        ["\xF3\xB0\x89\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x82"],
        ["\xF3\xB0\x89\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x82"],

        ["\xF3\xB0\x89\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x83"],
        ["\xF3\xB0\x89\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x83"],

        ["\xF3\xB0\x89\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x84"],
        ["\xF3\xB0\x89\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x84"],

        ["\xF3\xB0\x89\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x85"],
        ["\xF3\xB0\x89\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x85"],

        ["\xF3\xB0\x89\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x86"],
        ["\xF3\xB0\x89\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x86"],

        ["\xF3\xB0\x89\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x87"],
        ["\xF3\xB0\x89\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x87"],

        ["\xF3\xB0\x89\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x88"],
        ["\xF3\xB0\x89\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x88"],

        ["\xF3\xB0\x89\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x89"],
        ["\xF3\xB0\x89\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x89"],

        ["\xF3\xB0\x89\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8A"],
        ["\xF3\xB0\x89\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8A"],

        ["\xF3\xB0\x89\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8B"],
        ["\xF3\xB0\x89\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8B"],

        ["\xF3\xB0\x89\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8C"],
        ["\xF3\xB0\x89\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8C"],

        ["\xF3\xB0\x89\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8D"],
        ["\xF3\xB0\x89\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8D"],

        ["\xF3\xB0\x89\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8E"],
        ["\xF3\xB0\x89\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8E"],

        ["\xF3\xB0\x89\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8F"],
        ["\xF3\xB0\x89\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8F"],

        ["\xF3\xB0\x89\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x90"],
        ["\xF3\xB0\x89\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x90"],

        ["\xF3\xB0\x89\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x91"],
        ["\xF3\xB0\x89\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x91"],

        ["\xF3\xB0\x89\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x92"],
        ["\xF3\xB0\x89\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x92"],

        ["\xF3\xB0\x89\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x93"],
        ["\xF3\xB0\x89\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x93"],

        ["\xF3\xB0\x89\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x94"],
        ["\xF3\xB0\x89\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x94"],

        ["\xF3\xB0\x89\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x95"],
        ["\xF3\xB0\x89\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x95"],

        ["\xF3\xB0\x89\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x96"],
        ["\xF3\xB0\x89\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x96"],

        ["\xF3\xB0\x89\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x97"],
        ["\xF3\xB0\x89\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x97"],

        ["\xF3\xB0\x89\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x98"],
        ["\xF3\xB0\x89\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x98"],

        ["\xF3\xB0\x89\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x99"],
        ["\xF3\xB0\x89\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x99"],

        ["\xF3\xB0\x89\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9A"],
        ["\xF3\xB0\x89\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9A"],

        ["\xF3\xB0\x89\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9B"],
        ["\xF3\xB0\x89\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9B"],

        ["\xF3\xB0\x89\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9C"],
        ["\xF3\xB0\x89\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9C"],

        ["\xF3\xB0\x89\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9D"],
        ["\xF3\xB0\x89\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9D"],

        ["\xF3\xB0\x89\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9E"],
        ["\xF3\xB0\x89\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9E"],

        ["\xF3\xB0\x89\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9F"],
        ["\xF3\xB0\x89\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9F"],

        ["\xF3\xB0\x89\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA0"],
        ["\xF3\xB0\x89\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA0"],

        ["\xF3\xB0\x89\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA1"],
        ["\xF3\xB0\x89\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA1"],

        ["\xF3\xB0\x89\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA2"],
        ["\xF3\xB0\x89\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA2"],

        ["\xF3\xB0\x89\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA3"],
        ["\xF3\xB0\x89\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA3"],

        ["\xF3\xB0\x89\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA4"],
        ["\xF3\xB0\x89\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA4"],

        ["\xF3\xB0\x89\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA5"],
        ["\xF3\xB0\x89\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA5"],

        ["\xF3\xB0\x89\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA6"],
        ["\xF3\xB0\x89\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA6"],

        ["\xF3\xB0\x89\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA7"],
        ["\xF3\xB0\x89\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA7"],

        ["\xF3\xB0\x89\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA8"],
        ["\xF3\xB0\x89\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA8"],

        ["\xF3\xB0\x89\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA9"],
        ["\xF3\xB0\x89\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA9"],

        ["\xF3\xB0\x89\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAA"],
        ["\xF3\xB0\x89\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAA"],

        ["\xF3\xB0\x89\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAB"],
        ["\xF3\xB0\x89\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAB"],

        ["\xF3\xB0\x89\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAC"],
        ["\xF3\xB0\x89\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAC"],

        ["\xF3\xB0\x89\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB8"],
        ["\xF3\xB0\x89\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB8"],

        ["\xF3\xB0\x89\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB9"],
        ["\xF3\xB0\x89\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB9"],

        ["\xF3\xB0\x89\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBA"],
        ["\xF3\xB0\x89\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBA"],

        ["\xF3\xB0\x89\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBB"],
        ["\xF3\xB0\x89\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBB"],

        ["\xF3\xB0\x89\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBC"],
        ["\xF3\xB0\x89\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBC"],

        ["\xF3\xB0\x89\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBD"],
        ["\xF3\xB0\x89\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBD"],

        ["\xF3\xB0\x89\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBE"],
        ["\xF3\xB0\x89\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBE"],

        ["\xF3\xB0\x89\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBF"],
        ["\xF3\xB0\x89\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBF"],

        ["\xF3\xB0\x8A\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x80"],
        ["\xF3\xB0\x8A\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x80"],

        ["\xF3\xB0\x8A\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x81"],
        ["\xF3\xB0\x8A\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x81"],

        ["\xF3\xB0\x8A\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x82"],
        ["\xF3\xB0\x8A\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x82"],

        ["\xF3\xB0\x8A\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x83"],
        ["\xF3\xB0\x8A\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x83"],

        ["\xF3\xB0\x8A\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x84"],
        ["\xF3\xB0\x8A\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x84"],

        ["\xF3\xB0\x8A\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x85"],
        ["\xF3\xB0\x8A\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x85"],

        ["\xF3\xB0\x8A\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x86"],
        ["\xF3\xB0\x8A\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x86"],

        ["\xF3\xB0\x8A\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x87"],
        ["\xF3\xB0\x8A\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x87"],

        ["\xF3\xB0\x8A\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x88"],
        ["\xF3\xB0\x8A\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x88"],

        ["\xF3\xB0\x8A\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x89"],
        ["\xF3\xB0\x8A\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x89"],

        ["\xF3\xB0\x8A\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8A"],
        ["\xF3\xB0\x8A\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8A"],

        ["\xF3\xB0\x8A\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8B"],
        ["\xF3\xB0\x8A\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8B"],

        ["\xF3\xB0\x8A\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8C"],
        ["\xF3\xB0\x8A\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8C"],

        ["\xF3\xB0\x8A\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8D"],
        ["\xF3\xB0\x8A\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8D"],

        ["\xF3\xB0\x8A\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8E"],
        ["\xF3\xB0\x8A\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8E"],

        ["\xF3\xB0\x8A\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8F"],
        ["\xF3\xB0\x8A\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8F"],

        ["\xF3\xB0\x8A\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x90"],
        ["\xF3\xB0\x8A\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x90"],

        ["\xF3\xB0\x8A\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x91"],
        ["\xF3\xB0\x8A\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x91"],

        ["\xF3\xB0\x8A\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x92"],
        ["\xF3\xB0\x8A\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x92"],

        ["\xF3\xB0\x8A\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x93"],
        ["\xF3\xB0\x8A\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x93"],

        ["\xF3\xB0\x8A\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x94"],
        ["\xF3\xB0\x8A\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x94"],

        ["\xF3\xB0\x8A\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x95"],
        ["\xF3\xB0\x8A\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x95"],

        ["\xF3\xB0\x8A\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x96"],
        ["\xF3\xB0\x8A\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x96"],

        ["\xF3\xB0\x8A\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x97"],
        ["\xF3\xB0\x8A\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x97"],

        ["\xF3\xB0\x8A\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x98"],
        ["\xF3\xB0\x8A\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x98"],

        ["\xF3\xB0\x8A\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x99"],
        ["\xF3\xB0\x8A\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x99"],

        ["\xF3\xB0\x8A\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9A"],
        ["\xF3\xB0\x8A\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9A"],

        ["\xF3\xB0\x8A\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9B"],
        ["\xF3\xB0\x8A\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9B"],

        ["\xF3\xB0\x8A\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9C"],
        ["\xF3\xB0\x8A\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9C"],

        ["\xF3\xB0\x8A\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9D"],
        ["\xF3\xB0\x8A\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9D"],

        ["\xF3\xB0\x8A\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9E"],
        ["\xF3\xB0\x8A\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9E"],

        ["\xF3\xB0\x8A\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9F"],
        ["\xF3\xB0\x8A\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9F"],

        ["\xF3\xB0\x8A\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA0"],
        ["\xF3\xB0\x8A\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA0"],

        ["\xF3\xB0\x8A\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA1"],
        ["\xF3\xB0\x8A\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA1"],

        ["\xF3\xB0\x8A\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA2"],
        ["\xF3\xB0\x8A\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA2"],

        ["\xF3\xB0\x8A\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA3"],
        ["\xF3\xB0\x8A\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA3"],

        ["\xF3\xB0\x8A\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA4"],
        ["\xF3\xB0\x8A\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA4"],

        ["\xF3\xB0\x8A\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA5"],
        ["\xF3\xB0\x8A\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA5"],

        ["\xF3\xB0\x8A\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA6"],
        ["\xF3\xB0\x8A\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA6"],

        ["\xF3\xB0\x8A\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA7"],
        ["\xF3\xB0\x8A\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA7"],

        ["\xF3\xB0\x8A\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA8"],
        ["\xF3\xB0\x8A\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA8"],

        ["\xF3\xB0\x8A\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA9"],
        ["\xF3\xB0\x8A\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA9"],

        ["\xF3\xB0\x8A\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAA"],
        ["\xF3\xB0\x8A\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAA"],

        ["\xF3\xB0\x8A\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAB"],
        ["\xF3\xB0\x8A\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAB"],

        ["\xF3\xB0\x8A\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAC"],
        ["\xF3\xB0\x8A\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAC"],

        ["\xF3\xB0\x8A\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAD"],
        ["\xF3\xB0\x8A\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAD"],

        ["\xF3\xB0\x8A\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAE"],
        ["\xF3\xB0\x8A\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAE"],

        ["\xF3\xB0\x8A\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAF"],
        ["\xF3\xB0\x8A\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAF"],

        ["\xF3\xB0\x8A\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB0"],
        ["\xF3\xB0\x8A\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB0"],

        ["\xF3\xB0\x8A\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB1"],
        ["\xF3\xB0\x8A\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB1"],

        ["\xF3\xB0\x8A\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB2"],
        ["\xF3\xB0\x8A\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB2"],

        ["\xF3\xB0\x8A\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB3"],
        ["\xF3\xB0\x8A\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB3"],

        ["\xF3\xB0\x8A\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB4"],
        ["\xF3\xB0\x8A\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB4"],

        ["\xF3\xB0\x8A\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB5"],
        ["\xF3\xB0\x8A\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB5"],

        ["\xF3\xB0\x8A\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB6"],
        ["\xF3\xB0\x8A\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB6"],

        ["\xF3\xB0\x8A\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB7"],
        ["\xF3\xB0\x8A\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB7"],

        ["\xF3\xB0\x8A\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB8"],
        ["\xF3\xB0\x8A\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB8"],

        ["\xF3\xB0\x8A\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB9"],
        ["\xF3\xB0\x8A\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB9"],

        ["\xF3\xB0\x8A\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBA"],
        ["\xF3\xB0\x8A\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBA"],

        ["\xF3\xB0\x8A\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBB"],
        ["\xF3\xB0\x8A\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBB"],

        ["\xF3\xB0\x8A\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBC"],
        ["\xF3\xB0\x8A\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBC"],

        ["\xF3\xB0\x8A\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBD"],
        ["\xF3\xB0\x8A\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBD"],

        ["\xF3\xB0\x8A\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBE"],
        ["\xF3\xB0\x8A\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBE"],

        ["\xF3\xB0\x8A\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBF"],
        ["\xF3\xB0\x8A\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBF"],

        ["\xF3\xB0\x8B\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x80"],
        ["\xF3\xB0\x8B\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x80"],

        ["\xF3\xB0\x8B\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x81"],
        ["\xF3\xB0\x8B\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x81"],

        ["\xF3\xB0\x8B\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x82"],
        ["\xF3\xB0\x8B\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x82"],

        ["\xF3\xB0\x8B\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x83"],
        ["\xF3\xB0\x8B\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x83"],

        ["\xF3\xB0\x8B\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x84"],
        ["\xF3\xB0\x8B\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x84"],

        ["\xF3\xB0\x8B\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x85"],
        ["\xF3\xB0\x8B\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x85"],

        ["\xF3\xB0\x8B\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x86"],
        ["\xF3\xB0\x8B\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x86"],

        ["\xF3\xB0\x8B\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x87"],
        ["\xF3\xB0\x8B\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x87"],

        ["\xF3\xB0\x8B\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x88"],
        ["\xF3\xB0\x8B\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x88"],

        ["\xF3\xB0\x8B\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x89"],
        ["\xF3\xB0\x8B\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x89"],

        ["\xF3\xB0\x8B\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8A"],
        ["\xF3\xB0\x8B\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8A"],

        ["\xF3\xB0\x8B\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8B"],
        ["\xF3\xB0\x8B\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8B"],

        ["\xF3\xB0\x8B\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8C"],
        ["\xF3\xB0\x8B\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8C"],

        ["\xF3\xB0\x8B\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8D"],
        ["\xF3\xB0\x8B\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8D"],

        ["\xF3\xB0\x8B\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x96"],
        ["\xF3\xB0\x8B\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x96"],

        ["\xF3\xB0\x8B\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x97"],
        ["\xF3\xB0\x8B\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x97"],

        ["\xF3\xB0\x8B\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x98"],
        ["\xF3\xB0\x8B\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x98"],

        ["\xF3\xB0\x8B\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x99"],
        ["\xF3\xB0\x8B\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x99"],

        ["\xF3\xB0\x8B\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9A"],
        ["\xF3\xB0\x8B\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9A"],

        ["\xF3\xB0\x8B\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9B"],
        ["\xF3\xB0\x8B\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9B"],

        ["\xF3\xB0\x8B\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9C"],
        ["\xF3\xB0\x8B\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9C"],

        ["\xF3\xB0\x8B\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9D"],
        ["\xF3\xB0\x8B\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9D"],

        ["\xF3\xB0\x8B\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9E"],
        ["\xF3\xB0\x8B\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9E"],

        ["\xF3\xB0\x8B\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9F"],
        ["\xF3\xB0\x8B\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9F"],

        ["\xF3\xB0\x8B\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA0"],
        ["\xF3\xB0\x8B\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA0"],

        ["\xF3\xB0\x8B\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA1"],
        ["\xF3\xB0\x8B\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA1"],

        ["\xF3\xB0\x8B\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA2"],
        ["\xF3\xB0\x8B\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA2"],

        ["\xF3\xB0\x8B\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA3"],
        ["\xF3\xB0\x8B\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA3"],

        ["\xF3\xB0\x8B\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA4"],
        ["\xF3\xB0\x8B\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA4"],

        ["\xF3\xB0\x8B\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA5"],
        ["\xF3\xB0\x8B\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA5"],

        ["\xF3\xB0\x8B\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA6"],
        ["\xF3\xB0\x8B\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA6"],

        ["\xF3\xB0\x8B\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA7"],
        ["\xF3\xB0\x8B\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA7"],

        ["\xF3\xB0\x8B\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA8"],
        ["\xF3\xB0\x8B\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA8"],

        ["\xF3\xB0\x8B\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA9"],
        ["\xF3\xB0\x8B\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA9"],

        ["\xF3\xB0\x8B\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAA"],
        ["\xF3\xB0\x8B\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAA"],

        ["\xF3\xB0\x8B\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAB"],
        ["\xF3\xB0\x8B\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAB"],

        ["\xF3\xB0\x8B\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAC"],
        ["\xF3\xB0\x8B\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAC"],

        ["\xF3\xB0\x8B\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAD"],
        ["\xF3\xB0\x8B\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAD"],

        ["\xF3\xB0\x8B\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB6"],
        ["\xF3\xB0\x8B\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB6"],

        ["\xF3\xB0\x8B\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB7"],
        ["\xF3\xB0\x8B\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB7"],

        ["\xF3\xB0\x8B\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB8"],
        ["\xF3\xB0\x8B\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB8"],

        ["\xF3\xB0\x8B\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB9"],
        ["\xF3\xB0\x8B\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB9"],

        ["\xF3\xB0\x8B\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBA"],
        ["\xF3\xB0\x8B\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBA"],

        ["\xF3\xB0\x8B\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBB"],
        ["\xF3\xB0\x8B\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBB"],

        ["\xF3\xB0\x8B\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBC"],
        ["\xF3\xB0\x8B\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBC"],

        ["\xF3\xB0\x8B\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBD"],
        ["\xF3\xB0\x8B\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBD"],

        ["\xF3\xB0\x8B\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBE"],
        ["\xF3\xB0\x8B\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBE"],

        ["\xF3\xB0\x8B\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBF"],
        ["\xF3\xB0\x8B\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBF"],

        ["\xF3\xB0\x8C\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x80"],
        ["\xF3\xB0\x8C\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x80"],

        ["\xF3\xB0\x8C\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x81"],
        ["\xF3\xB0\x8C\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x81"],

        ["\xF3\xB0\x8C\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x82"],
        ["\xF3\xB0\x8C\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x82"],

        ["\xF3\xB0\x8C\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x83"],
        ["\xF3\xB0\x8C\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x83"],

        ["\xF3\xB0\x8C\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x84"],
        ["\xF3\xB0\x8C\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x84"],

        ["\xF3\xB0\x8C\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x85"],
        ["\xF3\xB0\x8C\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x85"],

        ["\xF3\xB0\x8C\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x86"],
        ["\xF3\xB0\x8C\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x86"],

        ["\xF3\xB0\x8C\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x87"],
        ["\xF3\xB0\x8C\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x87"],

        ["\xF3\xB0\x8C\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x88"],
        ["\xF3\xB0\x8C\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x88"],

        ["\xF3\xB0\x8C\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x89"],
        ["\xF3\xB0\x8C\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x89"],

        ["\xF3\xB0\x8C\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8A"],
        ["\xF3\xB0\x8C\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8A"],

        ["\xF3\xB0\x8C\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8B"],
        ["\xF3\xB0\x8C\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8B"],

        ["\xF3\xB0\x8C\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8C"],
        ["\xF3\xB0\x8C\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8C"],

        ["\xF3\xB0\x8C\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8D"],
        ["\xF3\xB0\x8C\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8D"],

        ["\xF3\xB0\x8C\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB4"],
        ["\xF3\xB0\x8C\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB4"],

        ["\xF3\xB0\x8C\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB5"],
        ["\xF3\xB0\x8C\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB5"],

        ["\xF3\xB0\x8C\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB6"],
        ["\xF3\xB0\x8C\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB6"],

        ["\xF3\xB0\x8C\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB7"],
        ["\xF3\xB0\x8C\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB7"],

        ["\xF3\xB0\x8C\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB8"],
        ["\xF3\xB0\x8C\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB8"],

        ["\xF3\xB0\x8C\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB9"],
        ["\xF3\xB0\x8C\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB9"],

        ["\xF3\xB0\x8C\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBA"],
        ["\xF3\xB0\x8C\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBA"],

        ["\xF3\xB0\x8C\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBB"],
        ["\xF3\xB0\x8C\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBB"],

        ["\xF3\xB0\x8C\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBC"],
        ["\xF3\xB0\x8C\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBC"],

        ["\xF3\xB0\x8C\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBD"],
        ["\xF3\xB0\x8C\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBD"],

        ["\xF3\xB0\x8C\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBE"],
        ["\xF3\xB0\x8C\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBE"],

        ["\xF3\xB0\x8C\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBF"],
        ["\xF3\xB0\x8C\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBF"],

        ["\xF3\xB0\x8D\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x80"],
        ["\xF3\xB0\x8D\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x80"],

        ["\xF3\xB0\x8D\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x81"],
        ["\xF3\xB0\x8D\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x81"],

        ["\xF3\xB0\x8D\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x82"],
        ["\xF3\xB0\x8D\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x82"],

        ["\xF3\xB0\x8D\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x83"],
        ["\xF3\xB0\x8D\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x83"],

        ["\xF3\xB0\x8D\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x84"],
        ["\xF3\xB0\x8D\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x84"],

        ["\xF3\xB0\x8D\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x85"],
        ["\xF3\xB0\x8D\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x85"],

        ["\xF3\xB0\x8D\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x86"],
        ["\xF3\xB0\x8D\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x86"],

        ["\xF3\xB0\x8D\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x87"],
        ["\xF3\xB0\x8D\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x87"],

        ["\xF3\xB0\x8D\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x88"],
        ["\xF3\xB0\x8D\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x88"],

        ["\xF3\xB0\x8D\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x89"],
        ["\xF3\xB0\x8D\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x89"],

        ["\xF3\xB0\x8D\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8A"],
        ["\xF3\xB0\x8D\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8A"],

        ["\xF3\xB0\x8D\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8B"],
        ["\xF3\xB0\x8D\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8B"],

        ["\xF3\xB0\x8D\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8C"],
        ["\xF3\xB0\x8D\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8C"],

        ["\xF3\xB0\x8D\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8D"],
        ["\xF3\xB0\x8D\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8D"],

        ["\xF3\xB0\x8D\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8E"],
        ["\xF3\xB0\x8D\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8E"],

        ["\xF3\xB0\x8D\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8F"],
        ["\xF3\xB0\x8D\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8F"],

        ["\xF3\xB0\x8D\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x90"],
        ["\xF3\xB0\x8D\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x90"],

        ["\xF3\xB0\x8D\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x91"],
        ["\xF3\xB0\x8D\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x91"],

        ["\xF3\xB0\x8D\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x92"],
        ["\xF3\xB0\x8D\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x92"],

        ["\xF3\xB0\x8D\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x93"],
        ["\xF3\xB0\x8D\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x93"],

        ["\xF3\xB0\x8D\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x94"],
        ["\xF3\xB0\x8D\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x94"],

        ["\xF3\xB0\x8D\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA4"],
        ["\xF3\xB0\x8D\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA4"],

        ["\xF3\xB0\x8D\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA5"],
        ["\xF3\xB0\x8D\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA5"],

        ["\xF3\xB0\x8D\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA6"],
        ["\xF3\xB0\x8D\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA6"],

        ["\xF3\xB0\x8D\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA7"],
        ["\xF3\xB0\x8D\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA7"],

        ["\xF3\xB0\x8D\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA8"],
        ["\xF3\xB0\x8D\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA8"],

        ["\xF3\xB0\x8D\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA9"],
        ["\xF3\xB0\x8D\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA9"],

        ["\xF3\xB0\x8D\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAA"],
        ["\xF3\xB0\x8D\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAA"],

        ["\xF3\xB0\x8D\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAB"],
        ["\xF3\xB0\x8D\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAB"],

        ["\xF3\xB0\x8D\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAC"],
        ["\xF3\xB0\x8D\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAC"],

        ["\xF3\xB0\x8D\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAD"],
        ["\xF3\xB0\x8D\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAD"],

        ["\xF3\xB0\x8D\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAE"],
        ["\xF3\xB0\x8D\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAE"],

        ["\xF3\xB0\x8D\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAF"],
        ["\xF3\xB0\x8D\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAF"],

        ["\xF3\xB0\x8D\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB0"],
        ["\xF3\xB0\x8D\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB0"],

        ["\xF3\xB0\x8D\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB1"],
        ["\xF3\xB0\x8D\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB1"],

        ["\xF3\xB0\x8D\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB2"],
        ["\xF3\xB0\x8D\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB2"],

        ["\xF3\xB0\x8D\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB3"],
        ["\xF3\xB0\x8D\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB3"],

        ["\xF3\xB0\x8D\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB4"],
        ["\xF3\xB0\x8D\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB4"],

        ["\xF3\xB0\x8D\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB5"],
        ["\xF3\xB0\x8D\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB5"],

        ["\xF3\xB0\x8D\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB6"],
        ["\xF3\xB0\x8D\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB6"],

        ["\xF3\xB0\x8D\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB7"],
        ["\xF3\xB0\x8D\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB7"],

        ["\xF3\xB0\x8D\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB8"],
        ["\xF3\xB0\x8D\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB8"],

        ["\xF3\xB0\x8D\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB9"],
        ["\xF3\xB0\x8D\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB9"],

        ["\xF3\xB0\x8D\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBA"],
        ["\xF3\xB0\x8D\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBA"],

        ["\xF3\xB0\x8D\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBB"],
        ["\xF3\xB0\x8D\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBB"],

        ["\xF3\xB0\x8D\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBC"],
        ["\xF3\xB0\x8D\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBC"],

        ["\xF3\xB0\x8D\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBD"],
        ["\xF3\xB0\x8D\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBD"],

        ["\xF3\xB0\x8D\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBE"],
        ["\xF3\xB0\x8D\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBE"],

        ["\xF3\xB0\x8D\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBF"],
        ["\xF3\xB0\x8D\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBF"],

        ["\xF3\xB0\x8E\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x80"],
        ["\xF3\xB0\x8E\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x80"],

        ["\xF3\xB0\x8E\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x81"],
        ["\xF3\xB0\x8E\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x81"],

        ["\xF3\xB0\x8E\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x82"],
        ["\xF3\xB0\x8E\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x82"],

        ["\xF3\xB0\x8E\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x83"],
        ["\xF3\xB0\x8E\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x83"],

        ["\xF3\xB0\x8E\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x84"],
        ["\xF3\xB0\x8E\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x84"],

        ["\xF3\xB0\x8E\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x92"],
        ["\xF3\xB0\x8E\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x92"],

        ["\xF3\xB0\x8E\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x93"],
        ["\xF3\xB0\x8E\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x93"],

        ["\xF3\xB0\x8E\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x94"],
        ["\xF3\xB0\x8E\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x94"],

        ["\xF3\xB0\x8E\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x95"],
        ["\xF3\xB0\x8E\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x95"],

        ["\xF3\xB0\x8E\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x96"],
        ["\xF3\xB0\x8E\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x96"],

        ["\xF3\xB0\x8E\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x97"],
        ["\xF3\xB0\x8E\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x97"],

        ["\xF3\xB0\x8E\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x98"],
        ["\xF3\xB0\x8E\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x98"],

        ["\xF3\xB0\x8E\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x99"],
        ["\xF3\xB0\x8E\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x99"],

        ["\xF3\xB0\x8E\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9A"],
        ["\xF3\xB0\x8E\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9A"],

        ["\xF3\xB0\x8E\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9B"],
        ["\xF3\xB0\x8E\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9B"],

        ["\xF3\xB0\x8E\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9C"],
        ["\xF3\xB0\x8E\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9C"],

        ["\xF3\xB0\x8E\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9D"],
        ["\xF3\xB0\x8E\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9D"],

        ["\xF3\xB0\x8E\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9E"],
        ["\xF3\xB0\x8E\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9E"],

        ["\xF3\xB0\x8E\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9F"],
        ["\xF3\xB0\x8E\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9F"],

        ["\xF3\xB0\x8E\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA0"],
        ["\xF3\xB0\x8E\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA0"],

        ["\xF3\xB0\x8E\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA1"],
        ["\xF3\xB0\x8E\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA1"],

        ["\xF3\xB0\x8E\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA2"],
        ["\xF3\xB0\x8E\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA2"],

        ["\xF3\xB0\x8E\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA3"],
        ["\xF3\xB0\x8E\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA3"],

        ["\xF3\xB0\x8E\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA4"],
        ["\xF3\xB0\x8E\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA4"],

        ["\xF3\xB0\x8E\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA5"],
        ["\xF3\xB0\x8E\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA5"],

        ["\xF3\xB0\x8E\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA6"],
        ["\xF3\xB0\x8E\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA6"],

        ["\xF3\xB0\x8E\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA7"],
        ["\xF3\xB0\x8E\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA7"],

        ["\xF3\xB0\x8E\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA8"],
        ["\xF3\xB0\x8E\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA8"],

        ["\xF3\xB0\x8E\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA9"],
        ["\xF3\xB0\x8E\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA9"],

        ["\xF3\xB0\x8E\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAA"],
        ["\xF3\xB0\x8E\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAA"],

        ["\xF3\xB0\x8E\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAB"],
        ["\xF3\xB0\x8E\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAB"],

        ["\xF3\xB0\x8E\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAC"],
        ["\xF3\xB0\x8E\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAC"],

        ["\xF3\xB0\x8E\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAD"],
        ["\xF3\xB0\x8E\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAD"],

        ["\xF3\xB0\x8E\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAE"],
        ["\xF3\xB0\x8E\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAE"],

        ["\xF3\xB0\x8E\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAF"],
        ["\xF3\xB0\x8E\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAF"],

        ["\xF3\xB0\x8E\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB0"],
        ["\xF3\xB0\x8E\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB0"],

        ["\xF3\xB0\x8E\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB1"],
        ["\xF3\xB0\x8E\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB1"],

        ["\xF3\xB0\x95\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA8"],
        ["\xF3\xB0\x95\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA8"],

        ["\xF3\xB0\x95\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA9"],
        ["\xF3\xB0\x95\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA9"],

        ["\xF3\xB0\x95\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAA"],
        ["\xF3\xB0\x95\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAA"],

        ["\xF3\xB0\x95\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAB"],
        ["\xF3\xB0\x95\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAB"],

        ["\xF3\xB0\x95\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAC"],
        ["\xF3\xB0\x95\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAC"],

        ["\xF3\xB0\x95\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAD"],
        ["\xF3\xB0\x95\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAD"],

        ["\xF3\xB0\x95\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAE"],
        ["\xF3\xB0\x95\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAE"],

        ["\xF3\xB0\x95\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAF"],
        ["\xF3\xB0\x95\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAF"],

        ["\xF3\xB0\x95\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB0"],
        ["\xF3\xB0\x95\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB0"],

        ["\xF3\xB0\x95\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB1"],
        ["\xF3\xB0\x95\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB1"],

        ["\xF3\xB0\x95\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB2"],
        ["\xF3\xB0\x95\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB2"],

        ["\xF3\xB0\x95\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB3"],
        ["\xF3\xB0\x95\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB3"],

        ["\xF3\xB0\x95\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB4"],
        ["\xF3\xB0\x95\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB4"],

        ["\xF3\xB0\x95\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB5"],
        ["\xF3\xB0\x95\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB5"],

        ["\xF3\xB0\x95\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB6"],
        ["\xF3\xB0\x95\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB6"],

        ["\xF3\xB0\x95\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB7"],
        ["\xF3\xB0\x95\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB7"],

        ["\xF3\xB0\x95\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB8"],
        ["\xF3\xB0\x95\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB8"],

        ["\xF3\xB0\x95\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB9"],
        ["\xF3\xB0\x95\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB9"],

        ["\xF3\xB0\x95\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBA"],
        ["\xF3\xB0\x95\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBA"],

        ["\xF3\xB0\x95\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBB"],
        ["\xF3\xB0\x95\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBB"],

        ["\xF3\xB0\x95\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBC"],
        ["\xF3\xB0\x95\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBC"],

        ["\xF3\xB0\x95\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBD"],
        ["\xF3\xB0\x95\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBD"],

        ["\xF3\xB0\x95\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBE"],
        ["\xF3\xB0\x95\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBE"],

        ["\xF3\xB0\x95\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBF"],
        ["\xF3\xB0\x95\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBF"],

        ["\xF3\xB0\x96\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x80"],
        ["\xF3\xB0\x96\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x80"],

        ["\xF3\xB0\x96\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x81"],
        ["\xF3\xB0\x96\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x81"],

        ["\xF3\xB0\x96\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x82"],
        ["\xF3\xB0\x96\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x82"],

        ["\xF3\xB0\x96\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x83"],
        ["\xF3\xB0\x96\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x83"],

        ["\xF3\xB0\x96\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x84"],
        ["\xF3\xB0\x96\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x84"],

        ["\xF3\xB0\x96\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x85"],
        ["\xF3\xB0\x96\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x85"],

        ["\xF3\xB0\x96\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x87"],
        ["\xF3\xB0\x96\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x87"],

        ["\xF3\xB0\x96\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x88"],
        ["\xF3\xB0\x96\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x88"],

        ["\xF3\xB0\x96\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x89"],
        ["\xF3\xB0\x96\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x89"],

        ["\xF3\xB0\x96\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8A"],
        ["\xF3\xB0\x96\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8A"],

        ["\xF3\xB0\x96\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8B"],
        ["\xF3\xB0\x96\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8B"],

        ["\xF3\xB0\x96\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8C"],
        ["\xF3\xB0\x96\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8C"],

        ["\xF3\xB0\x96\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8D"],
        ["\xF3\xB0\x96\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8D"],

        ["\xF3\xB0\x96\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8E"],
        ["\xF3\xB0\x96\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8E"],

        ["\xF3\xB0\x96\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8F"],
        ["\xF3\xB0\x96\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8F"],

        ["\xF3\xB0\x96\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x90"],
        ["\xF3\xB0\x96\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x90"],

        ["\xF3\xB0\x96\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x91"],
        ["\xF3\xB0\x96\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x91"],

        ["\xF3\xB0\x96\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x92"],
        ["\xF3\xB0\x96\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x92"],

        ["\xF3\xB0\x96\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x93"],
        ["\xF3\xB0\x96\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x93"],

        ["\xF3\xB0\x96\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x94"],
        ["\xF3\xB0\x96\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x94"],

        ["\xF3\xB0\x96\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x95"],
        ["\xF3\xB0\x96\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x95"],

        ["\xF3\xB0\x96\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x96"],
        ["\xF3\xB0\x96\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x96"],

        ["\xF3\xB0\x96\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x97"],
        ["\xF3\xB0\x96\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x97"],

        ["\xF3\xB0\x96\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x98"],
        ["\xF3\xB0\x96\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x98"],

        ["\xF3\xB0\x96\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x99"],
        ["\xF3\xB0\x96\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x99"],

        ["\xF3\xB0\x96\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9A"],
        ["\xF3\xB0\x96\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9A"],

        ["\xF3\xB0\x96\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9B"],
        ["\xF3\xB0\x96\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9B"],

        ["\xF3\xB0\x96\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9C"],
        ["\xF3\xB0\x96\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9C"],

        ["\xF3\xB0\x96\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9D"],
        ["\xF3\xB0\x96\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9D"],

        ["\xF3\xB0\x96\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA6"],
        ["\xF3\xB0\x96\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA6"],

        ["\xF3\xB0\x96\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA7"],
        ["\xF3\xB0\x96\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA7"],

        ["\xF3\xB0\x96\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA8"],
        ["\xF3\xB0\x96\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA8"],

        ["\xF3\xB0\x96\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA9"],
        ["\xF3\xB0\x96\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA9"],

        ["\xF3\xB0\x96\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAA"],
        ["\xF3\xB0\x96\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAA"],

        ["\xF3\xB0\x96\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAB"],
        ["\xF3\xB0\x96\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAB"],

        ["\xF3\xB0\x96\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAC"],
        ["\xF3\xB0\x96\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAC"],

        ["\xF3\xB0\x96\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAD"],
        ["\xF3\xB0\x96\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAD"],

        ["\xF3\xB0\x96\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAE"],
        ["\xF3\xB0\x96\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAE"],

        ["\xF3\xB0\x96\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAF"],
        ["\xF3\xB0\x96\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAF"],

        ["\xF3\xB0\x96\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB0"],
        ["\xF3\xB0\x96\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB0"],

        ["\xF3\xB0\x96\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB1"],
        ["\xF3\xB0\x96\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB1"],

        ["\xF3\xB0\x96\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB2"],
        ["\xF3\xB0\x96\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB2"],

        ["\xF3\xB0\x96\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB3"],
        ["\xF3\xB0\x96\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB3"],

        ["\xF3\xB0\x96\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB4"],
        ["\xF3\xB0\x96\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB4"],

        ["\xF3\xB0\x96\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB5"],
        ["\xF3\xB0\x96\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB5"],

        ["\xF3\xB0\x96\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB6"],
        ["\xF3\xB0\x96\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB6"],

        ["\xF3\xB0\x96\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBA"],
        ["\xF3\xB0\x96\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBA"],

        ["\xF3\xB0\x96\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBB"],
        ["\xF3\xB0\x96\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBB"],

        ["\xF3\xB0\x96\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBF"],
        ["\xF3\xB0\x96\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBF"],

        ["\xF3\xB0\x97\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x97\x80"],
        ["\xF3\xB0\x97\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x97\x80"],

        ["\xF3\xB0\x9A\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x82"],
        ["\xF3\xB0\x9A\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x82"],

        ["\xF3\xB0\x9A\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x83"],
        ["\xF3\xB0\x9A\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x83"],

        ["\xF3\xB0\x9A\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x84"],
        ["\xF3\xB0\x9A\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x84"],

        ["\xF3\xB0\x9A\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x85"],
        ["\xF3\xB0\x9A\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x85"],

        ["\xF3\xB0\x9A\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x86"],
        ["\xF3\xB0\x9A\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x86"],

        ["\xF3\xB0\x9A\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x87"],
        ["\xF3\xB0\x9A\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x87"],

        ["\xF3\xB0\x9A\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x88"],
        ["\xF3\xB0\x9A\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x88"],

        ["\xF3\xB0\x9A\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x89"],
        ["\xF3\xB0\x9A\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x89"],

        ["\xF3\xB0\x9A\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8A"],
        ["\xF3\xB0\x9A\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8A"],

        ["\xF3\xB0\x9A\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8B"],
        ["\xF3\xB0\x9A\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8B"],

        ["\xF3\xB0\x9A\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8C"],
        ["\xF3\xB0\x9A\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8C"],

        ["\xF3\xB0\x9A\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8D"],
        ["\xF3\xB0\x9A\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8D"],

        ["\xF3\xB0\x9A\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8E"],
        ["\xF3\xB0\x9A\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8E"],

        ["\xF3\xB0\x9A\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8F"],
        ["\xF3\xB0\x9A\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8F"],

        ["\xF3\xB0\x9A\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x90"],
        ["\xF3\xB0\x9A\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x90"],

        ["\xF3\xB0\x9A\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x91"],
        ["\xF3\xB0\x9A\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x91"],

        ["\xF3\xB0\x9A\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x92"],
        ["\xF3\xB0\x9A\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x92"],

        ["\xF3\xB0\x9A\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x93"],
        ["\xF3\xB0\x9A\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x93"],

        ["\xF3\xB0\x9A\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x94"],
        ["\xF3\xB0\x9A\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x94"],

        ["\xF3\xB0\x9A\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x95"],
        ["\xF3\xB0\x9A\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x95"],

        ["\xF3\xB0\x9A\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x96"],
        ["\xF3\xB0\x9A\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x96"],

        ["\xF3\xB0\x9A\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x97"],
        ["\xF3\xB0\x9A\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x97"],

        ["\xF3\xB0\x9A\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x98"],
        ["\xF3\xB0\x9A\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x98"],

        ["\xF3\xB0\x9A\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x99"],
        ["\xF3\xB0\x9A\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x99"],

        ["\xF3\xB0\x9A\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9A"],
        ["\xF3\xB0\x9A\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9A"],

        ["\xF3\xB0\x9A\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9B"],
        ["\xF3\xB0\x9A\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9B"],

        ["\xF3\xB0\x9A\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9C"],
        ["\xF3\xB0\x9A\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9C"],

        ["\xF3\xB0\x9A\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9D"],
        ["\xF3\xB0\x9A\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9D"],

        ["\xF3\xB0\x9A\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9E"],
        ["\xF3\xB0\x9A\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9E"],

        ["\xF3\xB0\x9A\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9F"],
        ["\xF3\xB0\x9A\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9F"],

        ["\xF3\xB0\x9A\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA0"],
        ["\xF3\xB0\x9A\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA0"],

        ["\xF3\xB0\x9A\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA1"],
        ["\xF3\xB0\x9A\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA1"],

        ["\xF3\xB0\x9A\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA2"],
        ["\xF3\xB0\x9A\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA2"],

        ["\xF3\xB0\x9A\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA3"],
        ["\xF3\xB0\x9A\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA3"],

        ["\xF3\xB0\x9A\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA4"],
        ["\xF3\xB0\x9A\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA4"],

        ["\xF3\xB0\x9A\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA5"],
        ["\xF3\xB0\x9A\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA5"],

        ["\xF3\xB0\x9A\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA6"],
        ["\xF3\xB0\x9A\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA6"],

        ["\xF3\xB0\x9A\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA7"],
        ["\xF3\xB0\x9A\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA7"],

        ["\xF3\xB0\x9A\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA8"],
        ["\xF3\xB0\x9A\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA8"],

        ["\xF3\xB0\x9A\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA9"],
        ["\xF3\xB0\x9A\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA9"],

        ["\xF3\xB0\x9A\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAA"],
        ["\xF3\xB0\x9A\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAA"],

        ["\xF3\xB0\x9A\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAB"],
        ["\xF3\xB0\x9A\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAB"],

        ["\xF3\xB0\x9A\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAC"],
        ["\xF3\xB0\x9A\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAC"],

        ["\xF3\xB0\x9A\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAD"],
        ["\xF3\xB0\x9A\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAD"],

        ["\xF3\xB0\x9A\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAE"],
        ["\xF3\xB0\x9A\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAE"],

        ["\xF3\xB0\x9A\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAF"],
        ["\xF3\xB0\x9A\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAF"],

        ["\xF3\xB0\x9A\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB0"],
        ["\xF3\xB0\x9A\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB0"],

        ["\xF3\xB0\x9A\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB1"],
        ["\xF3\xB0\x9A\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB1"],

        ["\xF3\xB0\x9A\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB2"],
        ["\xF3\xB0\x9A\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB2"],

        ["\xF3\xB0\x9A\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB3"],
        ["\xF3\xB0\x9A\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB3"],

        ["\xF3\xB0\x9A\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB4"],
        ["\xF3\xB0\x9A\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB4"],

        ["\xF3\xB0\x9A\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB5"],
        ["\xF3\xB0\x9A\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB5"],

        ["\xF3\xB0\x9A\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB6"],
        ["\xF3\xB0\x9A\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB6"],

        ["\xF3\xB0\x9A\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB7"],
        ["\xF3\xB0\x9A\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB7"],

        ["\xF3\xB0\x9A\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB8"],
        ["\xF3\xB0\x9A\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB8"],

        ["\xF3\xB0\x9A\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB9"],
        ["\xF3\xB0\x9A\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB9"],

        ["\xF3\xB0\x9A\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBA"],
        ["\xF3\xB0\x9A\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBA"],

        ["\xF3\xB0\x9A\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBB"],
        ["\xF3\xB0\x9A\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBB"],

        ["\xF3\xB0\x9A\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBC"],
        ["\xF3\xB0\x9A\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBC"],

        ["\xF3\xB0\x9A\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBD"],
        ["\xF3\xB0\x9A\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBD"],

        ["\xF3\xB0\x9A\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBE"],
        ["\xF3\xB0\x9A\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBE"],

        ["\xF3\xB0\x9A\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBF"],
        ["\xF3\xB0\x9A\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBF"],

        ["\xF3\xB0\x9B\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x80"],
        ["\xF3\xB0\x9B\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x80"],

        ["\xF3\xB0\x9B\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x81"],
        ["\xF3\xB0\x9B\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x81"],

        ["\xF3\xB0\x9B\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x82"],
        ["\xF3\xB0\x9B\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x82"],

        ["\xF3\xB0\x9B\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x83"],
        ["\xF3\xB0\x9B\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x83"],

        ["\xF3\xB0\x9B\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x84"],
        ["\xF3\xB0\x9B\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x84"],

        ["\xF3\xB0\x9B\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x85"],
        ["\xF3\xB0\x9B\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x85"],

        ["\xF3\xB0\x9B\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x86"],
        ["\xF3\xB0\x9B\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x86"],

        ["\xF3\xB0\x9B\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x87"],
        ["\xF3\xB0\x9B\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x87"],

        ["\xF3\xB0\x9B\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x88"],
        ["\xF3\xB0\x9B\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x88"],

        ["\xF3\xB0\x9B\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x89"],
        ["\xF3\xB0\x9B\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x89"],

        ["\xF3\xB0\x9B\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8A"],
        ["\xF3\xB0\x9B\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8A"],

        ["\xF3\xB0\x9B\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8B"],
        ["\xF3\xB0\x9B\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8B"],

        ["\xF3\xB0\x9B\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8C"],
        ["\xF3\xB0\x9B\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8C"],

        ["\xF3\xB0\x9B\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8D"],
        ["\xF3\xB0\x9B\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8D"],

        ["\xF3\xB0\x9B\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8E"],
        ["\xF3\xB0\x9B\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8E"],

        ["\xF3\xB0\x9B\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8F"],
        ["\xF3\xB0\x9B\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8F"],

        ["\xF3\xB0\x9B\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x90"],
        ["\xF3\xB0\x9B\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x90"],

        ["\xF3\xB0\x9B\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x91"],
        ["\xF3\xB0\x9B\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x91"],

        ["\xF3\xB0\x9B\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x92"],
        ["\xF3\xB0\x9B\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x92"],

        ["\xF3\xB0\x9B\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x93"],
        ["\xF3\xB0\x9B\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x93"],

        ["\xF3\xB0\x9B\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x94"],
        ["\xF3\xB0\x9B\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x94"],

        ["\xF3\xB0\x9B\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x95"],
        ["\xF3\xB0\x9B\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x95"],

        ["\xF3\xB0\x9B\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x96"],
        ["\xF3\xB0\x9B\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x96"],

        ["\xF3\xB0\x9B\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x97"],
        ["\xF3\xB0\x9B\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x97"],

        ["\xF3\xB0\x9B\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x98"],
        ["\xF3\xB0\x9B\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x98"],

        ["\xF3\xB0\x9B\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x99"],
        ["\xF3\xB0\x9B\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x99"],

        ["\xF3\xB0\x9B\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9A"],
        ["\xF3\xB0\x9B\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9A"],

        ["\xF3\xB0\x9B\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9B"],
        ["\xF3\xB0\x9B\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9B"],

        ["\xF3\xB0\x9B\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9C"],
        ["\xF3\xB0\x9B\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9C"],

        ["\xF3\xB0\x9B\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9D"],
        ["\xF3\xB0\x9B\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9D"],

        ["\xF3\xB0\x9B\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9E"],
        ["\xF3\xB0\x9B\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9E"],

        ["\xF3\xB0\x9B\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9F"],
        ["\xF3\xB0\x9B\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9F"],

        ["\xF3\xB0\x9B\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA0"],
        ["\xF3\xB0\x9B\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA0"],

        ["\xF3\xB0\x9B\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA1"],
        ["\xF3\xB0\x9B\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA1"],

        ["\xF3\xB0\x9B\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA2"],
        ["\xF3\xB0\x9B\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA2"],

        ["\xF3\xB0\x9B\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA3"],
        ["\xF3\xB0\x9B\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA3"],

        ["\xF3\xB0\x9B\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA4"],
        ["\xF3\xB0\x9B\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA4"],

        ["\xF3\xB0\x9B\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA5"],
        ["\xF3\xB0\x9B\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA5"],

        ["\xF3\xB0\x9B\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA6"],
        ["\xF3\xB0\x9B\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA6"],

        ["\xF3\xB0\x9B\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA7"],
        ["\xF3\xB0\x9B\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA7"],

        ["\xF3\xB0\x9B\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA8"],
        ["\xF3\xB0\x9B\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA8"],

        ["\xF3\xB0\x9B\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA9"],
        ["\xF3\xB0\x9B\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA9"],

        ["\xF3\xB0\x9B\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAA"],
        ["\xF3\xB0\x9B\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAA"],

        ["\xF3\xB0\x9B\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAB"],
        ["\xF3\xB0\x9B\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAB"],

        ["\xF3\xB0\x9B\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAC"],
        ["\xF3\xB0\x9B\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAC"],

        ["\xF3\xB0\x9B\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAD"],
        ["\xF3\xB0\x9B\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAD"],

        ["\xF3\xB0\x9B\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAE"],
        ["\xF3\xB0\x9B\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAE"],

        ["\xF3\xB0\x9B\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAF"],
        ["\xF3\xB0\x9B\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAF"],

        ["\xF3\xB0\x9B\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB0"],
        ["\xF3\xB0\x9B\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB0"],

        ["\xF3\xB0\x9B\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB1"],
        ["\xF3\xB0\x9B\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB1"],

        ["\xF3\xB0\x9B\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB2"],
        ["\xF3\xB0\x9B\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB2"],

        ["\xF3\xB0\x9B\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB3"],
        ["\xF3\xB0\x9B\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB3"],

        ["\xF3\xB0\x9B\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB4"],
        ["\xF3\xB0\x9B\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB4"],

        ["\xF3\xB0\x9B\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB5"],
        ["\xF3\xB0\x9B\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB5"],

        ["\xF3\xB0\x9B\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB6"],
        ["\xF3\xB0\x9B\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB6"],

        ["\xF3\xB0\x9B\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB7"],
        ["\xF3\xB0\x9B\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB7"],

        ["\xF3\xB0\x9B\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB8"],
        ["\xF3\xB0\x9B\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB8"],

        ["\xF3\xB0\x9B\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB9"],
        ["\xF3\xB0\x9B\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB9"],

        ["\xF3\xB0\x9B\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBA"],
        ["\xF3\xB0\x9B\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBA"],

        ["\xF3\xB0\x9B\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBB"],
        ["\xF3\xB0\x9B\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBB"],

        ["\xF3\xB0\x9B\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBC"],
        ["\xF3\xB0\x9B\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBC"],

        ["\xF3\xB0\x9B\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBD"],
        ["\xF3\xB0\x9B\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBD"],

        ["\xF3\xB0\x9B\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBE"],
        ["\xF3\xB0\x9B\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBE"],

        ["\xF3\xB0\x9B\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBF"],
        ["\xF3\xB0\x9B\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBF"],

        ["\xF3\xB0\x9C\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x80"],
        ["\xF3\xB0\x9C\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x80"],

        ["\xF3\xB0\x9C\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x81"],
        ["\xF3\xB0\x9C\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x81"],

        ["\xF3\xB0\x9C\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x82"],
        ["\xF3\xB0\x9C\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x82"],

        ["\xF3\xB0\x9C\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x83"],
        ["\xF3\xB0\x9C\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x83"],

        ["\xF3\xB0\x9C\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x84"],
        ["\xF3\xB0\x9C\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x84"],

        ["\xF3\xB0\x9C\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x85"],
        ["\xF3\xB0\x9C\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x85"],

        ["\xF3\xB0\x9C\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x86"],
        ["\xF3\xB0\x9C\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x86"],

        ["\xF3\xB0\x9C\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x87"],
        ["\xF3\xB0\x9C\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x87"],

        ["\xF3\xB0\x9C\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x88"],
        ["\xF3\xB0\x9C\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x88"],

        ["\xF3\xB0\x9C\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x89"],
        ["\xF3\xB0\x9C\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x89"],

        ["\xF3\xB0\x9C\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8A"],
        ["\xF3\xB0\x9C\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8A"],

        ["\xF3\xB0\x9C\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8B"],
        ["\xF3\xB0\x9C\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8B"],

        ["\xF3\xB0\x9C\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8C"],
        ["\xF3\xB0\x9C\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8C"],

        ["\xF3\xB0\x9C\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8D"],
        ["\xF3\xB0\x9C\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8D"],

        ["\xF3\xB0\x9C\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8E"],
        ["\xF3\xB0\x9C\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8E"],

        ["\xF3\xB0\x9C\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8F"],
        ["\xF3\xB0\x9C\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8F"],

        ["\xF3\xB0\x9C\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x90"],
        ["\xF3\xB0\x9C\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x90"],

        ["\xF3\xB0\x9C\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x91"],
        ["\xF3\xB0\x9C\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x91"],

        ["\xF3\xB0\x9C\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x92"],
        ["\xF3\xB0\x9C\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x92"],

        ["\xF3\xB0\x9C\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x93"],
        ["\xF3\xB0\x9C\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x93"],

        ["\xF3\xB0\x9C\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x94"],
        ["\xF3\xB0\x9C\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x94"],

        ["\xF3\xB0\x9C\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x95"],
        ["\xF3\xB0\x9C\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x95"],

        ["\xF3\xB0\x9C\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x96"],
        ["\xF3\xB0\x9C\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x96"],

        ["\xF3\xB0\x9C\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x97"],
        ["\xF3\xB0\x9C\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x97"],

        ["\xF3\xB0\x9C\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x98"],
        ["\xF3\xB0\x9C\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x98"],

        ["\xF3\xB0\x9C\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x99"],
        ["\xF3\xB0\x9C\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x99"],

        ["\xF3\xB0\x9C\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9A"],
        ["\xF3\xB0\x9C\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9A"],

        ["\xF3\xB0\x9C\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9B"],
        ["\xF3\xB0\x9C\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9B"],

        ["\xF3\xB0\x9C\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9C"],
        ["\xF3\xB0\x9C\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9C"],

        ["\xF3\xB0\x9C\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9D"],
        ["\xF3\xB0\x9C\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9D"],

        ["\xF3\xB0\x9C\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9E"],
        ["\xF3\xB0\x9C\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9E"],

        ["\xF3\xB0\x9C\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9F"],
        ["\xF3\xB0\x9C\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9F"],

        ["\xF3\xB0\x9C\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA0"],
        ["\xF3\xB0\x9C\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA0"],

        ["\xF3\xB0\x9C\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA1"],
        ["\xF3\xB0\x9C\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA1"],

        ["\xF3\xB0\x9C\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA2"],
        ["\xF3\xB0\x9C\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA2"],

        ["\xF3\xB0\x9C\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA3"],
        ["\xF3\xB0\x9C\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA3"],

        ["\xF3\xB0\x9C\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA4"],
        ["\xF3\xB0\x9C\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA4"],

        ["\xF3\xB0\x9C\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA5"],
        ["\xF3\xB0\x9C\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA5"],

        ["\xF3\xB0\x9C\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA6"],
        ["\xF3\xB0\x9C\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA6"],

        ["\xF3\xB0\x9C\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA7"],
        ["\xF3\xB0\x9C\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA7"],

        ["\xF3\xB0\x9C\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA8"],
        ["\xF3\xB0\x9C\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA8"],

        ["\xF3\xB0\x9C\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA9"],
        ["\xF3\xB0\x9C\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA9"],

        ["\xF3\xB0\x9C\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAA"],
        ["\xF3\xB0\x9C\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAA"],

        ["\xF3\xB0\x9C\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAB"],
        ["\xF3\xB0\x9C\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAB"],

        ["\xF3\xB0\x9C\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAC"],
        ["\xF3\xB0\x9C\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAC"],

        ["\xF3\xB0\x9C\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAD"],
        ["\xF3\xB0\x9C\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAD"],

        ["\xF3\xB0\x9C\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAE"],
        ["\xF3\xB0\x9C\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAE"],

        ["\xF3\xB0\x9C\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAF"],
        ["\xF3\xB0\x9C\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAF"],

        ["\xF3\xB0\x9C\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB0"],
        ["\xF3\xB0\x9C\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB0"],

        ["\xF3\xB0\x9C\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB1"],
        ["\xF3\xB0\x9C\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB1"],

        ["\xF3\xB0\x9C\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB2"],
        ["\xF3\xB0\x9C\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB2"],

        ["\xF3\xB0\x9C\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB3"],
        ["\xF3\xB0\x9C\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB3"],

        ["\xF3\xB0\x9C\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB4"],
        ["\xF3\xB0\x9C\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB4"],

        ["\xF3\xB0\x9C\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB5"],
        ["\xF3\xB0\x9C\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB5"],

        ["\xF3\xB0\x9C\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB6"],
        ["\xF3\xB0\x9C\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB6"],

        ["\xF3\xB0\x9C\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB7"],
        ["\xF3\xB0\x9C\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB7"],

        ["\xF3\xB0\x9C\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB8"],
        ["\xF3\xB0\x9C\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB8"],

        ["\xF3\xB0\x9C\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB9"],
        ["\xF3\xB0\x9C\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB9"],

        ["\xF3\xB0\x9C\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBA"],
        ["\xF3\xB0\x9C\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBA"],

        ["\xF3\xB0\x9C\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBB"],
        ["\xF3\xB0\x9C\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBB"],

        ["\xF3\xB0\x9C\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBC"],
        ["\xF3\xB0\x9C\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBC"],

        ["\xF3\xB0\x9C\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBD"],
        ["\xF3\xB0\x9C\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBD"],

        ["\xF3\xB0\x9C\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBE"],
        ["\xF3\xB0\x9C\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBE"],

        ["\xF3\xB0\x9C\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBF"],
        ["\xF3\xB0\x9C\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBF"],

        ["\xF3\xB0\x9D\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x80"],
        ["\xF3\xB0\x9D\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x80"],

        ["\xF3\xB0\x9D\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x81"],
        ["\xF3\xB0\x9D\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x81"],

        ["\xF3\xB0\x9D\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x82"],
        ["\xF3\xB0\x9D\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x82"],

        ["\xF3\xB0\x9D\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x83"],
        ["\xF3\xB0\x9D\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x83"],

        ["\xF3\xB0\x9D\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x84"],
        ["\xF3\xB0\x9D\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x84"],

        ["\xF3\xB0\x9D\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x85"],
        ["\xF3\xB0\x9D\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x85"],

        ["\xF3\xB0\x9D\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x86"],
        ["\xF3\xB0\x9D\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x86"],

        ["\xF3\xB0\x9D\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x87"],
        ["\xF3\xB0\x9D\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x87"],

        ["\xF3\xB0\x9D\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x88"],
        ["\xF3\xB0\x9D\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x88"],

        ["\xF3\xB0\x9D\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x89"],
        ["\xF3\xB0\x9D\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x89"],

        ["\xF3\xB0\x9D\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8A"],
        ["\xF3\xB0\x9D\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8A"],

        ["\xF3\xB0\x9D\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8B"],
        ["\xF3\xB0\x9D\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8B"],

        ["\xF3\xB0\x9D\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8C"],
        ["\xF3\xB0\x9D\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8C"],

        ["\xF3\xB0\x9D\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8D"],
        ["\xF3\xB0\x9D\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8D"],

        ["\xF3\xB0\x9D\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8E"],
        ["\xF3\xB0\x9D\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8E"],

        ["\xF3\xB0\x9D\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8F"],
        ["\xF3\xB0\x9D\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8F"],

        ["\xF3\xB0\x9D\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x90"],
        ["\xF3\xB0\x9D\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x90"],

        ["\xF3\xB0\x9D\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x91"],
        ["\xF3\xB0\x9D\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x91"],

        ["\xF3\xB0\x9D\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x92"],
        ["\xF3\xB0\x9D\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x92"],

        ["\xF3\xB0\x9D\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x93"],
        ["\xF3\xB0\x9D\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x93"],

        ["\xF3\xB0\x9D\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x94"],
        ["\xF3\xB0\x9D\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x94"],

        ["\xF3\xB0\x9D\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x95"],
        ["\xF3\xB0\x9D\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x95"],

        ["\xF3\xB0\x9D\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x96"],
        ["\xF3\xB0\x9D\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x96"],

        ["\xF3\xB0\x9D\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x97"],
        ["\xF3\xB0\x9D\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x97"],

        ["\xF3\xB0\x9D\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x98"],
        ["\xF3\xB0\x9D\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x98"],

        ["\xF3\xB0\x9D\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x99"],
        ["\xF3\xB0\x9D\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x99"],

        ["\xF3\xB0\x9D\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9A"],
        ["\xF3\xB0\x9D\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9A"],

        ["\xF3\xB0\x9D\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9B"],
        ["\xF3\xB0\x9D\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9B"],

        ["\xF3\xB0\x9D\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9C"],
        ["\xF3\xB0\x9D\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9C"],

        ["\xF3\xB0\x9D\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9D"],
        ["\xF3\xB0\x9D\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9D"],

        ["\xF3\xB0\x9D\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9E"],
        ["\xF3\xB0\x9D\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9E"],

        ["\xF3\xB0\x9D\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9F"],
        ["\xF3\xB0\x9D\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9F"],

        ["\xF3\xB0\x9D\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA0"],
        ["\xF3\xB0\x9D\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA0"],

        ["\xF3\xB0\x9D\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA1"],
        ["\xF3\xB0\x9D\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA1"],

        ["\xF3\xB0\x9D\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA2"],
        ["\xF3\xB0\x9D\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA2"],

        ["\xF3\xB0\x9D\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA3"],
        ["\xF3\xB0\x9D\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA3"],

        ["\xF3\xB0\x9D\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA4"],
        ["\xF3\xB0\x9D\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA4"],

        ["\xF3\xB0\x9D\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA5"],
        ["\xF3\xB0\x9D\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA5"],

        ["\xF3\xB0\x9D\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA6"],
        ["\xF3\xB0\x9D\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA6"],

        ["\xF3\xB0\x9D\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA7"],
        ["\xF3\xB0\x9D\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA7"],

        ["\xF3\xB0\x9D\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA8"],
        ["\xF3\xB0\x9D\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA8"],

        ["\xF3\xB0\x9D\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA9"],
        ["\xF3\xB0\x9D\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA9"],

        ["\xF3\xB0\x9D\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAA"],
        ["\xF3\xB0\x9D\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAA"],

        ["\xF3\xB0\x9D\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAB"],
        ["\xF3\xB0\x9D\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAB"],

        ["\xF3\xB0\x9D\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAC"],
        ["\xF3\xB0\x9D\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAC"],

        ["\xF3\xB0\x9D\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAD"],
        ["\xF3\xB0\x9D\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAD"],

        ["\xF3\xB0\x9D\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAE"],
        ["\xF3\xB0\x9D\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAE"],

        ["\xF3\xB0\x9D\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAF"],
        ["\xF3\xB0\x9D\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAF"],

        ["\xF3\xB0\x9D\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB0"],
        ["\xF3\xB0\x9D\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB0"],

        ["\xF3\xB0\x9D\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB1"],
        ["\xF3\xB0\x9D\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB1"],

        ["\xF3\xB0\x9D\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB2"],
        ["\xF3\xB0\x9D\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB2"],

        ["\xF3\xB0\x9D\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB3"],
        ["\xF3\xB0\x9D\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB3"],

        ["\xF3\xB0\x9D\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB4"],
        ["\xF3\xB0\x9D\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB4"],

        ["\xF3\xB0\x9D\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB5"],
        ["\xF3\xB0\x9D\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB5"],

        ["\xF3\xB0\x9D\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB6"],
        ["\xF3\xB0\x9D\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB6"],

        ["\xF3\xB0\x9D\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB7"],
        ["\xF3\xB0\x9D\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB7"],

        ["\xF3\xB0\x9D\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB8"],
        ["\xF3\xB0\x9D\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB8"],

        ["\xF3\xB0\x9D\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB9"],
        ["\xF3\xB0\x9D\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB9"],

        ["\xF3\xB0\x9D\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBA"],
        ["\xF3\xB0\x9D\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBA"],

        ["\xF3\xB0\x9D\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBB"],
        ["\xF3\xB0\x9D\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBB"],

        ["\xF3\xB0\x9D\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBC"],
        ["\xF3\xB0\x9D\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBC"],

        ["\xF3\xB0\x9D\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBD"],
        ["\xF3\xB0\x9D\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBD"],

        ["\xF3\xB0\x9D\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBE"],
        ["\xF3\xB0\x9D\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBE"],

        ["\xF3\xB0\x9D\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBF"],
        ["\xF3\xB0\x9D\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBF"],

        ["\xF3\xB0\x9E\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x80"],
        ["\xF3\xB0\x9E\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x80"],

        ["\xF3\xB0\x9E\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x81"],
        ["\xF3\xB0\x9E\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x81"],

        ["\xF3\xB0\x9E\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x82"],
        ["\xF3\xB0\x9E\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x82"],

        ["\xF3\xB0\x9E\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x83"],
        ["\xF3\xB0\x9E\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x83"],

        ["\xF3\xB0\x9E\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x84"],
        ["\xF3\xB0\x9E\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x84"],

        ["\xF3\xB0\x9E\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x85"],
        ["\xF3\xB0\x9E\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x85"],

        ["\xF3\xB0\x9E\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x86"],
        ["\xF3\xB0\x9E\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x86"],

        ["\xF3\xB0\x9E\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x87"],
        ["\xF3\xB0\x9E\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x87"],

        ["\xF3\xB0\x9E\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x88"],
        ["\xF3\xB0\x9E\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x88"],

        ["\xF3\xB0\x9E\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x89"],
        ["\xF3\xB0\x9E\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x89"],

        ["\xF3\xB0\x9E\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8A"],
        ["\xF3\xB0\x9E\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8A"],

        ["\xF3\xB0\x9E\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8B"],
        ["\xF3\xB0\x9E\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8B"],

        ["\xF3\xB0\x9E\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8C"],
        ["\xF3\xB0\x9E\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8C"],

        ["\xF3\xB0\x9E\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8D"],
        ["\xF3\xB0\x9E\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8D"],

        ["\xF3\xB0\x9E\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8E"],
        ["\xF3\xB0\x9E\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8E"],

        ["\xF3\xB0\x9E\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8F"],
        ["\xF3\xB0\x9E\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8F"],

        ["\xF3\xB0\x9E\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x90"],
        ["\xF3\xB0\x9E\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x90"],

        ["\xF3\xB0\x9E\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x91"],
        ["\xF3\xB0\x9E\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x91"],

        ["\xF3\xB0\x9E\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x92"],
        ["\xF3\xB0\x9E\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x92"],

        ["\xF3\xB0\x9E\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x93"],
        ["\xF3\xB0\x9E\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x93"],

        ["\xF3\xB0\x9E\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x94"],
        ["\xF3\xB0\x9E\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x94"],

        ["\xF3\xB0\x9E\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x95"],
        ["\xF3\xB0\x9E\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x95"],

        ["\xF3\xB0\x9E\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x96"],
        ["\xF3\xB0\x9E\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x96"],

        ["\xF3\xB0\x9E\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x97"],
        ["\xF3\xB0\x9E\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x97"],

        ["\xF3\xB0\x9E\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x98"],
        ["\xF3\xB0\x9E\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x98"],

        ["\xF3\xB0\x9E\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x99"],
        ["\xF3\xB0\x9E\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x99"],

        ["\xF3\xB0\x9E\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9A"],
        ["\xF3\xB0\x9E\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9A"],

        ["\xF3\xB0\x9E\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9B"],
        ["\xF3\xB0\x9E\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9B"],

        ["\xF3\xB0\x9E\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9C"],
        ["\xF3\xB0\x9E\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9C"],

        ["\xF3\xB0\x9E\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9D"],
        ["\xF3\xB0\x9E\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9D"],

        ["\xF3\xB0\x9E\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9E"],
        ["\xF3\xB0\x9E\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9E"],

        ["\xF3\xB0\x9E\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9F"],
        ["\xF3\xB0\x9E\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9F"],

        ["\xF3\xB0\x9E\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA0"],
        ["\xF3\xB0\x9E\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA0"],

        ["\xF3\xB0\x9E\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA1"],
        ["\xF3\xB0\x9E\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA1"],

        ["\xF3\xB0\x9E\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA2"],
        ["\xF3\xB0\x9E\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA2"],

        ["\xF3\xB0\x9E\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA3"],
        ["\xF3\xB0\x9E\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA3"],

        ["\xF3\xB0\x9E\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA4"],
        ["\xF3\xB0\x9E\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA4"],

        ["\xF3\xB0\x9E\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA5"],
        ["\xF3\xB0\x9E\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA5"],

        ["\xF3\xB0\x9E\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA6"],
        ["\xF3\xB0\x9E\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA6"],

        ["\xF3\xB0\x9E\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA7"],
        ["\xF3\xB0\x9E\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA7"],

        ["\xF3\xB0\x9E\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA8"],
        ["\xF3\xB0\x9E\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA8"],

        ["\xF3\xB0\x9E\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA9"],
        ["\xF3\xB0\x9E\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA9"],

        ["\xF3\xB0\x9E\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAA"],
        ["\xF3\xB0\x9E\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAA"],

        ["\xF3\xB0\x9E\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAB"],
        ["\xF3\xB0\x9E\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAB"],

        ["\xF3\xB0\x9E\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAC"],
        ["\xF3\xB0\x9E\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAC"],

        ["\xF3\xB0\x9E\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAD"],
        ["\xF3\xB0\x9E\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAD"],

        ["\xF3\xB0\x9E\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAE"],
        ["\xF3\xB0\x9E\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAE"],

        ["\xF3\xB0\x9E\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAF"],
        ["\xF3\xB0\x9E\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAF"],

        ["\xF3\xB0\x9E\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB0"],
        ["\xF3\xB0\x9E\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB0"],

        ["\xF3\xB0\x9E\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB1"],
        ["\xF3\xB0\x9E\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB1"],

        ["\xF3\xB0\x9E\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB2"],
        ["\xF3\xB0\x9E\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB2"],

        ["\xF3\xB0\x9E\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB3"],
        ["\xF3\xB0\x9E\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB3"],

        ["\xF3\xB0\x9E\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB4"],
        ["\xF3\xB0\x9E\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB4"],

        ["\xF3\xB0\x9E\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB5"],
        ["\xF3\xB0\x9E\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB5"],

        ["\xF3\xB0\x9E\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB6"],
        ["\xF3\xB0\x9E\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB6"],

        ["\xF3\xB0\x9E\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB7"],
        ["\xF3\xB0\x9E\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB7"],

        ["\xF3\xB0\x9E\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB8"],
        ["\xF3\xB0\x9E\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB8"],

        ["\xF3\xB0\x9E\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB9"],
        ["\xF3\xB0\x9E\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB9"],

        ["\xF3\xB0\x9E\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBA"],
        ["\xF3\xB0\x9E\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBA"],

        ["\xF3\xB0\x9E\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBB"],
        ["\xF3\xB0\x9E\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBB"],

        ["\xF3\xB0\x9E\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBC"],
        ["\xF3\xB0\x9E\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBC"],

        ["\xF3\xB0\x9E\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBD"],
        ["\xF3\xB0\x9E\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBD"],

        ["\xF3\xB0\x9E\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBE"],
        ["\xF3\xB0\x9E\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBE"],

        ["\xF3\xB0\x9E\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBF"],
        ["\xF3\xB0\x9E\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBF"],

        ["\xF3\xB0\x9F\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x80"],
        ["\xF3\xB0\x9F\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x80"],

        ["\xF3\xB0\x9F\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x81"],
        ["\xF3\xB0\x9F\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x81"],

        ["\xF3\xB0\x9F\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x82"],
        ["\xF3\xB0\x9F\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x82"],

        ["\xF3\xB0\x9F\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x83"],
        ["\xF3\xB0\x9F\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x83"],

        ["\xF3\xB0\x9F\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x84"],
        ["\xF3\xB0\x9F\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x84"],

        ["\xF3\xB0\x9F\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x85"],
        ["\xF3\xB0\x9F\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x85"],

        ["\xF3\xB0\x9F\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x86"],
        ["\xF3\xB0\x9F\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x86"],

        ["\xF3\xB0\x9F\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x87"],
        ["\xF3\xB0\x9F\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x87"],

        ["\xF3\xB0\x9F\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x88"],
        ["\xF3\xB0\x9F\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x88"],

        ["\xF3\xB0\x9F\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x89"],
        ["\xF3\xB0\x9F\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x89"],

        ["\xF3\xB0\x9F\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8A"],
        ["\xF3\xB0\x9F\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8A"],

        ["\xF3\xB0\x9F\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8B"],
        ["\xF3\xB0\x9F\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8B"],

        ["\xF3\xB0\x9F\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8C"],
        ["\xF3\xB0\x9F\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8C"],

        ["\xF3\xB0\x9F\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8D"],
        ["\xF3\xB0\x9F\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8D"],

        ["\xF3\xB0\x9F\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8E"],
        ["\xF3\xB0\x9F\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8E"],

        ["\xF3\xB0\x9F\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8F"],
        ["\xF3\xB0\x9F\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8F"],

        ["\xF3\xB0\x9F\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x90"],
        ["\xF3\xB0\x9F\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x90"],

        ["\xF3\xB0\x9F\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x91"],
        ["\xF3\xB0\x9F\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x91"],

        ["\xF3\xB0\x9F\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x92"],
        ["\xF3\xB0\x9F\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x92"],

        ["\xF3\xB0\x9F\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x93"],
        ["\xF3\xB0\x9F\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x93"],

        ["\xF3\xB0\x9F\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x94"],
        ["\xF3\xB0\x9F\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x94"],

        ["\xF3\xB0\x9F\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x95"],
        ["\xF3\xB0\x9F\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x95"],

        ["\xF3\xB0\x9F\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x96"],
        ["\xF3\xB0\x9F\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x96"],

        ["\xF3\xB0\x9F\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x97"],
        ["\xF3\xB0\x9F\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x97"],

        ["\xF3\xB0\x9F\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x98"],
        ["\xF3\xB0\x9F\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x98"],

        ["\xF3\xB0\x9F\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x99"],
        ["\xF3\xB0\x9F\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x99"],

        ["\xF3\xB0\x9F\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9A"],
        ["\xF3\xB0\x9F\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9A"],

        ["\xF3\xB0\x9F\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9B"],
        ["\xF3\xB0\x9F\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9B"],

        ["\xF3\xB0\x9F\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9C"],
        ["\xF3\xB0\x9F\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9C"],

        ["\xF3\xB0\x9F\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9D"],
        ["\xF3\xB0\x9F\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9D"],

        ["\xF3\xB0\x9F\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9E"],
        ["\xF3\xB0\x9F\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9E"],

        ["\xF3\xB0\x9F\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9F"],
        ["\xF3\xB0\x9F\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9F"],

        ["\xF3\xB0\x9F\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA0"],
        ["\xF3\xB0\x9F\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA0"],

        ["\xF3\xB0\x9F\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA1"],
        ["\xF3\xB0\x9F\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA1"],

        ["\xF3\xB0\x9F\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA2"],
        ["\xF3\xB0\x9F\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA2"],

        ["\xF3\xB0\x9F\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA3"],
        ["\xF3\xB0\x9F\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA3"],

        ["\xF3\xB0\x9F\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA4"],
        ["\xF3\xB0\x9F\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA4"],

        ["\xF3\xB0\x9F\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA5"],
        ["\xF3\xB0\x9F\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA5"],

        ["\xF3\xB0\x9F\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA6"],
        ["\xF3\xB0\x9F\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA6"],

        ["\xF3\xB0\x9F\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA7"],
        ["\xF3\xB0\x9F\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA7"],

        ["\xF3\xB0\x9F\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA8"],
        ["\xF3\xB0\x9F\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA8"],

        ["\xF3\xB0\x9F\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA9"],
        ["\xF3\xB0\x9F\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA9"],

        ["\xF3\xB0\x9F\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAA"],
        ["\xF3\xB0\x9F\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAA"],

        ["\xF3\xB0\x9F\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAB"],
        ["\xF3\xB0\x9F\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAB"],

        ["\xF3\xB0\x9F\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAC"],
        ["\xF3\xB0\x9F\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAC"],

        ["\xF3\xB0\x9F\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAD"],
        ["\xF3\xB0\x9F\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAD"],

        ["\xF3\xB0\x9F\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAE"],
        ["\xF3\xB0\x9F\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAE"],

        ["\xF3\xB0\x9F\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAF"],
        ["\xF3\xB0\x9F\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAF"],

        ["\xF3\xB0\x9F\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB0"],
        ["\xF3\xB0\x9F\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB0"],

        ["\xF3\xB0\x9F\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB1"],
        ["\xF3\xB0\x9F\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB1"],

        ["\xF3\xB0\x9F\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB2"],
        ["\xF3\xB0\x9F\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB2"],

        ["\xF3\xB0\x9F\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB3"],
        ["\xF3\xB0\x9F\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB3"],

        ["\xF3\xB0\x9F\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB4"],
        ["\xF3\xB0\x9F\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB4"],

        ["\xF3\xB0\x9F\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB5"],
        ["\xF3\xB0\x9F\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB5"],

        ["\xF3\xB0\x9F\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB6"],
        ["\xF3\xB0\x9F\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB6"],

        ["\xF3\xB0\x9F\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB7"],
        ["\xF3\xB0\x9F\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB7"],

        ["\xF3\xB0\x9F\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB8"],
        ["\xF3\xB0\x9F\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB8"],

        ["\xF3\xB0\x9F\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB9"],
        ["\xF3\xB0\x9F\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB9"],

        ["\xF3\xB0\x9F\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBA"],
        ["\xF3\xB0\x9F\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBA"],

        ["\xF3\xB0\x9F\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBB"],
        ["\xF3\xB0\x9F\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBB"],

        ["\xF3\xB0\x9F\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBC"],
        ["\xF3\xB0\x9F\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBC"],

        ["\xF3\xB0\x9F\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBD"],
        ["\xF3\xB0\x9F\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBD"],

        ["\xF3\xB0\x9F\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBE"],
        ["\xF3\xB0\x9F\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBE"],

        ["\xF3\xB0\x9F\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBF"],
        ["\xF3\xB0\x9F\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBF"],

        ["\xF3\xB0\xA0\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x80"],
        ["\xF3\xB0\xA0\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x80"],

        ["\xF3\xB0\xA0\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x81"],
        ["\xF3\xB0\xA0\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x81"],

        ["\xF3\xB0\xA0\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x82"],
        ["\xF3\xB0\xA0\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x82"],

        ["\xF3\xB0\xA0\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x83"],
        ["\xF3\xB0\xA0\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x83"],

        ["\xF3\xB0\xA0\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x84"],
        ["\xF3\xB0\xA0\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x84"],

        ["\xF3\xB0\xA0\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x85"],
        ["\xF3\xB0\xA0\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x85"],

        ["\xF3\xB0\xA0\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x86"],
        ["\xF3\xB0\xA0\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x86"],

        ["\xF3\xB0\xA0\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x87"],
        ["\xF3\xB0\xA0\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x87"],

        ["\xF3\xB0\xA0\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x88"],
        ["\xF3\xB0\xA0\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x88"],

        ["\xF3\xB0\xA0\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x89"],
        ["\xF3\xB0\xA0\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x89"],

        ["\xF3\xB0\xA0\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8A"],
        ["\xF3\xB0\xA0\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8A"],

        ["\xF3\xB0\xA0\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8B"],
        ["\xF3\xB0\xA0\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8B"],

        ["\xF3\xB0\xA0\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8C"],
        ["\xF3\xB0\xA0\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8C"],

        ["\xF3\xB0\xA0\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8D"],
        ["\xF3\xB0\xA0\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8D"],

        ["\xF3\xB0\xA0\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8E"],
        ["\xF3\xB0\xA0\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8E"],

        ["\xF3\xB0\xA0\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8F"],
        ["\xF3\xB0\xA0\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8F"],

        ["\xF3\xB0\xA0\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x90"],
        ["\xF3\xB0\xA0\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x90"],

        ["\xF3\xB0\xA0\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x91"],
        ["\xF3\xB0\xA0\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x91"],

        ["\xF3\xB0\xA0\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x92"],
        ["\xF3\xB0\xA0\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x92"],

        ["\xF3\xB0\xA0\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x93"],
        ["\xF3\xB0\xA0\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x93"],

        ["\xF3\xB0\xA0\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x94"],
        ["\xF3\xB0\xA0\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x94"],

        ["\xF3\xB0\xA0\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x95"],
        ["\xF3\xB0\xA0\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x95"],

        ["\xF3\xB0\xA0\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x96"],
        ["\xF3\xB0\xA0\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x96"],

        ["\xF3\xB0\xA0\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x97"],
        ["\xF3\xB0\xA0\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x97"],

        ["\xF3\xB0\xA0\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x98"],
        ["\xF3\xB0\xA0\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x98"],

        ["\xF3\xB0\xA0\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x99"],
        ["\xF3\xB0\xA0\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x99"],

        ["\xF3\xB0\xA0\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9A"],
        ["\xF3\xB0\xA0\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9A"],

        ["\xF3\xB0\xA0\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9B"],
        ["\xF3\xB0\xA0\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9B"],

        ["\xF3\xB0\xA0\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9C"],
        ["\xF3\xB0\xA0\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9C"],

        ["\xF3\xB0\xA0\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9D"],
        ["\xF3\xB0\xA0\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9D"],

        ["\xF3\xB0\xA0\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9E"],
        ["\xF3\xB0\xA0\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9E"],

        ["\xF3\xB0\xA0\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9F"],
        ["\xF3\xB0\xA0\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9F"],

        ["\xF3\xB0\xA0\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA0"],
        ["\xF3\xB0\xA0\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA0"],

        ["\xF3\xB0\xA0\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA1"],
        ["\xF3\xB0\xA0\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA1"],

        ["\xF3\xB0\xA0\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA2"],
        ["\xF3\xB0\xA0\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA2"],

        ["\xF3\xB0\xA0\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA3"],
        ["\xF3\xB0\xA0\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA3"],

        ["\xF3\xB0\xA0\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA4"],
        ["\xF3\xB0\xA0\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA4"],

        ["\xF3\xB0\xA0\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA5"],
        ["\xF3\xB0\xA0\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA5"],

        ["\xF3\xB0\xA0\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA6"],
        ["\xF3\xB0\xA0\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA6"],

        ["\xF3\xB0\xA0\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA7"],
        ["\xF3\xB0\xA0\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA7"],

        ["\xF3\xB0\xA0\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA8"],
        ["\xF3\xB0\xA0\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA8"],

        ["\xF3\xB0\xA0\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA9"],
        ["\xF3\xB0\xA0\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA9"],

        ["\xF3\xB0\xA0\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAA"],
        ["\xF3\xB0\xA0\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAA"],

        ["\xF3\xB0\xA0\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAB"],
        ["\xF3\xB0\xA0\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAB"],

        ["\xF3\xB0\xA0\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAC"],
        ["\xF3\xB0\xA0\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAC"],

        ["\xF3\xB0\xA0\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAD"],
        ["\xF3\xB0\xA0\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAD"],

        ["\xF3\xB0\xA0\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAE"],
        ["\xF3\xB0\xA0\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAE"],

        ["\xF3\xB0\xA0\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAF"],
        ["\xF3\xB0\xA0\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAF"],

        ["\xF3\xB0\xA0\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB0"],
        ["\xF3\xB0\xA0\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB0"],

        ["\xF3\xB0\xA0\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB1"],
        ["\xF3\xB0\xA0\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB1"],

        ["\xF3\xB0\xA0\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB2"],
        ["\xF3\xB0\xA0\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB2"],

        ["\xF3\xB0\xA0\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB3"],
        ["\xF3\xB0\xA0\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB3"],

        ["\xF3\xB0\xA0\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB4"],
        ["\xF3\xB0\xA0\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB4"],

        ["\xF3\xB0\xA0\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB5"],
        ["\xF3\xB0\xA0\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB5"],

        ["\xF3\xB0\xA0\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB6"],
        ["\xF3\xB0\xA0\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB6"],

        ["\xF3\xB0\xA0\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB7"],
        ["\xF3\xB0\xA0\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB7"],

        ["\xF3\xB0\xA0\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB8"],
        ["\xF3\xB0\xA0\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB8"],

        ["\xF3\xB0\xA0\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB9"],
        ["\xF3\xB0\xA0\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB9"],

        ["\xF3\xB0\xA0\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBA"],
        ["\xF3\xB0\xA0\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBA"],

        ["\xF3\xB0\xA0\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBB"],
        ["\xF3\xB0\xA0\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBB"],

        ["\xF3\xB0\xA0\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBC"],
        ["\xF3\xB0\xA0\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBC"],

        ["\xF3\xB0\xA0\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBD"],
        ["\xF3\xB0\xA0\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBD"],

        ["\xF3\xB0\xA0\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBE"],
        ["\xF3\xB0\xA0\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBE"],

        ["\xF3\xB0\xA0\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBF"],
        ["\xF3\xB0\xA0\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBF"],

        ["\xF3\xB0\xA1\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x80"],
        ["\xF3\xB0\xA1\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x80"],

        ["\xF3\xB0\xA1\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x81"],
        ["\xF3\xB0\xA1\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x81"],

        ["\xF3\xB0\xA1\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x82"],
        ["\xF3\xB0\xA1\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x82"],

        ["\xF3\xB0\xA1\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x83"],
        ["\xF3\xB0\xA1\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x83"],

        ["\xF3\xB0\xA1\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x84"],
        ["\xF3\xB0\xA1\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x84"],

        ["\xF3\xB0\xA1\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x85"],
        ["\xF3\xB0\xA1\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x85"],

        ["\xF3\xB0\xA1\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x86"],
        ["\xF3\xB0\xA1\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x86"],

        ["\xF3\xB0\xA1\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x87"],
        ["\xF3\xB0\xA1\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x87"],

        ["\xF3\xB0\xA1\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x88"],
        ["\xF3\xB0\xA1\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x88"],

        ["\xF3\xB0\xA1\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x89"],
        ["\xF3\xB0\xA1\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x89"],

        ["\xF3\xB0\xA1\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8A"],
        ["\xF3\xB0\xA1\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8A"],

        ["\xF3\xB0\xA1\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8B"],
        ["\xF3\xB0\xA1\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8B"],

        ["\xF3\xB0\xA1\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8C"],
        ["\xF3\xB0\xA1\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8C"],

        ["\xF3\xB0\xA1\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8D"],
        ["\xF3\xB0\xA1\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8D"],

        ["\xF3\xB0\xA1\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8E"],
        ["\xF3\xB0\xA1\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8E"],

        ["\xF3\xB0\xA1\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8F"],
        ["\xF3\xB0\xA1\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8F"],

        ["\xF3\xB0\xA1\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x90"],
        ["\xF3\xB0\xA1\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x90"],

        ["\xF3\xB0\xA1\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x91"],
        ["\xF3\xB0\xA1\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x91"],

        ["\xF3\xB0\xA1\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x92"],
        ["\xF3\xB0\xA1\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x92"],

        ["\xF3\xB0\xA1\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x93"],
        ["\xF3\xB0\xA1\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x93"],

        ["\xF3\xB0\xA1\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x94"],
        ["\xF3\xB0\xA1\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x94"],

        ["\xF3\xB0\xA1\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x95"],
        ["\xF3\xB0\xA1\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x95"],

        ["\xF3\xB0\xA1\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x96"],
        ["\xF3\xB0\xA1\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x96"],

        ["\xF3\xB0\xA1\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x97"],
        ["\xF3\xB0\xA1\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x97"],

        ["\xF3\xB0\xA1\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x98"],
        ["\xF3\xB0\xA1\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x98"],

        ["\xF3\xB0\xA1\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x99"],
        ["\xF3\xB0\xA1\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x99"],

        ["\xF3\xB0\xA1\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9A"],
        ["\xF3\xB0\xA1\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9A"],

        ["\xF3\xB0\xA1\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9B"],
        ["\xF3\xB0\xA1\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9B"],

        ["\xF3\xB0\xA1\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9C"],
        ["\xF3\xB0\xA1\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9C"],

        ["\xF3\xB0\xA1\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9D"],
        ["\xF3\xB0\xA1\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9D"],

        ["\xF3\xB0\xA1\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9E"],
        ["\xF3\xB0\xA1\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9E"],

        ["\xF3\xB0\xA1\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9F"],
        ["\xF3\xB0\xA1\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9F"],

        ["\xF3\xB0\xA1\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA0"],
        ["\xF3\xB0\xA1\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA0"],

        ["\xF3\xB0\xA1\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA1"],
        ["\xF3\xB0\xA1\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA1"],

        ["\xF3\xB0\xA1\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA2"],
        ["\xF3\xB0\xA1\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA2"],

        ["\xF3\xB0\xA1\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA3"],
        ["\xF3\xB0\xA1\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA3"],

        ["\xF3\xB0\xA1\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA4"],
        ["\xF3\xB0\xA1\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA4"],

        ["\xF3\xB0\xA1\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA5"],
        ["\xF3\xB0\xA1\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA5"],

        ["\xF3\xB0\xA1\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA6"],
        ["\xF3\xB0\xA1\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA6"],

        ["\xF3\xB0\xA1\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA7"],
        ["\xF3\xB0\xA1\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA7"],

        ["\xF3\xB0\xA1\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA8"],
        ["\xF3\xB0\xA1\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA8"],

        ["\xF3\xB0\xA1\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA9"],
        ["\xF3\xB0\xA1\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA9"],

        ["\xF3\xB0\xA1\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAA"],
        ["\xF3\xB0\xA1\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAA"],

        ["\xF3\xB0\xA1\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAB"],
        ["\xF3\xB0\xA1\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAB"],

        ["\xF3\xB0\xA1\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAC"],
        ["\xF3\xB0\xA1\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAC"],

        ["\xF3\xB0\xA1\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAD"],
        ["\xF3\xB0\xA1\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAD"],

        ["\xF3\xB0\xA1\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAE"],
        ["\xF3\xB0\xA1\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAE"],

        ["\xF3\xB0\xA1\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAF"],
        ["\xF3\xB0\xA1\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAF"],

        ["\xF3\xB0\xA1\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB0"],
        ["\xF3\xB0\xA1\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB0"],

        ["\xF3\xB0\xA1\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB1"],
        ["\xF3\xB0\xA1\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB1"],

        ["\xF3\xB0\xA1\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB2"],
        ["\xF3\xB0\xA1\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB2"],

        ["\xF3\xB0\xA1\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB3"],
        ["\xF3\xB0\xA1\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB3"],

        ["\xF3\xB0\xA1\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB4"],
        ["\xF3\xB0\xA1\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB4"],

        ["\xF3\xB0\xA1\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB5"],
        ["\xF3\xB0\xA1\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB5"],

        ["\xF3\xB0\xA1\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB6"],
        ["\xF3\xB0\xA1\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB6"],

        ["\xF3\xB0\xA1\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB7"],
        ["\xF3\xB0\xA1\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB7"],

        ["\xF3\xB0\xA1\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB8"],
        ["\xF3\xB0\xA1\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB8"],

        ["\xF3\xB0\xA1\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB9"],
        ["\xF3\xB0\xA1\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB9"],

        ["\xF3\xB0\xA1\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBA"],
        ["\xF3\xB0\xA1\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBA"],

        ["\xF3\xB0\xA1\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBB"],
        ["\xF3\xB0\xA1\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBB"],

        ["\xF3\xB0\xA1\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBC"],
        ["\xF3\xB0\xA1\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBC"],

        ["\xF3\xB0\xA1\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBD"],
        ["\xF3\xB0\xA1\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBD"],

        ["\xF3\xB0\xA1\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBE"],
        ["\xF3\xB0\xA1\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBE"],

        ["\xF3\xB0\xA1\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBF"],
        ["\xF3\xB0\xA1\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBF"],

        ["\xF3\xB0\xA2\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x80"],
        ["\xF3\xB0\xA2\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x80"],

        ["\xF3\xB0\xA2\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x81"],
        ["\xF3\xB0\xA2\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x81"],

        ["\xF3\xB0\xA2\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x82"],
        ["\xF3\xB0\xA2\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x82"],

        ["\xF3\xB0\xA2\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x83"],
        ["\xF3\xB0\xA2\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x83"],

        ["\xF3\xB0\xA2\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x84"],
        ["\xF3\xB0\xA2\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x84"],

        ["\xF3\xB0\xA2\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x85"],
        ["\xF3\xB0\xA2\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x85"],

        ["\xF3\xB0\xA2\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x86"],
        ["\xF3\xB0\xA2\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x86"],

        ["\xF3\xB0\xA2\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x87"],
        ["\xF3\xB0\xA2\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x87"],

        ["\xF3\xB0\xA2\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x88"],
        ["\xF3\xB0\xA2\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x88"],

        ["\xF3\xB0\xA2\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x89"],
        ["\xF3\xB0\xA2\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x89"],

        ["\xF3\xB0\xA2\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8A"],
        ["\xF3\xB0\xA2\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8A"],

        ["\xF3\xB0\xA2\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8B"],
        ["\xF3\xB0\xA2\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8B"],

        ["\xF3\xB0\xA2\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8C"],
        ["\xF3\xB0\xA2\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8C"],

        ["\xF3\xB0\xA2\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8D"],
        ["\xF3\xB0\xA2\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8D"],

        ["\xF3\xB0\xA2\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8E"],
        ["\xF3\xB0\xA2\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8E"],

        ["\xF3\xB0\xA2\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8F"],
        ["\xF3\xB0\xA2\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8F"],

        ["\xF3\xB0\xA2\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x90"],
        ["\xF3\xB0\xA2\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x90"],

        ["\xF3\xB0\xA2\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x91"],
        ["\xF3\xB0\xA2\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x91"],

        ["\xF3\xB0\xA2\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x92"],
        ["\xF3\xB0\xA2\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x92"],

        ["\xF3\xB0\xA2\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x93"],
        ["\xF3\xB0\xA2\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x93"],

        ["\xF3\xB0\xA2\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x94"],
        ["\xF3\xB0\xA2\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x94"],

        ["\xF3\xB0\xA2\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x95"],
        ["\xF3\xB0\xA2\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x95"],

        ["\xF3\xB0\xA2\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x96"],
        ["\xF3\xB0\xA2\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x96"],

        ["\xF3\xB0\xA2\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x97"],
        ["\xF3\xB0\xA2\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x97"],

        ["\xF3\xB0\xA2\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x98"],
        ["\xF3\xB0\xA2\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x98"],

        ["\xF3\xB0\xA2\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x99"],
        ["\xF3\xB0\xA2\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x99"],

        ["\xF3\xB0\xA2\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9A"],
        ["\xF3\xB0\xA2\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9A"],

        ["\xF3\xB0\xA2\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9B"],
        ["\xF3\xB0\xA2\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9B"],

        ["\xF3\xB0\xA2\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9C"],
        ["\xF3\xB0\xA2\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9C"],

        ["\xF3\xB0\xA2\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9D"],
        ["\xF3\xB0\xA2\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9D"],

        ["\xF3\xB0\xA2\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9E"],
        ["\xF3\xB0\xA2\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9E"],

        ["\xF3\xB0\xA2\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9F"],
        ["\xF3\xB0\xA2\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9F"],

        ["\xF3\xB0\xA2\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA0"],
        ["\xF3\xB0\xA2\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA0"],

        ["\xF3\xB0\xA2\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA1"],
        ["\xF3\xB0\xA2\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA1"],

        ["\xF3\xB0\xA2\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA2"],
        ["\xF3\xB0\xA2\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA2"],

        ["\xF3\xB0\xA2\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA3"],
        ["\xF3\xB0\xA2\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA3"],

        ["\xF3\xB0\xA2\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA4"],
        ["\xF3\xB0\xA2\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA4"],

        ["\xF3\xB0\xA2\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA5"],
        ["\xF3\xB0\xA2\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA5"],

        ["\xF3\xB0\xA2\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA6"],
        ["\xF3\xB0\xA2\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA6"],

        ["\xF3\xB0\xA2\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA7"],
        ["\xF3\xB0\xA2\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA7"],

        ["\xF3\xB0\xA2\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA8"],
        ["\xF3\xB0\xA2\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA8"],

        ["\xF3\xB0\xA2\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA9"],
        ["\xF3\xB0\xA2\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA9"],

        ["\xF3\xB0\xA2\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAA"],
        ["\xF3\xB0\xA2\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAA"],

        ["\xF3\xB0\xA2\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAB"],
        ["\xF3\xB0\xA2\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAB"],

        ["\xF3\xB0\xA2\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAC"],
        ["\xF3\xB0\xA2\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAC"],

        ["\xF3\xB0\xA2\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAD"],
        ["\xF3\xB0\xA2\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAD"],

        ["\xF3\xB0\xA2\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAE"],
        ["\xF3\xB0\xA2\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAE"],

        ["\xF3\xB0\xA2\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAF"],
        ["\xF3\xB0\xA2\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAF"],

        ["\xF3\xB0\xA2\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB0"],
        ["\xF3\xB0\xA2\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB0"],

        ["\xF3\xB0\xA2\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB1"],
        ["\xF3\xB0\xA2\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB1"],

        ["\xF3\xB0\xA2\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB2"],
        ["\xF3\xB0\xA2\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB2"],

        ["\xF3\xB0\xA2\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB3"],
        ["\xF3\xB0\xA2\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB3"],

        ["\xF3\xB0\xA2\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB4"],
        ["\xF3\xB0\xA2\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB4"],

        ["\xF3\xB0\xA2\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB5"],
        ["\xF3\xB0\xA2\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB5"],

        ["\xF3\xB0\xA2\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB6"],
        ["\xF3\xB0\xA2\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB6"],

        ["\xF3\xB0\xA2\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB7"],
        ["\xF3\xB0\xA2\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB7"],

        ["\xF3\xB0\xA2\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB8"],
        ["\xF3\xB0\xA2\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB8"],

        ["\xF3\xB0\xA2\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB9"],
        ["\xF3\xB0\xA2\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB9"],

        ["\xF3\xB0\xA2\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBA"],
        ["\xF3\xB0\xA2\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBA"],

        ["\xF3\xB0\xA2\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBB"],
        ["\xF3\xB0\xA2\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBB"],

        ["\xF3\xB0\xA2\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBC"],
        ["\xF3\xB0\xA2\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBC"],

        ["\xF3\xB0\xA2\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBD"],
        ["\xF3\xB0\xA2\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBD"],

        ["\xF3\xB0\xA2\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBE"],
        ["\xF3\xB0\xA2\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBE"],

        ["\xF3\xB0\xA2\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBF"],
        ["\xF3\xB0\xA2\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBF"],

        ["\xF3\xB0\xA3\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x80"],
        ["\xF3\xB0\xA3\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x80"],

        ["\xF3\xB0\xA3\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x81"],
        ["\xF3\xB0\xA3\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x81"],

        ["\xF3\xB0\xA3\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x82"],
        ["\xF3\xB0\xA3\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x82"],

        ["\xF3\xB0\xA3\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x83"],
        ["\xF3\xB0\xA3\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x83"],

        ["\xF3\xB0\xA3\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x84"],
        ["\xF3\xB0\xA3\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x84"],

        ["\xF3\xB0\xA3\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x85"],
        ["\xF3\xB0\xA3\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x85"],

        ["\xF3\xB0\xA3\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x86"],
        ["\xF3\xB0\xA3\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x86"],

        ["\xF3\xB0\xA3\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x87"],
        ["\xF3\xB0\xA3\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x87"],

        ["\xF3\xB0\xA3\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x88"],
        ["\xF3\xB0\xA3\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x88"],

        ["\xF3\xB0\xA3\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x89"],
        ["\xF3\xB0\xA3\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x89"],

        ["\xF3\xB0\xA3\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8A"],
        ["\xF3\xB0\xA3\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8A"],

        ["\xF3\xB0\xA3\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8B"],
        ["\xF3\xB0\xA3\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8B"],

        ["\xF3\xB0\xA3\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8C"],
        ["\xF3\xB0\xA3\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8C"],

        ["\xF3\xB0\xA3\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8D"],
        ["\xF3\xB0\xA3\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8D"],

        ["\xF3\xB0\xA3\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8E"],
        ["\xF3\xB0\xA3\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8E"],

        ["\xF3\xB0\xA3\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8F"],
        ["\xF3\xB0\xA3\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8F"],

        ["\xF3\xB0\xA3\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x90"],
        ["\xF3\xB0\xA3\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x90"],

        ["\xF3\xB0\xA3\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x91"],
        ["\xF3\xB0\xA3\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x91"],

        ["\xF3\xB0\xA3\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x92"],
        ["\xF3\xB0\xA3\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x92"],

        ["\xF3\xB0\xA3\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x93"],
        ["\xF3\xB0\xA3\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x93"],

        ["\xF3\xB0\xA3\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x94"],
        ["\xF3\xB0\xA3\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x94"],

        ["\xF3\xB0\xA3\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x95"],
        ["\xF3\xB0\xA3\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x95"],

        ["\xF3\xB0\xA3\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x96"],
        ["\xF3\xB0\xA3\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x96"],

        ["\xF3\xB0\xA3\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x97"],
        ["\xF3\xB0\xA3\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x97"],

        ["\xF3\xB0\xA3\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x98"],
        ["\xF3\xB0\xA3\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x98"],

        ["\xF3\xB0\xA3\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x99"],
        ["\xF3\xB0\xA3\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x99"],

        ["\xF3\xB0\xA3\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9A"],
        ["\xF3\xB0\xA3\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9A"],

        ["\xF3\xB0\xA3\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9B"],
        ["\xF3\xB0\xA3\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9B"],

        ["\xF3\xB0\xA3\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9C"],
        ["\xF3\xB0\xA3\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9C"],

        ["\xF3\xB0\xA3\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9D"],
        ["\xF3\xB0\xA3\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9D"],

        ["\xF3\xB0\xA3\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9E"],
        ["\xF3\xB0\xA3\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9E"],

        ["\xF3\xB0\xA3\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9F"],
        ["\xF3\xB0\xA3\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9F"],

        ["\xF3\xB0\xA3\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA0"],
        ["\xF3\xB0\xA3\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA0"],

        ["\xF3\xB0\xA3\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA1"],
        ["\xF3\xB0\xA3\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA1"],

        ["\xF3\xB0\xA3\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA2"],
        ["\xF3\xB0\xA3\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA2"],

        ["\xF3\xB0\xA3\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA3"],
        ["\xF3\xB0\xA3\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA3"],

        ["\xF3\xB0\xA3\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA4"],
        ["\xF3\xB0\xA3\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA4"],

        ["\xF3\xB0\xA3\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA5"],
        ["\xF3\xB0\xA3\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA5"],

        ["\xF3\xB0\xA3\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA6"],
        ["\xF3\xB0\xA3\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA6"],

        ["\xF3\xB0\xA3\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA7"],
        ["\xF3\xB0\xA3\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA7"],

        ["\xF3\xB0\xA3\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA8"],
        ["\xF3\xB0\xA3\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA8"],

        ["\xF3\xB0\xA3\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA9"],
        ["\xF3\xB0\xA3\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA9"],

        ["\xF3\xB0\xA3\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAA"],
        ["\xF3\xB0\xA3\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAA"],

        ["\xF3\xB0\xA3\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAB"],
        ["\xF3\xB0\xA3\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAB"],

        ["\xF3\xB0\xA3\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAC"],
        ["\xF3\xB0\xA3\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAC"],

        ["\xF3\xB0\xA3\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAD"],
        ["\xF3\xB0\xA3\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAD"],

        ["\xF3\xB0\xA3\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAE"],
        ["\xF3\xB0\xA3\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAE"],

        ["\xF3\xB0\xA3\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAF"],
        ["\xF3\xB0\xA3\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAF"],

        ["\xF3\xB0\xA3\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB0"],
        ["\xF3\xB0\xA3\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB0"],

        ["\xF3\xB0\xA3\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB1"],
        ["\xF3\xB0\xA3\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB1"],

        ["\xF3\xB0\xA3\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB2"],
        ["\xF3\xB0\xA3\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB2"],

        ["\xF3\xB0\xA3\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB3"],
        ["\xF3\xB0\xA3\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB3"],

        ["\xF3\xB0\xA3\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB4"],
        ["\xF3\xB0\xA3\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB4"],

        ["\xF3\xB0\xA3\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB5"],
        ["\xF3\xB0\xA3\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB5"],

        ["\xF3\xB0\xA3\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB6"],
        ["\xF3\xB0\xA3\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB6"],

        ["\xF3\xB0\xA3\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB7"],
        ["\xF3\xB0\xA3\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB7"],

        ["\xF3\xB0\xA3\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB8"],
        ["\xF3\xB0\xA3\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB8"],

        ["\xF3\xB0\xA3\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB9"],
        ["\xF3\xB0\xA3\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB9"],

        ["\xF3\xB0\xA3\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBA"],
        ["\xF3\xB0\xA3\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBA"],

        ["\xF3\xB0\xA3\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBB"],
        ["\xF3\xB0\xA3\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBB"],

        ["\xF3\xB0\xA3\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBC"],
        ["\xF3\xB0\xA3\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBC"],

        ["\xF3\xB0\xA3\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBD"],
        ["\xF3\xB0\xA3\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBD"],

        ["\xF3\xB0\xA3\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBE"],
        ["\xF3\xB0\xA3\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBE"],

        ["\xF3\xB0\xA3\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBF"],
        ["\xF3\xB0\xA3\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBF"],

        ["\xF3\xB0\xA4\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x80"],
        ["\xF3\xB0\xA4\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x80"],

        ["\xF3\xB0\xA4\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x81"],
        ["\xF3\xB0\xA4\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x81"],

        ["\xF3\xB0\xA4\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x82"],
        ["\xF3\xB0\xA4\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x82"],

        ["\xF3\xB0\xA4\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x83"],
        ["\xF3\xB0\xA4\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x83"],

        ["\xF3\xB0\xA4\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x84"],
        ["\xF3\xB0\xA4\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x84"],

        ["\xF3\xB0\xA4\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x85"],
        ["\xF3\xB0\xA4\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x85"],

        ["\xF3\xB0\xA4\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x86"],
        ["\xF3\xB0\xA4\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x86"],

        ["\xF3\xB0\xA4\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x87"],
        ["\xF3\xB0\xA4\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x87"],

        ["\xF3\xB0\xA4\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x88"],
        ["\xF3\xB0\xA4\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x88"],

        ["\xF3\xB0\xA4\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x89"],
        ["\xF3\xB0\xA4\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x89"],

        ["\xF3\xB0\xA4\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8A"],
        ["\xF3\xB0\xA4\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8A"],

        ["\xF3\xB0\xA4\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8B"],
        ["\xF3\xB0\xA4\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8B"],

        ["\xF3\xB0\xA4\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8C"],
        ["\xF3\xB0\xA4\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8C"],

        ["\xF3\xB0\xA4\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8D"],
        ["\xF3\xB0\xA4\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8D"],

        ["\xF3\xB0\xA4\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8E"],
        ["\xF3\xB0\xA4\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8E"],

        ["\xF3\xB0\xA4\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8F"],
        ["\xF3\xB0\xA4\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8F"],

        ["\xF3\xB0\xA4\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x90"],
        ["\xF3\xB0\xA4\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x90"],

        ["\xF3\xB0\xA4\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x91"],
        ["\xF3\xB0\xA4\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x91"],

        ["\xF3\xB0\xA4\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x92"],
        ["\xF3\xB0\xA4\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x92"],

        ["\xF3\xB0\xA4\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x93"],
        ["\xF3\xB0\xA4\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x93"],

        ["\xF3\xB0\xA4\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x94"],
        ["\xF3\xB0\xA4\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x94"],

        ["\xF3\xB0\xA4\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x95"],
        ["\xF3\xB0\xA4\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x95"],

        ["\xF3\xB0\xA4\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x96"],
        ["\xF3\xB0\xA4\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x96"],

        ["\xF3\xB0\xA4\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x97"],
        ["\xF3\xB0\xA4\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x97"],

        ["\xF3\xB0\xA4\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x98"],
        ["\xF3\xB0\xA4\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x98"],

        ["\xF3\xB0\xA4\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x99"],
        ["\xF3\xB0\xA4\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x99"],

        ["\xF3\xB0\xA4\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9A"],
        ["\xF3\xB0\xA4\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9A"],

        ["\xF3\xB0\xA4\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9B"],
        ["\xF3\xB0\xA4\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9B"],

        ["\xF3\xB0\xA4\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9C"],
        ["\xF3\xB0\xA4\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9C"],

        ["\xF3\xB0\xA4\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9D"],
        ["\xF3\xB0\xA4\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9D"],

        ["\xF3\xB0\xA4\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9E"],
        ["\xF3\xB0\xA4\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9E"],

        ["\xF3\xB0\xA4\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9F"],
        ["\xF3\xB0\xA4\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9F"],

        ["\xF3\xB0\xA4\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA0"],
        ["\xF3\xB0\xA4\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA0"],

        ["\xF3\xB0\xA4\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA1"],
        ["\xF3\xB0\xA4\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA1"],

        ["\xF3\xB0\xA4\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA2"],
        ["\xF3\xB0\xA4\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA2"],

        ["\xF3\xB0\xA4\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA3"],
        ["\xF3\xB0\xA4\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA3"],

        ["\xF3\xB0\xA4\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA4"],
        ["\xF3\xB0\xA4\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA4"],

        ["\xF3\xB0\xA4\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA5"],
        ["\xF3\xB0\xA4\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA5"],

        ["\xF3\xB0\xA4\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA6"],
        ["\xF3\xB0\xA4\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA6"],

        ["\xF3\xB0\xA4\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA7"],
        ["\xF3\xB0\xA4\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA7"],

        ["\xF3\xB0\xA4\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA8"],
        ["\xF3\xB0\xA4\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA8"],

        ["\xF3\xB0\xA4\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA9"],
        ["\xF3\xB0\xA4\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA9"],

        ["\xF3\xB0\xA4\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAA"],
        ["\xF3\xB0\xA4\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAA"],

        ["\xF3\xB0\xA4\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAB"],
        ["\xF3\xB0\xA4\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAB"],

        ["\xF3\xB0\xA4\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAC"],
        ["\xF3\xB0\xA4\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAC"],

        ["\xF3\xB0\xA4\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAD"],
        ["\xF3\xB0\xA4\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAD"],

        ["\xF3\xB0\xA4\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAE"],
        ["\xF3\xB0\xA4\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAE"],

        ["\xF3\xB0\xA4\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAF"],
        ["\xF3\xB0\xA4\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAF"],

        ["\xF3\xB0\xA4\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB0"],
        ["\xF3\xB0\xA4\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB0"],

        ["\xF3\xB0\xA4\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB1"],
        ["\xF3\xB0\xA4\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB1"],

        ["\xF3\xB0\xA4\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB2"],
        ["\xF3\xB0\xA4\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB2"],

        ["\xF3\xB0\xA4\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB3"],
        ["\xF3\xB0\xA4\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB3"],

        ["\xF3\xB0\xA4\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB4"],
        ["\xF3\xB0\xA4\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB4"],

        ["\xF3\xB0\xA4\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB5"],
        ["\xF3\xB0\xA4\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB5"],

        ["\xF3\xB0\xA4\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB6"],
        ["\xF3\xB0\xA4\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB6"],

        ["\xF3\xB0\xA4\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB7"],
        ["\xF3\xB0\xA4\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB7"],

        ["\xF3\xB0\xA4\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB8"],
        ["\xF3\xB0\xA4\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB8"],

        ["\xF3\xB0\xA4\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB9"],
        ["\xF3\xB0\xA4\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB9"],

        ["\xF3\xB0\xA4\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBA"],
        ["\xF3\xB0\xA4\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBA"],

        ["\xF3\xB0\xA4\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBB"],
        ["\xF3\xB0\xA4\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBB"],

        ["\xF3\xB0\xA4\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBC"],
        ["\xF3\xB0\xA4\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBC"],

        ["\xF3\xB0\xA4\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBD"],
        ["\xF3\xB0\xA4\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBD"],

        ["\xF3\xB0\xA4\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBE"],
        ["\xF3\xB0\xA4\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBE"],

        ["\xF3\xB0\xA4\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBF"],
        ["\xF3\xB0\xA4\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBF"],

        ["\xF3\xB0\xA5\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x80"],
        ["\xF3\xB0\xA5\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x80"],

        ["\xF3\xB0\xA5\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x81"],
        ["\xF3\xB0\xA5\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x81"],

        ["\xF3\xB0\xA5\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x82"],
        ["\xF3\xB0\xA5\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x82"],

        ["\xF3\xB0\xA5\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x83"],
        ["\xF3\xB0\xA5\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x83"],

        ["\xF3\xB0\xA5\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x84"],
        ["\xF3\xB0\xA5\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x84"],

        ["\xF3\xB0\xA5\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x85"],
        ["\xF3\xB0\xA5\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x85"],

        ["\xF3\xB0\xA5\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x86"],
        ["\xF3\xB0\xA5\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x86"],

        ["\xF3\xB0\xA5\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x87"],
        ["\xF3\xB0\xA5\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x87"],

        ["\xF3\xB0\xA5\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x88"],
        ["\xF3\xB0\xA5\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x88"],

        ["\xF3\xB0\xA5\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x89"],
        ["\xF3\xB0\xA5\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x89"],

        ["\xF3\xB0\xA5\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8A"],
        ["\xF3\xB0\xA5\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8A"],

        ["\xF3\xB0\xA5\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8B"],
        ["\xF3\xB0\xA5\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8B"],

        ["\xF3\xB0\xA5\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8C"],
        ["\xF3\xB0\xA5\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8C"],

        ["\xF3\xB0\xA5\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8D"],
        ["\xF3\xB0\xA5\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8D"],

        ["\xF3\xB0\xA5\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8E"],
        ["\xF3\xB0\xA5\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8E"],

        ["\xF3\xB0\xA5\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8F"],
        ["\xF3\xB0\xA5\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8F"],

        ["\xF3\xB0\xA5\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x90"],
        ["\xF3\xB0\xA5\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x90"],

        ["\xF3\xB0\xA5\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x91"],
        ["\xF3\xB0\xA5\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x91"],

        ["\xF3\xB0\xA5\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x92"],
        ["\xF3\xB0\xA5\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x92"],

        ["\xF3\xB0\xA5\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x93"],
        ["\xF3\xB0\xA5\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x93"],

        ["\xF3\xB0\xA5\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x94"],
        ["\xF3\xB0\xA5\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x94"],

        ["\xF3\xB0\xA5\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x95"],
        ["\xF3\xB0\xA5\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x95"],

        ["\xF3\xB0\xA5\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x96"],
        ["\xF3\xB0\xA5\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x96"],

        ["\xF3\xB0\xA5\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x97"],
        ["\xF3\xB0\xA5\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x97"],

        ["\xF3\xB0\xA5\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x98"],
        ["\xF3\xB0\xA5\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x98"],

        ["\xF3\xB0\xA5\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x99"],
        ["\xF3\xB0\xA5\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x99"],

        ["\xF3\xB0\xA5\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9A"],
        ["\xF3\xB0\xA5\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9A"],

        ["\xF3\xB0\xA5\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9B"],
        ["\xF3\xB0\xA5\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9B"],

        ["\xF3\xB0\xA5\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9C"],
        ["\xF3\xB0\xA5\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9C"],

        ["\xF3\xB0\xA5\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9D"],
        ["\xF3\xB0\xA5\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9D"],

        ["\xF3\xB0\xA5\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9E"],
        ["\xF3\xB0\xA5\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9E"],

        ["\xF3\xB0\xA5\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9F"],
        ["\xF3\xB0\xA5\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9F"],

        ["\xF3\xB0\xA5\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA0"],
        ["\xF3\xB0\xA5\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA0"],

        ["\xF3\xB0\xA5\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA1"],
        ["\xF3\xB0\xA5\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA1"],

        ["\xF3\xB0\xA5\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA2"],
        ["\xF3\xB0\xA5\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA2"],

        ["\xF3\xB0\xA5\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA3"],
        ["\xF3\xB0\xA5\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA3"],

        ["\xF3\xB0\xA5\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA4"],
        ["\xF3\xB0\xA5\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA4"],

        ["\xF3\xB0\xA5\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA5"],
        ["\xF3\xB0\xA5\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA5"],

        ["\xF3\xB0\xA5\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA6"],
        ["\xF3\xB0\xA5\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA6"],

        ["\xF3\xB0\xA5\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA7"],
        ["\xF3\xB0\xA5\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA7"],

        ["\xF3\xB0\xA5\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA8"],
        ["\xF3\xB0\xA5\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA8"],

        ["\xF3\xB0\xA5\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA9"],
        ["\xF3\xB0\xA5\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA9"],

        ["\xF3\xB0\xA5\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAA"],
        ["\xF3\xB0\xA5\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAA"],

        ["\xF3\xB0\xA5\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAB"],
        ["\xF3\xB0\xA5\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAB"],

        ["\xF3\xB0\xA5\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAC"],
        ["\xF3\xB0\xA5\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAC"],

        ["\xF3\xB0\xA5\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAD"],
        ["\xF3\xB0\xA5\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAD"],

        ["\xF3\xB0\xA5\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAE"],
        ["\xF3\xB0\xA5\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAE"],

        ["\xF3\xB0\xA5\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAF"],
        ["\xF3\xB0\xA5\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAF"],

        ["\xF3\xB0\xA5\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB0"],
        ["\xF3\xB0\xA5\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB0"],

        ["\xF3\xB0\xA5\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB1"],
        ["\xF3\xB0\xA5\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB1"],

        ["\xF3\xB0\xA5\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB2"],
        ["\xF3\xB0\xA5\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB2"],

        ["\xF3\xB0\xA5\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB3"],
        ["\xF3\xB0\xA5\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB3"],

        ["\xF3\xB0\xA5\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB4"],
        ["\xF3\xB0\xA5\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB4"],

        ["\xF3\xB0\xA5\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB5"],
        ["\xF3\xB0\xA5\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB5"],

        ["\xF3\xB0\xA5\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB6"],
        ["\xF3\xB0\xA5\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB6"],

        ["\xF3\xB0\xA5\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB7"],
        ["\xF3\xB0\xA5\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB7"],

        ["\xF3\xB0\xA5\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB8"],
        ["\xF3\xB0\xA5\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB8"],

        ["\xF3\xB0\xA5\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB9"],
        ["\xF3\xB0\xA5\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB9"],

        ["\xF3\xB0\xA5\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBA"],
        ["\xF3\xB0\xA5\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBA"],

        ["\xF3\xB0\xA5\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBB"],
        ["\xF3\xB0\xA5\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBB"],

        ["\xF3\xB0\xA5\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBC"],
        ["\xF3\xB0\xA5\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBC"],

        ["\xF3\xB0\xA5\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBD"],
        ["\xF3\xB0\xA5\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBD"],

        ["\xF3\xB0\xA5\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBE"],
        ["\xF3\xB0\xA5\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBE"],

        ["\xF3\xB0\xA5\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBF"],
        ["\xF3\xB0\xA5\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBF"],

        ["\xF3\xB0\xA6\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x80"],
        ["\xF3\xB0\xA6\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x80"],

        ["\xF3\xB0\xA6\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x81"],
        ["\xF3\xB0\xA6\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x81"],

        ["\xF3\xB0\xA6\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x82"],
        ["\xF3\xB0\xA6\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x82"],

        ["\xF3\xB0\xA6\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x83"],
        ["\xF3\xB0\xA6\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x83"],

        ["\xF3\xB0\xA6\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x84"],
        ["\xF3\xB0\xA6\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x84"],

        ["\xF3\xB0\xA6\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x85"],
        ["\xF3\xB0\xA6\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x85"],

        ["\xF3\xB0\xA6\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x86"],
        ["\xF3\xB0\xA6\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x86"],

        ["\xF3\xB0\xA6\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x87"],
        ["\xF3\xB0\xA6\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x87"],

        ["\xF3\xB0\xA6\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x88"],
        ["\xF3\xB0\xA6\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x88"],

        ["\xF3\xB0\xA6\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x89"],
        ["\xF3\xB0\xA6\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x89"],

        ["\xF3\xB0\xA6\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8A"],
        ["\xF3\xB0\xA6\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8A"],

        ["\xF3\xB0\xA6\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8B"],
        ["\xF3\xB0\xA6\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8B"],

        ["\xF3\xB0\xA6\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8C"],
        ["\xF3\xB0\xA6\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8C"],

        ["\xF3\xB0\xA6\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8D"],
        ["\xF3\xB0\xA6\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8D"],

        ["\xF3\xB0\xA6\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8E"],
        ["\xF3\xB0\xA6\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8E"],

        ["\xF3\xB0\xA6\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8F"],
        ["\xF3\xB0\xA6\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8F"],

        ["\xF3\xB0\xA6\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x90"],
        ["\xF3\xB0\xA6\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x90"],

        ["\xF3\xB0\xA6\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x91"],
        ["\xF3\xB0\xA6\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x91"],

        ["\xF3\xB0\xA6\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x92"],
        ["\xF3\xB0\xA6\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x92"],

        ["\xF3\xB0\xA6\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x93"],
        ["\xF3\xB0\xA6\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x93"],

        ["\xF3\xB0\xA6\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x94"],
        ["\xF3\xB0\xA6\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x94"],

        ["\xF3\xB0\xA6\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x95"],
        ["\xF3\xB0\xA6\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x95"],

        ["\xF3\xB0\xA6\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x96"],
        ["\xF3\xB0\xA6\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x96"],

        ["\xF3\xB0\xA6\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x97"],
        ["\xF3\xB0\xA6\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x97"],

        ["\xF3\xB0\xA6\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x98"],
        ["\xF3\xB0\xA6\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x98"],

        ["\xF3\xB0\xA6\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x99"],
        ["\xF3\xB0\xA6\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x99"],

        ["\xF3\xB0\xA6\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9A"],
        ["\xF3\xB0\xA6\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9A"],

        ["\xF3\xB0\xA6\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9B"],
        ["\xF3\xB0\xA6\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9B"],

        ["\xF3\xB0\xA6\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9C"],
        ["\xF3\xB0\xA6\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9C"],

        ["\xF3\xB0\xA6\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9D"],
        ["\xF3\xB0\xA6\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9D"],

        ["\xF3\xB0\xA6\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9E"],
        ["\xF3\xB0\xA6\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9E"],

        ["\xF3\xB0\xA6\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9F"],
        ["\xF3\xB0\xA6\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9F"],

        ["\xF3\xB0\xA6\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA0"],
        ["\xF3\xB0\xA6\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA0"],

        ["\xF3\xB0\xA6\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA1"],
        ["\xF3\xB0\xA6\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA1"],

        ["\xF3\xB0\xA6\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA2"],
        ["\xF3\xB0\xA6\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA2"],

        ["\xF3\xB0\xA6\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA3"],
        ["\xF3\xB0\xA6\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA3"],

        ["\xF3\xB0\xA6\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA4"],
        ["\xF3\xB0\xA6\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA4"],

        ["\xF3\xB0\xA6\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA5"],
        ["\xF3\xB0\xA6\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA5"],

        ["\xF3\xB0\xA6\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA6"],
        ["\xF3\xB0\xA6\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA6"],

        ["\xF3\xB0\xA6\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA7"],
        ["\xF3\xB0\xA6\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA7"],

        ["\xF3\xB0\xA6\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA8"],
        ["\xF3\xB0\xA6\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA8"],

        ["\xF3\xB0\xA6\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA9"],
        ["\xF3\xB0\xA6\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA9"],

        ["\xF3\xB0\xA6\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAA"],
        ["\xF3\xB0\xA6\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAA"],

        ["\xF3\xB0\xA6\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAB"],
        ["\xF3\xB0\xA6\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAB"],

        ["\xF3\xB0\xA6\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAC"],
        ["\xF3\xB0\xA6\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAC"],

        ["\xF3\xB0\xA6\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAD"],
        ["\xF3\xB0\xA6\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAD"],

        ["\xF3\xB0\xA6\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAE"],
        ["\xF3\xB0\xA6\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAE"],

        ["\xF3\xB0\xA6\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAF"],
        ["\xF3\xB0\xA6\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAF"],

        ["\xF3\xB0\xA6\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB0"],
        ["\xF3\xB0\xA6\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB0"],

        ["\xF3\xB0\xA6\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB1"],
        ["\xF3\xB0\xA6\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB1"],

        ["\xF3\xB0\xA6\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB2"],
        ["\xF3\xB0\xA6\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB2"],

        ["\xF3\xB0\xA6\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB3"],
        ["\xF3\xB0\xA6\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB3"],

        ["\xF3\xB0\xA6\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB4"],
        ["\xF3\xB0\xA6\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB4"],

        ["\xF3\xB0\xA6\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB5"],
        ["\xF3\xB0\xA6\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB5"],

        ["\xF3\xB0\xA6\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB6"],
        ["\xF3\xB0\xA6\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB6"],

        ["\xF3\xB0\xA6\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB7"],
        ["\xF3\xB0\xA6\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB7"],

        ["\xF3\xB0\xA6\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB8"],
        ["\xF3\xB0\xA6\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB8"],

        ["\xF3\xB0\xA6\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB9"],
        ["\xF3\xB0\xA6\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB9"],

        ["\xF3\xB0\xA6\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBA"],
        ["\xF3\xB0\xA6\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBA"],

        ["\xF3\xB0\xA6\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBB"],
        ["\xF3\xB0\xA6\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBB"],

        ["\xF3\xB0\xA6\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBC"],
        ["\xF3\xB0\xA6\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBC"],

        ["\xF3\xB0\xA6\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBD"],
        ["\xF3\xB0\xA6\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBD"],

        ["\xF3\xB0\xA6\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBE"],
        ["\xF3\xB0\xA6\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBE"],

        ["\xF3\xB0\xA6\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBF"],
        ["\xF3\xB0\xA6\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBF"],

        ["\xF3\xB0\xA7\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x80"],
        ["\xF3\xB0\xA7\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x80"],

        ["\xF3\xB0\xA7\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x81"],
        ["\xF3\xB0\xA7\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x81"],

        ["\xF3\xB0\xA7\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x82"],
        ["\xF3\xB0\xA7\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x82"],

        ["\xF3\xB0\xA7\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x83"],
        ["\xF3\xB0\xA7\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x83"],

        ["\xF3\xB0\xA7\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x84"],
        ["\xF3\xB0\xA7\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x84"],

        ["\xF3\xB0\xA7\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x85"],
        ["\xF3\xB0\xA7\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x85"],

        ["\xF3\xB0\xA7\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x86"],
        ["\xF3\xB0\xA7\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x86"],

        ["\xF3\xB0\xA7\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x87"],
        ["\xF3\xB0\xA7\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x87"],

        ["\xF3\xB0\xA7\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x88"],
        ["\xF3\xB0\xA7\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x88"],

        ["\xF3\xB0\xA7\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x89"],
        ["\xF3\xB0\xA7\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x89"],

        ["\xF3\xB0\xA7\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8A"],
        ["\xF3\xB0\xA7\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8A"],

        ["\xF3\xB0\xA7\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8B"],
        ["\xF3\xB0\xA7\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8B"],

        ["\xF3\xB0\xA7\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8C"],
        ["\xF3\xB0\xA7\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8C"],

        ["\xF3\xB0\xA7\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8D"],
        ["\xF3\xB0\xA7\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8D"],

        ["\xF3\xB0\xA7\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8E"],
        ["\xF3\xB0\xA7\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8E"],

        ["\xF3\xB0\xA7\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8F"],
        ["\xF3\xB0\xA7\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8F"],

        ["\xF3\xB0\xA7\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x90"],
        ["\xF3\xB0\xA7\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x90"],

        ["\xF3\xB0\xA7\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x91"],
        ["\xF3\xB0\xA7\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x91"],

        ["\xF3\xB0\xA7\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x92"],
        ["\xF3\xB0\xA7\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x92"],

        ["\xF3\xB0\xA7\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x93"],
        ["\xF3\xB0\xA7\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x93"],

        ["\xF3\xB0\xA7\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x94"],
        ["\xF3\xB0\xA7\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x94"],

        ["\xF3\xB0\xA7\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x95"],
        ["\xF3\xB0\xA7\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x95"],

        ["\xF3\xB0\xA7\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x96"],
        ["\xF3\xB0\xA7\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x96"],

        ["\xF3\xB0\xA7\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x97"],
        ["\xF3\xB0\xA7\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x97"],

        ["\xF3\xB0\xA7\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x98"],
        ["\xF3\xB0\xA7\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x98"],

        ["\xF3\xB0\xA7\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x99"],
        ["\xF3\xB0\xA7\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x99"],

        ["\xF3\xB0\xA7\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9A"],
        ["\xF3\xB0\xA7\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9A"],

        ["\xF3\xB0\xA7\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9B"],
        ["\xF3\xB0\xA7\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9B"],

        ["\xF3\xB0\xA7\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9C"],
        ["\xF3\xB0\xA7\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9C"],

        ["\xF3\xB0\xA7\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9D"],
        ["\xF3\xB0\xA7\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9D"],

        ["\xF3\xB0\xA7\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9E"],
        ["\xF3\xB0\xA7\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9E"],

        ["\xF3\xB0\xA7\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9F"],
        ["\xF3\xB0\xA7\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9F"],

        ["\xF3\xB0\xA7\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA0"],
        ["\xF3\xB0\xA7\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA0"],

        ["\xF3\xB0\xA7\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA1"],
        ["\xF3\xB0\xA7\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA1"],

        ["\xF3\xB0\xA7\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA2"],
        ["\xF3\xB0\xA7\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA2"],

        ["\xF3\xB0\xA7\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA3"],
        ["\xF3\xB0\xA7\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA3"],

        ["\xF3\xB0\xA7\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA4"],
        ["\xF3\xB0\xA7\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA4"],

        ["\xF3\xB0\xA7\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA5"],
        ["\xF3\xB0\xA7\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA5"],

        ["\xF3\xB0\xA7\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA6"],
        ["\xF3\xB0\xA7\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA6"],

        ["\xF3\xB0\xA7\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA7"],
        ["\xF3\xB0\xA7\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA7"],

        ["\xF3\xB0\xA7\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA8"],
        ["\xF3\xB0\xA7\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA8"],

        ["\xF3\xB0\xA7\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA9"],
        ["\xF3\xB0\xA7\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA9"],

        ["\xF3\xB0\xA7\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAA"],
        ["\xF3\xB0\xA7\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAA"],

        ["\xF3\xB0\xA7\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAB"],
        ["\xF3\xB0\xA7\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAB"],

        ["\xF3\xB0\xA7\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAC"],
        ["\xF3\xB0\xA7\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAC"],

        ["\xF3\xB0\xA7\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAD"],
        ["\xF3\xB0\xA7\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAD"],

        ["\xF3\xB0\xA7\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAE"],
        ["\xF3\xB0\xA7\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAE"],

        ["\xF3\xB0\xA7\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAF"],
        ["\xF3\xB0\xA7\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAF"],

        ["\xF3\xB0\xA7\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB0"],
        ["\xF3\xB0\xA7\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB0"],

        ["\xF3\xB0\xA7\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB1"],
        ["\xF3\xB0\xA7\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB1"],

        ["\xF3\xB0\xA7\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB2"],
        ["\xF3\xB0\xA7\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB2"],

        ["\xF3\xB0\xA7\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB3"],
        ["\xF3\xB0\xA7\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB3"],

        ["\xF3\xB0\xA7\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB4"],
        ["\xF3\xB0\xA7\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB4"],

        ["\xF3\xB0\xA7\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB5"],
        ["\xF3\xB0\xA7\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB5"],

        ["\xF3\xB0\xA7\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB6"],
        ["\xF3\xB0\xA7\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB6"],

        ["\xF3\xB0\xA7\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB7"],
        ["\xF3\xB0\xA7\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB7"],

        ["\xF3\xB0\xA7\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB8"],
        ["\xF3\xB0\xA7\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB8"],

        ["\xF3\xB0\xA7\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB9"],
        ["\xF3\xB0\xA7\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB9"],

        ["\xF3\xB0\xA7\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBA"],
        ["\xF3\xB0\xA7\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBA"],

        ["\xF3\xB0\xA7\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBB"],
        ["\xF3\xB0\xA7\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBB"],

        ["\xF3\xB0\xA7\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBC"],
        ["\xF3\xB0\xA7\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBC"],

        ["\xF3\xB0\xA7\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBD"],
        ["\xF3\xB0\xA7\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBD"],

        ["\xF3\xB0\xA7\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBE"],
        ["\xF3\xB0\xA7\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBE"],

        ["\xF3\xB0\xA7\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBF"],
        ["\xF3\xB0\xA7\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBF"],

        ["\xF3\xB0\xA8\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x80"],
        ["\xF3\xB0\xA8\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x80"],

        ["\xF3\xB0\xA8\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x81"],
        ["\xF3\xB0\xA8\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x81"],

        ["\xF3\xB0\xA8\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x82"],
        ["\xF3\xB0\xA8\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x82"],

        ["\xF3\xB0\xA8\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x83"],
        ["\xF3\xB0\xA8\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x83"],

        ["\xF3\xB0\xA8\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x84"],
        ["\xF3\xB0\xA8\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x84"],

        ["\xF3\xB0\xA8\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x85"],
        ["\xF3\xB0\xA8\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x85"],

        ["\xF3\xB0\xA8\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x86"],
        ["\xF3\xB0\xA8\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x86"],

        ["\xF3\xB0\xA8\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x87"],
        ["\xF3\xB0\xA8\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x87"],

        ["\xF3\xB0\xA8\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x88"],
        ["\xF3\xB0\xA8\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x88"],

        ["\xF3\xB0\xA8\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x89"],
        ["\xF3\xB0\xA8\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x89"],

        ["\xF3\xB0\xA8\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8A"],
        ["\xF3\xB0\xA8\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8A"],

        ["\xF3\xB0\xA8\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8B"],
        ["\xF3\xB0\xA8\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8B"],

        ["\xF3\xB0\xA8\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8C"],
        ["\xF3\xB0\xA8\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8C"],

        ["\xF3\xB0\xA8\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8D"],
        ["\xF3\xB0\xA8\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8D"],

        ["\xF3\xB0\xA8\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8E"],
        ["\xF3\xB0\xA8\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8E"],

        ["\xF3\xB0\xA8\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8F"],
        ["\xF3\xB0\xA8\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8F"],

        ["\xF3\xB0\xA8\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x90"],
        ["\xF3\xB0\xA8\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x90"],

        ["\xF3\xB0\xA8\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x91"],
        ["\xF3\xB0\xA8\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x91"],

        ["\xF3\xB0\xA8\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x92"],
        ["\xF3\xB0\xA8\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x92"],

        ["\xF3\xB0\xA8\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x93"],
        ["\xF3\xB0\xA8\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x93"],

        ["\xF3\xB0\xA8\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x94"],
        ["\xF3\xB0\xA8\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x94"],

        ["\xF3\xB0\xA8\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x95"],
        ["\xF3\xB0\xA8\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x95"],

        ["\xF3\xB0\xA8\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x96"],
        ["\xF3\xB0\xA8\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x96"],

        ["\xF3\xB0\xA8\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x97"],
        ["\xF3\xB0\xA8\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x97"],

        ["\xF3\xB0\xA8\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x98"],
        ["\xF3\xB0\xA8\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x98"],

        ["\xF3\xB0\xA8\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x99"],
        ["\xF3\xB0\xA8\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x99"],

        ["\xF3\xB0\xA8\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9A"],
        ["\xF3\xB0\xA8\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9A"],

        ["\xF3\xB0\xA8\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9B"],
        ["\xF3\xB0\xA8\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9B"],

        ["\xF3\xB0\xA8\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9C"],
        ["\xF3\xB0\xA8\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9C"],

        ["\xF3\xB0\xA8\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9D"],
        ["\xF3\xB0\xA8\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9D"],

        ["\xF3\xB0\xA8\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9E"],
        ["\xF3\xB0\xA8\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9E"],

        ["\xF3\xB0\xA8\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9F"],
        ["\xF3\xB0\xA8\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9F"],

        ["\xF3\xB0\xA8\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA0"],
        ["\xF3\xB0\xA8\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA0"],

        ["\xF3\xB0\xA8\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA1"],
        ["\xF3\xB0\xA8\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA1"],

        ["\xF3\xB0\xA8\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA2"],
        ["\xF3\xB0\xA8\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA2"],

        ["\xF3\xB0\xA8\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA3"],
        ["\xF3\xB0\xA8\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA3"],

        ["\xF3\xB0\xA8\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA4"],
        ["\xF3\xB0\xA8\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA4"],

        ["\xF3\xB0\xA8\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA5"],
        ["\xF3\xB0\xA8\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA5"],

        ["\xF3\xB0\xA8\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA6"],
        ["\xF3\xB0\xA8\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA6"],

        ["\xF3\xB0\xA8\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA7"],
        ["\xF3\xB0\xA8\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA7"],

        ["\xF3\xB0\xA8\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA8"],
        ["\xF3\xB0\xA8\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA8"],

        ["\xF3\xB0\xA8\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA9"],
        ["\xF3\xB0\xA8\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA9"],

        ["\xF3\xB0\xA8\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAA"],
        ["\xF3\xB0\xA8\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAA"],

        ["\xF3\xB0\xA8\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAB"],
        ["\xF3\xB0\xA8\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAB"],

        ["\xF3\xB0\xA8\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAC"],
        ["\xF3\xB0\xA8\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAC"],

        ["\xF3\xB0\xA8\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAD"],
        ["\xF3\xB0\xA8\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAD"],

        ["\xF3\xB0\xA8\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAE"],
        ["\xF3\xB0\xA8\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAE"],

        ["\xF3\xB0\xA8\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAF"],
        ["\xF3\xB0\xA8\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAF"],

        ["\xF3\xB0\xA8\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB0"],
        ["\xF3\xB0\xA8\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB0"],

        ["\xF3\xB0\xA8\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB1"],
        ["\xF3\xB0\xA8\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB1"],

        ["\xF3\xB0\xA8\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB2"],
        ["\xF3\xB0\xA8\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB2"],

        ["\xF3\xB0\xA8\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB3"],
        ["\xF3\xB0\xA8\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB3"],

        ["\xF3\xB0\xA8\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB4"],
        ["\xF3\xB0\xA8\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB4"],

        ["\xF3\xB0\xA8\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB5"],
        ["\xF3\xB0\xA8\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB5"],

        ["\xF3\xB0\xA8\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB6"],
        ["\xF3\xB0\xA8\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB6"],

        ["\xF3\xB0\xA8\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB7"],
        ["\xF3\xB0\xA8\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB7"],

        ["\xF3\xB0\xA8\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB8"],
        ["\xF3\xB0\xA8\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB8"],

        ["\xF3\xB0\xA8\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB9"],
        ["\xF3\xB0\xA8\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB9"],

        ["\xF3\xB0\xA8\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBA"],
        ["\xF3\xB0\xA8\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBA"],

        ["\xF3\xB0\xA8\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBB"],
        ["\xF3\xB0\xA8\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBB"],

        ["\xF3\xB0\xA8\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBC"],
        ["\xF3\xB0\xA8\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBC"],

        ["\xF3\xB0\xA8\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBD"],
        ["\xF3\xB0\xA8\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBD"],

        ["\xF3\xB0\xA8\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBE"],
        ["\xF3\xB0\xA8\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBE"],

        ["\xF3\xB0\xA8\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBF"],
        ["\xF3\xB0\xA8\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBF"],

        ["\xF3\xB0\xA9\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x80"],
        ["\xF3\xB0\xA9\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x80"],

        ["\xF3\xB0\xA9\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x81"],
        ["\xF3\xB0\xA9\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x81"],

        ["\xF3\xB0\xA9\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x82"],
        ["\xF3\xB0\xA9\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x82"],

        ["\xF3\xB0\xA9\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x83"],
        ["\xF3\xB0\xA9\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x83"],

        ["\xF3\xB0\xA9\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x84"],
        ["\xF3\xB0\xA9\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x84"],

        ["\xF3\xB0\xA9\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x85"],
        ["\xF3\xB0\xA9\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x85"],

        ["\xF3\xB0\xA9\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x86"],
        ["\xF3\xB0\xA9\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x86"],

        ["\xF3\xB0\xA9\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x87"],
        ["\xF3\xB0\xA9\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x87"],

        ["\xF3\xB0\xA9\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x88"],
        ["\xF3\xB0\xA9\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x88"],

        ["\xF3\xB0\xA9\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x89"],
        ["\xF3\xB0\xA9\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x89"],

        ["\xF3\xB0\xA9\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8A"],
        ["\xF3\xB0\xA9\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8A"],

        ["\xF3\xB0\xA9\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8B"],
        ["\xF3\xB0\xA9\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8B"],

        ["\xF3\xB0\xA9\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8C"],
        ["\xF3\xB0\xA9\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8C"],

        ["\xF3\xB0\xA9\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8D"],
        ["\xF3\xB0\xA9\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8D"],

        ["\xF3\xB0\xA9\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8E"],
        ["\xF3\xB0\xA9\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8E"],

        ["\xF3\xB0\xA9\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8F"],
        ["\xF3\xB0\xA9\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8F"],

        ["\xF3\xB0\xA9\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x90"],
        ["\xF3\xB0\xA9\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x90"],

        ["\xF3\xB0\xA9\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x91"],
        ["\xF3\xB0\xA9\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x91"],

        ["\xF3\xB0\xA9\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x92"],
        ["\xF3\xB0\xA9\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x92"],

        ["\xF3\xB0\xA9\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x93"],
        ["\xF3\xB0\xA9\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x93"],

        ["\xF3\xB0\xA9\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x94"],
        ["\xF3\xB0\xA9\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x94"],

        ["\xF3\xB0\xA9\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x95"],
        ["\xF3\xB0\xA9\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x95"],

        ["\xF3\xB0\xA9\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x96"],
        ["\xF3\xB0\xA9\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x96"],

        ["\xF3\xB0\xA9\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x97"],
        ["\xF3\xB0\xA9\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x97"],

        ["\xF3\xB0\xA9\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x98"],
        ["\xF3\xB0\xA9\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x98"],

        ["\xF3\xB0\xA9\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x99"],
        ["\xF3\xB0\xA9\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x99"],

        ["\xF3\xB0\xA9\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9A"],
        ["\xF3\xB0\xA9\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9A"],

        ["\xF3\xB0\xA9\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9B"],
        ["\xF3\xB0\xA9\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9B"],

        ["\xF3\xB0\xA9\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9C"],
        ["\xF3\xB0\xA9\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9C"],

        ["\xF3\xB0\xA9\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9D"],
        ["\xF3\xB0\xA9\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9D"],

        ["\xF3\xB0\xA9\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9E"],
        ["\xF3\xB0\xA9\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9E"],

        ["\xF3\xB0\xA9\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9F"],
        ["\xF3\xB0\xA9\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9F"],

        ["\xF3\xB0\xA9\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA0"],
        ["\xF3\xB0\xA9\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA0"],

        ["\xF3\xB0\xA9\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA1"],
        ["\xF3\xB0\xA9\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA1"],

        ["\xF3\xB0\xA9\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA2"],
        ["\xF3\xB0\xA9\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA2"],

        ["\xF3\xB0\xA9\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA3"],
        ["\xF3\xB0\xA9\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA3"],

        ["\xF3\xB0\xA9\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA4"],
        ["\xF3\xB0\xA9\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA4"],

        ["\xF3\xB0\xA9\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA5"],
        ["\xF3\xB0\xA9\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA5"],

        ["\xF3\xB0\xA9\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA6"],
        ["\xF3\xB0\xA9\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA6"],

        ["\xF3\xB0\xA9\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA7"],
        ["\xF3\xB0\xA9\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA7"],

        ["\xF3\xB0\xA9\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA8"],
        ["\xF3\xB0\xA9\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA8"],

        ["\xF3\xB0\xA9\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA9"],
        ["\xF3\xB0\xA9\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA9"],

        ["\xF3\xB0\xA9\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAA"],
        ["\xF3\xB0\xA9\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAA"],

        ["\xF3\xB0\xA9\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAB"],
        ["\xF3\xB0\xA9\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAB"],

        ["\xF3\xB0\xA9\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAC"],
        ["\xF3\xB0\xA9\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAC"],

        ["\xF3\xB0\xA9\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAD"],
        ["\xF3\xB0\xA9\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAD"],

        ["\xF3\xB0\xA9\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAE"],
        ["\xF3\xB0\xA9\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAE"],

        ["\xF3\xB0\xA9\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAF"],
        ["\xF3\xB0\xA9\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAF"],

        ["\xF3\xB0\xA9\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB0"],
        ["\xF3\xB0\xA9\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB0"],

        ["\xF3\xB0\xA9\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB1"],
        ["\xF3\xB0\xA9\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB1"],

        ["\xF3\xB0\xA9\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB2"],
        ["\xF3\xB0\xA9\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB2"],

        ["\xF3\xB0\xA9\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB3"],
        ["\xF3\xB0\xA9\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB3"],

        ["\xF3\xB0\xA9\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB4"],
        ["\xF3\xB0\xA9\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB4"],

        ["\xF3\xB0\xA9\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB5"],
        ["\xF3\xB0\xA9\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB5"],

        ["\xF3\xB0\xA9\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB6"],
        ["\xF3\xB0\xA9\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB6"],

        ["\xF3\xB0\xA9\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB7"],
        ["\xF3\xB0\xA9\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB7"],

        ["\xF3\xB0\xA9\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB8"],
        ["\xF3\xB0\xA9\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB8"],

        ["\xF3\xB0\xA9\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB9"],
        ["\xF3\xB0\xA9\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB9"],

        ["\xF3\xB0\xA9\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBA"],
        ["\xF3\xB0\xA9\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBA"],

        ["\xF3\xB0\xA9\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBB"],
        ["\xF3\xB0\xA9\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBB"],

        ["\xF3\xB0\xA9\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBC"],
        ["\xF3\xB0\xA9\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBC"],

        ["\xF3\xB0\xA9\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBD"],
        ["\xF3\xB0\xA9\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBD"],

        ["\xF3\xB0\xA9\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBE"],
        ["\xF3\xB0\xA9\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBE"],

        ["\xF3\xB0\xA9\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBF"],
        ["\xF3\xB0\xA9\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBF"],

        ["\xF3\xB0\xAA\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x80"],
        ["\xF3\xB0\xAA\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x80"],

        ["\xF3\xB0\xAA\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x81"],
        ["\xF3\xB0\xAA\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x81"],

        ["\xF3\xB0\xAA\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x82"],
        ["\xF3\xB0\xAA\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x82"],

        ["\xF3\xB0\xAA\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x83"],
        ["\xF3\xB0\xAA\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x83"],

        ["\xF3\xB0\xAA\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x84"],
        ["\xF3\xB0\xAA\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x84"],

        ["\xF3\xB0\xAA\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x85"],
        ["\xF3\xB0\xAA\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x85"],

        ["\xF3\xB0\xAA\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x86"],
        ["\xF3\xB0\xAA\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x86"],

        ["\xF3\xB0\xAA\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x87"],
        ["\xF3\xB0\xAA\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x87"],

        ["\xF3\xB0\xAA\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x88"],
        ["\xF3\xB0\xAA\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x88"],

        ["\xF3\xB0\xAA\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x89"],
        ["\xF3\xB0\xAA\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x89"],

        ["\xF3\xB0\xAA\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8A"],
        ["\xF3\xB0\xAA\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8A"],

        ["\xF3\xB0\xAA\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8B"],
        ["\xF3\xB0\xAA\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8B"],

        ["\xF3\xB0\xAA\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8C"],
        ["\xF3\xB0\xAA\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8C"],

        ["\xF3\xB0\xAA\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8D"],
        ["\xF3\xB0\xAA\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8D"],

        ["\xF3\xB0\xAA\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8E"],
        ["\xF3\xB0\xAA\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8E"],

        ["\xF3\xB0\xAA\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8F"],
        ["\xF3\xB0\xAA\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8F"],

        ["\xF3\xB0\xAA\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x90"],
        ["\xF3\xB0\xAA\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x90"],

        ["\xF3\xB0\xAA\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x91"],
        ["\xF3\xB0\xAA\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x91"],

        ["\xF3\xB0\xAA\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x92"],
        ["\xF3\xB0\xAA\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x92"],

        ["\xF3\xB0\xAA\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x93"],
        ["\xF3\xB0\xAA\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x93"],

        ["\xF3\xB0\xAA\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x94"],
        ["\xF3\xB0\xAA\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x94"],

        ["\xF3\xB0\xAA\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x95"],
        ["\xF3\xB0\xAA\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x95"],

        ["\xF3\xB0\xAA\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x96"],
        ["\xF3\xB0\xAA\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x96"],

        ["\xF3\xB0\xAA\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x97"],
        ["\xF3\xB0\xAA\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x97"],

        ["\xF3\xB0\xAA\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x98"],
        ["\xF3\xB0\xAA\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x98"],

        ["\xF3\xB0\xAA\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x99"],
        ["\xF3\xB0\xAA\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x99"],

        ["\xF3\xB0\xAA\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9A"],
        ["\xF3\xB0\xAA\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9A"],

        ["\xF3\xB0\xAA\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9B"],
        ["\xF3\xB0\xAA\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9B"],

        ["\xF3\xB0\xAA\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9C"],
        ["\xF3\xB0\xAA\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9C"],

        ["\xF3\xB0\xAA\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9D"],
        ["\xF3\xB0\xAA\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9D"],

        ["\xF3\xB0\xAA\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9E"],
        ["\xF3\xB0\xAA\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9E"],

        ["\xF3\xB0\xAA\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9F"],
        ["\xF3\xB0\xAA\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9F"],

        ["\xF3\xB0\xAA\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA0"],
        ["\xF3\xB0\xAA\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA0"],

        ["\xF3\xB0\xAA\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA1"],
        ["\xF3\xB0\xAA\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA1"],

        ["\xF3\xB0\xAA\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA2"],
        ["\xF3\xB0\xAA\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA2"],

        ["\xF3\xB0\xAA\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA3"],
        ["\xF3\xB0\xAA\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA3"],

        ["\xF3\xB0\xAA\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA4"],
        ["\xF3\xB0\xAA\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA4"],

        ["\xF3\xB0\xAA\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA5"],
        ["\xF3\xB0\xAA\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA5"],

        ["\xF3\xB0\xAA\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA6"],
        ["\xF3\xB0\xAA\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA6"],

        ["\xF3\xB0\xAA\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA7"],
        ["\xF3\xB0\xAA\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA7"],

        ["\xF3\xB0\xAA\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA8"],
        ["\xF3\xB0\xAA\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA8"],

        ["\xF3\xB0\xAA\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA9"],
        ["\xF3\xB0\xAA\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA9"],

        ["\xF3\xB0\xAA\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAA"],
        ["\xF3\xB0\xAA\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAA"],

        ["\xF3\xB0\xAA\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAB"],
        ["\xF3\xB0\xAA\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAB"],

        ["\xF3\xB0\xAA\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAC"],
        ["\xF3\xB0\xAA\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAC"],

        ["\xF3\xB0\xAA\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAD"],
        ["\xF3\xB0\xAA\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAD"],

        ["\xF3\xB0\xAA\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAE"],
        ["\xF3\xB0\xAA\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAE"],

        ["\xF3\xB0\xAA\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAF"],
        ["\xF3\xB0\xAA\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAF"],

        ["\xF3\xB0\xAA\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB0"],
        ["\xF3\xB0\xAA\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB0"],

        ["\xF3\xB0\xAA\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB1"],
        ["\xF3\xB0\xAA\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB1"],

        ["\xF3\xB0\xAA\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB2"],
        ["\xF3\xB0\xAA\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB2"],

        ["\xF3\xB0\xAA\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB3"],
        ["\xF3\xB0\xAA\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB3"],

        ["\xF3\xB0\xAA\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB4"],
        ["\xF3\xB0\xAA\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB4"],

        ["\xF3\xB0\xAA\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB5"],
        ["\xF3\xB0\xAA\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB5"],

        ["\xF3\xB0\xAA\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB6"],
        ["\xF3\xB0\xAA\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB6"],

        ["\xF3\xB0\xAA\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB7"],
        ["\xF3\xB0\xAA\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB7"],

        ["\xF3\xB0\xAA\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB8"],
        ["\xF3\xB0\xAA\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB8"],

        ["\xF3\xB0\xAA\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB9"],
        ["\xF3\xB0\xAA\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB9"],

        ["\xF3\xB0\xAA\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBA"],
        ["\xF3\xB0\xAA\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBA"],

        ["\xF3\xB0\xAA\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBB"],
        ["\xF3\xB0\xAA\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBB"],

        ["\xF3\xB0\xAA\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBC"],
        ["\xF3\xB0\xAA\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBC"],

        ["\xF3\xB0\xAA\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBD"],
        ["\xF3\xB0\xAA\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBD"],

        ["\xF3\xB0\xAA\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBE"],
        ["\xF3\xB0\xAA\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBE"],

        ["\xF3\xB0\xAA\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBF"],
        ["\xF3\xB0\xAA\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBF"],

        ["\xF3\xB0\xAB\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x80"],
        ["\xF3\xB0\xAB\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x80"],

        ["\xF3\xB0\xAB\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x81"],
        ["\xF3\xB0\xAB\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x81"],

        ["\xF3\xB0\xAB\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x82"],
        ["\xF3\xB0\xAB\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x82"],

        ["\xF3\xB0\xAB\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x83"],
        ["\xF3\xB0\xAB\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x83"],

        ["\xF3\xB0\xAB\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x84"],
        ["\xF3\xB0\xAB\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x84"],

        ["\xF3\xB0\xAB\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x85"],
        ["\xF3\xB0\xAB\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x85"],

        ["\xF3\xB0\xAB\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x86"],
        ["\xF3\xB0\xAB\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x86"],

        ["\xF3\xB0\xAB\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x87"],
        ["\xF3\xB0\xAB\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x87"],

        ["\xF3\xB0\xAB\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x88"],
        ["\xF3\xB0\xAB\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x88"],

        ["\xF3\xB0\xAB\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x89"],
        ["\xF3\xB0\xAB\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x89"],

        ["\xF3\xB0\xAB\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8A"],
        ["\xF3\xB0\xAB\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8A"],

        ["\xF3\xB0\xAB\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8B"],
        ["\xF3\xB0\xAB\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8B"],

        ["\xF3\xB0\xAB\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8C"],
        ["\xF3\xB0\xAB\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8C"],

        ["\xF3\xB0\xAB\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8D"],
        ["\xF3\xB0\xAB\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8D"],

        ["\xF3\xB0\xAB\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8E"],
        ["\xF3\xB0\xAB\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8E"],

        ["\xF3\xB0\xAB\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8F"],
        ["\xF3\xB0\xAB\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8F"],

        ["\xF3\xB0\xAB\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x90"],
        ["\xF3\xB0\xAB\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x90"],

        ["\xF3\xB0\xAB\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x91"],
        ["\xF3\xB0\xAB\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x91"],

        ["\xF3\xB0\xAB\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x92"],
        ["\xF3\xB0\xAB\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x92"],

        ["\xF3\xB0\xAB\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x93"],
        ["\xF3\xB0\xAB\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x93"],

        ["\xF3\xB0\xAB\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x94"],
        ["\xF3\xB0\xAB\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x94"],

        ["\xF3\xB0\xAB\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x95"],
        ["\xF3\xB0\xAB\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x95"],

        ["\xF3\xB0\xAB\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x96"],
        ["\xF3\xB0\xAB\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x96"],

        ["\xF3\xB0\xAB\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x97"],
        ["\xF3\xB0\xAB\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x97"],

        ["\xF3\xB0\xAB\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x98"],
        ["\xF3\xB0\xAB\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x98"],

        ["\xF3\xB0\xAB\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x99"],
        ["\xF3\xB0\xAB\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x99"],

        ["\xF3\xB0\xAB\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9A"],
        ["\xF3\xB0\xAB\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9A"],

        ["\xF3\xB0\xAB\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9B"],
        ["\xF3\xB0\xAB\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9B"],

        ["\xF3\xB0\xAB\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9C"],
        ["\xF3\xB0\xAB\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9C"],

        ["\xF3\xB0\xAB\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9D"],
        ["\xF3\xB0\xAB\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9D"],

        ["\xF3\xB0\xAB\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9E"],
        ["\xF3\xB0\xAB\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9E"],

        ["\xF3\xB0\xAB\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9F"],
        ["\xF3\xB0\xAB\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9F"],

        ["\xF3\xB0\xAB\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA0"],
        ["\xF3\xB0\xAB\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA0"],

        ["\xF3\xB0\xAB\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA1"],
        ["\xF3\xB0\xAB\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA1"],

        ["\xF3\xB0\xAB\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA2"],
        ["\xF3\xB0\xAB\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA2"],

        ["\xF3\xB0\xAB\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA3"],
        ["\xF3\xB0\xAB\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA3"],

        ["\xF3\xB0\xAB\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA4"],
        ["\xF3\xB0\xAB\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA4"],

        ["\xF3\xB0\xAB\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA5"],
        ["\xF3\xB0\xAB\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA5"],

        ["\xF3\xB0\xAB\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA6"],
        ["\xF3\xB0\xAB\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA6"],

        ["\xF3\xB0\xAB\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA7"],
        ["\xF3\xB0\xAB\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA7"],

        ["\xF3\xB0\xAB\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA8"],
        ["\xF3\xB0\xAB\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA8"],

        ["\xF3\xB0\xAB\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA9"],
        ["\xF3\xB0\xAB\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA9"],

        ["\xF3\xB0\xAB\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAA"],
        ["\xF3\xB0\xAB\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAA"],

        ["\xF3\xB0\xAB\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAB"],
        ["\xF3\xB0\xAB\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAB"],

        ["\xF3\xB0\xAB\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAC"],
        ["\xF3\xB0\xAB\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAC"],

        ["\xF3\xB0\xAB\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAD"],
        ["\xF3\xB0\xAB\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAD"],

        ["\xF3\xB0\xAB\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAE"],
        ["\xF3\xB0\xAB\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAE"],

        ["\xF3\xB0\xAB\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAF"],
        ["\xF3\xB0\xAB\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAF"],

        ["\xF3\xB0\xAB\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB0"],
        ["\xF3\xB0\xAB\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB0"],

        ["\xF3\xB0\xAB\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB1"],
        ["\xF3\xB0\xAB\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB1"],

        ["\xF3\xB0\xAB\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB2"],
        ["\xF3\xB0\xAB\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB2"],

        ["\xF3\xB0\xAB\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB3"],
        ["\xF3\xB0\xAB\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB3"],

        ["\xF3\xB0\xAB\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB4"],
        ["\xF3\xB0\xAB\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB4"],

        ["\xF3\xB0\xAB\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB5"],
        ["\xF3\xB0\xAB\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB5"],

        ["\xF3\xB0\xAB\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB6"],
        ["\xF3\xB0\xAB\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB6"],

        ["\xF3\xB0\xAB\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB7"],
        ["\xF3\xB0\xAB\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB7"],

        ["\xF3\xB0\xAB\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB8"],
        ["\xF3\xB0\xAB\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB8"],

        ["\xF3\xB0\xAB\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB9"],
        ["\xF3\xB0\xAB\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB9"],

        ["\xF3\xB0\xAB\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBA"],
        ["\xF3\xB0\xAB\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBA"],

        ["\xF3\xB0\xAB\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBB"],
        ["\xF3\xB0\xAB\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBB"],

        ["\xF3\xB0\xAB\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBC"],
        ["\xF3\xB0\xAB\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBC"],

        ["\xF3\xB0\xAB\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBD"],
        ["\xF3\xB0\xAB\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBD"],

        ["\xF3\xB0\xAB\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBE"],
        ["\xF3\xB0\xAB\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBE"],

        ["\xF3\xB0\xAB\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBF"],
        ["\xF3\xB0\xAB\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBF"],

        ["\xF3\xB0\xAC\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x80"],
        ["\xF3\xB0\xAC\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x80"],

        ["\xF3\xB0\xAC\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x81"],
        ["\xF3\xB0\xAC\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x81"],

        ["\xF3\xB0\xAC\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x82"],
        ["\xF3\xB0\xAC\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x82"],

        ["\xF3\xB0\xAC\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x83"],
        ["\xF3\xB0\xAC\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x83"],

        ["\xF3\xB0\xAC\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x84"],
        ["\xF3\xB0\xAC\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x84"],

        ["\xF3\xB0\xAC\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x85"],
        ["\xF3\xB0\xAC\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x85"],

        ["\xF3\xB0\xAC\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x86"],
        ["\xF3\xB0\xAC\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x86"],

        ["\xF3\xB0\xAC\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x87"],
        ["\xF3\xB0\xAC\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x87"],

        ["\xF3\xB0\xAC\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x88"],
        ["\xF3\xB0\xAC\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x88"],

        ["\xF3\xB0\xAC\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x89"],
        ["\xF3\xB0\xAC\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x89"],

        ["\xF3\xB0\xAC\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8A"],
        ["\xF3\xB0\xAC\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8A"],

        ["\xF3\xB0\xAC\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8B"],
        ["\xF3\xB0\xAC\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8B"],

        ["\xF3\xB0\xAC\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8C"],
        ["\xF3\xB0\xAC\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8C"],

        ["\xF3\xB0\xAC\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8D"],
        ["\xF3\xB0\xAC\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8D"],

        ["\xF3\xB0\xAC\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8E"],
        ["\xF3\xB0\xAC\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8E"],

        ["\xF3\xB0\xAC\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8F"],
        ["\xF3\xB0\xAC\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8F"],

        ["\xF3\xB0\xAC\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x90"],
        ["\xF3\xB0\xAC\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x90"],

        ["\xF3\xB0\xAC\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x91"],
        ["\xF3\xB0\xAC\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x91"],

        ["\xF3\xB0\xAC\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x92"],
        ["\xF3\xB0\xAC\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x92"],

        ["\xF3\xB0\xAC\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x93"],
        ["\xF3\xB0\xAC\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x93"],

        ["\xF3\xB0\xAC\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x94"],
        ["\xF3\xB0\xAC\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x94"],

        ["\xF3\xB0\xAC\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x95"],
        ["\xF3\xB0\xAC\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x95"],

        ["\xF3\xB0\xAC\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x96"],
        ["\xF3\xB0\xAC\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x96"],

        ["\xF3\xB0\xAC\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x97"],
        ["\xF3\xB0\xAC\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x97"],

        ["\xF3\xB0\xAC\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x98"],
        ["\xF3\xB0\xAC\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x98"],

        ["\xF3\xB0\xAC\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x99"],
        ["\xF3\xB0\xAC\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x99"],

        ["\xF3\xB0\xAC\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9A"],
        ["\xF3\xB0\xAC\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9A"],

        ["\xF3\xB0\xAC\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9B"],
        ["\xF3\xB0\xAC\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9B"],

        ["\xF3\xB0\xAC\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9C"],
        ["\xF3\xB0\xAC\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9C"],

        ["\xF3\xB0\xAC\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9D"],
        ["\xF3\xB0\xAC\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9D"],

        ["\xF3\xB0\xAC\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9E"],
        ["\xF3\xB0\xAC\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9E"],

        ["\xF3\xB0\xAC\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9F"],
        ["\xF3\xB0\xAC\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9F"],

        ["\xF3\xB0\xAC\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA0"],
        ["\xF3\xB0\xAC\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA0"],

        ["\xF3\xB0\xAC\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA1"],
        ["\xF3\xB0\xAC\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA1"],

        ["\xF3\xB0\xAC\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA2"],
        ["\xF3\xB0\xAC\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA2"],

        ["\xF3\xB0\xAC\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA3"],
        ["\xF3\xB0\xAC\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA3"],

        ["\xF3\xB0\xAC\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA4"],
        ["\xF3\xB0\xAC\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA4"],

        ["\xF3\xB0\xAC\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA5"],
        ["\xF3\xB0\xAC\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA5"],

        ["\xF3\xB0\xAC\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA6"],
        ["\xF3\xB0\xAC\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA6"],

        ["\xF3\xB0\xAC\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA7"],
        ["\xF3\xB0\xAC\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA7"],

        ["\xF3\xB0\xAC\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA8"],
        ["\xF3\xB0\xAC\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA8"],

        ["\xF3\xB0\xAC\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA9"],
        ["\xF3\xB0\xAC\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA9"],

        ["\xF3\xB0\xAC\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAA"],
        ["\xF3\xB0\xAC\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAA"],

        ["\xF3\xB0\xAC\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAB"],
        ["\xF3\xB0\xAC\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAB"],

        ["\xF3\xB0\xAC\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAC"],
        ["\xF3\xB0\xAC\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAC"],

        ["\xF3\xB0\xAC\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAD"],
        ["\xF3\xB0\xAC\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAD"],

        ["\xF3\xB0\xAC\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAE"],
        ["\xF3\xB0\xAC\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAE"],

        ["\xF3\xB0\xAC\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAF"],
        ["\xF3\xB0\xAC\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAF"],

        ["\xF3\xB0\xAC\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB0"],
        ["\xF3\xB0\xAC\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB0"],

        ["\xF3\xB0\xAC\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB1"],
        ["\xF3\xB0\xAC\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB1"],

        ["\xF3\xB0\xAC\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB2"],
        ["\xF3\xB0\xAC\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB2"],

        ["\xF3\xB0\xAC\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB3"],
        ["\xF3\xB0\xAC\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB3"],

        ["\xF3\xB0\xAC\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB4"],
        ["\xF3\xB0\xAC\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB4"],

        ["\xF3\xB0\xAC\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB5"],
        ["\xF3\xB0\xAC\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB5"],

        ["\xF3\xB0\xAC\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB6"],
        ["\xF3\xB0\xAC\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB6"],

        ["\xF3\xB0\xAC\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB7"],
        ["\xF3\xB0\xAC\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB7"],

        ["\xF3\xB0\xAC\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB8"],
        ["\xF3\xB0\xAC\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB8"],

        ["\xF3\xB0\xAC\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB9"],
        ["\xF3\xB0\xAC\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB9"],

        ["\xF3\xB0\xAC\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBA"],
        ["\xF3\xB0\xAC\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBA"],

        ["\xF3\xB0\xAC\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBB"],
        ["\xF3\xB0\xAC\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBB"],

        ["\xF3\xB0\xAC\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBC"],
        ["\xF3\xB0\xAC\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBC"],

        ["\xF3\xB0\xAC\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBD"],
        ["\xF3\xB0\xAC\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBD"],

        ["\xF3\xB0\xAC\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBE"],
        ["\xF3\xB0\xAC\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBE"],

        ["\xF3\xB0\xAC\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBF"],
        ["\xF3\xB0\xAC\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBF"],

        ["\xF3\xB0\xAD\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x80"],
        ["\xF3\xB0\xAD\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x80"],

        ["\xF3\xB0\xAD\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x81"],
        ["\xF3\xB0\xAD\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x81"],

        ["\xF3\xB0\xAD\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x82"],
        ["\xF3\xB0\xAD\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x82"],

        ["\xF3\xB0\xAD\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x83"],
        ["\xF3\xB0\xAD\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x83"],

        ["\xF3\xB0\xAD\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x84"],
        ["\xF3\xB0\xAD\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x84"],

        ["\xF3\xB0\xAD\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x85"],
        ["\xF3\xB0\xAD\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x85"],

        ["\xF3\xB0\xAD\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x86"],
        ["\xF3\xB0\xAD\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x86"],

        ["\xF3\xB0\xAD\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x87"],
        ["\xF3\xB0\xAD\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x87"],

        ["\xF3\xB0\xAD\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x88"],
        ["\xF3\xB0\xAD\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x88"],

        ["\xF3\xB0\xAD\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x89"],
        ["\xF3\xB0\xAD\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x89"],

        ["\xF3\xB0\xAD\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8A"],
        ["\xF3\xB0\xAD\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8A"],

        ["\xF3\xB0\xAD\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8B"],
        ["\xF3\xB0\xAD\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8B"],

        ["\xF3\xB0\xAD\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8C"],
        ["\xF3\xB0\xAD\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8C"],

        ["\xF3\xB0\xAD\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8D"],
        ["\xF3\xB0\xAD\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8D"],

        ["\xF3\xB0\xAD\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8E"],
        ["\xF3\xB0\xAD\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8E"],

        ["\xF3\xB0\xAD\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8F"],
        ["\xF3\xB0\xAD\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8F"],

        ["\xF3\xB0\xAD\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x90"],
        ["\xF3\xB0\xAD\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x90"],

        ["\xF3\xB0\xAD\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x91"],
        ["\xF3\xB0\xAD\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x91"],

        ["\xF3\xB0\xAD\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x92"],
        ["\xF3\xB0\xAD\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x92"],

        ["\xF3\xB0\xAD\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x93"],
        ["\xF3\xB0\xAD\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x93"],

        ["\xF3\xB0\xAD\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x94"],
        ["\xF3\xB0\xAD\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x94"],

        ["\xF3\xB0\xAD\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x95"],
        ["\xF3\xB0\xAD\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x95"],

        ["\xF3\xB0\xAD\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x96"],
        ["\xF3\xB0\xAD\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x96"],

        ["\xF3\xB0\xAD\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x97"],
        ["\xF3\xB0\xAD\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x97"],

        ["\xF3\xB0\xAD\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x98"],
        ["\xF3\xB0\xAD\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x98"],

        ["\xF3\xB0\xAD\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x99"],
        ["\xF3\xB0\xAD\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x99"],

        ["\xF3\xB0\xAD\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9A"],
        ["\xF3\xB0\xAD\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9A"],

        ["\xF3\xB0\xAD\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9B"],
        ["\xF3\xB0\xAD\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9B"],

        ["\xF3\xB0\xAD\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9C"],
        ["\xF3\xB0\xAD\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9C"],

        ["\xF3\xB0\xAD\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9D"],
        ["\xF3\xB0\xAD\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9D"],

        ["\xF3\xB0\xAD\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9E"],
        ["\xF3\xB0\xAD\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9E"],

        ["\xF3\xB0\xAD\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9F"],
        ["\xF3\xB0\xAD\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9F"],

        ["\xF3\xB0\xAD\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA0"],
        ["\xF3\xB0\xAD\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA0"],

        ["\xF3\xB0\xAD\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA1"],
        ["\xF3\xB0\xAD\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA1"],

        ["\xF3\xB0\xAD\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA2"],
        ["\xF3\xB0\xAD\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA2"],

        ["\xF3\xB0\xAD\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA3"],
        ["\xF3\xB0\xAD\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA3"],

        ["\xF3\xB0\xAD\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA4"],
        ["\xF3\xB0\xAD\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA4"],

        ["\xF3\xB0\xAD\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA5"],
        ["\xF3\xB0\xAD\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA5"],

        ["\xF3\xB0\xAD\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA6"],
        ["\xF3\xB0\xAD\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA6"],

        ["\xF3\xB0\xAD\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA7"],
        ["\xF3\xB0\xAD\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA7"],

        ["\xF3\xB0\xAD\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA8"],
        ["\xF3\xB0\xAD\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA8"],

        ["\xF3\xB0\xAD\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA9"],
        ["\xF3\xB0\xAD\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA9"],

        ["\xF3\xB0\xAD\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAA"],
        ["\xF3\xB0\xAD\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAA"],

        ["\xF3\xB0\xAD\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAB"],
        ["\xF3\xB0\xAD\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAB"],

        ["\xF3\xB0\xAD\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAC"],
        ["\xF3\xB0\xAD\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAC"],

        ["\xF3\xB0\xAD\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAD"],
        ["\xF3\xB0\xAD\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAD"],

        ["\xF3\xB0\xAD\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAE"],
        ["\xF3\xB0\xAD\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAE"],

        ["\xF3\xB0\xAD\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAF"],
        ["\xF3\xB0\xAD\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAF"],

        ["\xF3\xB0\xAD\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB0"],
        ["\xF3\xB0\xAD\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB0"],

        ["\xF3\xB0\xAD\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB1"],
        ["\xF3\xB0\xAD\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB1"],

        ["\xF3\xB0\xAD\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB2"],
        ["\xF3\xB0\xAD\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB2"],

        ["\xF3\xB0\xAD\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB3"],
        ["\xF3\xB0\xAD\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB3"],

        ["\xF3\xB0\xAD\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB4"],
        ["\xF3\xB0\xAD\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB4"],

        ["\xF3\xB0\xAD\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB5"],
        ["\xF3\xB0\xAD\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB5"],

        ["\xF3\xB0\xAD\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB6"],
        ["\xF3\xB0\xAD\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB6"],

        ["\xF3\xB0\xAD\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB7"],
        ["\xF3\xB0\xAD\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB7"],

        ["\xF3\xB0\xAD\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB8"],
        ["\xF3\xB0\xAD\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB8"],

        ["\xF3\xB0\xAD\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB9"],
        ["\xF3\xB0\xAD\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB9"],

        ["\xF3\xB0\xAD\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBA"],
        ["\xF3\xB0\xAD\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBA"],

        ["\xF3\xB0\xAD\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBB"],
        ["\xF3\xB0\xAD\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBB"],

        ["\xF3\xB0\xAD\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBC"],
        ["\xF3\xB0\xAD\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBC"],

        ["\xF3\xB0\xAD\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBD"],
        ["\xF3\xB0\xAD\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBD"],

        ["\xF3\xB0\xAD\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBE"],
        ["\xF3\xB0\xAD\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBE"],

        ["\xF3\xB0\xAD\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBF"],
        ["\xF3\xB0\xAD\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBF"],

        ["\xF3\xB0\xAE\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x80"],
        ["\xF3\xB0\xAE\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x80"],

        ["\xF3\xB0\xAE\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x81"],
        ["\xF3\xB0\xAE\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x81"],

        ["\xF3\xB0\xAE\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x82"],
        ["\xF3\xB0\xAE\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x82"],

        ["\xF3\xB0\xAE\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x83"],
        ["\xF3\xB0\xAE\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x83"],

        ["\xF3\xB0\xAE\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x84"],
        ["\xF3\xB0\xAE\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x84"],

        ["\xF3\xB0\xAE\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x85"],
        ["\xF3\xB0\xAE\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x85"],

        ["\xF3\xB0\xAE\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x86"],
        ["\xF3\xB0\xAE\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x86"],

        ["\xF3\xB0\xAE\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x87"],
        ["\xF3\xB0\xAE\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x87"],

        ["\xF3\xB0\xAE\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x88"],
        ["\xF3\xB0\xAE\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x88"],

        ["\xF3\xB0\xAE\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x89"],
        ["\xF3\xB0\xAE\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x89"],

        ["\xF3\xB0\xAE\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8A"],
        ["\xF3\xB0\xAE\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8A"],

        ["\xF3\xB0\xAE\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8B"],
        ["\xF3\xB0\xAE\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8B"],

        ["\xF3\xB0\xAE\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8C"],
        ["\xF3\xB0\xAE\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8C"],

        ["\xF3\xB0\xAE\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8D"],
        ["\xF3\xB0\xAE\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8D"],

        ["\xF3\xB0\xAE\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8E"],
        ["\xF3\xB0\xAE\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8E"],

        ["\xF3\xB0\xAE\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8F"],
        ["\xF3\xB0\xAE\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8F"],

        ["\xF3\xB0\xAE\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x90"],
        ["\xF3\xB0\xAE\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x90"],

        ["\xF3\xB0\xAE\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x91"],
        ["\xF3\xB0\xAE\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x91"],

        ["\xF3\xB0\xAE\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x92"],
        ["\xF3\xB0\xAE\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x92"],

        ["\xF3\xB0\xAE\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x93"],
        ["\xF3\xB0\xAE\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x93"],

        ["\xF3\xB0\xAE\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x94"],
        ["\xF3\xB0\xAE\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x94"],

        ["\xF3\xB0\xAE\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x95"],
        ["\xF3\xB0\xAE\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x95"],

        ["\xF3\xB0\xAE\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x96"],
        ["\xF3\xB0\xAE\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x96"],

        ["\xF3\xB0\xAE\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x97"],
        ["\xF3\xB0\xAE\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x97"],

        ["\xF3\xB0\xAE\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x98"],
        ["\xF3\xB0\xAE\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x98"],

        ["\xF3\xB0\xAE\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x99"],
        ["\xF3\xB0\xAE\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x99"],

        ["\xF3\xB0\xAE\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9A"],
        ["\xF3\xB0\xAE\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9A"],

        ["\xF3\xB0\xAE\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9B"],
        ["\xF3\xB0\xAE\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9B"],

        ["\xF3\xB0\xAE\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9C"],
        ["\xF3\xB0\xAE\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9C"],

        ["\xF3\xB0\xAE\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9D"],
        ["\xF3\xB0\xAE\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9D"],

        ["\xF3\xB0\xAE\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9E"],
        ["\xF3\xB0\xAE\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9E"],

        ["\xF3\xB0\xAE\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9F"],
        ["\xF3\xB0\xAE\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9F"],

        ["\xF3\xB0\xAE\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA0"],
        ["\xF3\xB0\xAE\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA0"],

        ["\xF3\xB0\xAE\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA1"],
        ["\xF3\xB0\xAE\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA1"],

        ["\xF3\xB0\xAE\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA2"],
        ["\xF3\xB0\xAE\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA2"],

        ["\xF3\xB0\xAE\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA3"],
        ["\xF3\xB0\xAE\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA3"],

        ["\xF3\xB0\xAE\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA4"],
        ["\xF3\xB0\xAE\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA4"],

        ["\xF3\xB0\xAE\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA5"],
        ["\xF3\xB0\xAE\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA5"],

        ["\xF3\xB0\xAE\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA6"],
        ["\xF3\xB0\xAE\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA6"],

        ["\xF3\xB0\xAE\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA7"],
        ["\xF3\xB0\xAE\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA7"],

        ["\xF3\xB0\xAE\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA8"],
        ["\xF3\xB0\xAE\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA8"],

        ["\xF3\xB0\xAE\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA9"],
        ["\xF3\xB0\xAE\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA9"],

        ["\xF3\xB0\xAE\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAA"],
        ["\xF3\xB0\xAE\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAA"],

        ["\xF3\xB0\xAE\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAB"],
        ["\xF3\xB0\xAE\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAB"],

        ["\xF3\xB0\xAE\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAC"],
        ["\xF3\xB0\xAE\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAC"],

        ["\xF3\xB0\xAE\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAD"],
        ["\xF3\xB0\xAE\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAD"],

        ["\xF3\xB0\xAE\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAE"],
        ["\xF3\xB0\xAE\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAE"],

        ["\xF3\xB0\xAE\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAF"],
        ["\xF3\xB0\xAE\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAF"],

        ["\xF3\xB0\xAE\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB0"],
        ["\xF3\xB0\xAE\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB0"],

        ["\xF3\xB0\xAE\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB1"],
        ["\xF3\xB0\xAE\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB1"],

        ["\xF3\xB0\xAE\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB2"],
        ["\xF3\xB0\xAE\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB2"],

        ["\xF3\xB0\xAE\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB3"],
        ["\xF3\xB0\xAE\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB3"],

        ["\xF3\xB0\xAE\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB4"],
        ["\xF3\xB0\xAE\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB4"],

        ["\xF3\xB0\xAE\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB5"],
        ["\xF3\xB0\xAE\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB5"],

        ["\xF3\xB0\xAE\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB6"],
        ["\xF3\xB0\xAE\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB6"],

        ["\xF3\xB0\xAE\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB7"],
        ["\xF3\xB0\xAE\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB7"],

        ["\xF3\xB0\xAE\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB8"],
        ["\xF3\xB0\xAE\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB8"],

        ["\xF3\xB0\xAE\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB9"],
        ["\xF3\xB0\xAE\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB9"],

        ["\xF3\xB0\xAE\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBA"],
        ["\xF3\xB0\xAE\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBA"],

        ["\xF3\xB0\xAE\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBB"],
        ["\xF3\xB0\xAE\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBB"],

        ["\xF3\xB0\xAE\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBC"],
        ["\xF3\xB0\xAE\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBC"],

        ["\xF3\xB0\xAE\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBD"],
        ["\xF3\xB0\xAE\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBD"],

        ["\xF3\xB0\xAE\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBE"],
        ["\xF3\xB0\xAE\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBE"],

        ["\xF3\xB0\xAE\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBF"],
        ["\xF3\xB0\xAE\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBF"],

        ["\xF3\xB0\xAF\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x80"],
        ["\xF3\xB0\xAF\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x80"],

        ["\xF3\xB0\xAF\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x81"],
        ["\xF3\xB0\xAF\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x81"],

        ["\xF3\xB0\xAF\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x82"],
        ["\xF3\xB0\xAF\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x82"],

        ["\xF3\xB0\xAF\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x83"],
        ["\xF3\xB0\xAF\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x83"],

        ["\xF3\xB0\xAF\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x84"],
        ["\xF3\xB0\xAF\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x84"],

        ["\xF3\xB0\xAF\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x85"],
        ["\xF3\xB0\xAF\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x85"],

        ["\xF3\xB0\xAF\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x86"],
        ["\xF3\xB0\xAF\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x86"],

        ["\xF3\xB0\xAF\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x87"],
        ["\xF3\xB0\xAF\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x87"],

        ["\xF3\xB0\xAF\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x88"],
        ["\xF3\xB0\xAF\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x88"],

        ["\xF3\xB0\xAF\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x89"],
        ["\xF3\xB0\xAF\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x89"],

        ["\xF3\xB0\xAF\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8A"],
        ["\xF3\xB0\xAF\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8A"],

        ["\xF3\xB0\xAF\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8B"],
        ["\xF3\xB0\xAF\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8B"],

        ["\xF3\xB0\xAF\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8C"],
        ["\xF3\xB0\xAF\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8C"],

        ["\xF3\xB0\xAF\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8D"],
        ["\xF3\xB0\xAF\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8D"],

        ["\xF3\xB0\xAF\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8E"],
        ["\xF3\xB0\xAF\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8E"],

        ["\xF3\xB0\xAF\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8F"],
        ["\xF3\xB0\xAF\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8F"],

        ["\xF3\xB0\xAF\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x90"],
        ["\xF3\xB0\xAF\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x90"],

        ["\xF3\xB0\xAF\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x91"],
        ["\xF3\xB0\xAF\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x91"],

        ["\xF3\xB0\xAF\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x92"],
        ["\xF3\xB0\xAF\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x92"],

        ["\xF3\xB0\xAF\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x93"],
        ["\xF3\xB0\xAF\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x93"],

        ["\xF3\xB0\xAF\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x94"],
        ["\xF3\xB0\xAF\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x94"],

        ["\xF3\xB0\xAF\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x95"],
        ["\xF3\xB0\xAF\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x95"],

        ["\xF3\xB0\xAF\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x96"],
        ["\xF3\xB0\xAF\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x96"],

        ["\xF3\xB0\xAF\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x97"],
        ["\xF3\xB0\xAF\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x97"],

        ["\xF3\xB0\xAF\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x98"],
        ["\xF3\xB0\xAF\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x98"],

        ["\xF3\xB0\xAF\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x99"],
        ["\xF3\xB0\xAF\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x99"],

        ["\xF3\xB0\xAF\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9A"],
        ["\xF3\xB0\xAF\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9A"],

        ["\xF3\xB0\xAF\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9B"],
        ["\xF3\xB0\xAF\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9B"],

        ["\xF3\xB0\xAF\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9C"],
        ["\xF3\xB0\xAF\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9C"],

        ["\xF3\xB0\xAF\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9D"],
        ["\xF3\xB0\xAF\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9D"],

        ["\xF3\xB0\xAF\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9E"],
        ["\xF3\xB0\xAF\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9E"],

        ["\xF3\xB0\xAF\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9F"],
        ["\xF3\xB0\xAF\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9F"],

        ["\xF3\xB0\xAF\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA0"],
        ["\xF3\xB0\xAF\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA0"],

        ["\xF3\xB0\xAF\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA1"],
        ["\xF3\xB0\xAF\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA1"],

        ["\xF3\xB0\xAF\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA2"],
        ["\xF3\xB0\xAF\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA2"],

        ["\xF3\xB0\xAF\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA3"],
        ["\xF3\xB0\xAF\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA3"],

        ["\xF3\xB0\xAF\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA4"],
        ["\xF3\xB0\xAF\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA4"],

        ["\xF3\xB0\xAF\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA5"],
        ["\xF3\xB0\xAF\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA5"],

        ["\xF3\xB0\xAF\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA6"],
        ["\xF3\xB0\xAF\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA6"],

        ["\xF3\xB0\xAF\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA7"],
        ["\xF3\xB0\xAF\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA7"],

        ["\xF3\xB0\xAF\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA8"],
        ["\xF3\xB0\xAF\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA8"],

        ["\xF3\xB0\xAF\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA9"],
        ["\xF3\xB0\xAF\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA9"],

        ["\xF3\xB0\xAF\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAA"],
        ["\xF3\xB0\xAF\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAA"],

        ["\xF3\xB0\xAF\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAB"],
        ["\xF3\xB0\xAF\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAB"],

        ["\xF3\xB0\xAF\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAC"],
        ["\xF3\xB0\xAF\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAC"],

        ["\xF3\xB0\xAF\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAD"],
        ["\xF3\xB0\xAF\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAD"],

        ["\xF3\xB0\xAF\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAE"],
        ["\xF3\xB0\xAF\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAE"],

        ["\xF3\xB0\xAF\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAF"],
        ["\xF3\xB0\xAF\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAF"],

        ["\xF3\xB0\xAF\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB0"],
        ["\xF3\xB0\xAF\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB0"],

        ["\xF3\xB0\xAF\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB1"],
        ["\xF3\xB0\xAF\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB1"],

        ["\xF3\xB0\xAF\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB2"],
        ["\xF3\xB0\xAF\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB2"],

        ["\xF3\xB0\xAF\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB3"],
        ["\xF3\xB0\xAF\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB3"],

        ["\xF3\xB0\xAF\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB4"],
        ["\xF3\xB0\xAF\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB4"],

        ["\xF3\xB0\xAF\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB5"],
        ["\xF3\xB0\xAF\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB5"],

        ["\xF3\xB0\xAF\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB6"],
        ["\xF3\xB0\xAF\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB6"],

        ["\xF3\xB0\xAF\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB7"],
        ["\xF3\xB0\xAF\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB7"],

        ["\xF3\xB0\xAF\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB8"],
        ["\xF3\xB0\xAF\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB8"],

        ["\xF3\xB0\xAF\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB9"],
        ["\xF3\xB0\xAF\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB9"],

        ["\xF3\xB0\xAF\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBA"],
        ["\xF3\xB0\xAF\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBA"],

        ["\xF3\xB0\xAF\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBB"],
        ["\xF3\xB0\xAF\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBB"],

        ["\xF3\xB0\xAF\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBC"],
        ["\xF3\xB0\xAF\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBC"],

        ["\xF3\xB0\xAF\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBD"],
        ["\xF3\xB0\xAF\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBD"],

        ["\xF3\xB0\xAF\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBE"],
        ["\xF3\xB0\xAF\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBE"],

        ["\xF3\xB0\xAF\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBF"],
        ["\xF3\xB0\xAF\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBF"],

        ["\xF3\xB0\xB0\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x80"],
        ["\xF3\xB0\xB0\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x80"],

        ["\xF3\xB0\xB0\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x81"],
        ["\xF3\xB0\xB0\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x81"],

        ["\xF3\xB0\xB0\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x82"],
        ["\xF3\xB0\xB0\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x82"],

        ["\xF3\xB0\xB0\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x83"],
        ["\xF3\xB0\xB0\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x83"],

        ["\xF3\xB0\xB0\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x84"],
        ["\xF3\xB0\xB0\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x84"],

        ["\xF3\xB0\xB0\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x85"],
        ["\xF3\xB0\xB0\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x85"],

        ["\xF3\xB0\xB0\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x86"],
        ["\xF3\xB0\xB0\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x86"],

        ["\xF3\xB0\xB0\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x87"],
        ["\xF3\xB0\xB0\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x87"],

        ["\xF3\xB0\xB0\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x88"],
        ["\xF3\xB0\xB0\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x88"],

        ["\xF3\xB0\xB0\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x89"],
        ["\xF3\xB0\xB0\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x89"],

        ["\xF3\xB0\xB0\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8A"],
        ["\xF3\xB0\xB0\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8A"],

        ["\xF3\xB0\xB0\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8B"],
        ["\xF3\xB0\xB0\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8B"],

        ["\xF3\xB0\xB0\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8C"],
        ["\xF3\xB0\xB0\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8C"],

        ["\xF3\xB0\xB0\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8D"],
        ["\xF3\xB0\xB0\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8D"],

        ["\xF3\xB0\xB0\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8E"],
        ["\xF3\xB0\xB0\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8E"],

        ["\xF3\xB0\xB0\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8F"],
        ["\xF3\xB0\xB0\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8F"],

        ["\xF3\xB0\xB0\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x90"],
        ["\xF3\xB0\xB0\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x90"],

        ["\xF3\xB0\xB0\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x91"],
        ["\xF3\xB0\xB0\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x91"],

        ["\xF3\xB0\xB0\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x92"],
        ["\xF3\xB0\xB0\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x92"],

        ["\xF3\xB0\xB0\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x93"],
        ["\xF3\xB0\xB0\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x93"],

        ["\xF3\xB0\xB0\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x94"],
        ["\xF3\xB0\xB0\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x94"],

        ["\xF3\xB0\xB0\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x95"],
        ["\xF3\xB0\xB0\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x95"],

        ["\xF3\xB0\xB0\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x96"],
        ["\xF3\xB0\xB0\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x96"],

        ["\xF3\xB0\xB0\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x97"],
        ["\xF3\xB0\xB0\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x97"],

        ["\xF3\xB0\xB0\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x98"],
        ["\xF3\xB0\xB0\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x98"],

        ["\xF3\xB0\xB0\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x99"],
        ["\xF3\xB0\xB0\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x99"],

        ["\xF3\xB0\xB0\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9A"],
        ["\xF3\xB0\xB0\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9A"],

        ["\xF3\xB0\xB0\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9B"],
        ["\xF3\xB0\xB0\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9B"],

        ["\xF3\xB0\xB0\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9C"],
        ["\xF3\xB0\xB0\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9C"],

        ["\xF3\xB0\xB0\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9D"],
        ["\xF3\xB0\xB0\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9D"],

        ["\xF3\xB0\xB0\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9E"],
        ["\xF3\xB0\xB0\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9E"],

        ["\xF3\xB0\xB0\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9F"],
        ["\xF3\xB0\xB0\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9F"],

        ["\xF3\xB0\xB0\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA0"],
        ["\xF3\xB0\xB0\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA0"],

        ["\xF3\xB0\xB0\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA1"],
        ["\xF3\xB0\xB0\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA1"],

        ["\xF3\xB0\xB0\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA2"],
        ["\xF3\xB0\xB0\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA2"],

        ["\xF3\xB0\xB0\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA3"],
        ["\xF3\xB0\xB0\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA3"],

        ["\xF3\xB0\xB0\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA4"],
        ["\xF3\xB0\xB0\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA4"],

        ["\xF3\xB0\xB0\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA5"],
        ["\xF3\xB0\xB0\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA5"],

        ["\xF3\xB0\xB0\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA6"],
        ["\xF3\xB0\xB0\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA6"],

        ["\xF3\xB0\xB0\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA7"],
        ["\xF3\xB0\xB0\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA7"],

        ["\xF3\xB0\xB0\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA8"],
        ["\xF3\xB0\xB0\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA8"],

        ["\xF3\xB0\xB0\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA9"],
        ["\xF3\xB0\xB0\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA9"],

        ["\xF3\xB0\xB0\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAA"],
        ["\xF3\xB0\xB0\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAA"],

        ["\xF3\xB0\xB0\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAB"],
        ["\xF3\xB0\xB0\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAB"],

        ["\xF3\xB0\xB0\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAC"],
        ["\xF3\xB0\xB0\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAC"],

        ["\xF3\xB0\xB0\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAD"],
        ["\xF3\xB0\xB0\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAD"],

        ["\xF3\xB0\xB0\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAE"],
        ["\xF3\xB0\xB0\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAE"],

        ["\xF3\xB0\xB0\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAF"],
        ["\xF3\xB0\xB0\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAF"],

        ["\xF3\xB0\xB0\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB0"],
        ["\xF3\xB0\xB0\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB0"],

        ["\xF3\xB0\xB0\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB1"],
        ["\xF3\xB0\xB0\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB1"],

        ["\xF3\xB0\xB0\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB2"],
        ["\xF3\xB0\xB0\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB2"],

        ["\xF3\xB0\xB0\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB3"],
        ["\xF3\xB0\xB0\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB3"],

        ["\xF3\xB0\xB0\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB4"],
        ["\xF3\xB0\xB0\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB4"],

        ["\xF3\xB0\xB0\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB5"],
        ["\xF3\xB0\xB0\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB5"],

        ["\xF3\xB0\xB0\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB6"],
        ["\xF3\xB0\xB0\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB6"],

        ["\xF3\xB0\xB0\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB7"],
        ["\xF3\xB0\xB0\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB7"],

        ["\xF3\xB0\xB0\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB8"],
        ["\xF3\xB0\xB0\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB8"],

        ["\xF3\xB0\xB0\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB9"],
        ["\xF3\xB0\xB0\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB9"],

        ["\xF3\xB0\xB0\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBA"],
        ["\xF3\xB0\xB0\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBA"],

        ["\xF3\xB0\xB0\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBB"],
        ["\xF3\xB0\xB0\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBB"],

        ["\xF3\xB0\xB0\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBC"],
        ["\xF3\xB0\xB0\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBC"],

        ["\xF3\xB0\xB0\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBD"],
        ["\xF3\xB0\xB0\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBD"],

        ["\xF3\xB0\xB0\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBE"],
        ["\xF3\xB0\xB0\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBE"],

        ["\xF3\xB0\xB0\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBF"],
        ["\xF3\xB0\xB0\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBF"],

        ["\xF3\xB0\xB1\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x80"],
        ["\xF3\xB0\xB1\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x80"],

        ["\xF3\xB0\xB1\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x81"],
        ["\xF3\xB0\xB1\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x81"],

        ["\xF3\xB0\xB1\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x82"],
        ["\xF3\xB0\xB1\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x82"],

        ["\xF3\xB0\xB1\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x83"],
        ["\xF3\xB0\xB1\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x83"],

        ["\xF3\xB0\xB1\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x84"],
        ["\xF3\xB0\xB1\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x84"],

        ["\xF3\xB0\xB1\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x85"],
        ["\xF3\xB0\xB1\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x85"],

        ["\xF3\xB0\xB1\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x86"],
        ["\xF3\xB0\xB1\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x86"],

        ["\xF3\xB0\xB1\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x87"],
        ["\xF3\xB0\xB1\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x87"],

        ["\xF3\xB0\xB1\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x88"],
        ["\xF3\xB0\xB1\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x88"],

        ["\xF3\xB0\xB1\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x89"],
        ["\xF3\xB0\xB1\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x89"],

        ["\xF3\xB0\xB1\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8A"],
        ["\xF3\xB0\xB1\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8A"],

        ["\xF3\xB0\xB1\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8B"],
        ["\xF3\xB0\xB1\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8B"],

        ["\xF3\xB0\xB1\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8C"],
        ["\xF3\xB0\xB1\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8C"],

        ["\xF3\xB0\xB1\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8D"],
        ["\xF3\xB0\xB1\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8D"],

        ["\xF3\xB0\xB1\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8E"],
        ["\xF3\xB0\xB1\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8E"],

        ["\xF3\xB0\xB1\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8F"],
        ["\xF3\xB0\xB1\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8F"],

        ["\xF3\xB0\xB1\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x90"],
        ["\xF3\xB0\xB1\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x90"],

        ["\xF3\xB0\xB1\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x91"],
        ["\xF3\xB0\xB1\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x91"],

        ["\xF3\xB0\xB1\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x92"],
        ["\xF3\xB0\xB1\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x92"],

        ["\xF3\xB0\xB1\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x93"],
        ["\xF3\xB0\xB1\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x93"],

        ["\xF3\xB0\xB1\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x94"],
        ["\xF3\xB0\xB1\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x94"],

        ["\xF3\xB0\xB1\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x95"],
        ["\xF3\xB0\xB1\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x95"],

        ["\xF3\xB0\xB1\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x96"],
        ["\xF3\xB0\xB1\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x96"],

        ["\xF3\xB0\xB1\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x97"],
        ["\xF3\xB0\xB1\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x97"],

        ["\xF3\xB0\xB1\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x98"],
        ["\xF3\xB0\xB1\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x98"],

        ["\xF3\xB0\xB1\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x99"],
        ["\xF3\xB0\xB1\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x99"],

        ["\xF3\xB0\xB1\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9A"],
        ["\xF3\xB0\xB1\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9A"],

        ["\xF3\xB0\xB1\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9B"],
        ["\xF3\xB0\xB1\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9B"],

        ["\xF3\xB0\xB1\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9C"],
        ["\xF3\xB0\xB1\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9C"],

        ["\xF3\xB0\xB1\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9D"],
        ["\xF3\xB0\xB1\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9D"],

        ["\xF3\xB0\xB1\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9E"],
        ["\xF3\xB0\xB1\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9E"],

        ["\xF3\xB0\xB1\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9F"],
        ["\xF3\xB0\xB1\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9F"],

        ["\xF3\xB0\xB1\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA0"],
        ["\xF3\xB0\xB1\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA0"],

        ["\xF3\xB0\xB1\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA1"],
        ["\xF3\xB0\xB1\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA1"],

        ["\xF3\xB0\xB1\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA2"],
        ["\xF3\xB0\xB1\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA2"],

        ["\xF3\xB0\xB1\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA3"],
        ["\xF3\xB0\xB1\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA3"],

        ["\xF3\xB0\xB1\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA4"],
        ["\xF3\xB0\xB1\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA4"],

        ["\xF3\xB0\xB1\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA5"],
        ["\xF3\xB0\xB1\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA5"],

        ["\xF3\xB0\xB1\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA6"],
        ["\xF3\xB0\xB1\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA6"],

        ["\xF3\xB0\xB1\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA7"],
        ["\xF3\xB0\xB1\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA7"],

        ["\xF3\xB0\xB1\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA8"],
        ["\xF3\xB0\xB1\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA8"],

        ["\xF3\xB0\xB1\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA9"],
        ["\xF3\xB0\xB1\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA9"],

        ["\xF3\xB0\xB1\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAA"],
        ["\xF3\xB0\xB1\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAA"],

        ["\xF3\xB0\xB1\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAB"],
        ["\xF3\xB0\xB1\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAB"],

        ["\xF3\xB0\xB1\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAC"],
        ["\xF3\xB0\xB1\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAC"],

        ["\xF3\xB0\xB1\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAD"],
        ["\xF3\xB0\xB1\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAD"],

        ["\xF3\xB0\xB1\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAE"],
        ["\xF3\xB0\xB1\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAE"],

        ["\xF3\xB0\xB1\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAF"],
        ["\xF3\xB0\xB1\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAF"],

        ["\xF3\xB0\xB1\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB0"],
        ["\xF3\xB0\xB1\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB0"],

        ["\xF3\xB0\xB1\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB1"],
        ["\xF3\xB0\xB1\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB1"],

        ["\xF3\xB0\xB1\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB2"],
        ["\xF3\xB0\xB1\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB2"],

        ["\xF3\xB0\xB1\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB3"],
        ["\xF3\xB0\xB1\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB3"],

        ["\xF3\xB0\xB1\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB4"],
        ["\xF3\xB0\xB1\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB4"],

        ["\xF3\xB0\xB1\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB5"],
        ["\xF3\xB0\xB1\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB5"],

        ["\xF3\xB0\xB1\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB6"],
        ["\xF3\xB0\xB1\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB6"],

        ["\xF3\xB0\xB1\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB7"],
        ["\xF3\xB0\xB1\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB7"],

        ["\xF3\xB0\xB1\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB8"],
        ["\xF3\xB0\xB1\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB8"],

        ["\xF3\xB0\xB1\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB9"],
        ["\xF3\xB0\xB1\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB9"],

        ["\xF3\xB0\xB1\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBA"],
        ["\xF3\xB0\xB1\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBA"],

        ["\xF3\xB0\xB1\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBB"],
        ["\xF3\xB0\xB1\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBB"],

        ["\xF3\xB0\xB1\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBC"],
        ["\xF3\xB0\xB1\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBC"],

        ["\xF3\xB0\xB1\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBD"],
        ["\xF3\xB0\xB1\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBD"],

        ["\xF3\xB0\xB1\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBE"],
        ["\xF3\xB0\xB1\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBE"],

        ["\xF3\xB0\xB1\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBF"],
        ["\xF3\xB0\xB1\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBF"],

        ["\xF3\xB0\xB2\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x80"],
        ["\xF3\xB0\xB2\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x80"],

        ["\xF3\xB0\xB2\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x81"],
        ["\xF3\xB0\xB2\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x81"],

        ["\xF3\xB0\xB2\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x82"],
        ["\xF3\xB0\xB2\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x82"],

        ["\xF3\xB0\xB2\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x83"],
        ["\xF3\xB0\xB2\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x83"],

        ["\xF3\xB0\xB2\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x84"],
        ["\xF3\xB0\xB2\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x84"],

        ["\xF3\xB0\xB2\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x85"],
        ["\xF3\xB0\xB2\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x85"],

        ["\xF3\xB0\xB2\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x86"],
        ["\xF3\xB0\xB2\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x86"],

        ["\xF3\xB0\xB2\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x87"],
        ["\xF3\xB0\xB2\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x87"],

        ["\xF3\xB0\xB2\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x88"],
        ["\xF3\xB0\xB2\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x88"],

        ["\xF3\xB0\xB2\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x89"],
        ["\xF3\xB0\xB2\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x89"],

        ["\xF3\xB0\xB2\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8A"],
        ["\xF3\xB0\xB2\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8A"],

        ["\xF3\xB0\xB2\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8B"],
        ["\xF3\xB0\xB2\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8B"],

        ["\xF3\xB0\xB2\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8C"],
        ["\xF3\xB0\xB2\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8C"],

        ["\xF3\xB0\xB2\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8D"],
        ["\xF3\xB0\xB2\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8D"],

        ["\xF3\xB0\xB2\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8E"],
        ["\xF3\xB0\xB2\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8E"],

        ["\xF3\xB0\xB2\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8F"],
        ["\xF3\xB0\xB2\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8F"],

        ["\xF3\xB0\xB2\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x90"],
        ["\xF3\xB0\xB2\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x90"],

        ["\xF3\xB0\xB2\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x91"],
        ["\xF3\xB0\xB2\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x91"],

        ["\xF3\xB0\xB2\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x92"],
        ["\xF3\xB0\xB2\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x92"],

        ["\xF3\xB0\xB2\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x93"],
        ["\xF3\xB0\xB2\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x93"],

        ["\xF3\xB0\xB2\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x94"],
        ["\xF3\xB0\xB2\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x94"],

        ["\xF3\xB0\xB2\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x95"],
        ["\xF3\xB0\xB2\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x95"],

        ["\xF3\xB0\xB2\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x96"],
        ["\xF3\xB0\xB2\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x96"],

        ["\xF3\xB0\xB2\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x97"],
        ["\xF3\xB0\xB2\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x97"],

        ["\xF3\xB0\xB2\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x98"],
        ["\xF3\xB0\xB2\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x98"],

        ["\xF3\xB0\xB2\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x99"],
        ["\xF3\xB0\xB2\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x99"],

        ["\xF3\xB0\xB2\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9A"],
        ["\xF3\xB0\xB2\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9A"],

        ["\xF3\xB0\xB2\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9B"],
        ["\xF3\xB0\xB2\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9B"],

        ["\xF3\xB0\xB2\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9C"],
        ["\xF3\xB0\xB2\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9C"],

        ["\xF3\xB0\xB2\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9D"],
        ["\xF3\xB0\xB2\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9D"],

        ["\xF3\xB0\xB2\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9E"],
        ["\xF3\xB0\xB2\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9E"],

        ["\xF3\xB0\xB2\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9F"],
        ["\xF3\xB0\xB2\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9F"],

        ["\xF3\xB0\xB2\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA0"],
        ["\xF3\xB0\xB2\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA0"],

        ["\xF3\xB0\xB2\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA1"],
        ["\xF3\xB0\xB2\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA1"],

        ["\xF3\xB0\xB2\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA2"],
        ["\xF3\xB0\xB2\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA2"],

        ["\xF3\xB0\xB2\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA3"],
        ["\xF3\xB0\xB2\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA3"],

        ["\xF3\xB0\xB2\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA4"],
        ["\xF3\xB0\xB2\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA4"],

        ["\xF3\xB0\xB2\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA5"],
        ["\xF3\xB0\xB2\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA5"],

        ["\xF3\xB0\xB2\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA6"],
        ["\xF3\xB0\xB2\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA6"],

        ["\xF3\xB0\xB2\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA7"],
        ["\xF3\xB0\xB2\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA7"],

        ["\xF3\xB0\xB2\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA8"],
        ["\xF3\xB0\xB2\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA8"],

        ["\xF3\xB0\xB2\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA9"],
        ["\xF3\xB0\xB2\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA9"],

        ["\xF3\xB0\xB2\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAA"],
        ["\xF3\xB0\xB2\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAA"],

        ["\xF3\xB0\xB2\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAB"],
        ["\xF3\xB0\xB2\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAB"],

        ["\xF3\xB0\xB2\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAC"],
        ["\xF3\xB0\xB2\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAC"],

        ["\xF3\xB0\xB2\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAD"],
        ["\xF3\xB0\xB2\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAD"],

        ["\xF3\xB0\xB2\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAE"],
        ["\xF3\xB0\xB2\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAE"],

        ["\xF3\xB0\xB2\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAF"],
        ["\xF3\xB0\xB2\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAF"],

        ["\xF3\xB0\xB2\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB0"],
        ["\xF3\xB0\xB2\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB0"],

        ["\xF3\xB0\xB2\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB1"],
        ["\xF3\xB0\xB2\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB1"],

        ["\xF3\xB0\xB2\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB2"],
        ["\xF3\xB0\xB2\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB2"],

        ["\xF3\xB0\xB2\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB3"],
        ["\xF3\xB0\xB2\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB3"],

        ["\xF3\xB0\xB2\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB4"],
        ["\xF3\xB0\xB2\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB4"],

        ["\xF3\xB0\xB2\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB5"],
        ["\xF3\xB0\xB2\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB5"],

        ["\xF3\xB0\xB2\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB6"],
        ["\xF3\xB0\xB2\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB6"],

        ["\xF3\xB0\xB2\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB7"],
        ["\xF3\xB0\xB2\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB7"],

        ["\xF3\xB0\xB2\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB8"],
        ["\xF3\xB0\xB2\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB8"],

        ["\xF3\xB0\xB2\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB9"],
        ["\xF3\xB0\xB2\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB9"],

        ["\xF3\xB0\xB2\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBA"],
        ["\xF3\xB0\xB2\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBA"],

        ["\xF3\xB0\xB2\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBB"],
        ["\xF3\xB0\xB2\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBB"],

        ["\xF3\xB0\xB2\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBC"],
        ["\xF3\xB0\xB2\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBC"],

        ["\xF3\xB0\xB2\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBD"],
        ["\xF3\xB0\xB2\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBD"],

        ["\xF3\xB0\xB2\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBE"],
        ["\xF3\xB0\xB2\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBE"],

        ["\xF3\xB0\xB2\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBF"],
        ["\xF3\xB0\xB2\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBF"],

        ["\xF3\xB0\xB3\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x80"],
        ["\xF3\xB0\xB3\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x80"],

        ["\xF3\xB0\xB3\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x81"],
        ["\xF3\xB0\xB3\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x81"],

        ["\xF3\xB0\xB3\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x82"],
        ["\xF3\xB0\xB3\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x82"],

        ["\xF3\xB0\xB3\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x83"],
        ["\xF3\xB0\xB3\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x83"],

        ["\xF3\xB0\xB3\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x84"],
        ["\xF3\xB0\xB3\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x84"],

        ["\xF3\xB0\xB3\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x85"],
        ["\xF3\xB0\xB3\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x85"],

        ["\xF3\xB0\xB3\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x86"],
        ["\xF3\xB0\xB3\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x86"],

        ["\xF3\xB0\xB3\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x87"],
        ["\xF3\xB0\xB3\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x87"],

        ["\xF3\xB0\xB3\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x88"],
        ["\xF3\xB0\xB3\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x88"],

        ["\xF3\xB0\xB3\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x89"],
        ["\xF3\xB0\xB3\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x89"],

        ["\xF3\xB0\xB3\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8A"],
        ["\xF3\xB0\xB3\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8A"],

        ["\xF3\xB0\xB3\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8B"],
        ["\xF3\xB0\xB3\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8B"],

        ["\xF3\xB0\xB3\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8C"],
        ["\xF3\xB0\xB3\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8C"],

        ["\xF3\xB0\xB3\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8D"],
        ["\xF3\xB0\xB3\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8D"],

        ["\xF3\xB0\xB3\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8E"],
        ["\xF3\xB0\xB3\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8E"],

        ["\xF3\xB0\xB3\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8F"],
        ["\xF3\xB0\xB3\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8F"],

        ["\xF3\xB0\xB3\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x90"],
        ["\xF3\xB0\xB3\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x90"],

        ["\xF3\xB0\xB3\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x91"],
        ["\xF3\xB0\xB3\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x91"],

        ["\xF3\xB0\xB3\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x92"],
        ["\xF3\xB0\xB3\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x92"],

        ["\xF3\xB0\xB3\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x93"],
        ["\xF3\xB0\xB3\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x93"],

        ["\xF3\xB0\xB3\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x94"],
        ["\xF3\xB0\xB3\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x94"],

        ["\xF3\xB0\xB3\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x95"],
        ["\xF3\xB0\xB3\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x95"],

        ["\xF3\xB0\xB3\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x96"],
        ["\xF3\xB0\xB3\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x96"],

        ["\xF3\xB0\xB3\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x97"],
        ["\xF3\xB0\xB3\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x97"],

        ["\xF3\xB0\xB3\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x98"],
        ["\xF3\xB0\xB3\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x98"],

        ["\xF3\xB0\xB3\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x99"],
        ["\xF3\xB0\xB3\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x99"],

        ["\xF3\xB0\xB3\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9A"],
        ["\xF3\xB0\xB3\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9A"],

        ["\xF3\xB0\xB3\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9B"],
        ["\xF3\xB0\xB3\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9B"],

        ["\xF3\xB0\xB3\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9C"],
        ["\xF3\xB0\xB3\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9C"],

        ["\xF3\xB0\xB3\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9D"],
        ["\xF3\xB0\xB3\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9D"],

        ["\xF3\xB0\xB3\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9E"],
        ["\xF3\xB0\xB3\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9E"],

        ["\xF3\xB0\xB3\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9F"],
        ["\xF3\xB0\xB3\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9F"],

        ["\xF3\xB0\xB3\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA0"],
        ["\xF3\xB0\xB3\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA0"],

        ["\xF3\xB0\xB3\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA1"],
        ["\xF3\xB0\xB3\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA1"],

        ["\xF3\xB0\xB3\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA2"],
        ["\xF3\xB0\xB3\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA2"],

        ["\xF3\xB0\xB3\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA3"],
        ["\xF3\xB0\xB3\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA3"],

        ["\xF3\xB0\xB3\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA4"],
        ["\xF3\xB0\xB3\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA4"],

        ["\xF3\xB0\xB3\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA5"],
        ["\xF3\xB0\xB3\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA5"],

        ["\xF3\xB0\xB3\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA6"],
        ["\xF3\xB0\xB3\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA6"],

        ["\xF3\xB0\xB3\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA7"],
        ["\xF3\xB0\xB3\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA7"],

        ["\xF3\xB0\xB3\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA8"],
        ["\xF3\xB0\xB3\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA8"],

        ["\xF3\xB0\xB3\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA9"],
        ["\xF3\xB0\xB3\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA9"],

        ["\xF3\xB0\xB3\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAA"],
        ["\xF3\xB0\xB3\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAA"],

        ["\xF3\xB0\xB3\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAB"],
        ["\xF3\xB0\xB3\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAB"],

        ["\xF3\xB0\xB3\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAC"],
        ["\xF3\xB0\xB3\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAC"],

        ["\xF3\xB0\xB3\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAD"],
        ["\xF3\xB0\xB3\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAD"],

        ["\xF3\xB0\xB3\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAE"],
        ["\xF3\xB0\xB3\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAE"],

        ["\xF3\xB0\xB3\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAF"],
        ["\xF3\xB0\xB3\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAF"],

        ["\xF3\xB0\xB3\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB0"],
        ["\xF3\xB0\xB3\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB0"],

        ["\xF3\xB0\xB3\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB1"],
        ["\xF3\xB0\xB3\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB1"],

        ["\xF3\xB0\xB3\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB2"],
        ["\xF3\xB0\xB3\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB2"],

        ["\xF3\xB0\xB3\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB3"],
        ["\xF3\xB0\xB3\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB3"],

        ["\xF3\xB0\xB3\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB4"],
        ["\xF3\xB0\xB3\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB4"],

        ["\xF3\xB0\xB3\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB5"],
        ["\xF3\xB0\xB3\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB5"],

        ["\xF3\xB0\xB3\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB6"],
        ["\xF3\xB0\xB3\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB6"],

        ["\xF3\xB0\xB3\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB7"],
        ["\xF3\xB0\xB3\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB7"],

        ["\xF3\xB0\xB3\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB8"],
        ["\xF3\xB0\xB3\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB8"],

        ["\xF3\xB0\xB3\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB9"],
        ["\xF3\xB0\xB3\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB9"],

        ["\xF3\xB0\xB3\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBA"],
        ["\xF3\xB0\xB3\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBA"],

        ["\xF3\xB0\xB3\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBB"],
        ["\xF3\xB0\xB3\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBB"],

        ["\xF3\xB0\xB3\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBC"],
        ["\xF3\xB0\xB3\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBC"],

        ["\xF3\xB0\xB3\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBD"],
        ["\xF3\xB0\xB3\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBD"],

        ["\xF3\xB0\xB3\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBE"],
        ["\xF3\xB0\xB3\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBE"],

        ["\xF3\xB0\xB3\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBF"],
        ["\xF3\xB0\xB3\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBF"],

        ["\xF3\xB0\xB4\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x80"],
        ["\xF3\xB0\xB4\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x80"],

        ["\xF3\xB0\xB4\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x81"],
        ["\xF3\xB0\xB4\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x81"],

        ["\xF3\xB0\xB4\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x82"],
        ["\xF3\xB0\xB4\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x82"],

        ["\xF3\xB0\xB4\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x83"],
        ["\xF3\xB0\xB4\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x83"],

        ["\xF3\xB0\xB4\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x84"],
        ["\xF3\xB0\xB4\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x84"],

        ["\xF3\xB0\xB4\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x85"],
        ["\xF3\xB0\xB4\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x85"],

        ["\xF3\xB0\xB4\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x86"],
        ["\xF3\xB0\xB4\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x86"],

        ["\xF3\xB0\xB4\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x87"],
        ["\xF3\xB0\xB4\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x87"],

        ["\xF3\xB0\xB4\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x88"],
        ["\xF3\xB0\xB4\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x88"],

        ["\xF3\xB0\xB4\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x89"],
        ["\xF3\xB0\xB4\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x89"],

        ["\xF3\xB0\xB4\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8A"],
        ["\xF3\xB0\xB4\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8A"],

        ["\xF3\xB0\xB4\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8B"],
        ["\xF3\xB0\xB4\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8B"],

        ["\xF3\xB0\xB4\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8C"],
        ["\xF3\xB0\xB4\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8C"],

        ["\xF3\xB0\xB4\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8D"],
        ["\xF3\xB0\xB4\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8D"],

        ["\xF3\xB0\xB4\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8E"],
        ["\xF3\xB0\xB4\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8E"],

        ["\xF3\xB0\xB4\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8F"],
        ["\xF3\xB0\xB4\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8F"],

        ["\xF3\xB0\xB4\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x90"],
        ["\xF3\xB0\xB4\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x90"],

        ["\xF3\xB0\xB4\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x91"],
        ["\xF3\xB0\xB4\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x91"],

        ["\xF3\xB0\xB4\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x92"],
        ["\xF3\xB0\xB4\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x92"],

        ["\xF3\xB0\xB4\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x93"],
        ["\xF3\xB0\xB4\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x93"],

        ["\xF3\xB0\xB4\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x94"],
        ["\xF3\xB0\xB4\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x94"],

        ["\xF3\xB0\xB4\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x95"],
        ["\xF3\xB0\xB4\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x95"],

        ["\xF3\xB0\xB4\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x96"],
        ["\xF3\xB0\xB4\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x96"],

        ["\xF3\xB0\xB4\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x97"],
        ["\xF3\xB0\xB4\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x97"],

        ["\xF3\xB0\xB4\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x98"],
        ["\xF3\xB0\xB4\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x98"],

        ["\xF3\xB0\xB4\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x99"],
        ["\xF3\xB0\xB4\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x99"],

        ["\xF3\xB0\xB4\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9A"],
        ["\xF3\xB0\xB4\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9A"],

        ["\xF3\xB0\xB4\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9B"],
        ["\xF3\xB0\xB4\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9B"],

        ["\xF3\xB0\xB4\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9C"],
        ["\xF3\xB0\xB4\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9C"],

        ["\xF3\xB0\xB4\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9D"],
        ["\xF3\xB0\xB4\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9D"],

        ["\xF3\xB0\xB4\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9E"],
        ["\xF3\xB0\xB4\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9E"],

        ["\xF3\xB0\xB4\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9F"],
        ["\xF3\xB0\xB4\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9F"],

        ["\xF3\xB0\xB4\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA0"],
        ["\xF3\xB0\xB4\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA0"],

        ["\xF3\xB0\xB4\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA1"],
        ["\xF3\xB0\xB4\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA1"],

        ["\xF3\xB0\xB4\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA2"],
        ["\xF3\xB0\xB4\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA2"],

        ["\xF3\xB0\xB4\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA3"],
        ["\xF3\xB0\xB4\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA3"],

        ["\xF3\xB0\xB4\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA4"],
        ["\xF3\xB0\xB4\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA4"],

        ["\xF3\xB0\xB4\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA5"],
        ["\xF3\xB0\xB4\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA5"],

        ["\xF3\xB0\xB4\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA6"],
        ["\xF3\xB0\xB4\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA6"],

        ["\xF3\xB0\xB4\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA7"],
        ["\xF3\xB0\xB4\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA7"],

        ["\xF3\xB0\xB4\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA8"],
        ["\xF3\xB0\xB4\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA8"],

        ["\xF3\xB0\xB4\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA9"],
        ["\xF3\xB0\xB4\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA9"],

        ["\xF3\xB0\xB4\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAA"],
        ["\xF3\xB0\xB4\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAA"],

        ["\xF3\xB0\xB4\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAB"],
        ["\xF3\xB0\xB4\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAB"],

        ["\xF3\xB0\xB4\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAC"],
        ["\xF3\xB0\xB4\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAC"],

        ["\xF3\xB0\xB4\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAD"],
        ["\xF3\xB0\xB4\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAD"],

        ["\xF3\xB0\xB4\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAE"],
        ["\xF3\xB0\xB4\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAE"],

        ["\xF3\xB0\xB4\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAF"],
        ["\xF3\xB0\xB4\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAF"],

        ["\xF3\xB0\xB4\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB0"],
        ["\xF3\xB0\xB4\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB0"],

        ["\xF3\xB0\xB4\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB1"],
        ["\xF3\xB0\xB4\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB1"],

        ["\xF3\xB0\xB4\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB2"],
        ["\xF3\xB0\xB4\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB2"],

        ["\xF3\xB0\xB4\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB3"],
        ["\xF3\xB0\xB4\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB3"],

        ["\xF3\xB0\xB4\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB4"],
        ["\xF3\xB0\xB4\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB4"],

        ["\xF3\xB0\xB4\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB5"],
        ["\xF3\xB0\xB4\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB5"],

        ["\xF3\xB0\xB4\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB6"],
        ["\xF3\xB0\xB4\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB6"],

        ["\xF3\xB0\xB4\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB7"],
        ["\xF3\xB0\xB4\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB7"],

        ["\xF3\xB0\xB4\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB8"],
        ["\xF3\xB0\xB4\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB8"],

        ["\xF3\xB0\xB4\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB9"],
        ["\xF3\xB0\xB4\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB9"],

        ["\xF3\xB0\xB4\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBA"],
        ["\xF3\xB0\xB4\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBA"],

        ["\xF3\xB0\xB4\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBB"],
        ["\xF3\xB0\xB4\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBB"],

        ["\xF3\xB0\xB4\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBC"],
        ["\xF3\xB0\xB4\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBC"],

        ["\xF3\xB0\xB4\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBD"],
        ["\xF3\xB0\xB4\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBD"],

        ["\xF3\xB0\xB4\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBE"],
        ["\xF3\xB0\xB4\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBE"],

        ["\xF3\xB0\xB4\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBF"],
        ["\xF3\xB0\xB4\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBF"],

        ["\xF3\xB0\xB5\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x80"],
        ["\xF3\xB0\xB5\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x80"],

        ["\xF3\xB0\xB5\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x81"],
        ["\xF3\xB0\xB5\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x81"],

        ["\xF3\xB0\xB5\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x82"],
        ["\xF3\xB0\xB5\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x82"],

        ["\xF3\xB0\xB5\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x83"],
        ["\xF3\xB0\xB5\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x83"],

        ["\xF3\xB0\xB5\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x84"],
        ["\xF3\xB0\xB5\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x84"],

        ["\xF3\xB0\xB5\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x85"],
        ["\xF3\xB0\xB5\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x85"],

        ["\xF3\xB0\xB5\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x86"],
        ["\xF3\xB0\xB5\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x86"],

        ["\xF3\xB0\xB5\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x87"],
        ["\xF3\xB0\xB5\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x87"],

        ["\xF3\xB0\xB5\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x88"],
        ["\xF3\xB0\xB5\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x88"],

        ["\xF3\xB0\xB5\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x89"],
        ["\xF3\xB0\xB5\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x89"],

        ["\xF3\xB0\xB5\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8A"],
        ["\xF3\xB0\xB5\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8A"],

        ["\xF3\xB0\xB5\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8B"],
        ["\xF3\xB0\xB5\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8B"],

        ["\xF3\xB0\xB5\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8C"],
        ["\xF3\xB0\xB5\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8C"],

        ["\xF3\xB0\xB5\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8D"],
        ["\xF3\xB0\xB5\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8D"],

        ["\xF3\xB0\xB5\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8E"],
        ["\xF3\xB0\xB5\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8E"],

        ["\xF3\xB0\xB5\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8F"],
        ["\xF3\xB0\xB5\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8F"],

        ["\xF3\xB0\xB5\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x90"],
        ["\xF3\xB0\xB5\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x90"],

        ["\xF3\xB0\xB5\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x91"],
        ["\xF3\xB0\xB5\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x91"],

        ["\xF3\xB0\xB5\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x92"],
        ["\xF3\xB0\xB5\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x92"],

        ["\xF3\xB0\xB5\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x93"],
        ["\xF3\xB0\xB5\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x93"],

        ["\xF3\xB0\xB5\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x94"],
        ["\xF3\xB0\xB5\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x94"],

        ["\xF3\xB0\xB5\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x95"],
        ["\xF3\xB0\xB5\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x95"],

        ["\xF3\xB0\xB5\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x96"],
        ["\xF3\xB0\xB5\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x96"],

        ["\xF3\xB0\xB5\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x97"],
        ["\xF3\xB0\xB5\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x97"],

        ["\xF3\xB0\xB5\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x98"],
        ["\xF3\xB0\xB5\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x98"],

        ["\xF3\xB0\xB5\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x99"],
        ["\xF3\xB0\xB5\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x99"],

        ["\xF3\xB0\xB5\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9A"],
        ["\xF3\xB0\xB5\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9A"],

        ["\xF3\xB0\xB5\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9B"],
        ["\xF3\xB0\xB5\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9B"],

        ["\xF3\xB0\xB5\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9C"],
        ["\xF3\xB0\xB5\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9C"],

        ["\xF3\xB0\xB5\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9D"],
        ["\xF3\xB0\xB5\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9D"],

        ["\xF3\xB0\xB5\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9E"],
        ["\xF3\xB0\xB5\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9E"],

        ["\xF3\xB0\xB5\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9F"],
        ["\xF3\xB0\xB5\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9F"],

        ["\xF3\xB0\xB5\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA0"],
        ["\xF3\xB0\xB5\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA0"],

        ["\xF3\xB0\xB5\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA1"],
        ["\xF3\xB0\xB5\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA1"],

        ["\xF3\xB0\xB5\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA2"],
        ["\xF3\xB0\xB5\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA2"],

        ["\xF3\xB0\xB5\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA3"],
        ["\xF3\xB0\xB5\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA3"],

        ["\xF3\xB0\xB5\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA4"],
        ["\xF3\xB0\xB5\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA4"],

        ["\xF3\xB0\xB5\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA5"],
        ["\xF3\xB0\xB5\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA5"],

        ["\xF3\xB0\xB5\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA6"],
        ["\xF3\xB0\xB5\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA6"],

        ["\xF3\xB0\xB5\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA7"],
        ["\xF3\xB0\xB5\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA7"],

        ["\xF3\xB0\xB5\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA8"],
        ["\xF3\xB0\xB5\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA8"],

        ["\xF3\xB0\xB5\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA9"],
        ["\xF3\xB0\xB5\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA9"],

        ["\xF3\xB0\xB5\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAA"],
        ["\xF3\xB0\xB5\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAA"],

        ["\xF3\xB0\xB5\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAB"],
        ["\xF3\xB0\xB5\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAB"],

        ["\xF3\xB0\xB5\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAC"],
        ["\xF3\xB0\xB5\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAC"],

        ["\xF3\xB0\xB5\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAD"],
        ["\xF3\xB0\xB5\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAD"],

        ["\xF3\xB0\xB5\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAE"],
        ["\xF3\xB0\xB5\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAE"],

        ["\xF3\xB0\xB5\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAF"],
        ["\xF3\xB0\xB5\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAF"],

        ["\xF3\xB0\xB5\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB0"],
        ["\xF3\xB0\xB5\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB0"],

        ["\xF3\xB0\xB5\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB1"],
        ["\xF3\xB0\xB5\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB1"],

        ["\xF3\xB0\xB5\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB2"],
        ["\xF3\xB0\xB5\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB2"],

        ["\xF3\xB0\xB5\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB3"],
        ["\xF3\xB0\xB5\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB3"],

        ["\xF3\xB0\xB5\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB4"],
        ["\xF3\xB0\xB5\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB4"],

        ["\xF3\xB0\xB5\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB5"],
        ["\xF3\xB0\xB5\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB5"],

        ["\xF3\xB0\xB5\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB6"],
        ["\xF3\xB0\xB5\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB6"],

        ["\xF3\xB0\xB5\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB7"],
        ["\xF3\xB0\xB5\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB7"],

        ["\xF3\xB0\xB5\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB8"],
        ["\xF3\xB0\xB5\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB8"],

        ["\xF3\xB0\xB5\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB9"],
        ["\xF3\xB0\xB5\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB9"],

        ["\xF3\xB0\xB5\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBA"],
        ["\xF3\xB0\xB5\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBA"],

        ["\xF3\xB0\xB5\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBB"],
        ["\xF3\xB0\xB5\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBB"],

        ["\xF3\xB0\xB5\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBC"],
        ["\xF3\xB0\xB5\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBC"],

        ["\xF3\xB0\xB5\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBD"],
        ["\xF3\xB0\xB5\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBD"],

        ["\xF3\xB0\xB5\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBE"],
        ["\xF3\xB0\xB5\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBE"],

        ["\xF3\xB0\xB5\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBF"],
        ["\xF3\xB0\xB5\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBF"],

        ["\xF3\xB0\xB6\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x80"],
        ["\xF3\xB0\xB6\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x80"],

        ["\xF3\xB0\xB6\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x81"],
        ["\xF3\xB0\xB6\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x81"],

        ["\xF3\xB0\xB6\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x82"],
        ["\xF3\xB0\xB6\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x82"],

        ["\xF3\xB0\xB6\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x83"],
        ["\xF3\xB0\xB6\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x83"],

        ["\xF3\xB0\xB6\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x84"],
        ["\xF3\xB0\xB6\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x84"],

        ["\xF3\xB0\xB6\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x85"],
        ["\xF3\xB0\xB6\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x85"],

        ["\xF3\xB0\xB6\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x86"],
        ["\xF3\xB0\xB6\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x86"],

        ["\xF3\xB0\xB6\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x87"],
        ["\xF3\xB0\xB6\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x87"],

        ["\xF3\xB0\xB6\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x88"],
        ["\xF3\xB0\xB6\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x88"],

        ["\xF3\xB0\xB6\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x89"],
        ["\xF3\xB0\xB6\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x89"],

        ["\xF3\xB0\xB6\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8A"],
        ["\xF3\xB0\xB6\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8A"],

        ["\xF3\xB0\xB6\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8B"],
        ["\xF3\xB0\xB6\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8B"],

        ["\xF3\xB0\xB6\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8C"],
        ["\xF3\xB0\xB6\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8C"],

        ["\xF3\xB0\xB6\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8D"],
        ["\xF3\xB0\xB6\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8D"],

        ["\xF3\xB0\xB6\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8E"],
        ["\xF3\xB0\xB6\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8E"],

        ["\xF3\xB0\xB6\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8F"],
        ["\xF3\xB0\xB6\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8F"],

        ["\xF3\xB0\xB6\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x90"],
        ["\xF3\xB0\xB6\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x90"],

        ["\xF3\xB0\xB6\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x91"],
        ["\xF3\xB0\xB6\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x91"],

        ["\xF3\xB0\xB6\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x92"],
        ["\xF3\xB0\xB6\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x92"],

        ["\xF3\xB0\xB6\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x93"],
        ["\xF3\xB0\xB6\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x93"],

        ["\xF3\xB0\xB6\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x94"],
        ["\xF3\xB0\xB6\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x94"],

        ["\xF3\xB0\xB6\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x95"],
        ["\xF3\xB0\xB6\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x95"],

        ["\xF3\xB0\xB6\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x96"],
        ["\xF3\xB0\xB6\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x96"],

        ["\xF3\xB0\xB6\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x97"],
        ["\xF3\xB0\xB6\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x97"],

        ["\xF3\xB0\xB6\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x98"],
        ["\xF3\xB0\xB6\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x98"],

        ["\xF3\xB0\xB6\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x99"],
        ["\xF3\xB0\xB6\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x99"],

        ["\xF3\xB0\xB6\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9A"],
        ["\xF3\xB0\xB6\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9A"],

        ["\xF3\xB0\xB6\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9B"],
        ["\xF3\xB0\xB6\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9B"],

        ["\xF3\xB0\xB6\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9C"],
        ["\xF3\xB0\xB6\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9C"],

        ["\xF3\xB0\xB6\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9D"],
        ["\xF3\xB0\xB6\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9D"],

        ["\xF3\xB0\xB6\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9E"],
        ["\xF3\xB0\xB6\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9E"],

        ["\xF3\xB0\xB6\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9F"],
        ["\xF3\xB0\xB6\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9F"],

        ["\xF3\xB0\xB6\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA0"],
        ["\xF3\xB0\xB6\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA0"],

        ["\xF3\xB0\xB6\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA1"],
        ["\xF3\xB0\xB6\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA1"],

        ["\xF3\xB0\xB6\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA2"],
        ["\xF3\xB0\xB6\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA2"],

        ["\xF3\xB0\xB6\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA3"],
        ["\xF3\xB0\xB6\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA3"],

        ["\xF3\xB0\xB6\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA4"],
        ["\xF3\xB0\xB6\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA4"],

        ["\xF3\xB0\xB6\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA5"],
        ["\xF3\xB0\xB6\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA5"],

        ["\xF3\xB0\xB6\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA6"],
        ["\xF3\xB0\xB6\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA6"],

        ["\xF3\xB0\xB6\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA7"],
        ["\xF3\xB0\xB6\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA7"],

        ["\xF3\xB0\xB6\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA8"],
        ["\xF3\xB0\xB6\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA8"],

        ["\xF3\xB0\xB6\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA9"],
        ["\xF3\xB0\xB6\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA9"],

        ["\xF3\xB0\xB6\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAA"],
        ["\xF3\xB0\xB6\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAA"],

        ["\xF3\xB0\xB6\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAB"],
        ["\xF3\xB0\xB6\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAB"],

        ["\xF3\xB0\xB6\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAC"],
        ["\xF3\xB0\xB6\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAC"],

        ["\xF3\xB0\xB6\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAD"],
        ["\xF3\xB0\xB6\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAD"],

        ["\xF3\xB0\xB6\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAE"],
        ["\xF3\xB0\xB6\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAE"],

        ["\xF3\xB0\xB6\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAF"],
        ["\xF3\xB0\xB6\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAF"],

        ["\xF3\xB0\xB6\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB0"],
        ["\xF3\xB0\xB6\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB0"],

        ["\xF3\xB0\xB6\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB1"],
        ["\xF3\xB0\xB6\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB1"],

        ["\xF3\xB0\xB6\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB2"],
        ["\xF3\xB0\xB6\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB2"],

        ["\xF3\xB0\xB6\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB3"],
        ["\xF3\xB0\xB6\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB3"],

        ["\xF3\xB0\xB6\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB4"],
        ["\xF3\xB0\xB6\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB4"],

        ["\xF3\xB0\xB6\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB5"],
        ["\xF3\xB0\xB6\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB5"],

        ["\xF3\xB0\xB6\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB6"],
        ["\xF3\xB0\xB6\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB6"],

        ["\xF3\xB0\xB6\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB7"],
        ["\xF3\xB0\xB6\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB7"],

        ["\xF3\xB0\xB6\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB8"],
        ["\xF3\xB0\xB6\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB8"],

        ["\xF3\xB0\xB6\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB9"],
        ["\xF3\xB0\xB6\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB9"],

        ["\xF3\xB0\xB6\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBA"],
        ["\xF3\xB0\xB6\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBA"],

        ["\xF3\xB0\xB6\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBB"],
        ["\xF3\xB0\xB6\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBB"],

        ["\xF3\xB0\xB6\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBC"],
        ["\xF3\xB0\xB6\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBC"],

        ["\xF3\xB0\xB6\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBD"],
        ["\xF3\xB0\xB6\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBD"],

        ["\xF3\xB0\xB6\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBE"],
        ["\xF3\xB0\xB6\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBE"],

        ["\xF3\xB0\xB6\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBF"],
        ["\xF3\xB0\xB6\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBF"],

        ["\xF3\xB0\xB7\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x80"],
        ["\xF3\xB0\xB7\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x80"],

        ["\xF3\xB0\xB7\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x81"],
        ["\xF3\xB0\xB7\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x81"],

        ["\xF3\xB0\xB7\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x82"],
        ["\xF3\xB0\xB7\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x82"],

        ["\xF3\xB0\xB7\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x83"],
        ["\xF3\xB0\xB7\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x83"],

        ["\xF3\xB0\xB7\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x84"],
        ["\xF3\xB0\xB7\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x84"],

        ["\xF3\xB0\xB7\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x85"],
        ["\xF3\xB0\xB7\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x85"],

        ["\xF3\xB0\xB7\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x86"],
        ["\xF3\xB0\xB7\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x86"],

        ["\xF3\xB0\xB7\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x87"],
        ["\xF3\xB0\xB7\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x87"],

        ["\xF3\xB0\xB7\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x88"],
        ["\xF3\xB0\xB7\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x88"],

        ["\xF3\xB0\xB7\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x89"],
        ["\xF3\xB0\xB7\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x89"],

        ["\xF3\xB0\xB7\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8A"],
        ["\xF3\xB0\xB7\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8A"],

        ["\xF3\xB0\xB7\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8B"],
        ["\xF3\xB0\xB7\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8B"],

        ["\xF3\xB0\xB7\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8C"],
        ["\xF3\xB0\xB7\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8C"],

        ["\xF3\xB0\xB7\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8D"],
        ["\xF3\xB0\xB7\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8D"],

        ["\xF3\xB0\xB7\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8E"],
        ["\xF3\xB0\xB7\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8E"],

        ["\xF3\xB0\xB7\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8F"],
        ["\xF3\xB0\xB7\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8F"],

        ["\xF3\xB0\xB7\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x90"],
        ["\xF3\xB0\xB7\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x90"],

        ["\xF3\xB0\xB7\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x91"],
        ["\xF3\xB0\xB7\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x91"],

        ["\xF3\xB0\xB7\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x92"],
        ["\xF3\xB0\xB7\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x92"],

        ["\xF3\xB0\xB7\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x93"],
        ["\xF3\xB0\xB7\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x93"],

        ["\xF3\xB0\xB7\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x94"],
        ["\xF3\xB0\xB7\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x94"],

        ["\xF3\xB0\xB7\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x95"],
        ["\xF3\xB0\xB7\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x95"],

        ["\xF3\xB0\xB7\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x96"],
        ["\xF3\xB0\xB7\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x96"],

        ["\xF3\xB0\xB7\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x97"],
        ["\xF3\xB0\xB7\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x97"],

        ["\xF3\xB0\xB7\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x98"],
        ["\xF3\xB0\xB7\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x98"],

        ["\xF3\xB0\xB7\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x99"],
        ["\xF3\xB0\xB7\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x99"],

        ["\xF3\xB0\xB7\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9A"],
        ["\xF3\xB0\xB7\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9A"],

        ["\xF3\xB0\xB7\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9B"],
        ["\xF3\xB0\xB7\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9B"],

        ["\xF3\xB0\xB7\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9C"],
        ["\xF3\xB0\xB7\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9C"],

        ["\xF3\xB0\xB7\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9D"],
        ["\xF3\xB0\xB7\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9D"],

        ["\xF3\xB0\xB7\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9E"],
        ["\xF3\xB0\xB7\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9E"],

        ["\xF3\xB0\xB7\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9F"],
        ["\xF3\xB0\xB7\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9F"],

        ["\xF3\xB0\xB7\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA0"],
        ["\xF3\xB0\xB7\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA0"],

        ["\xF3\xB0\xB7\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA1"],
        ["\xF3\xB0\xB7\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA1"],

        ["\xF3\xB0\xB7\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA2"],
        ["\xF3\xB0\xB7\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA2"],

        ["\xF3\xB0\xB7\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA3"],
        ["\xF3\xB0\xB7\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA3"],

        ["\xF3\xB0\xB7\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA4"],
        ["\xF3\xB0\xB7\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA4"],

        ["\xF3\xB0\xB7\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA5"],
        ["\xF3\xB0\xB7\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA5"],

        ["\xF3\xB0\xB7\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA6"],
        ["\xF3\xB0\xB7\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA6"],

        ["\xF3\xB0\xB7\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA7"],
        ["\xF3\xB0\xB7\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA7"],

        ["\xF3\xB0\xB7\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA8"],
        ["\xF3\xB0\xB7\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA8"],

        ["\xF3\xB0\xB7\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA9"],
        ["\xF3\xB0\xB7\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA9"],

        ["\xF3\xB0\xB7\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAA"],
        ["\xF3\xB0\xB7\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAA"],

        ["\xF3\xB0\xB7\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAB"],
        ["\xF3\xB0\xB7\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAB"],

        ["\xF3\xB0\xB7\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAC"],
        ["\xF3\xB0\xB7\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAC"],

        ["\xF3\xB0\xB7\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAD"],
        ["\xF3\xB0\xB7\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAD"],

        ["\xF3\xB0\xB7\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAE"],
        ["\xF3\xB0\xB7\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAE"],

        ["\xF3\xB0\xB7\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAF"],
        ["\xF3\xB0\xB7\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAF"],

        ["\xF3\xB0\xB7\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB0"],
        ["\xF3\xB0\xB7\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB0"],

        ["\xF3\xB0\xB7\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB1"],
        ["\xF3\xB0\xB7\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB1"],

        ["\xF3\xB0\xB7\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB2"],
        ["\xF3\xB0\xB7\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB2"],

        ["\xF3\xB0\xB7\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB3"],
        ["\xF3\xB0\xB7\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB3"],

        ["\xF3\xB0\xB7\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB4"],
        ["\xF3\xB0\xB7\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB4"],

        ["\xF3\xB0\xB7\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB5"],
        ["\xF3\xB0\xB7\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB5"],

        ["\xF3\xB0\xB7\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB6"],
        ["\xF3\xB0\xB7\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB6"],

        ["\xF3\xB0\xB7\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB7"],
        ["\xF3\xB0\xB7\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB7"],

        ["\xF3\xB0\xB7\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB8"],
        ["\xF3\xB0\xB7\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB8"],

        ["\xF3\xB0\xB7\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB9"],
        ["\xF3\xB0\xB7\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB9"],

        ["\xF3\xB0\xB7\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBA"],
        ["\xF3\xB0\xB7\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBA"],

        ["\xF3\xB0\xB7\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBB"],
        ["\xF3\xB0\xB7\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBB"],

        ["\xF3\xB0\xB7\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBC"],
        ["\xF3\xB0\xB7\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBC"],

        ["\xF3\xB0\xB7\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBD"],
        ["\xF3\xB0\xB7\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBD"],

        ["\xF3\xB0\xB7\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBE"],
        ["\xF3\xB0\xB7\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBE"],

        ["\xF3\xB0\xB7\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBF"],
        ["\xF3\xB0\xB7\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBF"],

        ["\xF3\xB0\xB8\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x80"],
        ["\xF3\xB0\xB8\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x80"],

        ["\xF3\xB0\xB8\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x81"],
        ["\xF3\xB0\xB8\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x81"],

        ["\xF3\xB0\xB8\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x82"],
        ["\xF3\xB0\xB8\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x82"],

        ["\xF3\xB0\xB8\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x83"],
        ["\xF3\xB0\xB8\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x83"],

        ["\xF3\xB0\xB8\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x84"],
        ["\xF3\xB0\xB8\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x84"],

        ["\xF3\xB0\xB8\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x85"],
        ["\xF3\xB0\xB8\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x85"],

        ["\xF3\xB0\xB8\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x86"],
        ["\xF3\xB0\xB8\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x86"],

        ["\xF3\xB0\xB8\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x87"],
        ["\xF3\xB0\xB8\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x87"],

        ["\xF3\xB0\xB8\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x88"],
        ["\xF3\xB0\xB8\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x88"],

        ["\xF3\xB0\xB8\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x89"],
        ["\xF3\xB0\xB8\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x89"],

        ["\xF3\xB0\xB8\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8A"],
        ["\xF3\xB0\xB8\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8A"],

        ["\xF3\xB0\xB8\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8B"],
        ["\xF3\xB0\xB8\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8B"],

        ["\xF3\xB0\xB8\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8C"],
        ["\xF3\xB0\xB8\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8C"],

        ["\xF3\xB0\xB8\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8D"],
        ["\xF3\xB0\xB8\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8D"],

        ["\xF3\xB0\xB8\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8E"],
        ["\xF3\xB0\xB8\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8E"],

        ["\xF3\xB0\xB8\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8F"],
        ["\xF3\xB0\xB8\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8F"],

        ["\xF3\xB0\xB8\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x90"],
        ["\xF3\xB0\xB8\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x90"],

        ["\xF3\xB0\xB8\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x91"],
        ["\xF3\xB0\xB8\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x91"],

        ["\xF3\xB0\xB8\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x92"],
        ["\xF3\xB0\xB8\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x92"],

        ["\xF3\xB0\xB8\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x93"],
        ["\xF3\xB0\xB8\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x93"],

        ["\xF3\xB0\xB8\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x94"],
        ["\xF3\xB0\xB8\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x94"],

        ["\xF3\xB0\xB8\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x95"],
        ["\xF3\xB0\xB8\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x95"],

        ["\xF3\xB0\xB8\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x96"],
        ["\xF3\xB0\xB8\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x96"],

        ["\xF3\xB0\xB8\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x97"],
        ["\xF3\xB0\xB8\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x97"],

        ["\xF3\xB0\xB8\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x98"],
        ["\xF3\xB0\xB8\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x98"],

        ["\xF3\xB0\xB8\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x99"],
        ["\xF3\xB0\xB8\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x99"],

        ["\xF3\xB0\xB8\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9A"],
        ["\xF3\xB0\xB8\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9A"],

        ["\xF3\xB0\xB8\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9B"],
        ["\xF3\xB0\xB8\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9B"],

        ["\xF3\xB0\xB8\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9C"],
        ["\xF3\xB0\xB8\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9C"],

        ["\xF3\xB0\xB8\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9D"],
        ["\xF3\xB0\xB8\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9D"],

        ["\xF3\xB0\xB8\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9E"],
        ["\xF3\xB0\xB8\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9E"],

        ["\xF3\xB0\xB8\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9F"],
        ["\xF3\xB0\xB8\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9F"],

        ["\xF3\xB0\xB8\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA0"],
        ["\xF3\xB0\xB8\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA0"],

        ["\xF3\xB0\xB8\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA1"],
        ["\xF3\xB0\xB8\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA1"],

        ["\xF3\xB0\xB8\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA2"],
        ["\xF3\xB0\xB8\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA2"],

        ["\xF3\xB0\xB8\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA3"],
        ["\xF3\xB0\xB8\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA3"],

        ["\xF3\xB0\xB8\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA4"],
        ["\xF3\xB0\xB8\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA4"],

        ["\xF3\xB0\xB8\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA5"],
        ["\xF3\xB0\xB8\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA5"],

        ["\xF3\xB0\xB8\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA6"],
        ["\xF3\xB0\xB8\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA6"],

        ["\xF3\xB0\xB8\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA7"],
        ["\xF3\xB0\xB8\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA7"],

        ["\xF3\xB0\xB8\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA8"],
        ["\xF3\xB0\xB8\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA8"],

        ["\xF3\xB0\xB8\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA9"],
        ["\xF3\xB0\xB8\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA9"],

        ["\xF3\xB0\xB8\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAA"],
        ["\xF3\xB0\xB8\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAA"],

        ["\xF3\xB0\xB8\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAB"],
        ["\xF3\xB0\xB8\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAB"],

        ["\xF3\xB0\xB8\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAC"],
        ["\xF3\xB0\xB8\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAC"],

        ["\xF3\xB0\xB8\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAD"],
        ["\xF3\xB0\xB8\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAD"],

        ["\xF3\xB0\xB8\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAE"],
        ["\xF3\xB0\xB8\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAE"],

        ["\xF3\xB0\xB8\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAF"],
        ["\xF3\xB0\xB8\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAF"],

        ["\xF3\xB0\xB8\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB0"],
        ["\xF3\xB0\xB8\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB0"],

        ["\xF3\xB0\xB8\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB1"],
        ["\xF3\xB0\xB8\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB1"],

        ["\xF3\xB0\xB8\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB2"],
        ["\xF3\xB0\xB8\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB2"],

        ["\xF3\xB0\xB8\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB3"],
        ["\xF3\xB0\xB8\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB3"],

        ["\xF3\xB0\xB8\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB4"],
        ["\xF3\xB0\xB8\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB4"],

        ["\xF3\xB0\xB8\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB5"],
        ["\xF3\xB0\xB8\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB5"],

        ["\xF3\xB0\xB8\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB6"],
        ["\xF3\xB0\xB8\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB6"],

        ["\xF3\xB0\xB8\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB7"],
        ["\xF3\xB0\xB8\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB7"],

        ["\xF3\xB0\xB8\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB8"],
        ["\xF3\xB0\xB8\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB8"],

        ["\xF3\xB0\xB8\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB9"],
        ["\xF3\xB0\xB8\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB9"],

        ["\xF3\xB0\xB8\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBA"],
        ["\xF3\xB0\xB8\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBA"],

        ["\xF3\xB0\xB8\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBB"],
        ["\xF3\xB0\xB8\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBB"],

        ["\xF3\xB0\xB8\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBC"],
        ["\xF3\xB0\xB8\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBC"],

        ["\xF3\xB0\xB8\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBD"],
        ["\xF3\xB0\xB8\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBD"],

        ["\xF3\xB0\xB8\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBE"],
        ["\xF3\xB0\xB8\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBE"],

        ["\xF3\xB0\xB8\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBF"],
        ["\xF3\xB0\xB8\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBF"],

        ["\xF3\xB0\xB9\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x80"],
        ["\xF3\xB0\xB9\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x80"],

        ["\xF3\xB0\xB9\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x81"],
        ["\xF3\xB0\xB9\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x81"],

        ["\xF3\xB0\xB9\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x82"],
        ["\xF3\xB0\xB9\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x82"],

        ["\xF3\xB0\xB9\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x83"],
        ["\xF3\xB0\xB9\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x83"],

        ["\xF3\xB0\xB9\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x84"],
        ["\xF3\xB0\xB9\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x84"],

        ["\xF3\xB0\xB9\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x85"],
        ["\xF3\xB0\xB9\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x85"],

        ["\xF3\xB0\xB9\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x86"],
        ["\xF3\xB0\xB9\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x86"],

        ["\xF3\xB0\xB9\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x87"],
        ["\xF3\xB0\xB9\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x87"],

        ["\xF3\xB0\xB9\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x88"],
        ["\xF3\xB0\xB9\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x88"],

        ["\xF3\xB0\xB9\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x89"],
        ["\xF3\xB0\xB9\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x89"],

        ["\xF3\xB0\xB9\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8A"],
        ["\xF3\xB0\xB9\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8A"],

        ["\xF3\xB0\xB9\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8B"],
        ["\xF3\xB0\xB9\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8B"],

        ["\xF3\xB0\xB9\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8C"],
        ["\xF3\xB0\xB9\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8C"],

        ["\xF3\xB0\xB9\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8D"],
        ["\xF3\xB0\xB9\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8D"],

        ["\xF3\xB0\xB9\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8E"],
        ["\xF3\xB0\xB9\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8E"],

        ["\xF3\xB0\xB9\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8F"],
        ["\xF3\xB0\xB9\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8F"],

        ["\xF3\xB0\xB9\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x90"],
        ["\xF3\xB0\xB9\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x90"],

        ["\xF3\xB0\xB9\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x91"],
        ["\xF3\xB0\xB9\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x91"],

        ["\xF3\xB0\xB9\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x92"],
        ["\xF3\xB0\xB9\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x92"],

        ["\xF3\xB0\xB9\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x93"],
        ["\xF3\xB0\xB9\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x93"],

        ["\xF3\xB0\xB9\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x94"],
        ["\xF3\xB0\xB9\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x94"],

        ["\xF3\xB0\xB9\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x95"],
        ["\xF3\xB0\xB9\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x95"],

        ["\xF3\xB0\xB9\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x96"],
        ["\xF3\xB0\xB9\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x96"],

        ["\xF3\xB0\xB9\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x97"],
        ["\xF3\xB0\xB9\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x97"],

        ["\xF3\xB0\xB9\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x98"],
        ["\xF3\xB0\xB9\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x98"],

        ["\xF3\xB0\xB9\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x99"],
        ["\xF3\xB0\xB9\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x99"],

        ["\xF3\xB0\xB9\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9A"],
        ["\xF3\xB0\xB9\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9A"],

        ["\xF3\xB0\xB9\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9B"],
        ["\xF3\xB0\xB9\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9B"],

        ["\xF3\xB0\xB9\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9C"],
        ["\xF3\xB0\xB9\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9C"],

        ["\xF3\xB0\xB9\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9D"],
        ["\xF3\xB0\xB9\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9D"],

        ["\xF3\xB0\xB9\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9E"],
        ["\xF3\xB0\xB9\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9E"],

        ["\xF3\xB0\xB9\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9F"],
        ["\xF3\xB0\xB9\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9F"],

        ["\xF3\xB0\xB9\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA0"],
        ["\xF3\xB0\xB9\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA0"],

        ["\xF3\xB0\xB9\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA1"],
        ["\xF3\xB0\xB9\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA1"],

        ["\xF3\xB0\xB9\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA2"],
        ["\xF3\xB0\xB9\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA2"],

        ["\xF3\xB0\xB9\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA3"],
        ["\xF3\xB0\xB9\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA3"],

        ["\xF3\xB0\xB9\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA4"],
        ["\xF3\xB0\xB9\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA4"],

        ["\xF3\xB0\xB9\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA5"],
        ["\xF3\xB0\xB9\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA5"],

        ["\xF3\xB0\xB9\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA6"],
        ["\xF3\xB0\xB9\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA6"],

        ["\xF3\xB0\xB9\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA7"],
        ["\xF3\xB0\xB9\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA7"],

        ["\xF3\xB0\xB9\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA8"],
        ["\xF3\xB0\xB9\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA8"],

        ["\xF3\xB0\xB9\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA9"],
        ["\xF3\xB0\xB9\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA9"],

        ["\xF3\xB0\xB9\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAA"],
        ["\xF3\xB0\xB9\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAA"],

        ["\xF3\xB0\xB9\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAB"],
        ["\xF3\xB0\xB9\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAB"],

        ["\xF3\xB0\xB9\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAC"],
        ["\xF3\xB0\xB9\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAC"],

        ["\xF3\xB0\xB9\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAD"],
        ["\xF3\xB0\xB9\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAD"],

        ["\xF3\xB0\xB9\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAE"],
        ["\xF3\xB0\xB9\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAE"],

        ["\xF3\xB0\xB9\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAF"],
        ["\xF3\xB0\xB9\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAF"],

        ["\xF3\xB0\xB9\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB0"],
        ["\xF3\xB0\xB9\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB0"],

        ["\xF3\xB0\xB9\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB1"],
        ["\xF3\xB0\xB9\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB1"],

        ["\xF3\xB0\xB9\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB2"],
        ["\xF3\xB0\xB9\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB2"],

        ["\xF3\xB0\xB9\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB3"],
        ["\xF3\xB0\xB9\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB3"],

        ["\xF3\xB0\xB9\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB4"],
        ["\xF3\xB0\xB9\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB4"],

        ["\xF3\xB0\xB9\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB5"],
        ["\xF3\xB0\xB9\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB5"],

        ["\xF3\xB0\xB9\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB6"],
        ["\xF3\xB0\xB9\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB6"],

        ["\xF3\xB0\xB9\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB7"],
        ["\xF3\xB0\xB9\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB7"],

        ["\xF3\xB0\xB9\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB8"],
        ["\xF3\xB0\xB9\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB8"],

        ["\xF3\xB0\xB9\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB9"],
        ["\xF3\xB0\xB9\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB9"],

        ["\xF3\xB0\xB9\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBA"],
        ["\xF3\xB0\xB9\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBA"],

        ["\xF3\xB0\xB9\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBB"],
        ["\xF3\xB0\xB9\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBB"],

        ["\xF3\xB0\xB9\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBC"],
        ["\xF3\xB0\xB9\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBC"],

        ["\xF3\xB0\xB9\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBD"],
        ["\xF3\xB0\xB9\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBD"],

        ["\xF3\xB0\xB9\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBE"],
        ["\xF3\xB0\xB9\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBE"],

        ["\xF3\xB0\xB9\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBF"],
        ["\xF3\xB0\xB9\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBF"],

        ["\xF3\xB0\xBA\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x80"],
        ["\xF3\xB0\xBA\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x80"],

        ["\xF3\xB0\xBA\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x81"],
        ["\xF3\xB0\xBA\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x81"],

        ["\xF3\xB0\xBA\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x82"],
        ["\xF3\xB0\xBA\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x82"],

        ["\xF3\xB0\xBA\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x83"],
        ["\xF3\xB0\xBA\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x83"],

        ["\xF3\xB0\xBA\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x84"],
        ["\xF3\xB0\xBA\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x84"],

        ["\xF3\xB0\xBA\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x85"],
        ["\xF3\xB0\xBA\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x85"],

        ["\xF3\xB0\xBA\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x86"],
        ["\xF3\xB0\xBA\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x86"],

        ["\xF3\xB0\xBA\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x87"],
        ["\xF3\xB0\xBA\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x87"],

        ["\xF3\xB0\xBA\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x88"],
        ["\xF3\xB0\xBA\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x88"],

        ["\xF3\xB0\xBA\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x89"],
        ["\xF3\xB0\xBA\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x89"],

        ["\xF3\xB0\xBA\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8A"],
        ["\xF3\xB0\xBA\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8A"],

        ["\xF3\xB0\xBA\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8B"],
        ["\xF3\xB0\xBA\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8B"],

        ["\xF3\xB0\xBA\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8C"],
        ["\xF3\xB0\xBA\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8C"],

        ["\xF3\xB0\xBA\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8D"],
        ["\xF3\xB0\xBA\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8D"],

        ["\xF3\xB0\xBA\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8E"],
        ["\xF3\xB0\xBA\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8E"],

        ["\xF3\xB0\xBA\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8F"],
        ["\xF3\xB0\xBA\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8F"],

        ["\xF3\xB0\xBA\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x90"],
        ["\xF3\xB0\xBA\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x90"],

        ["\xF3\xB0\xBA\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x91"],
        ["\xF3\xB0\xBA\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x91"],

        ["\xF3\xB0\xBA\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x92"],
        ["\xF3\xB0\xBA\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x92"],

        ["\xF3\xB0\xBA\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x93"],
        ["\xF3\xB0\xBA\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x93"],

        ["\xF3\xB0\xBA\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x94"],
        ["\xF3\xB0\xBA\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x94"],

        ["\xF3\xB0\xBA\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x95"],
        ["\xF3\xB0\xBA\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x95"],

        ["\xF3\xB0\xBA\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x96"],
        ["\xF3\xB0\xBA\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x96"],

        ["\xF3\xB0\xBA\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x97"],
        ["\xF3\xB0\xBA\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x97"],

        ["\xF3\xB0\xBA\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x98"],
        ["\xF3\xB0\xBA\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x98"],

        ["\xF3\xB0\xBA\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x99"],
        ["\xF3\xB0\xBA\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x99"],

        ["\xF3\xB0\xBA\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9A"],
        ["\xF3\xB0\xBA\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9A"],

        ["\xF3\xB0\xBA\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9B"],
        ["\xF3\xB0\xBA\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9B"],

        ["\xF3\xB0\xBA\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9C"],
        ["\xF3\xB0\xBA\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9C"],

        ["\xF3\xB0\xBA\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9D"],
        ["\xF3\xB0\xBA\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9D"],

        ["\xF3\xB0\xBA\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9E"],
        ["\xF3\xB0\xBA\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9E"],

        ["\xF3\xB0\xBA\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9F"],
        ["\xF3\xB0\xBA\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9F"],

        ["\xF3\xB0\xBA\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA0"],
        ["\xF3\xB0\xBA\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA0"],

        ["\xF3\xB0\xBA\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA1"],
        ["\xF3\xB0\xBA\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA1"],

        ["\xF3\xB0\xBA\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA2"],
        ["\xF3\xB0\xBA\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA2"],

        ["\xF3\xB0\xBA\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA3"],
        ["\xF3\xB0\xBA\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA3"],

        ["\xF3\xB0\xBA\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA4"],
        ["\xF3\xB0\xBA\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA4"],

        ["\xF3\xB0\xBA\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA5"],
        ["\xF3\xB0\xBA\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA5"],

        ["\xF3\xB0\xBA\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA6"],
        ["\xF3\xB0\xBA\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA6"],

        ["\xF3\xB0\xBA\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA7"],
        ["\xF3\xB0\xBA\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA7"],

        ["\xF3\xB0\xBA\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA8"],
        ["\xF3\xB0\xBA\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA8"],

        ["\xF3\xB0\xBA\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA9"],
        ["\xF3\xB0\xBA\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA9"],

        ["\xF3\xB0\xBA\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAA"],
        ["\xF3\xB0\xBA\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAA"],

        ["\xF3\xB0\xBA\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAB"],
        ["\xF3\xB0\xBA\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAB"],

        ["\xF3\xB0\xBA\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAC"],
        ["\xF3\xB0\xBA\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAC"],

        ["\xF3\xB0\xBA\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAD"],
        ["\xF3\xB0\xBA\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAD"],

        ["\xF3\xB0\xBA\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAE"],
        ["\xF3\xB0\xBA\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAE"],

        ["\xF3\xB0\xBA\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAF"],
        ["\xF3\xB0\xBA\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAF"],

        ["\xF3\xB0\xBA\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB0"],
        ["\xF3\xB0\xBA\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB0"],

        ["\xF3\xB0\xBA\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB1"],
        ["\xF3\xB0\xBA\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB1"],

        ["\xF3\xB0\xBA\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB2"],
        ["\xF3\xB0\xBA\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB2"],

        ["\xF3\xB0\xBA\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB3"],
        ["\xF3\xB0\xBA\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB3"],

        ["\xF3\xB0\xBA\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB4"],
        ["\xF3\xB0\xBA\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB4"],

        ["\xF3\xB0\xBA\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB5"],
        ["\xF3\xB0\xBA\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB5"],

        ["\xF3\xB0\xBA\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB6"],
        ["\xF3\xB0\xBA\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB6"],

        ["\xF3\xB0\xBA\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB7"],
        ["\xF3\xB0\xBA\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB7"],

        ["\xF3\xB0\xBA\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB8"],
        ["\xF3\xB0\xBA\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB8"],

        ["\xF3\xB0\xBA\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB9"],
        ["\xF3\xB0\xBA\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB9"],

        ["\xF3\xB0\xBA\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBA"],
        ["\xF3\xB0\xBA\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBA"],

        ["\xF3\xB0\xBA\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBB"],
        ["\xF3\xB0\xBA\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBB"],

        ["\xF3\xB0\xBA\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBC"],
        ["\xF3\xB0\xBA\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBC"],

        ["\xF3\xB0\xBA\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBD"],
        ["\xF3\xB0\xBA\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBD"],

        ["\xF3\xB0\xBA\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBE"],
        ["\xF3\xB0\xBA\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBE"],

        ["\xF3\xB0\xBA\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBF"],
        ["\xF3\xB0\xBA\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBF"],

        ["\xF3\xB0\xBB\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x80"],
        ["\xF3\xB0\xBB\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x80"],

        ["\xF3\xB0\xBB\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x81"],
        ["\xF3\xB0\xBB\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x81"],

        ["\xF3\xB0\xBB\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x82"],
        ["\xF3\xB0\xBB\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x82"],

        ["\xF3\xB0\xBB\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x83"],
        ["\xF3\xB0\xBB\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x83"],

        ["\xF3\xB0\xBB\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x84"],
        ["\xF3\xB0\xBB\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x84"],

        ["\xF3\xB0\xBB\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x85"],
        ["\xF3\xB0\xBB\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x85"],

        ["\xF3\xB0\xBB\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x86"],
        ["\xF3\xB0\xBB\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x86"],

        ["\xF3\xB0\xBB\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x87"],
        ["\xF3\xB0\xBB\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x87"],

        ["\xF3\xB0\xBB\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x88"],
        ["\xF3\xB0\xBB\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x88"],

        ["\xF3\xB0\xBB\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x89"],
        ["\xF3\xB0\xBB\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x89"],

        ["\xF3\xB0\xBB\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8A"],
        ["\xF3\xB0\xBB\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8A"],

        ["\xF3\xB0\xBB\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8B"],
        ["\xF3\xB0\xBB\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8B"],

        ["\xF3\xB0\xBB\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8C"],
        ["\xF3\xB0\xBB\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8C"],

        ["\xF3\xB0\xBB\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8D"],
        ["\xF3\xB0\xBB\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8D"],

        ["\xF3\xB0\xBB\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8E"],
        ["\xF3\xB0\xBB\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8E"],

        ["\xF3\xB0\xBB\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8F"],
        ["\xF3\xB0\xBB\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8F"],

        ["\xF3\xB0\xBB\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x90"],
        ["\xF3\xB0\xBB\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x90"],

        ["\xF3\xB0\xBB\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x91"],
        ["\xF3\xB0\xBB\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x91"],

        ["\xF3\xB0\xBB\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x92"],
        ["\xF3\xB0\xBB\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x92"],

        ["\xF3\xB0\xBB\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x93"],
        ["\xF3\xB0\xBB\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x93"],

        ["\xF3\xB0\xBB\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x94"],
        ["\xF3\xB0\xBB\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x94"],

        ["\xF3\xB0\xBB\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x95"],
        ["\xF3\xB0\xBB\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x95"],

        ["\xF3\xB0\xBB\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x96"],
        ["\xF3\xB0\xBB\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x96"],

        ["\xF3\xB0\xBB\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x97"],
        ["\xF3\xB0\xBB\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x97"],

        ["\xF3\xB0\xBB\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x98"],
        ["\xF3\xB0\xBB\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x98"],

        ["\xF3\xB0\xBB\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x99"],
        ["\xF3\xB0\xBB\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x99"],

        ["\xF3\xB0\xBB\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9A"],
        ["\xF3\xB0\xBB\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9A"],

        ["\xF3\xB0\xBB\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9B"],
        ["\xF3\xB0\xBB\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9B"],

        ["\xF3\xB0\xBB\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9C"],
        ["\xF3\xB0\xBB\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9C"],

        ["\xF3\xB0\xBB\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9D"],
        ["\xF3\xB0\xBB\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9D"],

        ["\xF3\xB0\xBB\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9E"],
        ["\xF3\xB0\xBB\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9E"],

        ["\xF3\xB0\xBB\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9F"],
        ["\xF3\xB0\xBB\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9F"],

        ["\xF3\xB0\xBB\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA0"],
        ["\xF3\xB0\xBB\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA0"],

        ["\xF3\xB0\xBB\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA1"],
        ["\xF3\xB0\xBB\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA1"],

        ["\xF3\xB0\xBB\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA2"],
        ["\xF3\xB0\xBB\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA2"],

        ["\xF3\xB0\xBB\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA3"],
        ["\xF3\xB0\xBB\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA3"],

        ["\xF3\xB0\xBB\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA4"],
        ["\xF3\xB0\xBB\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA4"],

        ["\xF3\xB0\xBB\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA5"],
        ["\xF3\xB0\xBB\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA5"],

        ["\xF3\xB0\xBB\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA6"],
        ["\xF3\xB0\xBB\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA6"],

        ["\xF3\xB0\xBB\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA7"],
        ["\xF3\xB0\xBB\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA7"],

        ["\xF3\xB0\xBB\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA8"],
        ["\xF3\xB0\xBB\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA8"],

        ["\xF3\xB0\xBB\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA9"],
        ["\xF3\xB0\xBB\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA9"],

        ["\xF3\xB0\xBB\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAA"],
        ["\xF3\xB0\xBB\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAA"],

        ["\xF3\xB0\xBB\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAB"],
        ["\xF3\xB0\xBB\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAB"],

        ["\xF3\xB0\xBB\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAC"],
        ["\xF3\xB0\xBB\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAC"],

        ["\xF3\xB0\xBB\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAD"],
        ["\xF3\xB0\xBB\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAD"],

        ["\xF3\xB0\xBB\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAE"],
        ["\xF3\xB0\xBB\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAE"],

        ["\xF3\xB0\xBB\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAF"],
        ["\xF3\xB0\xBB\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAF"],

        ["\xF3\xB0\xBB\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB0"],
        ["\xF3\xB0\xBB\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB0"],

        ["\xF3\xB0\xBB\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB1"],
        ["\xF3\xB0\xBB\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB1"],

        ["\xF3\xB0\xBB\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB2"],
        ["\xF3\xB0\xBB\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB2"],

        ["\xF3\xB0\xBB\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB3"],
        ["\xF3\xB0\xBB\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB3"],

        ["\xF3\xB0\xBB\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB4"],
        ["\xF3\xB0\xBB\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB4"],

        ["\xF3\xB0\xBB\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB5"],
        ["\xF3\xB0\xBB\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB5"],

        ["\xF3\xB0\xBB\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB6"],
        ["\xF3\xB0\xBB\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB6"],

        ["\xF3\xB0\xBB\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB7"],
        ["\xF3\xB0\xBB\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB7"],

        ["\xF3\xB0\xBB\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB8"],
        ["\xF3\xB0\xBB\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB8"],

        ["\xF3\xB0\xBB\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB9"],
        ["\xF3\xB0\xBB\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB9"],

        ["\xF3\xB0\xBB\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBA"],
        ["\xF3\xB0\xBB\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBA"],

        ["\xF3\xB0\xBB\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBB"],
        ["\xF3\xB0\xBB\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBB"],

        ["\xF3\xB0\xBB\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBC"],
        ["\xF3\xB0\xBB\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBC"],

        ["\xF3\xB0\xBB\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBD"],
        ["\xF3\xB0\xBB\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBD"],

        ["\xF3\xB0\xBB\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBE"],
        ["\xF3\xB0\xBB\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBE"],

        ["\xF3\xB0\xBB\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBF"],
        ["\xF3\xB0\xBB\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBF"],

        ["\xF3\xB0\xBC\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x80"],
        ["\xF3\xB0\xBC\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x80"],

        ["\xF3\xB0\xBC\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x81"],
        ["\xF3\xB0\xBC\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x81"],

        ["\xF3\xB0\xBC\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x82"],
        ["\xF3\xB0\xBC\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x82"],

        ["\xF3\xB0\xBC\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x83"],
        ["\xF3\xB0\xBC\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x83"],

        ["\xF3\xB0\xBC\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x84"],
        ["\xF3\xB0\xBC\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x84"],

        ["\xF3\xB0\xBC\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x85"],
        ["\xF3\xB0\xBC\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x85"],

        ["\xF3\xB0\xBC\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x86"],
        ["\xF3\xB0\xBC\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x86"],

        ["\xF3\xB0\xBC\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x87"],
        ["\xF3\xB0\xBC\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x87"],

        ["\xF3\xB0\xBC\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x88"],
        ["\xF3\xB0\xBC\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x88"],

        ["\xF3\xB0\xBC\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x89"],
        ["\xF3\xB0\xBC\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x89"],

        ["\xF3\xB0\xBC\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8A"],
        ["\xF3\xB0\xBC\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8A"],

        ["\xF3\xB0\xBC\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8B"],
        ["\xF3\xB0\xBC\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8B"],

        ["\xF3\xB0\xBC\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8C"],
        ["\xF3\xB0\xBC\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8C"],

        ["\xF3\xB0\xBC\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8D"],
        ["\xF3\xB0\xBC\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8D"],

        ["\xF3\xB0\xBC\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8E"],
        ["\xF3\xB0\xBC\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8E"],

        ["\xF3\xB0\xBC\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8F"],
        ["\xF3\xB0\xBC\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8F"],

        ["\xF3\xB0\xBC\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x90"],
        ["\xF3\xB0\xBC\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x90"],

        ["\xF3\xB0\xBC\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x91"],
        ["\xF3\xB0\xBC\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x91"],

        ["\xF3\xB0\xBC\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x92"],
        ["\xF3\xB0\xBC\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x92"],

        ["\xF3\xB0\xBC\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x93"],
        ["\xF3\xB0\xBC\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x93"],

        ["\xF3\xB0\xBC\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x94"],
        ["\xF3\xB0\xBC\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x94"],

        ["\xF3\xB0\xBC\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x95"],
        ["\xF3\xB0\xBC\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x95"],

        ["\xF3\xB0\xBC\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x96"],
        ["\xF3\xB0\xBC\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x96"],

        ["\xF3\xB0\xBC\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x97"],
        ["\xF3\xB0\xBC\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x97"],

        ["\xF3\xB0\xBC\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x98"],
        ["\xF3\xB0\xBC\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x98"],

        ["\xF3\xB0\xBC\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x99"],
        ["\xF3\xB0\xBC\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x99"],

        ["\xF3\xB0\xBC\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9A"],
        ["\xF3\xB0\xBC\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9A"],

        ["\xF3\xB0\xBC\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9B"],
        ["\xF3\xB0\xBC\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9B"],

        ["\xF3\xB0\xBC\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9C"],
        ["\xF3\xB0\xBC\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9C"],

        ["\xF3\xB0\xBC\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9D"],
        ["\xF3\xB0\xBC\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9D"],

        ["\xF3\xB0\xBC\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9E"],
        ["\xF3\xB0\xBC\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9E"],

        ["\xF3\xB0\xBC\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9F"],
        ["\xF3\xB0\xBC\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9F"],

        ["\xF3\xB0\xBC\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA0"],
        ["\xF3\xB0\xBC\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA0"],

        ["\xF3\xB0\xBC\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA1"],
        ["\xF3\xB0\xBC\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA1"],

        ["\xF3\xB0\xBC\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA2"],
        ["\xF3\xB0\xBC\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA2"],

        ["\xF3\xB0\xBC\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA3"],
        ["\xF3\xB0\xBC\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA3"],

        ["\xF3\xB0\xBC\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA4"],
        ["\xF3\xB0\xBC\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA4"],

        ["\xF3\xB0\xBC\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA5"],
        ["\xF3\xB0\xBC\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA5"],

        ["\xF3\xB0\xBC\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA6"],
        ["\xF3\xB0\xBC\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA6"],

        ["\xF3\xB0\xBC\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA7"],
        ["\xF3\xB0\xBC\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA7"],

        ["\xF3\xB0\xBC\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA8"],
        ["\xF3\xB0\xBC\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA8"],

        ["\xF3\xB0\xBC\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA9"],
        ["\xF3\xB0\xBC\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA9"],

        ["\xF3\xB0\xBC\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAA"],
        ["\xF3\xB0\xBC\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAA"],

        ["\xF3\xB0\xBC\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAB"],
        ["\xF3\xB0\xBC\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAB"],

        ["\xF3\xB0\xBC\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAC"],
        ["\xF3\xB0\xBC\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAC"],

        ["\xF3\xB0\xBC\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAD"],
        ["\xF3\xB0\xBC\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAD"],

        ["\xF3\xB0\xBC\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAE"],
        ["\xF3\xB0\xBC\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAE"],

        ["\xF3\xB0\xBC\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAF"],
        ["\xF3\xB0\xBC\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAF"],

        ["\xF3\xB0\xBC\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB0"],
        ["\xF3\xB0\xBC\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB0"],

        ["\xF3\xB0\xBC\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB1"],
        ["\xF3\xB0\xBC\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB1"],

        ["\xF3\xB0\xBC\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB2"],
        ["\xF3\xB0\xBC\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB2"],

        ["\xF3\xB0\xBC\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB3"],
        ["\xF3\xB0\xBC\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB3"],

        ["\xF3\xB0\xBC\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB4"],
        ["\xF3\xB0\xBC\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB4"],

        ["\xF3\xB0\xBC\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB5"],
        ["\xF3\xB0\xBC\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB5"],

        ["\xF3\xB0\xBC\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB6"],
        ["\xF3\xB0\xBC\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB6"],

        ["\xF3\xB0\xBC\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB7"],
        ["\xF3\xB0\xBC\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB7"],

        ["\xF3\xB0\xBC\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB8"],
        ["\xF3\xB0\xBC\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB8"],

        ["\xF3\xB0\xBC\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB9"],
        ["\xF3\xB0\xBC\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB9"],

        ["\xF3\xB0\xBC\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBA"],
        ["\xF3\xB0\xBC\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBA"],

        ["\xF3\xB0\xBC\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBB"],
        ["\xF3\xB0\xBC\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBB"],

        ["\xF3\xB0\xBC\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBC"],
        ["\xF3\xB0\xBC\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBC"],

        ["\xF3\xB0\xBC\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBD"],
        ["\xF3\xB0\xBC\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBD"],

        ["\xF3\xB0\xBC\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBE"],
        ["\xF3\xB0\xBC\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBE"],

        ["\xF3\xB0\xBC\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBF"],
        ["\xF3\xB0\xBC\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBF"],

        ["\xF3\xB0\xBD\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x80"],
        ["\xF3\xB0\xBD\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x80"],

        ["\xF3\xB0\xBD\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x81"],
        ["\xF3\xB0\xBD\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x81"],

        ["\xF3\xB0\xBD\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x82"],
        ["\xF3\xB0\xBD\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x82"],

        ["\xF3\xB0\xBD\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x83"],
        ["\xF3\xB0\xBD\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x83"],

        ["\xF3\xB0\xBD\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x84"],
        ["\xF3\xB0\xBD\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x84"],

        ["\xF3\xB0\xBD\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x85"],
        ["\xF3\xB0\xBD\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x85"],

        ["\xF3\xB0\xBD\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x86"],
        ["\xF3\xB0\xBD\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x86"],

        ["\xF3\xB0\xBD\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x87"],
        ["\xF3\xB0\xBD\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x87"],

        ["\xF3\xB0\xBD\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x88"],
        ["\xF3\xB0\xBD\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x88"],

        ["\xF3\xB0\xBD\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x89"],
        ["\xF3\xB0\xBD\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x89"],

        ["\xF3\xB0\xBD\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8A"],
        ["\xF3\xB0\xBD\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8A"],

        ["\xF3\xB0\xBD\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8B"],
        ["\xF3\xB0\xBD\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8B"],

        ["\xF3\xB0\xBD\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8C"],
        ["\xF3\xB0\xBD\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8C"],

        ["\xF3\xB0\xBD\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8D"],
        ["\xF3\xB0\xBD\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8D"],

        ["\xF3\xB0\xBD\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8E"],
        ["\xF3\xB0\xBD\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8E"],

        ["\xF3\xB0\xBD\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8F"],
        ["\xF3\xB0\xBD\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8F"],

        ["\xF3\xB0\xBD\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x90"],
        ["\xF3\xB0\xBD\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x90"],

        ["\xF3\xB0\xBD\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x91"],
        ["\xF3\xB0\xBD\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x91"],

        ["\xF3\xB0\xBD\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x92"],
        ["\xF3\xB0\xBD\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x92"],

        ["\xF3\xB0\xBD\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x93"],
        ["\xF3\xB0\xBD\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x93"],

        ["\xF3\xB0\xBD\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x94"],
        ["\xF3\xB0\xBD\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x94"],

        ["\xF3\xB0\xBD\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x95"],
        ["\xF3\xB0\xBD\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x95"],

        ["\xF3\xB0\xBD\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x96"],
        ["\xF3\xB0\xBD\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x96"],

        ["\xF3\xB0\xBD\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x97"],
        ["\xF3\xB0\xBD\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x97"],

        ["\xF3\xB0\xBD\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x98"],
        ["\xF3\xB0\xBD\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x98"],

        ["\xF3\xB0\xBD\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x99"],
        ["\xF3\xB0\xBD\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x99"],

        ["\xF3\xB0\xBD\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9A"],
        ["\xF3\xB0\xBD\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9A"],

        ["\xF3\xB0\xBD\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9B"],
        ["\xF3\xB0\xBD\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9B"],

        ["\xF3\xB0\xBD\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9C"],
        ["\xF3\xB0\xBD\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9C"],

        ["\xF3\xB0\xBD\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9D"],
        ["\xF3\xB0\xBD\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9D"],

        ["\xF3\xB0\xBD\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9E"],
        ["\xF3\xB0\xBD\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9E"],

        ["\xF3\xB0\xBD\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9F"],
        ["\xF3\xB0\xBD\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9F"],

        ["\xF3\xB0\xBD\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA0"],
        ["\xF3\xB0\xBD\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA0"],

        ["\xF3\xB0\xBD\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA1"],
        ["\xF3\xB0\xBD\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA1"],

        ["\xF3\xB0\xBD\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA2"],
        ["\xF3\xB0\xBD\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA2"],

        ["\xF3\xB0\xBD\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA3"],
        ["\xF3\xB0\xBD\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA3"],

        ["\xF3\xB0\xBD\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA4"],
        ["\xF3\xB0\xBD\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA4"],

        ["\xF3\xB0\xBD\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA5"],
        ["\xF3\xB0\xBD\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA5"],

        ["\xF3\xB0\xBD\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA6"],
        ["\xF3\xB0\xBD\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA6"],

        ["\xF3\xB0\xBD\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA7"],
        ["\xF3\xB0\xBD\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA7"],

        ["\xF3\xB0\xBD\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA8"],
        ["\xF3\xB0\xBD\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA8"],

        ["\xF3\xB0\xBD\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA9"],
        ["\xF3\xB0\xBD\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA9"],

        ["\xF3\xB0\xBD\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAA"],
        ["\xF3\xB0\xBD\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAA"],

        ["\xF3\xB0\xBD\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAB"],
        ["\xF3\xB0\xBD\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAB"],

        ["\xF3\xB0\xBD\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAC"],
        ["\xF3\xB0\xBD\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAC"],

        ["\xF3\xB0\xBD\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAD"],
        ["\xF3\xB0\xBD\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAD"],

        ["\xF3\xB0\xBD\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAE"],
        ["\xF3\xB0\xBD\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAE"],

        ["\xF3\xB0\xBD\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAF"],
        ["\xF3\xB0\xBD\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAF"],

        ["\xF3\xB0\xBD\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB0"],
        ["\xF3\xB0\xBD\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB0"],

        ["\xF3\xB0\xBD\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB1"],
        ["\xF3\xB0\xBD\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB1"],

        ["\xF3\xB0\xBD\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB2"],
        ["\xF3\xB0\xBD\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB2"],

        ["\xF3\xB0\xBD\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB3"],
        ["\xF3\xB0\xBD\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB3"],

        ["\xF3\xB0\xBD\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB4"],
        ["\xF3\xB0\xBD\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB4"],

        ["\xF3\xB0\xBD\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB5"],
        ["\xF3\xB0\xBD\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB5"],

        ["\xF3\xB0\xBD\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB6"],
        ["\xF3\xB0\xBD\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB6"],

        ["\xF3\xB0\xBD\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB7"],
        ["\xF3\xB0\xBD\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB7"],

        ["\xF3\xB0\xBD\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB8"],
        ["\xF3\xB0\xBD\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB8"],

        ["\xF3\xB0\xBD\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB9"],
        ["\xF3\xB0\xBD\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB9"],

        ["\xF3\xB0\xBD\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBA"],
        ["\xF3\xB0\xBD\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBA"],

        ["\xF3\xB0\xBD\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBB"],
        ["\xF3\xB0\xBD\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBB"],

        ["\xF3\xB0\xBD\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBC"],
        ["\xF3\xB0\xBD\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBC"],

        ["\xF3\xB0\xBD\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBD"],
        ["\xF3\xB0\xBD\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBD"],

        ["\xF3\xB0\xBD\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBE"],
        ["\xF3\xB0\xBD\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBE"],

        ["\xF3\xB0\xBD\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBF"],
        ["\xF3\xB0\xBD\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBF"],

        ["\xF3\xB0\xBE\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x80"],
        ["\xF3\xB0\xBE\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x80"],

        ["\xF3\xB0\xBE\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x81"],
        ["\xF3\xB0\xBE\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x81"],

        ["\xF3\xB0\xBE\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x82"],
        ["\xF3\xB0\xBE\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x82"],

        ["\xF3\xB0\xBE\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x83"],
        ["\xF3\xB0\xBE\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x83"],

        ["\xF3\xB0\xBE\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x84"],
        ["\xF3\xB0\xBE\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x84"],

        ["\xF3\xB0\xBE\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x85"],
        ["\xF3\xB0\xBE\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x85"],

        ["\xF3\xB0\xBE\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x86"],
        ["\xF3\xB0\xBE\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x86"],

        ["\xF3\xB0\xBE\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x87"],
        ["\xF3\xB0\xBE\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x87"],

        ["\xF3\xB0\xBE\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x88"],
        ["\xF3\xB0\xBE\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x88"],

        ["\xF3\xB0\xBE\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x89"],
        ["\xF3\xB0\xBE\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x89"],

        ["\xF3\xB0\xBE\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8A"],
        ["\xF3\xB0\xBE\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8A"],

        ["\xF3\xB0\xBE\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8B"],
        ["\xF3\xB0\xBE\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8B"],

        ["\xF3\xB0\xBE\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8C"],
        ["\xF3\xB0\xBE\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8C"],

        ["\xF3\xB0\xBE\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8D"],
        ["\xF3\xB0\xBE\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8D"],

        ["\xF3\xB0\xBE\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8E"],
        ["\xF3\xB0\xBE\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8E"],

        ["\xF3\xB0\xBE\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8F"],
        ["\xF3\xB0\xBE\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8F"],

        ["\xF3\xB0\xBE\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x90"],
        ["\xF3\xB0\xBE\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x90"],

        ["\xF3\xB0\xBE\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x91"],
        ["\xF3\xB0\xBE\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x91"],

        ["\xF3\xB0\xBE\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x92"],
        ["\xF3\xB0\xBE\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x92"],

        ["\xF3\xB0\xBE\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x93"],
        ["\xF3\xB0\xBE\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x93"],

        ["\xF3\xB0\xBE\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x94"],
        ["\xF3\xB0\xBE\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x94"],

        ["\xF3\xB0\xBE\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x95"],
        ["\xF3\xB0\xBE\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x95"],

        ["\xF3\xB0\xBE\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x96"],
        ["\xF3\xB0\xBE\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x96"],

        ["\xF3\xB0\xBE\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x97"],
        ["\xF3\xB0\xBE\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x97"],

        ["\xF3\xB0\xBE\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x98"],
        ["\xF3\xB0\xBE\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x98"],

        ["\xF3\xB0\xBE\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x99"],
        ["\xF3\xB0\xBE\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x99"],

        ["\xF3\xB0\xBE\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9A"],
        ["\xF3\xB0\xBE\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9A"],

        ["\xF3\xB0\xBE\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9B"],
        ["\xF3\xB0\xBE\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9B"],

        ["\xF3\xB0\xBE\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9C"],
        ["\xF3\xB0\xBE\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9C"],

        ["\xF3\xB0\xBE\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9D"],
        ["\xF3\xB0\xBE\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9D"],

        ["\xF3\xB0\xBE\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9E"],
        ["\xF3\xB0\xBE\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9E"],

        ["\xF3\xB0\xBE\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9F"],
        ["\xF3\xB0\xBE\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9F"],

        ["\xF3\xB0\xBE\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA0"],
        ["\xF3\xB0\xBE\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA0"],

        ["\xF3\xB0\xBE\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA1"],
        ["\xF3\xB0\xBE\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA1"],

        ["\xF3\xB0\xBE\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA2"],
        ["\xF3\xB0\xBE\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA2"],

        ["\xF3\xB0\xBE\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA3"],
        ["\xF3\xB0\xBE\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA3"],

        ["\xF3\xB0\xBE\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA4"],
        ["\xF3\xB0\xBE\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA4"],

        ["\xF3\xB0\xBE\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA5"],
        ["\xF3\xB0\xBE\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA5"],

        ["\xF3\xB0\xBE\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA6"],
        ["\xF3\xB0\xBE\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA6"],

        ["\xF3\xB0\xBE\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA7"],
        ["\xF3\xB0\xBE\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA7"],

        ["\xF3\xB0\xBE\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA8"],
        ["\xF3\xB0\xBE\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA8"],

        ["\xF3\xB0\xBE\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA9"],
        ["\xF3\xB0\xBE\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA9"],

        ["\xF3\xB0\xBE\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAA"],
        ["\xF3\xB0\xBE\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAA"],

        ["\xF3\xB0\xBE\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAB"],
        ["\xF3\xB0\xBE\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAB"],

        ["\xF3\xB0\xBE\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAC"],
        ["\xF3\xB0\xBE\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAC"],

        ["\xF3\xB0\xBE\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAD"],
        ["\xF3\xB0\xBE\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAD"],

        ["\xF3\xB0\xBE\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAE"],
        ["\xF3\xB0\xBE\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAE"],

        ["\xF3\xB0\xBE\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAF"],
        ["\xF3\xB0\xBE\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAF"],

        ["\xF3\xB0\xBE\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB0"],
        ["\xF3\xB0\xBE\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB0"],

        ["\xF3\xB0\xBE\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB1"],
        ["\xF3\xB0\xBE\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB1"],

        ["\xF3\xB0\xBE\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB2"],
        ["\xF3\xB0\xBE\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB2"],

        ["\xF3\xB0\xBE\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB3"],
        ["\xF3\xB0\xBE\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB3"],

        ["\xF3\xB0\xBE\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB4"],
        ["\xF3\xB0\xBE\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB4"],

        ["\xF3\xB0\xBE\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB5"],
        ["\xF3\xB0\xBE\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB5"],

        ["\xF3\xB0\xBE\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB6"],
        ["\xF3\xB0\xBE\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB6"],

        ["\xF3\xB0\xBE\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB7"],
        ["\xF3\xB0\xBE\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB7"],

        ["\xF3\xB0\xBE\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB8"],
        ["\xF3\xB0\xBE\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB8"],

        ["\xF3\xB0\xBE\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB9"],
        ["\xF3\xB0\xBE\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB9"],

        ["\xF3\xB0\xBE\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBA"],
        ["\xF3\xB0\xBE\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBA"],

        ["\xF3\xB0\xBE\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBB"],
        ["\xF3\xB0\xBE\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBB"],

        ["\xF3\xB0\xBE\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBC"],
        ["\xF3\xB0\xBE\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBC"],

        ["\xF3\xB0\xBE\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBD"],
        ["\xF3\xB0\xBE\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBD"],

        ["\xF3\xB0\xBE\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBE"],
        ["\xF3\xB0\xBE\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBE"],

        ["\xF3\xB0\xBE\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBF"],
        ["\xF3\xB0\xBE\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBF"],

        ["\xF3\xB0\xBF\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x80"],
        ["\xF3\xB0\xBF\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x80"],

        ["\xF3\xB0\xBF\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x81"],
        ["\xF3\xB0\xBF\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x81"],

        ["\xF3\xB0\xBF\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x82"],
        ["\xF3\xB0\xBF\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x82"],

        ["\xF3\xB0\xBF\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x83"],
        ["\xF3\xB0\xBF\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x83"],

        ["\xF3\xB0\xBF\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x84"],
        ["\xF3\xB0\xBF\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x84"],

        ["\xF3\xB0\xBF\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x85"],
        ["\xF3\xB0\xBF\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x85"],

        ["\xF3\xB0\xBF\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x86"],
        ["\xF3\xB0\xBF\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x86"],

        ["\xF3\xB0\xBF\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x87"],
        ["\xF3\xB0\xBF\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x87"],

        ["\xF3\xB0\xBF\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x88"],
        ["\xF3\xB0\xBF\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x88"],

        ["\xF3\xB0\xBF\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x89"],
        ["\xF3\xB0\xBF\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x89"],

        ["\xF3\xB0\xBF\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8A"],
        ["\xF3\xB0\xBF\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8A"],

        ["\xF3\xB0\xBF\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8B"],
        ["\xF3\xB0\xBF\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8B"],

        ["\xF3\xB0\xBF\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8C"],
        ["\xF3\xB0\xBF\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8C"],

        ["\xF3\xB0\xBF\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8D"],
        ["\xF3\xB0\xBF\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8D"],

        ["\xF3\xB0\xBF\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8E"],
        ["\xF3\xB0\xBF\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8E"],

        ["\xF3\xB0\xBF\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8F"],
        ["\xF3\xB0\xBF\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8F"],

        ["\xF3\xB0\xBF\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x90"],
        ["\xF3\xB0\xBF\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x90"],

        ["\xF3\xB0\xBF\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x91"],
        ["\xF3\xB0\xBF\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x91"],

        ["\xF3\xB0\xBF\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x92"],
        ["\xF3\xB0\xBF\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x92"],

        ["\xF3\xB0\xBF\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x93"],
        ["\xF3\xB0\xBF\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x93"],

        ["\xF3\xB0\xBF\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x94"],
        ["\xF3\xB0\xBF\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x94"],

        ["\xF3\xB0\xBF\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x95"],
        ["\xF3\xB0\xBF\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x95"],

        ["\xF3\xB0\xBF\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x96"],
        ["\xF3\xB0\xBF\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x96"],

        ["\xF3\xB0\xBF\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x97"],
        ["\xF3\xB0\xBF\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x97"],

        ["\xF3\xB0\xBF\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x98"],
        ["\xF3\xB0\xBF\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x98"],

        ["\xF3\xB0\xBF\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x99"],
        ["\xF3\xB0\xBF\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x99"],

        ["\xF3\xB0\xBF\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9A"],
        ["\xF3\xB0\xBF\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9A"],

        ["\xF3\xB0\xBF\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9B"],
        ["\xF3\xB0\xBF\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9B"],

        ["\xF3\xB0\xBF\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9C"],
        ["\xF3\xB0\xBF\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9C"],

        ["\xF3\xB0\xBF\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9D"],
        ["\xF3\xB0\xBF\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9D"],

        ["\xF3\xB0\xBF\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9E"],
        ["\xF3\xB0\xBF\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9E"],

        ["\xF3\xB0\xBF\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9F"],
        ["\xF3\xB0\xBF\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9F"],

        ["\xF3\xB0\xBF\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA0"],
        ["\xF3\xB0\xBF\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA0"],

        ["\xF3\xB0\xBF\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA1"],
        ["\xF3\xB0\xBF\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA1"],

        ["\xF3\xB0\xBF\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA2"],
        ["\xF3\xB0\xBF\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA2"],

        ["\xF3\xB0\xBF\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA3"],
        ["\xF3\xB0\xBF\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA3"],

        ["\xF3\xB0\xBF\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA4"],
        ["\xF3\xB0\xBF\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA4"],

        ["\xF3\xB0\xBF\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA5"],
        ["\xF3\xB0\xBF\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA5"],

        ["\xF3\xB0\xBF\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA6"],
        ["\xF3\xB0\xBF\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA6"],

        ["\xF3\xB0\xBF\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA7"],
        ["\xF3\xB0\xBF\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA7"],

        ["\xF3\xB0\xBF\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA8"],
        ["\xF3\xB0\xBF\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA8"],

        ["\xF3\xB0\xBF\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA9"],
        ["\xF3\xB0\xBF\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA9"],

        ["\xF3\xB0\xBF\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAA"],
        ["\xF3\xB0\xBF\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAA"],

        ["\xF3\xB0\xBF\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAB"],
        ["\xF3\xB0\xBF\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAB"],

        ["\xF3\xB0\xBF\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAC"],
        ["\xF3\xB0\xBF\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAC"],

        ["\xF3\xB0\xBF\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAD"],
        ["\xF3\xB0\xBF\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAD"],

        ["\xF3\xB0\xBF\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAE"],
        ["\xF3\xB0\xBF\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAE"],

        ["\xF3\xB0\xBF\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAF"],
        ["\xF3\xB0\xBF\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAF"],

        ["\xF3\xB0\xBF\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB0"],
        ["\xF3\xB0\xBF\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB0"],

        ["\xF3\xB0\xBF\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB1"],
        ["\xF3\xB0\xBF\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB1"],

        ["\xF3\xB0\xBF\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB2"],
        ["\xF3\xB0\xBF\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB2"],

        ["\xF3\xB0\xBF\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB3"],
        ["\xF3\xB0\xBF\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB3"],

        ["\xF3\xB0\xBF\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB4"],
        ["\xF3\xB0\xBF\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB4"],

        ["\xF3\xB0\xBF\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB5"],
        ["\xF3\xB0\xBF\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB5"],

        ["\xF3\xB0\xBF\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB6"],
        ["\xF3\xB0\xBF\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB6"],

        ["\xF3\xB0\xBF\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB7"],
        ["\xF3\xB0\xBF\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB7"],

        ["\xF3\xB0\xBF\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB8"],
        ["\xF3\xB0\xBF\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB8"],

        ["\xF3\xB0\xBF\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB9"],
        ["\xF3\xB0\xBF\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB9"],

        ["\xF3\xB0\xBF\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBA"],
        ["\xF3\xB0\xBF\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBA"],

        ["\xF3\xB0\xBF\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBB"],
        ["\xF3\xB0\xBF\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBB"],

        ["\xF3\xB0\xBF\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBC"],
        ["\xF3\xB0\xBF\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBC"],

        ["\xF3\xB0\xBF\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBD"],
        ["\xF3\xB0\xBF\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBD"],

        ["\xF3\xB0\xBF\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBE"],
        ["\xF3\xB0\xBF\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBE"],

        ["\xF3\xB0\xBF\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBF"],
        ["\xF3\xB0\xBF\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBF"],

        ["\xF3\xB1\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x80"],
        ["\xF3\xB1\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x80"],

        ["\xF3\xB1\x80\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x81"],
        ["\xF3\xB1\x80\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x81"],

        ["\xF3\xB1\x80\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x82"],
        ["\xF3\xB1\x80\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x82"],

        ["\xF3\xB1\x80\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x83"],
        ["\xF3\xB1\x80\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x83"],

        ["\xF3\xB1\x80\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x84"],
        ["\xF3\xB1\x80\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x84"],

        ["\xF3\xB1\x80\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x85"],
        ["\xF3\xB1\x80\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x85"],

        ["\xF3\xB1\x80\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x86"],
        ["\xF3\xB1\x80\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x86"],

        ["\xF3\xB1\x80\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x87"],
        ["\xF3\xB1\x80\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x87"],

        ["\xF3\xB1\x80\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x88"],
        ["\xF3\xB1\x80\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x88"],

        ["\xF3\xB1\x80\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x89"],
        ["\xF3\xB1\x80\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x89"],

        ["\xF3\xB1\x80\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8A"],
        ["\xF3\xB1\x80\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8A"],

        ["\xF3\xB1\x80\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8B"],
        ["\xF3\xB1\x80\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8B"],

        ["\xF3\xB1\x80\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8C"],
        ["\xF3\xB1\x80\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8C"],

        ["\xF3\xB1\x80\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8D"],
        ["\xF3\xB1\x80\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8D"],

        ["\xF3\xB1\x80\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8E"],
        ["\xF3\xB1\x80\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8E"],

        ["\xF3\xB1\x80\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8F"],
        ["\xF3\xB1\x80\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8F"],

        ["\xF3\xB1\x80\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x90"],
        ["\xF3\xB1\x80\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x90"],

        ["\xF3\xB1\x80\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x91"],
        ["\xF3\xB1\x80\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x91"],

        ["\xF3\xB1\x80\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x92"],
        ["\xF3\xB1\x80\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x92"],

        ["\xF3\xB1\x80\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x93"],
        ["\xF3\xB1\x80\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x93"],

        ["\xF3\xB1\x80\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x94"],
        ["\xF3\xB1\x80\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x94"],

        ["\xF3\xB1\x80\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x95"],
        ["\xF3\xB1\x80\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x95"],

        ["\xF3\xB1\x80\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x96"],
        ["\xF3\xB1\x80\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x96"],

        ["\xF3\xB1\x80\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x97"],
        ["\xF3\xB1\x80\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x97"],

        ["\xF3\xB1\x80\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x98"],
        ["\xF3\xB1\x80\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x98"],

        ["\xF3\xB1\x80\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x99"],
        ["\xF3\xB1\x80\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x99"],

        ["\xF3\xB1\x80\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9A"],
        ["\xF3\xB1\x80\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9A"],

        ["\xF3\xB1\x80\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9B"],
        ["\xF3\xB1\x80\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9B"],

        ["\xF3\xB1\x80\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9C"],
        ["\xF3\xB1\x80\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9C"],

        ["\xF3\xB1\x80\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9D"],
        ["\xF3\xB1\x80\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9D"],

        ["\xF3\xB1\x80\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9E"],
        ["\xF3\xB1\x80\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9E"],

        ["\xF3\xB1\x80\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9F"],
        ["\xF3\xB1\x80\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9F"],

        ["\xF3\xB1\x80\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA0"],
        ["\xF3\xB1\x80\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA0"],

        ["\xF3\xB1\x80\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA1"],
        ["\xF3\xB1\x80\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA1"],

        ["\xF3\xB1\x80\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA2"],
        ["\xF3\xB1\x80\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA2"],

        ["\xF3\xB1\x80\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA3"],
        ["\xF3\xB1\x80\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA3"],

        ["\xF3\xB1\x80\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA4"],
        ["\xF3\xB1\x80\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA4"],

        ["\xF3\xB1\x80\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA5"],
        ["\xF3\xB1\x80\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA5"],

        ["\xF3\xB1\x80\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA6"],
        ["\xF3\xB1\x80\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA6"],

        ["\xF3\xB1\x80\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA7"],
        ["\xF3\xB1\x80\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA7"],

        ["\xF3\xB1\x80\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA8"],
        ["\xF3\xB1\x80\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA8"],

        ["\xF3\xB1\x80\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA9"],
        ["\xF3\xB1\x80\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA9"],

        ["\xF3\xB1\x80\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAA"],
        ["\xF3\xB1\x80\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAA"],

        ["\xF3\xB1\x80\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAB"],
        ["\xF3\xB1\x80\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAB"],

        ["\xF3\xB1\x80\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAC"],
        ["\xF3\xB1\x80\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAC"],

        ["\xF3\xB1\x80\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAD"],
        ["\xF3\xB1\x80\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAD"],

        ["\xF3\xB1\x80\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAE"],
        ["\xF3\xB1\x80\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAE"],

        ["\xF3\xB1\x80\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAF"],
        ["\xF3\xB1\x80\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAF"],

        ["\xF3\xB1\x80\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB0"],
        ["\xF3\xB1\x80\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB0"],

        ["\xF3\xB1\x80\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB1"],
        ["\xF3\xB1\x80\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB1"],

        ["\xF3\xB1\x80\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB2"],
        ["\xF3\xB1\x80\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB2"],

        ["\xF3\xB1\x80\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB3"],
        ["\xF3\xB1\x80\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB3"],

        ["\xF3\xB1\x80\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB4"],
        ["\xF3\xB1\x80\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB4"],

        ["\xF3\xB1\x80\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB5"],
        ["\xF3\xB1\x80\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB5"],

        ["\xF3\xB1\x80\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB6"],
        ["\xF3\xB1\x80\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB6"],

        ["\xF3\xB1\x80\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB7"],
        ["\xF3\xB1\x80\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB7"],

        ["\xF3\xB1\x80\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB8"],
        ["\xF3\xB1\x80\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB8"],

        ["\xF3\xB1\x80\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB9"],
        ["\xF3\xB1\x80\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB9"],

        ["\xF3\xB1\x80\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBA"],
        ["\xF3\xB1\x80\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBA"],

        ["\xF3\xB1\x80\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBB"],
        ["\xF3\xB1\x80\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBB"],

        ["\xF3\xB1\x80\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBC"],
        ["\xF3\xB1\x80\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBC"],

        ["\xF3\xB1\x80\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBD"],
        ["\xF3\xB1\x80\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBD"],

        ["\xF3\xB1\x80\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBE"],
        ["\xF3\xB1\x80\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBE"],

        ["\xF3\xB1\x80\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBF"],
        ["\xF3\xB1\x80\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBF"],

        ["\xF3\xB1\x81\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x80"],
        ["\xF3\xB1\x81\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x80"],

        ["\xF3\xB1\x81\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x81"],
        ["\xF3\xB1\x81\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x81"],

        ["\xF3\xB1\x81\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x82"],
        ["\xF3\xB1\x81\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x82"],

        ["\xF3\xB1\x81\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x83"],
        ["\xF3\xB1\x81\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x83"],

        ["\xF3\xB1\x81\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x84"],
        ["\xF3\xB1\x81\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x84"],

        ["\xF3\xB1\x81\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x85"],
        ["\xF3\xB1\x81\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x85"],

        ["\xF3\xB1\x81\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x86"],
        ["\xF3\xB1\x81\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x86"],

        ["\xF3\xB1\x81\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x87"],
        ["\xF3\xB1\x81\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x87"],

        ["\xF3\xB1\x81\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x88"],
        ["\xF3\xB1\x81\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x88"],

        ["\xF3\xB1\x81\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x89"],
        ["\xF3\xB1\x81\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x89"],

        ["\xF3\xB1\x81\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8A"],
        ["\xF3\xB1\x81\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8A"],

        ["\xF3\xB1\x81\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8B"],
        ["\xF3\xB1\x81\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8B"],

        ["\xF3\xB1\x81\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8C"],
        ["\xF3\xB1\x81\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8C"],

        ["\xF3\xB1\x81\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8D"],
        ["\xF3\xB1\x81\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8D"],

        ["\xF3\xB1\x81\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8E"],
        ["\xF3\xB1\x81\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8E"],

        ["\xF3\xB1\x81\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8F"],
        ["\xF3\xB1\x81\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8F"],

        ["\xF3\xB1\x81\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x90"],
        ["\xF3\xB1\x81\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x90"],

        ["\xF3\xB1\x81\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x91"],
        ["\xF3\xB1\x81\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x91"],

        ["\xF3\xB1\x81\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x92"],
        ["\xF3\xB1\x81\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x92"],

        ["\xF3\xB1\x81\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x93"],
        ["\xF3\xB1\x81\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x93"],

        ["\xF3\xB1\x81\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x94"],
        ["\xF3\xB1\x81\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x94"],

        ["\xF3\xB1\x81\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x95"],
        ["\xF3\xB1\x81\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x95"],

        ["\xF3\xB1\x81\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x96"],
        ["\xF3\xB1\x81\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x96"],

        ["\xF3\xB1\x81\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x97"],
        ["\xF3\xB1\x81\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x97"],

        ["\xF3\xB1\x81\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x98"],
        ["\xF3\xB1\x81\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x98"],

        ["\xF3\xB1\x81\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x99"],
        ["\xF3\xB1\x81\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x99"],

        ["\xF3\xB1\x81\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9A"],
        ["\xF3\xB1\x81\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9A"],

        ["\xF3\xB1\x81\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9B"],
        ["\xF3\xB1\x81\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9B"],

        ["\xF3\xB1\x81\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9C"],
        ["\xF3\xB1\x81\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9C"],

        ["\xF3\xB1\x81\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9D"],
        ["\xF3\xB1\x81\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9D"],

        ["\xF3\xB1\x81\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9E"],
        ["\xF3\xB1\x81\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9E"],

        ["\xF3\xB1\x81\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9F"],
        ["\xF3\xB1\x81\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9F"],

        ["\xF3\xB1\x81\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA0"],
        ["\xF3\xB1\x81\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA0"],

        ["\xF3\xB1\x81\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA1"],
        ["\xF3\xB1\x81\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA1"],

        ["\xF3\xB1\x81\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA2"],
        ["\xF3\xB1\x81\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA2"],

        ["\xF3\xB1\x81\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA3"],
        ["\xF3\xB1\x81\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA3"],

        ["\xF3\xB1\x81\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA4"],
        ["\xF3\xB1\x81\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA4"],

        ["\xF3\xB1\x81\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA5"],
        ["\xF3\xB1\x81\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA5"],

        ["\xF3\xB1\x81\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA6"],
        ["\xF3\xB1\x81\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA6"],

        ["\xF3\xB1\x81\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA7"],
        ["\xF3\xB1\x81\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA7"],

        ["\xF3\xB1\x81\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA8"],
        ["\xF3\xB1\x81\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA8"],

        ["\xF3\xB1\x81\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA9"],
        ["\xF3\xB1\x81\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA9"],

        ["\xF3\xB1\x81\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAA"],
        ["\xF3\xB1\x81\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAA"],

        ["\xF3\xB1\x81\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAB"],
        ["\xF3\xB1\x81\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAB"],

        ["\xF3\xB1\x81\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAC"],
        ["\xF3\xB1\x81\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAC"],

        ["\xF3\xB1\x81\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAD"],
        ["\xF3\xB1\x81\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAD"],

        ["\xF3\xB1\x81\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAE"],
        ["\xF3\xB1\x81\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAE"],

        ["\xF3\xB1\x81\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAF"],
        ["\xF3\xB1\x81\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAF"],

        ["\xF3\xB1\x81\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB0"],
        ["\xF3\xB1\x81\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB0"],

        ["\xF3\xB1\x81\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB1"],
        ["\xF3\xB1\x81\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB1"],

        ["\xF3\xB1\x81\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB2"],
        ["\xF3\xB1\x81\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB2"],

        ["\xF3\xB1\x81\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB3"],
        ["\xF3\xB1\x81\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB3"],

        ["\xF3\xB1\x81\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB4"],
        ["\xF3\xB1\x81\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB4"],

        ["\xF3\xB1\x81\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB5"],
        ["\xF3\xB1\x81\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB5"],

        ["\xF3\xB1\x81\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB6"],
        ["\xF3\xB1\x81\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB6"],

        ["\xF3\xB1\x81\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB7"],
        ["\xF3\xB1\x81\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB7"],

        ["\xF3\xB1\x81\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB8"],
        ["\xF3\xB1\x81\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB8"],

        ["\xF3\xB1\x81\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB9"],
        ["\xF3\xB1\x81\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB9"],

        ["\xF3\xB1\x81\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBA"],
        ["\xF3\xB1\x81\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBA"],

        ["\xF3\xB1\x81\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBB"],
        ["\xF3\xB1\x81\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBB"],

        ["\xF3\xB1\x81\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBC"],
        ["\xF3\xB1\x81\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBC"],

        ["\xF3\xB1\x81\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBD"],
        ["\xF3\xB1\x81\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBD"],

        ["\xF3\xB1\x81\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBE"],
        ["\xF3\xB1\x81\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBE"],

        ["\xF3\xB1\x81\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBF"],
        ["\xF3\xB1\x81\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBF"],

        ["\xF3\xB1\x82\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x80"],
        ["\xF3\xB1\x82\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x80"],

        ["\xF3\xB1\x82\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x81"],
        ["\xF3\xB1\x82\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x81"],

        ["\xF3\xB1\x82\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x82"],
        ["\xF3\xB1\x82\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x82"],

        ["\xF3\xB1\x82\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x83"],
        ["\xF3\xB1\x82\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x83"],

        ["\xF3\xB1\x82\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x84"],
        ["\xF3\xB1\x82\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x84"],

        ["\xF3\xB1\x82\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x85"],
        ["\xF3\xB1\x82\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x85"],

        ["\xF3\xB1\x82\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x86"],
        ["\xF3\xB1\x82\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x86"],

        ["\xF3\xB1\x82\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x87"],
        ["\xF3\xB1\x82\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x87"],

        ["\xF3\xB1\x82\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x88"],
        ["\xF3\xB1\x82\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x88"],

        ["\xF3\xB1\x82\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x89"],
        ["\xF3\xB1\x82\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x89"],

        ["\xF3\xB1\x82\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8A"],
        ["\xF3\xB1\x82\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8A"],

        ["\xF3\xB1\x82\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8B"],
        ["\xF3\xB1\x82\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8B"],

        ["\xF3\xB1\x82\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8C"],
        ["\xF3\xB1\x82\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8C"],

        ["\xF3\xB1\x82\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8D"],
        ["\xF3\xB1\x82\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8D"],

        ["\xF3\xB1\x82\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8E"],
        ["\xF3\xB1\x82\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8E"],

        ["\xF3\xB1\x82\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8F"],
        ["\xF3\xB1\x82\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8F"],

        ["\xF3\xB1\x82\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x90"],
        ["\xF3\xB1\x82\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x90"],

        ["\xF3\xB1\x82\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x91"],
        ["\xF3\xB1\x82\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x91"],

        ["\xF3\xB1\x82\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x92"],
        ["\xF3\xB1\x82\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x92"],

        ["\xF3\xB1\x82\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x93"],
        ["\xF3\xB1\x82\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x93"],

        ["\xF3\xB1\x82\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x94"],
        ["\xF3\xB1\x82\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x94"],

        ["\xF3\xB1\x82\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x95"],
        ["\xF3\xB1\x82\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x95"],

        ["\xF3\xB1\x82\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x96"],
        ["\xF3\xB1\x82\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x96"],

        ["\xF3\xB1\x82\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x97"],
        ["\xF3\xB1\x82\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x97"],

        ["\xF3\xB1\x82\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x98"],
        ["\xF3\xB1\x82\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x98"],

        ["\xF3\xB1\x82\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x99"],
        ["\xF3\xB1\x82\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x99"],

        ["\xF3\xB1\x82\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9A"],
        ["\xF3\xB1\x82\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9A"],

        ["\xF3\xB1\x82\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9B"],
        ["\xF3\xB1\x82\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9B"],

        ["\xF3\xB1\x82\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9C"],
        ["\xF3\xB1\x82\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9C"],

        ["\xF3\xB1\x82\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9D"],
        ["\xF3\xB1\x82\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9D"],

        ["\xF3\xB1\x82\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9E"],
        ["\xF3\xB1\x82\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9E"],

        ["\xF3\xB1\x82\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9F"],
        ["\xF3\xB1\x82\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9F"],

        ["\xF3\xB1\x82\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA0"],
        ["\xF3\xB1\x82\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA0"],

        ["\xF3\xB1\x82\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA1"],
        ["\xF3\xB1\x82\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA1"],

        ["\xF3\xB1\x82\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA2"],
        ["\xF3\xB1\x82\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA2"],

        ["\xF3\xB1\x82\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA3"],
        ["\xF3\xB1\x82\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA3"],

        ["\xF3\xB1\x82\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA4"],
        ["\xF3\xB1\x82\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA4"],

        ["\xF3\xB1\x82\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA5"],
        ["\xF3\xB1\x82\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA5"],

        ["\xF3\xB1\x82\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA6"],
        ["\xF3\xB1\x82\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA6"],

        ["\xF3\xB1\x82\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA7"],
        ["\xF3\xB1\x82\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA7"],

        ["\xF3\xB1\x82\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA8"],
        ["\xF3\xB1\x82\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA8"],

        ["\xF3\xB1\x82\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA9"],
        ["\xF3\xB1\x82\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA9"],

        ["\xF3\xB1\x82\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAA"],
        ["\xF3\xB1\x82\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAA"],

        ["\xF3\xB1\x82\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAB"],
        ["\xF3\xB1\x82\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAB"],

        ["\xF3\xB1\x82\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAC"],
        ["\xF3\xB1\x82\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAC"],

        ["\xF3\xB1\x82\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAD"],
        ["\xF3\xB1\x82\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAD"],

        ["\xF3\xB1\x82\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAE"],
        ["\xF3\xB1\x82\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAE"],

        ["\xF3\xB1\x82\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAF"],
        ["\xF3\xB1\x82\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAF"],

        ["\xF3\xB1\x82\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB0"],
        ["\xF3\xB1\x82\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB0"],

        ["\xF3\xB1\x82\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB1"],
        ["\xF3\xB1\x82\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB1"],

        ["\xF3\xB1\x82\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB2"],
        ["\xF3\xB1\x82\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB2"],

        ["\xF3\xB1\x82\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB3"],
        ["\xF3\xB1\x82\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB3"],

        ["\xF3\xB1\x82\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB4"],
        ["\xF3\xB1\x82\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB4"],

        ["\xF3\xB1\x82\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB5"],
        ["\xF3\xB1\x82\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB5"],

        ["\xF3\xB1\x82\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB6"],
        ["\xF3\xB1\x82\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB6"],

        ["\xF3\xB1\x82\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB7"],
        ["\xF3\xB1\x82\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB7"],

        ["\xF3\xB1\x82\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB8"],
        ["\xF3\xB1\x82\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB8"],

        ["\xF3\xB1\x82\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB9"],
        ["\xF3\xB1\x82\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB9"],

        ["\xF3\xB1\x82\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBA"],
        ["\xF3\xB1\x82\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBA"],

        ["\xF3\xB1\x82\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBB"],
        ["\xF3\xB1\x82\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBB"],

        ["\xF3\xB1\x82\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBC"],
        ["\xF3\xB1\x82\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBC"],

        ["\xF3\xB1\x82\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBD"],
        ["\xF3\xB1\x82\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBD"],

        ["\xF3\xB1\x82\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBE"],
        ["\xF3\xB1\x82\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBE"],

        ["\xF3\xB1\x82\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBF"],
        ["\xF3\xB1\x82\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBF"],

        ["\xF3\xB1\x83\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x80"],
        ["\xF3\xB1\x83\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x80"],

        ["\xF3\xB1\x83\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x81"],
        ["\xF3\xB1\x83\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x81"],

        ["\xF3\xB1\x83\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x82"],
        ["\xF3\xB1\x83\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x82"],

        ["\xF3\xB1\x83\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x83"],
        ["\xF3\xB1\x83\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x83"],

        ["\xF3\xB1\x83\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x84"],
        ["\xF3\xB1\x83\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x84"],

        ["\xF3\xB1\x83\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x85"],
        ["\xF3\xB1\x83\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x85"],

        ["\xF3\xB1\x83\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x86"],
        ["\xF3\xB1\x83\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x86"],

        ["\xF3\xB1\x83\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x87"],
        ["\xF3\xB1\x83\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x87"],

        ["\xF3\xB1\x83\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x88"],
        ["\xF3\xB1\x83\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x88"],

        ["\xF3\xB1\x83\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x89"],
        ["\xF3\xB1\x83\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x89"],

        ["\xF3\xB1\x83\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8A"],
        ["\xF3\xB1\x83\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8A"],

        ["\xF3\xB1\x83\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8B"],
        ["\xF3\xB1\x83\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8B"],

        ["\xF3\xB1\x83\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8C"],
        ["\xF3\xB1\x83\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8C"],

        ["\xF3\xB1\x83\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8D"],
        ["\xF3\xB1\x83\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8D"],

        ["\xF3\xB1\x83\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8E"],
        ["\xF3\xB1\x83\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8E"],

        ["\xF3\xB1\x83\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8F"],
        ["\xF3\xB1\x83\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8F"],

        ["\xF3\xB1\x83\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x90"],
        ["\xF3\xB1\x83\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x90"],

        ["\xF3\xB1\x83\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x91"],
        ["\xF3\xB1\x83\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x91"],

        ["\xF3\xB1\x83\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x92"],
        ["\xF3\xB1\x83\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x92"],

        ["\xF3\xB1\x83\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x93"],
        ["\xF3\xB1\x83\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x93"],

        ["\xF3\xB1\x83\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x94"],
        ["\xF3\xB1\x83\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x94"],

        ["\xF3\xB1\x83\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x95"],
        ["\xF3\xB1\x83\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x95"],

        ["\xF3\xB1\x83\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x96"],
        ["\xF3\xB1\x83\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x96"],

        ["\xF3\xB1\x83\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x97"],
        ["\xF3\xB1\x83\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x97"],

        ["\xF3\xB1\x83\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x98"],
        ["\xF3\xB1\x83\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x98"],

        ["\xF3\xB1\x83\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x99"],
        ["\xF3\xB1\x83\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x99"],

        ["\xF3\xB1\x83\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9A"],
        ["\xF3\xB1\x83\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9A"],

        ["\xF3\xB1\x83\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9B"],
        ["\xF3\xB1\x83\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9B"],

        ["\xF3\xB1\x83\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9C"],
        ["\xF3\xB1\x83\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9C"],

        ["\xF3\xB1\x83\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9D"],
        ["\xF3\xB1\x83\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9D"],

        ["\xF3\xB1\x83\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9E"],
        ["\xF3\xB1\x83\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9E"],

        ["\xF3\xB1\x83\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9F"],
        ["\xF3\xB1\x83\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9F"],

        ["\xF3\xB1\x83\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA0"],
        ["\xF3\xB1\x83\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA0"],

        ["\xF3\xB1\x83\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA1"],
        ["\xF3\xB1\x83\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA1"],

        ["\xF3\xB1\x83\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA2"],
        ["\xF3\xB1\x83\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA2"],

        ["\xF3\xB1\x83\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA3"],
        ["\xF3\xB1\x83\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA3"],

        ["\xF3\xB1\x83\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA4"],
        ["\xF3\xB1\x83\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA4"],

        ["\xF3\xB1\x83\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA5"],
        ["\xF3\xB1\x83\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA5"],

        ["\xF3\xB1\x83\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA6"],
        ["\xF3\xB1\x83\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA6"],

        ["\xF3\xB1\x83\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA7"],
        ["\xF3\xB1\x83\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA7"],

        ["\xF3\xB1\x83\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA8"],
        ["\xF3\xB1\x83\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA8"],

        ["\xF3\xB1\x83\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA9"],
        ["\xF3\xB1\x83\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA9"],

        ["\xF3\xB1\x83\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAA"],
        ["\xF3\xB1\x83\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAA"],

        ["\xF3\xB1\x83\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAB"],
        ["\xF3\xB1\x83\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAB"],

        ["\xF3\xB1\x83\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAC"],
        ["\xF3\xB1\x83\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAC"],

        ["\xF3\xB1\x83\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAD"],
        ["\xF3\xB1\x83\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAD"],

        ["\xF3\xB1\x83\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAE"],
        ["\xF3\xB1\x83\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAE"],

        ["\xF3\xB1\x83\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAF"],
        ["\xF3\xB1\x83\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAF"],

        ["\xF3\xB1\x83\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB0"],
        ["\xF3\xB1\x83\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB0"],

        ["\xF3\xB1\x83\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB1"],
        ["\xF3\xB1\x83\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB1"],

        ["\xF3\xB1\x83\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB2"],
        ["\xF3\xB1\x83\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB2"],

        ["\xF3\xB1\x83\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB3"],
        ["\xF3\xB1\x83\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB3"],

        ["\xF3\xB1\x83\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB4"],
        ["\xF3\xB1\x83\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB4"],

        ["\xF3\xB1\x83\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB5"],
        ["\xF3\xB1\x83\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB5"],

        ["\xF3\xB1\x83\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB6"],
        ["\xF3\xB1\x83\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB6"],

        ["\xF3\xB1\x83\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB7"],
        ["\xF3\xB1\x83\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB7"],

        ["\xF3\xB1\x83\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB8"],
        ["\xF3\xB1\x83\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB8"],

        ["\xF3\xB1\x83\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB9"],
        ["\xF3\xB1\x83\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB9"],

        ["\xF3\xB1\x83\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBA"],
        ["\xF3\xB1\x83\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBA"],

        ["\xF3\xB1\x83\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBB"],
        ["\xF3\xB1\x83\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBB"],

        ["\xF3\xB1\x83\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBC"],
        ["\xF3\xB1\x83\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBC"],

        ["\xF3\xB1\x83\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBD"],
        ["\xF3\xB1\x83\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBD"],

        ["\xF3\xB1\x83\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBE"],
        ["\xF3\xB1\x83\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBE"],

        ["\xF3\xB1\x83\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBF"],
        ["\xF3\xB1\x83\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBF"],

        ["\xF3\xB1\x84\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x80"],
        ["\xF3\xB1\x84\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x80"],

        ["\xF3\xB1\x84\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x81"],
        ["\xF3\xB1\x84\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x81"],

        ["\xF3\xB1\x84\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x82"],
        ["\xF3\xB1\x84\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x82"],

        ["\xF3\xB1\x84\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x83"],
        ["\xF3\xB1\x84\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x83"],

        ["\xF3\xB1\x84\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x84"],
        ["\xF3\xB1\x84\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x84"],

        ["\xF3\xB1\x84\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x85"],
        ["\xF3\xB1\x84\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x85"],

        ["\xF3\xB1\x84\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x86"],
        ["\xF3\xB1\x84\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x86"],

        ["\xF3\xB1\x84\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x87"],
        ["\xF3\xB1\x84\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x87"],

        ["\xF3\xB1\x84\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x88"],
        ["\xF3\xB1\x84\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x88"],

        ["\xF3\xB1\x84\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x89"],
        ["\xF3\xB1\x84\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x89"],

        ["\xF3\xB1\x84\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8A"],
        ["\xF3\xB1\x84\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8A"],

        ["\xF3\xB1\x84\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8B"],
        ["\xF3\xB1\x84\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8B"],

        ["\xF3\xB1\x84\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8C"],
        ["\xF3\xB1\x84\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8C"],

        ["\xF3\xB1\x84\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8D"],
        ["\xF3\xB1\x84\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8D"],

        ["\xF3\xB1\x84\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8E"],
        ["\xF3\xB1\x84\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8E"],

        ["\xF3\xB1\x84\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8F"],
        ["\xF3\xB1\x84\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8F"],

        ["\xF3\xB1\x84\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x90"],
        ["\xF3\xB1\x84\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x90"],

        ["\xF3\xB1\x84\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x91"],
        ["\xF3\xB1\x84\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x91"],

        ["\xF3\xB1\x84\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x92"],
        ["\xF3\xB1\x84\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x92"],

        ["\xF3\xB1\x84\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x93"],
        ["\xF3\xB1\x84\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x93"],

        ["\xF3\xB1\x84\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x94"],
        ["\xF3\xB1\x84\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x94"],

        ["\xF3\xB1\x84\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x95"],
        ["\xF3\xB1\x84\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x95"],

        ["\xF3\xB1\x84\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x96"],
        ["\xF3\xB1\x84\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x96"],

        ["\xF3\xB1\x84\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x97"],
        ["\xF3\xB1\x84\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x97"],

        ["\xF3\xB1\x84\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x98"],
        ["\xF3\xB1\x84\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x98"],

        ["\xF3\xB1\x84\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x99"],
        ["\xF3\xB1\x84\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x99"],

        ["\xF3\xB1\x84\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9A"],
        ["\xF3\xB1\x84\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9A"],

        ["\xF3\xB1\x84\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9B"],
        ["\xF3\xB1\x84\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9B"],

        ["\xF3\xB1\x84\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9C"],
        ["\xF3\xB1\x84\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9C"],

        ["\xF3\xB1\x84\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9D"],
        ["\xF3\xB1\x84\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9D"],

        ["\xF3\xB1\x84\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9E"],
        ["\xF3\xB1\x84\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9E"],

        ["\xF3\xB1\x84\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9F"],
        ["\xF3\xB1\x84\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9F"],

        ["\xF3\xB1\x84\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA0"],
        ["\xF3\xB1\x84\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA0"],

        ["\xF3\xB1\x84\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA1"],
        ["\xF3\xB1\x84\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA1"],

        ["\xF3\xB1\x84\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA2"],
        ["\xF3\xB1\x84\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA2"],

        ["\xF3\xB1\x84\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA3"],
        ["\xF3\xB1\x84\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA3"],

        ["\xF3\xB1\x84\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA4"],
        ["\xF3\xB1\x84\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA4"],

        ["\xF3\xB1\x84\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA5"],
        ["\xF3\xB1\x84\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA5"],

        ["\xF3\xB1\x84\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA6"],
        ["\xF3\xB1\x84\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA6"],

        ["\xF3\xB1\x84\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA7"],
        ["\xF3\xB1\x84\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA7"],

        ["\xF3\xB1\x84\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA8"],
        ["\xF3\xB1\x84\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA8"],

        ["\xF3\xB1\x84\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA9"],
        ["\xF3\xB1\x84\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA9"],

        ["\xF3\xB1\x84\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAA"],
        ["\xF3\xB1\x84\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAA"],

        ["\xF3\xB1\x84\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAB"],
        ["\xF3\xB1\x84\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAB"],

        ["\xF3\xB1\x84\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAC"],
        ["\xF3\xB1\x84\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAC"],

        ["\xF3\xB1\x84\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAD"],
        ["\xF3\xB1\x84\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAD"],

        ["\xF3\xB1\x84\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAE"],
        ["\xF3\xB1\x84\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAE"],

        ["\xF3\xB1\x84\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAF"],
        ["\xF3\xB1\x84\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAF"],

        ["\xF3\xB1\x84\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB0"],
        ["\xF3\xB1\x84\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB0"],

        ["\xF3\xB1\x84\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB1"],
        ["\xF3\xB1\x84\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB1"],

        ["\xF3\xB1\x84\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB2"],
        ["\xF3\xB1\x84\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB2"],

        ["\xF3\xB1\x84\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB3"],
        ["\xF3\xB1\x84\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB3"],

        ["\xF3\xB1\x84\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB4"],
        ["\xF3\xB1\x84\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB4"],

        ["\xF3\xB1\x84\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB5"],
        ["\xF3\xB1\x84\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB5"],

        ["\xF3\xB1\x84\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB6"],
        ["\xF3\xB1\x84\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB6"],

        ["\xF3\xB1\x84\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB7"],
        ["\xF3\xB1\x84\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB7"],

        ["\xF3\xB1\x84\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB8"],
        ["\xF3\xB1\x84\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB8"],

        ["\xF3\xB1\x84\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB9"],
        ["\xF3\xB1\x84\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB9"],

        ["\xF3\xB1\x84\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBA"],
        ["\xF3\xB1\x84\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBA"],

        ["\xF3\xB1\x84\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBB"],
        ["\xF3\xB1\x84\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBB"],

        ["\xF3\xB1\x84\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBC"],
        ["\xF3\xB1\x84\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBC"],

        ["\xF3\xB1\x84\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBD"],
        ["\xF3\xB1\x84\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBD"],

        ["\xF3\xB1\x84\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBE"],
        ["\xF3\xB1\x84\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBE"],

        ["\xF3\xB1\x84\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBF"],
        ["\xF3\xB1\x84\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBF"],

        ["\xF3\xB1\x85\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x80"],
        ["\xF3\xB1\x85\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x80"],

        ["\xF3\xB1\x85\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x81"],
        ["\xF3\xB1\x85\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x81"],

        ["\xF3\xB1\x85\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x82"],
        ["\xF3\xB1\x85\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x82"],

        ["\xF3\xB1\x85\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x83"],
        ["\xF3\xB1\x85\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x83"],

        ["\xF3\xB1\x85\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x84"],
        ["\xF3\xB1\x85\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x84"],

        ["\xF3\xB1\x85\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x85"],
        ["\xF3\xB1\x85\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x85"],

        ["\xF3\xB1\x85\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x86"],
        ["\xF3\xB1\x85\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x86"],

        ["\xF3\xB1\x85\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x87"],
        ["\xF3\xB1\x85\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x87"],

        ["\xF3\xB1\x85\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x88"],
        ["\xF3\xB1\x85\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x88"],

        ["\xF3\xB1\x85\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x89"],
        ["\xF3\xB1\x85\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x89"],

        ["\xF3\xB1\x85\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8A"],
        ["\xF3\xB1\x85\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8A"],

        ["\xF3\xB1\x85\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8B"],
        ["\xF3\xB1\x85\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8B"],

        ["\xF3\xB1\x85\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8C"],
        ["\xF3\xB1\x85\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8C"],

        ["\xF3\xB1\x85\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8D"],
        ["\xF3\xB1\x85\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8D"],

        ["\xF3\xB1\x85\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8E"],
        ["\xF3\xB1\x85\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8E"],

        ["\xF3\xB1\x85\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8F"],
        ["\xF3\xB1\x85\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8F"],

        ["\xF3\xB1\x85\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x90"],
        ["\xF3\xB1\x85\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x90"],

        ["\xF3\xB1\x85\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x91"],
        ["\xF3\xB1\x85\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x91"],

        ["\xF3\xB1\x85\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x92"],
        ["\xF3\xB1\x85\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x92"],

        ["\xF3\xB1\x85\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x93"],
        ["\xF3\xB1\x85\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x93"],

        ["\xF3\xB1\x85\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x94"],
        ["\xF3\xB1\x85\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x94"],

        ["\xF3\xB1\x85\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x95"],
        ["\xF3\xB1\x85\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x95"],

        ["\xF3\xB1\x85\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x96"],
        ["\xF3\xB1\x85\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x96"],

        ["\xF3\xB1\x85\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x97"],
        ["\xF3\xB1\x85\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x97"],

        ["\xF3\xB1\x85\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x98"],
        ["\xF3\xB1\x85\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x98"],

        ["\xF3\xB1\x85\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x99"],
        ["\xF3\xB1\x85\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x99"],

        ["\xF3\xB1\x85\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9A"],
        ["\xF3\xB1\x85\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9A"],

        ["\xF3\xB1\x85\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9B"],
        ["\xF3\xB1\x85\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9B"],

        ["\xF3\xB1\x85\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9C"],
        ["\xF3\xB1\x85\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9C"],

        ["\xF3\xB1\x85\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9D"],
        ["\xF3\xB1\x85\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9D"],

        ["\xF3\xB1\x85\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9E"],
        ["\xF3\xB1\x85\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9E"],

        ["\xF3\xB1\x85\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9F"],
        ["\xF3\xB1\x85\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9F"],

        ["\xF3\xB1\x85\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA0"],
        ["\xF3\xB1\x85\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA0"],

        ["\xF3\xB1\x85\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA1"],
        ["\xF3\xB1\x85\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA1"],

        ["\xF3\xB1\x85\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA2"],
        ["\xF3\xB1\x85\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA2"],

        ["\xF3\xB1\x85\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA3"],
        ["\xF3\xB1\x85\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA3"],

        ["\xF3\xB1\x85\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA4"],
        ["\xF3\xB1\x85\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA4"],

        ["\xF3\xB1\x85\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA5"],
        ["\xF3\xB1\x85\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA5"],

        ["\xF3\xB1\x85\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA6"],
        ["\xF3\xB1\x85\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA6"],

        ["\xF3\xB1\x85\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA7"],
        ["\xF3\xB1\x85\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA7"],

        ["\xF3\xB1\x85\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA8"],
        ["\xF3\xB1\x85\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA8"],

        ["\xF3\xB1\x85\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA9"],
        ["\xF3\xB1\x85\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA9"],

        ["\xF3\xB1\x85\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAA"],
        ["\xF3\xB1\x85\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAA"],

        ["\xF3\xB1\x85\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAB"],
        ["\xF3\xB1\x85\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAB"],

        ["\xF3\xB1\x85\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAC"],
        ["\xF3\xB1\x85\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAC"],

        ["\xF3\xB1\x85\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAD"],
        ["\xF3\xB1\x85\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAD"],

        ["\xF3\xB1\x85\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAE"],
        ["\xF3\xB1\x85\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAE"],

        ["\xF3\xB1\x85\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAF"],
        ["\xF3\xB1\x85\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAF"],

        ["\xF3\xB1\x85\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB0"],
        ["\xF3\xB1\x85\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB0"],

        ["\xF3\xB1\x85\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB1"],
        ["\xF3\xB1\x85\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB1"],

        ["\xF3\xB1\x85\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB2"],
        ["\xF3\xB1\x85\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB2"],

        ["\xF3\xB1\x85\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB3"],
        ["\xF3\xB1\x85\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB3"],

        ["\xF3\xB1\x85\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB4"],
        ["\xF3\xB1\x85\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB4"],

        ["\xF3\xB1\x85\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB5"],
        ["\xF3\xB1\x85\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB5"],

        ["\xF3\xB1\x85\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB6"],
        ["\xF3\xB1\x85\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB6"],

        ["\xF3\xB1\x85\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB7"],
        ["\xF3\xB1\x85\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB7"],

        ["\xF3\xB1\x85\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB8"],
        ["\xF3\xB1\x85\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB8"],

        ["\xF3\xB1\x85\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB9"],
        ["\xF3\xB1\x85\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB9"],

        ["\xF3\xB1\x85\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBA"],
        ["\xF3\xB1\x85\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBA"],

        ["\xF3\xB1\x85\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBB"],
        ["\xF3\xB1\x85\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBB"],

        ["\xF3\xB1\x85\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBC"],
        ["\xF3\xB1\x85\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBC"],

        ["\xF3\xB1\x85\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBD"],
        ["\xF3\xB1\x85\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBD"],

        ["\xF3\xB1\x85\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBE"],
        ["\xF3\xB1\x85\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBE"],

        ["\xF3\xB1\x85\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBF"],
        ["\xF3\xB1\x85\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBF"],

        ["\xF3\xB1\x86\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x80"],
        ["\xF3\xB1\x86\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x80"],

        ["\xF3\xB1\x86\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x81"],
        ["\xF3\xB1\x86\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x81"],

        ["\xF3\xB1\x86\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x82"],
        ["\xF3\xB1\x86\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x82"],

        ["\xF3\xB1\x86\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x83"],
        ["\xF3\xB1\x86\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x83"],

        ["\xF3\xB1\x86\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x84"],
        ["\xF3\xB1\x86\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x84"],

        ["\xF3\xB1\x86\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x85"],
        ["\xF3\xB1\x86\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x85"],

        ["\xF3\xB1\x86\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x86"],
        ["\xF3\xB1\x86\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x86"],

        ["\xF3\xB1\x86\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x87"],
        ["\xF3\xB1\x86\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x87"],

        ["\xF3\xB1\x86\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x88"],
        ["\xF3\xB1\x86\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x88"],

        ["\xF3\xB1\x86\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x89"],
        ["\xF3\xB1\x86\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x89"],

        ["\xF3\xB1\x86\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8A"],
        ["\xF3\xB1\x86\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8A"],

        ["\xF3\xB1\x86\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8B"],
        ["\xF3\xB1\x86\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8B"],

        ["\xF3\xB1\x86\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8C"],
        ["\xF3\xB1\x86\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8C"],

        ["\xF3\xB1\x86\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8D"],
        ["\xF3\xB1\x86\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8D"],

        ["\xF3\xB1\x86\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8E"],
        ["\xF3\xB1\x86\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8E"],

        ["\xF3\xB1\x86\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8F"],
        ["\xF3\xB1\x86\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8F"],

        ["\xF3\xB1\x86\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x90"],
        ["\xF3\xB1\x86\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x90"],

        ["\xF3\xB1\x86\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x91"],
        ["\xF3\xB1\x86\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x91"],

        ["\xF3\xB1\x86\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x92"],
        ["\xF3\xB1\x86\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x92"],

        ["\xF3\xB1\x86\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x93"],
        ["\xF3\xB1\x86\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x93"],

        ["\xF3\xB1\x86\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x94"],
        ["\xF3\xB1\x86\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x94"],

        ["\xF3\xB1\x86\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x95"],
        ["\xF3\xB1\x86\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x95"],

        ["\xF3\xB1\x86\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x96"],
        ["\xF3\xB1\x86\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x96"],

        ["\xF3\xB1\x86\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x97"],
        ["\xF3\xB1\x86\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x97"],

        ["\xF3\xB1\x86\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x98"],
        ["\xF3\xB1\x86\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x98"],

        ["\xF3\xB1\x86\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x99"],
        ["\xF3\xB1\x86\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x99"],

        ["\xF3\xB1\x86\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9A"],
        ["\xF3\xB1\x86\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9A"],

        ["\xF3\xB1\x86\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9B"],
        ["\xF3\xB1\x86\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9B"],

        ["\xF3\xB1\x86\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9C"],
        ["\xF3\xB1\x86\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9C"],

        ["\xF3\xB1\x86\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9D"],
        ["\xF3\xB1\x86\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9D"],

        ["\xF3\xB1\x86\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9E"],
        ["\xF3\xB1\x86\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9E"],

        ["\xF3\xB1\x86\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9F"],
        ["\xF3\xB1\x86\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9F"],

        ["\xF3\xB1\x86\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA0"],
        ["\xF3\xB1\x86\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA0"],

        ["\xF3\xB1\x86\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA1"],
        ["\xF3\xB1\x86\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA1"],

        ["\xF3\xB1\x86\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA2"],
        ["\xF3\xB1\x86\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA2"],

        ["\xF3\xB1\x86\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA3"],
        ["\xF3\xB1\x86\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA3"],

        ["\xF3\xB1\x86\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA4"],
        ["\xF3\xB1\x86\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA4"],

        ["\xF3\xB1\x86\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA5"],
        ["\xF3\xB1\x86\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA5"],

        ["\xF3\xB1\x86\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA6"],
        ["\xF3\xB1\x86\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA6"],

        ["\xF3\xB1\x86\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA7"],
        ["\xF3\xB1\x86\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA7"],

        ["\xF3\xB1\x86\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA8"],
        ["\xF3\xB1\x86\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA8"],

        ["\xF3\xB1\x86\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA9"],
        ["\xF3\xB1\x86\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA9"],

        ["\xF3\xB1\x86\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAA"],
        ["\xF3\xB1\x86\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAA"],

        ["\xF3\xB1\x86\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAB"],
        ["\xF3\xB1\x86\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAB"],

        ["\xF3\xB1\x86\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAC"],
        ["\xF3\xB1\x86\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAC"],

        ["\xF3\xB1\x86\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAD"],
        ["\xF3\xB1\x86\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAD"],

        ["\xF3\xB1\x86\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAE"],
        ["\xF3\xB1\x86\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAE"],

        ["\xF3\xB1\x86\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAF"],
        ["\xF3\xB1\x86\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAF"],

        ["\xF3\xB1\x86\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB0"],
        ["\xF3\xB1\x86\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB0"],

        ["\xF3\xB1\x86\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB1"],
        ["\xF3\xB1\x86\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB1"],

        ["\xF3\xB1\x86\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB2"],
        ["\xF3\xB1\x86\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB2"],

        ["\xF3\xB1\x86\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB3"],
        ["\xF3\xB1\x86\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB3"],

        ["\xF3\xB1\x86\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB4"],
        ["\xF3\xB1\x86\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB4"],

        ["\xF3\xB1\x86\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB5"],
        ["\xF3\xB1\x86\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB5"],

        ["\xF3\xB1\x86\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB6"],
        ["\xF3\xB1\x86\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB6"],

        ["\xF3\xB1\x86\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB7"],
        ["\xF3\xB1\x86\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB7"],

        ["\xF3\xB1\x86\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB8"],
        ["\xF3\xB1\x86\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB8"],

        ["\xF3\xB1\x86\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB9"],
        ["\xF3\xB1\x86\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB9"],

        ["\xF3\xB1\x86\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBA"],
        ["\xF3\xB1\x86\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBA"],

        ["\xF3\xB1\x86\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBB"],
        ["\xF3\xB1\x86\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBB"],

        ["\xF3\xB1\x86\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBC"],
        ["\xF3\xB1\x86\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBC"],

        ["\xF3\xB1\x86\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBD"],
        ["\xF3\xB1\x86\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBD"],

        ["\xF3\xB1\x86\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBE"],
        ["\xF3\xB1\x86\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBE"],

        ["\xF3\xB1\x86\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBF"],
        ["\xF3\xB1\x86\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBF"],

        ["\xF3\xB1\x87\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x80"],
        ["\xF3\xB1\x87\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x80"],

        ["\xF3\xB1\x87\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x81"],
        ["\xF3\xB1\x87\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x81"],

        ["\xF3\xB1\x87\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x82"],
        ["\xF3\xB1\x87\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x82"],

        ["\xF3\xB1\x87\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x83"],
        ["\xF3\xB1\x87\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x83"],

        ["\xF3\xB1\x87\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x84"],
        ["\xF3\xB1\x87\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x84"],

        ["\xF3\xB1\x87\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x85"],
        ["\xF3\xB1\x87\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x85"],

        ["\xF3\xB1\x87\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x86"],
        ["\xF3\xB1\x87\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x86"],

        ["\xF3\xB1\x87\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x87"],
        ["\xF3\xB1\x87\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x87"],

        ["\xF3\xB1\x87\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x88"],
        ["\xF3\xB1\x87\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x88"],

        ["\xF3\xB1\x87\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x89"],
        ["\xF3\xB1\x87\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x89"],

        ["\xF3\xB1\x87\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8A"],
        ["\xF3\xB1\x87\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8A"],

        ["\xF3\xB1\x87\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8B"],
        ["\xF3\xB1\x87\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8B"],

        ["\xF3\xB1\x87\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8C"],
        ["\xF3\xB1\x87\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8C"],

        ["\xF3\xB1\x87\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8D"],
        ["\xF3\xB1\x87\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8D"],

        ["\xF3\xB1\x87\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8E"],
        ["\xF3\xB1\x87\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8E"],

        ["\xF3\xB1\x87\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8F"],
        ["\xF3\xB1\x87\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8F"],

        ["\xF3\xB1\x87\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x90"],
        ["\xF3\xB1\x87\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x90"],

        ["\xF3\xB1\x87\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x91"],
        ["\xF3\xB1\x87\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x91"],

        ["\xF3\xB1\x87\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x92"],
        ["\xF3\xB1\x87\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x92"],

        ["\xF3\xB1\x87\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x93"],
        ["\xF3\xB1\x87\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x93"],

        ["\xF3\xB1\x87\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x94"],
        ["\xF3\xB1\x87\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x94"],

        ["\xF3\xB1\x87\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x95"],
        ["\xF3\xB1\x87\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x95"],

        ["\xF3\xB1\x87\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x96"],
        ["\xF3\xB1\x87\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x96"],

        ["\xF3\xB1\x87\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x97"],
        ["\xF3\xB1\x87\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x97"],

        ["\xF3\xB1\x87\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x98"],
        ["\xF3\xB1\x87\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x98"],

        ["\xF3\xB1\x87\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x99"],
        ["\xF3\xB1\x87\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x99"],

        ["\xF3\xB1\x87\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9A"],
        ["\xF3\xB1\x87\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9A"],

        ["\xF3\xB1\x87\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9B"],
        ["\xF3\xB1\x87\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9B"],

        ["\xF3\xB1\x87\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9C"],
        ["\xF3\xB1\x87\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9C"],

        ["\xF3\xB1\x87\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9D"],
        ["\xF3\xB1\x87\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9D"],

        ["\xF3\xB1\x87\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9E"],
        ["\xF3\xB1\x87\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9E"],

        ["\xF3\xB1\x87\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9F"],
        ["\xF3\xB1\x87\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9F"],

        ["\xF3\xB1\x87\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA0"],
        ["\xF3\xB1\x87\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA0"],

        ["\xF3\xB1\x87\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA1"],
        ["\xF3\xB1\x87\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA1"],

        ["\xF3\xB1\x87\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA2"],
        ["\xF3\xB1\x87\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA2"],

        ["\xF3\xB1\x87\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA3"],
        ["\xF3\xB1\x87\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA3"],

        ["\xF3\xB1\x87\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA4"],
        ["\xF3\xB1\x87\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA4"],

        ["\xF3\xB1\x87\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA5"],
        ["\xF3\xB1\x87\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA5"],

        ["\xF3\xB1\x87\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA6"],
        ["\xF3\xB1\x87\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA6"],

        ["\xF3\xB1\x87\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA7"],
        ["\xF3\xB1\x87\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA7"],

        ["\xF3\xB1\x87\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA8"],
        ["\xF3\xB1\x87\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA8"],

        ["\xF3\xB1\x87\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA9"],
        ["\xF3\xB1\x87\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA9"],

        ["\xF3\xB1\x87\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAA"],
        ["\xF3\xB1\x87\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAA"],

        ["\xF3\xB1\x87\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAB"],
        ["\xF3\xB1\x87\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAB"],

        ["\xF3\xB1\x87\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAC"],
        ["\xF3\xB1\x87\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAC"],

        ["\xF3\xB1\x87\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAD"],
        ["\xF3\xB1\x87\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAD"],

        ["\xF3\xB1\x87\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAE"],
        ["\xF3\xB1\x87\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAE"],

        ["\xF3\xB1\x87\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAF"],
        ["\xF3\xB1\x87\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAF"],

        ["\xF3\xB1\x87\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB0"],
        ["\xF3\xB1\x87\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB0"],

        ["\xF3\xB1\x87\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB1"],
        ["\xF3\xB1\x87\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB1"],

        ["\xF3\xB1\x87\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB2"],
        ["\xF3\xB1\x87\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB2"],

        ["\xF3\xB1\x87\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB3"],
        ["\xF3\xB1\x87\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB3"],

        ["\xF3\xB1\x87\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB4"],
        ["\xF3\xB1\x87\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB4"],

        ["\xF3\xB1\x87\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB5"],
        ["\xF3\xB1\x87\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB5"],

        ["\xF3\xB1\x87\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB6"],
        ["\xF3\xB1\x87\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB6"],

        ["\xF3\xB1\x87\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB7"],
        ["\xF3\xB1\x87\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB7"],

        ["\xF3\xB1\x87\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB8"],
        ["\xF3\xB1\x87\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB8"],

        ["\xF3\xB1\x87\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB9"],
        ["\xF3\xB1\x87\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB9"],

        ["\xF3\xB1\x87\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBA"],
        ["\xF3\xB1\x87\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBA"],

        ["\xF3\xB1\x87\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBB"],
        ["\xF3\xB1\x87\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBB"],

        ["\xF3\xB1\x87\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBC"],
        ["\xF3\xB1\x87\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBC"],

        ["\xF3\xB1\x87\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBD"],
        ["\xF3\xB1\x87\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBD"],

        ["\xF3\xB1\x87\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBE"],
        ["\xF3\xB1\x87\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBE"],

        ["\xF3\xB1\x87\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBF"],
        ["\xF3\xB1\x87\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBF"],

        ["\xF3\xB1\x88\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x80"],
        ["\xF3\xB1\x88\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x80"],

        ["\xF3\xB1\x88\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x81"],
        ["\xF3\xB1\x88\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x81"],

        ["\xF3\xB1\x88\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x82"],
        ["\xF3\xB1\x88\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x82"],

        ["\xF3\xB1\x88\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x83"],
        ["\xF3\xB1\x88\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x83"],

        ["\xF3\xB1\x88\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x84"],
        ["\xF3\xB1\x88\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x84"],

        ["\xF3\xB1\x88\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x85"],
        ["\xF3\xB1\x88\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x85"],

        ["\xF3\xB1\x88\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x86"],
        ["\xF3\xB1\x88\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x86"],

        ["\xF3\xB1\x88\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x87"],
        ["\xF3\xB1\x88\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x87"],

        ["\xF3\xB1\x88\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x88"],
        ["\xF3\xB1\x88\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x88"],

        ["\xF3\xB1\x88\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x89"],
        ["\xF3\xB1\x88\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x89"],

        ["\xF3\xB1\x88\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8A"],
        ["\xF3\xB1\x88\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8A"],

        ["\xF3\xB1\x88\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8B"],
        ["\xF3\xB1\x88\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8B"],

        ["\xF3\xB1\x88\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8C"],
        ["\xF3\xB1\x88\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8C"],

        ["\xF3\xB1\x88\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8D"],
        ["\xF3\xB1\x88\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8D"],

        ["\xF3\xB1\x88\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8E"],
        ["\xF3\xB1\x88\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8E"],

        ["\xF3\xB1\x88\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8F"],
        ["\xF3\xB1\x88\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8F"],

        ["\xF3\xB1\x88\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x90"],
        ["\xF3\xB1\x88\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x90"],

        ["\xF3\xB1\x88\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x91"],
        ["\xF3\xB1\x88\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x91"],

        ["\xF3\xB1\x88\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x92"],
        ["\xF3\xB1\x88\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x92"],

        ["\xF3\xB1\x88\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x93"],
        ["\xF3\xB1\x88\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x93"],

        ["\xF3\xB1\x88\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x94"],
        ["\xF3\xB1\x88\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x94"],

        ["\xF3\xB1\x88\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x95"],
        ["\xF3\xB1\x88\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x95"],

        ["\xF3\xB1\x88\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x96"],
        ["\xF3\xB1\x88\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x96"],

        ["\xF3\xB1\x89\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x82"],
        ["\xF3\xB1\x89\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x82"],

        ["\xF3\xB1\x89\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x83"],
        ["\xF3\xB1\x89\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x83"],

        ["\xF3\xB1\x89\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x84"],
        ["\xF3\xB1\x89\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x84"],

        ["\xF3\xB1\x89\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x85"],
        ["\xF3\xB1\x89\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x85"],

        ["\xF3\xB1\x89\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x86"],
        ["\xF3\xB1\x89\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x86"],

        ["\xF3\xB1\x89\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x87"],
        ["\xF3\xB1\x89\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x87"],

        ["\xF3\xB1\x89\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x88"],
        ["\xF3\xB1\x89\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x88"],

        ["\xF3\xB1\x89\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x89"],
        ["\xF3\xB1\x89\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x89"],

        ["\xF3\xB1\x89\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8A"],
        ["\xF3\xB1\x89\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8A"],

        ["\xF3\xB1\x89\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8B"],
        ["\xF3\xB1\x89\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8B"],

        ["\xF3\xB1\x89\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8C"],
        ["\xF3\xB1\x89\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8C"],

        ["\xF3\xB1\x89\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8D"],
        ["\xF3\xB1\x89\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8D"],

        ["\xF3\xB1\x89\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8E"],
        ["\xF3\xB1\x89\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8E"],

        ["\xF3\xB1\x89\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8F"],
        ["\xF3\xB1\x89\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8F"],

        ["\xF3\xB1\x89\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x90"],
        ["\xF3\xB1\x89\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x90"],

        ["\xF3\xB1\x89\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x91"],
        ["\xF3\xB1\x89\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x91"],

        ["\xF3\xB1\x89\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x92"],
        ["\xF3\xB1\x89\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x92"],

        ["\xF3\xB1\x89\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x93"],
        ["\xF3\xB1\x89\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x93"],

        ["\xF3\xB1\x89\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x94"],
        ["\xF3\xB1\x89\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x94"],

        ["\xF3\xB1\x89\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x95"],
        ["\xF3\xB1\x89\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x95"],

        ["\xF3\xB1\x89\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x96"],
        ["\xF3\xB1\x89\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x96"],

        ["\xF3\xB1\x89\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x97"],
        ["\xF3\xB1\x89\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x97"],

        ["\xF3\xB1\x89\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x98"],
        ["\xF3\xB1\x89\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x98"],

        ["\xF3\xB1\x89\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x99"],
        ["\xF3\xB1\x89\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x99"],

        ["\xF3\xB1\x89\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9A"],
        ["\xF3\xB1\x89\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9A"],

        ["\xF3\xB1\x89\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9B"],
        ["\xF3\xB1\x89\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9B"],

        ["\xF3\xB1\x89\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9C"],
        ["\xF3\xB1\x89\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9C"],

        ["\xF3\xB1\x89\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9D"],
        ["\xF3\xB1\x89\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9D"],

        ["\xF3\xB1\x89\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9E"],
        ["\xF3\xB1\x89\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9E"],

        ["\xF3\xB1\x89\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9F"],
        ["\xF3\xB1\x89\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9F"],

        ["\xF3\xB1\x89\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA0"],
        ["\xF3\xB1\x89\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA0"],

        ["\xF3\xB1\x89\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA1"],
        ["\xF3\xB1\x89\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA1"],

        ["\xF3\xB1\x89\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA2"],
        ["\xF3\xB1\x89\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA2"],

        ["\xF3\xB1\x89\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA3"],
        ["\xF3\xB1\x89\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA3"],

        ["\xF3\xB1\x89\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA4"],
        ["\xF3\xB1\x89\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA4"],

        ["\xF3\xB1\x89\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA5"],
        ["\xF3\xB1\x89\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA5"],

        ["\xF3\xB1\x89\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA6"],
        ["\xF3\xB1\x89\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA6"],

        ["\xF3\xB1\x89\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA7"],
        ["\xF3\xB1\x89\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA7"],

        ["\xF3\xB1\x89\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA8"],
        ["\xF3\xB1\x89\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA8"],

        ["\xF3\xB1\x89\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA9"],
        ["\xF3\xB1\x89\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA9"],

        ["\xF3\xB1\x89\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAA"],
        ["\xF3\xB1\x89\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAA"],

        ["\xF3\xB1\x89\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAB"],
        ["\xF3\xB1\x89\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAB"],

        ["\xF3\xB1\x89\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAC"],
        ["\xF3\xB1\x89\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAC"],

        ["\xF3\xB1\x89\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAD"],
        ["\xF3\xB1\x89\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAD"],

        ["\xF3\xB1\x89\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAE"],
        ["\xF3\xB1\x89\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAE"],

        ["\xF3\xB1\x89\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAF"],
        ["\xF3\xB1\x89\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAF"],

        ["\xF3\xB1\x89\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB0"],
        ["\xF3\xB1\x89\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB0"],

        ["\xF3\xB1\x89\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB1"],
        ["\xF3\xB1\x89\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB1"],

        ["\xF3\xB1\x89\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB2"],
        ["\xF3\xB1\x89\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB2"],

        ["\xF3\xB1\x89\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB3"],
        ["\xF3\xB1\x89\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB3"],

        ["\xF3\xB1\x89\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB4"],
        ["\xF3\xB1\x89\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB4"],

        ["\xF3\xB1\x89\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB5"],
        ["\xF3\xB1\x89\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB5"],

        ["\xF3\xB1\x89\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB6"],
        ["\xF3\xB1\x89\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB6"],

        ["\xF3\xB1\x89\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB7"],
        ["\xF3\xB1\x89\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB7"],

        ["\xF3\xB1\x89\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB8"],
        ["\xF3\xB1\x89\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB8"],

        ["\xF3\xB1\x89\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB9"],
        ["\xF3\xB1\x89\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB9"],

        ["\xF3\xB1\x89\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBA"],
        ["\xF3\xB1\x89\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBA"],

        ["\xF3\xB1\x89\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBB"],
        ["\xF3\xB1\x89\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBB"],

        ["\xF3\xB1\x89\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBC"],
        ["\xF3\xB1\x89\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBC"],

        ["\xF3\xB1\x89\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBD"],
        ["\xF3\xB1\x89\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBD"],

        ["\xF3\xB1\x89\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBE"],
        ["\xF3\xB1\x89\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBE"],

        ["\xF3\xB1\x89\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBF"],
        ["\xF3\xB1\x89\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBF"],

        ["\xF3\xB1\x8A\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x80"],
        ["\xF3\xB1\x8A\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x80"],

        ["\xF3\xB1\x8A\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x81"],
        ["\xF3\xB1\x8A\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x81"],

        ["\xF3\xB1\x8A\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x82"],
        ["\xF3\xB1\x8A\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x82"],

        ["\xF3\xB1\x8A\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x83"],
        ["\xF3\xB1\x8A\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x83"],

        ["\xF3\xB1\x8A\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x84"],
        ["\xF3\xB1\x8A\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x84"],

        ["\xF3\xB1\x8A\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x85"],
        ["\xF3\xB1\x8A\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x85"],

        ["\xF3\xB1\x8A\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x86"],
        ["\xF3\xB1\x8A\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x86"],

        ["\xF3\xB1\x8A\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x87"],
        ["\xF3\xB1\x8A\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x87"],

        ["\xF3\xB1\x8A\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x88"],
        ["\xF3\xB1\x8A\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x88"],

        ["\xF3\xB1\x8A\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x89"],
        ["\xF3\xB1\x8A\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x89"],

        ["\xF3\xB1\x8A\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8A"],
        ["\xF3\xB1\x8A\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8A"],

        ["\xF3\xB1\x8A\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8B"],
        ["\xF3\xB1\x8A\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8B"],

        ["\xF3\xB1\x8A\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8C"],
        ["\xF3\xB1\x8A\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8C"],

        ["\xF3\xB1\x8A\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8D"],
        ["\xF3\xB1\x8A\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8D"],

        ["\xF3\xB1\x8A\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8E"],
        ["\xF3\xB1\x8A\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8E"],

        ["\xF3\xB1\x8A\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8F"],
        ["\xF3\xB1\x8A\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8F"],

        ["\xF3\xB1\x8A\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x90"],
        ["\xF3\xB1\x8A\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x90"],

        ["\xF3\xB1\x8A\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x91"],
        ["\xF3\xB1\x8A\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x91"],

        ["\xF3\xB1\x8A\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x92"],
        ["\xF3\xB1\x8A\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x92"],

        ["\xF3\xB1\x8A\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x93"],
        ["\xF3\xB1\x8A\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x93"],

        ["\xF3\xB1\x8A\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x94"],
        ["\xF3\xB1\x8A\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x94"],

        ["\xF3\xB1\x8A\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x95"],
        ["\xF3\xB1\x8A\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x95"],

        ["\xF3\xB1\x8A\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x96"],
        ["\xF3\xB1\x8A\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x96"],

        ["\xF3\xB1\x8A\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x97"],
        ["\xF3\xB1\x8A\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x97"],

        ["\xF3\xB1\x8A\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x98"],
        ["\xF3\xB1\x8A\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x98"],

        ["\xF3\xB1\x8A\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x99"],
        ["\xF3\xB1\x8A\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x99"],

        ["\xF3\xB1\x8A\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9A"],
        ["\xF3\xB1\x8A\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9A"],

        ["\xF3\xB1\x8A\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9B"],
        ["\xF3\xB1\x8A\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9B"],

        ["\xF3\xB1\x8A\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9C"],
        ["\xF3\xB1\x8A\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9C"],

        ["\xF3\xB1\x8A\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9D"],
        ["\xF3\xB1\x8A\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9D"],

        ["\xF3\xB1\x8A\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9E"],
        ["\xF3\xB1\x8A\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9E"],

        ["\xF3\xB1\x8A\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9F"],
        ["\xF3\xB1\x8A\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9F"],

        ["\xF3\xB1\x8A\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA0"],
        ["\xF3\xB1\x8A\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA0"],

        ["\xF3\xB1\x8A\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA1"],
        ["\xF3\xB1\x8A\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA1"],

        ["\xF3\xB1\x8A\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA2"],
        ["\xF3\xB1\x8A\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA2"],

        ["\xF3\xB1\x8A\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA3"],
        ["\xF3\xB1\x8A\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA3"],

        ["\xF3\xB1\x8A\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA4"],
        ["\xF3\xB1\x8A\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA4"],

        ["\xF3\xB1\x8A\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA5"],
        ["\xF3\xB1\x8A\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA5"],

        ["\xF3\xB1\x8A\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA6"],
        ["\xF3\xB1\x8A\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA6"],

        ["\xF3\xB1\x8A\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA7"],
        ["\xF3\xB1\x8A\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA7"],

        ["\xF3\xB1\x8A\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA8"],
        ["\xF3\xB1\x8A\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA8"],

        ["\xF3\xB1\x8A\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA9"],
        ["\xF3\xB1\x8A\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA9"],

        ["\xF3\xB1\x8A\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAA"],
        ["\xF3\xB1\x8A\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAA"],

        ["\xF3\xB1\x8A\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAB"],
        ["\xF3\xB1\x8A\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAB"],

        ["\xF3\xB1\x8A\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAC"],
        ["\xF3\xB1\x8A\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAC"],

        ["\xF3\xB1\x8A\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAD"],
        ["\xF3\xB1\x8A\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAD"],

        ["\xF3\xB1\x8A\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAE"],
        ["\xF3\xB1\x8A\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAE"],

        ["\xF3\xB1\x8A\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAF"],
        ["\xF3\xB1\x8A\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAF"],

        ["\xF3\xB1\x8A\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB0"],
        ["\xF3\xB1\x8A\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB0"],

        ["\xF3\xB1\x8A\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB1"],
        ["\xF3\xB1\x8A\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB1"],

        ["\xF3\xB1\x8A\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB2"],
        ["\xF3\xB1\x8A\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB2"],

        ["\xF3\xB1\x8A\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB3"],
        ["\xF3\xB1\x8A\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB3"],

        ["\xF3\xB1\x8A\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB4"],
        ["\xF3\xB1\x8A\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB4"],

        ["\xF3\xB1\x8A\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB5"],
        ["\xF3\xB1\x8A\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB5"],

        ["\xF3\xB1\x8A\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB6"],
        ["\xF3\xB1\x8A\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB6"],

        ["\xF3\xB1\x8A\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB7"],
        ["\xF3\xB1\x8A\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB7"],

        ["\xF3\xB1\x8A\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB8"],
        ["\xF3\xB1\x8A\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB8"],

        ["\xF3\xB1\x8A\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB9"],
        ["\xF3\xB1\x8A\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB9"],

        ["\xF3\xB1\x8A\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBA"],
        ["\xF3\xB1\x8A\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBA"],

        ["\xF3\xB1\x8A\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBB"],
        ["\xF3\xB1\x8A\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBB"],

        ["\xF3\xB1\x8A\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBC"],
        ["\xF3\xB1\x8A\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBC"],

        ["\xF3\xB1\x8A\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBD"],
        ["\xF3\xB1\x8A\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBD"],

        ["\xF3\xB1\x8A\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBE"],
        ["\xF3\xB1\x8A\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBE"],

        ["\xF3\xB1\x8A\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBF"],
        ["\xF3\xB1\x8A\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBF"],

        ["\xF3\xB1\x8B\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x80"],
        ["\xF3\xB1\x8B\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x80"],

        ["\xF3\xB1\x8B\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x81"],
        ["\xF3\xB1\x8B\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x81"],

        ["\xF3\xB1\x8B\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x82"],
        ["\xF3\xB1\x8B\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x82"],

        ["\xF3\xB1\x8B\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x83"],
        ["\xF3\xB1\x8B\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x83"],

        ["\xF3\xB1\x8B\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x84"],
        ["\xF3\xB1\x8B\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x84"],

        ["\xF3\xB1\x8B\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x85"],
        ["\xF3\xB1\x8B\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x85"],

        ["\xF3\xB1\x8B\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x86"],
        ["\xF3\xB1\x8B\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x86"],

        ["\xF3\xB1\x8B\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x87"],
        ["\xF3\xB1\x8B\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x87"],

        ["\xF3\xB1\x8B\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x88"],
        ["\xF3\xB1\x8B\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x88"],

        ["\xF3\xB1\x8B\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x89"],
        ["\xF3\xB1\x8B\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x89"],

        ["\xF3\xB1\x8B\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8A"],
        ["\xF3\xB1\x8B\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8A"],

        ["\xF3\xB1\x8B\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8B"],
        ["\xF3\xB1\x8B\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8B"],

        ["\xF3\xB1\x8B\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8C"],
        ["\xF3\xB1\x8B\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8C"],

        ["\xF3\xB1\x8B\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8D"],
        ["\xF3\xB1\x8B\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8D"],

        ["\xF3\xB1\x8B\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8E"],
        ["\xF3\xB1\x8B\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8E"],

        ["\xF3\xB1\x8B\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8F"],
        ["\xF3\xB1\x8B\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8F"],

        ["\xF3\xB1\x8B\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x90"],
        ["\xF3\xB1\x8B\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x90"],

        ["\xF3\xB1\x8B\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x91"],
        ["\xF3\xB1\x8B\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x91"],

        ["\xF3\xB1\x8B\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x92"],
        ["\xF3\xB1\x8B\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x92"],

        ["\xF3\xB1\x8B\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x93"],
        ["\xF3\xB1\x8B\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x93"],

        ["\xF3\xB1\x8B\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x94"],
        ["\xF3\xB1\x8B\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x94"],

        ["\xF3\xB1\x8B\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x95"],
        ["\xF3\xB1\x8B\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x95"],

        ["\xF3\xB1\x8B\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x96"],
        ["\xF3\xB1\x8B\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x96"],

        ["\xF3\xB1\x8B\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x97"],
        ["\xF3\xB1\x8B\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x97"],

        ["\xF3\xB1\x8B\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x98"],
        ["\xF3\xB1\x8B\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x98"],

        ["\xF3\xB1\x8B\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x99"],
        ["\xF3\xB1\x8B\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x99"],

        ["\xF3\xB1\x8B\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9A"],
        ["\xF3\xB1\x8B\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9A"],

        ["\xF3\xB1\x8B\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9B"],
        ["\xF3\xB1\x8B\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9B"],

        ["\xF3\xB1\x8B\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9C"],
        ["\xF3\xB1\x8B\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9C"],

        ["\xF3\xB1\x8B\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9D"],
        ["\xF3\xB1\x8B\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9D"],

        ["\xF3\xB1\x8B\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9E"],
        ["\xF3\xB1\x8B\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9E"],

        ["\xF3\xB1\x8B\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9F"],
        ["\xF3\xB1\x8B\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9F"],

        ["\xF3\xB1\x8B\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA0"],
        ["\xF3\xB1\x8B\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA0"],

        ["\xF3\xB1\x8B\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA1"],
        ["\xF3\xB1\x8B\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA1"],

        ["\xF3\xB1\x8B\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA2"],
        ["\xF3\xB1\x8B\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA2"],

        ["\xF3\xB1\x8B\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA3"],
        ["\xF3\xB1\x8B\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA3"],

        ["\xF3\xB1\x8B\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA4"],
        ["\xF3\xB1\x8B\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA4"],

        ["\xF3\xB1\x8B\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA5"],
        ["\xF3\xB1\x8B\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA5"],

        ["\xF3\xB1\x8B\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA6"],
        ["\xF3\xB1\x8B\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA6"],

        ["\xF3\xB1\x8B\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA7"],
        ["\xF3\xB1\x8B\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA7"],

        ["\xF3\xB1\x8B\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA8"],
        ["\xF3\xB1\x8B\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA8"],

        ["\xF3\xB1\x8B\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA9"],
        ["\xF3\xB1\x8B\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA9"],

        ["\xF3\xB1\x8B\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAA"],
        ["\xF3\xB1\x8B\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAA"],

        ["\xF3\xB1\x8B\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAB"],
        ["\xF3\xB1\x8B\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAB"],

        ["\xF3\xB1\x8B\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAC"],
        ["\xF3\xB1\x8B\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAC"],

        ["\xF3\xB1\x8B\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAD"],
        ["\xF3\xB1\x8B\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAD"],

        ["\xF3\xB1\x8B\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAE"],
        ["\xF3\xB1\x8B\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAE"],

        ["\xF3\xB1\x8B\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAF"],
        ["\xF3\xB1\x8B\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAF"],

        ["\xF3\xB1\x8B\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB0"],
        ["\xF3\xB1\x8B\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB0"],

        ["\xF3\xB1\x8B\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB1"],
        ["\xF3\xB1\x8B\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB1"],

        ["\xF3\xB1\x8B\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB2"],
        ["\xF3\xB1\x8B\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB2"],

        ["\xF3\xB1\x8B\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB3"],
        ["\xF3\xB1\x8B\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB3"],

        ["\xF3\xB1\x8B\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB4"],
        ["\xF3\xB1\x8B\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB4"],

        ["\xF3\xB1\x8B\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB5"],
        ["\xF3\xB1\x8B\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB5"],

        ["\xF3\xB1\x8B\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB6"],
        ["\xF3\xB1\x8B\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB6"],

        ["\xF3\xB1\x8B\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB7"],
        ["\xF3\xB1\x8B\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB7"],

        ["\xF3\xB1\x8B\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB8"],
        ["\xF3\xB1\x8B\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB8"],

        ["\xF3\xB1\x8B\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB9"],
        ["\xF3\xB1\x8B\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB9"],

        ["\xF3\xB1\x8B\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBA"],
        ["\xF3\xB1\x8B\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBA"],

        ["\xF3\xB1\x8B\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBB"],
        ["\xF3\xB1\x8B\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBB"],

        ["\xF3\xB1\x8B\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBC"],
        ["\xF3\xB1\x8B\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBC"],

        ["\xF3\xB1\x8B\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBD"],
        ["\xF3\xB1\x8B\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBD"],

        ["\xF3\xB1\x8B\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBE"],
        ["\xF3\xB1\x8B\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBE"],

        ["\xF3\xB1\x8B\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBF"],
        ["\xF3\xB1\x8B\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBF"],

        ["\xF3\xB1\x8C\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x80"],
        ["\xF3\xB1\x8C\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x80"],

        ["\xF3\xB1\x8C\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x81"],
        ["\xF3\xB1\x8C\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x81"],

        ["\xF3\xB1\x8C\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x82"],
        ["\xF3\xB1\x8C\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x82"],

        ["\xF3\xB1\x8C\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x83"],
        ["\xF3\xB1\x8C\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x83"],

        ["\xF3\xB1\x8C\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x84"],
        ["\xF3\xB1\x8C\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x84"],

        ["\xF3\xB1\x8C\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x85"],
        ["\xF3\xB1\x8C\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x85"],

        ["\xF3\xB1\x8C\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x86"],
        ["\xF3\xB1\x8C\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x86"],

        ["\xF3\xB1\x8C\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x87"],
        ["\xF3\xB1\x8C\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x87"],

        ["\xF3\xB1\x8C\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x88"],
        ["\xF3\xB1\x8C\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x88"],

        ["\xF3\xB1\x8C\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x89"],
        ["\xF3\xB1\x8C\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x89"],

        ["\xF3\xB1\x8C\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8A"],
        ["\xF3\xB1\x8C\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8A"],

        ["\xF3\xB1\x8C\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8B"],
        ["\xF3\xB1\x8C\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8B"],

        ["\xF3\xB1\x8C\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8C"],
        ["\xF3\xB1\x8C\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8C"],

        ["\xF3\xB1\x8C\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8D"],
        ["\xF3\xB1\x8C\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8D"],

        ["\xF3\xB1\x8C\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8E"],
        ["\xF3\xB1\x8C\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8E"],

        ["\xF3\xB1\x8C\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8F"],
        ["\xF3\xB1\x8C\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8F"],

        ["\xF3\xB1\x8C\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x90"],
        ["\xF3\xB1\x8C\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x90"],

        ["\xF3\xB1\x8C\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x91"],
        ["\xF3\xB1\x8C\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x91"],

        ["\xF3\xB1\x8C\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x92"],
        ["\xF3\xB1\x8C\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x92"],

        ["\xF3\xB1\x8C\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x93"],
        ["\xF3\xB1\x8C\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x93"],

        ["\xF3\xB1\x8C\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x94"],
        ["\xF3\xB1\x8C\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x94"],

        ["\xF3\xB1\x8C\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x95"],
        ["\xF3\xB1\x8C\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x95"],

        ["\xF3\xB1\x8C\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x96"],
        ["\xF3\xB1\x8C\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x96"],

        ["\xF3\xB1\x8C\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x97"],
        ["\xF3\xB1\x8C\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x97"],

        ["\xF3\xB1\x8C\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x98"],
        ["\xF3\xB1\x8C\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x98"],

        ["\xF3\xB1\x8C\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x99"],
        ["\xF3\xB1\x8C\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x99"],

        ["\xF3\xB1\x8C\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9A"],
        ["\xF3\xB1\x8C\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9A"],

        ["\xF3\xB1\x8C\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9B"],
        ["\xF3\xB1\x8C\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9B"],

        ["\xF3\xB1\x8C\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9C"],
        ["\xF3\xB1\x8C\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9C"],

        ["\xF3\xB1\x8C\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9D"],
        ["\xF3\xB1\x8C\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9D"],

        ["\xF3\xB1\x8C\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9E"],
        ["\xF3\xB1\x8C\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9E"],

        ["\xF3\xB1\x8C\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9F"],
        ["\xF3\xB1\x8C\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9F"],

        ["\xF3\xB1\x8C\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA0"],
        ["\xF3\xB1\x8C\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA0"],

        ["\xF3\xB1\x8C\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA1"],
        ["\xF3\xB1\x8C\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA1"],

        ["\xF3\xB1\x8C\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA2"],
        ["\xF3\xB1\x8C\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA2"],

        ["\xF3\xB1\x8C\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA3"],
        ["\xF3\xB1\x8C\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA3"],

        ["\xF3\xB1\x8C\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA4"],
        ["\xF3\xB1\x8C\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA4"],

        ["\xF3\xB1\x8C\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA5"],
        ["\xF3\xB1\x8C\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA5"],

        ["\xF3\xB1\x8C\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA6"],
        ["\xF3\xB1\x8C\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA6"],

        ["\xF3\xB1\x8C\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA7"],
        ["\xF3\xB1\x8C\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA7"],

        ["\xF3\xB1\x8C\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA8"],
        ["\xF3\xB1\x8C\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA8"],

        ["\xF3\xB1\x8C\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA9"],
        ["\xF3\xB1\x8C\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA9"],

        ["\xF3\xB1\x8C\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAA"],
        ["\xF3\xB1\x8C\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAA"],

        ["\xF3\xB1\x8C\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAB"],
        ["\xF3\xB1\x8C\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAB"],

        ["\xF3\xB1\x8C\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAC"],
        ["\xF3\xB1\x8C\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAC"],

        ["\xF3\xB1\x8C\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAD"],
        ["\xF3\xB1\x8C\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAD"],

        ["\xF3\xB1\x8C\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAE"],
        ["\xF3\xB1\x8C\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAE"],

        ["\xF3\xB1\x8C\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAF"],
        ["\xF3\xB1\x8C\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAF"],

        ["\xF3\xB1\x8C\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB0"],
        ["\xF3\xB1\x8C\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB0"],

        ["\xF3\xB1\x8C\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB1"],
        ["\xF3\xB1\x8C\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB1"],

        ["\xF3\xB1\x8C\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB2"],
        ["\xF3\xB1\x8C\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB2"],

        ["\xF3\xB1\x8C\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB3"],
        ["\xF3\xB1\x8C\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB3"],

        ["\xF3\xB1\x8C\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB4"],
        ["\xF3\xB1\x8C\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB4"],

        ["\xF3\xB1\x8C\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB5"],
        ["\xF3\xB1\x8C\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB5"],

        ["\xF3\xB1\x8C\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB6"],
        ["\xF3\xB1\x8C\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB6"],

        ["\xF3\xB1\x8C\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB7"],
        ["\xF3\xB1\x8C\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB7"],

        ["\xF3\xB1\x8C\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB8"],
        ["\xF3\xB1\x8C\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB8"],

        ["\xF3\xB1\x8C\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB9"],
        ["\xF3\xB1\x8C\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB9"],

        ["\xF3\xB1\x8C\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBA"],
        ["\xF3\xB1\x8C\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBA"],

        ["\xF3\xB1\x8C\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBB"],
        ["\xF3\xB1\x8C\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBB"],

        ["\xF3\xB1\x8C\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBC"],
        ["\xF3\xB1\x8C\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBC"],

        ["\xF3\xB1\x8C\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBD"],
        ["\xF3\xB1\x8C\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBD"],

        ["\xF3\xB1\x8C\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBE"],
        ["\xF3\xB1\x8C\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBE"],

        ["\xF3\xB1\x8C\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBF"],
        ["\xF3\xB1\x8C\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBF"],

        ["\xF3\xB1\x8D\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x80"],
        ["\xF3\xB1\x8D\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x80"],

        ["\xF3\xB1\x8D\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x81"],
        ["\xF3\xB1\x8D\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x81"],

        ["\xF3\xB1\x8D\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x82"],
        ["\xF3\xB1\x8D\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x82"],

        ["\xF3\xB1\x8D\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x83"],
        ["\xF3\xB1\x8D\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x83"],

        ["\xF3\xB1\x8D\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x84"],
        ["\xF3\xB1\x8D\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x84"],

        ["\xF3\xB1\x8D\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x85"],
        ["\xF3\xB1\x8D\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x85"],

        ["\xF3\xB1\x8D\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x86"],
        ["\xF3\xB1\x8D\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x86"],

        ["\xF3\xB1\x8D\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x87"],
        ["\xF3\xB1\x8D\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x87"],

        ["\xF3\xB1\x8D\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x88"],
        ["\xF3\xB1\x8D\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x88"],

        ["\xF3\xB1\x8D\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x89"],
        ["\xF3\xB1\x8D\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x89"],

        ["\xF3\xB1\x8D\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8A"],
        ["\xF3\xB1\x8D\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8A"],

        ["\xF3\xB1\x8D\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8B"],
        ["\xF3\xB1\x8D\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8B"],

        ["\xF3\xB1\x8D\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8C"],
        ["\xF3\xB1\x8D\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8C"],

        ["\xF3\xB1\x8D\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8D"],
        ["\xF3\xB1\x8D\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8D"],

        ["\xF3\xB1\x8D\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8E"],
        ["\xF3\xB1\x8D\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8E"],

        ["\xF3\xB1\x8D\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8F"],
        ["\xF3\xB1\x8D\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8F"],

        ["\xF3\xB1\x8D\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x90"],
        ["\xF3\xB1\x8D\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x90"],

        ["\xF3\xB1\x8D\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x91"],
        ["\xF3\xB1\x8D\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x91"],

        ["\xF3\xB1\x8D\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x92"],
        ["\xF3\xB1\x8D\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x92"],

        ["\xF3\xB1\x8D\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x93"],
        ["\xF3\xB1\x8D\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x93"],

        ["\xF3\xB1\x8D\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x94"],
        ["\xF3\xB1\x8D\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x94"],

        ["\xF3\xB1\x8D\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x95"],
        ["\xF3\xB1\x8D\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x95"],

        ["\xF3\xB1\x8D\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x96"],
        ["\xF3\xB1\x8D\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x96"],

        ["\xF3\xB1\x8D\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x97"],
        ["\xF3\xB1\x8D\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x97"],

        ["\xF3\xB1\x8D\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x98"],
        ["\xF3\xB1\x8D\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x98"],

        ["\xF3\xB1\x8D\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x99"],
        ["\xF3\xB1\x8D\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x99"],

        ["\xF3\xB1\x8D\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9A"],
        ["\xF3\xB1\x8D\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9A"],

        ["\xF3\xB1\x8D\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9B"],
        ["\xF3\xB1\x8D\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9B"],

        ["\xF3\xB1\x8D\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9C"],
        ["\xF3\xB1\x8D\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9C"],

        ["\xF3\xB1\x8D\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9D"],
        ["\xF3\xB1\x8D\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9D"],

        ["\xF3\xB1\x8D\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9E"],
        ["\xF3\xB1\x8D\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9E"],

        ["\xF3\xB1\x8D\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9F"],
        ["\xF3\xB1\x8D\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9F"],

        ["\xF3\xB1\x8D\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA0"],
        ["\xF3\xB1\x8D\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA0"],

        ["\xF3\xB1\x8D\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA1"],
        ["\xF3\xB1\x8D\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA1"],

        ["\xF3\xB1\x8D\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA2"],
        ["\xF3\xB1\x8D\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA2"],

        ["\xF3\xB1\x8D\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA3"],
        ["\xF3\xB1\x8D\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA3"],

        ["\xF3\xB1\x8D\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA4"],
        ["\xF3\xB1\x8D\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA4"],

        ["\xF3\xB1\x8D\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA5"],
        ["\xF3\xB1\x8D\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA5"],

        ["\xF3\xB1\x8D\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA6"],
        ["\xF3\xB1\x8D\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA6"],

        ["\xF3\xB1\x8D\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA7"],
        ["\xF3\xB1\x8D\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA7"],

        ["\xF3\xB1\x8D\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA8"],
        ["\xF3\xB1\x8D\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA8"],

        ["\xF3\xB1\x8D\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA9"],
        ["\xF3\xB1\x8D\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA9"],

        ["\xF3\xB1\x8D\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAA"],
        ["\xF3\xB1\x8D\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAA"],

        ["\xF3\xB1\x8D\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAB"],
        ["\xF3\xB1\x8D\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAB"],

        ["\xF3\xB1\x8D\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAC"],
        ["\xF3\xB1\x8D\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAC"],

        ["\xF3\xB1\x8D\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAD"],
        ["\xF3\xB1\x8D\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAD"],

        ["\xF3\xB1\x8D\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAE"],
        ["\xF3\xB1\x8D\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAE"],

        ["\xF3\xB1\x8D\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAF"],
        ["\xF3\xB1\x8D\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAF"],

        ["\xF3\xB1\x8D\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB0"],
        ["\xF3\xB1\x8D\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB0"],

        ["\xF3\xB1\x8D\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB1"],
        ["\xF3\xB1\x8D\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB1"],

        ["\xF3\xB1\x8D\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB2"],
        ["\xF3\xB1\x8D\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB2"],

        ["\xF3\xB1\x8D\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB3"],
        ["\xF3\xB1\x8D\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB3"],

        ["\xF3\xB1\x8D\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB4"],
        ["\xF3\xB1\x8D\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB4"],

        ["\xF3\xB1\x8D\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB5"],
        ["\xF3\xB1\x8D\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB5"],

        ["\xF3\xB1\x8D\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB6"],
        ["\xF3\xB1\x8D\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB6"],

        ["\xF3\xB1\x8D\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB7"],
        ["\xF3\xB1\x8D\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB7"],

        ["\xF3\xB1\x8D\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB8"],
        ["\xF3\xB1\x8D\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB8"],

        ["\xF3\xB1\x8D\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB9"],
        ["\xF3\xB1\x8D\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB9"],

        ["\xF3\xB1\x8D\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBA"],
        ["\xF3\xB1\x8D\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBA"],

        ["\xF3\xB1\x8D\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBB"],
        ["\xF3\xB1\x8D\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBB"],

        ["\xF3\xB1\x8D\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBC"],
        ["\xF3\xB1\x8D\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBC"],

        ["\xF3\xB1\x8D\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBD"],
        ["\xF3\xB1\x8D\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBD"],

        ["\xF3\xB1\x8D\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBE"],
        ["\xF3\xB1\x8D\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBE"],

        ["\xF3\xB1\x8D\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBF"],
        ["\xF3\xB1\x8D\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBF"],

        ["\xF3\xB1\x8E\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x80"],
        ["\xF3\xB1\x8E\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x80"],

        ["\xF3\xB1\x8E\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x81"],
        ["\xF3\xB1\x8E\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x81"],

        ["\xF3\xB1\x8E\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x82"],
        ["\xF3\xB1\x8E\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x82"],

        ["\xF3\xB1\x8E\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x83"],
        ["\xF3\xB1\x8E\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x83"],

        ["\xF3\xB1\x8E\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x84"],
        ["\xF3\xB1\x8E\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x84"],

        ["\xF3\xB1\x8E\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x85"],
        ["\xF3\xB1\x8E\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x85"],

        ["\xF3\xB1\x8E\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x86"],
        ["\xF3\xB1\x8E\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x86"],

        ["\xF3\xB1\x8E\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x87"],
        ["\xF3\xB1\x8E\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x87"],

        ["\xF3\xB1\x8E\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x88"],
        ["\xF3\xB1\x8E\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x88"],

        ["\xF3\xB1\x8E\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x89"],
        ["\xF3\xB1\x8E\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x89"],

        ["\xF3\xB1\x8E\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8A"],
        ["\xF3\xB1\x8E\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8A"],

        ["\xF3\xB1\x8E\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8B"],
        ["\xF3\xB1\x8E\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8B"],

        ["\xF3\xB1\x8E\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8C"],
        ["\xF3\xB1\x8E\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8C"],

        ["\xF3\xB1\x8E\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8D"],
        ["\xF3\xB1\x8E\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8D"],

        ["\xF3\xB1\x8E\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8E"],
        ["\xF3\xB1\x8E\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8E"],

        ["\xF3\xB1\x8E\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8F"],
        ["\xF3\xB1\x8E\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8F"],

        ["\xF3\xB1\x8E\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x90"],
        ["\xF3\xB1\x8E\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x90"],

        ["\xF3\xB1\x8E\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x91"],
        ["\xF3\xB1\x8E\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x91"],

        ["\xF3\xB1\x8E\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x92"],
        ["\xF3\xB1\x8E\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x92"],

        ["\xF3\xB1\x8E\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x93"],
        ["\xF3\xB1\x8E\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x93"],

        ["\xF3\xB1\x8E\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x94"],
        ["\xF3\xB1\x8E\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x94"],

        ["\xF3\xB1\x8E\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x95"],
        ["\xF3\xB1\x8E\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x95"],

        ["\xF3\xB1\x8E\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x96"],
        ["\xF3\xB1\x8E\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x96"],

        ["\xF3\xB1\x8E\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x97"],
        ["\xF3\xB1\x8E\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x97"],

        ["\xF3\xB1\x8E\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x98"],
        ["\xF3\xB1\x8E\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x98"],

        ["\xF3\xB1\x8E\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x99"],
        ["\xF3\xB1\x8E\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x99"],

        ["\xF3\xB1\x8E\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9A"],
        ["\xF3\xB1\x8E\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9A"],

        ["\xF3\xB1\x8E\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9B"],
        ["\xF3\xB1\x8E\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9B"],

        ["\xF3\xB1\x8E\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9C"],
        ["\xF3\xB1\x8E\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9C"],

        ["\xF3\xB1\x8E\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9D"],
        ["\xF3\xB1\x8E\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9D"],

        ["\xF3\xB1\x8E\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9E"],
        ["\xF3\xB1\x8E\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9E"],

        ["\xF3\xB1\x8E\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9F"],
        ["\xF3\xB1\x8E\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9F"],

        ["\xF3\xB1\x8E\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA0"],
        ["\xF3\xB1\x8E\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA0"],

        ["\xF3\xB1\x8E\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA1"],
        ["\xF3\xB1\x8E\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA1"],

        ["\xF3\xB1\x8E\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA2"],
        ["\xF3\xB1\x8E\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA2"],

        ["\xF3\xB1\x8E\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA3"],
        ["\xF3\xB1\x8E\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA3"],

        ["\xF3\xB1\x8E\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA4"],
        ["\xF3\xB1\x8E\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA4"],

        ["\xF3\xB1\x8E\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA5"],
        ["\xF3\xB1\x8E\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA5"],

        ["\xF3\xB1\x8E\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA6"],
        ["\xF3\xB1\x8E\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA6"],

        ["\xF3\xB1\x8E\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA7"],
        ["\xF3\xB1\x8E\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA7"],

        ["\xF3\xB1\x8E\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA8"],
        ["\xF3\xB1\x8E\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA8"],

        ["\xF3\xB1\x8E\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA9"],
        ["\xF3\xB1\x8E\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA9"],

        ["\xF3\xB1\x8E\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAA"],
        ["\xF3\xB1\x8E\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAA"],

        ["\xF3\xB1\x8E\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAB"],
        ["\xF3\xB1\x8E\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAB"],

        ["\xF3\xB1\x8E\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAC"],
        ["\xF3\xB1\x8E\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAC"],

        ["\xF3\xB1\x8E\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAD"],
        ["\xF3\xB1\x8E\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAD"],

        ["\xF3\xB1\x8E\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAE"],
        ["\xF3\xB1\x8E\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAE"],

        ["\xF3\xB1\x8E\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAF"],
        ["\xF3\xB1\x8E\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAF"],

        ["\xF3\xB1\x8E\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB0"],
        ["\xF3\xB1\x8E\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB0"],

        ["\xF3\xB1\x8E\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB1"],
        ["\xF3\xB1\x8E\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB1"],

        ["\xF3\xB1\x8E\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB2"],
        ["\xF3\xB1\x8E\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB2"],

        ["\xF3\xB1\x8E\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB3"],
        ["\xF3\xB1\x8E\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB3"],

        ["\xF3\xB1\x8E\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB4"],
        ["\xF3\xB1\x8E\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB4"],

        ["\xF3\xB1\x8E\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB5"],
        ["\xF3\xB1\x8E\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB5"],

        ["\xF3\xB1\x8E\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB6"],
        ["\xF3\xB1\x8E\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB6"],

        ["\xF3\xB1\x8E\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB7"],
        ["\xF3\xB1\x8E\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB7"],

        ["\xF3\xB1\x8E\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB8"],
        ["\xF3\xB1\x8E\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB8"],

        ["\xF3\xB1\x8E\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB9"],
        ["\xF3\xB1\x8E\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB9"],

        ["\xF3\xB1\x8E\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBA"],
        ["\xF3\xB1\x8E\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBA"],

        ["\xF3\xB1\x8E\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBB"],
        ["\xF3\xB1\x8E\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBB"],

        ["\xF3\xB1\x8E\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBC"],
        ["\xF3\xB1\x8E\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBC"],

        ["\xF3\xB1\x8E\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBD"],
        ["\xF3\xB1\x8E\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBD"],

        ["\xF3\xB1\x8E\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBE"],
        ["\xF3\xB1\x8E\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBE"],

        ["\xF3\xB1\x8E\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBF"],
        ["\xF3\xB1\x8E\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBF"],

        ["\xF3\xB1\x8F\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x80"],
        ["\xF3\xB1\x8F\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x80"],

        ["\xF3\xB1\x8F\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x81"],
        ["\xF3\xB1\x8F\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x81"],

        ["\xF3\xB1\x8F\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x82"],
        ["\xF3\xB1\x8F\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x82"],

        ["\xF3\xB1\x8F\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x83"],
        ["\xF3\xB1\x8F\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x83"],

        ["\xF3\xB1\x8F\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x84"],
        ["\xF3\xB1\x8F\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x84"],

        ["\xF3\xB1\x8F\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x85"],
        ["\xF3\xB1\x8F\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x85"],

        ["\xF3\xB1\x8F\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x86"],
        ["\xF3\xB1\x8F\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x86"],

        ["\xF3\xB1\x8F\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x87"],
        ["\xF3\xB1\x8F\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x87"],

        ["\xF3\xB1\x8F\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x88"],
        ["\xF3\xB1\x8F\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x88"],

        ["\xF3\xB1\x8F\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x89"],
        ["\xF3\xB1\x8F\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x89"],

        ["\xF3\xB1\x8F\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8A"],
        ["\xF3\xB1\x8F\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8A"],

        ["\xF3\xB1\x8F\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8B"],
        ["\xF3\xB1\x8F\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8B"],

        ["\xF3\xB1\x8F\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8C"],
        ["\xF3\xB1\x8F\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8C"],

        ["\xF3\xB1\x8F\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8D"],
        ["\xF3\xB1\x8F\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8D"],

        ["\xF3\xB1\x8F\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8E"],
        ["\xF3\xB1\x8F\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8E"],

        ["\xF3\xB1\x8F\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8F"],
        ["\xF3\xB1\x8F\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8F"],

        ["\xF3\xB1\x8F\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x90"],
        ["\xF3\xB1\x8F\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x90"],

        ["\xF3\xB1\x8F\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x91"],
        ["\xF3\xB1\x8F\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x91"],

        ["\xF3\xB1\x8F\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x92"],
        ["\xF3\xB1\x8F\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x92"],

        ["\xF3\xB1\x8F\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x93"],
        ["\xF3\xB1\x8F\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x93"],

        ["\xF3\xB1\x8F\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x94"],
        ["\xF3\xB1\x8F\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x94"],

        ["\xF3\xB1\x8F\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x95"],
        ["\xF3\xB1\x8F\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x95"],

        ["\xF3\xB1\x8F\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x96"],
        ["\xF3\xB1\x8F\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x96"],

        ["\xF3\xB1\x8F\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x97"],
        ["\xF3\xB1\x8F\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x97"],

        ["\xF3\xB1\x8F\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x98"],
        ["\xF3\xB1\x8F\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x98"],

        ["\xF3\xB1\x8F\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x99"],
        ["\xF3\xB1\x8F\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x99"],

        ["\xF3\xB1\x8F\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9A"],
        ["\xF3\xB1\x8F\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9A"],

        ["\xF3\xB1\x8F\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9B"],
        ["\xF3\xB1\x8F\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9B"],

        ["\xF3\xB1\x8F\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9C"],
        ["\xF3\xB1\x8F\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9C"],

        ["\xF3\xB1\x8F\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9D"],
        ["\xF3\xB1\x8F\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9D"],

        ["\xF3\xB1\x8F\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9E"],
        ["\xF3\xB1\x8F\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9E"],

        ["\xF3\xB1\x8F\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9F"],
        ["\xF3\xB1\x8F\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9F"],

        ["\xF3\xB1\x8F\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA0"],
        ["\xF3\xB1\x8F\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA0"],

        ["\xF3\xB1\x8F\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA1"],
        ["\xF3\xB1\x8F\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA1"],

        ["\xF3\xB1\x8F\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA2"],
        ["\xF3\xB1\x8F\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA2"],

        ["\xF3\xB1\x8F\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA3"],
        ["\xF3\xB1\x8F\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA3"],

        ["\xF3\xB1\x8F\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA4"],
        ["\xF3\xB1\x8F\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA4"],

        ["\xF3\xB1\x8F\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA5"],
        ["\xF3\xB1\x8F\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA5"],

        ["\xF3\xB1\x8F\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA6"],
        ["\xF3\xB1\x8F\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA6"],

        ["\xF3\xB1\x8F\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA7"],
        ["\xF3\xB1\x8F\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA7"],

        ["\xF3\xB1\x8F\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA8"],
        ["\xF3\xB1\x8F\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA8"],

        ["\xF3\xB1\x8F\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA9"],
        ["\xF3\xB1\x8F\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA9"],

        ["\xF3\xB1\x8F\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAA"],
        ["\xF3\xB1\x8F\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAA"],

        ["\xF3\xB1\x8F\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAB"],
        ["\xF3\xB1\x8F\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAB"],

        ["\xF3\xB1\x8F\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAC"],
        ["\xF3\xB1\x8F\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAC"],

        ["\xF3\xB1\x8F\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAD"],
        ["\xF3\xB1\x8F\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAD"],

        ["\xF3\xB1\x8F\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAE"],
        ["\xF3\xB1\x8F\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAE"],

        ["\xF3\xB1\x8F\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAF"],
        ["\xF3\xB1\x8F\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAF"],

        ["\xF3\xB1\x8F\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB0"],
        ["\xF3\xB1\x8F\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB0"],

        ["\xF3\xB1\x8F\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB1"],
        ["\xF3\xB1\x8F\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB1"],

        ["\xF3\xB1\x8F\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB2"],
        ["\xF3\xB1\x8F\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB2"],

        ["\xF3\xB1\x8F\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB3"],
        ["\xF3\xB1\x8F\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB3"],

        ["\xF3\xB1\x8F\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB4"],
        ["\xF3\xB1\x8F\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB4"],

        ["\xF3\xB1\x8F\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB5"],
        ["\xF3\xB1\x8F\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB5"],

        ["\xF3\xB1\x8F\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB6"],
        ["\xF3\xB1\x8F\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB6"],

        ["\xF3\xB1\x8F\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB7"],
        ["\xF3\xB1\x8F\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB7"],

        ["\xF3\xB1\x8F\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB8"],
        ["\xF3\xB1\x8F\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB8"],

        ["\xF3\xB1\x8F\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB9"],
        ["\xF3\xB1\x8F\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB9"],

        ["\xF3\xB1\x8F\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBA"],
        ["\xF3\xB1\x8F\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBA"],

        ["\xF3\xB1\x8F\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBB"],
        ["\xF3\xB1\x8F\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBB"],

        ["\xF3\xB1\x8F\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBC"],
        ["\xF3\xB1\x8F\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBC"],

        ["\xF3\xB1\x8F\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBD"],
        ["\xF3\xB1\x8F\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBD"],

        ["\xF3\xB1\x8F\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBE"],
        ["\xF3\xB1\x8F\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBE"],

        ["\xF3\xB1\x8F\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBF"],
        ["\xF3\xB1\x8F\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBF"],

        ["\xF3\xB1\x90\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x80"],
        ["\xF3\xB1\x90\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x80"],

        ["\xF3\xB1\x90\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x81"],
        ["\xF3\xB1\x90\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x81"],

        ["\xF3\xB1\x90\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x82"],
        ["\xF3\xB1\x90\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x82"],

        ["\xF3\xB1\x90\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x83"],
        ["\xF3\xB1\x90\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x83"],

        ["\xF3\xB1\x90\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x84"],
        ["\xF3\xB1\x90\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x84"],

        ["\xF3\xB1\x90\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x85"],
        ["\xF3\xB1\x90\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x85"],

        ["\xF3\xB1\x90\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x86"],
        ["\xF3\xB1\x90\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x86"],

        ["\xF3\xB1\x90\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x87"],
        ["\xF3\xB1\x90\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x87"],

        ["\xF3\xB1\x90\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x88"],
        ["\xF3\xB1\x90\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x88"],

        ["\xF3\xB1\x90\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x89"],
        ["\xF3\xB1\x90\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x89"],

        ["\xF3\xB1\x90\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8A"],
        ["\xF3\xB1\x90\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8A"],

        ["\xF3\xB1\x90\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8B"],
        ["\xF3\xB1\x90\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8B"],

        ["\xF3\xB1\x90\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8C"],
        ["\xF3\xB1\x90\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8C"],

        ["\xF3\xB1\x90\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8D"],
        ["\xF3\xB1\x90\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8D"],

        ["\xF3\xB1\x90\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8E"],
        ["\xF3\xB1\x90\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8E"],

        ["\xF3\xB1\x90\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8F"],
        ["\xF3\xB1\x90\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8F"],

        ["\xF3\xB1\x90\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x90"],
        ["\xF3\xB1\x90\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x90"],

        ["\xF3\xB1\x90\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x91"],
        ["\xF3\xB1\x90\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x91"],

        ["\xF3\xB1\x90\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x92"],
        ["\xF3\xB1\x90\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x92"],

        ["\xF3\xB1\x90\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x93"],
        ["\xF3\xB1\x90\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x93"],

        ["\xF3\xB1\x90\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x94"],
        ["\xF3\xB1\x90\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x94"],

        ["\xF3\xB1\x90\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x95"],
        ["\xF3\xB1\x90\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x95"],

        ["\xF3\xB1\x90\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x96"],
        ["\xF3\xB1\x90\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x96"],

        ["\xF3\xB1\x90\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x97"],
        ["\xF3\xB1\x90\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x97"],

        ["\xF3\xB1\x90\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x98"],
        ["\xF3\xB1\x90\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x98"],

        ["\xF3\xB1\x90\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x99"],
        ["\xF3\xB1\x90\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x99"],

        ["\xF3\xB1\x90\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9A"],
        ["\xF3\xB1\x90\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9A"],

        ["\xF3\xB1\x90\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9B"],
        ["\xF3\xB1\x90\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9B"],

        ["\xF3\xB1\x90\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9C"],
        ["\xF3\xB1\x90\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9C"],

        ["\xF3\xB1\x90\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9D"],
        ["\xF3\xB1\x90\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9D"],

        ["\xF3\xB1\x90\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9E"],
        ["\xF3\xB1\x90\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9E"],

        ["\xF3\xB1\x90\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9F"],
        ["\xF3\xB1\x90\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9F"],

        ["\xF3\xB1\x90\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA0"],
        ["\xF3\xB1\x90\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA0"],

        ["\xF3\xB1\x90\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA1"],
        ["\xF3\xB1\x90\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA1"],

        ["\xF3\xB1\x90\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA2"],
        ["\xF3\xB1\x90\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA2"],

        ["\xF3\xB1\x90\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA3"],
        ["\xF3\xB1\x90\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA3"],

        ["\xF3\xB1\x90\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA4"],
        ["\xF3\xB1\x90\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA4"],

        ["\xF3\xB1\x90\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA5"],
        ["\xF3\xB1\x90\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA5"],

        ["\xF3\xB1\x90\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA6"],
        ["\xF3\xB1\x90\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA6"],

        ["\xF3\xB1\x90\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA7"],
        ["\xF3\xB1\x90\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA7"],

        ["\xF3\xB1\x90\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA8"],
        ["\xF3\xB1\x90\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA8"],

        ["\xF3\xB1\x90\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA9"],
        ["\xF3\xB1\x90\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA9"],

        ["\xF3\xB1\x90\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAA"],
        ["\xF3\xB1\x90\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAA"],

        ["\xF3\xB1\x90\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAB"],
        ["\xF3\xB1\x90\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAB"],

        ["\xF3\xB1\x90\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAC"],
        ["\xF3\xB1\x90\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAC"],

        ["\xF3\xB1\x90\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAD"],
        ["\xF3\xB1\x90\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAD"],

        ["\xF3\xB1\x90\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAE"],
        ["\xF3\xB1\x90\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAE"],

        ["\xF3\xB1\x90\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAF"],
        ["\xF3\xB1\x90\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAF"],

        ["\xF3\xB1\x90\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB0"],
        ["\xF3\xB1\x90\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB0"],

        ["\xF3\xB1\x90\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB1"],
        ["\xF3\xB1\x90\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB1"],

        ["\xF3\xB1\x90\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB2"],
        ["\xF3\xB1\x90\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB2"],

        ["\xF3\xB1\x90\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB3"],
        ["\xF3\xB1\x90\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB3"],

        ["\xF3\xB1\x90\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB4"],
        ["\xF3\xB1\x90\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB4"],

        ["\xF3\xB1\x90\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB5"],
        ["\xF3\xB1\x90\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB5"],

        ["\xF3\xB1\x90\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB6"],
        ["\xF3\xB1\x90\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB6"],

        ["\xF3\xB1\x90\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB7"],
        ["\xF3\xB1\x90\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB7"],

        ["\xF3\xB1\x90\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB8"],
        ["\xF3\xB1\x90\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB8"],

        ["\xF3\xB1\x90\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB9"],
        ["\xF3\xB1\x90\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB9"],

        ["\xF3\xB1\x90\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBA"],
        ["\xF3\xB1\x90\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBA"],

        ["\xF3\xB1\x90\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBB"],
        ["\xF3\xB1\x90\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBB"],

        ["\xF3\xB1\x90\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBC"],
        ["\xF3\xB1\x90\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBC"],

        ["\xF3\xB1\x90\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBD"],
        ["\xF3\xB1\x90\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBD"],

        ["\xF3\xB1\x90\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBE"],
        ["\xF3\xB1\x90\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBE"],

        ["\xF3\xB1\x90\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBF"],
        ["\xF3\xB1\x90\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBF"],

        ["\xF3\xB1\x91\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x80"],
        ["\xF3\xB1\x91\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x80"],

        ["\xF3\xB1\x91\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x81"],
        ["\xF3\xB1\x91\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x81"],

        ["\xF3\xB1\x91\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x82"],
        ["\xF3\xB1\x91\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x82"],

        ["\xF3\xB1\x91\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x83"],
        ["\xF3\xB1\x91\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x83"],

        ["\xF3\xB1\x91\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x84"],
        ["\xF3\xB1\x91\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x84"],

        ["\xF3\xB1\x91\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x85"],
        ["\xF3\xB1\x91\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x85"],

        ["\xF3\xB1\x91\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x86"],
        ["\xF3\xB1\x91\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x86"],

        ["\xF3\xB1\x91\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x87"],
        ["\xF3\xB1\x91\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x87"],

        ["\xF3\xB1\x91\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x88"],
        ["\xF3\xB1\x91\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x88"],

        ["\xF3\xB1\x91\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x89"],
        ["\xF3\xB1\x91\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x89"],

        ["\xF3\xB1\x91\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8A"],
        ["\xF3\xB1\x91\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8A"],

        ["\xF3\xB1\x91\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8B"],
        ["\xF3\xB1\x91\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8B"],

        ["\xF3\xB1\x91\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8C"],
        ["\xF3\xB1\x91\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8C"],

        ["\xF3\xB1\x91\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8D"],
        ["\xF3\xB1\x91\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8D"],

        ["\xF3\xB1\x91\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8E"],
        ["\xF3\xB1\x91\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8E"],

        ["\xF3\xB1\x91\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8F"],
        ["\xF3\xB1\x91\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8F"],

        ["\xF3\xB1\x91\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x90"],
        ["\xF3\xB1\x91\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x90"],

        ["\xF3\xB1\x91\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x91"],
        ["\xF3\xB1\x91\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x91"],

        ["\xF3\xB1\x91\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x92"],
        ["\xF3\xB1\x91\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x92"],

        ["\xF3\xB1\x91\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x93"],
        ["\xF3\xB1\x91\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x93"],

        ["\xF3\xB1\x91\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x94"],
        ["\xF3\xB1\x91\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x94"],

        ["\xF3\xB1\x91\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x95"],
        ["\xF3\xB1\x91\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x95"],

        ["\xF3\xB1\x91\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x96"],
        ["\xF3\xB1\x91\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x96"],

        ["\xF3\xB1\x91\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x97"],
        ["\xF3\xB1\x91\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x97"],

        ["\xF3\xB1\x91\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x98"],
        ["\xF3\xB1\x91\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x98"],

        ["\xF3\xB1\x91\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x99"],
        ["\xF3\xB1\x91\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x99"],

        ["\xF3\xB1\x91\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9A"],
        ["\xF3\xB1\x91\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9A"],

        ["\xF3\xB1\x91\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9B"],
        ["\xF3\xB1\x91\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9B"],

        ["\xF3\xB1\x91\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9C"],
        ["\xF3\xB1\x91\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9C"],

        ["\xF3\xB1\x91\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9D"],
        ["\xF3\xB1\x91\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9D"],

        ["\xF3\xB1\x91\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9E"],
        ["\xF3\xB1\x91\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9E"],

        ["\xF3\xB1\x91\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9F"],
        ["\xF3\xB1\x91\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9F"],

        ["\xF3\xB1\x91\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA0"],
        ["\xF3\xB1\x91\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA0"],

        ["\xF3\xB1\x91\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA1"],
        ["\xF3\xB1\x91\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA1"],

        ["\xF3\xB1\x91\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA2"],
        ["\xF3\xB1\x91\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA2"],

        ["\xF3\xB1\x91\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA3"],
        ["\xF3\xB1\x91\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA3"],

        ["\xF3\xB1\x91\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA4"],
        ["\xF3\xB1\x91\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA4"],

        ["\xF3\xB1\x91\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA5"],
        ["\xF3\xB1\x91\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA5"],

        ["\xF3\xB1\x91\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA6"],
        ["\xF3\xB1\x91\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA6"],

        ["\xF3\xB1\x91\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA7"],
        ["\xF3\xB1\x91\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA7"],

        ["\xF3\xB1\x91\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA8"],
        ["\xF3\xB1\x91\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA8"],

        ["\xF3\xB1\x91\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA9"],
        ["\xF3\xB1\x91\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA9"],

        ["\xF3\xB1\x91\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAA"],
        ["\xF3\xB1\x91\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAA"],

        ["\xF3\xB1\x91\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAB"],
        ["\xF3\xB1\x91\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAB"],

        ["\xF3\xB1\x91\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAC"],
        ["\xF3\xB1\x91\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAC"],

        ["\xF3\xB1\x91\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAD"],
        ["\xF3\xB1\x91\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAD"],

        ["\xF3\xB1\x91\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAE"],
        ["\xF3\xB1\x91\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAE"],

        ["\xF3\xB1\x91\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAF"],
        ["\xF3\xB1\x91\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAF"],

        ["\xF3\xB1\x91\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB0"],
        ["\xF3\xB1\x91\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB0"],

        ["\xF3\xB1\x91\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB1"],
        ["\xF3\xB1\x91\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB1"],

        ["\xF3\xB1\x91\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB2"],
        ["\xF3\xB1\x91\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB2"],

        ["\xF3\xB1\x91\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB3"],
        ["\xF3\xB1\x91\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB3"],

        ["\xF3\xB1\x91\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB4"],
        ["\xF3\xB1\x91\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB4"],

        ["\xF3\xB1\x91\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB5"],
        ["\xF3\xB1\x91\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB5"],

        ["\xF3\xB1\x91\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB6"],
        ["\xF3\xB1\x91\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB6"],

        ["\xF3\xB1\x91\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB7"],
        ["\xF3\xB1\x91\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB7"],

        ["\xF3\xB1\x91\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB8"],
        ["\xF3\xB1\x91\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB8"],

        ["\xF3\xB1\x91\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB9"],
        ["\xF3\xB1\x91\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB9"],

        ["\xF3\xB1\x91\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBA"],
        ["\xF3\xB1\x91\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBA"],

        ["\xF3\xB1\x91\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBB"],
        ["\xF3\xB1\x91\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBB"],

        ["\xF3\xB1\x91\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBC"],
        ["\xF3\xB1\x91\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBC"],

        ["\xF3\xB1\x91\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBD"],
        ["\xF3\xB1\x91\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBD"],

        ["\xF3\xB1\x91\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBE"],
        ["\xF3\xB1\x91\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBE"],

        ["\xF3\xB1\x91\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBF"],
        ["\xF3\xB1\x91\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBF"],

        ["\xF3\xB1\x92\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x80"],
        ["\xF3\xB1\x92\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x80"],

        ["\xF3\xB1\x92\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x81"],
        ["\xF3\xB1\x92\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x81"],

        ["\xF3\xB1\x92\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x82"],
        ["\xF3\xB1\x92\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x82"],

        ["\xF3\xB1\x92\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x83"],
        ["\xF3\xB1\x92\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x83"],

        ["\xF3\xB1\x92\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x84"],
        ["\xF3\xB1\x92\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x84"],

        ["\xF3\xB1\x92\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x85"],
        ["\xF3\xB1\x92\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x85"],

        ["\xF3\xB1\x92\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x86"],
        ["\xF3\xB1\x92\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x86"],

        ["\xF3\xB1\x92\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x87"],
        ["\xF3\xB1\x92\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x87"],

        ["\xF3\xB1\x92\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x88"],
        ["\xF3\xB1\x92\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x88"],

        ["\xF3\xB1\x92\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x89"],
        ["\xF3\xB1\x92\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x89"],

        ["\xF3\xB1\x92\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8A"],
        ["\xF3\xB1\x92\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8A"],

        ["\xF3\xB1\x92\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8B"],
        ["\xF3\xB1\x92\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8B"],

        ["\xF3\xB1\x92\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8C"],
        ["\xF3\xB1\x92\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8C"],

        ["\xF3\xB1\x92\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8D"],
        ["\xF3\xB1\x92\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8D"],

        ["\xF3\xB1\x92\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8E"],
        ["\xF3\xB1\x92\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8E"],

        ["\xF3\xB1\x92\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8F"],
        ["\xF3\xB1\x92\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8F"],

        ["\xF3\xB1\x92\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x90"],
        ["\xF3\xB1\x92\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x90"],

        ["\xF3\xB1\x92\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x91"],
        ["\xF3\xB1\x92\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x91"],

        ["\xF3\xB1\x92\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x92"],
        ["\xF3\xB1\x92\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x92"],

        ["\xF3\xB1\x92\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x93"],
        ["\xF3\xB1\x92\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x93"],

        ["\xF3\xB1\x92\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x94"],
        ["\xF3\xB1\x92\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x94"],

        ["\xF3\xB1\x92\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x95"],
        ["\xF3\xB1\x92\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x95"],

        ["\xF3\xB1\x92\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x96"],
        ["\xF3\xB1\x92\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x96"],

        ["\xF3\xB1\x92\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x97"],
        ["\xF3\xB1\x92\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x97"],

        ["\xF3\xB1\x92\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x98"],
        ["\xF3\xB1\x92\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x98"],

        ["\xF3\xB1\x92\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x99"],
        ["\xF3\xB1\x92\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x99"],

        ["\xF3\xB1\x92\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9A"],
        ["\xF3\xB1\x92\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9A"],

        ["\xF3\xB1\x92\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9B"],
        ["\xF3\xB1\x92\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9B"],

        ["\xF3\xB1\x92\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9C"],
        ["\xF3\xB1\x92\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9C"],

        ["\xF3\xB1\x92\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9D"],
        ["\xF3\xB1\x92\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9D"],

        ["\xF3\xB1\x92\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9E"],
        ["\xF3\xB1\x92\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9E"],

        ["\xF3\xB1\x92\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9F"],
        ["\xF3\xB1\x92\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9F"],

        ["\xF3\xB1\x92\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA0"],
        ["\xF3\xB1\x92\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA0"],

        ["\xF3\xB1\x92\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA1"],
        ["\xF3\xB1\x92\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA1"],

        ["\xF3\xB1\x92\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA2"],
        ["\xF3\xB1\x92\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA2"],

        ["\xF3\xB1\x92\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA3"],
        ["\xF3\xB1\x92\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA3"],

        ["\xF3\xB1\x92\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA4"],
        ["\xF3\xB1\x92\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA4"],

        ["\xF3\xB1\x92\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA5"],
        ["\xF3\xB1\x92\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA5"],

        ["\xF3\xB1\x92\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA6"],
        ["\xF3\xB1\x92\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA6"],

        ["\xF3\xB1\x92\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA7"],
        ["\xF3\xB1\x92\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA7"],

        ["\xF3\xB1\x92\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA8"],
        ["\xF3\xB1\x92\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA8"],

        ["\xF3\xB1\x92\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA9"],
        ["\xF3\xB1\x92\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA9"],

        ["\xF3\xB1\x92\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAA"],
        ["\xF3\xB1\x92\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAA"],

        ["\xF3\xB1\x92\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAB"],
        ["\xF3\xB1\x92\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAB"],

        ["\xF3\xB1\x92\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAC"],
        ["\xF3\xB1\x92\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAC"],

        ["\xF3\xB1\x92\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAD"],
        ["\xF3\xB1\x92\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAD"],

        ["\xF3\xB1\x92\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAE"],
        ["\xF3\xB1\x92\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAE"],

        ["\xF3\xB1\x92\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAF"],
        ["\xF3\xB1\x92\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAF"],

        ["\xF3\xB1\x92\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB0"],
        ["\xF3\xB1\x92\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB0"],

        ["\xF3\xB1\x92\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB1"],
        ["\xF3\xB1\x92\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB1"],

        ["\xF3\xB1\x92\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB2"],
        ["\xF3\xB1\x92\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB2"],

        ["\xF3\xB1\x92\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB3"],
        ["\xF3\xB1\x92\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB3"],

        ["\xF3\xB1\x92\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB4"],
        ["\xF3\xB1\x92\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB4"],

        ["\xF3\xB1\x92\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB5"],
        ["\xF3\xB1\x92\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB5"],

        ["\xF3\xB1\x92\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB6"],
        ["\xF3\xB1\x92\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB6"],

        ["\xF3\xB1\x92\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB7"],
        ["\xF3\xB1\x92\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB7"],

        ["\xF3\xB1\x92\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB8"],
        ["\xF3\xB1\x92\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB8"],

        ["\xF3\xB1\x92\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB9"],
        ["\xF3\xB1\x92\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB9"],

        ["\xF3\xB1\x92\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBA"],
        ["\xF3\xB1\x92\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBA"],

        ["\xF3\xB1\x92\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBB"],
        ["\xF3\xB1\x92\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBB"],

        ["\xF3\xB1\x92\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBC"],
        ["\xF3\xB1\x92\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBC"],

        ["\xF3\xB1\x92\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBD"],
        ["\xF3\xB1\x92\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBD"],

        ["\xF3\xB1\x92\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBE"],
        ["\xF3\xB1\x92\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBE"],

        ["\xF3\xB1\x92\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBF"],
        ["\xF3\xB1\x92\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBF"],

        ["\xF3\xB1\x93\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x80"],
        ["\xF3\xB1\x93\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x80"],

        ["\xF3\xB1\x93\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x81"],
        ["\xF3\xB1\x93\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x81"],

        ["\xF3\xB1\x93\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x82"],
        ["\xF3\xB1\x93\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x82"],

        ["\xF3\xB1\x93\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x83"],
        ["\xF3\xB1\x93\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x83"],

        ["\xF3\xB1\x93\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x84"],
        ["\xF3\xB1\x93\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x84"],

        ["\xF3\xB1\x93\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x85"],
        ["\xF3\xB1\x93\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x85"],

        ["\xF3\xB1\x93\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x86"],
        ["\xF3\xB1\x93\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x86"],

        ["\xF3\xB1\x93\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x87"],
        ["\xF3\xB1\x93\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x87"],

        ["\xF3\xB1\x93\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x88"],
        ["\xF3\xB1\x93\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x88"],

        ["\xF3\xB1\x93\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x89"],
        ["\xF3\xB1\x93\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x89"],

        ["\xF3\xB1\x93\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8A"],
        ["\xF3\xB1\x93\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8A"],

        ["\xF3\xB1\x93\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8B"],
        ["\xF3\xB1\x93\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8B"],

        ["\xF3\xB1\x93\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8C"],
        ["\xF3\xB1\x93\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8C"],

        ["\xF3\xB1\x93\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8D"],
        ["\xF3\xB1\x93\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8D"],

        ["\xF3\xB1\x93\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8E"],
        ["\xF3\xB1\x93\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8E"],

        ["\xF3\xB1\x93\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8F"],
        ["\xF3\xB1\x93\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8F"],

        ["\xF3\xB1\x93\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x90"],
        ["\xF3\xB1\x93\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x90"],

        ["\xF3\xB1\x93\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x91"],
        ["\xF3\xB1\x93\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x91"],

        ["\xF3\xB1\x93\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x92"],
        ["\xF3\xB1\x93\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x92"],

        ["\xF3\xB1\x93\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x93"],
        ["\xF3\xB1\x93\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x93"],

        ["\xF3\xB1\x93\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x94"],
        ["\xF3\xB1\x93\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x94"],

        ["\xF3\xB1\x93\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x95"],
        ["\xF3\xB1\x93\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x95"],

        ["\xF3\xB1\x93\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x96"],
        ["\xF3\xB1\x93\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x96"],

        ["\xF3\xB1\x93\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x97"],
        ["\xF3\xB1\x93\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x97"],

        ["\xF3\xB1\x93\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x98"],
        ["\xF3\xB1\x93\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x98"],

        ["\xF3\xB1\x93\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x99"],
        ["\xF3\xB1\x93\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x99"],

        ["\xF3\xB1\x93\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9A"],
        ["\xF3\xB1\x93\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9A"],

        ["\xF3\xB1\x93\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9B"],
        ["\xF3\xB1\x93\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9B"],

        ["\xF3\xB1\x93\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9C"],
        ["\xF3\xB1\x93\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9C"],

        ["\xF3\xB1\x93\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9D"],
        ["\xF3\xB1\x93\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9D"],

        ["\xF3\xB1\x93\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9E"],
        ["\xF3\xB1\x93\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9E"],

        ["\xF3\xB1\x93\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9F"],
        ["\xF3\xB1\x93\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9F"],

        ["\xF3\xB1\x93\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA0"],
        ["\xF3\xB1\x93\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA0"],

        ["\xF3\xB1\x93\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA1"],
        ["\xF3\xB1\x93\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA1"],

        ["\xF3\xB1\x93\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA2"],
        ["\xF3\xB1\x93\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA2"],

        ["\xF3\xB1\x93\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA3"],
        ["\xF3\xB1\x93\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA3"],

        ["\xF3\xB1\x93\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA4"],
        ["\xF3\xB1\x93\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA4"],

        ["\xF3\xB1\x93\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA5"],
        ["\xF3\xB1\x93\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA5"],

        ["\xF3\xB1\x93\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA6"],
        ["\xF3\xB1\x93\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA6"],

        ["\xF3\xB1\x93\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA7"],
        ["\xF3\xB1\x93\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA7"],

        ["\xF3\xB1\x93\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA8"],
        ["\xF3\xB1\x93\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA8"],

        ["\xF3\xB1\x93\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA9"],
        ["\xF3\xB1\x93\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA9"],

        ["\xF3\xB1\x93\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAA"],
        ["\xF3\xB1\x93\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAA"],

        ["\xF3\xB1\x93\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAB"],
        ["\xF3\xB1\x93\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAB"],

        ["\xF3\xB1\x93\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAC"],
        ["\xF3\xB1\x93\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAC"],

        ["\xF3\xB1\x93\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAD"],
        ["\xF3\xB1\x93\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAD"],

        ["\xF3\xB1\x93\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAF"],
        ["\xF3\xB1\x93\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAF"],

        ["\xF3\xB1\x93\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB0"],
        ["\xF3\xB1\x93\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB0"],

        ["\xF3\xB1\x93\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB1"],
        ["\xF3\xB1\x93\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB1"],

        ["\xF3\xB1\x93\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB2"],
        ["\xF3\xB1\x93\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB2"],

        ["\xF3\xB1\x93\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB3"],
        ["\xF3\xB1\x93\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB3"],

        ["\xF3\xB1\x93\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB4"],
        ["\xF3\xB1\x93\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB4"],

        ["\xF3\xB1\x93\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB5"],
        ["\xF3\xB1\x93\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB5"],

        ["\xF3\xB1\x93\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB6"],
        ["\xF3\xB1\x93\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB6"],

        ["\xF3\xB1\x93\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB7"],
        ["\xF3\xB1\x93\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB7"],

        ["\xF3\xB1\x93\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB8"],
        ["\xF3\xB1\x93\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB8"],

        ["\xF3\xB1\x93\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB9"],
        ["\xF3\xB1\x93\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB9"],

        ["\xF3\xB1\x93\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBA"],
        ["\xF3\xB1\x93\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBA"],

        ["\xF3\xB1\x93\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBB"],
        ["\xF3\xB1\x93\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBB"],

        ["\xF3\xB1\x93\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBC"],
        ["\xF3\xB1\x93\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBC"],

        ["\xF3\xB1\x93\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBD"],
        ["\xF3\xB1\x93\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBD"],

        ["\xF3\xB1\x93\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBE"],
        ["\xF3\xB1\x93\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBE"],

        ["\xF3\xB1\x93\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBF"],
        ["\xF3\xB1\x93\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBF"],

        ["\xF3\xB1\x94\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x80"],
        ["\xF3\xB1\x94\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x80"],

        ["\xF3\xB1\x94\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x81"],
        ["\xF3\xB1\x94\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x81"],

        ["\xF3\xB1\x94\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x82"],
        ["\xF3\xB1\x94\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x82"],

        ["\xF3\xB1\x94\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x83"],
        ["\xF3\xB1\x94\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x83"],

        ["\xF3\xB1\x94\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x84"],
        ["\xF3\xB1\x94\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x84"],

        ["\xF3\xB1\x94\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x85"],
        ["\xF3\xB1\x94\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x85"],

        ["\xF3\xB1\x94\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x86"],
        ["\xF3\xB1\x94\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x86"],

        ["\xF3\xB1\x94\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x87"],
        ["\xF3\xB1\x94\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x87"],

        ["\xF3\xB1\x94\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x88"],
        ["\xF3\xB1\x94\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x88"],

        ["\xF3\xB1\x94\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x89"],
        ["\xF3\xB1\x94\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x89"],

        ["\xF3\xB1\x94\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8A"],
        ["\xF3\xB1\x94\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8A"],

        ["\xF3\xB1\x94\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8B"],
        ["\xF3\xB1\x94\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8B"],

        ["\xF3\xB1\x94\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8C"],
        ["\xF3\xB1\x94\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8C"],

        ["\xF3\xB1\x94\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8D"],
        ["\xF3\xB1\x94\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8D"],

        ["\xF3\xB1\x94\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8E"],
        ["\xF3\xB1\x94\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8E"],

        ["\xF3\xB1\x94\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8F"],
        ["\xF3\xB1\x94\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8F"],

        ["\xF3\xB1\x94\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x90"],
        ["\xF3\xB1\x94\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x90"],

        ["\xF3\xB1\x94\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x91"],
        ["\xF3\xB1\x94\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x91"],

        ["\xF3\xB1\x94\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x92"],
        ["\xF3\xB1\x94\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x92"],

        ["\xF3\xB1\x94\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x93"],
        ["\xF3\xB1\x94\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x93"],

        ["\xF3\xB1\x94\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x94"],
        ["\xF3\xB1\x94\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x94"],

        ["\xF3\xB1\x94\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x95"],
        ["\xF3\xB1\x94\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x95"],

        ["\xF3\xB1\x94\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x96"],
        ["\xF3\xB1\x94\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x96"],

        ["\xF3\xB1\x94\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x97"],
        ["\xF3\xB1\x94\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x97"],

        ["\xF3\xB1\x94\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x98"],
        ["\xF3\xB1\x94\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x98"],

        ["\xF3\xB1\x94\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x99"],
        ["\xF3\xB1\x94\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x99"],

        ["\xF3\xB1\x94\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9A"],
        ["\xF3\xB1\x94\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9A"],

        ["\xF3\xB1\x94\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9B"],
        ["\xF3\xB1\x94\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9B"],

        ["\xF3\xB1\x94\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9C"],
        ["\xF3\xB1\x94\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9C"],

        ["\xF3\xB1\x94\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9D"],
        ["\xF3\xB1\x94\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9D"],

        ["\xF3\xB1\x94\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9E"],
        ["\xF3\xB1\x94\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9E"],

        ["\xF3\xB1\x94\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9F"],
        ["\xF3\xB1\x94\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9F"],

        ["\xF3\xB1\x94\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA0"],
        ["\xF3\xB1\x94\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA0"],

        ["\xF3\xB1\x94\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA1"],
        ["\xF3\xB1\x94\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA1"],

        ["\xF3\xB1\x94\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA2"],
        ["\xF3\xB1\x94\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA2"],

        ["\xF3\xB1\x94\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA3"],
        ["\xF3\xB1\x94\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA3"],

        ["\xF3\xB1\x94\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA4"],
        ["\xF3\xB1\x94\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA4"],

        ["\xF3\xB1\x94\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA5"],
        ["\xF3\xB1\x94\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA5"],

        ["\xF3\xB1\x94\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA6"],
        ["\xF3\xB1\x94\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA6"],

        ["\xF3\xB1\x94\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA7"],
        ["\xF3\xB1\x94\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA7"],

        ["\xF3\xB1\x94\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA8"],
        ["\xF3\xB1\x94\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA8"],

        ["\xF3\xB1\x94\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA9"],
        ["\xF3\xB1\x94\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA9"],

        ["\xF3\xB1\x94\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAA"],
        ["\xF3\xB1\x94\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAA"],

        ["\xF3\xB1\x94\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAB"],
        ["\xF3\xB1\x94\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAB"],

        ["\xF3\xB1\x94\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAC"],
        ["\xF3\xB1\x94\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAC"],

        ["\xF3\xB1\x94\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAD"],
        ["\xF3\xB1\x94\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAD"],

        ["\xF3\xB1\x94\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAE"],
        ["\xF3\xB1\x94\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAE"],

        ["\xF3\xB1\x94\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAF"],
        ["\xF3\xB1\x94\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAF"],

        ["\xF3\xB1\x94\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB0"],
        ["\xF3\xB1\x94\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB0"],

        ["\xF3\xB1\x94\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB1"],
        ["\xF3\xB1\x94\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB1"],

        ["\xF3\xB1\x94\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB2"],
        ["\xF3\xB1\x94\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB2"],

        ["\xF3\xB1\x94\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB3"],
        ["\xF3\xB1\x94\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB3"],

        ["\xF3\xB1\x94\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB4"],
        ["\xF3\xB1\x94\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB4"],

        ["\xF3\xB1\x94\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB5"],
        ["\xF3\xB1\x94\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB5"],

        ["\xF3\xB1\x94\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB6"],
        ["\xF3\xB1\x94\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB6"],

        ["\xF3\xB1\x94\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB7"],
        ["\xF3\xB1\x94\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB7"],

        ["\xF3\xB1\x94\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB8"],
        ["\xF3\xB1\x94\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB8"],

        ["\xF3\xB1\x94\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB9"],
        ["\xF3\xB1\x94\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB9"],

        ["\xF3\xB1\x94\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBA"],
        ["\xF3\xB1\x94\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBA"],

        ["\xF3\xB1\x94\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBB"],
        ["\xF3\xB1\x94\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBB"],

        ["\xF3\xB1\x94\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBC"],
        ["\xF3\xB1\x94\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBC"],

        ["\xF3\xB1\x94\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBD"],
        ["\xF3\xB1\x94\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBD"],

        ["\xF3\xB1\x94\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBE"],
        ["\xF3\xB1\x94\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBE"],

        ["\xF3\xB1\x94\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBF"],
        ["\xF3\xB1\x94\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBF"],

        ["\xF3\xB1\x95\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x80"],
        ["\xF3\xB1\x95\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x80"],

        ["\xF3\xB1\x95\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x81"],
        ["\xF3\xB1\x95\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x81"],

        ["\xF3\xB1\x95\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x82"],
        ["\xF3\xB1\x95\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x82"],

        ["\xF3\xB1\x95\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x83"],
        ["\xF3\xB1\x95\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x83"],

        ["\xF3\xB1\x95\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x84"],
        ["\xF3\xB1\x95\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x84"],

        ["\xF3\xB1\x95\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x85"],
        ["\xF3\xB1\x95\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x85"],

        ["\xF3\xB1\x95\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x86"],
        ["\xF3\xB1\x95\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x86"],

        ["\xF3\xB1\x95\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x87"],
        ["\xF3\xB1\x95\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x87"],

        ["\xF3\xB1\x95\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x88"],
        ["\xF3\xB1\x95\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x88"],

        ["\xF3\xB1\x95\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x89"],
        ["\xF3\xB1\x95\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x89"],

        ["\xF3\xB1\x95\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8A"],
        ["\xF3\xB1\x95\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8A"],

        ["\xF3\xB1\x95\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8B"],
        ["\xF3\xB1\x95\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8B"],

        ["\xF3\xB1\x95\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8C"],
        ["\xF3\xB1\x95\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8C"],

        ["\xF3\xB1\x95\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8D"],
        ["\xF3\xB1\x95\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8D"],

        ["\xF3\xB1\x95\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8E"],
        ["\xF3\xB1\x95\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8E"],

        ["\xF3\xB1\x95\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8F"],
        ["\xF3\xB1\x95\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8F"],

        ["\xF3\xB1\x95\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x90"],
        ["\xF3\xB1\x95\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x90"],

        ["\xF3\xB1\x95\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x91"],
        ["\xF3\xB1\x95\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x91"],

        ["\xF3\xB1\x95\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x92"],
        ["\xF3\xB1\x95\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x92"],

        ["\xF3\xB1\x95\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x93"],
        ["\xF3\xB1\x95\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x93"],

        ["\xF3\xB1\x95\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x94"],
        ["\xF3\xB1\x95\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x94"],

        ["\xF3\xB1\x95\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x95"],
        ["\xF3\xB1\x95\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x95"],

        ["\xF3\xB1\x95\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x96"],
        ["\xF3\xB1\x95\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x96"],

        ["\xF3\xB1\x95\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x97"],
        ["\xF3\xB1\x95\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x97"],

        ["\xF3\xB1\x95\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x98"],
        ["\xF3\xB1\x95\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x98"],

        ["\xF3\xB1\x95\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x99"],
        ["\xF3\xB1\x95\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x99"],

        ["\xF3\xB1\x95\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9A"],
        ["\xF3\xB1\x95\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9A"],

        ["\xF3\xB1\x95\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9B"],
        ["\xF3\xB1\x95\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9B"],

        ["\xF3\xB1\x95\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9C"],
        ["\xF3\xB1\x95\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9C"],

        ["\xF3\xB1\x95\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9D"],
        ["\xF3\xB1\x95\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9D"],

        ["\xF3\xB1\x95\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9E"],
        ["\xF3\xB1\x95\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9E"],

        ["\xF3\xB1\x95\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9F"],
        ["\xF3\xB1\x95\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9F"],

        ["\xF3\xB1\x95\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA0"],
        ["\xF3\xB1\x95\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA0"],

        ["\xF3\xB1\x95\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA1"],
        ["\xF3\xB1\x95\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA1"],

        ["\xF3\xB1\x95\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA2"],
        ["\xF3\xB1\x95\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA2"],

        ["\xF3\xB1\x95\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA3"],
        ["\xF3\xB1\x95\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA3"],

        ["\xF3\xB1\x95\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA4"],
        ["\xF3\xB1\x95\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA4"],

        ["\xF3\xB1\x95\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA5"],
        ["\xF3\xB1\x95\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA5"],

        ["\xF3\xB1\x95\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA6"],
        ["\xF3\xB1\x95\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA6"],

        ["\xF3\xB1\x95\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA7"],
        ["\xF3\xB1\x95\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA7"],

        ["\xF3\xB1\x95\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA8"],
        ["\xF3\xB1\x95\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA8"],

        ["\xF3\xB1\x95\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA9"],
        ["\xF3\xB1\x95\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA9"],

        ["\xF3\xB1\x95\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAA"],
        ["\xF3\xB1\x95\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAA"],

        ["\xF3\xB1\x95\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAB"],
        ["\xF3\xB1\x95\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAB"],

        ["\xF3\xB1\x95\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAC"],
        ["\xF3\xB1\x95\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAC"],

        ["\xF3\xB1\x95\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAD"],
        ["\xF3\xB1\x95\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAD"],

        ["\xF3\xB1\x95\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAE"],
        ["\xF3\xB1\x95\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAE"],

        ["\xF3\xB1\x95\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAF"],
        ["\xF3\xB1\x95\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAF"],

        ["\xF3\xB1\x95\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB0"],
        ["\xF3\xB1\x95\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB0"],

        ["\xF3\xB1\x95\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB1"],
        ["\xF3\xB1\x95\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB1"],

        ["\xF3\xB1\x95\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB2"],
        ["\xF3\xB1\x95\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB2"],

        ["\xF3\xB1\x95\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB3"],
        ["\xF3\xB1\x95\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB3"],

        ["\xF3\xB1\x95\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB4"],
        ["\xF3\xB1\x95\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB4"],

        ["\xF3\xB1\x95\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB5"],
        ["\xF3\xB1\x95\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB5"],

        ["\xF3\xB1\x95\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB6"],
        ["\xF3\xB1\x95\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB6"],

        ["\xF3\xB1\x95\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB7"],
        ["\xF3\xB1\x95\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB7"],

        ["\xF3\xB1\x95\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB8"],
        ["\xF3\xB1\x95\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB8"],

        ["\xF3\xB1\x95\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB9"],
        ["\xF3\xB1\x95\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB9"],

        ["\xF3\xB1\x95\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBA"],
        ["\xF3\xB1\x95\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBA"],

        ["\xF3\xB1\x95\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBB"],
        ["\xF3\xB1\x95\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBB"],

        ["\xF3\xB1\x95\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBC"],
        ["\xF3\xB1\x95\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBC"],

        ["\xF3\xB1\x95\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBD"],
        ["\xF3\xB1\x95\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBD"],

        ["\xF3\xB1\x95\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBE"],
        ["\xF3\xB1\x95\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBE"],

        ["\xF3\xB1\x95\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBF"],
        ["\xF3\xB1\x95\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBF"],

        ["\xF3\xB1\x96\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x80"],
        ["\xF3\xB1\x96\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x80"],

        ["\xF3\xB1\x96\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x81"],
        ["\xF3\xB1\x96\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x81"],

        ["\xF3\xB1\x96\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x82"],
        ["\xF3\xB1\x96\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x82"],

        ["\xF3\xB1\x96\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x83"],
        ["\xF3\xB1\x96\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x83"],

        ["\xF3\xB1\x96\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x84"],
        ["\xF3\xB1\x96\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x84"],

        ["\xF3\xB1\x96\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x85"],
        ["\xF3\xB1\x96\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x85"],

        ["\xF3\xB1\x96\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x86"],
        ["\xF3\xB1\x96\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x86"],

        ["\xF3\xB1\x96\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x87"],
        ["\xF3\xB1\x96\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x87"],

        ["\xF3\xB1\x96\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x88"],
        ["\xF3\xB1\x96\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x88"],

        ["\xF3\xB1\x96\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x89"],
        ["\xF3\xB1\x96\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x89"],

        ["\xF3\xB1\x96\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8A"],
        ["\xF3\xB1\x96\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8A"],

        ["\xF3\xB1\x96\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8B"],
        ["\xF3\xB1\x96\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8B"],

        ["\xF3\xB1\x96\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8C"],
        ["\xF3\xB1\x96\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8C"],

        ["\xF3\xB1\x96\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8D"],
        ["\xF3\xB1\x96\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8D"],

        ["\xF3\xB1\x96\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8E"],
        ["\xF3\xB1\x96\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8E"],

        ["\xF3\xB1\x96\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8F"],
        ["\xF3\xB1\x96\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8F"],

        ["\xF3\xB1\x96\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x90"],
        ["\xF3\xB1\x96\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x90"],

        ["\xF3\xB1\x96\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x91"],
        ["\xF3\xB1\x96\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x91"],

        ["\xF3\xB1\x96\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x92"],
        ["\xF3\xB1\x96\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x92"],

        ["\xF3\xB1\x96\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x93"],
        ["\xF3\xB1\x96\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x93"],

        ["\xF3\xB1\x96\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x94"],
        ["\xF3\xB1\x96\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x94"],

        ["\xF3\xB1\x96\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x95"],
        ["\xF3\xB1\x96\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x95"],

        ["\xF3\xB1\x96\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x96"],
        ["\xF3\xB1\x96\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x96"],

        ["\xF3\xB1\x96\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x97"],
        ["\xF3\xB1\x96\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x97"],

        ["\xF3\xB1\x96\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x98"],
        ["\xF3\xB1\x96\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x98"],

        ["\xF3\xB1\x96\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x99"],
        ["\xF3\xB1\x96\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x99"],

        ["\xF3\xB1\x96\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9A"],
        ["\xF3\xB1\x96\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9A"],

        ["\xF3\xB1\x96\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9B"],
        ["\xF3\xB1\x96\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9B"],

        ["\xF3\xB1\x96\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9C"],
        ["\xF3\xB1\x96\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9C"],

        ["\xF3\xB1\x96\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9D"],
        ["\xF3\xB1\x96\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9D"],

        ["\xF3\xB1\x96\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9E"],
        ["\xF3\xB1\x96\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9E"],

        ["\xF3\xB1\x96\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9F"],
        ["\xF3\xB1\x96\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9F"],

        ["\xF3\xB1\x96\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA0"],
        ["\xF3\xB1\x96\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA0"],

        ["\xF3\xB1\x96\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA1"],
        ["\xF3\xB1\x96\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA1"],

        ["\xF3\xB1\x96\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA2"],
        ["\xF3\xB1\x96\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA2"],

        ["\xF3\xB1\x96\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA3"],
        ["\xF3\xB1\x96\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA3"],

        ["\xF3\xB1\x96\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA4"],
        ["\xF3\xB1\x96\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA4"],

        ["\xF3\xB1\x96\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA5"],
        ["\xF3\xB1\x96\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA5"],

        ["\xF3\xB1\x96\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA6"],
        ["\xF3\xB1\x96\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA6"],

        ["\xF3\xB1\x96\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA7"],
        ["\xF3\xB1\x96\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA7"],

        ["\xF3\xB1\x96\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA8"],
        ["\xF3\xB1\x96\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA8"],

        ["\xF3\xB1\x96\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA9"],
        ["\xF3\xB1\x96\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA9"],

        ["\xF3\xB1\x96\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAA"],
        ["\xF3\xB1\x96\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAA"],

        ["\xF3\xB1\x96\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAB"],
        ["\xF3\xB1\x96\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAB"],

        ["\xF3\xB1\x96\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAC"],
        ["\xF3\xB1\x96\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAC"],

        ["\xF3\xB1\x96\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAD"],
        ["\xF3\xB1\x96\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAD"],

        ["\xF3\xB1\x96\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAE"],
        ["\xF3\xB1\x96\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAE"],

        ["\xF3\xB1\x96\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAF"],
        ["\xF3\xB1\x96\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAF"],

        ["\xF3\xB1\x96\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB0"],
        ["\xF3\xB1\x96\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB0"],

        ["\xF3\xB1\x96\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB1"],
        ["\xF3\xB1\x96\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB1"],

        ["\xF3\xB1\x96\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB2"],
        ["\xF3\xB1\x96\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB2"],

        ["\xF3\xB1\x96\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB3"],
        ["\xF3\xB1\x96\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB3"],

        ["\xF3\xB1\x96\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB4"],
        ["\xF3\xB1\x96\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB4"],

        ["\xF3\xB1\x96\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB5"],
        ["\xF3\xB1\x96\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB5"],

        ["\xF3\xB1\x96\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB6"],
        ["\xF3\xB1\x96\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB6"],

        ["\xF3\xB1\x96\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB7"],
        ["\xF3\xB1\x96\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB7"],

        ["\xF3\xB1\x96\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB8"],
        ["\xF3\xB1\x96\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB8"],

        ["\xF3\xB1\x96\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB9"],
        ["\xF3\xB1\x96\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB9"],

        ["\xF3\xB1\x96\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBA"],
        ["\xF3\xB1\x96\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBA"],

        ["\xF3\xB1\x96\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBB"],
        ["\xF3\xB1\x96\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBB"],

        ["\xF3\xB1\x96\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBC"],
        ["\xF3\xB1\x96\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBC"],

        ["\xF3\xB1\x96\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBD"],
        ["\xF3\xB1\x96\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBD"],

        ["\xF3\xB1\x96\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBE"],
        ["\xF3\xB1\x96\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBE"],

        ["\xF3\xB1\x96\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBF"],
        ["\xF3\xB1\x96\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBF"],

        ["\xF3\xB1\x97\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x80"],
        ["\xF3\xB1\x97\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x80"],

        ["\xF3\xB1\x97\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x81"],
        ["\xF3\xB1\x97\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x81"],

        ["\xF3\xB1\x97\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x82"],
        ["\xF3\xB1\x97\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x82"],

        ["\xF3\xB1\x97\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x83"],
        ["\xF3\xB1\x97\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x83"],

        ["\xF3\xB1\x97\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x84"],
        ["\xF3\xB1\x97\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x84"],

        ["\xF3\xB1\x97\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x85"],
        ["\xF3\xB1\x97\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x85"],

        ["\xF3\xB1\x97\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x86"],
        ["\xF3\xB1\x97\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x86"],

        ["\xF3\xB1\x97\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x87"],
        ["\xF3\xB1\x97\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x87"],

        ["\xF3\xB1\x97\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x88"],
        ["\xF3\xB1\x97\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x88"],

        ["\xF3\xB1\x97\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x89"],
        ["\xF3\xB1\x97\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x89"],

        ["\xF3\xB1\x97\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8A"],
        ["\xF3\xB1\x97\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8A"],

        ["\xF3\xB1\x97\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8B"],
        ["\xF3\xB1\x97\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8B"],

        ["\xF3\xB1\x97\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8C"],
        ["\xF3\xB1\x97\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8C"],

        ["\xF3\xB1\x97\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8D"],
        ["\xF3\xB1\x97\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8D"],

        ["\xF3\xB1\x97\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8E"],
        ["\xF3\xB1\x97\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8E"],

        ["\xF3\xB1\x97\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8F"],
        ["\xF3\xB1\x97\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8F"],

        ["\xF3\xB1\x97\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x90"],
        ["\xF3\xB1\x97\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x90"],

        ["\xF3\xB1\x97\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x91"],
        ["\xF3\xB1\x97\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x91"],

        ["\xF3\xB1\x97\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x92"],
        ["\xF3\xB1\x97\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x92"],

        ["\xF3\xB1\x97\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x93"],
        ["\xF3\xB1\x97\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x93"],

        ["\xF3\xB1\x97\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x94"],
        ["\xF3\xB1\x97\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x94"],

        ["\xF3\xB1\x97\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x95"],
        ["\xF3\xB1\x97\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x95"],

        ["\xF3\xB1\x97\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x96"],
        ["\xF3\xB1\x97\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x96"],

        ["\xF3\xB1\x97\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x97"],
        ["\xF3\xB1\x97\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x97"],

        ["\xF3\xB1\x97\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x98"],
        ["\xF3\xB1\x97\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x98"],

        ["\xF3\xB1\x97\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x99"],
        ["\xF3\xB1\x97\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x99"],

        ["\xF3\xB1\x97\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9A"],
        ["\xF3\xB1\x97\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9A"],

        ["\xF3\xB1\x97\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9B"],
        ["\xF3\xB1\x97\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9B"],

        ["\xF3\xB1\x97\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9C"],
        ["\xF3\xB1\x97\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9C"],

        ["\xF3\xB1\x97\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9D"],
        ["\xF3\xB1\x97\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9D"],

        ["\xF3\xB1\x97\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9E"],
        ["\xF3\xB1\x97\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9E"],

        ["\xF3\xB1\x97\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9F"],
        ["\xF3\xB1\x97\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9F"],

        ["\xF3\xB1\x97\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA0"],
        ["\xF3\xB1\x97\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA0"],

        ["\xF3\xB1\x97\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA1"],
        ["\xF3\xB1\x97\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA1"],

        ["\xF3\xB1\x97\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA2"],
        ["\xF3\xB1\x97\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA2"],

        ["\xF3\xB1\x97\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA3"],
        ["\xF3\xB1\x97\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA3"],

        ["\xF3\xB1\x97\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA4"],
        ["\xF3\xB1\x97\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA4"],

        ["\xF3\xB1\x97\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA5"],
        ["\xF3\xB1\x97\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA5"],

        ["\xF3\xB1\x97\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA6"],
        ["\xF3\xB1\x97\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA6"],

        ["\xF3\xB1\x97\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA7"],
        ["\xF3\xB1\x97\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA7"],

        ["\xF3\xB1\x97\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA8"],
        ["\xF3\xB1\x97\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA8"],

        ["\xF3\xB1\x97\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA9"],
        ["\xF3\xB1\x97\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA9"],

        ["\xF3\xB1\x97\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAA"],
        ["\xF3\xB1\x97\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAA"],

        ["\xF3\xB1\x97\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAB"],
        ["\xF3\xB1\x97\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAB"],

        ["\xF3\xB1\x97\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAC"],
        ["\xF3\xB1\x97\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAC"],

        ["\xF3\xB1\x97\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAD"],
        ["\xF3\xB1\x97\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAD"],

        ["\xF3\xB1\x97\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAE"],
        ["\xF3\xB1\x97\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAE"],

        ["\xF3\xB1\x97\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAF"],
        ["\xF3\xB1\x97\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAF"],

        ["\xF3\xB1\x97\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB0"],
        ["\xF3\xB1\x97\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB0"],

        ["\xF3\xB1\x97\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB1"],
        ["\xF3\xB1\x97\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB1"],

        ["\xF3\xB1\x97\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB2"],
        ["\xF3\xB1\x97\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB2"],

        ["\xF3\xB1\x97\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB3"],
        ["\xF3\xB1\x97\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB3"],

        ["\xF3\xB1\x97\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB4"],
        ["\xF3\xB1\x97\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB4"],

        ["\xF3\xB1\x97\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB5"],
        ["\xF3\xB1\x97\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB5"],

        ["\xF3\xB1\x97\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB6"],
        ["\xF3\xB1\x97\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB6"],

        ["\xF3\xB1\x97\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB7"],
        ["\xF3\xB1\x97\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB7"],

        ["\xF3\xB1\x97\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB8"],
        ["\xF3\xB1\x97\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB8"],

        ["\xF3\xB1\x97\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB9"],
        ["\xF3\xB1\x97\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB9"],

        ["\xF3\xB1\x97\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBA"],
        ["\xF3\xB1\x97\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBA"],

        ["\xF3\xB1\x97\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBB"],
        ["\xF3\xB1\x97\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBB"],

        ["\xF3\xB1\x97\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBC"],
        ["\xF3\xB1\x97\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBC"],

        ["\xF3\xB1\x97\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBD"],
        ["\xF3\xB1\x97\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBD"],

        ["\xF3\xB1\x97\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBE"],
        ["\xF3\xB1\x97\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBE"],

        ["\xF3\xB1\x97\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBF"],
        ["\xF3\xB1\x97\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBF"],

        ["\xF3\xB1\x98\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x80"],
        ["\xF3\xB1\x98\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x80"],

        ["\xF3\xB1\x98\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x81"],
        ["\xF3\xB1\x98\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x81"],

        ["\xF3\xB1\x98\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x82"],
        ["\xF3\xB1\x98\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x82"],

        ["\xF3\xB1\x98\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x83"],
        ["\xF3\xB1\x98\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x83"],

        ["\xF3\xB1\x98\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x84"],
        ["\xF3\xB1\x98\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x84"],

        ["\xF3\xB1\x98\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x85"],
        ["\xF3\xB1\x98\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x85"],

        ["\xF3\xB1\x98\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x86"],
        ["\xF3\xB1\x98\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x86"],

        ["\xF3\xB1\x98\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x87"],
        ["\xF3\xB1\x98\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x87"],

        ["\xF3\xB1\x98\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x88"],
        ["\xF3\xB1\x98\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x88"],

        ["\xF3\xB1\x98\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x89"],
        ["\xF3\xB1\x98\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x89"],

        ["\xF3\xB1\x98\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8A"],
        ["\xF3\xB1\x98\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8A"],

        ["\xF3\xB1\x98\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8B"],
        ["\xF3\xB1\x98\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8B"],

        ["\xF3\xB1\x98\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8C"],
        ["\xF3\xB1\x98\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8C"],

        ["\xF3\xB1\x98\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8D"],
        ["\xF3\xB1\x98\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8D"],

        ["\xF3\xB1\x98\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8E"],
        ["\xF3\xB1\x98\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8E"],

        ["\xF3\xB1\x98\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8F"],
        ["\xF3\xB1\x98\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8F"],

        ["\xF3\xB1\x98\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x90"],
        ["\xF3\xB1\x98\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x90"],

        ["\xF3\xB1\x98\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x91"],
        ["\xF3\xB1\x98\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x91"],

        ["\xF3\xB1\x98\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x92"],
        ["\xF3\xB1\x98\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x92"],

        ["\xF3\xB1\x98\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x93"],
        ["\xF3\xB1\x98\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x93"],

        ["\xF3\xB1\x98\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x94"],
        ["\xF3\xB1\x98\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x94"],

        ["\xF3\xB1\x98\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x95"],
        ["\xF3\xB1\x98\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x95"],

        ["\xF3\xB1\x98\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x96"],
        ["\xF3\xB1\x98\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x96"],

        ["\xF3\xB1\x98\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x97"],
        ["\xF3\xB1\x98\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x97"],

        ["\xF3\xB1\x98\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x98"],
        ["\xF3\xB1\x98\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x98"],

        ["\xF3\xB1\x98\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x99"],
        ["\xF3\xB1\x98\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x99"],

        ["\xF3\xB1\x98\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9A"],
        ["\xF3\xB1\x98\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9A"],

        ["\xF3\xB1\x98\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9B"],
        ["\xF3\xB1\x98\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9B"],

        ["\xF3\xB1\x98\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9C"],
        ["\xF3\xB1\x98\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9C"],

        ["\xF3\xB1\x98\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9D"],
        ["\xF3\xB1\x98\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9D"],

        ["\xF3\xB1\x98\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9E"],
        ["\xF3\xB1\x98\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9E"],

        ["\xF3\xB1\x98\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9F"],
        ["\xF3\xB1\x98\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9F"],

        ["\xF3\xB1\x98\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA0"],
        ["\xF3\xB1\x98\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA0"],

        ["\xF3\xB1\x98\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA1"],
        ["\xF3\xB1\x98\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA1"],

        ["\xF3\xB1\x98\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA2"],
        ["\xF3\xB1\x98\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA2"],

        ["\xF3\xB1\x98\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA3"],
        ["\xF3\xB1\x98\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA3"],

        ["\xF3\xB1\x98\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA4"],
        ["\xF3\xB1\x98\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA4"],

        ["\xF3\xB1\x98\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA5"],
        ["\xF3\xB1\x98\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA5"],

        ["\xF3\xB1\x98\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA6"],
        ["\xF3\xB1\x98\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA6"],

        ["\xF3\xB1\x98\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA7"],
        ["\xF3\xB1\x98\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA7"],

        ["\xF3\xB1\x98\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA8"],
        ["\xF3\xB1\x98\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA8"],

        ["\xF3\xB1\x98\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA9"],
        ["\xF3\xB1\x98\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA9"],

        ["\xF3\xB1\x98\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAA"],
        ["\xF3\xB1\x98\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAA"],

        ["\xF3\xB1\x98\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAB"],
        ["\xF3\xB1\x98\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAB"],

        ["\xF3\xB1\x98\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAC"],
        ["\xF3\xB1\x98\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAC"],

        ["\xF3\xB1\x98\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAD"],
        ["\xF3\xB1\x98\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAD"],

        ["\xF3\xB1\x98\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAE"],
        ["\xF3\xB1\x98\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAE"],

        ["\xF3\xB1\x98\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAF"],
        ["\xF3\xB1\x98\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAF"],

        ["\xF3\xB1\x98\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB0"],
        ["\xF3\xB1\x98\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB0"],

        ["\xF3\xB1\x98\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB1"],
        ["\xF3\xB1\x98\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB1"],

        ["\xF3\xB1\x98\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB2"],
        ["\xF3\xB1\x98\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB2"],

        ["\xF3\xB1\x98\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB3"],
        ["\xF3\xB1\x98\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB3"],

        ["\xF3\xB1\x98\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB4"],
        ["\xF3\xB1\x98\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB4"],

        ["\xF3\xB1\x98\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB5"],
        ["\xF3\xB1\x98\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB5"],

        ["\xF3\xB1\x98\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB6"],
        ["\xF3\xB1\x98\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB6"],

        ["\xF3\xB1\x98\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB7"],
        ["\xF3\xB1\x98\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB7"],

        ["\xF3\xB1\x98\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB8"],
        ["\xF3\xB1\x98\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB8"],

        ["\xF3\xB1\x98\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB9"],
        ["\xF3\xB1\x98\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB9"],

        ["\xF3\xB1\x98\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBA"],
        ["\xF3\xB1\x98\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBA"],

        ["\xF3\xB1\x98\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBB"],
        ["\xF3\xB1\x98\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBB"],

        ["\xF3\xB1\x98\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBC"],
        ["\xF3\xB1\x98\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBC"],

        ["\xF3\xB1\x98\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBD"],
        ["\xF3\xB1\x98\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBD"],

        ["\xF3\xB1\x98\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBE"],
        ["\xF3\xB1\x98\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBE"],

        ["\xF3\xB1\x98\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBF"],
        ["\xF3\xB1\x98\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBF"],

        ["\xF3\xB1\x99\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x80"],
        ["\xF3\xB1\x99\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x80"],

        ["\xF3\xB1\x99\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x81"],
        ["\xF3\xB1\x99\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x81"],

        ["\xF3\xB1\x99\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x82"],
        ["\xF3\xB1\x99\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x82"],

        ["\xF3\xB1\x99\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x83"],
        ["\xF3\xB1\x99\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x83"],

        ["\xF3\xB1\x99\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x84"],
        ["\xF3\xB1\x99\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x84"],

        ["\xF3\xB1\x99\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x85"],
        ["\xF3\xB1\x99\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x85"],

        ["\xF3\xB1\x99\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x86"],
        ["\xF3\xB1\x99\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x86"],

        ["\xF3\xB1\x99\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x87"],
        ["\xF3\xB1\x99\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x87"],

        ["\xF3\xB1\x99\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x88"],
        ["\xF3\xB1\x99\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x88"],

        ["\xF3\xB1\x99\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x89"],
        ["\xF3\xB1\x99\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x89"],

        ["\xF3\xB1\x99\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8A"],
        ["\xF3\xB1\x99\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8A"],

        ["\xF3\xB1\x99\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8B"],
        ["\xF3\xB1\x99\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8B"],

        ["\xF3\xB1\x99\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8C"],
        ["\xF3\xB1\x99\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8C"],

        ["\xF3\xB1\x99\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8D"],
        ["\xF3\xB1\x99\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8D"],

        ["\xF3\xB1\x99\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8E"],
        ["\xF3\xB1\x99\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8E"],

        ["\xF3\xB1\x99\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8F"],
        ["\xF3\xB1\x99\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8F"],

        ["\xF3\xB1\x99\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x90"],
        ["\xF3\xB1\x99\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x90"],

        ["\xF3\xB1\x99\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x91"],
        ["\xF3\xB1\x99\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x91"],

        ["\xF3\xB1\x99\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x92"],
        ["\xF3\xB1\x99\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x92"],

        ["\xF3\xB1\x99\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x93"],
        ["\xF3\xB1\x99\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x93"],

        ["\xF3\xB1\x99\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x94"],
        ["\xF3\xB1\x99\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x94"],

        ["\xF3\xB1\x99\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x95"],
        ["\xF3\xB1\x99\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x95"],

        ["\xF3\xB1\x99\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x96"],
        ["\xF3\xB1\x99\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x96"],

        ["\xF3\xB1\x99\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x97"],
        ["\xF3\xB1\x99\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x97"],

        ["\xF3\xB1\x99\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x98"],
        ["\xF3\xB1\x99\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x98"],

        ["\xF3\xB1\x99\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x99"],
        ["\xF3\xB1\x99\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x99"],

        ["\xF3\xB1\x99\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9A"],
        ["\xF3\xB1\x99\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9A"],

        ["\xF3\xB1\x99\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9B"],
        ["\xF3\xB1\x99\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9B"],

        ["\xF3\xB1\x99\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9C"],
        ["\xF3\xB1\x99\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9C"],

        ["\xF3\xB1\x99\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9D"],
        ["\xF3\xB1\x99\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9D"],

        ["\xF3\xB1\x99\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9E"],
        ["\xF3\xB1\x99\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9E"],

        ["\xF3\xB1\x99\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9F"],
        ["\xF3\xB1\x99\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9F"],

        ["\xF3\xB1\x99\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA0"],
        ["\xF3\xB1\x99\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA0"],

        ["\xF3\xB1\x99\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA1"],
        ["\xF3\xB1\x99\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA1"],

        ["\xF3\xB1\x99\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA2"],
        ["\xF3\xB1\x99\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA2"],

        ["\xF3\xB1\x99\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA3"],
        ["\xF3\xB1\x99\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA3"],

        ["\xF3\xB1\x99\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA4"],
        ["\xF3\xB1\x99\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA4"],

        ["\xF3\xB1\x99\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA5"],
        ["\xF3\xB1\x99\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA5"],

        ["\xF3\xB1\x99\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA6"],
        ["\xF3\xB1\x99\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA6"],

        ["\xF3\xB1\x99\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA7"],
        ["\xF3\xB1\x99\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA7"],

        ["\xF3\xB1\x99\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA8"],
        ["\xF3\xB1\x99\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA8"],

        ["\xF3\xB1\x99\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA9"],
        ["\xF3\xB1\x99\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA9"],

        ["\xF3\xB1\x99\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAA"],
        ["\xF3\xB1\x99\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAA"],

        ["\xF3\xB1\x99\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAB"],
        ["\xF3\xB1\x99\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAB"],

        ["\xF3\xB1\x99\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAC"],
        ["\xF3\xB1\x99\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAC"],

        ["\xF3\xB1\x99\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAD"],
        ["\xF3\xB1\x99\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAD"],

        ["\xF3\xB1\x99\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAE"],
        ["\xF3\xB1\x99\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAE"],

        ["\xF3\xB1\x99\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAF"],
        ["\xF3\xB1\x99\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAF"],

        ["\xF3\xB1\x99\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB0"],
        ["\xF3\xB1\x99\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB0"],

        ["\xF3\xB1\x99\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB1"],
        ["\xF3\xB1\x99\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB1"],

        ["\xF3\xB1\x99\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB2"],
        ["\xF3\xB1\x99\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB2"],

        ["\xF3\xB1\x99\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB3"],
        ["\xF3\xB1\x99\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB3"],

        ["\xF3\xB1\x99\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB4"],
        ["\xF3\xB1\x99\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB4"],

        ["\xF3\xB1\x99\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB5"],
        ["\xF3\xB1\x99\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB5"],

        ["\xF3\xB1\x99\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB6"],
        ["\xF3\xB1\x99\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB6"],

        ["\xF3\xB1\x99\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB7"],
        ["\xF3\xB1\x99\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB7"],

        ["\xF3\xB1\x99\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB8"],
        ["\xF3\xB1\x99\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB8"],

        ["\xF3\xB1\x99\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB9"],
        ["\xF3\xB1\x99\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB9"],

        ["\xF3\xB1\x99\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBA"],
        ["\xF3\xB1\x99\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBA"],

        ["\xF3\xB1\x99\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBB"],
        ["\xF3\xB1\x99\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBB"],

        ["\xF3\xB1\x99\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBC"],
        ["\xF3\xB1\x99\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBC"],

        ["\xF3\xB1\x99\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBD"],
        ["\xF3\xB1\x99\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBD"],

        ["\xF3\xB1\x99\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBE"],
        ["\xF3\xB1\x99\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBE"],

        ["\xF3\xB1\x99\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBF"],
        ["\xF3\xB1\x99\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBF"],

        ["\xF3\xB1\x9A\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x80"],
        ["\xF3\xB1\x9A\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x80"],

        ["\xF3\xB1\x9A\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x81"],
        ["\xF3\xB1\x9A\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x81"],

        ["\xF3\xB1\x9A\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x82"],
        ["\xF3\xB1\x9A\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x82"],

        ["\xF3\xB1\x9A\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x83"],
        ["\xF3\xB1\x9A\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x83"],

        ["\xF3\xB1\x9A\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x84"],
        ["\xF3\xB1\x9A\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x84"],

        ["\xF3\xB1\x9A\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x85"],
        ["\xF3\xB1\x9A\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x85"],

        ["\xF3\xB1\x9A\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x86"],
        ["\xF3\xB1\x9A\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x86"],

        ["\xF3\xB1\x9A\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x87"],
        ["\xF3\xB1\x9A\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x87"],

        ["\xF3\xB1\x9A\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x88"],
        ["\xF3\xB1\x9A\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x88"],

        ["\xF3\xB1\x9A\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x89"],
        ["\xF3\xB1\x9A\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x89"],

        ["\xF3\xB1\x9A\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8A"],
        ["\xF3\xB1\x9A\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8A"],

        ["\xF3\xB1\x9A\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8B"],
        ["\xF3\xB1\x9A\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8B"],

        ["\xF3\xB1\x9A\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8C"],
        ["\xF3\xB1\x9A\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8C"],

        ["\xF3\xB1\x9A\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8D"],
        ["\xF3\xB1\x9A\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8D"],

        ["\xF3\xB1\x9A\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8E"],
        ["\xF3\xB1\x9A\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8E"],

        ["\xF3\xB1\x9A\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8F"],
        ["\xF3\xB1\x9A\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8F"],

        ["\xF3\xB1\x9A\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x90"],
        ["\xF3\xB1\x9A\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x90"],

        ["\xF3\xB1\x9A\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x91"],
        ["\xF3\xB1\x9A\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x91"],

        ["\xF3\xB1\x9A\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x92"],
        ["\xF3\xB1\x9A\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x92"],

        ["\xF3\xB1\x9A\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x93"],
        ["\xF3\xB1\x9A\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x93"],

        ["\xF3\xB1\x9A\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x94"],
        ["\xF3\xB1\x9A\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x94"],

        ["\xF3\xB1\x9A\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x95"],
        ["\xF3\xB1\x9A\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x95"],

        ["\xF3\xB1\x9A\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x96"],
        ["\xF3\xB1\x9A\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x96"],

        ["\xF3\xB1\x9A\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x97"],
        ["\xF3\xB1\x9A\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x97"],

        ["\xF3\xB1\x9A\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x98"],
        ["\xF3\xB1\x9A\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x98"],

        ["\xF3\xB1\x9A\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x99"],
        ["\xF3\xB1\x9A\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x99"],

        ["\xF3\xB1\x9A\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9A"],
        ["\xF3\xB1\x9A\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9A"],

        ["\xF3\xB1\x9A\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9B"],
        ["\xF3\xB1\x9A\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9B"],

        ["\xF3\xB1\x9A\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9C"],
        ["\xF3\xB1\x9A\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9C"],

        ["\xF3\xB1\x9A\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9D"],
        ["\xF3\xB1\x9A\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9D"],

        ["\xF3\xB1\x9A\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9E"],
        ["\xF3\xB1\x9A\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9E"],

        ["\xF3\xB1\x9A\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9F"],
        ["\xF3\xB1\x9A\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9F"],

        ["\xF3\xB1\x9A\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA0"],
        ["\xF3\xB1\x9A\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA0"],

        ["\xF3\xB1\x9A\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA1"],
        ["\xF3\xB1\x9A\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA1"],

        ["\xF3\xB1\x9A\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA2"],
        ["\xF3\xB1\x9A\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA2"],

        ["\xF3\xB1\x9A\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA3"],
        ["\xF3\xB1\x9A\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA3"],

        ["\xF3\xB1\x9A\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA4"],
        ["\xF3\xB1\x9A\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA4"],

        ["\xF3\xB1\x9A\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA5"],
        ["\xF3\xB1\x9A\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA5"],

        ["\xF3\xB1\x9A\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA6"],
        ["\xF3\xB1\x9A\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA6"],

        ["\xF3\xB1\x9A\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA7"],
        ["\xF3\xB1\x9A\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA7"],

        ["\xF3\xB1\x9A\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA8"],
        ["\xF3\xB1\x9A\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA8"],

        ["\xF3\xB1\x9A\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA9"],
        ["\xF3\xB1\x9A\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA9"],

        ["\xF3\xB1\x9A\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAA"],
        ["\xF3\xB1\x9A\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAA"],

        ["\xF3\xB1\x9A\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAB"],
        ["\xF3\xB1\x9A\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAB"],

        ["\xF3\xB1\x9A\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAC"],
        ["\xF3\xB1\x9A\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAC"],

        ["\xF3\xB1\x9A\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAD"],
        ["\xF3\xB1\x9A\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAD"],

        ["\xF3\xB1\x9A\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAE"],
        ["\xF3\xB1\x9A\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAE"],

        ["\xF3\xB1\x9A\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAF"],
        ["\xF3\xB1\x9A\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAF"],

        ["\xF3\xB1\x9A\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB0"],
        ["\xF3\xB1\x9A\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB0"],

        ["\xF3\xB1\x9A\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB1"],
        ["\xF3\xB1\x9A\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB1"],

        ["\xF3\xB1\x9A\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB2"],
        ["\xF3\xB1\x9A\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB2"],

        ["\xF3\xB1\x9A\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB3"],
        ["\xF3\xB1\x9A\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB3"],

        ["\xF3\xB1\x9A\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB4"],
        ["\xF3\xB1\x9A\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB4"],

        ["\xF3\xB1\x9A\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB5"],
        ["\xF3\xB1\x9A\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB5"],

        ["\xF3\xB1\x9A\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB6"],
        ["\xF3\xB1\x9A\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB6"],

        ["\xF3\xB1\x9A\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB7"],
        ["\xF3\xB1\x9A\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB7"],

        ["\xF3\xB1\x9A\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB8"],
        ["\xF3\xB1\x9A\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB8"],

        ["\xF3\xB1\x9A\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB9"],
        ["\xF3\xB1\x9A\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB9"],

        ["\xF3\xB1\x9A\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBA"],
        ["\xF3\xB1\x9A\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBA"],

        ["\xF3\xB1\x9A\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBB"],
        ["\xF3\xB1\x9A\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBB"],

        ["\xF3\xB1\x9A\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBC"],
        ["\xF3\xB1\x9A\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBC"],

        ["\xF3\xB1\x9A\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBD"],
        ["\xF3\xB1\x9A\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBD"],

        ["\xF3\xB1\x9A\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBE"],
        ["\xF3\xB1\x9A\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBE"],

        ["\xF3\xB1\x9A\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBF"],
        ["\xF3\xB1\x9A\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBF"],

        ["\xF3\xB1\x9B\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x80"],
        ["\xF3\xB1\x9B\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x80"],

        ["\xF3\xB1\x9B\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x81"],
        ["\xF3\xB1\x9B\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x81"],

        ["\xF3\xB1\x9B\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x82"],
        ["\xF3\xB1\x9B\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x82"],

        ["\xF3\xB1\x9B\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x83"],
        ["\xF3\xB1\x9B\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x83"],

        ["\xF3\xB1\x9B\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x84"],
        ["\xF3\xB1\x9B\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x84"],

        ["\xF3\xB1\x9B\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x85"],
        ["\xF3\xB1\x9B\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x85"],

        ["\xF3\xB1\x9B\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x86"],
        ["\xF3\xB1\x9B\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x86"],

        ["\xF3\xB1\x9B\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x87"],
        ["\xF3\xB1\x9B\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x87"],

        ["\xF3\xB1\x9B\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x88"],
        ["\xF3\xB1\x9B\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x88"],

        ["\xF3\xB1\x9B\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x89"],
        ["\xF3\xB1\x9B\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x89"],

        ["\xF3\xB1\x9B\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8A"],
        ["\xF3\xB1\x9B\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8A"],

        ["\xF3\xB1\x9B\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8B"],
        ["\xF3\xB1\x9B\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8B"],

        ["\xF3\xB1\x9B\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8C"],
        ["\xF3\xB1\x9B\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8C"],

        ["\xF3\xB1\x9B\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8D"],
        ["\xF3\xB1\x9B\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8D"],

        ["\xF3\xB1\x9B\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8E"],
        ["\xF3\xB1\x9B\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8E"],

        ["\xF3\xB1\x9B\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8F"],
        ["\xF3\xB1\x9B\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8F"],

        ["\xF3\xB1\x9B\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x90"],
        ["\xF3\xB1\x9B\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x90"],

        ["\xF3\xB1\x9B\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x91"],
        ["\xF3\xB1\x9B\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x91"],

        ["\xF3\xB1\x9B\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x92"],
        ["\xF3\xB1\x9B\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x92"],

        ["\xF3\xB1\x9B\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x93"],
        ["\xF3\xB1\x9B\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x93"],

        ["\xF3\xB1\x9B\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x94"],
        ["\xF3\xB1\x9B\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x94"],

        ["\xF3\xB1\x9B\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x95"],
        ["\xF3\xB1\x9B\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x95"],

        ["\xF3\xB1\x9B\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x96"],
        ["\xF3\xB1\x9B\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x96"],

        ["\xF3\xB1\x9B\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x97"],
        ["\xF3\xB1\x9B\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x97"],

        ["\xF3\xB1\x9B\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x98"],
        ["\xF3\xB1\x9B\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x98"],

        ["\xF3\xB1\x9B\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x99"],
        ["\xF3\xB1\x9B\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x99"],

        ["\xF3\xB1\x9B\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9A"],
        ["\xF3\xB1\x9B\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9A"],

        ["\xF3\xB1\x9B\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9B"],
        ["\xF3\xB1\x9B\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9B"],

        ["\xF3\xB1\x9B\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9C"],
        ["\xF3\xB1\x9B\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9C"],

        ["\xF3\xB1\x9B\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9D"],
        ["\xF3\xB1\x9B\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9D"],

        ["\xF3\xB1\x9B\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9E"],
        ["\xF3\xB1\x9B\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9E"],

        ["\xF3\xB1\x9B\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9F"],
        ["\xF3\xB1\x9B\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9F"],

        ["\xF3\xB1\x9B\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA0"],
        ["\xF3\xB1\x9B\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA0"],

        ["\xF3\xB1\x9B\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA1"],
        ["\xF3\xB1\x9B\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA1"],

        ["\xF3\xB1\x9B\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA2"],
        ["\xF3\xB1\x9B\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA2"],

        ["\xF3\xB1\x9B\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA3"],
        ["\xF3\xB1\x9B\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA3"],

        ["\xF3\xB1\x9B\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA4"],
        ["\xF3\xB1\x9B\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA4"],

        ["\xF3\xB1\x9B\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA5"],
        ["\xF3\xB1\x9B\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA5"],

        ["\xF3\xB1\x9B\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA6"],
        ["\xF3\xB1\x9B\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA6"],

        ["\xF3\xB1\x9B\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA7"],
        ["\xF3\xB1\x9B\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA7"],

        ["\xF3\xB1\x9B\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA8"],
        ["\xF3\xB1\x9B\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA8"],

        ["\xF3\xB1\x9B\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA9"],
        ["\xF3\xB1\x9B\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA9"],

        ["\xF3\xB1\x9B\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAA"],
        ["\xF3\xB1\x9B\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAA"],

        ["\xF3\xB1\x9B\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAB"],
        ["\xF3\xB1\x9B\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAB"],

        ["\xF3\xB1\x9B\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAC"],
        ["\xF3\xB1\x9B\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAC"],

        ["\xF3\xB1\x9B\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAD"],
        ["\xF3\xB1\x9B\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAD"],

        ["\xF3\xB1\x9B\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAE"],
        ["\xF3\xB1\x9B\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAE"],

        ["\xF3\xB1\x9B\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAF"],
        ["\xF3\xB1\x9B\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAF"],

        ["\xF3\xB1\x9B\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB0"],
        ["\xF3\xB1\x9B\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB0"],

        ["\xF3\xB1\x9B\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB1"],
        ["\xF3\xB1\x9B\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB1"],

        ["\xF3\xB1\x9B\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB2"],
        ["\xF3\xB1\x9B\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB2"],

        ["\xF3\xB1\x9B\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB3"],
        ["\xF3\xB1\x9B\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB3"],

        ["\xF3\xB1\x9B\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB4"],
        ["\xF3\xB1\x9B\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB4"],

        ["\xF3\xB1\x9B\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB5"],
        ["\xF3\xB1\x9B\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB5"],

        ["\xF3\xB1\x9B\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB6"],
        ["\xF3\xB1\x9B\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB6"],

        ["\xF3\xB1\x9B\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB7"],
        ["\xF3\xB1\x9B\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB7"],

        ["\xF3\xB1\x9B\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB8"],
        ["\xF3\xB1\x9B\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB8"],

        ["\xF3\xB1\x9B\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB9"],
        ["\xF3\xB1\x9B\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB9"],

        ["\xF3\xB1\x9B\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBA"],
        ["\xF3\xB1\x9B\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBA"],

        ["\xF3\xB1\x9B\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBB"],
        ["\xF3\xB1\x9B\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBB"],

        ["\xF3\xB1\x9B\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBC"],
        ["\xF3\xB1\x9B\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBC"],

        ["\xF3\xB1\x9B\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBD"],
        ["\xF3\xB1\x9B\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBD"],

        ["\xF3\xB1\x9B\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBE"],
        ["\xF3\xB1\x9B\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBE"],

        ["\xF3\xB1\x9B\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBF"],
        ["\xF3\xB1\x9B\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBF"],

        ["\xF3\xB1\x9C\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x80"],
        ["\xF3\xB1\x9C\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x80"],

        ["\xF3\xB1\x9C\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x81"],
        ["\xF3\xB1\x9C\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x81"],

        ["\xF3\xB1\x9C\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x82"],
        ["\xF3\xB1\x9C\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x82"],

        ["\xF3\xB1\x9C\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x83"],
        ["\xF3\xB1\x9C\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x83"],

        ["\xF3\xB1\x9C\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x84"],
        ["\xF3\xB1\x9C\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x84"],

        ["\xF3\xB1\x9C\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x85"],
        ["\xF3\xB1\x9C\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x85"],

        ["\xF3\xB1\x9C\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x86"],
        ["\xF3\xB1\x9C\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x86"],

        ["\xF3\xB1\x9C\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x87"],
        ["\xF3\xB1\x9C\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x87"],

        ["\xF3\xB1\x9C\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x88"],
        ["\xF3\xB1\x9C\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x88"],

        ["\xF3\xB1\x9C\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x89"],
        ["\xF3\xB1\x9C\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x89"],

        ["\xF3\xB1\x9C\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8A"],
        ["\xF3\xB1\x9C\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8A"],

        ["\xF3\xB1\x9C\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8B"],
        ["\xF3\xB1\x9C\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8B"],

        ["\xF3\xB1\x9C\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8C"],
        ["\xF3\xB1\x9C\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8C"],

        ["\xF3\xB1\x9C\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8D"],
        ["\xF3\xB1\x9C\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8D"],

        ["\xF3\xB1\x9C\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8E"],
        ["\xF3\xB1\x9C\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8E"],

        ["\xF3\xB1\x9C\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8F"],
        ["\xF3\xB1\x9C\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8F"],

        ["\xF3\xB1\x9C\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x90"],
        ["\xF3\xB1\x9C\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x90"],

        ["\xF3\xB1\x9C\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x91"],
        ["\xF3\xB1\x9C\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x91"],

        ["\xF3\xB1\x9C\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x92"],
        ["\xF3\xB1\x9C\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x92"],

        ["\xF3\xB1\x9C\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x93"],
        ["\xF3\xB1\x9C\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x93"],

        ["\xF3\xB1\x9C\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x94"],
        ["\xF3\xB1\x9C\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x94"],

        ["\xF3\xB1\x9C\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x95"],
        ["\xF3\xB1\x9C\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x95"],

        ["\xF3\xB1\x9C\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x96"],
        ["\xF3\xB1\x9C\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x96"],

        ["\xF3\xB1\x9C\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x97"],
        ["\xF3\xB1\x9C\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x97"],

        ["\xF3\xB1\x9C\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x98"],
        ["\xF3\xB1\x9C\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x98"],

        ["\xF3\xB1\x9C\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x99"],
        ["\xF3\xB1\x9C\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x99"],

        ["\xF3\xB1\x9C\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9A"],
        ["\xF3\xB1\x9C\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9A"],

        ["\xF3\xB1\x9C\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9B"],
        ["\xF3\xB1\x9C\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9B"],

        ["\xF3\xB1\x9C\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9C"],
        ["\xF3\xB1\x9C\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9C"],

        ["\xF3\xB1\x9C\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9D"],
        ["\xF3\xB1\x9C\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9D"],

        ["\xF3\xB1\x9C\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9E"],
        ["\xF3\xB1\x9C\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9E"],

        ["\xF3\xB1\x9C\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9F"],
        ["\xF3\xB1\x9C\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9F"],

        ["\xF3\xB1\x9C\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA0"],
        ["\xF3\xB1\x9C\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA0"],

        ["\xF3\xB1\x9C\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA1"],
        ["\xF3\xB1\x9C\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA1"],

        ["\xF3\xB1\x9C\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA2"],
        ["\xF3\xB1\x9C\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA2"],

        ["\xF3\xB1\x9C\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA3"],
        ["\xF3\xB1\x9C\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA3"],

        ["\xF3\xB1\x9C\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA4"],
        ["\xF3\xB1\x9C\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA4"],

        ["\xF3\xB1\x9C\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA5"],
        ["\xF3\xB1\x9C\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA5"],

        ["\xF3\xB1\x9C\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA6"],
        ["\xF3\xB1\x9C\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA6"],

        ["\xF3\xB1\x9C\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA7"],
        ["\xF3\xB1\x9C\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA7"],

        ["\xF3\xB1\x9C\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA8"],
        ["\xF3\xB1\x9C\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA8"],

        ["\xF3\xB1\x9C\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA9"],
        ["\xF3\xB1\x9C\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA9"],

        ["\xF3\xB1\x9C\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAA"],
        ["\xF3\xB1\x9C\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAA"],

        ["\xF3\xB1\x9C\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAB"],
        ["\xF3\xB1\x9C\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAB"],

        ["\xF3\xB1\x9C\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAC"],
        ["\xF3\xB1\x9C\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAC"],

        ["\xF3\xB1\x9C\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAD"],
        ["\xF3\xB1\x9C\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAD"],

        ["\xF3\xB1\x9C\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAE"],
        ["\xF3\xB1\x9C\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAE"],

        ["\xF3\xB1\x9C\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAF"],
        ["\xF3\xB1\x9C\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAF"],

        ["\xF3\xB1\x9C\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB0"],
        ["\xF3\xB1\x9C\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB0"],

        ["\xF3\xB1\x9C\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB1"],
        ["\xF3\xB1\x9C\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB1"],

        ["\xF3\xB1\x9C\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB2"],
        ["\xF3\xB1\x9C\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB2"],

        ["\xF3\xB1\x9C\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB3"],
        ["\xF3\xB1\x9C\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB3"],

        ["\xF3\xB1\x9C\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB4"],
        ["\xF3\xB1\x9C\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB4"],

        ["\xF3\xB1\x9C\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB5"],
        ["\xF3\xB1\x9C\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB5"],

        ["\xF3\xB1\x9C\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB6"],
        ["\xF3\xB1\x9C\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB6"],

        ["\xF3\xB1\x9C\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB7"],
        ["\xF3\xB1\x9C\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB7"],

        ["\xF3\xB1\x9C\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB8"],
        ["\xF3\xB1\x9C\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB8"],

        ["\xF3\xB1\x9C\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB9"],
        ["\xF3\xB1\x9C\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB9"],

        ["\xF3\xB1\x9C\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBA"],
        ["\xF3\xB1\x9C\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBA"],

        ["\xF3\xB1\x9C\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBB"],
        ["\xF3\xB1\x9C\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBB"],

        ["\xF3\xB1\x9C\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBC"],
        ["\xF3\xB1\x9C\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBC"],

        ["\xF3\xB1\x9C\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBD"],
        ["\xF3\xB1\x9C\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBD"],

        ["\xF3\xB1\x9C\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBE"],
        ["\xF3\xB1\x9C\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBE"],

        ["\xF3\xB1\x9C\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBF"],
        ["\xF3\xB1\x9C\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBF"],

        ["\xF3\xB1\x9D\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x80"],
        ["\xF3\xB1\x9D\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x80"],

        ["\xF3\xB1\x9D\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x81"],
        ["\xF3\xB1\x9D\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x81"],

        ["\xF3\xB1\x9D\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x82"],
        ["\xF3\xB1\x9D\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x82"],

        ["\xF3\xB1\x9D\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x83"],
        ["\xF3\xB1\x9D\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x83"],

        ["\xF3\xB1\x9D\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x84"],
        ["\xF3\xB1\x9D\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x84"],

        ["\xF3\xB1\x9D\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x85"],
        ["\xF3\xB1\x9D\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x85"],

        ["\xF3\xB1\x9D\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x86"],
        ["\xF3\xB1\x9D\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x86"],

        ["\xF3\xB1\x9D\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x87"],
        ["\xF3\xB1\x9D\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x87"],

        ["\xF3\xB1\x9D\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x88"],
        ["\xF3\xB1\x9D\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x88"],

        ["\xF3\xB1\x9D\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x89"],
        ["\xF3\xB1\x9D\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x89"],

        ["\xF3\xB1\x9D\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8A"],
        ["\xF3\xB1\x9D\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8A"],

        ["\xF3\xB1\x9D\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8B"],
        ["\xF3\xB1\x9D\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8B"],

        ["\xF3\xB1\x9D\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8C"],
        ["\xF3\xB1\x9D\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8C"],

        ["\xF3\xB1\x9D\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8D"],
        ["\xF3\xB1\x9D\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8D"],

        ["\xF3\xB1\x9D\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8E"],
        ["\xF3\xB1\x9D\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8E"],

        ["\xF3\xB1\x9D\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8F"],
        ["\xF3\xB1\x9D\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8F"],

        ["\xF3\xB1\x9D\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x90"],
        ["\xF3\xB1\x9D\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x90"],

        ["\xF3\xB1\x9D\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x91"],
        ["\xF3\xB1\x9D\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x91"],

        ["\xF3\xB1\x9D\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x92"],
        ["\xF3\xB1\x9D\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x92"],

        ["\xF3\xB1\x9D\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x93"],
        ["\xF3\xB1\x9D\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x93"],

        ["\xF3\xB1\x9D\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x94"],
        ["\xF3\xB1\x9D\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x94"],

        ["\xF3\xB1\x9D\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x95"],
        ["\xF3\xB1\x9D\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x95"],

        ["\xF3\xB1\x9D\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x96"],
        ["\xF3\xB1\x9D\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x96"],

        ["\xF3\xB1\x9D\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x97"],
        ["\xF3\xB1\x9D\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x97"],

        ["\xF3\xB1\x9D\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x98"],
        ["\xF3\xB1\x9D\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x98"],

        ["\xF3\xB1\x9D\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x99"],
        ["\xF3\xB1\x9D\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x99"],

        ["\xF3\xB1\x9D\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9A"],
        ["\xF3\xB1\x9D\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9A"],

        ["\xF3\xB1\x9D\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9B"],
        ["\xF3\xB1\x9D\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9B"],

        ["\xF3\xB1\x9D\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9C"],
        ["\xF3\xB1\x9D\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9C"],

        ["\xF3\xB1\x9D\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9D"],
        ["\xF3\xB1\x9D\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9D"],

        ["\xF3\xB1\x9D\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9E"],
        ["\xF3\xB1\x9D\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9E"],

        ["\xF3\xB1\x9D\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9F"],
        ["\xF3\xB1\x9D\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9F"],

        ["\xF3\xB1\x9D\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA0"],
        ["\xF3\xB1\x9D\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA0"],

        ["\xF3\xB1\x9D\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA1"],
        ["\xF3\xB1\x9D\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA1"],

        ["\xF3\xB1\x9D\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA2"],
        ["\xF3\xB1\x9D\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA2"],

        ["\xF3\xB1\x9D\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA3"],
        ["\xF3\xB1\x9D\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA3"],

        ["\xF3\xB1\x9D\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA4"],
        ["\xF3\xB1\x9D\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA4"],

        ["\xF3\xB1\x9D\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA5"],
        ["\xF3\xB1\x9D\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA5"],

        ["\xF3\xB1\x9D\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA6"],
        ["\xF3\xB1\x9D\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA6"],

        ["\xF3\xB1\x9D\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA7"],
        ["\xF3\xB1\x9D\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA7"],

        ["\xF3\xB1\x9D\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA8"],
        ["\xF3\xB1\x9D\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA8"],

        ["\xF3\xB1\x9D\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA9"],
        ["\xF3\xB1\x9D\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA9"],

        ["\xF3\xB1\x9D\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAA"],
        ["\xF3\xB1\x9D\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAA"],

        ["\xF3\xB1\x9D\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAB"],
        ["\xF3\xB1\x9D\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAB"],

        ["\xF3\xB1\x9D\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAC"],
        ["\xF3\xB1\x9D\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAC"],

        ["\xF3\xB1\x9D\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAD"],
        ["\xF3\xB1\x9D\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAD"],

        ["\xF3\xB1\x9D\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAE"],
        ["\xF3\xB1\x9D\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAE"],

        ["\xF3\xB1\x9D\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAF"],
        ["\xF3\xB1\x9D\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAF"],

        ["\xF3\xB1\x9D\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB0"],
        ["\xF3\xB1\x9D\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB0"],

        ["\xF3\xB1\x9D\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB1"],
        ["\xF3\xB1\x9D\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB1"],

        ["\xF3\xB1\x9D\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB2"],
        ["\xF3\xB1\x9D\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB2"],

        ["\xF3\xB1\x9D\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB3"],
        ["\xF3\xB1\x9D\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB3"],

        ["\xF3\xB1\x9D\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB4"],
        ["\xF3\xB1\x9D\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB4"],

        ["\xF3\xB1\x9D\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB5"],
        ["\xF3\xB1\x9D\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB5"],

        ["\xF3\xB1\x9D\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB6"],
        ["\xF3\xB1\x9D\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB6"],

        ["\xF3\xB1\x9D\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB7"],
        ["\xF3\xB1\x9D\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB7"],

        ["\xF3\xB1\x9D\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB8"],
        ["\xF3\xB1\x9D\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB8"],

        ["\xF3\xB1\x9D\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB9"],
        ["\xF3\xB1\x9D\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB9"],

        ["\xF3\xB1\x9D\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBA"],
        ["\xF3\xB1\x9D\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBA"],

        ["\xF3\xB1\x9D\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBB"],
        ["\xF3\xB1\x9D\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBB"],

        ["\xF3\xB1\x9D\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBC"],
        ["\xF3\xB1\x9D\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBC"],

        ["\xF3\xB1\x9D\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBD"],
        ["\xF3\xB1\x9D\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBD"],

        ["\xF3\xB1\x9D\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBE"],
        ["\xF3\xB1\x9D\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBE"],

        ["\xF3\xB1\x9D\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBF"],
        ["\xF3\xB1\x9D\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBF"],

        ["\xF3\xB1\x9E\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x80"],
        ["\xF3\xB1\x9E\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x80"],

        ["\xF3\xB1\x9E\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x81"],
        ["\xF3\xB1\x9E\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x81"],

        ["\xF3\xB1\x9E\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x82"],
        ["\xF3\xB1\x9E\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x82"],

        ["\xF3\xB1\x9E\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x83"],
        ["\xF3\xB1\x9E\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x83"],

        ["\xF3\xB1\x9E\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x84"],
        ["\xF3\xB1\x9E\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x84"],

        ["\xF3\xB1\x9E\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x85"],
        ["\xF3\xB1\x9E\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x85"],

        ["\xF3\xB1\x9E\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x86"],
        ["\xF3\xB1\x9E\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x86"],

        ["\xF3\xB1\x9E\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x87"],
        ["\xF3\xB1\x9E\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x87"],

        ["\xF3\xB1\x9E\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x88"],
        ["\xF3\xB1\x9E\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x88"],

        ["\xF3\xB1\x9E\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x89"],
        ["\xF3\xB1\x9E\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x89"],

        ["\xF3\xB1\x9E\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8A"],
        ["\xF3\xB1\x9E\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8A"],

        ["\xF3\xB1\x9E\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8B"],
        ["\xF3\xB1\x9E\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8B"],

        ["\xF3\xB1\x9E\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8C"],
        ["\xF3\xB1\x9E\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8C"],

        ["\xF3\xB1\x9E\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8D"],
        ["\xF3\xB1\x9E\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8D"],

        ["\xF3\xB1\x9E\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8E"],
        ["\xF3\xB1\x9E\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8E"],

        ["\xF3\xB1\x9E\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8F"],
        ["\xF3\xB1\x9E\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8F"],

        ["\xF3\xB1\x9E\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x90"],
        ["\xF3\xB1\x9E\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x90"],

        ["\xF3\xB1\x9E\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x91"],
        ["\xF3\xB1\x9E\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x91"],

        ["\xF3\xB1\x9E\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x92"],
        ["\xF3\xB1\x9E\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x92"],

        ["\xF3\xB1\x9E\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x93"],
        ["\xF3\xB1\x9E\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x93"],

        ["\xF3\xB1\x9E\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x94"],
        ["\xF3\xB1\x9E\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x94"],

        ["\xF3\xB1\x9E\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x95"],
        ["\xF3\xB1\x9E\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x95"],

        ["\xF3\xB1\x9E\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x96"],
        ["\xF3\xB1\x9E\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x96"],

        ["\xF3\xB1\x9E\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x97"],
        ["\xF3\xB1\x9E\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x97"],

        ["\xF3\xB1\x9E\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x98"],
        ["\xF3\xB1\x9E\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x98"],

        ["\xF3\xB1\x9E\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x99"],
        ["\xF3\xB1\x9E\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x99"],

        ["\xF3\xB1\x9E\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9A"],
        ["\xF3\xB1\x9E\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9A"],

        ["\xF3\xB1\x9E\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9B"],
        ["\xF3\xB1\x9E\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9B"],

        ["\xF3\xB1\x9E\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9C"],
        ["\xF3\xB1\x9E\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9C"],

        ["\xF3\xB1\x9E\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9D"],
        ["\xF3\xB1\x9E\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9D"],

        ["\xF3\xB1\x9E\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9E"],
        ["\xF3\xB1\x9E\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9E"],

        ["\xF3\xB1\x9E\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9F"],
        ["\xF3\xB1\x9E\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9F"],

        ["\xF3\xB1\x9E\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA0"],
        ["\xF3\xB1\x9E\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA0"],

        ["\xF3\xB1\x9E\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA1"],
        ["\xF3\xB1\x9E\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA1"],

        ["\xF3\xB1\x9E\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA2"],
        ["\xF3\xB1\x9E\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA2"],

        ["\xF3\xB1\x9E\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA3"],
        ["\xF3\xB1\x9E\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA3"],

        ["\xF3\xB1\x9E\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA4"],
        ["\xF3\xB1\x9E\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA4"],

        ["\xF3\xB1\x9E\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA5"],
        ["\xF3\xB1\x9E\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA5"],

        ["\xF3\xB1\x9E\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA6"],
        ["\xF3\xB1\x9E\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA6"],

        ["\xF3\xB1\x9E\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA7"],
        ["\xF3\xB1\x9E\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA7"],

        ["\xF3\xB1\x9E\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA8"],
        ["\xF3\xB1\x9E\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA8"],

        ["\xF3\xB1\x9E\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA9"],
        ["\xF3\xB1\x9E\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA9"],

        ["\xF3\xB1\x9E\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAA"],
        ["\xF3\xB1\x9E\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAA"],

        ["\xF3\xB1\x9E\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAB"],
        ["\xF3\xB1\x9E\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAB"],

        ["\xF3\xB1\x9E\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAC"],
        ["\xF3\xB1\x9E\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAC"],

        ["\xF3\xB1\x9E\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAD"],
        ["\xF3\xB1\x9E\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAD"],

        ["\xF3\xB1\x9E\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAE"],
        ["\xF3\xB1\x9E\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAE"],

        ["\xF3\xB1\x9E\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAF"],
        ["\xF3\xB1\x9E\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAF"],

        ["\xF3\xB1\x9E\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB0"],
        ["\xF3\xB1\x9E\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB0"],

        ["\xF3\xB1\x9E\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB1"],
        ["\xF3\xB1\x9E\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB1"],

        ["\xF3\xB1\x9E\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB2"],
        ["\xF3\xB1\x9E\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB2"],

        ["\xF3\xB1\x9E\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB3"],
        ["\xF3\xB1\x9E\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB3"],

        ["\xF3\xB1\x9E\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB4"],
        ["\xF3\xB1\x9E\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB4"],

        ["\xF3\xB1\x9E\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB5"],
        ["\xF3\xB1\x9E\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB5"],

        ["\xF3\xB1\x9E\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB6"],
        ["\xF3\xB1\x9E\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB6"],

        ["\xF3\xB1\x9E\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB7"],
        ["\xF3\xB1\x9E\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB7"],

        ["\xF3\xB1\x9E\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB8"],
        ["\xF3\xB1\x9E\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB8"],

        ["\xF3\xB1\x9E\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB9"],
        ["\xF3\xB1\x9E\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB9"],

        ["\xF3\xB1\x9E\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBA"],
        ["\xF3\xB1\x9E\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBA"],

        ["\xF3\xB1\x9E\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBB"],
        ["\xF3\xB1\x9E\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBB"],

        ["\xF3\xB1\x9E\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBC"],
        ["\xF3\xB1\x9E\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBC"],

        ["\xF3\xB1\x9E\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBD"],
        ["\xF3\xB1\x9E\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBD"],

        ["\xF3\xB1\x9E\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBE"],
        ["\xF3\xB1\x9E\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBE"],

        ["\xF3\xB1\x9E\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBF"],
        ["\xF3\xB1\x9E\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBF"],

        ["\xF3\xB1\x9F\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x80"],
        ["\xF3\xB1\x9F\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x80"],

        ["\xF3\xB1\x9F\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x81"],
        ["\xF3\xB1\x9F\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x81"],

        ["\xF3\xB1\x9F\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x82"],
        ["\xF3\xB1\x9F\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x82"],

        ["\xF3\xB1\x9F\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x83"],
        ["\xF3\xB1\x9F\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x83"],

        ["\xF3\xB1\x9F\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x84"],
        ["\xF3\xB1\x9F\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x84"],

        ["\xF3\xB1\x9F\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x85"],
        ["\xF3\xB1\x9F\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x85"],

        ["\xF3\xB1\x9F\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x86"],
        ["\xF3\xB1\x9F\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x86"],

        ["\xF3\xB1\x9F\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x87"],
        ["\xF3\xB1\x9F\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x87"],

        ["\xF3\xB1\x9F\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x88"],
        ["\xF3\xB1\x9F\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x88"],

        ["\xF3\xB1\x9F\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x89"],
        ["\xF3\xB1\x9F\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x89"],

        ["\xF3\xB1\x9F\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8A"],
        ["\xF3\xB1\x9F\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8A"],

        ["\xF3\xB1\x9F\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8B"],
        ["\xF3\xB1\x9F\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8B"],

        ["\xF3\xB1\x9F\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8C"],
        ["\xF3\xB1\x9F\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8C"],

        ["\xF3\xB1\x9F\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8D"],
        ["\xF3\xB1\x9F\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8D"],

        ["\xF3\xB1\x9F\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8E"],
        ["\xF3\xB1\x9F\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8E"],

        ["\xF3\xB1\x9F\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8F"],
        ["\xF3\xB1\x9F\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8F"],

        ["\xF3\xB1\x9F\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x90"],
        ["\xF3\xB1\x9F\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x90"],

        ["\xF3\xB1\x9F\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x91"],
        ["\xF3\xB1\x9F\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x91"],

        ["\xF3\xB1\x9F\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x92"],
        ["\xF3\xB1\x9F\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x92"],

        ["\xF3\xB1\x9F\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x93"],
        ["\xF3\xB1\x9F\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x93"],

        ["\xF3\xB1\x9F\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x94"],
        ["\xF3\xB1\x9F\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x94"],

        ["\xF3\xB1\x9F\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x95"],
        ["\xF3\xB1\x9F\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x95"],

        ["\xF3\xB1\x9F\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x96"],
        ["\xF3\xB1\x9F\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x96"],

        ["\xF3\xB1\x9F\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x97"],
        ["\xF3\xB1\x9F\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x97"],

        ["\xF3\xB1\x9F\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x98"],
        ["\xF3\xB1\x9F\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x98"],

        ["\xF3\xB1\x9F\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x99"],
        ["\xF3\xB1\x9F\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x99"],

        ["\xF3\xB1\x9F\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9A"],
        ["\xF3\xB1\x9F\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9A"],

        ["\xF3\xB1\x9F\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9B"],
        ["\xF3\xB1\x9F\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9B"],

        ["\xF3\xB1\x9F\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9C"],
        ["\xF3\xB1\x9F\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9C"],

        ["\xF3\xB1\x9F\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9D"],
        ["\xF3\xB1\x9F\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9D"],

        ["\xF3\xB1\x9F\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9E"],
        ["\xF3\xB1\x9F\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9E"],

        ["\xF3\xB1\x9F\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9F"],
        ["\xF3\xB1\x9F\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9F"],

        ["\xF3\xB1\x9F\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA0"],
        ["\xF3\xB1\x9F\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA0"],

        ["\xF3\xB1\x9F\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA1"],
        ["\xF3\xB1\x9F\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA1"],

        ["\xF3\xB1\x9F\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA2"],
        ["\xF3\xB1\x9F\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA2"],

        ["\xF3\xB1\x9F\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA3"],
        ["\xF3\xB1\x9F\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA3"],

        ["\xF3\xB1\x9F\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA4"],
        ["\xF3\xB1\x9F\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA4"],

        ["\xF3\xB1\x9F\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA5"],
        ["\xF3\xB1\x9F\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA5"],

        ["\xF3\xB1\x9F\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA6"],
        ["\xF3\xB1\x9F\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA6"],

        ["\xF3\xB1\x9F\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA7"],
        ["\xF3\xB1\x9F\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA7"],

        ["\xF3\xB1\x9F\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA8"],
        ["\xF3\xB1\x9F\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA8"],

        ["\xF3\xB1\x9F\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA9"],
        ["\xF3\xB1\x9F\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA9"],

        ["\xF3\xB1\x9F\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAA"],
        ["\xF3\xB1\x9F\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAA"],

        ["\xF3\xB1\x9F\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAB"],
        ["\xF3\xB1\x9F\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAB"],

        ["\xF3\xB1\x9F\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAC"],
        ["\xF3\xB1\x9F\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAC"],

        ["\xF3\xB1\x9F\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAD"],
        ["\xF3\xB1\x9F\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAD"],

        ["\xF3\xB1\x9F\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAE"],
        ["\xF3\xB1\x9F\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAE"],

        ["\xF3\xB1\x9F\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAF"],
        ["\xF3\xB1\x9F\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAF"],

        ["\xF3\xB1\x9F\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB0"],
        ["\xF3\xB1\x9F\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB0"],

        ["\xF3\xB1\x9F\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB1"],
        ["\xF3\xB1\x9F\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB1"],

        ["\xF3\xB1\x9F\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB2"],
        ["\xF3\xB1\x9F\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB2"],

        ["\xF3\xB1\x9F\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB3"],
        ["\xF3\xB1\x9F\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB3"],

        ["\xF3\xB1\x9F\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB4"],
        ["\xF3\xB1\x9F\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB4"],

        ["\xF3\xB1\x9F\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB5"],
        ["\xF3\xB1\x9F\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB5"],

        ["\xF3\xB1\x9F\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB6"],
        ["\xF3\xB1\x9F\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB6"],

        ["\xF3\xB1\x9F\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB7"],
        ["\xF3\xB1\x9F\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB7"],

        ["\xF3\xB1\x9F\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB8"],
        ["\xF3\xB1\x9F\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB8"],

        ["\xF3\xB1\x9F\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB9"],
        ["\xF3\xB1\x9F\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB9"],

        ["\xF3\xB1\x9F\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBA"],
        ["\xF3\xB1\x9F\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBA"],

        ["\xF3\xB1\x9F\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBB"],
        ["\xF3\xB1\x9F\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBB"],

        ["\xF3\xB1\x9F\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBC"],
        ["\xF3\xB1\x9F\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBC"],

        ["\xF3\xB1\x9F\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBD"],
        ["\xF3\xB1\x9F\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBD"],

        ["\xF3\xB1\x9F\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBE"],
        ["\xF3\xB1\x9F\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBE"],

        ["\xF3\xB1\x9F\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBF"],
        ["\xF3\xB1\x9F\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBF"],

        ["\xF3\xB1\xA0\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x80"],
        ["\xF3\xB1\xA0\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x80"],

        ["\xF3\xB1\xA0\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x81"],
        ["\xF3\xB1\xA0\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x81"],

        ["\xF3\xB1\xA0\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x82"],
        ["\xF3\xB1\xA0\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x82"],

        ["\xF3\xB1\xA0\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x83"],
        ["\xF3\xB1\xA0\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x83"],

        ["\xF3\xB1\xA0\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x84"],
        ["\xF3\xB1\xA0\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x84"],

        ["\xF3\xB1\xA0\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x85"],
        ["\xF3\xB1\xA0\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x85"],

        ["\xF3\xB1\xA0\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x86"],
        ["\xF3\xB1\xA0\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x86"],

        ["\xF3\xB1\xA0\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x87"],
        ["\xF3\xB1\xA0\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x87"],

        ["\xF3\xB1\xA0\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x88"],
        ["\xF3\xB1\xA0\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x88"],

        ["\xF3\xB1\xA0\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x89"],
        ["\xF3\xB1\xA0\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x89"],

        ["\xF3\xB1\xA0\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8A"],
        ["\xF3\xB1\xA0\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8A"],

        ["\xF3\xB1\xA0\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8B"],
        ["\xF3\xB1\xA0\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8B"],

        ["\xF3\xB1\xA0\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8C"],
        ["\xF3\xB1\xA0\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8C"],

        ["\xF3\xB1\xA0\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8D"],
        ["\xF3\xB1\xA0\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8D"],

        ["\xF3\xB1\xA0\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8E"],
        ["\xF3\xB1\xA0\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8E"],

        ["\xF3\xB1\xA0\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8F"],
        ["\xF3\xB1\xA0\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8F"],

        ["\xF3\xB1\xA0\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x90"],
        ["\xF3\xB1\xA0\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x90"],

        ["\xF3\xB1\xA0\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x91"],
        ["\xF3\xB1\xA0\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x91"],

        ["\xF3\xB1\xA0\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x92"],
        ["\xF3\xB1\xA0\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x92"],

        ["\xF3\xB1\xA0\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x93"],
        ["\xF3\xB1\xA0\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x93"],

        ["\xF3\xB1\xA0\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x94"],
        ["\xF3\xB1\xA0\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x94"],

        ["\xF3\xB1\xA0\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x95"],
        ["\xF3\xB1\xA0\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x95"],

        ["\xF3\xB1\xA0\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x96"],
        ["\xF3\xB1\xA0\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x96"],

        ["\xF3\xB1\xA0\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x97"],
        ["\xF3\xB1\xA0\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x97"],

        ["\xF3\xB1\xA0\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x98"],
        ["\xF3\xB1\xA0\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x98"],

        ["\xF3\xB1\xA0\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x99"],
        ["\xF3\xB1\xA0\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x99"],

        ["\xF3\xB1\xA0\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9A"],
        ["\xF3\xB1\xA0\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9A"],

        ["\xF3\xB1\xA0\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9B"],
        ["\xF3\xB1\xA0\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9B"],

        ["\xF3\xB1\xA0\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9C"],
        ["\xF3\xB1\xA0\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9C"],

        ["\xF3\xB1\xA0\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9D"],
        ["\xF3\xB1\xA0\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9D"],

        ["\xF3\xB1\xA0\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9E"],
        ["\xF3\xB1\xA0\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9E"],

        ["\xF3\xB1\xA0\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9F"],
        ["\xF3\xB1\xA0\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9F"],

        ["\xF3\xB1\xA0\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA0"],
        ["\xF3\xB1\xA0\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA0"],

        ["\xF3\xB1\xA0\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA1"],
        ["\xF3\xB1\xA0\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA1"],

        ["\xF3\xB1\xA0\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA2"],
        ["\xF3\xB1\xA0\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA2"],

        ["\xF3\xB1\xA0\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA3"],
        ["\xF3\xB1\xA0\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA3"],

        ["\xF3\xB1\xA0\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA4"],
        ["\xF3\xB1\xA0\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA4"],

        ["\xF3\xB1\xA0\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA5"],
        ["\xF3\xB1\xA0\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA5"],

        ["\xF3\xB1\xA0\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA6"],
        ["\xF3\xB1\xA0\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA6"],

        ["\xF3\xB1\xA0\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA7"],
        ["\xF3\xB1\xA0\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA7"],

        ["\xF3\xB1\xA0\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA8"],
        ["\xF3\xB1\xA0\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA8"],

        ["\xF3\xB1\xA0\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA9"],
        ["\xF3\xB1\xA0\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA9"],

        ["\xF3\xB1\xA0\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAA"],
        ["\xF3\xB1\xA0\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAA"],

        ["\xF3\xB1\xA0\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAB"],
        ["\xF3\xB1\xA0\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAB"],

        ["\xF3\xB1\xA0\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAC"],
        ["\xF3\xB1\xA0\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAC"],

        ["\xF3\xB1\xA0\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAD"],
        ["\xF3\xB1\xA0\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAD"],

        ["\xF3\xB1\xA0\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAE"],
        ["\xF3\xB1\xA0\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAE"],

        ["\xF3\xB1\xA0\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAF"],
        ["\xF3\xB1\xA0\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAF"],

        ["\xF3\xB1\xA0\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB0"],
        ["\xF3\xB1\xA0\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB0"],

        ["\xF3\xB1\xA0\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB1"],
        ["\xF3\xB1\xA0\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB1"],

        ["\xF3\xB1\xA0\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB2"],
        ["\xF3\xB1\xA0\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB2"],

        ["\xF3\xB1\xA0\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB3"],
        ["\xF3\xB1\xA0\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB3"],

        ["\xF3\xB1\xA0\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB4"],
        ["\xF3\xB1\xA0\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB4"],

        ["\xF3\xB1\xA0\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB5"],
        ["\xF3\xB1\xA0\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB5"],

        ["\xF3\xB1\xA0\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB6"],
        ["\xF3\xB1\xA0\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB6"],

        ["\xF3\xB1\xA0\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB7"],
        ["\xF3\xB1\xA0\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB7"],

        ["\xF3\xB1\xA0\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB8"],
        ["\xF3\xB1\xA0\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB8"],

        ["\xF3\xB1\xA0\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB9"],
        ["\xF3\xB1\xA0\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB9"],

        ["\xF3\xB1\xA0\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBA"],
        ["\xF3\xB1\xA0\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBA"],

        ["\xF3\xB1\xA0\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBB"],
        ["\xF3\xB1\xA0\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBB"],

        ["\xF3\xB1\xA0\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBC"],
        ["\xF3\xB1\xA0\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBC"],

        ["\xF3\xB1\xA0\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBD"],
        ["\xF3\xB1\xA0\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBD"],

        ["\xF3\xB1\xA0\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBE"],
        ["\xF3\xB1\xA0\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBE"],

        ["\xF3\xB1\xA0\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBF"],
        ["\xF3\xB1\xA0\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBF"],

        ["\xF3\xB1\xA1\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x80"],
        ["\xF3\xB1\xA1\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x80"],

        ["\xF3\xB1\xA1\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x81"],
        ["\xF3\xB1\xA1\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x81"],

        ["\xF3\xB1\xA1\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x82"],
        ["\xF3\xB1\xA1\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x82"],

        ["\xF3\xB1\xA1\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x83"],
        ["\xF3\xB1\xA1\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x83"],

        ["\xF3\xB1\xA1\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x84"],
        ["\xF3\xB1\xA1\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x84"],

        ["\xF3\xB1\xA1\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x85"],
        ["\xF3\xB1\xA1\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x85"],

        ["\xF3\xB1\xA1\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x86"],
        ["\xF3\xB1\xA1\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x86"],

        ["\xF3\xB1\xA1\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x87"],
        ["\xF3\xB1\xA1\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x87"],

        ["\xF3\xB1\xA1\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x88"],
        ["\xF3\xB1\xA1\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x88"],

        ["\xF3\xB1\xA1\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x89"],
        ["\xF3\xB1\xA1\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x89"],

        ["\xF3\xB1\xA1\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8A"],
        ["\xF3\xB1\xA1\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8A"],

        ["\xF3\xB1\xA1\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8B"],
        ["\xF3\xB1\xA1\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8B"],

        ["\xF3\xB1\xA1\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8C"],
        ["\xF3\xB1\xA1\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8C"],

        ["\xF3\xB1\xA1\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8D"],
        ["\xF3\xB1\xA1\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8D"],

        ["\xF3\xB1\xA1\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8E"],
        ["\xF3\xB1\xA1\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8E"],

        ["\xF3\xB1\xA1\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8F"],
        ["\xF3\xB1\xA1\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8F"],

        ["\xF3\xB1\xA1\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x90"],
        ["\xF3\xB1\xA1\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x90"],

        ["\xF3\xB1\xA1\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x91"],
        ["\xF3\xB1\xA1\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x91"],

        ["\xF3\xB1\xA1\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x92"],
        ["\xF3\xB1\xA1\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x92"],

        ["\xF3\xB1\xA1\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x93"],
        ["\xF3\xB1\xA1\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x93"],

        ["\xF3\xB1\xA1\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x94"],
        ["\xF3\xB1\xA1\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x94"],

        ["\xF3\xB1\xA1\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x95"],
        ["\xF3\xB1\xA1\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x95"],

        ["\xF3\xB1\xA1\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x96"],
        ["\xF3\xB1\xA1\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x96"],

        ["\xF3\xB1\xA1\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x97"],
        ["\xF3\xB1\xA1\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x97"],

        ["\xF3\xB1\xA1\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x98"],
        ["\xF3\xB1\xA1\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x98"],

        ["\xF3\xB1\xA1\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x99"],
        ["\xF3\xB1\xA1\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x99"],

        ["\xF3\xB1\xA1\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9A"],
        ["\xF3\xB1\xA1\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9A"],

        ["\xF3\xB1\xA1\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9B"],
        ["\xF3\xB1\xA1\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9B"],

        ["\xF3\xB1\xA1\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9C"],
        ["\xF3\xB1\xA1\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9C"],

        ["\xF3\xB1\xA1\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9D"],
        ["\xF3\xB1\xA1\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9D"],

        ["\xF3\xB1\xA1\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9E"],
        ["\xF3\xB1\xA1\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9E"],

        ["\xF3\xB1\xA1\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9F"],
        ["\xF3\xB1\xA1\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9F"],

        ["\xF3\xB1\xA1\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA0"],
        ["\xF3\xB1\xA1\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA0"],

        ["\xF3\xB1\xA1\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA1"],
        ["\xF3\xB1\xA1\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA1"],

        ["\xF3\xB1\xA1\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA2"],
        ["\xF3\xB1\xA1\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA2"],

        ["\xF3\xB1\xA1\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA3"],
        ["\xF3\xB1\xA1\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA3"],

        ["\xF3\xB1\xA1\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA4"],
        ["\xF3\xB1\xA1\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA4"],

        ["\xF3\xB1\xA1\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA5"],
        ["\xF3\xB1\xA1\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA5"],

        ["\xF3\xB1\xA1\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA6"],
        ["\xF3\xB1\xA1\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA6"],

        ["\xF3\xB1\xA1\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA7"],
        ["\xF3\xB1\xA1\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA7"],

        ["\xF3\xB1\xA1\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA8"],
        ["\xF3\xB1\xA1\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA8"],

        ["\xF3\xB1\xA1\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA9"],
        ["\xF3\xB1\xA1\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA9"],

        ["\xF3\xB1\xA1\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAA"],
        ["\xF3\xB1\xA1\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAA"],

        ["\xF3\xB1\xA1\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAB"],
        ["\xF3\xB1\xA1\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAB"],

        ["\xF3\xB1\xA1\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAC"],
        ["\xF3\xB1\xA1\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAC"],

        ["\xF3\xB1\xA1\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAD"],
        ["\xF3\xB1\xA1\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAD"],

        ["\xF3\xB1\xA1\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAE"],
        ["\xF3\xB1\xA1\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAE"],

        ["\xF3\xB1\xA1\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAF"],
        ["\xF3\xB1\xA1\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAF"],

        ["\xF3\xB1\xA1\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB0"],
        ["\xF3\xB1\xA1\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB0"],

        ["\xF3\xB1\xA1\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB1"],
        ["\xF3\xB1\xA1\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB1"],

        ["\xF3\xB1\xA1\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB2"],
        ["\xF3\xB1\xA1\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB2"],

        ["\xF3\xB1\xA1\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB3"],
        ["\xF3\xB1\xA1\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB3"],

        ["\xF3\xB1\xA1\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB4"],
        ["\xF3\xB1\xA1\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB4"],

        ["\xF3\xB1\xA1\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB5"],
        ["\xF3\xB1\xA1\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB5"],

        ["\xF3\xB1\xA1\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB6"],
        ["\xF3\xB1\xA1\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB6"],

        ["\xF3\xB1\xA1\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB7"],
        ["\xF3\xB1\xA1\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB7"],

        ["\xF3\xB1\xA1\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB8"],
        ["\xF3\xB1\xA1\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB8"],

        ["\xF3\xB1\xA1\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB9"],
        ["\xF3\xB1\xA1\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB9"],

        ["\xF3\xB1\xA1\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBA"],
        ["\xF3\xB1\xA1\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBA"],

        ["\xF3\xB1\xA1\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBB"],
        ["\xF3\xB1\xA1\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBB"],

        ["\xF3\xB1\xA1\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBC"],
        ["\xF3\xB1\xA1\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBC"],

        ["\xF3\xB1\xA1\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBD"],
        ["\xF3\xB1\xA1\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBD"],

        ["\xF3\xB1\xA1\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBE"],
        ["\xF3\xB1\xA1\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBE"],

        ["\xF3\xB1\xA1\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBF"],
        ["\xF3\xB1\xA1\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBF"],

        ["\xF3\xB1\xA2\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x80"],
        ["\xF3\xB1\xA2\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x80"],

        ["\xF3\xB1\xA2\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x81"],
        ["\xF3\xB1\xA2\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x81"],

        ["\xF3\xB1\xA2\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x82"],
        ["\xF3\xB1\xA2\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x82"],

        ["\xF3\xB1\xA2\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x83"],
        ["\xF3\xB1\xA2\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x83"],

        ["\xF3\xB1\xA2\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x84"],
        ["\xF3\xB1\xA2\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x84"],

        ["\xF3\xB1\xA2\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x85"],
        ["\xF3\xB1\xA2\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x85"],

        ["\xF3\xB1\xA2\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x86"],
        ["\xF3\xB1\xA2\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x86"],

        ["\xF3\xB1\xA2\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x87"],
        ["\xF3\xB1\xA2\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x87"],

        ["\xF3\xB1\xA2\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x88"],
        ["\xF3\xB1\xA2\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x88"],

        ["\xF3\xB1\xA2\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x89"],
        ["\xF3\xB1\xA2\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x89"],

        ["\xF3\xB1\xA2\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8A"],
        ["\xF3\xB1\xA2\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8A"],

        ["\xF3\xB1\xA2\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8B"],
        ["\xF3\xB1\xA2\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8B"],

        ["\xF3\xB1\xA2\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8C"],
        ["\xF3\xB1\xA2\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8C"],

        ["\xF3\xB1\xA2\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8D"],
        ["\xF3\xB1\xA2\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8D"],

        ["\xF3\xB1\xA2\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8E"],
        ["\xF3\xB1\xA2\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8E"],

        ["\xF3\xB1\xA2\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8F"],
        ["\xF3\xB1\xA2\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8F"],

        ["\xF3\xB1\xA2\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x90"],
        ["\xF3\xB1\xA2\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x90"],

        ["\xF3\xB1\xA2\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x91"],
        ["\xF3\xB1\xA2\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x91"],

        ["\xF3\xB1\xA2\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x92"],
        ["\xF3\xB1\xA2\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x92"],

        ["\xF3\xB1\xA2\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x93"],
        ["\xF3\xB1\xA2\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x93"],

        ["\xF3\xB1\xA2\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x94"],
        ["\xF3\xB1\xA2\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x94"],

        ["\xF3\xB1\xA2\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x95"],
        ["\xF3\xB1\xA2\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x95"],

        ["\xF3\xB1\xA2\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x96"],
        ["\xF3\xB1\xA2\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x96"],

        ["\xF3\xB1\xA2\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x97"],
        ["\xF3\xB1\xA2\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x97"],

        ["\xF3\xB1\xA2\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x98"],
        ["\xF3\xB1\xA2\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x98"],

        ["\xF3\xB1\xA2\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x99"],
        ["\xF3\xB1\xA2\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x99"],

        ["\xF3\xB1\xA2\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9A"],
        ["\xF3\xB1\xA2\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9A"],

        ["\xF3\xB1\xA2\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9B"],
        ["\xF3\xB1\xA2\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9B"],

        ["\xF3\xB1\xA2\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9C"],
        ["\xF3\xB1\xA2\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9C"],

        ["\xF3\xB1\xA2\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9D"],
        ["\xF3\xB1\xA2\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9D"],

        ["\xF3\xB1\xA2\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9E"],
        ["\xF3\xB1\xA2\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9E"],

        ["\xF3\xB1\xA2\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9F"],
        ["\xF3\xB1\xA2\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9F"],

        ["\xF3\xB1\xA2\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA0"],
        ["\xF3\xB1\xA2\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA0"],

        ["\xF3\xB1\xA2\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA1"],
        ["\xF3\xB1\xA2\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA1"],

        ["\xF3\xB1\xA2\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA2"],
        ["\xF3\xB1\xA2\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA2"],

        ["\xF3\xB1\xA2\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA3"],
        ["\xF3\xB1\xA2\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA3"],

        ["\xF3\xB1\xA2\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA4"],
        ["\xF3\xB1\xA2\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA4"],

        ["\xF3\xB1\xA2\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA5"],
        ["\xF3\xB1\xA2\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA5"],

        ["\xF3\xB1\xA2\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA6"],
        ["\xF3\xB1\xA2\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA6"],

        ["\xF3\xB1\xA2\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA7"],
        ["\xF3\xB1\xA2\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA7"],

        ["\xF3\xB1\xA2\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA8"],
        ["\xF3\xB1\xA2\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA8"],

        ["\xF3\xB1\xA2\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA9"],
        ["\xF3\xB1\xA2\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA9"],

        ["\xF3\xB1\xA2\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAA"],
        ["\xF3\xB1\xA2\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAA"],

        ["\xF3\xB1\xA2\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAB"],
        ["\xF3\xB1\xA2\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAB"],

        ["\xF3\xB1\xA2\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAC"],
        ["\xF3\xB1\xA2\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAC"],

        ["\xF3\xB1\xA2\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAD"],
        ["\xF3\xB1\xA2\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAD"],

        ["\xF3\xB1\xA2\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAE"],
        ["\xF3\xB1\xA2\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAE"],

        ["\xF3\xB1\xA2\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAF"],
        ["\xF3\xB1\xA2\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAF"],

        ["\xF3\xB1\xA2\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB0"],
        ["\xF3\xB1\xA2\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB0"],

        ["\xF3\xB1\xA2\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB1"],
        ["\xF3\xB1\xA2\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB1"],

        ["\xF3\xB1\xA2\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB2"],
        ["\xF3\xB1\xA2\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB2"],

        ["\xF3\xB1\xA2\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB3"],
        ["\xF3\xB1\xA2\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB3"],

        ["\xF3\xB1\xA2\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB4"],
        ["\xF3\xB1\xA2\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB4"],

        ["\xF3\xB1\xA2\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB5"],
        ["\xF3\xB1\xA2\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB5"],

        ["\xF3\xB1\xA2\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB6"],
        ["\xF3\xB1\xA2\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB6"],

        ["\xF3\xB1\xA2\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB7"],
        ["\xF3\xB1\xA2\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB7"],

        ["\xF3\xB1\xA2\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB8"],
        ["\xF3\xB1\xA2\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB8"],

        ["\xF3\xB1\xA2\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB9"],
        ["\xF3\xB1\xA2\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB9"],

        ["\xF3\xB1\xA2\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBA"],
        ["\xF3\xB1\xA2\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBA"],

        ["\xF3\xB1\xA2\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBB"],
        ["\xF3\xB1\xA2\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBB"],

        ["\xF3\xB1\xA2\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBC"],
        ["\xF3\xB1\xA2\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBC"],

        ["\xF3\xB1\xA2\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBD"],
        ["\xF3\xB1\xA2\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBD"],

        ["\xF3\xB1\xA2\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBE"],
        ["\xF3\xB1\xA2\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBE"],

        ["\xF3\xB1\xA2\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBF"],
        ["\xF3\xB1\xA2\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBF"],

        ["\xF3\xB1\xA3\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x80"],
        ["\xF3\xB1\xA3\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x80"],

        ["\xF3\xB1\xA3\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x81"],
        ["\xF3\xB1\xA3\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x81"],

        ["\xF3\xB1\xA3\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x82"],
        ["\xF3\xB1\xA3\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x82"],

        ["\xF3\xB1\xA3\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x83"],
        ["\xF3\xB1\xA3\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x83"],

        ["\xF3\xB1\xA3\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x84"],
        ["\xF3\xB1\xA3\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x84"],

        ["\xF3\xB1\xA3\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x85"],
        ["\xF3\xB1\xA3\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x85"],

        ["\xF3\xB1\xA3\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x86"],
        ["\xF3\xB1\xA3\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x86"],

        ["\xF3\xB1\xA3\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x87"],
        ["\xF3\xB1\xA3\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x87"],

        ["\xF3\xB1\xA3\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x88"],
        ["\xF3\xB1\xA3\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x88"],

        ["\xF3\xB1\xA3\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x89"],
        ["\xF3\xB1\xA3\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x89"],

        ["\xF3\xB1\xA3\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8A"],
        ["\xF3\xB1\xA3\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8A"],

        ["\xF3\xB1\xA3\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8B"],
        ["\xF3\xB1\xA3\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8B"],

        ["\xF3\xB1\xA3\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8C"],
        ["\xF3\xB1\xA3\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8C"],

        ["\xF3\xB1\xA3\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8D"],
        ["\xF3\xB1\xA3\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8D"],

        ["\xF3\xB1\xA3\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8E"],
        ["\xF3\xB1\xA3\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8E"],

        ["\xF3\xB1\xA3\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8F"],
        ["\xF3\xB1\xA3\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8F"],

        ["\xF3\xB1\xA3\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x90"],
        ["\xF3\xB1\xA3\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x90"],

        ["\xF3\xB1\xA3\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x91"],
        ["\xF3\xB1\xA3\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x91"],

        ["\xF3\xB1\xA3\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x92"],
        ["\xF3\xB1\xA3\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x92"],

        ["\xF3\xB1\xA3\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x93"],
        ["\xF3\xB1\xA3\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x93"],

        ["\xF3\xB1\xA3\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x94"],
        ["\xF3\xB1\xA3\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x94"],

        ["\xF3\xB1\xA3\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x95"],
        ["\xF3\xB1\xA3\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x95"],

        ["\xF3\xB1\xA3\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x96"],
        ["\xF3\xB1\xA3\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x96"],

        ["\xF3\xB1\xA3\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x97"],
        ["\xF3\xB1\xA3\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x97"],

        ["\xF3\xB1\xA3\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x98"],
        ["\xF3\xB1\xA3\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x98"],

        ["\xF3\xB1\xA3\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x99"],
        ["\xF3\xB1\xA3\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x99"],

        ["\xF3\xB1\xA3\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9A"],
        ["\xF3\xB1\xA3\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9A"],

        ["\xF3\xB1\xA3\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9B"],
        ["\xF3\xB1\xA3\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9B"],

        ["\xF3\xB1\xA3\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9C"],
        ["\xF3\xB1\xA3\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9C"],

        ["\xF3\xB1\xA3\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9D"],
        ["\xF3\xB1\xA3\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9D"],

        ["\xF3\xB1\xA3\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9E"],
        ["\xF3\xB1\xA3\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9E"],

        ["\xF3\xB1\xA3\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9F"],
        ["\xF3\xB1\xA3\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9F"],

        ["\xF3\xB1\xA3\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA0"],
        ["\xF3\xB1\xA3\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA0"],

        ["\xF3\xB1\xA3\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA1"],
        ["\xF3\xB1\xA3\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA1"],

        ["\xF3\xB1\xA3\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA2"],
        ["\xF3\xB1\xA3\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA2"],

        ["\xF3\xB1\xA3\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA3"],
        ["\xF3\xB1\xA3\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA3"],

        ["\xF3\xB1\xA3\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA4"],
        ["\xF3\xB1\xA3\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA4"],

        ["\xF3\xB1\xA3\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA5"],
        ["\xF3\xB1\xA3\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA5"],

        ["\xF3\xB1\xA3\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA6"],
        ["\xF3\xB1\xA3\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA6"],

        ["\xF3\xB1\xA3\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA7"],
        ["\xF3\xB1\xA3\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA7"],

        ["\xF3\xB1\xA3\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA8"],
        ["\xF3\xB1\xA3\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA8"],

        ["\xF3\xB1\xA3\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA9"],
        ["\xF3\xB1\xA3\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA9"],

        ["\xF3\xB1\xA3\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAA"],
        ["\xF3\xB1\xA3\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAA"],

        ["\xF3\xB1\xA3\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAB"],
        ["\xF3\xB1\xA3\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAB"],

        ["\xF3\xB1\xA3\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAC"],
        ["\xF3\xB1\xA3\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAC"],

        ["\xF3\xB1\xA3\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAD"],
        ["\xF3\xB1\xA3\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAD"],

        ["\xF3\xB1\xA3\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAE"],
        ["\xF3\xB1\xA3\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAE"],

        ["\xF3\xB1\xA3\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAF"],
        ["\xF3\xB1\xA3\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAF"],

        ["\xF3\xB1\xA3\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB0"],
        ["\xF3\xB1\xA3\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB0"],

        ["\xF3\xB1\xA3\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB1"],
        ["\xF3\xB1\xA3\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB1"],

        ["\xF3\xB1\xA3\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB2"],
        ["\xF3\xB1\xA3\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB2"],

        ["\xF3\xB1\xA3\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB3"],
        ["\xF3\xB1\xA3\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB3"],

        ["\xF3\xB1\xA3\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB4"],
        ["\xF3\xB1\xA3\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB4"],

        ["\xF3\xB1\xA3\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB5"],
        ["\xF3\xB1\xA3\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB5"],

        ["\xF3\xB1\xA3\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB6"],
        ["\xF3\xB1\xA3\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB6"],

        ["\xF3\xB1\xA3\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB7"],
        ["\xF3\xB1\xA3\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB7"],

        ["\xF3\xB1\xA3\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB8"],
        ["\xF3\xB1\xA3\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB8"],

        ["\xF3\xB1\xA3\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB9"],
        ["\xF3\xB1\xA3\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB9"],

        ["\xF3\xB1\xA3\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBA"],
        ["\xF3\xB1\xA3\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBA"],

        ["\xF3\xB1\xA3\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBB"],
        ["\xF3\xB1\xA3\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBB"],

        ["\xF3\xB1\xA3\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBC"],
        ["\xF3\xB1\xA3\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBC"],

        ["\xF3\xB1\xA3\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBD"],
        ["\xF3\xB1\xA3\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBD"],

        ["\xF3\xB1\xA3\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBE"],
        ["\xF3\xB1\xA3\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBE"],

        ["\xF3\xB1\xA3\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBF"],
        ["\xF3\xB1\xA3\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBF"],

        ["\xF3\xB1\xA4\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x80"],
        ["\xF3\xB1\xA4\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x80"],

        ["\xF3\xB1\xA4\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x81"],
        ["\xF3\xB1\xA4\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x81"],

        ["\xF3\xB1\xA4\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x82"],
        ["\xF3\xB1\xA4\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x82"],

        ["\xF3\xB1\xA4\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x83"],
        ["\xF3\xB1\xA4\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x83"],

        ["\xF3\xB1\xA4\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x84"],
        ["\xF3\xB1\xA4\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x84"],

        ["\xF3\xB1\xA4\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x85"],
        ["\xF3\xB1\xA4\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x85"],

        ["\xF3\xB1\xA4\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x86"],
        ["\xF3\xB1\xA4\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x86"],

        ["\xF3\xB1\xA4\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x87"],
        ["\xF3\xB1\xA4\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x87"],

        ["\xF3\xB1\xA4\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x88"],
        ["\xF3\xB1\xA4\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x88"],

        ["\xF3\xB1\xA4\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x89"],
        ["\xF3\xB1\xA4\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x89"],

        ["\xF3\xB1\xA4\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8A"],
        ["\xF3\xB1\xA4\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8A"],

        ["\xF3\xB1\xA4\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8B"],
        ["\xF3\xB1\xA4\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8B"],

        ["\xF3\xB1\xA4\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8C"],
        ["\xF3\xB1\xA4\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8C"],

        ["\xF3\xB1\xA4\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8D"],
        ["\xF3\xB1\xA4\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8D"],

        ["\xF3\xB1\xA4\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8E"],
        ["\xF3\xB1\xA4\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8E"],

        ["\xF3\xB1\xA4\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8F"],
        ["\xF3\xB1\xA4\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8F"],

        ["\xF3\xB1\xA4\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x90"],
        ["\xF3\xB1\xA4\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x90"],

        ["\xF3\xB1\xA4\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x91"],
        ["\xF3\xB1\xA4\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x91"],

        ["\xF3\xB1\xA4\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x92"],
        ["\xF3\xB1\xA4\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x92"],

        ["\xF3\xB1\xA4\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x93"],
        ["\xF3\xB1\xA4\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x93"],

        ["\xF3\xB1\xA4\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x94"],
        ["\xF3\xB1\xA4\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x94"],

        ["\xF3\xB1\xA4\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x95"],
        ["\xF3\xB1\xA4\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x95"],

        ["\xF3\xB1\xA4\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x96"],
        ["\xF3\xB1\xA4\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x96"],

        ["\xF3\xB1\xA4\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x97"],
        ["\xF3\xB1\xA4\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x97"],

        ["\xF3\xB1\xA4\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x98"],
        ["\xF3\xB1\xA4\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x98"],

        ["\xF3\xB1\xA4\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x99"],
        ["\xF3\xB1\xA4\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x99"],

        ["\xF3\xB1\xA4\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9A"],
        ["\xF3\xB1\xA4\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9A"],

        ["\xF3\xB1\xA4\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9B"],
        ["\xF3\xB1\xA4\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9B"],

        ["\xF3\xB1\xA4\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9C"],
        ["\xF3\xB1\xA4\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9C"],

        ["\xF3\xB1\xA4\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9D"],
        ["\xF3\xB1\xA4\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9D"],

        ["\xF3\xB1\xA4\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9E"],
        ["\xF3\xB1\xA4\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9E"],

        ["\xF3\xB1\xA4\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9F"],
        ["\xF3\xB1\xA4\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9F"],

        ["\xF3\xB1\xA4\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA0"],
        ["\xF3\xB1\xA4\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA0"],

        ["\xF3\xB1\xA4\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA1"],
        ["\xF3\xB1\xA4\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA1"],

        ["\xF3\xB1\xA4\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA2"],
        ["\xF3\xB1\xA4\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA2"],

        ["\xF3\xB1\xA4\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA3"],
        ["\xF3\xB1\xA4\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA3"],

        ["\xF3\xB1\xA4\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA4"],
        ["\xF3\xB1\xA4\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA4"],

        ["\xF3\xB1\xA4\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA5"],
        ["\xF3\xB1\xA4\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA5"],

        ["\xF3\xB1\xA4\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA6"],
        ["\xF3\xB1\xA4\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA6"],

        ["\xF3\xB1\xA4\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA7"],
        ["\xF3\xB1\xA4\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA7"],

        ["\xF3\xB1\xA4\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA8"],
        ["\xF3\xB1\xA4\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA8"],

        ["\xF3\xB1\xA4\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA9"],
        ["\xF3\xB1\xA4\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA9"],

        ["\xF3\xB1\xA4\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAA"],
        ["\xF3\xB1\xA4\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAA"],

        ["\xF3\xB1\xA4\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAB"],
        ["\xF3\xB1\xA4\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAB"],

        ["\xF3\xB1\xA4\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAC"],
        ["\xF3\xB1\xA4\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAC"],

        ["\xF3\xB1\xA4\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAD"],
        ["\xF3\xB1\xA4\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAD"],

        ["\xF3\xB1\xA4\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAE"],
        ["\xF3\xB1\xA4\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAE"],

        ["\xF3\xB1\xA4\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAF"],
        ["\xF3\xB1\xA4\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAF"],

        ["\xF3\xB1\xA4\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB0"],
        ["\xF3\xB1\xA4\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB0"],

        ["\xF3\xB1\xA4\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB1"],
        ["\xF3\xB1\xA4\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB1"],

        ["\xF3\xB1\xA4\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB2"],
        ["\xF3\xB1\xA4\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB2"],

        ["\xF3\xB1\xA4\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB3"],
        ["\xF3\xB1\xA4\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB3"],

        ["\xF3\xB1\xA4\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB4"],
        ["\xF3\xB1\xA4\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB4"],

        ["\xF3\xB1\xA4\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB5"],
        ["\xF3\xB1\xA4\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB5"],

        ["\xF3\xB1\xA4\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB6"],
        ["\xF3\xB1\xA4\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB6"],

        ["\xF3\xB1\xA4\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB7"],
        ["\xF3\xB1\xA4\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB7"],

        ["\xF3\xB1\xA4\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB8"],
        ["\xF3\xB1\xA4\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB8"],

        ["\xF3\xB1\xA4\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB9"],
        ["\xF3\xB1\xA4\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB9"],

        ["\xF3\xB1\xA4\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBA"],
        ["\xF3\xB1\xA4\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBA"],

        ["\xF3\xB1\xA4\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBB"],
        ["\xF3\xB1\xA4\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBB"],

        ["\xF3\xB1\xA4\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBC"],
        ["\xF3\xB1\xA4\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBC"],

        ["\xF3\xB1\xA4\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBD"],
        ["\xF3\xB1\xA4\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBD"],

        ["\xF3\xB1\xA4\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBE"],
        ["\xF3\xB1\xA4\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBE"],

        ["\xF3\xB1\xA4\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBF"],
        ["\xF3\xB1\xA4\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBF"],

        ["\xF3\xB1\xA5\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x80"],
        ["\xF3\xB1\xA5\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x80"],

        ["\xF3\xB1\xA5\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x81"],
        ["\xF3\xB1\xA5\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x81"],

        ["\xF3\xB1\xA5\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x82"],
        ["\xF3\xB1\xA5\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x82"],

        ["\xF3\xB1\xA5\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x83"],
        ["\xF3\xB1\xA5\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x83"],

        ["\xF3\xB1\xA5\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x84"],
        ["\xF3\xB1\xA5\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x84"],

        ["\xF3\xB1\xA5\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x85"],
        ["\xF3\xB1\xA5\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x85"],

        ["\xF3\xB1\xA5\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x86"],
        ["\xF3\xB1\xA5\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x86"],

        ["\xF3\xB1\xA5\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x87"],
        ["\xF3\xB1\xA5\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x87"],

        ["\xF3\xB1\xA5\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x88"],
        ["\xF3\xB1\xA5\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x88"],

        ["\xF3\xB1\xA5\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x89"],
        ["\xF3\xB1\xA5\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x89"],

        ["\xF3\xB1\xA5\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8A"],
        ["\xF3\xB1\xA5\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8A"],

        ["\xF3\xB1\xA5\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8B"],
        ["\xF3\xB1\xA5\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8B"],

        ["\xF3\xB1\xA5\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8C"],
        ["\xF3\xB1\xA5\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8C"],

        ["\xF3\xB1\xA5\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8D"],
        ["\xF3\xB1\xA5\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8D"],

        ["\xF3\xB1\xA5\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8E"],
        ["\xF3\xB1\xA5\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8E"],

        ["\xF3\xB1\xA5\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8F"],
        ["\xF3\xB1\xA5\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8F"],

        ["\xF3\xB1\xA5\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x90"],
        ["\xF3\xB1\xA5\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x90"],

        ["\xF3\xB1\xA5\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x91"],
        ["\xF3\xB1\xA5\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x91"],

        ["\xF3\xB1\xA5\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x92"],
        ["\xF3\xB1\xA5\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x92"],

        ["\xF3\xB1\xA5\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x93"],
        ["\xF3\xB1\xA5\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x93"],

        ["\xF3\xB1\xA5\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x94"],
        ["\xF3\xB1\xA5\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x94"],

        ["\xF3\xB1\xA5\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x95"],
        ["\xF3\xB1\xA5\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x95"],

        ["\xF3\xB1\xA5\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x96"],
        ["\xF3\xB1\xA5\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x96"],

        ["\xF3\xB1\xA5\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x97"],
        ["\xF3\xB1\xA5\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x97"],

        ["\xF3\xB1\xA5\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x98"],
        ["\xF3\xB1\xA5\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x98"],

        ["\xF3\xB1\xA5\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x99"],
        ["\xF3\xB1\xA5\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x99"],

        ["\xF3\xB1\xA5\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9A"],
        ["\xF3\xB1\xA5\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9A"],

        ["\xF3\xB1\xA5\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9B"],
        ["\xF3\xB1\xA5\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9B"],

        ["\xF3\xB1\xA5\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9C"],
        ["\xF3\xB1\xA5\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9C"],

        ["\xF3\xB1\xA5\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9D"],
        ["\xF3\xB1\xA5\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9D"],

        ["\xF3\xB1\xA5\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9E"],
        ["\xF3\xB1\xA5\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9E"],

        ["\xF3\xB1\xA5\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9F"],
        ["\xF3\xB1\xA5\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9F"],

        ["\xF3\xB1\xA5\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA0"],
        ["\xF3\xB1\xA5\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA0"],

        ["\xF3\xB1\xA5\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA1"],
        ["\xF3\xB1\xA5\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA1"],

        ["\xF3\xB1\xA5\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA2"],
        ["\xF3\xB1\xA5\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA2"],

        ["\xF3\xB1\xA5\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA3"],
        ["\xF3\xB1\xA5\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA3"],

        ["\xF3\xB1\xA5\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA4"],
        ["\xF3\xB1\xA5\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA4"],

        ["\xF3\xB1\xA5\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA5"],
        ["\xF3\xB1\xA5\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA5"],

        ["\xF3\xB1\xA5\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA6"],
        ["\xF3\xB1\xA5\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA6"],

        ["\xF3\xB1\xA5\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA7"],
        ["\xF3\xB1\xA5\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA7"],

        ["\xF3\xB1\xA5\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA8"],
        ["\xF3\xB1\xA5\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA8"],

        ["\xF3\xB1\xA5\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA9"],
        ["\xF3\xB1\xA5\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA9"],

        ["\xF3\xB1\xA5\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAA"],
        ["\xF3\xB1\xA5\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAA"],

        ["\xF3\xB1\xA5\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAB"],
        ["\xF3\xB1\xA5\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAB"],

        ["\xF3\xB1\xA5\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAC"],
        ["\xF3\xB1\xA5\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAC"],

        ["\xF3\xB1\xA5\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAD"],
        ["\xF3\xB1\xA5\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAD"],

        ["\xF3\xB1\xA5\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAE"],
        ["\xF3\xB1\xA5\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAE"],

        ["\xF3\xB1\xA5\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAF"],
        ["\xF3\xB1\xA5\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAF"],

        ["\xF3\xB1\xA5\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB0"],
        ["\xF3\xB1\xA5\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB0"],

        ["\xF3\xB1\xA5\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB1"],
        ["\xF3\xB1\xA5\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB1"],

        ["\xF3\xB1\xA5\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB2"],
        ["\xF3\xB1\xA5\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB2"],

        ["\xF3\xB1\xA5\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB3"],
        ["\xF3\xB1\xA5\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB3"],

        ["\xF3\xB1\xA5\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB4"],
        ["\xF3\xB1\xA5\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB4"],

        ["\xF3\xB1\xA5\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB5"],
        ["\xF3\xB1\xA5\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB5"],

        ["\xF3\xB1\xA5\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB6"],
        ["\xF3\xB1\xA5\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB6"],

        ["\xF3\xB1\xA5\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB7"],
        ["\xF3\xB1\xA5\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB7"],

        ["\xF3\xB1\xA5\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB8"],
        ["\xF3\xB1\xA5\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB8"],

        ["\xF3\xB1\xA5\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB9"],
        ["\xF3\xB1\xA5\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB9"],

        ["\xF3\xB1\xA5\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBA"],
        ["\xF3\xB1\xA5\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBA"],

        ["\xF3\xB1\xA5\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBB"],
        ["\xF3\xB1\xA5\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBB"],

        ["\xF3\xB1\xA5\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBC"],
        ["\xF3\xB1\xA5\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBC"],

        ["\xF3\xB1\xA5\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBD"],
        ["\xF3\xB1\xA5\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBD"],

        ["\xF3\xB1\xA5\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBE"],
        ["\xF3\xB1\xA5\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBE"],

        ["\xF3\xB1\xA5\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBF"],
        ["\xF3\xB1\xA5\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBF"],

        ["\xF3\xB1\xA6\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x80"],
        ["\xF3\xB1\xA6\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x80"],

        ["\xF3\xB1\xA6\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x81"],
        ["\xF3\xB1\xA6\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x81"],

        ["\xF3\xB1\xA6\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x82"],
        ["\xF3\xB1\xA6\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x82"],

        ["\xF3\xB1\xA6\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x83"],
        ["\xF3\xB1\xA6\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x83"],

        ["\xF3\xB1\xA6\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x84"],
        ["\xF3\xB1\xA6\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x84"],

        ["\xF3\xB1\xA6\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x85"],
        ["\xF3\xB1\xA6\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x85"],

        ["\xF3\xB1\xA6\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x86"],
        ["\xF3\xB1\xA6\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x86"],

        ["\xF3\xB1\xA6\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x87"],
        ["\xF3\xB1\xA6\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x87"],

        ["\xF3\xB1\xA6\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x88"],
        ["\xF3\xB1\xA6\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x88"],

        ["\xF3\xB1\xA6\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x89"],
        ["\xF3\xB1\xA6\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x89"],

        ["\xF3\xB1\xA6\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8A"],
        ["\xF3\xB1\xA6\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8A"],

        ["\xF3\xB1\xA6\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8B"],
        ["\xF3\xB1\xA6\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8B"],

        ["\xF3\xB1\xA6\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8C"],
        ["\xF3\xB1\xA6\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8C"],

        ["\xF3\xB1\xA6\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8D"],
        ["\xF3\xB1\xA6\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8D"],

        ["\xF3\xB1\xA6\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8E"],
        ["\xF3\xB1\xA6\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8E"],

        ["\xF3\xB1\xA6\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8F"],
        ["\xF3\xB1\xA6\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8F"],

        ["\xF3\xB1\xA6\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x90"],
        ["\xF3\xB1\xA6\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x90"],

        ["\xF3\xB1\xA6\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x91"],
        ["\xF3\xB1\xA6\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x91"],

        ["\xF3\xB1\xA6\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x92"],
        ["\xF3\xB1\xA6\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x92"],

        ["\xF3\xB1\xA6\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x93"],
        ["\xF3\xB1\xA6\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x93"],

        ["\xF3\xB1\xA6\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x94"],
        ["\xF3\xB1\xA6\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x94"],

        ["\xF3\xB1\xA6\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x95"],
        ["\xF3\xB1\xA6\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x95"],

        ["\xF3\xB1\xA6\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x96"],
        ["\xF3\xB1\xA6\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x96"],

        ["\xF3\xB1\xA6\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x97"],
        ["\xF3\xB1\xA6\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x97"],

        ["\xF3\xB1\xA6\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x98"],
        ["\xF3\xB1\xA6\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x98"],

        ["\xF3\xB1\xA6\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x99"],
        ["\xF3\xB1\xA6\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x99"],

        ["\xF3\xB1\xA6\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9A"],
        ["\xF3\xB1\xA6\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9A"],

        ["\xF3\xB1\xA6\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9B"],
        ["\xF3\xB1\xA6\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9B"],

        ["\xF3\xB1\xA6\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9C"],
        ["\xF3\xB1\xA6\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9C"],

        ["\xF3\xB1\xA6\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9D"],
        ["\xF3\xB1\xA6\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9D"],

        ["\xF3\xB1\xA6\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9E"],
        ["\xF3\xB1\xA6\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9E"],

        ["\xF3\xB1\xA6\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9F"],
        ["\xF3\xB1\xA6\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9F"],

        ["\xF3\xB1\xA6\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA0"],
        ["\xF3\xB1\xA6\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA0"],

        ["\xF3\xB1\xA6\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA1"],
        ["\xF3\xB1\xA6\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA1"],

        ["\xF3\xB1\xA6\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA2"],
        ["\xF3\xB1\xA6\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA2"],

        ["\xF3\xB1\xA6\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA3"],
        ["\xF3\xB1\xA6\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA3"],

        ["\xF3\xB1\xA6\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA4"],
        ["\xF3\xB1\xA6\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA4"],

        ["\xF3\xB1\xA6\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA5"],
        ["\xF3\xB1\xA6\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA5"],

        ["\xF3\xB1\xA6\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA6"],
        ["\xF3\xB1\xA6\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA6"],

        ["\xF3\xB1\xA6\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA7"],
        ["\xF3\xB1\xA6\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA7"],

        ["\xF3\xB1\xA6\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA8"],
        ["\xF3\xB1\xA6\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA8"],

        ["\xF3\xB1\xA6\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA9"],
        ["\xF3\xB1\xA6\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA9"],

        ["\xF3\xB1\xA6\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAA"],
        ["\xF3\xB1\xA6\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAA"],

        ["\xF3\xB1\xA6\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAB"],
        ["\xF3\xB1\xA6\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAB"],

        ["\xF3\xB1\xA6\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAC"],
        ["\xF3\xB1\xA6\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAC"],

        ["\xF3\xB1\xA6\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAD"],
        ["\xF3\xB1\xA6\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAD"],

        ["\xF3\xB1\xA6\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAE"],
        ["\xF3\xB1\xA6\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAE"],

        ["\xF3\xB1\xA6\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAF"],
        ["\xF3\xB1\xA6\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAF"],

        ["\xF3\xB1\xA6\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB0"],
        ["\xF3\xB1\xA6\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB0"],

        ["\xF3\xB1\xA6\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB1"],
        ["\xF3\xB1\xA6\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB1"],

        ["\xF3\xB1\xA6\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB2"],
        ["\xF3\xB1\xA6\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB2"],

        ["\xF3\xB1\xA6\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB3"],
        ["\xF3\xB1\xA6\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB3"],

        ["\xF3\xB1\xA6\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB4"],
        ["\xF3\xB1\xA6\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB4"],

        ["\xF3\xB1\xA6\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB5"],
        ["\xF3\xB1\xA6\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB5"],

        ["\xF3\xB1\xA6\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB6"],
        ["\xF3\xB1\xA6\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB6"],

        ["\xF3\xB1\xA6\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB7"],
        ["\xF3\xB1\xA6\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB7"],

        ["\xF3\xB1\xA6\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB8"],
        ["\xF3\xB1\xA6\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB8"],

        ["\xF3\xB1\xA6\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB9"],
        ["\xF3\xB1\xA6\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB9"],

        ["\xF3\xB1\xA6\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBA"],
        ["\xF3\xB1\xA6\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBA"],

        ["\xF3\xB1\xA6\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBB"],
        ["\xF3\xB1\xA6\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBB"],

        ["\xF3\xB1\xA6\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBC"],
        ["\xF3\xB1\xA6\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBC"],

        ["\xF3\xB1\xA6\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBD"],
        ["\xF3\xB1\xA6\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBD"],

        ["\xF3\xB1\xA6\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBE"],
        ["\xF3\xB1\xA6\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBE"],

        ["\xF3\xB1\xA6\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBF"],
        ["\xF3\xB1\xA6\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBF"],

        ["\xF3\xB1\xA7\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x80"],
        ["\xF3\xB1\xA7\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x80"],

        ["\xF3\xB1\xA7\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x81"],
        ["\xF3\xB1\xA7\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x81"],

        ["\xF3\xB1\xA7\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x82"],
        ["\xF3\xB1\xA7\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x82"],

        ["\xF3\xB1\xA7\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x83"],
        ["\xF3\xB1\xA7\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x83"],

        ["\xF3\xB1\xA7\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x84"],
        ["\xF3\xB1\xA7\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x84"],

        ["\xF3\xB1\xA7\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x85"],
        ["\xF3\xB1\xA7\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x85"],

        ["\xF3\xB1\xA7\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x86"],
        ["\xF3\xB1\xA7\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x86"],

        ["\xF3\xB1\xA7\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x87"],
        ["\xF3\xB1\xA7\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x87"],

        ["\xF3\xB1\xA7\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x88"],
        ["\xF3\xB1\xA7\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x88"],

        ["\xF3\xB1\xA7\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x89"],
        ["\xF3\xB1\xA7\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x89"],

        ["\xF3\xB1\xA7\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8A"],
        ["\xF3\xB1\xA7\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8A"],

        ["\xF3\xB1\xA7\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8B"],
        ["\xF3\xB1\xA7\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8B"],

        ["\xF3\xB1\xA7\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8C"],
        ["\xF3\xB1\xA7\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8C"],

        ["\xF3\xB1\xA7\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8D"],
        ["\xF3\xB1\xA7\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8D"],

        ["\xF3\xB1\xA7\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8E"],
        ["\xF3\xB1\xA7\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8E"],

        ["\xF3\xB1\xA7\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8F"],
        ["\xF3\xB1\xA7\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8F"],

        ["\xF3\xB1\xA7\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x90"],
        ["\xF3\xB1\xA7\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x90"],

        ["\xF3\xB1\xA7\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x91"],
        ["\xF3\xB1\xA7\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x91"],

        ["\xF3\xB1\xA7\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x92"],
        ["\xF3\xB1\xA7\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x92"],

        ["\xF3\xB1\xA7\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x93"],
        ["\xF3\xB1\xA7\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x93"],

        ["\xF3\xB1\xA7\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x94"],
        ["\xF3\xB1\xA7\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x94"],

        ["\xF3\xB1\xA7\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x95"],
        ["\xF3\xB1\xA7\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x95"],

        ["\xF3\xB1\xA7\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x96"],
        ["\xF3\xB1\xA7\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x96"],

        ["\xF3\xB1\xA7\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x97"],
        ["\xF3\xB1\xA7\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x97"],

        ["\xF3\xB1\xA7\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x98"],
        ["\xF3\xB1\xA7\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x98"],

        ["\xF3\xB1\xA7\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x99"],
        ["\xF3\xB1\xA7\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x99"],

        ["\xF3\xB1\xA7\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9A"],
        ["\xF3\xB1\xA7\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9A"],

        ["\xF3\xB1\xA7\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9B"],
        ["\xF3\xB1\xA7\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9B"],

        ["\xF3\xB1\xA7\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9C"],
        ["\xF3\xB1\xA7\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9C"],

        ["\xF3\xB1\xA7\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9D"],
        ["\xF3\xB1\xA7\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9D"],

        ["\xF3\xB1\xA7\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9E"],
        ["\xF3\xB1\xA7\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9E"],

        ["\xF3\xB1\xA7\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9F"],
        ["\xF3\xB1\xA7\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9F"],

        ["\xF3\xB1\xA7\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA0"],
        ["\xF3\xB1\xA7\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA0"],

        ["\xF3\xB1\xA7\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA1"],
        ["\xF3\xB1\xA7\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA1"],

        ["\xF3\xB1\xA7\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA2"],
        ["\xF3\xB1\xA7\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA2"],

        ["\xF3\xB1\xA7\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA3"],
        ["\xF3\xB1\xA7\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA3"],

        ["\xF3\xB1\xA7\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA4"],
        ["\xF3\xB1\xA7\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA4"],

        ["\xF3\xB1\xA7\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA5"],
        ["\xF3\xB1\xA7\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA5"],

        ["\xF3\xB1\xA7\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA6"],
        ["\xF3\xB1\xA7\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA6"],

        ["\xF3\xB1\xA7\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA7"],
        ["\xF3\xB1\xA7\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA7"],

        ["\xF3\xB1\xA7\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA8"],
        ["\xF3\xB1\xA7\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA8"],

        ["\xF3\xB1\xA7\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA9"],
        ["\xF3\xB1\xA7\xA9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA9"],

        ["\xF3\xB1\xA7\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAA"],
        ["\xF3\xB1\xA7\xAA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAA"],

        ["\xF3\xB1\xA7\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAB"],
        ["\xF3\xB1\xA7\xAB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAB"],

        ["\xF3\xB1\xA7\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAC"],
        ["\xF3\xB1\xA7\xAC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAC"],

        ["\xF3\xB1\xA7\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAD"],
        ["\xF3\xB1\xA7\xAD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAD"],

        ["\xF3\xB1\xA7\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAE"],
        ["\xF3\xB1\xA7\xAE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAE"],

        ["\xF3\xB1\xA7\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAF"],
        ["\xF3\xB1\xA7\xAF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAF"],

        ["\xF3\xB1\xA7\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB0"],
        ["\xF3\xB1\xA7\xB0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB0"],

        ["\xF3\xB1\xA7\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB1"],
        ["\xF3\xB1\xA7\xB1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB1"],

        ["\xF3\xB1\xA7\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB2"],
        ["\xF3\xB1\xA7\xB2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB2"],

        ["\xF3\xB1\xA7\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB3"],
        ["\xF3\xB1\xA7\xB3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB3"],

        ["\xF3\xB1\xA7\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB4"],
        ["\xF3\xB1\xA7\xB4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB4"],

        ["\xF3\xB1\xA7\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB5"],
        ["\xF3\xB1\xA7\xB5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB5"],

        ["\xF3\xB1\xA7\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB6"],
        ["\xF3\xB1\xA7\xB6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB6"],

        ["\xF3\xB1\xA7\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB7"],
        ["\xF3\xB1\xA7\xB7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB7"],

        ["\xF3\xB1\xA7\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB8"],
        ["\xF3\xB1\xA7\xB8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB8"],

        ["\xF3\xB1\xA7\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB9"],
        ["\xF3\xB1\xA7\xB9",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB9"],

        ["\xF3\xB1\xA7\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBA"],
        ["\xF3\xB1\xA7\xBA",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBA"],

        ["\xF3\xB1\xA7\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBB"],
        ["\xF3\xB1\xA7\xBB",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBB"],

        ["\xF3\xB1\xA7\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBC"],
        ["\xF3\xB1\xA7\xBC",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBC"],

        ["\xF3\xB1\xA7\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBD"],
        ["\xF3\xB1\xA7\xBD",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBD"],

        ["\xF3\xB1\xA7\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBE"],
        ["\xF3\xB1\xA7\xBE",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBE"],

        ["\xF3\xB1\xA7\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBF"],
        ["\xF3\xB1\xA7\xBF",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBF"],

        ["\xF3\xB1\xA8\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x80"],
        ["\xF3\xB1\xA8\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x80"],

        ["\xF3\xB1\xA8\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x81"],
        ["\xF3\xB1\xA8\x81",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x81"],

        ["\xF3\xB1\xA8\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x82"],
        ["\xF3\xB1\xA8\x82",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x82"],

        ["\xF3\xB1\xA8\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x83"],
        ["\xF3\xB1\xA8\x83",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x83"],

        ["\xF3\xB1\xA8\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x84"],
        ["\xF3\xB1\xA8\x84",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x84"],

        ["\xF3\xB1\xA8\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x85"],
        ["\xF3\xB1\xA8\x85",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x85"],

        ["\xF3\xB1\xA8\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x86"],
        ["\xF3\xB1\xA8\x86",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x86"],

        ["\xF3\xB1\xA8\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x87"],
        ["\xF3\xB1\xA8\x87",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x87"],

        ["\xF3\xB1\xA8\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x88"],
        ["\xF3\xB1\xA8\x88",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x88"],

        ["\xF3\xB1\xA8\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x89"],
        ["\xF3\xB1\xA8\x89",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x89"],

        ["\xF3\xB1\xA8\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8A"],
        ["\xF3\xB1\xA8\x8A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8A"],

        ["\xF3\xB1\xA8\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8B"],
        ["\xF3\xB1\xA8\x8B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8B"],

        ["\xF3\xB1\xA8\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8C"],
        ["\xF3\xB1\xA8\x8C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8C"],

        ["\xF3\xB1\xA8\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8D"],
        ["\xF3\xB1\xA8\x8D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8D"],

        ["\xF3\xB1\xA8\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8E"],
        ["\xF3\xB1\xA8\x8E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8E"],

        ["\xF3\xB1\xA8\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8F"],
        ["\xF3\xB1\xA8\x8F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8F"],

        ["\xF3\xB1\xA8\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x90"],
        ["\xF3\xB1\xA8\x90",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x90"],

        ["\xF3\xB1\xA8\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x91"],
        ["\xF3\xB1\xA8\x91",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x91"],

        ["\xF3\xB1\xA8\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x92"],
        ["\xF3\xB1\xA8\x92",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x92"],

        ["\xF3\xB1\xA8\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x93"],
        ["\xF3\xB1\xA8\x93",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x93"],

        ["\xF3\xB1\xA8\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x94"],
        ["\xF3\xB1\xA8\x94",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x94"],

        ["\xF3\xB1\xA8\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x95"],
        ["\xF3\xB1\xA8\x95",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x95"],

        ["\xF3\xB1\xA8\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x96"],
        ["\xF3\xB1\xA8\x96",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x96"],

        ["\xF3\xB1\xA8\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x97"],
        ["\xF3\xB1\xA8\x97",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x97"],

        ["\xF3\xB1\xA8\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x98"],
        ["\xF3\xB1\xA8\x98",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x98"],

        ["\xF3\xB1\xA8\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x99"],
        ["\xF3\xB1\xA8\x99",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x99"],

        ["\xF3\xB1\xA8\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9A"],
        ["\xF3\xB1\xA8\x9A",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9A"],

        ["\xF3\xB1\xA8\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9B"],
        ["\xF3\xB1\xA8\x9B",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9B"],

        ["\xF3\xB1\xA8\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9C"],
        ["\xF3\xB1\xA8\x9C",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9C"],

        ["\xF3\xB1\xA8\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9D"],
        ["\xF3\xB1\xA8\x9D",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9D"],

        ["\xF3\xB1\xA8\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9E"],
        ["\xF3\xB1\xA8\x9E",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9E"],

        ["\xF3\xB1\xA8\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9F"],
        ["\xF3\xB1\xA8\x9F",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9F"],

        ["\xF3\xB1\xA8\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA0"],
        ["\xF3\xB1\xA8\xA0",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA0"],

        ["\xF3\xB1\xA8\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA1"],
        ["\xF3\xB1\xA8\xA1",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA1"],

        ["\xF3\xB1\xA8\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA2"],
        ["\xF3\xB1\xA8\xA2",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA2"],

        ["\xF3\xB1\xA8\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA3"],
        ["\xF3\xB1\xA8\xA3",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA3"],

        ["\xF3\xB1\xA8\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA4"],
        ["\xF3\xB1\xA8\xA4",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA4"],

        ["\xF3\xB1\xA8\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA5"],
        ["\xF3\xB1\xA8\xA5",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA5"],

        ["\xF3\xB1\xA8\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA6"],
        ["\xF3\xB1\xA8\xA6",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA6"],

        ["\xF3\xB1\xA8\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA7"],
        ["\xF3\xB1\xA8\xA7",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA7"],

        ["\xF3\xB1\xA8\xA8",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA8"],
        ["\xF3\xB1\xA8\x