/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.CountDownLatch;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.http.StateGrabber;

public class BucketsStreamingHandler
implements Observer {
    private final OutputStream output;
    private final Bucket bucket;
    private final CouchbaseMock.HarakiriMonitor monitor;
    private final CountDownLatch completed;

    public BucketsStreamingHandler(CouchbaseMock.HarakiriMonitor monitor, Bucket bucket, OutputStream output) {
        this.output = output;
        this.bucket = bucket;
        this.monitor = monitor;
        this.completed = new CountDownLatch(1);
    }

    private byte[] getConfigBytes() {
        StringWriter sw = new StringWriter();
        sw.append(StateGrabber.getBucketJSON(this.bucket));
        sw.append(StateGrabber.getStreamDelimiter());
        return sw.toString().getBytes();
    }

    @Override
    public void update(Observable o, Object arg) {
        try {
            this.output.write(this.getConfigBytes());
            this.output.flush();
        }
        catch (IOException ex) {
            this.completed.countDown();
        }
    }

    public void startStreaming() throws IOException, InterruptedException {
        this.bucket.configReadLock();
        if (this.monitor != null) {
            this.monitor.addObserver(this);
        }
        this.output.write(this.getConfigBytes());
        this.output.flush();
        this.bucket.configReadUnlock();
        this.completed.await();
        this.output.close();
    }
}

