/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.CodecHandler;
import com.healthmarketscience.jackcess.impl.KeyCache;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.TempBufferHolder;
import com.healthmarketscience.jackcess.util.StreamCipherCompat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public abstract class BaseCryptCodecHandler
implements CodecHandler {
    public static final boolean CIPHER_DECRYPT_MODE = false;
    public static final boolean CIPHER_ENCRYPT_MODE = true;
    private final PageChannel _channel;
    private final byte[] _encodingKey;
    private final KeyCache<CipherParameters> _paramCache = new KeyCache<CipherParameters>(){

        @Override
        protected CipherParameters computeKey(int pageNumber) {
            return BaseCryptCodecHandler.this.computeCipherParams(pageNumber);
        }
    };
    private TempBufferHolder _tempBufH;

    protected BaseCryptCodecHandler(PageChannel channel, byte[] encodingKey) {
        this._channel = channel;
        this._encodingKey = encodingKey;
    }

    protected CipherParameters getCipherParams(int pageNumber) {
        return this._paramCache.get(pageNumber);
    }

    protected byte[] getEncodingKey() {
        return this._encodingKey;
    }

    protected StreamCipherCompat getStreamCipher() {
        throw new UnsupportedOperationException();
    }

    protected BufferedBlockCipher getBlockCipher() {
        throw new UnsupportedOperationException();
    }

    protected ByteBuffer getTempBuffer() {
        if (this._tempBufH == null) {
            this._tempBufH = TempBufferHolder.newHolder(TempBufferHolder.Type.SOFT, true);
        }
        ByteBuffer tempBuf = this._tempBufH.getPageBuffer(this._channel);
        tempBuf.clear();
        return tempBuf;
    }

    protected void streamDecrypt(ByteBuffer buffer, int pageNumber) {
        StreamCipherCompat cipher = BaseCryptCodecHandler.decryptInit(this.getStreamCipher(), this.getCipherParams(pageNumber));
        byte[] array = buffer.array();
        cipher.processStreamBytes(array, 0, array.length, array, 0);
    }

    protected ByteBuffer streamEncrypt(ByteBuffer buffer, int pageNumber, int pageOffset) {
        StreamCipherCompat cipher = BaseCryptCodecHandler.encryptInit(this.getStreamCipher(), this.getCipherParams(pageNumber));
        int limit = buffer.limit();
        ByteBuffer encodeBuf = this.getTempBuffer();
        cipher.processStreamBytes(buffer.array(), 0, limit, encodeBuf.array(), 0);
        return encodeBuf;
    }

    protected void blockDecrypt(ByteBuffer inPage, ByteBuffer outPage, int pageNumber) {
        BufferedBlockCipher cipher = BaseCryptCodecHandler.decryptInit(this.getBlockCipher(), this.getCipherParams(pageNumber));
        try {
            byte[] inArray = inPage.array();
            int inLen = inArray.length;
            byte[] outArray = outPage.array();
            BaseCryptCodecHandler.processBytesFully(cipher, inArray, BaseCryptCodecHandler.fill(outArray, 0), inLen);
        }
        catch (InvalidCipherTextException e) {
            throw new IllegalStateException(e);
        }
    }

    protected ByteBuffer blockEncrypt(ByteBuffer buffer, int pageNumber) {
        BufferedBlockCipher cipher = BaseCryptCodecHandler.encryptInit(this.getBlockCipher(), this.getCipherParams(pageNumber));
        try {
            byte[] inArray = buffer.array();
            int inLen = buffer.limit();
            ByteBuffer encodeBuf = this.getTempBuffer();
            BaseCryptCodecHandler.processBytesFully(cipher, inArray, BaseCryptCodecHandler.fill(encodeBuf.array(), 0), inLen);
            return encodeBuf;
        }
        catch (InvalidCipherTextException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected static StreamCipherCompat decryptInit(StreamCipherCompat cipher, CipherParameters params) {
        cipher.init(false, params);
        return cipher;
    }

    protected static StreamCipherCompat encryptInit(StreamCipherCompat cipher, CipherParameters params) {
        cipher.init(true, params);
        return cipher;
    }

    protected static BufferedBlockCipher decryptInit(BufferedBlockCipher cipher, CipherParameters params) {
        cipher.init(false, params);
        return cipher;
    }

    protected static BufferedBlockCipher encryptInit(BufferedBlockCipher cipher, CipherParameters params) {
        cipher.init(true, params);
        return cipher;
    }

    protected static byte[] decryptBytes(StreamCipherCompat cipher, byte[] encBytes) {
        byte[] bytes = new byte[encBytes.length];
        cipher.processStreamBytes(encBytes, 0, encBytes.length, bytes, 0);
        return bytes;
    }

    protected byte[] blockDecryptBytes(byte[] keyBytes, byte[] iv, byte[] encBytes) {
        BufferedBlockCipher cipher = BaseCryptCodecHandler.decryptInit(this.getBlockCipher(), (CipherParameters)new ParametersWithIV(new KeyParameter(keyBytes), iv));
        return BaseCryptCodecHandler.decryptBytes(cipher, encBytes);
    }

    protected static byte[] decryptBytes(BufferedBlockCipher cipher, byte[] encBytes) {
        try {
            int inLen = encBytes.length;
            return BaseCryptCodecHandler.processBytesFully(cipher, encBytes, new byte[inLen], inLen);
        }
        catch (InvalidCipherTextException e) {
            throw new IllegalStateException(e);
        }
    }

    protected byte[] getEncodingKey(int pageNumber) {
        return BaseCryptCodecHandler.applyPageNumber(this.getEncodingKey(), 0, pageNumber);
    }

    protected static ByteBuffer readHeaderPage(PageChannel pageChannel) throws IOException {
        ByteBuffer buffer = pageChannel.createPageBuffer();
        pageChannel.readPage(buffer, 0);
        return buffer;
    }

    public static byte[] applyPageNumber(byte[] key, int offset, int pageNumber) {
        byte[] tmp = ByteUtil.copyOf(key, key.length);
        ByteBuffer bb = BaseCryptCodecHandler.wrap(tmp);
        bb.position(offset);
        bb.putInt(pageNumber);
        for (int i = offset; i < offset + 4; ++i) {
            int n = i;
            tmp[n] = (byte)(tmp[n] ^ key[i]);
        }
        return tmp;
    }

    public static byte[] hash(Digest digest, byte[] bytes) {
        return BaseCryptCodecHandler.hash(digest, bytes, null, 0);
    }

    public static byte[] hash(Digest digest, byte[] bytes1, byte[] bytes2) {
        return BaseCryptCodecHandler.hash(digest, bytes1, bytes2, 0);
    }

    public static byte[] hash(Digest digest, byte[] bytes, int resultLen) {
        return BaseCryptCodecHandler.hash(digest, bytes, null, resultLen);
    }

    public static byte[] hash(Digest digest, byte[] bytes1, byte[] bytes2, int resultLen) {
        digest.reset();
        digest.update(bytes1, 0, bytes1.length);
        if (bytes2 != null) {
            digest.update(bytes2, 0, bytes2.length);
        }
        byte[] digestBytes = new byte[digest.getDigestSize()];
        digest.doFinal(digestBytes, 0);
        if (resultLen > 0) {
            digestBytes = BaseCryptCodecHandler.fixToLength(digestBytes, resultLen);
        }
        return digestBytes;
    }

    public static byte[] fixToLength(byte[] bytes, int len) {
        return BaseCryptCodecHandler.fixToLength(bytes, len, 0);
    }

    public static byte[] fixToLength(byte[] bytes, int len, int padByte) {
        int byteLen = bytes.length;
        if (byteLen != len) {
            bytes = ByteUtil.copyOf(bytes, len);
            if (byteLen < len) {
                Arrays.fill(bytes, byteLen, len, (byte)padByte);
            }
        }
        return bytes;
    }

    public static ByteBuffer wrap(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(PageChannel.DEFAULT_BYTE_ORDER);
    }

    public static byte[] fill(byte[] bytes, int value) {
        Arrays.fill(bytes, (byte)value);
        return bytes;
    }

    protected static byte[] processBytesFully(BufferedBlockCipher cipher, byte[] inArray, byte[] outArray, int inLen) throws InvalidCipherTextException {
        int outLen = cipher.processBytes(inArray, 0, inLen, outArray, 0);
        cipher.doFinal(outArray, outLen);
        return outArray;
    }

    protected static boolean isBlankKey(byte[] key) {
        for (byte byteVal : key) {
            if (byteVal == 0) continue;
            return false;
        }
        return true;
    }

    protected abstract CipherParameters computeCipherParams(int var1);
}

