/*
 * Decompiled with CFR 0.152.
 */
package gma.gsa;

import gma.gsa.Segment;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AlignedBlock {
    List xAxisSegments = new LinkedList();
    List yAxisSegments = new LinkedList();

    public void clear() {
        this.xAxisSegments.clear();
        this.yAxisSegments.clear();
    }

    public AlignedBlock copy() {
        AlignedBlock alignedBlock = new AlignedBlock();
        LinkedList xSegBlock = new LinkedList(this.getSegments(true, true));
        LinkedList ySegBlock = new LinkedList(this.getSegments(false, true));
        alignedBlock.xAxisSegments = xSegBlock;
        alignedBlock.yAxisSegments = ySegBlock;
        return alignedBlock;
    }

    public void addSegment(Segment segment, boolean isXAxis) {
        if (isXAxis) {
            int index = this.xAxisSegments.indexOf(segment);
            if (index == -1) {
                for (int loopIndex = 0; loopIndex < this.xAxisSegments.size(); ++loopIndex) {
                    if (segment.compareTo(this.xAxisSegments.get(loopIndex)) != -1) continue;
                    this.xAxisSegments.add(loopIndex, segment);
                    break;
                }
                if (this.xAxisSegments.size() == 0 || segment.compareTo(this.xAxisSegments.get(this.xAxisSegments.size() - 1)) == 1) {
                    this.xAxisSegments.add(segment);
                }
            }
        } else {
            int index = this.yAxisSegments.indexOf(segment);
            if (index == -1) {
                for (int loopIndex = 0; loopIndex < this.yAxisSegments.size(); ++loopIndex) {
                    if (segment.compareTo(this.yAxisSegments.get(loopIndex)) != -1) continue;
                    this.yAxisSegments.add(loopIndex, segment);
                    break;
                }
                if (this.yAxisSegments.size() == 0 || segment.compareTo(this.yAxisSegments.get(this.yAxisSegments.size() - 1)) == 1) {
                    this.yAxisSegments.add(segment);
                }
            }
        }
    }

    public int getBalanceStatus() {
        if (this.xAxisSegments.size() == this.yAxisSegments.size()) {
            return 0;
        }
        if (this.xAxisSegments.size() < this.yAxisSegments.size()) {
            return -1;
        }
        return 1;
    }

    public boolean hasSegments(boolean isXAxis) {
        if (isXAxis) {
            return this.xAxisSegments.size() > 0;
        }
        return this.yAxisSegments.size() > 0;
    }

    public List getSegments(boolean isXAxis, boolean isClone) {
        if (isXAxis && !isClone) {
            return this.xAxisSegments;
        }
        if (!isXAxis && !isClone) {
            return this.yAxisSegments;
        }
        List sourceList = null;
        sourceList = isXAxis ? this.xAxisSegments : this.yAxisSegments;
        LinkedList clone = new LinkedList();
        Iterator iterator = sourceList.iterator();
        while (iterator.hasNext()) {
            clone.add(iterator.next());
        }
        return clone;
    }

    public double computeBalance(AlignedBlock blockToBalance, boolean isPreviousBlock, boolean isXAxis) {
        double alterBalanceScore;
        List upXSegments = null;
        List upYSegments = null;
        List alterUpXSegments = null;
        List alterUpYSegments = null;
        List downXSegments = null;
        List downYSegments = null;
        List alterDownXSegments = null;
        List alterDownYSegments = null;
        Segment balanceSegment = null;
        if (!isPreviousBlock) {
            upXSegments = this.xAxisSegments;
            upYSegments = this.yAxisSegments;
            downXSegments = blockToBalance.getSegments(true, false);
            downYSegments = blockToBalance.getSegments(false, false);
            if (isXAxis) {
                alterUpXSegments = this.getSegments(true, true);
                balanceSegment = (Segment)alterUpXSegments.get(0);
                alterUpXSegments.remove(0);
                alterDownXSegments = blockToBalance.getSegments(true, true);
                alterDownXSegments.add(balanceSegment);
                alterBalanceScore = this.computeBalanceUp(alterUpXSegments, upYSegments) + this.computeBalanceDown(alterDownXSegments, downYSegments);
            } else {
                alterUpYSegments = this.getSegments(false, true);
                balanceSegment = (Segment)alterUpYSegments.get(0);
                alterUpYSegments.remove(0);
                alterDownYSegments = blockToBalance.getSegments(false, true);
                alterDownYSegments.add(balanceSegment);
                alterBalanceScore = this.computeBalanceUp(upXSegments, alterUpYSegments) + this.computeBalanceDown(downXSegments, alterDownYSegments);
            }
        } else {
            downXSegments = this.xAxisSegments;
            downYSegments = this.yAxisSegments;
            upXSegments = blockToBalance.getSegments(true, false);
            upYSegments = blockToBalance.getSegments(false, false);
            if (isXAxis) {
                alterDownXSegments = this.getSegments(true, true);
                balanceSegment = (Segment)alterDownXSegments.get(alterDownXSegments.size() - 1);
                alterDownXSegments.remove(alterDownXSegments.size() - 1);
                alterUpXSegments = blockToBalance.getSegments(true, true);
                alterUpXSegments.add(0, balanceSegment);
                alterBalanceScore = this.computeBalanceUp(alterUpXSegments, upYSegments) + this.computeBalanceDown(alterDownXSegments, downYSegments);
            } else {
                alterDownYSegments = this.getSegments(false, true);
                balanceSegment = (Segment)alterDownYSegments.get(alterDownYSegments.size() - 1);
                alterDownYSegments.remove(alterDownYSegments.size() - 1);
                alterUpYSegments = blockToBalance.getSegments(false, true);
                alterUpYSegments.add(0, balanceSegment);
                alterBalanceScore = this.computeBalanceUp(upXSegments, alterUpYSegments) + this.computeBalanceDown(downXSegments, alterDownYSegments);
            }
        }
        double currentBalanceScore = this.computeBalanceUp(upXSegments, upYSegments) + this.computeBalanceDown(downXSegments, downYSegments);
        return (currentBalanceScore - alterBalanceScore) / (double)balanceSegment.getDistance();
    }

    private double computeBalanceUp(List upXSegments, List upYSegments) {
        double minDiff = 9.999999999E9;
        double sumXDistance = 0.0;
        for (int xSegmentIndex = 0; xSegmentIndex < upXSegments.size(); ++xSegmentIndex) {
            sumXDistance += (double)((Segment)upXSegments.get(xSegmentIndex)).getDistance();
            double sumYDistance = 0.0;
            for (int ySegmentIndex = 0; ySegmentIndex < upYSegments.size(); ++ySegmentIndex) {
                double diff = Math.abs(sumXDistance - (sumYDistance += (double)((Segment)upYSegments.get(ySegmentIndex)).getDistance()));
                if (!(minDiff > diff)) continue;
                minDiff = diff;
            }
        }
        return minDiff;
    }

    private double computeBalanceDown(List downXSegments, List downYSegments) {
        double minDiff = 9.999999999E9;
        double sumXDistance = 0.0;
        for (int xSegmentIndex = downXSegments.size() - 1; xSegmentIndex >= 0; --xSegmentIndex) {
            sumXDistance += (double)((Segment)downXSegments.get(xSegmentIndex)).getDistance();
            double sumYDistance = 0.0;
            for (int ySegmentIndex = downYSegments.size() - 1; ySegmentIndex >= 0; --ySegmentIndex) {
                double diff = Math.abs(sumXDistance - (sumYDistance += (double)((Segment)downYSegments.get(ySegmentIndex)).getDistance()));
                if (!(minDiff > diff)) continue;
                minDiff = diff;
            }
        }
        return minDiff;
    }

    public void merge(AlignedBlock alignedBlock) {
        Iterator xSegmentIter = alignedBlock.getSegments(true, false).iterator();
        while (xSegmentIter.hasNext()) {
            this.addSegment((Segment)xSegmentIter.next(), true);
        }
        Iterator ySegmentIter = alignedBlock.getSegments(false, false).iterator();
        while (ySegmentIter.hasNext()) {
            this.addSegment((Segment)ySegmentIter.next(), false);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.segmentListToString(this.xAxisSegments));
        stringBuffer.append(" <=> ");
        stringBuffer.append(this.segmentListToString(this.yAxisSegments));
        return stringBuffer.toString();
    }

    private String segmentListToString(List segments) {
        if (segments.size() == 0) {
            return "omitted";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean isFirst = true;
        Iterator segmentIterator = segments.iterator();
        while (segmentIterator.hasNext()) {
            if (!isFirst) {
                stringBuffer.append(",");
            } else {
                isFirst = false;
            }
            stringBuffer.append(segmentIterator.next().toString());
        }
        return stringBuffer.toString();
    }
}

