/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.analysis;

import at.ac.tuwien.dbai.pdfwrap.comparators.XComparator;
import at.ac.tuwien.dbai.pdfwrap.comparators.YComparator;
import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.LineSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.RectSegment;
import at.ac.tuwien.dbai.pdfwrap.utils.SegmentUtils;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.comparators.ReverseComparator;

public class RulingObjectProcessor {
    protected List<LineSegment> rulingLines = new ArrayList<LineSegment>();

    public RulingObjectProcessor() {
    }

    public RulingObjectProcessor(List<? extends GenericSegment> rulingObjects) {
        this.addRulingObjects(rulingObjects);
    }

    public void addRulingObjects(List<? extends GenericSegment> rulingObjects) {
        for (GenericSegment genericSegment : rulingObjects) {
            if (genericSegment instanceof LineSegment) {
                this.rulingLines.add((LineSegment)genericSegment);
                continue;
            }
            if (!(genericSegment instanceof RectSegment)) continue;
            this.rulingLines.addAll(((RectSegment)genericSegment).toLines());
        }
    }

    public void removeDuplicateLines() {
        List<LineSegment> theLines = this.getRulingLines();
        float tolerance = 6.0f;
        ArrayList<LineSegment> hRetVal = new ArrayList<LineSegment>();
        ArrayList<LineSegment> vRetVal = new ArrayList<LineSegment>();
        ArrayList<LineSegment> horizLines = new ArrayList<LineSegment>();
        ArrayList<LineSegment> vertLines = new ArrayList<LineSegment>();
        for (LineSegment thisLine : theLines) {
            if (thisLine.getDirection() == 1) {
                horizLines.add(thisLine);
                continue;
            }
            if (thisLine.getDirection() != 2) continue;
            vertLines.add(thisLine);
        }
        Collections.sort(horizLines, new XComparator());
        Collections.sort(vertLines, new ReverseComparator((Comparator)new YComparator()));
        for (LineSegment thisLine : horizLines) {
            boolean addedToExistingLine = false;
            int n = 0;
            while (n < hRetVal.size()) {
                LineSegment l = (LineSegment)hRetVal.get(n);
                if (Utils.within(thisLine.getYmid(), l.getYmid(), tolerance) && SegmentUtils.horizIntersect(l, thisLine.getX1() - 6.0f, thisLine.getX2() + 6.0f)) {
                    l.setX1(Utils.minimum(thisLine.getX1(), l.getX1()));
                    l.setX2(Utils.maximum(thisLine.getX2(), l.getX2()));
                    addedToExistingLine = true;
                }
                ++n;
            }
            if (addedToExistingLine) continue;
            hRetVal.add(thisLine);
        }
        for (LineSegment thisLine : vertLines) {
            boolean addedToExistingLine = false;
            int n = 0;
            while (n < vRetVal.size()) {
                LineSegment l = (LineSegment)vRetVal.get(n);
                if (Utils.within(thisLine.getXmid(), l.getXmid(), tolerance) && SegmentUtils.vertIntersect(l, thisLine.getY1() - 6.0f, thisLine.getY2() + 6.0f)) {
                    l.setY1(Utils.minimum(thisLine.getY1(), l.getY1()));
                    l.setY2(Utils.maximum(thisLine.getY2(), l.getY2()));
                    addedToExistingLine = true;
                }
                ++n;
            }
            if (addedToExistingLine) continue;
            vRetVal.add(thisLine);
        }
        ArrayList<LineSegment> retVal = new ArrayList<LineSegment>();
        retVal.addAll(hRetVal);
        retVal.addAll(vRetVal);
        this.setRulingLines(retVal);
    }

    public List<LineSegment> getRulingLines() {
        return this.rulingLines;
    }

    public void setRulingLines(List<LineSegment> rulingLines) {
        this.rulingLines = rulingLines;
    }
}

