# Check for non-standard modules used by this module.
use ExtUtils::MakeMaker;

$DISTNAME = "HTML-CalendarMonth";
$NAME = "HTML::CalendarMonth";

$| = 1;

print "Checking for Date::Calc..";
eval {
    require Date::Calc;
};
if ($@) {
    print " failed\n";
    print <<EOT;

$@
Date::Calc is only needed if you want to use week-of-year numbering,
or if you plan on manipulating dates that exceed the ability of
localtime() (Prior to Jan 1, 1970 or after 2038).
You can obtain this from CPAN/modules/by-module/Date/Date-Calc-x.x.tar.gz

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print <<EOT if $missing_modules;
The missing modules can be obtained from CPAN.  Visit
http://www.perl.com/CPAN/ to find a CPAN site near you.

EOT

# Time to make a makefile

use ExtUtils::MakeMaker;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
              DISTNAME     => $DISTNAME,
              NAME         => $NAME,
	      VERSION_FROM => 'lib/HTML/CalendarMonth.pm',
              PREREQ_PM    => {
			       HTML::ElementTable => 1.03,
			      },
	      dist         => {
			       COMPRESS => 'gzip -9f',
			       SUFFIX => 'gz',
			      },
	     );
