# This perl routine will take a prompt, a default response and a list of
# possible responses and deal with the user interface, ( and the user! ),
# by displaying the prompt, showing the default, and checking to be sure
# that the response is one of the legal choices.
# --Mark Henderson
#
# Additional "types" that could be added would be a phone type,
# a social security type, a generic numeric pattern type...

# The usage is the following:
# x = don't care, a = alpha-only, n = numeric-only, i = ignore case
# c = case sensitive, r = ranged by the low and high values
#
# $result = &prompt("x", "text prompt", "help prompt", "default" );
#
# $result = &prompt("a", "text prompt", "help prompt", "default" );
#
# $result = &prompt("n", "text prompt", "help prompt", "default" );
#
# $result = &prompt("i", "text prompt", "help prompt", "default",
#	                 "legal_options-ignore-case-list");
#
# $result = &prompt("c", "text prompt", "help prompt", "default",
#	                 "legal_options-case-sensitive-list");
#
# $result = &prompt("r", "text prompt", "help prompt", "default",
#			"low", "high");
#
# What, you might ask, is the difference between a "text prompt" and a
# "help prompt"?  Think about the case where the "legal_options" look 
# something like: "1-1000".  Now consider what happens when you tell someone
# that "0" is not between 1-1000 and that the possible choices are:  :)
# 1 2 3 4 5 .....
# This is what the "help prompt" is for.

# It will work off of unique parts of "legal_options".

sub im_prompt2 {
    local ($debug) = 0;		# debugging

    local($mopt, $prompt, $prompt_options, $default, @things);
    local($repl, @match, $tmp, $match_options, $case, $low, $high);

    # Figure out just what we are doing here
    ($mopt) = @_;
    print "mopt is: $mopt\n" if $debug;

    # check the size of the match option, it should just have one char.
    die "Illegal call in im_prompt2 prompter."
	if ( length($mopt) > 1 );

    WHAT: {			# What sort of checking are we doing
	$type = 0;
	$legal = 0;
	$range = 0;

	if ( $mopt =~ /x/ || $mopt =~ /a/ || $mopt =~ /n/ ) {
	    ($mopt, $prompt, $prompt_options, $default) = @_;
	    $type = 1;
	    last WHAT;
	}
	if ( $mopt =~ /c/ || $mopt =~ /i/ ) {
	    ($mopt, $prompt, $prompt_options, $default, @things) = @_;
	    $legal = 1;
	    last WHAT;
	}
	if ( $mopt =~ /r/ ) {
	    ($mopt, $prompt, $prompt_options, $default, $low, $high) = @_;
	    $range = 1;
	    last WHAT;
	}
     }				


    $ok = 0;
    while (1) {
        # print out the prompt string in all it's gore
	print "$prompt ";
	if ( $prompt_options ne '' ) {
	    print "($prompt_options) ";
	} 
        print "[default $default] " if $default ne '';

        $_ = scalar<STDIN>;
        chop;			# nuke the <CR>

        s/^\s*//;		# ignore leading white space
        s/\s*$//;		# ignore trailing white space

        $_ = $default if $_ eq '';

        if ($_ eq '') {
            print "Invalid option\n";
            next;
        }

        print "Reply: '$_'\n" if $debug;
        $repl = $_;

	# Now here is where things get real interesting
	
        HOW: {
	    if ( $type ) { &typeit; last HOW; }
	    if ( $legal ) { &legalit; last HOW; }
	    if ( $range ) { &rangeit; last HOW; }
	}
	if ( $ok ) { 
	    return $repl;
	} else {
	    if ( $prompt_options ne '' ) {
		print "Options are:\n$prompt_options\n";
	    } 
	}

    }

sub rangeit {
    # this routine makes sure that the reply is within a given range 

    if ( $low <= $repl && $repl <= $high ) { 
	$ok = 1;
    } else {
	print "Invalid range value.  ";
    }
}

sub legalit {
    # this routine checks to see if a repl is one of a set of "things"
    # it checks case based on c = case check, i = ignore case

    if ( $mopt eq "c" ) {
	@match = grep(/^$repl/, @things); # check w/case
    } else {
	@match = grep(/^$repl/i, @things); # check ignoring case
    }
    # this is to check for unique stings if they aren't at the beginning
    if ( @match == 0 ) {
        if ( $mopt eq "c" ) {
            @match = grep(/$repl/, @things); # check w/case
        } else {
            @match = grep(/$repl/i, @things); # check ignoring case
        }
    }
    print join(":", @match), "\n" if $debug;
    if (@match == 1) {
	$repl = $match[0];
	$ok = 1;
    } elsif (@match == 0) {
	print "Invalid legal match.  ";
    } else {
	foreach $tmp ( @match ) {
	    print "testing $tmp for $repl.\n" if ($debug);
	    $ok = 1 if ($tmp eq $repl);
	}
	if ( ! $ok ) {
	    print "Ambiguous reply.  ";
	}
    }
}

sub typeit {
    # this routine does checks based on the following:
    # x = no checks, a = alpha only, n = numeric only
    print "inside of typeit\n" if $debug;

    if ( $mopt eq "x" ) { $ok = 1; }

    if ( $mopt eq "a" ) {
	if ( $repl =~ /^[a-zA-Z]*$/ ) { 
	    $ok = 1; 
	} else {		
	    print "Invalid type value.  ";
	}
    }

    if ( $mopt eq "n" ) {
	if ( $repl =~/^[0-9]*$/ ) { 
	    $ok = 1; 
	} else {
	    print "Invalid numeric value.  ";
	}
    }
}



}

1;



