.\" @(#)xlock.1	1.3 90/10/28; Copyright (c) 1990 - Sun Microsystems, Inc.
.TH XLOCK 1 "28 Oct 1990" "OpenWindows"
.SH NAME
xlock \- Locks the local X display until a password is entered.

.IX xlock#(1) "" "\fLxlock\fP(1)"
.SH SYNOPSIS
.B xlock
[
.BI \-display " dsp"
]
[
.BI -/+remote
]
[
.BI -/+mono
]
[
.BI -/+nolock
]
[
.BI -/+allowroot
]
[
.BI -/+enablesaver
]
[
.BI -/+allowaccess
]
[
.BI -/+echokeys
]
[
.BI -/+v
]
[
.BI \-delay " usecs"
]
[
.BI \-batchcount " num"
]
[
.BI \-nice " level"
]
[
.BI \-timeout " seconds"
]
[
.BI \-saturation " value"
]
[
.BI \-font " fontname"
]
[
.BI \-bg " color"
]
[
.BI \-fg " color"
]
[
.BI \-mode " mode"
]
[
.BI \-name " textstring"
]
[
.BI \-password " textstring"
]
[
.BI \-info " textstring"
]
[
.BI \-validate " textstring"
]
[
.BI \-invalid " textstring"
]

.SH DESCRIPTION
.B xlock
locks the X server till the user enters their password at the keyboard.
While
.B xlock
is running,
all new server connections are refused.
The screen saver is disabled.
The mouse cursor is turned off.
The screen is blanked and a changing pattern is put on the screen.
If a key or a mouse button is pressed then the user is prompted for the
password of the user who started
.B xlock.

If the correct password is typed, then the screen is unlocked and the X
server is restored.  When typing the password Control-U and Control-H are
active as kill and erase respectively.  To return to the locked screen,
click in the small icon version of the changing pattern.

.SH OPTIONS
.TP 5
.B \-display " dsp"
The
.I display
option sets the X11 display to lock.
.B xlock
locks all available screens on a given server,
and restricts you to locking only a local server such as
.BI unix:0,
.BI localhost:0,
or
.BI :0
unless you set the
.B \-remote
option.
.TP 5
.B \-mode " modename"
As of this writing there are six display modes supported.
.TP 8
.B hop
Hop mode shows the "real plane fractals" from the September 1986 issue of
Scientific American.
.TP 8
.B life
Life mode shows Conway's game of life.
.TP 8
.B qix
Qix mode shows the spinning lines similar to the old video game
by the same name.
.TP 8
.B image
Image mode shows several sun logos randomly appearing on the screen.
.TP 8
.B swarm
Swarm mode shows a swarm of bees following a wasp.
.TP 8
.B blank
Blank mode shows nothing but a black screen.

.TP 5
.B \-delay " usecs"
The
.I delay
option sets the speed at which a mode will operate.  It simply sets the
number of microseconds to delay between batches of "hopalong pixels",
"qix lines", "life generations", "image blits", and "swarm motions".  In
blank mode, it is important to set this to some small number of seconds,
because the keyboard and mouse are only checked after each delay, so you
cannot set the delay too high, but a delay of zero would needlessly
consume cpu checking for mouse and keyboard input in a tight loop, since
blank mode has no work to do.
.TP 5
.B \-batchcount " num"
The
.I batchcount
option sets number of
.I things
to do per batch to
.I num .
In qix mode this refers to the number of lines rendered in the same color.
In hop mode this refers to the number of pixels rendered in the same color.
In image mode this refers to the number of sunlogos on screen at once.
In swarm mode this refers to the number of bees.
In life and blank mode it means nothing.
.TP 5
.B \-nice " nicelevel"
The
.I nice
option sets system nicelevel of the xlock process to
.I nicelevel .
.TP 5
.B \-timeout " seconds"
The
.I timeout
option sets the number of
.I seconds
before the password screen will time out.
.TP 5
.B \-saturation " value"
The
.I saturation
option sets saturation of the color ramp used to
.I value .
0 is grayscale and 1 is very rich color.  0.4 is a nice pastel.
.TP 5
.B \-font " fontname"
The
.I font
option sets the font to be used on the prompt screen.
.TP 5
.B \-fg " color"
The
.I fg
option sets the color of the text on the password screen to
.I color .
.TP 5
.B \-bg " color"
The
.I bg
option sets the color of the background on the password screen to
.I color .
.TP 5
.B \-name " textstring"
.I textstring
is shown in front of user name, defaults to "Name: ".
.TP 5
.B \-password " textstring"
.I textstring
is the password prompt string, defaults to "Password: ".
.TP 5
.B \-info " textstring"
.I textstring
is an informational message to tell the user what to do, defaults to
"Enter password to unlock; select icon to lock.".
.TP 5
.BI \-validate " textstring"
.I textstring
.BI \-validate " message shown while validating the password, defaults to
"Validating login..."
.TP 5
.BI \-invalid " textstring"
.I textstring
.BI \-invalid " message shown when password is invalid, defaults to
"Invalid login."

.TP 5
.B -/+remote
The
.I remote
option tells xlock to not stop you from locking remote X11 servers.  This
option should be used with care and is intended mainly to lock X11 terminals
which cannot run
.I xlock
locally.  If you lock someone else's workstation, they will have to know
.B your
password to unlock it.
.TP 5
.B -/+mono
The
.I mono
option causes xlock to display monochrome, (black and white) pixels rather
than the default colored ones on color displays
.TP 5
.B +/-nolock
The
.I nolock
option causes xlock to only draw the patterns and not lock the display.
A keypress or a mouse click will terminate the screen saver.
.TP 5
.B -/+allowroot
The
.I allowroot
option allows the root password to unlock the server as well as the user
who started xlock.
.TP 5
.B -/+enablesaver
By default xlock will disable the normal X server's screen saver since
it is in effect a replacement for it.  Since it is possible to set delay
parameters long enough to cause phosphor burn on some displays, this
option will turn back on the default screensaver which is very careful
to keep most of the screen black.
.TP 5
.B -/+allowaccess
This option is simply a hack for the paranoid, who don't want to disable the
access control list, but still want the local server to prompt for a password.
This way if xlock is killed -KILL, the access control list is not lost.
.TP 5
.B -/+echokeys
The
.I echokeys
option causes xlock to echo '?' characters for each key typed into the
password prompt.  Some consider this a security risk, so the default is
to not echo anything. 
.TP 5
.B \-v
Verbose mode, tells what options it is going to use.

.SH BUGS
"kill -KILL
.B xlock
" causes the server that was locked to be unusable, since all hosts
(including localhost) were removed from the access control list
to lock out new X clients, and since xlock couldn't catch SIGKILL,
it terminated before restoring the access control list.  This will
leave the X server in a state where
\fI"you can no longer connect to that server,
and this operation cannot be reversed unless you reset the server."\fP
		-From the X11R4 Xlib Documentation, Chapter 7.
.SH SEE ALSO
X(1), Xlib Documentation.
.SH AUTHOR
 Patrick J. Naughton	 (naughton@wind.eng.sun.com)
 MailStop 14-01
 Windows and Graphics Group
 Sun Microsystems, Inc.
 Mountain View, CA  94043
 415/336-1080
.SH COPYRIGHT
Copyright (c) 1988-90 by Patrick J. Naughton and Sun Microsystems, Inc.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation. 
