
#ifndef __ANSIPRSR_H
#define __ANSIPRSR_H

class TANSIParser {
protected:
	virtual int ConWriteString(char* pszString, int cbString) = 0;
	virtual void ConClearScreen() = 0;
	virtual void ConClearEOScreen() = 0;
	virtual void ConClearBOScreen() = 0;
	virtual void ConClearLine() = 0;
	virtual void ConClearEOLine() = 0;
	virtual void ConClearBOLine() = 0;
	virtual void ConSetCursorPosition(int x, int y) = 0;
	virtual void ConMoveCursorPosition(int x, int y) = 0;
	virtual void ConSetExtendedMode(int iFunction, int bEnable) = 0;
	virtual int NetWriteString(char* pszString, int cbString) = 0;

	virtual char* GetTerminalId();

	char* ParseIAC(char* pszBuffer, char* pszBufferEnd);
	char* ParseEscapeANSI(char* pszBuffer, char* pszBufferEnd);
	char* ParseEscape(char* pszBuffer, char* pszBufferEnd);
public:
	char* ParseBuffer(char* pszBuffer, char* pszBufferEnd);

};

#endif
