use Test::More;
use Mojo::DOM;

my $html = q|<html><head><script>...</script></head><body><p class="okay" id="allow" onclick="not-allow">Restrict <span class="not-okay">HTML</span></p></body></html>|;

my $spec = {
	script => 0, # remove all script tags
	'*' => { # apply to all tags
		'*' => 1, # allow all attributes by default
		'onclick' => 0 # disable onclick attributes
	},
	span => {
		class => 0 # disable class attributes on span's
	}
};

my $dom = Mojo::DOM->with_roles('+Restrict')->new($html, $spec);
is ("$dom", q|<html><head></head><body><p class="okay" id="allow">Restrict <span>HTML</span></p></body></html>|);

done_testing();
