/* -*- buffer-read-only: t -*-
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/ebcdic.pl.
 * Any changes made here will be lost!
 */


#ifndef H_EBCDIC_TABLES   /* Guard against nested #includes */
#define H_EBCDIC_TABLES   1

/* This file contains definitions for various tables used in EBCDIC handling.
 * More info is in utfebcdic.h */

#if 'A' == 193 /* EBCDIC 1047 */ \
     && '\\' == 224 && '[' == 173 && ']' == 189 && '{' == 192 && '}' == 208 \
     && '^' == 95 && '~' == 161 && '!' == 90 && '#' == 123 && '|' == 79 \
     && '$' == 91 && '@' == 124 && '`' == 121

/* Index is ASCII platform code point; value is EBCDIC 1047 equivalent */
EXTCONST U8 PL_a2e[] = {
   0,   1,   2,   3,  55,  45,  46,  47,  22,   5,  21,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  60,  61,  50,  38,  24,  25,  63,  39,  28,  29,  30,  31,
  64,  90, 127, 123,  91, 108,  80, 125,  77,  93,  92,  78, 107,  96,  75,  97,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122,  94,  76, 126, 110, 111,
 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214,
 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 173, 224, 189,  95, 109,
 121, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150,
 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 192,  79, 208, 161,   7,
  32,  33,  34,  35,  36,  37,   6,  23,  40,  41,  42,  43,  44,   9,  10,  27,
  48,  49,  26,  51,  52,  53,  54,   8,  56,  57,  58,  59,   4,  20,  62, 255,
  65, 170,  74, 177, 159, 178, 106, 181, 187, 180, 154, 138, 176, 202, 175, 188,
 144, 143, 234, 250, 190, 160, 182, 179, 157, 218, 155, 139, 183, 184, 185, 171,
 100, 101,  98, 102,  99, 103, 158, 104, 116, 113, 114, 115, 120, 117, 118, 119,
 172, 105, 237, 238, 235, 239, 236, 191, 128, 253, 254, 251, 252, 186, 174,  89,
  68,  69,  66,  70,  67,  71, 156,  72,  84,  81,  82,  83,  88,  85,  86,  87,
 140,  73, 205, 206, 203, 207, 204, 225, 112, 221, 222, 219, 220, 141, 142, 223
};

/* Index is EBCDIC 1047 code point; value is ASCII platform equivalent */
EXTCONST U8 PL_e2a[] = {
   0,   1,   2,   3, 156,   9, 134, 127, 151, 141, 142,  11,  12,  13,  14,  15,
  16,  17,  18,  19, 157,  10,   8, 135,  24,  25, 146, 143,  28,  29,  30,  31,
 128, 129, 130, 131, 132, 133,  23,  27, 136, 137, 138, 139, 140,   5,   6,   7,
 144, 145,  22, 147, 148, 149, 150,   4, 152, 153, 154, 155,  20,  21, 158,  26,
  32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 162,  46,  60,  40,  43, 124,
  38, 233, 234, 235, 232, 237, 238, 239, 236, 223,  33,  36,  42,  41,  59,  94,
  45,  47, 194, 196, 192, 193, 195, 197, 199, 209, 166,  44,  37,  95,  62,  63,
 248, 201, 202, 203, 200, 205, 206, 207, 204,  96,  58,  35,  64,  39,  61,  34,
 216,  97,  98,  99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
 176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
 181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208,  91, 222, 174,
 172, 163, 165, 183, 169, 167, 182, 188, 189, 190, 221, 168, 175,  93, 180, 215,
 123,  65,  66,  67,  68,  69,  70,  71,  72,  73, 173, 244, 246, 242, 243, 245,
 125,  74,  75,  76,  77,  78,  79,  80,  81,  82, 185, 251, 252, 249, 250, 255,
  92, 247,  83,  84,  85,  86,  87,  88,  89,  90, 178, 212, 214, 210, 211, 213,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57, 179, 219, 220, 217, 218, 159
};

/* (Confusingly named) Index is EBCDIC 1047 I8 byte; value is
 * EBCDIC 1047 UTF-EBCDIC equivalent */
EXTCONST U8 PL_utf2e[] = {
   0,   1,   2,   3,  55,  45,  46,  47,  22,   5,  21,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  60,  61,  50,  38,  24,  25,  63,  39,  28,  29,  30,  31,
  64,  90, 127, 123,  91, 108,  80, 125,  77,  93,  92,  78, 107,  96,  75,  97,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122,  94,  76, 126, 110, 111,
 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214,
 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 173, 224, 189,  95, 109,
 121, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150,
 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 192,  79, 208, 161,   7,
  32,  33,  34,  35,  36,  37,   6,  23,  40,  41,  42,  43,  44,   9,  10,  27,
  48,  49,  26,  51,  52,  53,  54,   8,  56,  57,  58,  59,   4,  20,  62, 255,
  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  81,  82,  83,  84,  85,  86,
  87,  88,  89,  98,  99, 100, 101, 102, 103, 104, 105, 106, 112, 113, 114, 115,
 116, 117, 118, 119, 120, 128, 138, 139, 140, 141, 142, 143, 144, 154, 155, 156,
 157, 158, 159, 160, 170, 171, 172, 174, 175, 176, 177, 178, 179, 180, 181, 182,
 183, 184, 185, 186, 187, 188, 190, 191, 202, 203, 204, 205, 206, 207, 218, 219,
 220, 221, 222, 223, 225, 234, 235, 236, 237, 238, 239, 250, 251, 252, 253, 254
};

/* (Confusingly named) Index is EBCDIC 1047 UTF-EBCDIC byte; value is
 * EBCDIC 1047 I8 equivalent */
EXTCONST U8 PL_e2utf[] = {
   0,   1,   2,   3, 156,   9, 134, 127, 151, 141, 142,  11,  12,  13,  14,  15,
  16,  17,  18,  19, 157,  10,   8, 135,  24,  25, 146, 143,  28,  29,  30,  31,
 128, 129, 130, 131, 132, 133,  23,  27, 136, 137, 138, 139, 140,   5,   6,   7,
 144, 145,  22, 147, 148, 149, 150,   4, 152, 153, 154, 155,  20,  21, 158,  26,
  32, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,  46,  60,  40,  43, 124,
  38, 170, 171, 172, 173, 174, 175, 176, 177, 178,  33,  36,  42,  41,  59,  94,
  45,  47, 179, 180, 181, 182, 183, 184, 185, 186, 187,  44,  37,  95,  62,  63,
 188, 189, 190, 191, 192, 193, 194, 195, 196,  96,  58,  35,  64,  39,  61,  34,
 197,  97,  98,  99, 100, 101, 102, 103, 104, 105, 198, 199, 200, 201, 202, 203,
 204, 106, 107, 108, 109, 110, 111, 112, 113, 114, 205, 206, 207, 208, 209, 210,
 211, 126, 115, 116, 117, 118, 119, 120, 121, 122, 212, 213, 214,  91, 215, 216,
 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229,  93, 230, 231,
 123,  65,  66,  67,  68,  69,  70,  71,  72,  73, 232, 233, 234, 235, 236, 237,
 125,  74,  75,  76,  77,  78,  79,  80,  81,  82, 238, 239, 240, 241, 242, 243,
  92, 244,  83,  84,  85,  86,  87,  88,  89,  90, 245, 246, 247, 248, 249, 250,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57, 251, 252, 253, 254, 255, 159
};

/* Index is EBCDIC 1047 UTF-EBCDIC byte; value is UTF8SKIP for start bytes;
 * 1 for continuation.  Adapted from the shadow flags table in tr16.  The
 * entries marked 9 in tr16 are continuation bytes and are marked as length 1
 * here so that we can recover. */
EXTCONST U8 PL_utf8skip[] = {
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   2,   2,   2,   2,   2,   1,   1,   1,   1,   1,   1,   1,
   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,
   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,
   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   1,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   3,   1,   3,   3,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   3,   3,   3,   3,   3,   3,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   3,   3,   4,   4,   4,   4,
   1,   4,   1,   1,   1,   1,   1,   1,   1,   1,   4,   4,   4,   5,   5,   5,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   5,   6,   6,   7,   7,   1
};

/* Index is EBCDIC 1047 code point; value is its lowercase equivalent */
EXTCONST U8 PL_latin1_lc[] = {
   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
  96,  97,  66,  67,  68,  69,  70,  71,  72,  73, 106, 107, 108, 109, 110, 111,
 112,  81,  82,  83,  84,  85,  86,  87,  88, 121, 122, 123, 124, 125, 126, 127,
 112, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 156, 159,
 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 140, 173, 142, 175,
 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 141, 187, 188, 189, 190, 191,
 192, 129, 130, 131, 132, 133, 134, 135, 136, 137, 202, 203, 204, 205, 206, 207,
 208, 145, 146, 147, 148, 149, 150, 151, 152, 153, 218, 219, 220, 221, 222, 223,
 224, 225, 162, 163, 164, 165, 166, 167, 168, 169, 234, 203, 204, 205, 206, 207,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 219, 220, 221, 222, 255
};

/* Index is EBCDIC 1047 code point; value is its uppercase equivalent.
 * The 'mod' in the name means that codepoints whose uppercase is above 255 or
 * longer than 1 character map to LATIN SMALL LETTER Y WITH DIARESIS */
EXTCONST U8 PL_mod_latin1_uc[] = {
   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
  64,  65,  98,  99, 100, 101, 102, 103, 104, 105,  74,  75,  76,  77,  78,  79,
  80, 113, 114, 115, 116, 117, 118, 119, 120, 223,  90,  91,  92,  93,  94,  95,
  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
 128, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
 128, 193, 194, 195, 196, 197, 198, 199, 200, 201, 138, 139, 172, 186, 174, 143,
 144, 209, 210, 211, 212, 213, 214, 215, 216, 217, 154, 155, 158, 157, 158, 159,
 223, 161, 226, 227, 228, 229, 230, 231, 232, 233, 170, 171, 172, 173, 174, 175,
 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 235, 236, 237, 238, 239,
 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 251, 252, 253, 254, 223,
 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255
};

/* Index is EBCDIC 1047 code point; For A-Z, value is a-z; for a-z, value
 * is A-Z; all other code points map to themselves */
EXTCONST U8 PL_fold[] = {
   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
 128, 193, 194, 195, 196, 197, 198, 199, 200, 201, 138, 139, 140, 141, 142, 143,
 144, 209, 210, 211, 212, 213, 214, 215, 216, 217, 154, 155, 156, 157, 158, 159,
 160, 161, 226, 227, 228, 229, 230, 231, 232, 233, 170, 171, 172, 173, 174, 175,
 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
 192, 129, 130, 131, 132, 133, 134, 135, 136, 137, 202, 203, 204, 205, 206, 207,
 208, 145, 146, 147, 148, 149, 150, 151, 152, 153, 218, 219, 220, 221, 222, 223,
 224, 225, 162, 163, 164, 165, 166, 167, 168, 169, 234, 235, 236, 237, 238, 239,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255
};

/* Index is EBCDIC 1047 code point; value is its other fold-pair equivalent
 * (A => a; a => A, etc) in the 0-255 range.  If no such equivalent, value is
 * the code point itself */
EXTCONST U8 PL_fold_latin1[] = {
   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
  64,  65,  98,  99, 100, 101, 102, 103, 104, 105,  74,  75,  76,  77,  78,  79,
  80, 113, 114, 115, 116, 117, 118, 119, 120,  89,  90,  91,  92,  93,  94,  95,
  96,  97,  66,  67,  68,  69,  70,  71,  72,  73, 106, 107, 108, 109, 110, 111,
 128,  81,  82,  83,  84,  85,  86,  87,  88, 121, 122, 123, 124, 125, 126, 127,
 112, 193, 194, 195, 196, 197, 198, 199, 200, 201, 138, 139, 172, 186, 174, 143,
 144, 209, 210, 211, 212, 213, 214, 215, 216, 217, 154, 155, 158, 157, 156, 159,
 160, 161, 226, 227, 228, 229, 230, 231, 232, 233, 170, 171, 140, 173, 142, 175,
 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 141, 187, 188, 189, 190, 191,
 192, 129, 130, 131, 132, 133, 134, 135, 136, 137, 202, 235, 236, 237, 238, 239,
 208, 145, 146, 147, 148, 149, 150, 151, 152, 153, 218, 251, 252, 253, 254, 223,
 224, 225, 162, 163, 164, 165, 166, 167, 168, 169, 234, 203, 204, 205, 206, 207,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 219, 220, 221, 222, 255
};

#endif	/* EBCDIC 1047 */

#if 'A' == 193 /* EBCDIC 037 */ \
     && '\\' == 224 && '[' == 186 && ']' == 187 && '{' == 192 && '}' == 208 \
     && '^' == 176 && '~' == 161 && '!' == 90 && '#' == 123 && '|' == 79 \
     && '$' == 91 && '@' == 124 && '`' == 121

/* Index is ASCII platform code point; value is EBCDIC 037 equivalent */
EXTCONST U8 PL_a2e[] = {
   0,   1,   2,   3,  55,  45,  46,  47,  22,   5,  37,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  60,  61,  50,  38,  24,  25,  63,  39,  28,  29,  30,  31,
  64,  90, 127, 123,  91, 108,  80, 125,  77,  93,  92,  78, 107,  96,  75,  97,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122,  94,  76, 126, 110, 111,
 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214,
 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 186, 224, 187, 176, 109,
 121, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150,
 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 192,  79, 208, 161,   7,
  32,  33,  34,  35,  36,  21,   6,  23,  40,  41,  42,  43,  44,   9,  10,  27,
  48,  49,  26,  51,  52,  53,  54,   8,  56,  57,  58,  59,   4,  20,  62, 255,
  65, 170,  74, 177, 159, 178, 106, 181, 189, 180, 154, 138,  95, 202, 175, 188,
 144, 143, 234, 250, 190, 160, 182, 179, 157, 218, 155, 139, 183, 184, 185, 171,
 100, 101,  98, 102,  99, 103, 158, 104, 116, 113, 114, 115, 120, 117, 118, 119,
 172, 105, 237, 238, 235, 239, 236, 191, 128, 253, 254, 251, 252, 173, 174,  89,
  68,  69,  66,  70,  67,  71, 156,  72,  84,  81,  82,  83,  88,  85,  86,  87,
 140,  73, 205, 206, 203, 207, 204, 225, 112, 221, 222, 219, 220, 141, 142, 223
};

/* Index is EBCDIC 037 code point; value is ASCII platform equivalent */
EXTCONST U8 PL_e2a[] = {
   0,   1,   2,   3, 156,   9, 134, 127, 151, 141, 142,  11,  12,  13,  14,  15,
  16,  17,  18,  19, 157, 133,   8, 135,  24,  25, 146, 143,  28,  29,  30,  31,
 128, 129, 130, 131, 132,  10,  23,  27, 136, 137, 138, 139, 140,   5,   6,   7,
 144, 145,  22, 147, 148, 149, 150,   4, 152, 153, 154, 155,  20,  21, 158,  26,
  32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 162,  46,  60,  40,  43, 124,
  38, 233, 234, 235, 232, 237, 238, 239, 236, 223,  33,  36,  42,  41,  59, 172,
  45,  47, 194, 196, 192, 193, 195, 197, 199, 209, 166,  44,  37,  95,  62,  63,
 248, 201, 202, 203, 200, 205, 206, 207, 204,  96,  58,  35,  64,  39,  61,  34,
 216,  97,  98,  99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
 176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
 181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
  94, 163, 165, 183, 169, 167, 182, 188, 189, 190,  91,  93, 175, 168, 180, 215,
 123,  65,  66,  67,  68,  69,  70,  71,  72,  73, 173, 244, 246, 242, 243, 245,
 125,  74,  75,  76,  77,  78,  79,  80,  81,  82, 185, 251, 252, 249, 250, 255,
  92, 247,  83,  84,  85,  86,  87,  88,  89,  90, 178, 212, 214, 210, 211, 213,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57, 179, 219, 220, 217, 218, 159
};

/* (Confusingly named) Index is EBCDIC 037 I8 byte; value is
 * EBCDIC 037 UTF-EBCDIC equivalent */
EXTCONST U8 PL_utf2e[] = {
   0,   1,   2,   3,  55,  45,  46,  47,  22,   5,  37,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  60,  61,  50,  38,  24,  25,  63,  39,  28,  29,  30,  31,
  64,  90, 127, 123,  91, 108,  80, 125,  77,  93,  92,  78, 107,  96,  75,  97,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122,  94,  76, 126, 110, 111,
 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214,
 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 186, 224, 187, 176, 109,
 121, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150,
 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 192,  79, 208, 161,   7,
  32,  33,  34,  35,  36,  21,   6,  23,  40,  41,  42,  43,  44,   9,  10,  27,
  48,  49,  26,  51,  52,  53,  54,   8,  56,  57,  58,  59,   4,  20,  62, 255,
  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  81,  82,  83,  84,  85,  86,
  87,  88,  89,  95,  98,  99, 100, 101, 102, 103, 104, 105, 106, 112, 113, 114,
 115, 116, 117, 118, 119, 120, 128, 138, 139, 140, 141, 142, 143, 144, 154, 155,
 156, 157, 158, 159, 160, 170, 171, 172, 173, 174, 175, 177, 178, 179, 180, 181,
 182, 183, 184, 185, 188, 189, 190, 191, 202, 203, 204, 205, 206, 207, 218, 219,
 220, 221, 222, 223, 225, 234, 235, 236, 237, 238, 239, 250, 251, 252, 253, 254
};

/* (Confusingly named) Index is EBCDIC 037 UTF-EBCDIC byte; value is
 * EBCDIC 037 I8 equivalent */
EXTCONST U8 PL_e2utf[] = {
   0,   1,   2,   3, 156,   9, 134, 127, 151, 141, 142,  11,  12,  13,  14,  15,
  16,  17,  18,  19, 157, 133,   8, 135,  24,  25, 146, 143,  28,  29,  30,  31,
 128, 129, 130, 131, 132,  10,  23,  27, 136, 137, 138, 139, 140,   5,   6,   7,
 144, 145,  22, 147, 148, 149, 150,   4, 152, 153, 154, 155,  20,  21, 158,  26,
  32, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,  46,  60,  40,  43, 124,
  38, 170, 171, 172, 173, 174, 175, 176, 177, 178,  33,  36,  42,  41,  59, 179,
  45,  47, 180, 181, 182, 183, 184, 185, 186, 187, 188,  44,  37,  95,  62,  63,
 189, 190, 191, 192, 193, 194, 195, 196, 197,  96,  58,  35,  64,  39,  61,  34,
 198,  97,  98,  99, 100, 101, 102, 103, 104, 105, 199, 200, 201, 202, 203, 204,
 205, 106, 107, 108, 109, 110, 111, 112, 113, 114, 206, 207, 208, 209, 210, 211,
 212, 126, 115, 116, 117, 118, 119, 120, 121, 122, 213, 214, 215, 216, 217, 218,
  94, 219, 220, 221, 222, 223, 224, 225, 226, 227,  91,  93, 228, 229, 230, 231,
 123,  65,  66,  67,  68,  69,  70,  71,  72,  73, 232, 233, 234, 235, 236, 237,
 125,  74,  75,  76,  77,  78,  79,  80,  81,  82, 238, 239, 240, 241, 242, 243,
  92, 244,  83,  84,  85,  86,  87,  88,  89,  90, 245, 246, 247, 248, 249, 250,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57, 251, 252, 253, 254, 255, 159
};

/* Index is EBCDIC 037 UTF-EBCDIC byte; value is UTF8SKIP for start bytes;
 * 1 for continuation.  Adapted from the shadow flags table in tr16.  The
 * entries marked 9 in tr16 are continuation bytes and are marked as length 1
 * here so that we can recover. */
EXTCONST U8 PL_utf8skip[] = {
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   2,   2,   2,   2,   2,   2,   1,   1,   1,   1,   1,   1,   1,
   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,
   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,
   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,
   1,   2,   2,   2,   2,   2,   3,   3,   3,   3,   1,   1,   3,   3,   3,   3,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   3,   3,   3,   3,   3,   3,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   3,   3,   4,   4,   4,   4,
   1,   4,   1,   1,   1,   1,   1,   1,   1,   1,   4,   4,   4,   5,   5,   5,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   5,   6,   6,   7,   7,   1
};

/* Index is EBCDIC 037 code point; value is its lowercase equivalent */
EXTCONST U8 PL_latin1_lc[] = {
   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
  96,  97,  66,  67,  68,  69,  70,  71,  72,  73, 106, 107, 108, 109, 110, 111,
 112,  81,  82,  83,  84,  85,  86,  87,  88, 121, 122, 123, 124, 125, 126, 127,
 112, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 156, 159,
 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 140, 141, 142, 175,
 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
 192, 129, 130, 131, 132, 133, 134, 135, 136, 137, 202, 203, 204, 205, 206, 207,
 208, 145, 146, 147, 148, 149, 150, 151, 152, 153, 218, 219, 220, 221, 222, 223,
 224, 225, 162, 163, 164, 165, 166, 167, 168, 169, 234, 203, 204, 205, 206, 207,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 219, 220, 221, 222, 255
};

/* Index is EBCDIC 037 code point; value is its uppercase equivalent.
 * The 'mod' in the name means that codepoints whose uppercase is above 255 or
 * longer than 1 character map to LATIN SMALL LETTER Y WITH DIARESIS */
EXTCONST U8 PL_mod_latin1_uc[] = {
   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
  64,  65,  98,  99, 100, 101, 102, 103, 104, 105,  74,  75,  76,  77,  78,  79,
  80, 113, 114, 115, 116, 117, 118, 119, 120, 223,  90,  91,  92,  93,  94,  95,
  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
 128, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
 128, 193, 194, 195, 196, 197, 198, 199, 200, 201, 138, 139, 172, 173, 174, 143,
 144, 209, 210, 211, 212, 213, 214, 215, 216, 217, 154, 155, 158, 157, 158, 159,
 223, 161, 226, 227, 228, 229, 230, 231, 232, 233, 170, 171, 172, 173, 174, 175,
 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 235, 236, 237, 238, 239,
 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 251, 252, 253, 254, 223,
 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255
};

/* Index is EBCDIC 037 code point; For A-Z, value is a-z; for a-z, value
 * is A-Z; all other code points map to themselves */
EXTCONST U8 PL_fold[] = {
   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
 128, 193, 194, 195, 196, 197, 198, 199, 200, 201, 138, 139, 140, 141, 142, 143,
 144, 209, 210, 211, 212, 213, 214, 215, 216, 217, 154, 155, 156, 157, 158, 159,
 160, 161, 226, 227, 228, 229, 230, 231, 232, 233, 170, 171, 172, 173, 174, 175,
 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
 192, 129, 130, 131, 132, 133, 134, 135, 136, 137, 202, 203, 204, 205, 206, 207,
 208, 145, 146, 147, 148, 149, 150, 151, 152, 153, 218, 219, 220, 221, 222, 223,
 224, 225, 162, 163, 164, 165, 166, 167, 168, 169, 234, 235, 236, 237, 238, 239,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255
};

/* Index is EBCDIC 037 code point; value is its other fold-pair equivalent
 * (A => a; a => A, etc) in the 0-255 range.  If no such equivalent, value is
 * the code point itself */
EXTCONST U8 PL_fold_latin1[] = {
   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
  64,  65,  98,  99, 100, 101, 102, 103, 104, 105,  74,  75,  76,  77,  78,  79,
  80, 113, 114, 115, 116, 117, 118, 119, 120,  89,  90,  91,  92,  93,  94,  95,
  96,  97,  66,  67,  68,  69,  70,  71,  72,  73, 106, 107, 108, 109, 110, 111,
 128,  81,  82,  83,  84,  85,  86,  87,  88, 121, 122, 123, 124, 125, 126, 127,
 112, 193, 194, 195, 196, 197, 198, 199, 200, 201, 138, 139, 172, 173, 174, 143,
 144, 209, 210, 211, 212, 213, 214, 215, 216, 217, 154, 155, 158, 157, 156, 159,
 160, 161, 226, 227, 228, 229, 230, 231, 232, 233, 170, 171, 140, 141, 142, 175,
 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
 192, 129, 130, 131, 132, 133, 134, 135, 136, 137, 202, 235, 236, 237, 238, 239,
 208, 145, 146, 147, 148, 149, 150, 151, 152, 153, 218, 251, 252, 253, 254, 223,
 224, 225, 162, 163, 164, 165, 166, 167, 168, 169, 234, 203, 204, 205, 206, 207,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 219, 220, 221, 222, 255
};

#endif	/* EBCDIC 037 */

#if 'A' == 193 /* EBCDIC POSIX-BC */ \
     && '\\' == 188 && '[' == 187 && ']' == 189 && '{' == 251 && '}' == 253 \
     && '^' == 106 && '~' == 255 && '!' == 90 && '#' == 123 && '|' == 79 \
     && '$' == 91 && '@' == 124 && '`' == 74

/* Index is ASCII platform code point; value is EBCDIC POSIX-BC equivalent */
EXTCONST U8 PL_a2e[] = {
   0,   1,   2,   3,  55,  45,  46,  47,  22,   5,  21,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  60,  61,  50,  38,  24,  25,  63,  39,  28,  29,  30,  31,
  64,  90, 127, 123,  91, 108,  80, 125,  77,  93,  92,  78, 107,  96,  75,  97,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122,  94,  76, 126, 110, 111,
 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214,
 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 187, 188, 189, 106, 109,
  74, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150,
 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 251,  79, 253, 255,   7,
  32,  33,  34,  35,  36,  37,   6,  23,  40,  41,  42,  43,  44,   9,  10,  27,
  48,  49,  26,  51,  52,  53,  54,   8,  56,  57,  58,  59,   4,  20,  62,  95,
  65, 170, 176, 177, 159, 178, 208, 181, 121, 180, 154, 138, 186, 202, 175, 161,
 144, 143, 234, 250, 190, 160, 182, 179, 157, 218, 155, 139, 183, 184, 185, 171,
 100, 101,  98, 102,  99, 103, 158, 104, 116, 113, 114, 115, 120, 117, 118, 119,
 172, 105, 237, 238, 235, 239, 236, 191, 128, 224, 254, 221, 252, 173, 174,  89,
  68,  69,  66,  70,  67,  71, 156,  72,  84,  81,  82,  83,  88,  85,  86,  87,
 140,  73, 205, 206, 203, 207, 204, 225, 112, 192, 222, 219, 220, 141, 142, 223
};

/* Index is EBCDIC POSIX-BC code point; value is ASCII platform equivalent */
EXTCONST U8 PL_e2a[] = {
   0,   1,   2,   3, 156,   9, 134, 127, 151, 141, 142,  11,  12,  13,  14,  15,
  16,  17,  18,  19, 157,  10,   8, 135,  24,  25, 146, 143,  28,  29,  30,  31,
 128, 129, 130, 131, 132, 133,  23,  27, 136, 137, 138, 139, 140,   5,   6,   7,
 144, 145,  22, 147, 148, 149, 150,   4, 152, 153, 154, 155,  20,  21, 158,  26,
  32, 160, 226, 228, 224, 225, 227, 229, 231, 241,  96,  46,  60,  40,  43, 124,
  38, 233, 234, 235, 232, 237, 238, 239, 236, 223,  33,  36,  42,  41,  59, 159,
  45,  47, 194, 196, 192, 193, 195, 197, 199, 209,  94,  44,  37,  95,  62,  63,
 248, 201, 202, 203, 200, 205, 206, 207, 204, 168,  58,  35,  64,  39,  61,  34,
 216,  97,  98,  99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
 176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
 181, 175, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
 162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 172,  91,  92,  93, 180, 215,
 249,  65,  66,  67,  68,  69,  70,  71,  72,  73, 173, 244, 246, 242, 243, 245,
 166,  74,  75,  76,  77,  78,  79,  80,  81,  82, 185, 251, 252, 219, 250, 255,
 217, 247,  83,  84,  85,  86,  87,  88,  89,  90, 178, 212, 214, 210, 211, 213,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57, 179, 123, 220, 125, 218, 126
};

/* (Confusingly named) Index is EBCDIC POSIX-BC I8 byte; value is
 * EBCDIC POSIX-BC UTF-EBCDIC equivalent */
EXTCONST U8 PL_utf2e[] = {
   0,   1,   2,   3,  55,  45,  46,  47,  22,   5,  21,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  60,  61,  50,  38,  24,  25,  63,  39,  28,  29,  30,  31,
  64,  90, 127, 123,  91, 108,  80, 125,  77,  93,  92,  78, 107,  96,  75,  97,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122,  94,  76, 126, 110, 111,
 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214,
 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 187, 188, 189, 106, 109,
  74, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150,
 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 251,  79, 253, 255,   7,
  32,  33,  34,  35,  36,  37,   6,  23,  40,  41,  42,  43,  44,   9,  10,  27,
  48,  49,  26,  51,  52,  53,  54,   8,  56,  57,  58,  59,   4,  20,  62,  95,
  65,  66,  67,  68,  69,  70,  71,  72,  73,  81,  82,  83,  84,  85,  86,  87,
  88,  89,  98,  99, 100, 101, 102, 103, 104, 105, 112, 113, 114, 115, 116, 117,
 118, 119, 120, 121, 128, 138, 139, 140, 141, 142, 143, 144, 154, 155, 156, 157,
 158, 159, 160, 161, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181,
 182, 183, 184, 185, 186, 190, 191, 192, 202, 203, 204, 205, 206, 207, 208, 218,
 219, 220, 221, 222, 223, 224, 225, 234, 235, 236, 237, 238, 239, 250, 252, 254
};

/* (Confusingly named) Index is EBCDIC POSIX-BC UTF-EBCDIC byte; value is
 * EBCDIC POSIX-BC I8 equivalent */
EXTCONST U8 PL_e2utf[] = {
   0,   1,   2,   3, 156,   9, 134, 127, 151, 141, 142,  11,  12,  13,  14,  15,
  16,  17,  18,  19, 157,  10,   8, 135,  24,  25, 146, 143,  28,  29,  30,  31,
 128, 129, 130, 131, 132, 133,  23,  27, 136, 137, 138, 139, 140,   5,   6,   7,
 144, 145,  22, 147, 148, 149, 150,   4, 152, 153, 154, 155,  20,  21, 158,  26,
  32, 160, 161, 162, 163, 164, 165, 166, 167, 168,  96,  46,  60,  40,  43, 124,
  38, 169, 170, 171, 172, 173, 174, 175, 176, 177,  33,  36,  42,  41,  59, 159,
  45,  47, 178, 179, 180, 181, 182, 183, 184, 185,  94,  44,  37,  95,  62,  63,
 186, 187, 188, 189, 190, 191, 192, 193, 194, 195,  58,  35,  64,  39,  61,  34,
 196,  97,  98,  99, 100, 101, 102, 103, 104, 105, 197, 198, 199, 200, 201, 202,
 203, 106, 107, 108, 109, 110, 111, 112, 113, 114, 204, 205, 206, 207, 208, 209,
 210, 211, 115, 116, 117, 118, 119, 120, 121, 122, 212, 213, 214, 215, 216, 217,
 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,  91,  92,  93, 229, 230,
 231,  65,  66,  67,  68,  69,  70,  71,  72,  73, 232, 233, 234, 235, 236, 237,
 238,  74,  75,  76,  77,  78,  79,  80,  81,  82, 239, 240, 241, 242, 243, 244,
 245, 246,  83,  84,  85,  86,  87,  88,  89,  90, 247, 248, 249, 250, 251, 252,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57, 253, 123, 254, 125, 255, 126
};

/* Index is EBCDIC POSIX-BC UTF-EBCDIC byte; value is UTF8SKIP for start bytes;
 * 1 for continuation.  Adapted from the shadow flags table in tr16.  The
 * entries marked 9 in tr16 are continuation bytes and are marked as length 1
 * here so that we can recover. */
EXTCONST U8 PL_utf8skip[] = {
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   1,   1,   1,   1,   1,   1,
   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,
   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,
   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   1,   1,   1,   3,   3,
   3,   1,   1,   1,   1,   1,   1,   1,   1,   1,   3,   3,   3,   3,   3,   3,
   3,   1,   1,   1,   1,   1,   1,   1,   1,   1,   3,   4,   4,   4,   4,   4,
   4,   4,   1,   1,   1,   1,   1,   1,   1,   1,   4,   5,   5,   5,   5,   6,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   6,   1,   7,   1,   7,   1
};

/* Index is EBCDIC POSIX-BC code point; value is its lowercase equivalent */
EXTCONST U8 PL_latin1_lc[] = {
   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
  96,  97,  66,  67,  68,  69,  70,  71,  72,  73, 106, 107, 108, 109, 110, 111,
 112,  81,  82,  83,  84,  85,  86,  87,  88, 121, 122, 123, 124, 125, 126, 127,
 112, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 156, 159,
 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 140, 141, 142, 175,
 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
 192, 129, 130, 131, 132, 133, 134, 135, 136, 137, 202, 203, 204, 205, 206, 207,
 208, 145, 146, 147, 148, 149, 150, 151, 152, 153, 218, 219, 220, 219, 222, 223,
 192, 225, 162, 163, 164, 165, 166, 167, 168, 169, 234, 203, 204, 205, 206, 207,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 220, 253, 222, 255
};

/* Index is EBCDIC POSIX-BC code point; value is its uppercase equivalent.
 * The 'mod' in the name means that codepoints whose uppercase is above 255 or
 * longer than 1 character map to LATIN SMALL LETTER Y WITH DIARESIS */
EXTCONST U8 PL_mod_latin1_uc[] = {
   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
  64,  65,  98,  99, 100, 101, 102, 103, 104, 105,  74,  75,  76,  77,  78,  79,
  80, 113, 114, 115, 116, 117, 118, 119, 120, 223,  90,  91,  92,  93,  94,  95,
  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
 128, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
 128, 193, 194, 195, 196, 197, 198, 199, 200, 201, 138, 139, 172, 173, 174, 143,
 144, 209, 210, 211, 212, 213, 214, 215, 216, 217, 154, 155, 158, 157, 158, 159,
 223, 161, 226, 227, 228, 229, 230, 231, 232, 233, 170, 171, 172, 173, 174, 175,
 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
 224, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 235, 236, 237, 238, 239,
 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 221, 252, 221, 254, 223,
 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255
};

/* Index is EBCDIC POSIX-BC code point; For A-Z, value is a-z; for a-z, value
 * is A-Z; all other code points map to themselves */
EXTCONST U8 PL_fold[] = {
   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
 128, 193, 194, 195, 196, 197, 198, 199, 200, 201, 138, 139, 140, 141, 142, 143,
 144, 209, 210, 211, 212, 213, 214, 215, 216, 217, 154, 155, 156, 157, 158, 159,
 160, 161, 226, 227, 228, 229, 230, 231, 232, 233, 170, 171, 172, 173, 174, 175,
 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
 192, 129, 130, 131, 132, 133, 134, 135, 136, 137, 202, 203, 204, 205, 206, 207,
 208, 145, 146, 147, 148, 149, 150, 151, 152, 153, 218, 219, 220, 221, 222, 223,
 224, 225, 162, 163, 164, 165, 166, 167, 168, 169, 234, 235, 236, 237, 238, 239,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255
};

/* Index is EBCDIC POSIX-BC code point; value is its other fold-pair equivalent
 * (A => a; a => A, etc) in the 0-255 range.  If no such equivalent, value is
 * the code point itself */
EXTCONST U8 PL_fold_latin1[] = {
   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
  64,  65,  98,  99, 100, 101, 102, 103, 104, 105,  74,  75,  76,  77,  78,  79,
  80, 113, 114, 115, 116, 117, 118, 119, 120,  89,  90,  91,  92,  93,  94,  95,
  96,  97,  66,  67,  68,  69,  70,  71,  72,  73, 106, 107, 108, 109, 110, 111,
 128,  81,  82,  83,  84,  85,  86,  87,  88, 121, 122, 123, 124, 125, 126, 127,
 112, 193, 194, 195, 196, 197, 198, 199, 200, 201, 138, 139, 172, 173, 174, 143,
 144, 209, 210, 211, 212, 213, 214, 215, 216, 217, 154, 155, 158, 157, 156, 159,
 160, 161, 226, 227, 228, 229, 230, 231, 232, 233, 170, 171, 140, 141, 142, 175,
 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
 224, 129, 130, 131, 132, 133, 134, 135, 136, 137, 202, 235, 236, 237, 238, 239,
 208, 145, 146, 147, 148, 149, 150, 151, 152, 153, 218, 221, 252, 219, 254, 223,
 192, 225, 162, 163, 164, 165, 166, 167, 168, 169, 234, 203, 204, 205, 206, 207,
 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 220, 253, 222, 255
};

#endif	/* EBCDIC POSIX-BC */

#endif /* H_EBCDIC_TABLES */

/* ex: set ro: */
