# Generated by default/object.tt
package Paws::AccessAnalyzer::StatusReason;
  use Moose;
  has Code => (is => 'ro', isa => 'Str', request_name => 'code', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::StatusReason

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::StatusReason object:

  $service_obj->Method(Att1 => { Code => $value, ..., Code => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::StatusReason object:

  $result = $service_obj->Method(...);
  $result->Att1->Code

=head1 DESCRIPTION

Provides more details about the current status of the analyzer. For
example, if the creation for the analyzer fails, a C<Failed> status is
returned. For an analyzer with organization as the type, this failure
can be due to an issue with creating the service-linked roles required
in the member accounts of the AWS organization.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Code => Str

The reason code for the current status of the analyzer.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

