# Generated by default/object.tt
package Paws::DevOpsGuru::ListInsightsStatusFilter;
  use Moose;
  has Any => (is => 'ro', isa => 'Paws::DevOpsGuru::ListInsightsAnyStatusFilter');
  has Closed => (is => 'ro', isa => 'Paws::DevOpsGuru::ListInsightsClosedStatusFilter');
  has Ongoing => (is => 'ro', isa => 'Paws::DevOpsGuru::ListInsightsOngoingStatusFilter');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::ListInsightsStatusFilter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::ListInsightsStatusFilter object:

  $service_obj->Method(Att1 => { Any => $value, ..., Ongoing => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::ListInsightsStatusFilter object:

  $result = $service_obj->Method(...);
  $result->Att1->Any

=head1 DESCRIPTION

A filter used by C<ListInsights> to specify which insights to return.

=head1 ATTRIBUTES


=head2 Any => L<Paws::DevOpsGuru::ListInsightsAnyStatusFilter>

A C<ListInsightsAnyStatusFilter> that specifies insights of any status
that are either C<REACTIVE> or C<PROACTIVE>.


=head2 Closed => L<Paws::DevOpsGuru::ListInsightsClosedStatusFilter>

A C<ListInsightsClosedStatusFilter> that specifies closed insights that
are either C<REACTIVE> or C<PROACTIVE>.


=head2 Ongoing => L<Paws::DevOpsGuru::ListInsightsOngoingStatusFilter>

A C<ListInsightsAnyStatusFilter> that specifies ongoing insights that
are either C<REACTIVE> or C<PROACTIVE>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

