/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessControlException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.memcached.AppendPrependCommandExecutor;
import org.couchbase.mock.memcached.ArithmeticCommandExecutor;
import org.couchbase.mock.memcached.BinaryProtocolHandler;
import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.ConfigCommandExecutor;
import org.couchbase.mock.memcached.DeleteCommandExecutor;
import org.couchbase.mock.memcached.EvictCommandExecutor;
import org.couchbase.mock.memcached.FlushCommandExecutor;
import org.couchbase.mock.memcached.GetCommandExecutor;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.NoopCommandExecutor;
import org.couchbase.mock.memcached.ObserveCommandExecutor;
import org.couchbase.mock.memcached.OutputContext;
import org.couchbase.mock.memcached.QuitCommandExecutor;
import org.couchbase.mock.memcached.SaslCommandExecutor;
import org.couchbase.mock.memcached.StatCommandExecutor;
import org.couchbase.mock.memcached.Storage;
import org.couchbase.mock.memcached.StoreCommandExecutor;
import org.couchbase.mock.memcached.UnknownCommandExecutor;
import org.couchbase.mock.memcached.UnlockCommandExecutor;
import org.couchbase.mock.memcached.VBucketInfo;
import org.couchbase.mock.memcached.VBucketStore;
import org.couchbase.mock.memcached.VerbosityCommandExecutor;
import org.couchbase.mock.memcached.VersionCommandExecutor;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryConfigResponse;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.CommandCode;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class MemcachedServer
implements Runnable,
BinaryProtocolHandler {
    private final Storage storage;
    private final long bootTime;
    private final String hostname;
    private final ServerSocketChannel server;
    private Selector selector;
    private final int port;
    private final CommandExecutor[] executors = new CommandExecutor[255];
    private final Bucket bucket;
    private boolean active = true;
    private int hiccupTime = 0;
    private int hiccupOffset = 0;
    private int truncateLimit = 0;
    private boolean cccpEnabled = false;
    private FailMaker failmaker = new FailMaker();

    public MemcachedServer(Bucket bucket, String hostname, int port, VBucketInfo[] vbi) throws IOException {
        this.bucket = bucket;
        this.storage = new Storage(vbi, this);
        UnknownCommandExecutor unknownHandler = new UnknownCommandExecutor();
        for (int ii = 0; ii < this.executors.length; ++ii) {
            this.executors[ii] = unknownHandler;
        }
        this.executors[CommandCode.QUIT.cc()] = new QuitCommandExecutor();
        this.executors[CommandCode.QUITQ.cc()] = new QuitCommandExecutor();
        this.executors[CommandCode.FLUSH.cc()] = new FlushCommandExecutor();
        this.executors[CommandCode.FLUSHQ.cc()] = new FlushCommandExecutor();
        this.executors[CommandCode.NOOP.cc()] = new NoopCommandExecutor();
        this.executors[CommandCode.VERSION.cc()] = new VersionCommandExecutor();
        this.executors[CommandCode.STAT.cc()] = new StatCommandExecutor();
        this.executors[CommandCode.VERBOSITY.cc()] = new VerbosityCommandExecutor();
        this.executors[CommandCode.ADD.cc()] = new StoreCommandExecutor();
        this.executors[CommandCode.ADDQ.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.APPEND.cc()] = new AppendPrependCommandExecutor();
        this.executors[CommandCode.APPENDQ.cc()] = new AppendPrependCommandExecutor();
        this.executors[CommandCode.PREPEND.cc()] = new AppendPrependCommandExecutor();
        this.executors[CommandCode.PREPENDQ.cc()] = new AppendPrependCommandExecutor();
        this.executors[CommandCode.SET.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.SETQ.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.REPLACE.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.REPLACEQ.cc()] = this.executors[CommandCode.ADD.cc()];
        this.executors[CommandCode.DELETE.cc()] = new DeleteCommandExecutor();
        this.executors[CommandCode.DELETEQ.cc()] = this.executors[CommandCode.DELETE.cc()];
        this.executors[CommandCode.GET.cc()] = new GetCommandExecutor();
        this.executors[CommandCode.GETQ.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GETK.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GETKQ.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GETL.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GET_REPLICA.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.TOUCH.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GAT.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.GATQ.cc()] = this.executors[CommandCode.GET.cc()];
        this.executors[CommandCode.UNL.cc()] = new UnlockCommandExecutor();
        this.executors[CommandCode.INCREMENT.cc()] = new ArithmeticCommandExecutor();
        this.executors[CommandCode.INCREMENTQ.cc()] = this.executors[CommandCode.INCREMENT.cc()];
        this.executors[CommandCode.DECREMENT.cc()] = this.executors[CommandCode.INCREMENT.cc()];
        this.executors[CommandCode.DECREMENTQ.cc()] = this.executors[CommandCode.INCREMENT.cc()];
        this.executors[CommandCode.SASL_LIST_MECHS.cc()] = new SaslCommandExecutor();
        this.executors[CommandCode.SASL_AUTH.cc()] = this.executors[CommandCode.SASL_LIST_MECHS.cc()];
        this.executors[CommandCode.SASL_STEP.cc()] = this.executors[CommandCode.SASL_LIST_MECHS.cc()];
        this.executors[CommandCode.OBSERVE.cc()] = new ObserveCommandExecutor();
        this.executors[CommandCode.EVICT.cc()] = new EvictCommandExecutor();
        this.executors[CommandCode.GET_CLUSTER_CONFIG.cc()] = new ConfigCommandExecutor();
        this.bootTime = System.currentTimeMillis() / 1000L;
        this.selector = Selector.open();
        this.server = ServerSocketChannel.open();
        this.server.configureBlocking(false);
        if (hostname != null && !hostname.equals("*")) {
            this.server.socket().bind(new InetSocketAddress(hostname, port));
            this.hostname = hostname;
        } else {
            this.server.socket().bind(new InetSocketAddress(port));
            InetAddress address = this.server.socket().getInetAddress();
            if (address.isAnyLocalAddress()) {
                String name;
                try {
                    name = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException ex) {
                    name = "localhost";
                }
                this.hostname = name;
            } else {
                this.hostname = address.getHostName();
            }
        }
        this.port = this.server.socket().getLocalPort();
        this.server.register(this.selector, 16);
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void updateFailMakerContext(ErrorCode code, int count) {
        this.failmaker.update(code, count);
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long now = System.currentTimeMillis() / 1000L;
        long uptime = now - this.bootTime;
        CouchbaseMock mock = this.bucket.getCluster();
        map.put("uptime", uptime);
        map.put("replication", 1);
        map.put("clusterMembership", "active");
        map.put("status", "healthy");
        map.put("hostname", this.hostname + ":" + (mock == null ? "0" : Integer.valueOf(mock.getHttpPort())));
        map.put("clusterCompatibility", 1);
        map.put("version", "9.9.9");
        StringBuilder sb = new StringBuilder(System.getProperty("os.arch"));
        sb.append("-");
        sb.append(System.getProperty("os.name"));
        sb.append("-");
        sb.append(System.getProperty("os.version"));
        map.put("os", sb.toString().replaceAll(" ", "_"));
        HashMap<String, Integer> ports = new HashMap<String, Integer>();
        ports.put("direct", this.port);
        ports.put("proxy", 0);
        map.put("ports", ports);
        return JSONObject.fromObject(map).toString();
    }

    public Map<String, String> getStats() {
        HashMap<String, String> stats = new HashMap<String, String>();
        stats.put("pid", Long.toString(Thread.currentThread().getId()));
        stats.put("time", Long.toString(new Date().getTime()));
        stats.put("version", "9.9.9");
        stats.put("uptime", "15554");
        stats.put("accepting_conns", "1");
        stats.put("auth_cmds", "0");
        stats.put("auth_errors", "0");
        stats.put("bucket_active_conns", "1");
        stats.put("bucket_conns", "3");
        stats.put("bytes_read", "1108621");
        stats.put("bytes_written", "205374436");
        stats.put("cas_badval", "0");
        stats.put("cas_hits", "0");
        stats.put("cas_misses", "0");
        stats.put("mem_used", "100000000000000000000");
        stats.put("curr_connections", "-1");
        return stats;
    }

    public String getSocketName() {
        return this.hostname + ":" + this.port;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostname() {
        return this.hostname;
    }

    private void writeResponse(SocketChannel channel, OutputContext ctx) throws IOException {
        while (ctx.hasRemaining()) {
            ByteBuffer[] bufs = ctx.getIov();
            long nw = channel.write(bufs);
            if (nw < 0L) {
                channel.close();
                throw new ClosedChannelException();
            }
            if (nw == 0L) {
                return;
            }
            ctx.updateBytesSent(nw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.selector.select();
                    if (!this.active) {
                        this.selector.selectedKeys().clear();
                    }
                }
                catch (IOException ex) {}
                continue;
                try {
                    Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                    while (iterator.hasNext()) {
                        SelectionKey key = iterator.next();
                        iterator.remove();
                        this.handleClient(key);
                    }
                }
                catch (IOException e) {
                    Logger.getLogger(MemcachedServer.class.getName()).log(Level.SEVERE, null, e);
                }
            }
        }
        finally {
            try {
                this.server.close();
                this.selector.close();
            }
            catch (IOException e) {
                Logger.getLogger(MemcachedServer.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    private void handleClientWrite(SocketChannel channel, OutputContext ctx) throws IOException {
        OutputContext effectiveCtx = ctx;
        if (this.truncateLimit > 0) {
            effectiveCtx = ctx.getSlice(this.truncateLimit);
        } else if (this.hiccupOffset > 0) {
            effectiveCtx = ctx.getSlice(this.hiccupOffset);
        }
        this.writeResponse(channel, effectiveCtx);
        if (this.hiccupOffset > 0) {
            try {
                Thread.sleep(this.hiccupTime);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.writeResponse(channel, ctx);
        }
    }

    private void handleClientRead(SocketChannel channel, MemcachedConnection client) throws IOException {
        if (channel.read(client.getInputBuffer()) == -1) {
            channel.close();
            throw new ClosedChannelException();
        }
        client.step();
    }

    private void handleNewClient() throws IOException {
        SocketChannel cc = this.server.accept();
        cc.configureBlocking(false);
        cc.socket().setTcpNoDelay(false);
        cc.socket().setSendBufferSize(0x100000);
        cc.socket().setReceiveBufferSize(0x100000);
        cc.register(this.selector, 1, new MemcachedConnection(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClient(SelectionKey key) throws IOException {
        SocketChannel channel;
        MemcachedConnection client;
        block15: {
            client = (MemcachedConnection)key.attachment();
            if (client == null) {
                this.handleNewClient();
                return;
            }
            channel = (SocketChannel)key.channel();
            try {
                OutputContext ctx;
                if (key.isReadable()) {
                    this.handleClientRead(channel, client);
                }
                if (!key.isWritable() || (ctx = client.borrowOutputContext()) == null) break block15;
                try {
                    this.handleClientWrite(channel, ctx);
                }
                finally {
                    client.returnOutputContext(ctx);
                }
            }
            catch (IOException ex) {
                try {
                    channel.close();
                }
                finally {
                    key.cancel();
                }
                try {
                    String message = ex.getMessage();
                    if (message == null) {
                        throw ex;
                    }
                    if (!message.contains("reset") && !message.contains("forcibly")) {
                        throw ex;
                    }
                }
                catch (ClosedChannelException exClosed) {
                    // empty catch block
                }
                return;
            }
        }
        int ioEvents = 1;
        if (client.hasOutput()) {
            ioEvents |= 4;
        }
        channel.register(this.selector, ioEvents, client);
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    private boolean authOk(BinaryCommand cmd, MemcachedConnection client) {
        if (client.isAuthenticated()) {
            return true;
        }
        switch (cmd.getComCode()) {
            case SASL_AUTH: 
            case SASL_LIST_MECHS: 
            case SASL_STEP: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void execute(BinaryCommand cmd, MemcachedConnection client) throws IOException {
        try {
            ErrorCode failcode = this.failmaker.getFailCode();
            if (failcode != ErrorCode.SUCCESS) {
                client.sendResponse(new BinaryResponse(cmd, failcode));
            } else if (this.authOk(cmd, client)) {
                this.executors[cmd.getComCode().cc()].execute(cmd, this, client);
            } else {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.AUTH_ERROR));
            }
        }
        catch (AccessControlException ex) {
            client.sendResponse(BinaryConfigResponse.createNotMyVbucket(cmd, this));
        }
    }

    BinaryProtocolHandler getProtocolHandler() {
        return this;
    }

    public void shutdown() {
        this.active = false;
    }

    public void startup() {
        this.active = true;
    }

    public void setHiccup(int milliSeconds, int offset) {
        if (milliSeconds < 0 || offset < 0) {
            throw new IllegalArgumentException("Time and offset must be >= 0");
        }
        this.hiccupTime = milliSeconds;
        this.hiccupOffset = offset;
    }

    public void setTruncateLimit(int limit) {
        this.truncateLimit = limit;
    }

    public void flushNode() {
        this.storage.flush();
    }

    public void flushAll() {
        this.flushNode();
        for (MemcachedServer other : this.bucket.getServers()) {
            if (other == this) continue;
            other.flushNode();
        }
    }

    public VBucketStore getCache(BinaryCommand cmd) {
        return this.storage.getCache(this, cmd.getVBucketId());
    }

    public static void main(String[] args) {
        try {
            VBucketInfo[] vbi = new VBucketInfo[1024];
            for (int ii = 0; ii < vbi.length; ++ii) {
                vbi[ii] = new VBucketInfo();
            }
            MemcachedServer server = new MemcachedServer(null, null, 11211, vbi);
            for (VBucketInfo aVbi : vbi) {
                aVbi.setOwner(server);
            }
            server.run();
        }
        catch (IOException e) {
            Logger.getLogger(MemcachedServer.class.getName()).log(Level.SEVERE, "Fatal error! failed to create socket: ", e);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isCccpEnabled() {
        return this.cccpEnabled && this.bucket.getType() != Bucket.BucketType.MEMCACHED;
    }

    public void setCccpEnabled(boolean enabled) {
        this.cccpEnabled = enabled;
    }

    public Bucket.BucketType getType() {
        return this.bucket.getType();
    }

    public class FailMaker {
        private ErrorCode code = ErrorCode.SUCCESS;
        private int remaining = 0;

        public void update(ErrorCode code, int count) {
            this.code = code;
            this.remaining = count;
        }

        public ErrorCode getFailCode() {
            if (this.remaining == 0) {
                return ErrorCode.SUCCESS;
            }
            if (this.remaining > 0) {
                --this.remaining;
            }
            return this.code;
        }
    }
}

