package JIRA::REST::Class::Issue::Status;
use base qw( JIRA::REST::Class::Abstract );
use strict;
use warnings;
use v5.10;

our $VERSION = '0.02';

# ABSTRACT: A helper class for C<JIRA::REST::Class> that represents the status of a JIRA issue as an object.

__PACKAGE__->mk_ro_accessors(qw/ category /);
__PACKAGE__->mk_data_ro_accessors(qw/ description iconUrl id name self /);
__PACKAGE__->mk_contextual_ro_accessors(qw/ transitions /);

sub init {
    my $self = shift;
    $self->SUPER::init(@_);

    $self->{category} = $self->make_object('statuscat', {
        data => $self->data->{statusCategory}
    });
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

JIRA::REST::Class::Issue::Status - A helper class for C<JIRA::REST::Class> that represents the status of a JIRA issue as an object.

=head1 VERSION

version 0.02

=head1 METHODS

=head2 B<description>

Returns the description of the status.

=head2 B<iconUrl>

Returns the URL of the icon the status.

=head2 B<id>

Returns the id of the status.

=head2 B<name>

Returns the name of the status.

=head2 B<self>

Returns the JIRA REST API URL of the status.

=head2 B<category>

Returns the category of the status as a C<JIRA::REST::Class::Issue::Status::Category> object.

=head1 AUTHOR

Packy Anderson <packy@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Packy Anderson.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
