# Generated by default/object.tt
package Paws::LexModels::SlotDefaultValueSpec;
  use Moose;
  has DefaultValueList => (is => 'ro', isa => 'ArrayRef[Paws::LexModels::SlotDefaultValue]', request_name => 'defaultValueList', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModels::SlotDefaultValueSpec

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModels::SlotDefaultValueSpec object:

  $service_obj->Method(Att1 => { DefaultValueList => $value, ..., DefaultValueList => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModels::SlotDefaultValueSpec object:

  $result = $service_obj->Method(...);
  $result->Att1->DefaultValueList

=head1 DESCRIPTION

Contains the default values for a slot. Default values are used when
Amazon Lex hasn't determined a value for a slot.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DefaultValueList => ArrayRef[L<Paws::LexModels::SlotDefaultValue>]

The default values for a slot. You can specify more than one default.
For example, you can specify a default value to use from a matching
context variable, a session attribute, or a fixed value.

The default value chosen is selected based on the order that you
specify them in the list. For example, if you specify a context
variable and a fixed value in that order, Amazon Lex uses the context
variable if it is available, else it uses the fixed value.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModels>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

