[//]: # ( README.ru.md Tue 23 Jul 2019 11:26:37 GMT )

# App::DistSync

**App::DistSync** — готовое решение для синхронизации двух и более веб‑ресурсов со статическими данными. Проект хорошо зарекомендовал себя при синхронизации сайтов, содержащих дистрибутивы программного обеспечения, библиотеки фото, видео, аудио и другие коллекции мультимедийного контента.

## ВОЗМОЖНОСТИ

- Репликация каталогов и файлов между ресурсами
- Простейший способ добавления файлов — обычное копирование в каталог ресурса
- Отсутствие необходимости сложного конфигурирования: работа программы настраивается
  с помощью опций командной утилиты и редактированием дескрипторных файлов
- Возможность динамического добавления новых ресурсов (зеркал)
- Установка проекта через `RPM`, `APT`, `CPAN` или вручную через `make install`

## ЗАВИСИМОСТИ

Перед установкой убедитесь, что в системе, где будет работать App::DistSync, установлены следующие пакеты:

- GCC актуальной версии
- Perl v5.20 или выше (рекомендуется v5.20+)
- libwww (perl-libwww-perl / p5-libwww / libwww-perl / perl-libwww / LWP)
- libnet
- веб‑сервер: Apache2, nginx, lighttpd и т. д.

## УСТАНОВКА

App::DistSync можно установить двумя способами: автоматически или вручную.

### Автоматическая установка

Для систем на базе **RHEL**:
```bash
sudo dnf install perl-libwww-perl
```

Для систем на базе **Debian**:
```bash
sudo apt install libwww-perl
```

Через **CPAN**:
```bash
cpan install App::DistSync
```

Для **ActivePerl** (Windows):
```bash
ppm install App-DistSync
```

### Ручная установка

1. Скачайте дистрибутив с [CPAN](https://metacpan.org/pod/App::DistSync) или официальный релиз с [SourceForge](https://sourceforge.net/projects/app-distsync/).
2. Распакуйте архив и перейдите в каталог проекта.
3. Выполните:

```bash
perl Makefile.PL
make
make test
sudo make install
```

или с использованием `cpanminus`:

```bash
cpanm App::DistSync
```

В процессе установки система предложит установить недостающие модули.

## ИНИЦИАЛИЗАЦИЯ

Перед началом работы необходимо проинициализировать каталог, в котором будет размещаться зеркало ресурса. Процесс инициализации создаст простую структуру каталога и добавит несколько системных файлов. О них — в следующем разделе.

Для инициализации выполните:

```bash
distsync -D /var/www/foo.localhost init
```

Опция `-D` указывает каталог ресурса, в котором будет создана структура служебных файлов.

После инициализации настройте каталог для доступа через веб. Например, конфигурация для Apache2:

```apache
<VirtualHost *:80>
    ServerName foo.localhost
    DocumentRoot /var/www/foo.localhost
    <Directory /var/www/foo.localhost>
        DirectoryIndex index.html
        Options +Indexes +FollowSymLinks -Includes -MultiViews
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

> Обратите внимание на отключённую опцию `-Includes`. Её использование нарушает работу ресурса, так как App::DistSync требуется корректный заголовок `Last-Modified` для каждого файла. Также следует отключить автоматические фильтры и пост‑процессоры, искажающие ответ сервера.

После запуска веб‑сервера ресурс готов к работе. Первым делом добавьте в список зеркал (`MIRRORS`) URL текущего ресурса, например:
```
http://foo.localhost
```

Если ресурс размещается не в корне сайта, а в подкаталоге (например, `/dist`), инициализируйте структуру именно там:

```bash
mkdir -p /var/www/foo.localhost/dist
distsync -D /var/www/foo.localhost/dist init
```

И укажите зеркалам именно этот URL:
```
http://foo.localhost/dist
```

## СТРУКТУРА КАТАЛОГА РЕСУРСА

Каталог ресурса — это корневой каталог зеркала, содержащий структуру файлов ресурса. На одном веб‑сервере может располагаться несколько ресурсов с разными URL. В каталоге ресурса размещаются дескрипторные файлы, управляющие процессом синхронизации.

Важно: некоторые файлы **не подлежат ручному редактированию** — они отмечены ниже.

### META

*НЕРЕДАКТИРУЕМЫЙ* YAML‑файл, содержащий информацию о ресурсе и дате последней синхронизации. Содержит данные, которые должны быть доступны другим зеркалам.

### MANIFEST

*НЕРЕДАКТИРУЕМЫЙ* файл, создаваемый автоматически при каждом запуске. Он отражает текущую структуру ресурса. После синхронизации пересоздаётся, а в файле `META` обновляется поле `mtime`.

Формат:
```
DIRNAME/FILENAME   MTIME   SIZE   MTIME_AS_STRING
```

Все пути — относительные, разделитель — «/», независимо от ОС.

### MANIFEST.SKIP

Редактируемый файл, содержащий список системных и игнорируемых файлов, которые не должны попадать в `MANIFEST`. Поддерживает регулярные выражения в YAML‑формате.

Игнорируются также файлы:
```
META
MANIFEST
MANIFEST.DEL
MANIFEST.SKIP
MANIFEST.LOCK
README
```

Формат:
```
DIRNAME/FILENAME   COMMENT
```

### MANIFEST.DEL

Редактируемый файл со списком файлов, которые должны быть удалены в указанный момент (`DTIME`). `DTIME` — смещение относительно времени изменения самого файла. По умолчанию: `+3d`.

Файл **не синхронизируется**, но скачивается удалёнными ресурсами, которые удаляют указанные файлы у себя. После удаления файл очищается.

Формат:
```
DIRNAME/FILENAME   DTIME
```

### MIRRORS

Редактируемый файл со списком URL зеркал. URL текущего ресурса должен присутствовать обязательно.

Формат:
```
URL   COMMENT
```

### MANIFEST.LOCK

*НЕРЕДАКТИРУЕМЫЙ* файл, содержащий PID процесса, начавшего синхронизацию. Предотвращает одновременный запуск нескольких процессов `distsync`.

### MANIFEST.TEMP

*НЕРЕДАКТИРУЕМЫЙ* временный файл для хранения загруженных данных. Может сохраняться между запусками.

### README

Опциональный файл с описанием ресурса. Не синхронизируется. Для синхронизации используйте `README.md`.

## НАЧАЛО РАБОТЫ

После инициализации отредактируйте файл `MIRRORS`, добавив адрес нового зеркала. Затем передайте обновлённый `MIRRORS` на существующий сервер, чтобы другие зеркала смогли узнать о новом.

Первая синхронизация выполняется командой:
```bash
distsync -D /var/www/foo.localhost sync -d
```

Опция `-d` включает вывод процесса на экран, `-dv` — расширенную диагностику.

### Важные опции

`-D DATADIR` — путь к локальному каталогу ресурса, куда будут помещаться файлы.

Справка:
```bash
distsync --help
man distsync
```

## ПРОМЫШЛЕННОЕ ИСПОЛЬЗОВАНИЕ

После настройки зеркал ресурс можно включать в автоматический режим. Наиболее распространённый способ — cron.

Пример задания:
```cron
37 * * * * /usr/bin/distsync -D /var/www/foo.localhost >/var/log/distsync.log 2>&1
```

Все ошибки логируются в `/var/log/distsync.log`.

### Добавление файлов
Просто скопируйте файл в каталог ресурса — он автоматически попадёт в синхронизацию.

### Удаление файлов
Добавьте файл в `MANIFEST.DEL`. После удаления можно удалить его физически.

### Обновление файлов
Замените файл новым — синхронизация выполнится автоматически.

⚠ **Запрещено переименовывать и перемещать файлы и папки.**
При следующей синхронизации отсутствующие файлы будут пересозданы, что приведёт к рассинхронизации и дублированию.

