# Generated by default/object.tt
package Paws::DS::RegionsInfo;
  use Moose;
  has AdditionalRegions => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has PrimaryRegion => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DS::RegionsInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DS::RegionsInfo object:

  $service_obj->Method(Att1 => { AdditionalRegions => $value, ..., PrimaryRegion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DS::RegionsInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->AdditionalRegions

=head1 DESCRIPTION

Provides information about the Regions that are configured for
multi-Region replication.

=head1 ATTRIBUTES


=head2 AdditionalRegions => ArrayRef[Str|Undef]

Lists the Regions where the directory has been replicated, excluding
the primary Region.


=head2 PrimaryRegion => Str

The Region where the AWS Managed Microsoft AD directory was originally
created.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

