# Generated by default/object.tt
package Paws::SSMIncidents::RelatedItemsUpdate;
  use Moose;
  has ItemToAdd => (is => 'ro', isa => 'Paws::SSMIncidents::RelatedItem', request_name => 'itemToAdd', traits => ['NameInRequest']);
  has ItemToRemove => (is => 'ro', isa => 'Paws::SSMIncidents::ItemIdentifier', request_name => 'itemToRemove', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::RelatedItemsUpdate

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::RelatedItemsUpdate object:

  $service_obj->Method(Att1 => { ItemToAdd => $value, ..., ItemToRemove => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::RelatedItemsUpdate object:

  $result = $service_obj->Method(...);
  $result->Att1->ItemToAdd

=head1 DESCRIPTION

Details about the related item you're adding.

=head1 ATTRIBUTES


=head2 ItemToAdd => L<Paws::SSMIncidents::RelatedItem>

Details about the related item you're adding.


=head2 ItemToRemove => L<Paws::SSMIncidents::ItemIdentifier>

Details about the related item you're deleting.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

