# Generated by default/object.tt
package Paws::WAFV2::LabelMatchStatement;
  use Moose;
  has Key => (is => 'ro', isa => 'Str', required => 1);
  has Scope => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::LabelMatchStatement

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::LabelMatchStatement object:

  $service_obj->Method(Att1 => { Key => $value, ..., Scope => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::LabelMatchStatement object:

  $result = $service_obj->Method(...);
  $result->Att1->Key

=head1 DESCRIPTION

A rule statement that defines a string match search against labels that
have been added to the web request by rules that have already run in
the web ACL.

The label match statement provides the label or namespace string to
search for. The label string can represent a part or all of the fully
qualified label name that had been added to the web request. Fully
qualified labels have a prefix, optional namespaces, and label name.
The prefix identifies the rule group or web ACL context of the rule
that added the label. If you do not provide the fully qualified name in
your label match string, WAF performs the search for labels that were
added in the same context as the label match statement.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Key => Str

The string to match against. The setting you provide for this depends
on the match statement's C<Scope> setting:

=over

=item *

If the C<Scope> indicates C<LABEL>, then this specification must
include the name and can include any number of preceding namespace
specifications and prefix up to providing the fully qualified label
name.

=item *

If the C<Scope> indicates C<NAMESPACE>, then this specification can
include any number of contiguous namespace strings, and can include the
entire label namespace prefix from the rule group or web ACL where the
label originates.

=back

Labels are case sensitive and components of a label must be separated
by colon, for example C<NS1:NS2:name>.


=head2 B<REQUIRED> Scope => Str

Specify whether you want to match using the label name or just the
namespace.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

