package WWW::Hetzner::Robot::CLI::Cmd::Key;
our $VERSION = '0.001';
our $AUTHORITY = 'cpan:GETTY';

# ABSTRACT: Robot SSH key commands

use Moo;
use MooX::Cmd;
use MooX::Options usage_string => 'USAGE: hrobot.pl key [options]';


sub execute {
    my ($self, $args, $chain) = @_;
    my $root = $chain->[0];
    my $robot = $root->robot;

    # Default: list keys
    my $keys = $robot->keys->list;

    if ($root->output eq 'json') {
        require JSON::MaybeXS;
        print JSON::MaybeXS::encode_json([map { +{
            name        => $_->name,
            fingerprint => $_->fingerprint,
            type        => $_->type,
            size        => $_->size,
        } } @$keys]);
        print "\n";
    } else {
        printf "%-20s %-50s %-10s %s\n", 'NAME', 'FINGERPRINT', 'TYPE', 'SIZE';
        for my $k (@$keys) {
            printf "%-20s %-50s %-10s %s\n",
                $k->name // '',
                $k->fingerprint // '',
                $k->type // '',
                $k->size // '';
        }
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WWW::Hetzner::Robot::CLI::Cmd::Key - Robot SSH key commands

=head1 VERSION

version 0.001

=head1 SYNOPSIS

    hrobot.pl key
    hrobot.pl key -o json

=head1 DESCRIPTION

Lists all SSH keys stored in your Hetzner Robot account.
Shows name, fingerprint, type, and size for each key.

=head1 NAME

hrobot.pl key - List SSH keys

=for :stopwords cpan testmatrix url bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<https://github.com/Getty/p5-www-hetzner>

  git clone https://github.com/Getty/p5-www-hetzner.git

=head1 AUTHOR

Torsten Raudssus <torsten@raudssus.de>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2026 by Torsten Raudssus.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
