# Generated by default/object.tt
package Paws::IoTEvents::NotificationAction;
  use Moose;
  has Action => (is => 'ro', isa => 'Paws::IoTEvents::NotificationTargetActions', request_name => 'action', traits => ['NameInRequest'], required => 1);
  has EmailConfigurations => (is => 'ro', isa => 'ArrayRef[Paws::IoTEvents::EmailConfiguration]', request_name => 'emailConfigurations', traits => ['NameInRequest']);
  has SmsConfigurations => (is => 'ro', isa => 'ArrayRef[Paws::IoTEvents::SMSConfiguration]', request_name => 'smsConfigurations', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::NotificationAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::NotificationAction object:

  $service_obj->Method(Att1 => { Action => $value, ..., SmsConfigurations => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::NotificationAction object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

Contains the notification settings of an alarm model. The settings
apply to all alarms that were created based on this alarm model.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Action => L<Paws::IoTEvents::NotificationTargetActions>

Specifies an AWS Lambda function to manage alarm notifications. You can
create one or use the AWS Lambda function provided by AWS IoT Events
(https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html).


=head2 EmailConfigurations => ArrayRef[L<Paws::IoTEvents::EmailConfiguration>]

Contains the configuration information of email notifications.


=head2 SmsConfigurations => ArrayRef[L<Paws::IoTEvents::SMSConfiguration>]

Contains the configuration information of SMS notifications.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

