# Generated by default/object.tt
package Paws::Chime::ChannelMessage;
  use Moose;
  has ChannelArn => (is => 'ro', isa => 'Str');
  has Content => (is => 'ro', isa => 'Str');
  has CreatedTimestamp => (is => 'ro', isa => 'Str');
  has LastEditedTimestamp => (is => 'ro', isa => 'Str');
  has LastUpdatedTimestamp => (is => 'ro', isa => 'Str');
  has MessageId => (is => 'ro', isa => 'Str');
  has Metadata => (is => 'ro', isa => 'Str');
  has Persistence => (is => 'ro', isa => 'Str');
  has Redacted => (is => 'ro', isa => 'Bool');
  has Sender => (is => 'ro', isa => 'Paws::Chime::Identity');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::ChannelMessage

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::ChannelMessage object:

  $service_obj->Method(Att1 => { ChannelArn => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::ChannelMessage object:

  $result = $service_obj->Method(...);
  $result->Att1->ChannelArn

=head1 DESCRIPTION

The details of a message in a channel.

=head1 ATTRIBUTES


=head2 ChannelArn => Str

The ARN of the channel.


=head2 Content => Str

The message content.


=head2 CreatedTimestamp => Str

The time at which the message was created.


=head2 LastEditedTimestamp => Str

The time at which a message was edited.


=head2 LastUpdatedTimestamp => Str

The time at which a message was updated.


=head2 MessageId => Str

The ID of a message.


=head2 Metadata => Str

The message metadata.


=head2 Persistence => Str

The persistence setting for a channel message.


=head2 Redacted => Bool

Hides the content of a message.


=head2 Sender => L<Paws::Chime::Identity>

The message sender.


=head2 Type => Str

The message type.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

