/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.attachment.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.poi.ooxml.extractor.ExtractorFactory;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.DigestingParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.html.BoilerpipeContentHandler;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.parser.ocr.TesseractOCRConfig;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ExpandedTitleContentHandler;
import org.apache.tika.sax.RichTextContentHandler;
import org.apache.tika.server.InputStreamFactory;
import org.apache.tika.server.ServerStatus;
import org.apache.tika.server.TikaServerParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Path(value="/tika")
public class TikaResource {
    private static Pattern ALLOWABLE_HEADER_CHARS = Pattern.compile("(?i)^[-/_+\\.A-Z0-9 ]+$");
    public static final String GREETING = "This is Tika Server (" + new Tika().toString() + "). Please PUT\n";
    public static final String X_TIKA_OCR_HEADER_PREFIX = "X-Tika-OCR";
    public static final String X_TIKA_PDF_HEADER_PREFIX = "X-Tika-PDF";
    private static final Logger LOG = LoggerFactory.getLogger(TikaResource.class);
    private static TikaConfig tikaConfig;
    private static DigestingParser.Digester digester;
    private static InputStreamFactory inputStreamFactory;
    private static ServerStatus SERVER_STATUS;

    public static void init(TikaConfig config, DigestingParser.Digester digestr, InputStreamFactory iSF, ServerStatus serverStatus) {
        tikaConfig = config;
        digester = digestr;
        inputStreamFactory = iSF;
        SERVER_STATUS = serverStatus;
    }

    public static Parser createParser() {
        final AutoDetectParser parser = new AutoDetectParser(tikaConfig);
        Map<MediaType, Parser> parsers = parser.getParsers();
        parsers.put(MediaType.APPLICATION_XML, new HtmlParser());
        parser.setParsers(parsers);
        parser.setFallback(new Parser(){

            @Override
            public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
                return parser.getSupportedTypes(parseContext);
            }

            @Override
            public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) {
                throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
            }
        });
        if (digester != null) {
            return new DigestingParser(parser, digester);
        }
        return parser;
    }

    public static TikaConfig getConfig() {
        return tikaConfig;
    }

    public static String detectFilename(MultivaluedMap<String, String> httpHeaders) {
        String fn;
        ContentDisposition c;
        String disposition = httpHeaders.getFirst("Content-Disposition");
        if (disposition != null && "attachment".equals((c = new ContentDisposition(disposition)).getType()) && (fn = c.getParameter("filename")) != null) {
            return fn;
        }
        return httpHeaders.getFirst("File-Name");
    }

    public static void fillParseContext(ParseContext parseContext, MultivaluedMap<String, String> httpHeaders, Parser embeddedParser) {
        TesseractOCRConfig ocrConfig = null;
        PDFParserConfig pdfParserConfig = null;
        for (String key : httpHeaders.keySet()) {
            if (StringUtils.startsWith(key, X_TIKA_OCR_HEADER_PREFIX)) {
                ocrConfig = ocrConfig == null ? new TesseractOCRConfig() : ocrConfig;
                TikaResource.processHeaderConfig(httpHeaders, ocrConfig, key, X_TIKA_OCR_HEADER_PREFIX);
                continue;
            }
            if (!StringUtils.startsWith(key, X_TIKA_PDF_HEADER_PREFIX)) continue;
            pdfParserConfig = pdfParserConfig == null ? new PDFParserConfig() : pdfParserConfig;
            TikaResource.processHeaderConfig(httpHeaders, pdfParserConfig, key, X_TIKA_PDF_HEADER_PREFIX);
        }
        if (ocrConfig != null) {
            parseContext.set(TesseractOCRConfig.class, ocrConfig);
        }
        if (pdfParserConfig != null) {
            parseContext.set(PDFParserConfig.class, pdfParserConfig);
        }
        if (embeddedParser != null) {
            parseContext.set(Parser.class, embeddedParser);
        }
    }

    public static InputStream getInputStream(InputStream is, HttpHeaders headers) {
        try {
            return inputStreamFactory.getInputSteam(is, headers);
        }
        catch (IOException e) {
            throw new TikaServerParseException(e);
        }
    }

    private static void processHeaderConfig(MultivaluedMap<String, String> httpHeaders, Object object, String key, String prefix) {
        block25: {
            try {
                Method m;
                String property = StringUtils.removeStart(key, prefix);
                Field field = null;
                try {
                    field = object.getClass().getDeclaredField(StringUtils.uncapitalize(property));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                String setter = property;
                setter = "set" + setter.substring(0, 1).toUpperCase(Locale.US) + setter.substring(1);
                Class clazz = String.class;
                if (field != null) {
                    if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                        clazz = Integer.TYPE;
                    } else if (field.getType() == Double.TYPE) {
                        clazz = Double.TYPE;
                    } else if (field.getType() == Double.class) {
                        clazz = Double.class;
                    } else if (field.getType() == Float.TYPE) {
                        clazz = Float.TYPE;
                    } else if (field.getType() == Float.class) {
                        clazz = Float.class;
                    } else if (field.getType() == Boolean.TYPE) {
                        clazz = Boolean.TYPE;
                    } else if (field.getType() == Boolean.class) {
                        clazz = Boolean.class;
                    }
                }
                if ((m = TikaResource.tryToGetMethod(object, setter, clazz)) == null && clazz != String.class) {
                    m = TikaResource.tryToGetMethod(object, setter, String.class);
                }
                if (m != null) {
                    String val = httpHeaders.getFirst(key);
                    val = val.trim();
                    if (clazz == String.class) {
                        TikaResource.checkTrustWorthy(setter, val);
                        m.invoke(object, val);
                        break block25;
                    }
                    if (clazz == Integer.TYPE || clazz == Integer.class) {
                        m.invoke(object, Integer.parseInt(val));
                        break block25;
                    }
                    if (clazz == Double.TYPE || clazz == Double.class) {
                        m.invoke(object, Double.parseDouble(val));
                        break block25;
                    }
                    if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                        m.invoke(object, Boolean.parseBoolean(val));
                        break block25;
                    }
                    if (clazz == Float.TYPE || clazz == Float.class) {
                        m.invoke(object, Float.valueOf(Float.parseFloat(val)));
                        break block25;
                    }
                    throw new IllegalArgumentException("setter must be String, int, float, double or boolean...for now");
                }
                throw new NoSuchMethodException("Couldn't find: " + setter);
            }
            catch (Throwable ex) {
                throw new WebApplicationException(String.format(Locale.ROOT, "%s is an invalid %s header", key, X_TIKA_OCR_HEADER_PREFIX));
            }
        }
    }

    private static void checkTrustWorthy(String setter, String val) {
        if (setter == null || val == null) {
            throw new IllegalArgumentException("setter and val must not be null");
        }
        if (setter.toLowerCase(Locale.US).contains("trusted")) {
            throw new IllegalArgumentException("Can't call a trusted method via tika-server headers");
        }
        Matcher m = ALLOWABLE_HEADER_CHARS.matcher(val);
        if (!m.find()) {
            throw new IllegalArgumentException("Header val: " + val + " contains illegal characters. Must contain: TikaResource.ALLOWABLE_HEADER_CHARS");
        }
    }

    private static Method tryToGetMethod(Object object, String method, Class clazz) {
        try {
            return object.getClass().getMethod(method, clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static void fillMetadata(Parser parser, Metadata metadata, ParseContext context, MultivaluedMap<String, String> httpHeaders) {
        String password;
        String contentTypeHeader;
        javax.ws.rs.core.MediaType mediaType;
        String fileName = TikaResource.detectFilename(httpHeaders);
        if (fileName != null) {
            metadata.set("resourceName", fileName);
        }
        javax.ws.rs.core.MediaType mediaType2 = mediaType = (contentTypeHeader = httpHeaders.getFirst("Content-Type")) == null ? null : javax.ws.rs.core.MediaType.valueOf(contentTypeHeader);
        if (mediaType != null && "xml".equals(mediaType.getSubtype())) {
            mediaType = null;
        }
        if (mediaType != null && mediaType.equals(javax.ws.rs.core.MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
            mediaType = null;
        }
        if (mediaType != null) {
            metadata.add("Content-Type", mediaType.toString());
            final Detector detector = TikaResource.getDetector(parser);
            TikaResource.setDetector(parser, new Detector(){

                @Override
                public MediaType detect(InputStream inputStream, Metadata metadata) throws IOException {
                    String ct = metadata.get("Content-Type");
                    MediaType type = null;
                    if (ct != null) {
                        type = MediaType.parse(ct);
                    }
                    if (type != null) {
                        return type;
                    }
                    return detector.detect(inputStream, metadata);
                }
            });
        }
        if ((password = httpHeaders.getFirst("Password")) != null) {
            context.set(PasswordProvider.class, new PasswordProvider(){

                @Override
                public String getPassword(Metadata metadata) {
                    return password;
                }
            });
        }
    }

    public static void setDetector(Parser p, Detector detector) {
        AutoDetectParser adp = TikaResource.getAutoDetectParser(p);
        adp.setDetector(detector);
    }

    public static Detector getDetector(Parser p) {
        AutoDetectParser adp = TikaResource.getAutoDetectParser(p);
        return adp.getDetector();
    }

    private static AutoDetectParser getAutoDetectParser(Parser p) {
        if (p instanceof AutoDetectParser) {
            return (AutoDetectParser)p;
        }
        if (p instanceof ParserDecorator) {
            Parser wrapped = ((ParserDecorator)p).getWrappedParser();
            if (wrapped instanceof AutoDetectParser) {
                return (AutoDetectParser)wrapped;
            }
            throw new RuntimeException("Couldn't find AutoDetectParser within: " + wrapped.getClass());
        }
        throw new RuntimeException("Couldn't find AutoDetectParser within: " + p.getClass());
    }

    public static void parse(Parser parser, Logger logger, String path, InputStream inputStream, ContentHandler handler, Metadata metadata, ParseContext parseContext) throws IOException {
        TikaResource.checkIsOperating();
        long taskId = SERVER_STATUS.start(ServerStatus.TASK.PARSE, metadata.get("resourceName"));
        try {
            parser.parse(inputStream, handler, metadata, parseContext);
        }
        catch (SAXException e) {
            throw new TikaServerParseException(e);
        }
        catch (EncryptedDocumentException e) {
            logger.warn("{}: Encrypted document", (Object)path, (Object)e);
            throw new TikaServerParseException(e);
        }
        catch (Exception e) {
            logger.warn("{}: Text extraction failed", (Object)path, (Object)e);
            throw new TikaServerParseException(e);
        }
        catch (OutOfMemoryError e) {
            SERVER_STATUS.setStatus(ServerStatus.STATUS.ERROR);
            throw e;
        }
        finally {
            SERVER_STATUS.complete(taskId);
            inputStream.close();
        }
    }

    public static void checkIsOperating() {
        if (!SERVER_STATUS.isOperating()) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    public static void logRequest(Logger logger, UriInfo info, Metadata metadata) {
        if (metadata.get("Content-Type") == null) {
            logger.info("{} (autodetecting type)", (Object)info.getPath());
        } else {
            logger.info("{} ({})", (Object)info.getPath(), (Object)metadata.get("Content-Type"));
        }
    }

    @GET
    @Produces(value={"text/plain"})
    public String getMessage() {
        TikaResource.checkIsOperating();
        return GREETING;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Path(value="form")
    public StreamingOutput getTextFromMultipart(Attachment att, @Context UriInfo info) {
        return this.produceText(att.getObject(InputStream.class), att.getHeaders(), info);
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="main")
    public StreamingOutput getTextMain(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceTextMain(is, httpHeaders.getRequestHeaders(), info);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Path(value="form/main")
    public StreamingOutput getTextMainFromMultipart(Attachment att, @Context UriInfo info) {
        return this.produceTextMain(att.getObject(InputStream.class), att.getHeaders(), info);
    }

    public StreamingOutput produceTextMain(final InputStream is, MultivaluedMap<String, String> httpHeaders, final UriInfo info) {
        final Parser parser = TikaResource.createParser();
        final Metadata metadata = new Metadata();
        final ParseContext context = new ParseContext();
        TikaResource.fillMetadata(parser, metadata, context, httpHeaders);
        TikaResource.fillParseContext(context, httpHeaders, parser);
        TikaResource.logRequest(LOG, info, metadata);
        return new StreamingOutput(){

            @Override
            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                BoilerpipeContentHandler handler = new BoilerpipeContentHandler(writer);
                TikaResource.parse(parser, LOG, info.getPath(), is, handler, metadata, context);
            }
        };
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public StreamingOutput getText(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceText(TikaResource.getInputStream(is, httpHeaders), httpHeaders.getRequestHeaders(), info);
    }

    public StreamingOutput produceText(final InputStream is, MultivaluedMap<String, String> httpHeaders, final UriInfo info) {
        final Parser parser = TikaResource.createParser();
        final Metadata metadata = new Metadata();
        final ParseContext context = new ParseContext();
        TikaResource.fillMetadata(parser, metadata, context, httpHeaders);
        TikaResource.fillParseContext(context, httpHeaders, parser);
        TikaResource.logRequest(LOG, info, metadata);
        return new StreamingOutput(){

            @Override
            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                BodyContentHandler body = new BodyContentHandler(new RichTextContentHandler(writer));
                TikaResource.parse(parser, LOG, info.getPath(), is, body, metadata, context);
            }
        };
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @Path(value="form")
    public StreamingOutput getHTMLFromMultipart(Attachment att, @Context UriInfo info) {
        return this.produceOutput(att.getObject(InputStream.class), att.getHeaders(), info, "html");
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/html"})
    public StreamingOutput getHTML(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceOutput(TikaResource.getInputStream(is, httpHeaders), httpHeaders.getRequestHeaders(), info, "html");
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/xml"})
    @Path(value="form")
    public StreamingOutput getXMLFromMultipart(Attachment att, @Context UriInfo info) {
        return this.produceOutput(att.getObject(InputStream.class), att.getHeaders(), info, "xml");
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/xml"})
    public StreamingOutput getXML(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceOutput(TikaResource.getInputStream(is, httpHeaders), httpHeaders.getRequestHeaders(), info, "xml");
    }

    private StreamingOutput produceOutput(final InputStream is, MultivaluedMap<String, String> httpHeaders, final UriInfo info, final String format) {
        final Parser parser = TikaResource.createParser();
        final Metadata metadata = new Metadata();
        final ParseContext context = new ParseContext();
        TikaResource.fillMetadata(parser, metadata, context, httpHeaders);
        TikaResource.fillParseContext(context, httpHeaders, parser);
        TikaResource.logRequest(LOG, info, metadata);
        return new StreamingOutput(){

            @Override
            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                ExpandedTitleContentHandler content;
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                try {
                    SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                    TransformerHandler handler = factory.newTransformerHandler();
                    handler.getTransformer().setOutputProperty("method", format);
                    handler.getTransformer().setOutputProperty("indent", "yes");
                    handler.getTransformer().setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                    handler.setResult(new StreamResult(writer));
                    content = new ExpandedTitleContentHandler(handler);
                }
                catch (TransformerConfigurationException e) {
                    throw new WebApplicationException(e);
                }
                TikaResource.parse(parser, LOG, info.getPath(), is, content, metadata, context);
            }
        };
    }

    static {
        digester = null;
        inputStreamFactory = null;
        SERVER_STATUS = null;
        ExtractorFactory.setAllThreadsPreferEventExtractors(true);
    }
}

