# Generated by default/object.tt
package Paws::WAFV2::RuleGroup;
  use Moose;
  has ARN => (is => 'ro', isa => 'Str', required => 1);
  has AvailableLabels => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::LabelSummary]');
  has Capacity => (is => 'ro', isa => 'Int', required => 1);
  has ConsumedLabels => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::LabelSummary]');
  has CustomResponseBodies => (is => 'ro', isa => 'Paws::WAFV2::CustomResponseBodies');
  has Description => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has LabelNamespace => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has Rules => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::Rule]');
  has VisibilityConfig => (is => 'ro', isa => 'Paws::WAFV2::VisibilityConfig', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::RuleGroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::RuleGroup object:

  $service_obj->Method(Att1 => { ARN => $value, ..., VisibilityConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::RuleGroup object:

  $result = $service_obj->Method(...);
  $result->Att1->ARN

=head1 DESCRIPTION

A rule group defines a collection of rules to inspect and control web
requests that you can use in a WebACL. When you create a rule group,
you define an immutable capacity limit. If you update a rule group, you
must stay within the capacity. This allows others to reuse the rule
group with confidence in its capacity requirements.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ARN => Str

The Amazon Resource Name (ARN) of the entity.


=head2 AvailableLabels => ArrayRef[L<Paws::WAFV2::LabelSummary>]

The labels that one or more rules in this rule group add to matching
web requests. These labels are defined in the C<RuleLabels> for a Rule.


=head2 B<REQUIRED> Capacity => Int

The web ACL capacity units (WCUs) required for this rule group.

When you create your own rule group, you define this, and you cannot
change it after creation. When you add or modify the rules in a rule
group, WAF enforces this limit. You can check the capacity for a set of
rules using CheckCapacity.

WAF uses WCUs to calculate and control the operating resources that are
used to run your rules, rule groups, and web ACLs. WAF calculates
capacity differently for each rule type, to reflect the relative cost
of each rule. Simple rules that cost little to run use fewer WCUs than
more complex rules that use more processing power. Rule group capacity
is fixed at creation, which helps users plan their web ACL WCU usage
when they use a rule group. The WCU limit for web ACLs is 1,500.


=head2 ConsumedLabels => ArrayRef[L<Paws::WAFV2::LabelSummary>]

The labels that one or more rules in this rule group match against in
label match statements. These labels are defined in a
C<LabelMatchStatement> specification, in the Statement definition of a
rule.


=head2 CustomResponseBodies => L<Paws::WAFV2::CustomResponseBodies>

A map of custom response keys and content bodies. When you create a
rule with a block action, you can send a custom response to the web
request. You define these for the rule group, and then use them in the
rules that you define in the rule group.

For information about customizing web requests and responses, see
Customizing web requests and responses in WAF
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
in the WAF Developer Guide
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).

For information about the limits on count and size for custom request
and response settings, see WAF quotas
(https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in
the WAF Developer Guide
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).


=head2 Description => Str

A description of the rule group that helps with identification.


=head2 B<REQUIRED> Id => Str

A unique identifier for the rule group. This ID is returned in the
responses to create and list commands. You provide it to operations
like update and delete.


=head2 LabelNamespace => Str

The label namespace prefix for this rule group. All labels added by
rules in this rule group have this prefix.

=over

=item *

The syntax for the label namespace prefix for your rule groups is the
following:

C<awswaf:E<lt>account IDE<gt>:rulegroup:E<lt>rule group nameE<gt>:>

=item *

When a rule with a label matches a web request, WAF adds the fully
qualified label to the request. A fully qualified label is made up of
the label namespace from the rule group or web ACL where the rule is
defined and the label from the rule, separated by a colon:

C<E<lt>label namespaceE<gt>:E<lt>label from ruleE<gt>>

=back



=head2 B<REQUIRED> Name => Str

The name of the rule group. You cannot change the name of a rule group
after you create it.


=head2 Rules => ArrayRef[L<Paws::WAFV2::Rule>]

The Rule statements used to identify the web requests that you want to
allow, block, or count. Each rule includes one top-level statement that
WAF uses to identify matching web requests, and parameters that govern
how WAF handles them.


=head2 B<REQUIRED> VisibilityConfig => L<Paws::WAFV2::VisibilityConfig>

Defines and enables Amazon CloudWatch metrics and web request sample
collection.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

