#!perl

use 5.006001;
use strict;
use warnings;

use English qw(-no_match_vars);

use Perl::ToPerl6::UserProfile;

use Test::More tests => 41;

#-----------------------------------------------------------------------------

# Create profile from hash

{
    my %transformer_params = (min_elements => 4);
    my %profile_hash = ( '-BasicTypes::Strings::RenameShell' => {},
        '-Variables::QuoteHashKeys' => \%transformer_params );

    my $up = Perl::ToPerl6::UserProfile->new( -profile => \%profile_hash );

    # Using short transformer names
SKIP: {
  skip "XXX Need to restore this eventually", 1;
    is(
        $up->transformer_is_enabled('Variables::QuoteHashKeys'),
        1,
        'Variables::QuoteHashKeys is enabled.',
    );
}
    is(
        $up->transformer_is_disabled('Variables::QuoteHashKeys'),
        1,
        'Variables::QuoteHashKeys is disabled.',
    );
SKIP: {
  skip "XXX Need to restore this eventually", 1;
    is_deeply(
        $up->raw_transformer_params('Variables::QuoteHashKeys'),
        \%transformer_params,
        'Variables::QuoteHashKeys got the correct configuration.',
    );
}

SKIP: {
  skip "XXX Need to restore these eventually", 2;
    # Now using long transformer names
    is(
        $up->transformer_is_enabled('Perl::ToPerl6::Transformer::Variables::QuoteHashKeys'),
        1,
        'Perl::ToPerl6::Transformer::Variables::QuoteHashKeys is enabled.',
    );
    is(
        $up->transformer_is_disabled('Perl::ToPerl6::Transformer::NamingConventions::Capitalization'),
        1,
        'Perl::ToPerl6::Transformer::NamingConventions::Capitalization is disabled.',
    );
}
    is_deeply(
        $up->raw_transformer_params('Perl::ToPerl6::Transformer::Variables::QuoteHashKeys'),
        \%transformer_params,
        'Perl::ToPerl6::Transformer::Variables::QuoteHashKeys got the correct configuration.',
    );

    # Using bogus transformer names
    is(
        $up->transformer_is_enabled('Perl::ToPerl6::Transformer::Bogus'),
        q{},
        q<Bogus Transformer isn't enabled>,
    );
    is(
        $up->transformer_is_disabled('Perl::ToPerl6::Transformer::Bogus'),
        q{},
        q<Bogus Transformer isn't disabled>,
    );
    is_deeply(
        $up->raw_transformer_params('Perl::ToPerl6::Transformer::Bogus'),
        {},
        q<Bogus Transformer doesn't have any configuration.>,
    );
}

#-----------------------------------------------------------------------------
# Create profile from array

{
    my %transformer_params = (min_elements => 4);
    my @profile_array = ( q{ [-NamingConventions::Capitalization] },
                          q{ [Variables::QuoteHashKeys]           },
                          q{ min_elements = 4                         },
    );


    my $up = Perl::ToPerl6::UserProfile->new( -profile => \@profile_array );

    # Now using long transformer names
    is(
        $up->transformer_is_enabled('Variables::QuoteHashKeys'),
        1,
        'Variables::QuoteHashKeys is enabled.',
    );
    is(
        $up->transformer_is_disabled('NamingConventions::Capitalization'),
        1,
        'NamingConventions::Capitalization is disabled.',
    );
    is_deeply(
        $up->raw_transformer_params('Variables::QuoteHashKeys'),
        \%transformer_params,
        'Variables::QuoteHashKeys got the correct configuration.',
    );

    # Now using long transformer names
    is(
        $up->transformer_is_enabled('Perl::ToPerl6::Transformer::Variables::QuoteHashKeys'),
        1,
        'Perl::ToPerl6::Transformer::Variables::QuoteHashKeys is enabled.',
    );
    is(
        $up->transformer_is_disabled('Perl::ToPerl6::Transformer::NamingConventions::Capitalization'),
        1,
        'Perl::ToPerl6::Transformer::NamingConventions::Capitalization is disabled.',
    );
    is_deeply(
        $up->raw_transformer_params('Perl::ToPerl6::Transformer::Variables::QuoteHashKeys'),
        \%transformer_params,
        'Perl::ToPerl6::Transformer::Variables::QuoteHashKeys got the correct configuration.',
    );

    # Using bogus transformer names
    is(
        $up->transformer_is_enabled('Perl::ToPerl6::Transformer::Bogus'),
        q{},
        q<Bogus Transformer isn't enabled>,
    );
    is(
        $up->transformer_is_disabled('Perl::ToPerl6::Transformer::Bogus'),
        q{},
        q<Bogus Transformer isn't disabled>,
    );
    is_deeply(
        $up->raw_transformer_params('Perl::ToPerl6::Transformer::Bogus'),
        {},
        q<Bogus Transformer doesn't have any configuration.>,
    );
}

#-----------------------------------------------------------------------------
# Create profile from string

{
    my %transformer_params = (min_elements => 4);
    my $profile_string = <<'END_PROFILE';
[-NamingConventions::Capitalization]
[Variables::QuoteHashKeys]
min_elements = 4
END_PROFILE

    my $up = Perl::ToPerl6::UserProfile->new( -profile => \$profile_string );

    # Now using long transformer names
    is(
        $up->transformer_is_enabled('Variables::QuoteHashKeys'),
        1,
        'Variables::QuoteHashKeys is enabled.',
    );
    is(
        $up->transformer_is_disabled('NamingConventions::Capitalization'),
        1,
        'NamingConventions::Capitalization is disabled.',
    );
    is_deeply(
        $up->raw_transformer_params('Variables::QuoteHashKeys'),
        \%transformer_params,
        'Variables::QuoteHashKeys got the correct configuration.',
    );

    # Now using long transformer names
    is(
        $up->transformer_is_enabled('Perl::ToPerl6::Transformer::Variables::QuoteHashKeys'),
        1,
        'Perl::ToPerl6::Transformer::Variables::QuoteHashKeys is enabled.',
    );
    is(
        $up->transformer_is_disabled('Perl::ToPerl6::Transformer::NamingConventions::Capitalization'),
        1,
        'Perl::ToPerl6::Transformer::NamingConventions::Capitalization is disabled.',
    );
    is_deeply(
        $up->raw_transformer_params('Perl::ToPerl6::Transformer::Variables::QuoteHashKeys'),
        \%transformer_params,
        'Perl::ToPerl6::Transformer::Variables::QuoteHashKeys got the correct configuration.',
    );

    # Using bogus transformer names
    is(
        $up->transformer_is_enabled('Perl::ToPerl6::Transformer::Bogus'),
        q{},
        q<Bogus Transformer isn't enabled>,
    );
    is(
        $up->transformer_is_disabled('Perl::ToPerl6::Transformer::Bogus'),
        q{},
        q<Bogus Transformer isn't disabled>,
    );
    is_deeply(
        $up->raw_transformer_params('Perl::ToPerl6::Transformer::Bogus'),
        {},
        q<Bogus Transformer doesn't have any configuration.>,
    );
}

#-----------------------------------------------------------------------------
# Test long transformer names

{
    my %transformer_params = (min_elements => 4);
    my $long_profile_string = <<'END_PROFILE';
[-Perl::ToPerl6::Transformer::NamingConventions::Capitalization]
[Perl::ToPerl6::Transformer::Variables::QuoteHashKeys]
min_elements = 4
END_PROFILE

    my $up = Perl::ToPerl6::UserProfile->new( -profile => \$long_profile_string );

    # Now using long transformer names
    is(
        $up->transformer_is_enabled('Variables::QuoteHashKeys'),
        1,
        'Variables::QuoteHashKeys is enabled.',
    );
    is(
        $up->transformer_is_disabled('NamingConventions::Capitalization'),
        1,
        'NamingConventions::Capitalization is disabled.',
    );
    is_deeply(
        $up->raw_transformer_params('Variables::QuoteHashKeys'),
        \%transformer_params,
        'Variables::QuoteHashKeys got the correct configuration.',
    );

    # Now using long transformer names
    is(
        $up->transformer_is_enabled('Perl::ToPerl6::Transformer::Variables::QuoteHashKeys'),
        1,
        'Perl::ToPerl6::Transformer::Variables::QuoteHashKeys is enabled.',
    );
    is(
        $up->transformer_is_disabled('Perl::ToPerl6::Transformer::NamingConventions::Capitalization'),
        1,
        'Perl::ToPerl6::Transformer::NamingConventions::Capitalization is disabled.',
    );
    is_deeply(
        $up->raw_transformer_params('Perl::ToPerl6::Transformer::Variables::QuoteHashKeys'),
        \%transformer_params,
        'Perl::ToPerl6::Transformer::Variables::QuoteHashKeys got the correct configuration.',
    );

    # Using bogus transformer names
    is(
        $up->transformer_is_enabled('Perl::ToPerl6::Transformer::Bogus'),
        q{},
        q<Bogus Transformer isn't enabled>,
    );
    is(
        $up->transformer_is_disabled('Perl::ToPerl6::Transformer::Bogus'),
        q{},
        q<Bogus Transformer isn't disabled>,
    );
    is_deeply(
        $up->raw_transformer_params('Perl::ToPerl6::Transformer::Bogus'),
        {},
        q<Bogus Transformer doesn't have any configuration.>,
    );
}

#-----------------------------------------------------------------------------
# Test exception handling

{
    my $code_ref = sub { return };
    eval { Perl::ToPerl6::UserProfile->new( -profile => $code_ref ) };
    like(
        $EVAL_ERROR,
        qr/Can't [ ] load [ ] UserProfile/xms,
        'Invalid profile type',
    );

    eval { Perl::ToPerl6::UserProfile->new( -profile => 'bogus' ) };
    like(
        $EVAL_ERROR,
        qr/Could [ ] not [ ] parse [ ] profile [ ] "bogus"/xms,
        'Invalid profile path',
    );

    my $invalid_syntax = '[Foo::Bar'; # Missing "]"
    eval { Perl::ToPerl6::UserProfile->new( -profile => \$invalid_syntax ) };
    like(
        $EVAL_ERROR,
        qr/Syntax [ ] error [ ] at [ ] line/xms,
        'Invalid profile syntax',
    );

    $invalid_syntax = 'necessity 2'; # Missing "="
    eval { Perl::ToPerl6::UserProfile->new( -profile => \$invalid_syntax ) };
    like(
        $EVAL_ERROR,
        qr/Syntax [ ] error [ ] at [ ] line/xms,
        'Invalid profile syntax',
    );

}

#-----------------------------------------------------------------------------
# Test profile finding

{
    my $expected = local $ENV{PERLMOGRIFY} = 'foo';
    my $got = Perl::ToPerl6::UserProfile::_find_profile_path();
    is( $got, $expected, 'PERLMOGRIFY environment variable');
}

#-----------------------------------------------------------------------------

# ensure we return true if this test is loaded by
# t/10_userprofile.t_without_optional_dependencies.t
1;

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 78
#   indent-tabs-mode: nil
#   c-indentation-style: bsd
# End:
# ex: set ts=8 sts=4 sw=4 tw=78 ft=perl expandtab shiftround :
