# Модели форм

Вы можете использовать **Pydantic-модели** для объявления **полей форм** в FastAPI.

/// info | Дополнительная информация

Чтобы использовать формы, сначала установите <a href="https://github.com/Kludex/python-multipart" class="external-link" target="_blank">`python-multipart`</a>.

Убедитесь, что вы создали и активировали [виртуальное окружение](../virtual-environments.md){.internal-link target=_blank}, а затем установите пакет, например:

```console
$ pip install python-multipart
```

///

/// note | Заметка

Этот функционал доступен с версии `0.113.0`. 🤓

///

## Pydantic-модель для формы

Вам просто нужно объявить **Pydantic-модель** с полями, которые вы хотите получить как **поля формы**, а затем объявить параметр как `Form`:

{* ../../docs_src/request_form_models/tutorial001_an_py39.py hl[9:11,15] *}

**FastAPI** **извлечёт** данные для **каждого поля** из **данных формы** в запросе и выдаст вам объявленную Pydantic-модель.

## Проверка сгенерированной документации

Вы можете посмотреть поля формы в графическом интерфейсе Документации по пути `/docs`:

<div class="screenshot">
<img src="/img/tutorial/request-form-models/image01.png">
</div>

## Запрет дополнительных полей формы

В некоторых случаях (не особо часто встречающихся) вам может понадобиться **ограничить** поля формы только теми, которые объявлены в Pydantic-модели. И **запретить** любые **дополнительные** поля.

/// note | Заметка

Этот функционал доступен с версии `0.114.0`. 🤓

///

Вы можете сконфигурировать Pydantic-модель так, чтобы запретить (`forbid`) все дополнительные (`extra`) поля:

{* ../../docs_src/request_form_models/tutorial002_an_py39.py hl[12] *}

Если клиент попробует отправить дополнительные данные, то в ответ он получит **ошибку**.

Например, если клиент попытается отправить поля формы:

* `username`: `Rick`
* `password`: `Portal Gun`
* `extra`: `Mr. Poopybutthole`

То в ответ он получит **ошибку**, сообщающую ему, что поле `extra` не разрешено:

```json
{
    "detail": [
        {
            "type": "extra_forbidden",
            "loc": ["body", "extra"],
            "msg": "Extra inputs are not permitted",
            "input": "Mr. Poopybutthole"
        }
    ]
}
```

## Заключение

Вы можете использовать Pydantic-модели для объявления полей форм в FastAPI. 😎
