/*
 * TechSmith Screen Codec 2 (aka Dora) decoder
 * Copyright (c) 2012 Konstantin Shishkov
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef AVCODEC_TSCC2DATA_H
#define AVCODEC_TSCC2DATA_H

#include <stdint.h>

#define NUM_VLC_SETS 13

static const uint16_t tscc2_quants[NUM_VLC_SETS][3] = {
    {  655,  861, 1130 }, {  983, 1291, 1695 }, { 1311, 1721, 2260 },
    { 1638, 2151, 2825 }, { 1966, 2582, 3390 }, { 2294, 3012, 3955 },
    { 2621, 3442, 4520 }, { 2949, 3872, 5085 }, { 3277, 4303, 5650 },
    { 3604, 4733, 6215 }, { 3932, 5163, 6780 }, { 4260, 5593, 7345 },
    { 4588, 6024, 7910 },
};

#define DC_VLC_COUNT 47

static const uint16_t tscc2_dc_vlc_syms[DC_VLC_COUNT] = {
   0x100, 0xFF, 0xFE, 0xFD, 0xFC, 0xFB, 0xFA, 0xF9,
    0xF8, 0xF7, 0xF6, 0xF5, 0xF4, 0xF3, 0xF2, 0xF1,
    0xF0, 0xEF, 0xEE, 0xED, 0xEC, 0xEB, 0xEA, 0x17,
    0x16, 0x15, 0x14, 0x13, 0x12, 0x11, 0x10, 0x0F,
    0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x07,
    0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00,
};

static const uint16_t tscc2_dc_vlc_codes[DC_VLC_COUNT] = {
    0x000A, 0x0000, 0x0006, 0x002E, 0x0002, 0x000E, 0x001A, 0x007E,
    0x004E, 0x005A, 0x00E2, 0x01BE, 0x01BA, 0x00BA, 0x0072, 0x0022,
    0x02BE, 0x00BE, 0x033A, 0x03F2, 0x01F2, 0x03A2, 0x0122, 0x0322,
    0x01A2, 0x0172, 0x0372, 0x013A, 0x00CE, 0x02CE, 0x02FE, 0x00FE,
    0x00A2, 0x00F2, 0x003A, 0x01CE, 0x01FE, 0x0062, 0x00DA, 0x003E,
    0x0032, 0x007A, 0x0012, 0x001E, 0x0016, 0x0004, 0x0001,
};

static const uint8_t tscc2_dc_vlc_bits[DC_VLC_COUNT] = {
     5,  3,  5,  6,  6,  7,  7,  8,
     8,  8,  8,  9,  9,  9,  9,  9,
    10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10,
     9,  9,  9,  9,  9,  8,  8,  8,
     7,  7,  6,  6,  5,  3,  1,
};

static const uint8_t tscc2_nc_vlc_syms[16] = {
    0x0F, 0x0E, 0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08,
    0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00,
};

static const uint16_t tscc2_nc_vlc_codes[NUM_VLC_SETS][16] = {
    { 0x0023, 0x0003, 0x0031, 0x0021, 0x0011, 0x0053, 0x0013, 0x0001,
      0x0009, 0x0029, 0x0033, 0x0019, 0x000B, 0x0005, 0x0007, 0x0000, },
    { 0x0030, 0x0022, 0x0028, 0x0020, 0x0008, 0x0000, 0x0032, 0x0072,
      0x0010, 0x0002, 0x0012, 0x0018, 0x000A, 0x0004, 0x0006, 0x0001, },
    { 0x0032, 0x0038, 0x0020, 0x0008, 0x0002, 0x0018, 0x0072, 0x0000,
      0x0028, 0x0022, 0x0012, 0x0010, 0x000A, 0x0004, 0x0006, 0x0001, },
    { 0x0032, 0x0010, 0x0072, 0x0030, 0x0022, 0x0038, 0x0008, 0x0028,
      0x0018, 0x0002, 0x0012, 0x0000, 0x000A, 0x0004, 0x0006, 0x0001, },
    { 0x0012, 0x0052, 0x0000, 0x0020, 0x0018, 0x0022, 0x0008, 0x0028,
      0x0038, 0x0002, 0x0032, 0x0010, 0x000A, 0x0004, 0x0006, 0x0001, },
    { 0x0016, 0x0096, 0x0006, 0x0046, 0x0056, 0x0002, 0x0036, 0x0076,
      0x0012, 0x0022, 0x0032, 0x0026, 0x000A, 0x000E, 0x0000, 0x0001, },
    { 0x001A, 0x009A, 0x0032, 0x0072, 0x005A, 0x007A, 0x003A, 0x0002,
      0x0012, 0x0022, 0x000A, 0x002A, 0x0006, 0x000E, 0x0000, 0x0001, },
    { 0x002A, 0x00AA, 0x0002, 0x0042, 0x006A, 0x003A, 0x007A, 0x0022,
      0x0032, 0x0012, 0x000A, 0x001A, 0x0006, 0x000E, 0x0000, 0x0001, },
    { 0x0042, 0x00C2, 0x0002, 0x000A, 0x004A, 0x003A, 0x007A, 0x0022,
      0x0012, 0x0032, 0x002A, 0x001A, 0x0006, 0x000E, 0x0000, 0x0001, },
    { 0x00BA, 0x01BA, 0x003A, 0x0012, 0x0052, 0x007A, 0x0002, 0x0022,
      0x0032, 0x000A, 0x002A, 0x001A, 0x0000, 0x0004, 0x0006, 0x0001, },
    { 0x00AA, 0x01AA, 0x002A, 0x0022, 0x0062, 0x006A, 0x0002, 0x0012,
      0x0032, 0x000A, 0x001A, 0x003A, 0x0000, 0x0004, 0x0006, 0x0001, },
    { 0x00AA, 0x01AA, 0x002A, 0x0022, 0x0062, 0x006A, 0x0002, 0x0012,
      0x0032, 0x000A, 0x003A, 0x001A, 0x0000, 0x0004, 0x0006, 0x0001, },
    { 0x008A, 0x018A, 0x000A, 0x0022, 0x0062, 0x004A, 0x0002, 0x0012,
      0x0032, 0x002A, 0x001A, 0x003A, 0x0000, 0x0004, 0x0006, 0x0001, },
};

static const uint8_t tscc2_nc_vlc_bits[NUM_VLC_SETS][16] = {
    { 6, 6, 6, 6, 6, 7, 7, 6, 6, 6, 6, 5, 4, 3, 3, 1 },
    { 6, 6, 6, 6, 6, 6, 7, 7, 6, 6, 6, 5, 4, 3, 3, 1 },
    { 7, 6, 6, 6, 6, 6, 7, 6, 6, 6, 6, 5, 4, 3, 3, 1 },
    { 7, 6, 7, 6, 6, 6, 6, 6, 6, 6, 6, 5, 4, 3, 3, 1 },
    { 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 4, 3, 3, 1 },
    { 8, 8, 7, 7, 7, 6, 7, 7, 6, 6, 6, 6, 4, 4, 2, 1 },
    { 8, 8, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 4, 4, 2, 1 },
    { 8, 8, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 4, 4, 2, 1 },
    { 8, 8, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 4, 4, 2, 1 },
    { 9, 9, 8, 7, 7, 7, 6, 6, 6, 6, 6, 6, 3, 3, 3, 1 },
    { 9, 9, 8, 7, 7, 7, 6, 6, 6, 6, 6, 6, 3, 3, 3, 1 },
    { 9, 9, 8, 7, 7, 7, 6, 6, 6, 6, 6, 6, 3, 3, 3, 1 },
    { 9, 9, 8, 7, 7, 7, 6, 6, 6, 6, 6, 6, 3, 3, 3, 1 },
};

static const uint16_t ac_vlc_desc0_syms[172] = {
   0x1000, 0xFF8, 0xFF6, 0xFF5, 0xFF4, 0xFF3, 0xFF2, 0xFF1,
    0xFF0, 0xFE6, 0xFE5, 0xFE4, 0xFE3, 0xFE2, 0xFE1, 0xFE0,
    0xFD6, 0xFD5, 0xFD3, 0xFD2, 0xFD1, 0xFD0, 0xFC6, 0xFC5,
    0xFC3, 0xFC2, 0xFC1, 0xFC0, 0xFB5, 0xFB3, 0xFB2, 0xFB1,
    0xFB0, 0xFA5, 0xFA3, 0xFA1, 0xFA0, 0xF95, 0xF91, 0xF90,
    0xF83, 0xF81, 0xF80, 0xF73, 0xF71, 0xF70, 0xF61, 0xF60,
    0xF51, 0xF50, 0xF45, 0xF41, 0xF40, 0xF31, 0xF30, 0xF21,
    0xF20, 0xF10, 0xF00, 0xEF0, 0xEE0, 0xED5, 0xED1, 0xED0,
    0xEC0, 0xEB0, 0xEA0, 0xE90, 0xE80, 0xE70, 0xE60, 0xE50,
    0xE40, 0xE30, 0xE20, 0xE10, 0xE00, 0xDF0, 0xDE0, 0xDD0,
    0xDC0, 0xDB0, 0xDA0, 0xD90, 0xD80, 0xD60, 0xCD1, 0x280,
    0x270, 0x260, 0x250, 0x240, 0x230, 0x220, 0x210, 0x200,
    0x1F0, 0x1E0, 0x1D0, 0x1C0, 0x1B0, 0x1A1, 0x1A0, 0x190,
    0x180, 0x170, 0x160, 0x150, 0x140, 0x130, 0x121, 0x120,
    0x111, 0x110, 0x101, 0x100, 0x0F1, 0x0F0, 0x0E1, 0x0E0,
    0x0D1, 0x0D0, 0x0C1, 0x0C0, 0x0B1, 0x0B0, 0x0A5, 0x0A1,
    0x0A0, 0x091, 0x090, 0x081, 0x080, 0x075, 0x071, 0x070,
    0x065, 0x063, 0x061, 0x060, 0x055, 0x053, 0x052, 0x051,
    0x050, 0x046, 0x045, 0x043, 0x042, 0x041, 0x040, 0x036,
    0x035, 0x033, 0x032, 0x031, 0x030, 0x026, 0x025, 0x024,
    0x023, 0x022, 0x021, 0x020, 0x018, 0x016, 0x015, 0x014,
    0x013, 0x012, 0x011, 0x010,
};

static const uint16_t ac_vlc_desc0_codes[172] = {
    0x001F, 0x0D71, 0x013F, 0x006C, 0x00A7, 0x0067, 0x001C, 0x0008,
    0x0005, 0x06F1, 0x002C, 0x04BA, 0x0072, 0x01AA, 0x0002, 0x0006,
    0x06AC, 0x02AF, 0x06EF, 0x018F, 0x000A, 0x0009, 0x02AC, 0x042A,
    0x06E1, 0x068F, 0x00B1, 0x0000, 0x0317, 0x0C17, 0x0612, 0x010F,
    0x0011, 0x0FBA, 0x002A, 0x0172, 0x000C, 0x05AC, 0x03D7, 0x0037,
    0x0E8F, 0x02F2, 0x0041, 0x0BE1, 0x057F, 0x004A, 0x00AF, 0x006F,
    0x06AA, 0x0097, 0x0101, 0x0012, 0x0081, 0x0571, 0x0092, 0x0EAF,
    0x01BF, 0x00D7, 0x0031, 0x0001, 0x01F2, 0x0F17, 0x053A, 0x00BF,
    0x038F, 0x0217, 0x0371, 0x01F1, 0x01BA, 0x022A, 0x02BF, 0x028F,
    0x008F, 0x03F1, 0x00E1, 0x00BA, 0x00F2, 0x0EBF, 0x06AF, 0x048F,
    0x0FE1, 0x0271, 0x07BA, 0x0D3A, 0x0C12, 0x08AC, 0x0717, 0x00AC,
    0x0412, 0x0901, 0x04E1, 0x07E1, 0x0417, 0x0CAF, 0x04AC, 0x01AC,
    0x04F2, 0x03BA, 0x05D7, 0x07F1, 0x01D7, 0x04AF, 0x04EF, 0x03AC,
    0x00AA, 0x01E1, 0x0071, 0x00F1, 0x012C, 0x03EF, 0x082A, 0x0112,
    0x03E1, 0x01FA, 0x0DAC, 0x0131, 0x0E12, 0x000F, 0x0B17, 0x007F,
    0x0AEF, 0x007A, 0x02AA, 0x0061, 0x0671, 0x0027, 0x013A, 0x058F,
    0x00FF, 0x033A, 0x0032, 0x0301, 0x0021, 0x0C8F, 0x037F, 0x0077,
    0x02F1, 0x02E1, 0x003A, 0x003C, 0x0212, 0x0817, 0x0CE1, 0x003F,
    0x0007, 0x0017, 0x0501, 0x02BA, 0x06BF, 0x0057, 0x0010, 0x02EF,
    0x0117, 0x017F, 0x00EF, 0x006A, 0x0019, 0x0171, 0x01EF, 0x06BA,
    0x012A, 0x00FA, 0x0022, 0x000E, 0x0AE1, 0x01AF, 0x0052, 0x002F,
    0x004F, 0x001A, 0x0004, 0x0003,
};

static const uint8_t ac_vlc_desc0_bits[172] = {
     6, 12,  9,  7,  8,  7,  6,  4,
     3, 11,  9, 11,  9,  9,  6,  4,
    11, 11, 11, 11,  7,  5, 11, 11,
    11, 12,  8,  5, 12, 12, 12,  9,
     6, 12, 12,  9,  6, 12, 10,  7,
    12, 10,  7, 12, 11,  7, 11,  8,
    11,  8, 12, 11,  8, 12,  8, 12,
     9,  9,  9,  9,  9, 12, 12, 10,
    10, 10, 10, 10, 10, 10, 11, 11,
    11, 11, 11, 11, 11, 12, 12, 12,
    12, 11, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 11, 11,
    11, 11, 11, 11, 11, 12, 11, 10,
    10, 10, 10, 10,  9, 10, 12,  9,
    12,  9, 12,  9, 12,  9, 12,  9,
    12,  8, 11,  8, 11,  8, 11, 11,
     8, 10,  7, 10,  7, 12, 10,  7,
    11, 12,  9,  6, 11, 12, 12,  9,
     6, 12, 11, 11, 12,  8,  5, 12,
    10, 11, 11,  7,  5, 11, 10, 11,
     9,  9,  6,  4, 12,  9,  7,  8,
     7,  6,  4,  3,
};

static const uint16_t ac_vlc_desc1_syms[169] = {
   0x1000, 0xFF8, 0xFF6, 0xFF5, 0xFF4, 0xFF3, 0xFF2, 0xFF1,
    0xFF0, 0xFE6, 0xFE5, 0xFE4, 0xFE3, 0xFE2, 0xFE1, 0xFE0,
    0xFD6, 0xFD5, 0xFD3, 0xFD2, 0xFD1, 0xFD0, 0xFC6, 0xFC5,
    0xFC3, 0xFC2, 0xFC1, 0xFC0, 0xFB6, 0xFB5, 0xFB3, 0xFB2,
    0xFB1, 0xFB0, 0xFA6, 0xFA5, 0xFA3, 0xFA1, 0xFA0, 0xF95,
    0xF93, 0xF91, 0xF90, 0xF85, 0xF81, 0xF80, 0xF71, 0xF70,
    0xF61, 0xF60, 0xF51, 0xF50, 0xF45, 0xF41, 0xF40, 0xF31,
    0xF30, 0xF21, 0xF20, 0xF11, 0xF10, 0xF01, 0xF00, 0xEF1,
    0xEF0, 0xEE1, 0xEE0, 0xED0, 0xEC6, 0xEC0, 0xEB6, 0xEB0,
    0xEA0, 0xE90, 0xE80, 0xE70, 0xE60, 0xE50, 0xE40, 0xE33,
    0xE31, 0xE30, 0xE20, 0xE10, 0xE00, 0xDF0, 0xDE1, 0xDE0,
    0xDC0, 0xDB0, 0xDA0, 0x250, 0x240, 0x1F0, 0x1E0, 0x1D0,
    0x1C0, 0x1B0, 0x1A0, 0x190, 0x180, 0x170, 0x160, 0x150,
    0x140, 0x130, 0x120, 0x111, 0x110, 0x101, 0x100, 0x0F1,
    0x0F0, 0x0E1, 0x0E0, 0x0D1, 0x0D0, 0x0C6, 0x0C1, 0x0C0,
    0x0B1, 0x0B0, 0x0A1, 0x0A0, 0x095, 0x091, 0x090, 0x085,
    0x081, 0x080, 0x075, 0x071, 0x070, 0x065, 0x063, 0x061,
    0x060, 0x055, 0x053, 0x052, 0x051, 0x050, 0x046, 0x045,
    0x043, 0x042, 0x041, 0x040, 0x036, 0x035, 0x033, 0x032,
    0x031, 0x030, 0x026, 0x025, 0x024, 0x023, 0x022, 0x021,
    0x020, 0x018, 0x016, 0x015, 0x014, 0x013, 0x012, 0x011,
    0x010,
};

static const uint16_t ac_vlc_desc1_codes[169] = {
    0x0019, 0x027D, 0x0084, 0x0044, 0x009D, 0x003D, 0x000A, 0x0002,
    0x0003, 0x00EA, 0x02FD, 0x017A, 0x01C6, 0x00B6, 0x0026, 0x000E,
    0x0095, 0x0260, 0x032A, 0x0360, 0x0006, 0x0005, 0x05B6, 0x036A,
    0x06F6, 0x0704, 0x00FA, 0x0010, 0x0279, 0x04D4, 0x00F6, 0x066A,
    0x001D, 0x0029, 0x05F9, 0x0846, 0x04F6, 0x01D4, 0x0038, 0x0446,
    0x0160, 0x031D, 0x0075, 0x0054, 0x02D4, 0x005A, 0x05FD, 0x0040,
    0x06EA, 0x0055, 0x0460, 0x009A, 0x052A, 0x00A0, 0x00D8, 0x0380,
    0x017D, 0x092A, 0x00F9, 0x0D7A, 0x0179, 0x0304, 0x002A, 0x0104,
    0x01A0, 0x0780, 0x007D, 0x03F9, 0x0C46, 0x03EA, 0x0E6A, 0x0204,
    0x01FD, 0x051D, 0x02AA, 0x05EA, 0x00AA, 0x0080, 0x067D, 0x09EA,
    0x0C95, 0x09F9, 0x07B6, 0x0DB6, 0x012A, 0x0904, 0x0454, 0x0FB6,
    0x0960, 0x08D4, 0x0495, 0x0F80, 0x0560, 0x0B04, 0x057A, 0x0079,
    0x0795, 0x0E7D, 0x0060, 0x076A, 0x03B6, 0x0395, 0x0180, 0x02A0,
    0x006A, 0x0195, 0x0295, 0x0646, 0x03FD, 0x01F9, 0x0154, 0x0DF9,
    0x00C6, 0x0F95, 0x01F6, 0x0480, 0x0000, 0x0A79, 0x04AA, 0x00E0,
    0x0246, 0x001A, 0x0479, 0x0015, 0x0D60, 0x0280, 0x0018, 0x01EA,
    0x037A, 0x003A, 0x011D, 0x00FD, 0x0035, 0x0A7D, 0x04A0, 0x0146,
    0x0024, 0x01B6, 0x0504, 0x0046, 0x0020, 0x0009, 0x00D4, 0x03AA,
    0x0679, 0x026A, 0x0036, 0x0008, 0x02F6, 0x01AA, 0x016A, 0x0254,
    0x0039, 0x000D, 0x0004, 0x0176, 0x02EA, 0x007A, 0x0076, 0x0016,
    0x0001, 0x0879, 0x0058, 0x0014, 0x00D5, 0x005D, 0x0034, 0x000C,
    0x0007,
};

static const uint8_t ac_vlc_desc1_bits[169] = {
     6, 12,  8,  7,  8,  7,  6,  4,
     3, 10, 10, 11,  9,  9,  6,  4,
    11, 10, 10, 10,  7,  5, 12, 11,
    11, 11,  8,  5, 12, 11, 11, 12,
     9,  6, 12, 12, 11,  9,  6, 12,
    12, 10,  7, 11, 10,  7, 11,  7,
    11,  8, 11,  8, 11, 11,  8, 11,
     9, 12,  9, 12,  9, 12,  9, 12,
     9, 12, 10, 10, 12, 10, 12, 10,
    11, 11, 10, 11, 11, 11, 12, 12,
    12, 12, 12, 12, 12, 12, 11, 12,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 11, 11, 11, 11, 10, 10,
    10, 10, 10, 11, 10, 12,  9, 12,
     9, 12,  9, 11,  8, 12, 11,  8,
    11,  8, 11,  8, 12, 10,  7, 12,
    10,  7, 11, 10,  7, 12, 11,  9,
     6, 11, 11, 12,  8,  6, 12, 10,
    11, 11,  8,  5, 11, 10, 10, 10,
     7,  5, 10,  9, 11,  9,  9,  6,
     4, 12,  8,  7,  8,  7,  6,  4,
     3,
};

static const uint16_t ac_vlc_desc2_syms[165] = {
   0x1000, 0xFF8, 0xFF7, 0xFF6, 0xFF5, 0xFF4, 0xFF3, 0xFF2,
    0xFF1, 0xFF0, 0xFE6, 0xFE5, 0xFE4, 0xFE3, 0xFE2, 0xFE1,
    0xFE0, 0xFD6, 0xFD5, 0xFD3, 0xFD2, 0xFD1, 0xFD0, 0xFC6,
    0xFC5, 0xFC3, 0xFC2, 0xFC1, 0xFC0, 0xFB6, 0xFB5, 0xFB3,
    0xFB2, 0xFB1, 0xFB0, 0xFA5, 0xFA3, 0xFA1, 0xFA0, 0xF95,
    0xF93, 0xF91, 0xF90, 0xF81, 0xF80, 0xF75, 0xF71, 0xF70,
    0xF61, 0xF60, 0xF51, 0xF50, 0xF41, 0xF40, 0xF36, 0xF31,
    0xF30, 0xF26, 0xF21, 0xF20, 0xF16, 0xF11, 0xF10, 0xF06,
    0xF01, 0xF00, 0xEF1, 0xEF0, 0xEE1, 0xEE0, 0xED0, 0xEC0,
    0xEB3, 0xEB1, 0xEB0, 0xEA3, 0xEA1, 0xEA0, 0xE90, 0xE81,
    0xE80, 0xE71, 0xE70, 0xE61, 0xE60, 0xE50, 0xE40, 0xE30,
    0xE10, 0xE00, 0x241, 0x240, 0x231, 0x1D0, 0x1C0, 0x1B3,
    0x1B0, 0x1A0, 0x190, 0x180, 0x170, 0x160, 0x150, 0x140,
    0x130, 0x120, 0x110, 0x100, 0x0F0, 0x0E0, 0x0D1, 0x0D0,
    0x0C1, 0x0C0, 0x0B1, 0x0B0, 0x0A5, 0x0A1, 0x0A0, 0x096,
    0x095, 0x091, 0x090, 0x086, 0x085, 0x081, 0x080, 0x075,
    0x071, 0x070, 0x065, 0x063, 0x061, 0x060, 0x055, 0x053,
    0x052, 0x051, 0x050, 0x045, 0x043, 0x042, 0x041, 0x040,
    0x036, 0x035, 0x033, 0x032, 0x031, 0x030, 0x026, 0x025,
    0x024, 0x023, 0x022, 0x021, 0x020, 0x018, 0x016, 0x015,
    0x014, 0x013, 0x012, 0x011, 0x010,
};

static const uint16_t ac_vlc_desc2_codes[165] = {
    0x0034, 0x059C, 0x0280, 0x001C, 0x004C, 0x00BD, 0x0020, 0x003C,
    0x000A, 0x0003, 0x00FD, 0x008C, 0x0332, 0x01D5, 0x0055, 0x003E,
    0x0001, 0x07E4, 0x0264, 0x00B2, 0x00A2, 0x005C, 0x0005, 0x02A2,
    0x011D, 0x0132, 0x076C, 0x0012, 0x0018, 0x01E4, 0x05E4, 0x02B2,
    0x0432, 0x017D, 0x000E, 0x055D, 0x0955, 0x0164, 0x0028, 0x0D62,
    0x0B24, 0x02DE, 0x001E, 0x0340, 0x0014, 0x0555, 0x0180, 0x00DD,
    0x01B2, 0x0092, 0x036C, 0x00EC, 0x00E4, 0x00C0, 0x0C64, 0x095D,
    0x01DE, 0x0AE4, 0x0C32, 0x01A2, 0x06E4, 0x0832, 0x01A4, 0x015D,
    0x0732, 0x031D, 0x0F9C, 0x03E2, 0x09E2, 0x02FD, 0x0224, 0x051D,
    0x02E4, 0x019C, 0x05B2, 0x0355, 0x0064, 0x016C, 0x038C, 0x0880,
    0x0480, 0x06B2, 0x0540, 0x0080, 0x075D, 0x0155, 0x0424, 0x0680,
    0x0A62, 0x0A80, 0x078C, 0x0D9C, 0x0F8C, 0x0562, 0x0FF2, 0x0464,
    0x0B55, 0x01E2, 0x0032, 0x07F2, 0x0140, 0x03E4, 0x0662, 0x0755,
    0x0380, 0x026C, 0x0232, 0x001D, 0x0040, 0x00E2, 0x035D, 0x00F2,
    0x0162, 0x01FD, 0x03F2, 0x000C, 0x0EA2, 0x05F2, 0x0072, 0x04E4,
    0x0F32, 0x018C, 0x009D, 0x0324, 0x079C, 0x006C, 0x0054, 0x0F5D,
    0x021D, 0x0015, 0x0024, 0x06A2, 0x009C, 0x0004, 0x0062, 0x056C,
    0x0262, 0x0000, 0x002E, 0x01F2, 0x0124, 0x039C, 0x005E, 0x0010,
    0x0724, 0x00A4, 0x00DE, 0x0362, 0x0052, 0x000D, 0x03B2, 0x007D,
    0x05E2, 0x00D5, 0x005D, 0x0035, 0x0009, 0x099C, 0x0022, 0x002C,
    0x003D, 0x0008, 0x0002, 0x0006, 0x0007,
};

static const uint8_t ac_vlc_desc2_bits[165] = {
     6, 12, 12,  8,  7,  8,  6,  6,
     4,  3, 10,  9, 11,  9,  9,  6,
     4, 11, 10, 10, 10,  7,  5, 11,
    11, 10, 11,  8,  5, 11, 11, 11,
    12,  9,  6, 11, 12,  9,  6, 12,
    12, 10,  7, 10,  7, 11, 10,  8,
    11,  8, 11,  8, 11,  8, 12, 12,
     9, 12, 12,  9, 11, 12,  9, 12,
    12, 10, 12, 10, 12, 10, 10, 11,
    12, 12, 11, 12, 11, 11, 11, 12,
    11, 11, 11, 12, 12, 12, 11, 11,
    12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 11, 11, 11, 11,
    10, 10, 10, 10,  9,  9, 11,  9,
    11,  9, 11,  8, 12, 11,  8, 11,
    12, 10,  8, 12, 12, 10,  7, 12,
    10,  7, 11, 12,  9,  6, 10, 11,
    12,  8,  6, 11, 10, 11,  8,  5,
    11,  9, 10, 10,  7,  5, 10,  9,
    11,  9,  9,  6,  4, 12,  8,  7,
     8,  6,  6,  4,  3,
};

static const uint16_t ac_vlc_desc3_syms[162] = {
   0x1000, 0xFF8, 0xFF7, 0xFF6, 0xFF5, 0xFF4, 0xFF3, 0xFF2,
    0xFF1, 0xFF0, 0xFE6, 0xFE5, 0xFE4, 0xFE3, 0xFE2, 0xFE1,
    0xFE0, 0xFD6, 0xFD5, 0xFD4, 0xFD3, 0xFD2, 0xFD1, 0xFD0,
    0xFC6, 0xFC5, 0xFC3, 0xFC2, 0xFC1, 0xFC0, 0xFB5, 0xFB3,
    0xFB2, 0xFB1, 0xFB0, 0xFA5, 0xFA3, 0xFA1, 0xFA0, 0xF95,
    0xF93, 0xF91, 0xF90, 0xF85, 0xF83, 0xF81, 0xF80, 0xF71,
    0xF70, 0xF66, 0xF61, 0xF60, 0xF56, 0xF51, 0xF50, 0xF46,
    0xF41, 0xF40, 0xF36, 0xF31, 0xF30, 0xF26, 0xF21, 0xF20,
    0xF11, 0xF10, 0xF01, 0xF00, 0xEF3, 0xEF1, 0xEF0, 0xEE3,
    0xEE1, 0xEE0, 0xED3, 0xED1, 0xED0, 0xEC1, 0xEC0, 0xEB1,
    0xEB0, 0xEA0, 0xE90, 0xE80, 0xE70, 0x1E1, 0x1D1, 0x1D0,
    0x1C1, 0x1B1, 0x1A1, 0x180, 0x170, 0x163, 0x160, 0x150,
    0x140, 0x130, 0x123, 0x120, 0x113, 0x110, 0x100, 0x0F0,
    0x0E0, 0x0D1, 0x0D0, 0x0C1, 0x0C0, 0x0B1, 0x0B0, 0x0A1,
    0x0A0, 0x095, 0x091, 0x090, 0x085, 0x081, 0x080, 0x076,
    0x075, 0x073, 0x071, 0x070, 0x066, 0x065, 0x063, 0x061,
    0x060, 0x055, 0x053, 0x052, 0x051, 0x050, 0x045, 0x043,
    0x042, 0x041, 0x040, 0x036, 0x035, 0x034, 0x033, 0x032,
    0x031, 0x030, 0x026, 0x025, 0x024, 0x023, 0x022, 0x021,
    0x020, 0x018, 0x017, 0x016, 0x015, 0x014, 0x013, 0x012,
    0x011, 0x010,
};

static const uint16_t ac_vlc_desc3_codes[162] = {
    0x001D, 0x087C, 0x0AE8, 0x003A, 0x001C, 0x0008, 0x000C, 0x0032,
    0x0006, 0x0003, 0x03A5, 0x01EC, 0x01A5, 0x0080, 0x0030, 0x0005,
    0x0001, 0x0040, 0x03FC, 0x02D4, 0x0154, 0x02FC, 0x003C, 0x0015,
    0x051A, 0x0000, 0x02EC, 0x077C, 0x00D2, 0x0018, 0x03E8, 0x04EC,
    0x027C, 0x01FA, 0x0022, 0x0765, 0x0EA5, 0x0054, 0x0010, 0x08EC,
    0x0AAC, 0x03BA, 0x0042, 0x065D, 0x0AD4, 0x005C, 0x0028, 0x03C0,
    0x00E5, 0x035C, 0x04FA, 0x00DC, 0x06A5, 0x075C, 0x00C8, 0x05A5,
    0x04D4, 0x00BA, 0x01C0, 0x05E8, 0x012C, 0x00E8, 0x01B0, 0x00B0,
    0x025D, 0x002C, 0x0A52, 0x025C, 0x01E8, 0x00FA, 0x0348, 0x0652,
    0x0B7C, 0x0365, 0x031A, 0x0E52, 0x011A, 0x0200, 0x01BA, 0x02AC,
    0x06D4, 0x01FC, 0x05BA, 0x0DFC, 0x0248, 0x0EE8, 0x0B1A, 0x0CFC,
    0x0F65, 0x0B5C, 0x0DC0, 0x007C, 0x0548, 0x08A5, 0x00FC, 0x03B0,
    0x0148, 0x06AC, 0x0252, 0x071A, 0x02E8, 0x0240, 0x00AC, 0x021A,
    0x0140, 0x08E8, 0x01AC, 0x00EC, 0x0152, 0x00A5, 0x0068, 0x001A,
    0x006C, 0x05C0, 0x015C, 0x0025, 0x05B0, 0x017C, 0x0014, 0x047C,
    0x00D4, 0x06E8, 0x00C0, 0x0002, 0x0A5D, 0x04E8, 0x0A7C, 0x01D4,
    0x0020, 0x04A5, 0x07B0, 0x037C, 0x015D, 0x002A, 0x005D, 0x0048,
    0x067C, 0x007A, 0x0004, 0x04FC, 0x02FA, 0x0648, 0x0100, 0x0052,
    0x005A, 0x000D, 0x0165, 0x0065, 0x02A5, 0x0070, 0x00F0, 0x003D,
    0x0009, 0x05FC, 0x0E48, 0x009A, 0x0012, 0x00DD, 0x0034, 0x000A,
    0x000E, 0x0007,
};

static const uint8_t ac_vlc_desc3_bits[162] = {
     7, 12, 12,  8,  7,  7,  6,  6,
     4,  3, 10,  9, 11,  8,  8,  6,
     4, 10, 10, 12,  9, 10,  7,  5,
    11, 10, 10, 11,  8,  5, 10, 11,
    12,  9,  6, 12, 12,  9,  6, 12,
    12, 10,  7, 11, 12, 10,  7, 10,
     8, 12, 11,  8, 12, 11,  8, 11,
    11,  9, 11, 11,  9, 12, 11,  9,
    12,  9, 12, 10, 11, 11, 10, 12,
    12, 11, 12, 12, 11, 10, 11, 12,
    11, 11, 11, 12, 11, 12, 12, 12,
    12, 12, 12, 12, 11, 12, 11, 11,
    11, 11, 12, 11, 12, 10, 10, 10,
     9, 12,  9, 12,  9, 12,  8, 10,
     8, 12, 10,  8, 11, 10,  7, 11,
    11, 12,  9,  7, 12, 11, 12,  9,
     6, 11, 11, 12,  9,  6, 10, 10,
    11,  8,  5, 12, 10, 12,  9, 10,
     7,  5, 10,  9, 11,  8,  8,  6,
     4, 12, 12,  8,  7,  8,  6,  6,
     4,  3,
};

static const uint16_t ac_vlc_desc4_syms[131] = {
   0x1000, 0xFF6, 0xFF5, 0xFF4, 0xFF3, 0xFF2, 0xFF1, 0xFF0,
    0xFE6, 0xFE5, 0xFE4, 0xFE3, 0xFE2, 0xFE1, 0xFE0, 0xFD6,
    0xFD5, 0xFD3, 0xFD2, 0xFD1, 0xFD0, 0xFC5, 0xFC3, 0xFC2,
    0xFC1, 0xFC0, 0xFB5, 0xFB3, 0xFB1, 0xFB0, 0xFA5, 0xFA3,
    0xFA1, 0xFA0, 0xF93, 0xF91, 0xF90, 0xF81, 0xF80, 0xF76,
    0xF71, 0xF70, 0xF66, 0xF61, 0xF60, 0xF56, 0xF51, 0xF50,
    0xF41, 0xF40, 0xF31, 0xF30, 0xF23, 0xF21, 0xF20, 0xF13,
    0xF11, 0xF10, 0xF03, 0xF01, 0xF00, 0xEF1, 0xEF0, 0xEE0,
    0xED0, 0xEC0, 0xEB0, 0x191, 0x181, 0x180, 0x171, 0x161,
    0x140, 0x130, 0x123, 0x120, 0x110, 0x100, 0x0F3, 0x0F0,
    0x0E0, 0x0D0, 0x0C0, 0x0B1, 0x0B0, 0x0A1, 0x0A0, 0x091,
    0x090, 0x085, 0x081, 0x080, 0x075, 0x071, 0x070, 0x066,
    0x065, 0x063, 0x061, 0x060, 0x056, 0x055, 0x053, 0x051,
    0x050, 0x045, 0x043, 0x042, 0x041, 0x040, 0x036, 0x035,
    0x033, 0x032, 0x031, 0x030, 0x026, 0x025, 0x024, 0x023,
    0x022, 0x021, 0x020, 0x018, 0x016, 0x015, 0x014, 0x013,
    0x012, 0x011, 0x010,
};

static const uint16_t ac_vlc_desc4_codes[131] = {
    0x006B, 0x00BE, 0x0052, 0x00F3, 0x005B, 0x003A, 0x0009, 0x0007,
    0x00DA, 0x03FB, 0x0123, 0x00B3, 0x01B3, 0x002E, 0x0006, 0x030A,
    0x005A, 0x004A, 0x034A, 0x0072, 0x0005, 0x02DA, 0x0173, 0x04FB,
    0x0032, 0x0013, 0x039B, 0x0B9B, 0x011E, 0x0002, 0x00FB, 0x021E,
    0x009B, 0x007E, 0x0E1A, 0x03CA, 0x007B, 0x02FB, 0x0033, 0x03AB,
    0x0463, 0x008A, 0x0773, 0x041E, 0x002B, 0x031B, 0x065A, 0x011A,
    0x060A, 0x01DA, 0x0963, 0x0323, 0x0BAB, 0x059E, 0x010A, 0x05AB,
    0x0CFB, 0x071B, 0x079E, 0x0F9E, 0x0263, 0x079B, 0x0563, 0x019E,
    0x01AB, 0x0E63, 0x029B, 0x04CA, 0x0DAB, 0x0663, 0x0B1B, 0x020A,
    0x0A1E, 0x021A, 0x0063, 0x061E, 0x06FB, 0x025A, 0x0163, 0x0573,
    0x000A, 0x0223, 0x011B, 0x0C1A, 0x015A, 0x0863, 0x00AB, 0x02CA,
    0x00B2, 0x0A0A, 0x01CA, 0x00A3, 0x0B73, 0x0023, 0x0012, 0x039E,
    0x001A, 0x0CCA, 0x01FB, 0x005E, 0x0A9B, 0x00CA, 0x0373, 0x009E,
    0x0022, 0x07AB, 0x001E, 0x0EFB, 0x009A, 0x000B, 0x041A, 0x019B,
    0x0363, 0x014A, 0x006A, 0x0015, 0x069B, 0x0073, 0x0523, 0x001B,
    0x012B, 0x0003, 0x0001, 0x061A, 0x003E, 0x002A, 0x00E3, 0x003B,
    0x000E, 0x000D, 0x0000,
};

static const uint8_t ac_vlc_desc4_bits[131] = {
     7,  8,  7,  8,  7,  6,  4,  3,
    10, 10, 11,  9,  9,  6,  4, 10,
    10,  9, 10,  7,  5, 10, 11, 12,
     8,  6, 12, 12,  9,  6, 11, 12,
    10,  7, 12, 10,  8, 11,  8, 12,
    11,  8, 11, 11,  9, 12, 11,  9,
    11,  9, 12, 10, 12, 11, 10, 12,
    12, 11, 12, 12, 11, 11, 11, 11,
    11, 12, 12, 12, 12, 12, 12, 12,
    12, 11, 12, 11, 12, 11, 12, 11,
    10, 10, 10, 12,  9, 12,  9, 10,
     8, 12, 10,  8, 12, 10,  7, 11,
    11, 12, 10,  7, 12, 11, 12,  9,
     6, 11, 11, 12,  8,  6, 12, 10,
    10, 10,  7,  5, 11,  9, 11,  9,
     9,  6,  4, 12,  8,  7,  8,  7,
     6,  4,  2,
};

static const uint16_t ac_vlc_desc5_syms[132] = {
   0x1000, 0xFF8, 0xFF6, 0xFF5, 0xFF4, 0xFF3, 0xFF2, 0xFF1,
    0xFF0, 0xFE6, 0xFE5, 0xFE4, 0xFE3, 0xFE2, 0xFE1, 0xFE0,
    0xFD6, 0xFD5, 0xFD4, 0xFD3, 0xFD2, 0xFD1, 0xFD0, 0xFC5,
    0xFC3, 0xFC2, 0xFC1, 0xFC0, 0xFB5, 0xFB3, 0xFB1, 0xFB0,
    0xFA3, 0xFA1, 0xFA0, 0xF96, 0xF93, 0xF91, 0xF90, 0xF86,
    0xF85, 0xF81, 0xF80, 0xF76, 0xF75, 0xF71, 0xF70, 0xF66,
    0xF61, 0xF60, 0xF51, 0xF50, 0xF43, 0xF41, 0xF40, 0xF33,
    0xF31, 0xF30, 0xF23, 0xF21, 0xF20, 0xF11, 0xF10, 0xF00,
    0xEF0, 0xEE0, 0xEC1, 0xEC0, 0x151, 0x141, 0x140, 0x131,
    0x121, 0x120, 0x111, 0x110, 0x103, 0x100, 0x0F0, 0x0E0,
    0x0D3, 0x0D0, 0x0C3, 0x0C1, 0x0C0, 0x0B1, 0x0B0, 0x0A1,
    0x0A0, 0x091, 0x090, 0x081, 0x080, 0x075, 0x071, 0x070,
    0x065, 0x061, 0x060, 0x056, 0x055, 0x053, 0x052, 0x051,
    0x050, 0x046, 0x045, 0x043, 0x042, 0x041, 0x040, 0x035,
    0x034, 0x033, 0x032, 0x031, 0x030, 0x026, 0x025, 0x024,
    0x023, 0x022, 0x021, 0x020, 0x018, 0x016, 0x015, 0x014,
    0x013, 0x012, 0x011, 0x010,
};

static const uint16_t ac_vlc_desc5_codes[132] = {
    0x0001, 0x0D62, 0x00BD, 0x0022, 0x009B, 0x0032, 0x0019, 0x0005,
    0x0007, 0x034D, 0x009A, 0x012B, 0x0052, 0x006B, 0x003A, 0x0006,
    0x06FD, 0x017D, 0x081A, 0x031B, 0x031A, 0x0012, 0x0011, 0x0202,
    0x00FD, 0x051B, 0x00D2, 0x001D, 0x011A, 0x0782, 0x018D, 0x007B,
    0x067D, 0x037D, 0x0021, 0x0E8D, 0x0562, 0x008D, 0x00BB, 0x053D,
    0x082A, 0x0002, 0x000D, 0x0302, 0x007D, 0x053B, 0x003B, 0x0A4D,
    0x027D, 0x01FD, 0x042A, 0x01C2, 0x041A, 0x0182, 0x014D, 0x0162,
    0x00C2, 0x032A, 0x0D9A, 0x012A, 0x0102, 0x087D, 0x072B, 0x039A,
    0x0362, 0x019A, 0x0C62, 0x04C2, 0x0D1B, 0x028D, 0x0762, 0x0E7D,
    0x0E41, 0x059A, 0x024D, 0x093B, 0x052B, 0x011B, 0x064D, 0x013D,
    0x0382, 0x0262, 0x0641, 0x0462, 0x004D, 0x0CC2, 0x033B, 0x068D,
    0x0141, 0x0D2B, 0x001B, 0x0041, 0x00C1, 0x0C41, 0x01E2, 0x00EB,
    0x062A, 0x0082, 0x0061, 0x02FD, 0x047D, 0x013B, 0x002A, 0x003D,
    0x005B, 0x022A, 0x02C2, 0x0241, 0x0062, 0x00AA, 0x000B, 0x00E2,
    0x001A, 0x033D, 0x021A, 0x006A, 0x0009, 0x032B, 0x002B, 0x04FD,
    0x0042, 0x016B, 0x002D, 0x000E, 0x0441, 0x00CD, 0x005A, 0x00AB,
    0x000A, 0x0039, 0x0003, 0x0000,
};

static const uint8_t ac_vlc_desc5_bits[132] = {
     7, 12,  8,  7,  8,  6,  6,  4,
     3, 10,  9, 11,  8,  9,  6,  4,
    11, 10, 12, 10, 10,  7,  5, 10,
    11, 12,  8,  6, 10, 11,  9,  7,
    12, 10,  7, 12, 12, 10,  8, 11,
    12, 10,  8, 10, 12, 11,  9, 12,
    11,  9, 11,  9, 11, 10, 10, 11,
    11, 10, 12, 10, 10, 12, 11, 10,
    11, 11, 12, 12, 12, 11, 11, 12,
    12, 12, 12, 12, 12, 11, 11, 11,
    11, 10, 12, 12, 10, 12, 10, 12,
     9, 12,  9, 11,  8, 12,  9,  8,
    11,  9,  7, 11, 11, 12, 12,  9,
     7, 11, 10, 11, 11,  8,  6,  9,
    12, 10, 10,  7,  5, 11,  9, 11,
     8,  9,  6,  4, 12,  8,  7,  8,
     6,  6,  4,  2,
};

static const uint16_t ac_vlc_desc6_syms[130] = {
   0x1000, 0xFF8, 0xFF7, 0xFF6, 0xFF5, 0xFF4, 0xFF3, 0xFF2,
    0xFF1, 0xFF0, 0xFE6, 0xFE5, 0xFE4, 0xFE3, 0xFE2, 0xFE1,
    0xFE0, 0xFD6, 0xFD5, 0xFD4, 0xFD3, 0xFD2, 0xFD1, 0xFD0,
    0xFC5, 0xFC3, 0xFC2, 0xFC1, 0xFC0, 0xFB5, 0xFB3, 0xFB1,
    0xFB0, 0xFA6, 0xFA3, 0xFA1, 0xFA0, 0xF96, 0xF95, 0xF93,
    0xF91, 0xF90, 0xF86, 0xF85, 0xF81, 0xF80, 0xF76, 0xF71,
    0xF70, 0xF63, 0xF61, 0xF60, 0xF53, 0xF51, 0xF50, 0xF43,
    0xF41, 0xF40, 0xF31, 0xF30, 0xF20, 0xF10, 0xF00, 0xEF0,
    0xEE1, 0x131, 0x121, 0x120, 0x111, 0x110, 0x101, 0x100,
    0x0F1, 0x0F0, 0x0E3, 0x0E1, 0x0E0, 0x0D1, 0x0D0, 0x0C3,
    0x0C0, 0x0B3, 0x0B1, 0x0B0, 0x0A1, 0x0A0, 0x091, 0x090,
    0x081, 0x080, 0x075, 0x071, 0x070, 0x065, 0x063, 0x061,
    0x060, 0x056, 0x055, 0x053, 0x051, 0x050, 0x046, 0x045,
    0x043, 0x042, 0x041, 0x040, 0x036, 0x035, 0x034, 0x033,
    0x032, 0x031, 0x030, 0x026, 0x025, 0x024, 0x023, 0x022,
    0x021, 0x020, 0x018, 0x016, 0x015, 0x014, 0x013, 0x012,
    0x011, 0x010,
};

static const uint16_t ac_vlc_desc6_codes[130] = {
    0x0022, 0x0BB2, 0x0942, 0x002B, 0x0072, 0x0002, 0x001A, 0x0039,
    0x000D, 0x0007, 0x007B, 0x008E, 0x06DB, 0x00EA, 0x015B, 0x002E,
    0x0006, 0x0959, 0x027B, 0x0A0E, 0x01AB, 0x008A, 0x0012, 0x001E,
    0x0575, 0x005B, 0x02AB, 0x00C2, 0x0015, 0x036A, 0x04B2, 0x0099,
    0x001B, 0x0519, 0x0C19, 0x00DB, 0x004E, 0x0042, 0x0159, 0x03B2,
    0x030E, 0x00EB, 0x0252, 0x0EAB, 0x018A, 0x00E2, 0x06AB, 0x0242,
    0x017B, 0x0452, 0x0319, 0x0152, 0x025B, 0x016A, 0x00AB, 0x0052,
    0x05B2, 0x010E, 0x038E, 0x028A, 0x0359, 0x0019, 0x078A, 0x0C52,
    0x0D8E, 0x0ED9, 0x02D9, 0x0662, 0x0119, 0x09B2, 0x0BAB, 0x0D19,
    0x0C5B, 0x00B2, 0x0542, 0x0B8A, 0x02B2, 0x0142, 0x065B, 0x058E,
    0x0062, 0x018E, 0x038A, 0x00D9, 0x0419, 0x0162, 0x03AB, 0x0075,
    0x07B2, 0x0032, 0x020E, 0x07AB, 0x006B, 0x045B, 0x01B2, 0x0199,
    0x002A, 0x0375, 0x0775, 0x0AAB, 0x01D9, 0x003B, 0x060E, 0x0342,
    0x0175, 0x0262, 0x000A, 0x0005, 0x0559, 0x006A, 0x0D59, 0x0219,
    0x000E, 0x004A, 0x0009, 0x0719, 0x0059, 0x02DB, 0x00D2, 0x01DB,
    0x0025, 0x0001, 0x06D9, 0x00F5, 0x0035, 0x00FB, 0x003A, 0x000B,
    0x0003, 0x0000,
};

static const uint8_t ac_vlc_desc6_bits[130] = {
     7, 12, 12,  8,  7,  7,  6,  6,
     4,  3, 10,  9, 11,  8,  9,  6,
     4, 12, 10, 12, 10, 10,  7,  5,
    11, 11, 12,  8,  6, 10, 11,  9,
     7, 12, 12, 10,  7, 10, 12, 12,
    10,  8, 10, 12, 10,  8, 12, 10,
     9, 12, 11,  9, 11, 10, 10, 11,
    11, 10, 10, 10, 10, 11, 11, 12,
    12, 12, 11, 11, 11, 12, 12, 12,
    12, 11, 11, 12, 10, 12, 11, 12,
    10, 11, 12, 10, 12,  9, 12,  9,
    11,  8, 12, 11,  8, 12, 12,  9,
     7, 11, 11, 12,  9,  7, 11, 10,
    11, 11,  8,  6, 12,  9, 12, 10,
    10,  7,  5, 11,  9, 11,  8,  9,
     6,  4, 12,  8,  7,  8,  6,  6,
     4,  2,
};

static const uint16_t ac_vlc_desc7_syms[125] = {
   0x1000, 0xFF8, 0xFF7, 0xFF6, 0xFF5, 0xFF4, 0xFF3, 0xFF2,
    0xFF1, 0xFF0, 0xFE6, 0xFE5, 0xFE4, 0xFE3, 0xFE2, 0xFE1,
    0xFE0, 0xFD5, 0xFD4, 0xFD3, 0xFD2, 0xFD1, 0xFD0, 0xFC5,
    0xFC3, 0xFC2, 0xFC1, 0xFC0, 0xFB5, 0xFB3, 0xFB1, 0xFB0,
    0xFA6, 0xFA5, 0xFA3, 0xFA1, 0xFA0, 0xF96, 0xF95, 0xF93,
    0xF91, 0xF90, 0xF86, 0xF81, 0xF80, 0xF73, 0xF71, 0xF70,
    0xF63, 0xF61, 0xF60, 0xF53, 0xF51, 0xF50, 0xF41, 0xF40,
    0xF31, 0xF30, 0xF20, 0xF10, 0xF01, 0xF00, 0x121, 0x111,
    0x101, 0x100, 0x0F1, 0x0F0, 0x0E1, 0x0E0, 0x0D1, 0x0D0,
    0x0C3, 0x0C1, 0x0C0, 0x0B1, 0x0B0, 0x0A3, 0x0A1, 0x0A0,
    0x093, 0x091, 0x090, 0x081, 0x080, 0x071, 0x070, 0x065,
    0x063, 0x061, 0x060, 0x055, 0x053, 0x052, 0x051, 0x050,
    0x046, 0x045, 0x043, 0x042, 0x041, 0x040, 0x036, 0x035,
    0x034, 0x033, 0x032, 0x031, 0x030, 0x026, 0x025, 0x024,
    0x023, 0x022, 0x021, 0x020, 0x018, 0x017, 0x016, 0x015,
    0x014, 0x013, 0x012, 0x011, 0x010,
};

static const uint16_t ac_vlc_desc7_codes[125] = {
    0x0053, 0x009A, 0x0EE2, 0x00D3, 0x006A, 0x0052, 0x003A, 0x0035,
    0x000D, 0x0007, 0x0062, 0x0125, 0x0142, 0x0019, 0x01F3, 0x0029,
    0x000E, 0x0082, 0x0ADA, 0x02E3, 0x00E2, 0x0022, 0x0006, 0x0065,
    0x05E3, 0x0765, 0x0032, 0x0039, 0x0F99, 0x05E2, 0x0099, 0x0033,
    0x0362, 0x0799, 0x0F65, 0x0073, 0x004A, 0x02A5, 0x0162, 0x0742,
    0x01A5, 0x00D9, 0x0342, 0x005A, 0x00AA, 0x0EF3, 0x0182, 0x01DA,
    0x0382, 0x035A, 0x00F3, 0x0673, 0x0165, 0x00E5, 0x06F3, 0x0225,
    0x0842, 0x025A, 0x07E3, 0x0399, 0x07A5, 0x072A, 0x0F2A, 0x09E3,
    0x0273, 0x049A, 0x02E5, 0x0B99, 0x02E2, 0x0E73, 0x0562, 0x02F3,
    0x032A, 0x0F42, 0x00DA, 0x0999, 0x012A, 0x0365, 0x00A5, 0x00E3,
    0x0199, 0x03E3, 0x019A, 0x01E2, 0x0173, 0x06E5, 0x0059, 0x01E3,
    0x02DA, 0x002A, 0x000A, 0x06DA, 0x0FA5, 0x0042, 0x01E5, 0x0013,
    0x03E2, 0x015A, 0x03A5, 0x0442, 0x001A, 0x0005, 0x04A5, 0x0265,
    0x08A5, 0x0025, 0x029A, 0x0072, 0x0016, 0x0599, 0x00C2, 0x0242,
    0x00B2, 0x0002, 0x0015, 0x0001, 0x0BE3, 0x06E2, 0x0063, 0x0023,
    0x0012, 0x0009, 0x0003, 0x000B, 0x0000,
};

static const uint8_t ac_vlc_desc7_bits[125] = {
     8, 11, 12,  8,  7,  7,  6,  6,
     4,  3,  9,  9, 10,  8,  9,  6,
     4,  9, 12, 10, 10,  7,  5, 10,
    11, 12,  8,  6, 12, 11,  9,  7,
    10, 12, 12, 10,  7, 10, 11, 12,
    10,  8, 11, 10,  8, 12, 10,  9,
    10, 10, 10, 12, 10, 10, 12, 10,
    12, 10, 11, 12, 12, 12, 12, 12,
    11, 11, 11, 12, 11, 12, 11, 11,
    11, 12, 10, 12, 10, 11, 12, 10,
    12, 12,  9, 11,  9, 11,  8, 12,
    12,  9,  7, 11, 12, 12,  9,  7,
    10, 10, 11, 11,  8,  6, 11, 10,
    12, 10, 10,  7,  5, 11,  8, 10,
     8,  8,  6,  4, 12, 12,  8,  7,
     7,  6,  6,  4,  2,
};

static const uint16_t ac_vlc_desc8_syms[121] = {
   0x1000, 0xFF8, 0xFF7, 0xFF6, 0xFF5, 0xFF4, 0xFF3, 0xFF2,
    0xFF1, 0xFF0, 0xFE6, 0xFE5, 0xFE4, 0xFE3, 0xFE2, 0xFE1,
    0xFE0, 0xFD5, 0xFD4, 0xFD3, 0xFD2, 0xFD1, 0xFD0, 0xFC5,
    0xFC3, 0xFC2, 0xFC1, 0xFC0, 0xFB6, 0xFB5, 0xFB3, 0xFB1,
    0xFB0, 0xFA6, 0xFA5, 0xFA3, 0xFA1, 0xFA0, 0xF96, 0xF95,
    0xF93, 0xF91, 0xF90, 0xF86, 0xF83, 0xF81, 0xF80, 0xF73,
    0xF71, 0xF70, 0xF63, 0xF61, 0xF60, 0xF51, 0xF50, 0xF41,
    0xF40, 0xF30, 0xF21, 0xF20, 0x111, 0x101, 0x0F1, 0x0E1,
    0x0E0, 0x0D1, 0x0D0, 0x0C1, 0x0C0, 0x0B3, 0x0B1, 0x0B0,
    0x0A3, 0x0A1, 0x0A0, 0x093, 0x091, 0x090, 0x083, 0x081,
    0x080, 0x073, 0x071, 0x070, 0x065, 0x063, 0x061, 0x060,
    0x055, 0x053, 0x051, 0x050, 0x046, 0x045, 0x043, 0x042,
    0x041, 0x040, 0x036, 0x035, 0x034, 0x033, 0x032, 0x031,
    0x030, 0x026, 0x025, 0x024, 0x023, 0x022, 0x021, 0x020,
    0x018, 0x017, 0x016, 0x015, 0x014, 0x013, 0x012, 0x011,
    0x010,
};

static const uint16_t ac_vlc_desc8_codes[121] = {
    0x00F6, 0x0676, 0x0EB6, 0x00F3, 0x0056, 0x006A, 0x0039, 0x0003,
    0x000D, 0x0007, 0x00A2, 0x0173, 0x00CA, 0x0025, 0x0082, 0x0019,
    0x0001, 0x00B6, 0x0276, 0x02E3, 0x00B2, 0x0062, 0x001A, 0x0175,
    0x01E3, 0x0BE5, 0x004A, 0x0029, 0x07A5, 0x00E3, 0x030A, 0x0176,
    0x0023, 0x0042, 0x05CA, 0x00A5, 0x0142, 0x0052, 0x04A5, 0x0B02,
    0x0D22, 0x0375, 0x0065, 0x0522, 0x0DE3, 0x010A, 0x00F5, 0x0136,
    0x0275, 0x01B2, 0x03F5, 0x03E3, 0x0002, 0x08E3, 0x01A2, 0x0B36,
    0x020A, 0x0076, 0x0CE3, 0x07E5, 0x070A, 0x03A5, 0x02B6, 0x0036,
    0x01E5, 0x02A5, 0x05E3, 0x07B6, 0x07F5, 0x0736, 0x0BA5, 0x0075,
    0x0302, 0x0FE5, 0x01B6, 0x0102, 0x04E3, 0x0022, 0x08A5, 0x01CA,
    0x00E5, 0x0F0A, 0x05E5, 0x0096, 0x0A76, 0x0336, 0x0236, 0x0012,
    0x03B6, 0x0BF5, 0x0073, 0x0035, 0x02B2, 0x000A, 0x0476, 0x0122,
    0x0016, 0x0009, 0x0322, 0x01F5, 0x03E5, 0x01A5, 0x03CA, 0x0072,
    0x0006, 0x06A5, 0x0032, 0x02CA, 0x008A, 0x00C2, 0x0015, 0x000E,
    0x0702, 0x06B6, 0x0063, 0x0033, 0x002A, 0x0005, 0x0013, 0x000B,
    0x0000,
};

static const uint8_t ac_vlc_desc8_bits[121] = {
     8, 11, 12,  8,  7,  7,  6,  6,
     4,  3,  9,  9, 10,  8,  8,  6,
     4, 10, 12, 10, 10,  7,  5, 10,
    11, 12,  8,  6, 11, 12, 11,  9,
     7,  9, 11, 12,  9,  7, 11, 12,
    12, 10,  8, 12, 12, 10,  9, 10,
    10,  9, 12, 10,  9, 12,  9, 12,
    10, 11, 12, 12, 12, 12, 11, 10,
    11, 11, 12, 11, 11, 11, 12, 10,
    12, 12, 10, 10, 12,  9, 12, 11,
     9, 12, 11,  8, 12, 12, 10,  7,
    11, 12,  9,  7, 10, 10, 11, 11,
     8,  6, 10, 10, 12, 10, 10,  7,
     5, 11,  8, 10,  8,  8,  6,  4,
    11, 12,  8,  7,  7,  6,  6,  4,
     2,
};

static const uint16_t ac_vlc_desc9_syms[114] = {
   0x1000, 0xFF8, 0xFF7, 0xFF6, 0xFF5, 0xFF4, 0xFF3, 0xFF2,
    0xFF1, 0xFF0, 0xFE6, 0xFE5, 0xFE4, 0xFE3, 0xFE2, 0xFE1,
    0xFE0, 0xFD5, 0xFD4, 0xFD3, 0xFD2, 0xFD1, 0xFD0, 0xFC5,
    0xFC3, 0xFC2, 0xFC1, 0xFC0, 0xFB6, 0xFB5, 0xFB3, 0xFB2,
    0xFB1, 0xFB0, 0xFA6, 0xFA5, 0xFA3, 0xFA1, 0xFA0, 0xF96,
    0xF93, 0xF91, 0xF90, 0xF83, 0xF81, 0xF80, 0xF73, 0xF71,
    0xF70, 0xF61, 0xF60, 0xF51, 0xF50, 0xF40, 0xF31, 0xF30,
    0xF21, 0x121, 0x0F1, 0x0E1, 0x0D1, 0x0D0, 0x0C1, 0x0C0,
    0x0B1, 0x0B0, 0x0A3, 0x0A1, 0x0A0, 0x093, 0x091, 0x090,
    0x083, 0x081, 0x080, 0x073, 0x071, 0x070, 0x065, 0x063,
    0x061, 0x060, 0x055, 0x053, 0x051, 0x050, 0x045, 0x043,
    0x042, 0x041, 0x040, 0x036, 0x035, 0x034, 0x033, 0x032,
    0x031, 0x030, 0x026, 0x025, 0x024, 0x023, 0x022, 0x021,
    0x020, 0x018, 0x017, 0x016, 0x015, 0x014, 0x013, 0x012,
    0x011, 0x010,
};

static const uint16_t ac_vlc_desc9_codes[114] = {
    0x0061, 0x0403, 0x0DB1, 0x0012, 0x0071, 0x0056, 0x0035, 0x0023,
    0x000D, 0x0007, 0x0243, 0x01D3, 0x026A, 0x00A1, 0x00A2, 0x0011,
    0x000E, 0x01AA, 0x0531, 0x0093, 0x0222, 0x0032, 0x0006, 0x07F2,
    0x04D3, 0x0C43, 0x0072, 0x0001, 0x0343, 0x05F2, 0x04AA, 0x03F2,
    0x0031, 0x0045, 0x0143, 0x00AA, 0x0B31, 0x00F2, 0x00C3, 0x0693,
    0x0BF2, 0x0203, 0x00E1, 0x03B1, 0x02D3, 0x00B1, 0x056A, 0x01D2,
    0x008A, 0x046A, 0x01E2, 0x0003, 0x0103, 0x01B1, 0x02E2, 0x0293,
    0x016A, 0x04E2, 0x0443, 0x0521, 0x0321, 0x0043, 0x00D3, 0x00E2,
    0x0703, 0x00D2, 0x0731, 0x0A93, 0x0393, 0x0803, 0x0422, 0x0383,
    0x018A, 0x006A, 0x0021, 0x096A, 0x0303, 0x0052, 0x0CE2, 0x0D31,
    0x038A, 0x0013, 0x01F2, 0x0E93, 0x0083, 0x0005, 0x02D2, 0x0121,
    0x0022, 0x00EA, 0x0036, 0x0122, 0x0193, 0x0331, 0x0183, 0x02AA,
    0x004A, 0x001A, 0x0131, 0x002A, 0x036A, 0x000A, 0x0062, 0x0025,
    0x0009, 0x06E2, 0x05B1, 0x0053, 0x0002, 0x0016, 0x0015, 0x0033,
    0x000B, 0x0000,
};

static const uint8_t ac_vlc_desc9_bits[114] = {
     8, 11, 12,  7,  7,  7,  6,  6,
     4,  3, 10,  9, 10,  8,  8,  6,
     4,  9, 12, 10, 10,  7,  5, 11,
    11, 12,  8,  6, 10, 11, 11, 12,
     9,  7, 10, 11, 12,  9,  8, 12,
    12, 10,  8, 10, 10,  9, 11,  9,
     9, 11,  9, 12, 10, 11, 11, 12,
    12, 12, 12, 11, 10, 11, 11, 11,
    11, 10, 11, 12, 10, 12, 11, 10,
    10, 11,  9, 12, 11,  8, 12, 12,
    10,  8, 11, 12,  9,  7, 10, 11,
    11,  8,  6,  9, 10, 12, 10, 10,
     7,  5, 11,  8, 10,  8,  8,  6,
     4, 11, 12,  8,  6,  7,  6,  6,
     4,  2,
};

static const uint16_t ac_vlc_descA_syms[110] = {
   0x1000, 0xFF8, 0xFF7, 0xFF6, 0xFF5, 0xFF4, 0xFF3, 0xFF2,
    0xFF1, 0xFF0, 0xFE6, 0xFE5, 0xFE4, 0xFE3, 0xFE2, 0xFE1,
    0xFE0, 0xFD5, 0xFD4, 0xFD3, 0xFD2, 0xFD1, 0xFD0, 0xFC6,
    0xFC5, 0xFC3, 0xFC2, 0xFC1, 0xFC0, 0xFB6, 0xFB5, 0xFB3,
    0xFB2, 0xFB1, 0xFB0, 0xFA6, 0xFA5, 0xFA3, 0xFA1, 0xFA0,
    0xF96, 0xF93, 0xF91, 0xF90, 0xF83, 0xF81, 0xF80, 0xF73,
    0xF71, 0xF70, 0xF61, 0xF60, 0xF51, 0xF50, 0xF41, 0xF40,
    0xF31, 0x0E1, 0x0D1, 0x0C1, 0x0C0, 0x0B1, 0x0B0, 0x0A1,
    0x0A0, 0x093, 0x091, 0x090, 0x083, 0x081, 0x080, 0x073,
    0x071, 0x070, 0x063, 0x061, 0x060, 0x055, 0x053, 0x051,
    0x050, 0x045, 0x044, 0x043, 0x042, 0x041, 0x040, 0x036,
    0x035, 0x034, 0x033, 0x032, 0x031, 0x030, 0x026, 0x025,
    0x024, 0x023, 0x022, 0x021, 0x020, 0x018, 0x017, 0x016,
    0x015, 0x014, 0x013, 0x012, 0x011, 0x010,
};

static const uint16_t ac_vlc_descA_codes[110] = {
    0x002A, 0x04C5, 0x02A3, 0x004A, 0x0015, 0x0005, 0x0003, 0x0013,
    0x000D, 0x0007, 0x0171, 0x0032, 0x0371, 0x0076, 0x0042, 0x0011,
    0x000E, 0x00AA, 0x04D5, 0x03A3, 0x06A3, 0x0062, 0x001A, 0x06D5,
    0x07F2, 0x0223, 0x0CD5, 0x006A, 0x0001, 0x00F6, 0x0623, 0x03F2,
    0x07EA, 0x01F1, 0x0021, 0x03D5, 0x08C2, 0x07F6, 0x00F2, 0x00E3,
    0x0FEA, 0x02C5, 0x01AA, 0x0082, 0x04A3, 0x00B6, 0x0071, 0x03B2,
    0x0023, 0x01B6, 0x08A3, 0x0002, 0x0BB2, 0x00C5, 0x02EA, 0x0C23,
    0x0FF6, 0x0423, 0x07B2, 0x01C5, 0x07D5, 0x01EA, 0x06EA, 0x02C2,
    0x01F6, 0x01D5, 0x01B2, 0x00B2, 0x04F1, 0x03EA, 0x01A2, 0x02A2,
    0x02D5, 0x0123, 0x00D5, 0x01F2, 0x0055, 0x05B2, 0x04C2, 0x0102,
    0x0061, 0x05D5, 0x00C2, 0x00F1, 0x00A3, 0x0045, 0x0016, 0x01A3,
    0x01C2, 0x08D5, 0x03C5, 0x00EA, 0x000A, 0x0006, 0x00A2, 0x0036,
    0x02F1, 0x0072, 0x0022, 0x0025, 0x0009, 0x03F6, 0x0AA3, 0x0063,
    0x0012, 0x0031, 0x0035, 0x0033, 0x000B, 0x0000,
};

static const uint8_t ac_vlc_descA_bits[110] = {
     8, 11, 12,  7,  7,  7,  6,  6,
     4,  3, 10,  8, 10,  8,  8,  6,
     4,  9, 12, 10, 11,  7,  5, 11,
    11, 11, 12,  8,  6,  9, 11, 11,
    12,  9,  7, 11, 12, 12,  9,  8,
    12, 10,  9,  8, 11,  9,  9, 12,
    11,  9, 12,  9, 12, 11, 11, 12,
    12, 12, 11, 10, 11, 10, 11, 10,
    10, 11, 11,  9, 11, 11,  9, 10,
    11,  9, 12, 10,  8, 11, 11,  9,
     7, 11, 12, 11, 12,  8,  6, 10,
     9, 12, 10, 10,  7,  5, 10,  8,
    10,  8,  8,  6,  4, 11, 12,  8,
     6,  7,  6,  6,  4,  2,
};

static const uint16_t ac_vlc_descB_syms[101] = {
   0x1000, 0xFF8, 0xFF7, 0xFF6, 0xFF5, 0xFF4, 0xFF3, 0xFF2,
    0xFF1, 0xFF0, 0xFE6, 0xFE5, 0xFE4, 0xFE3, 0xFE2, 0xFE1,
    0xFE0, 0xFD5, 0xFD4, 0xFD3, 0xFD2, 0xFD1, 0xFD0, 0xFC6,
    0xFC5, 0xFC3, 0xFC2, 0xFC1, 0xFC0, 0xFB6, 0xFB5, 0xFB3,
    0xFB1, 0xFB0, 0xFA6, 0xFA3, 0xFA1, 0xFA0, 0xF93, 0xF91,
    0xF90, 0xF83, 0xF81, 0xF80, 0xF71, 0xF70, 0xF61, 0xF60,
    0xF51, 0xF50, 0xF41, 0x0F1, 0x0D1, 0x0C1, 0x0B1, 0x0B0,
    0x0A1, 0x0A0, 0x091, 0x090, 0x083, 0x081, 0x080, 0x073,
    0x071, 0x070, 0x063, 0x061, 0x060, 0x055, 0x053, 0x051,
    0x050, 0x045, 0x043, 0x042, 0x041, 0x040, 0x036, 0x035,
    0x034, 0x033, 0x032, 0x031, 0x030, 0x026, 0x025, 0x024,
    0x023, 0x022, 0x021, 0x020, 0x018, 0x017, 0x016, 0x015,
    0x014, 0x013, 0x012, 0x011, 0x010,
};

static const uint16_t ac_vlc_descB_codes[101] = {
    0x00EE, 0x03A5, 0x0B73, 0x004E, 0x0035, 0x0015, 0x0023, 0x0013,
    0x000D, 0x0007, 0x0673, 0x01F3, 0x02FE, 0x0096, 0x0133, 0x001E,
    0x0001, 0x0116, 0x00F5, 0x03F5, 0x0473, 0x0052, 0x001A, 0x01D5,
    0x0025, 0x0073, 0x0633, 0x0086, 0x0036, 0x012E, 0x0155, 0x0006,
    0x0055, 0x000E, 0x0106, 0x023E, 0x0192, 0x0075, 0x0173, 0x01AE,
    0x00D5, 0x08F5, 0x002E, 0x01FE, 0x0406, 0x00AE, 0x0E3E, 0x0206,
    0x013E, 0x0373, 0x0D55, 0x063E, 0x0E33, 0x033E, 0x01F5, 0x0273,
    0x003E, 0x06A5, 0x0092, 0x03D5, 0x04F5, 0x053E, 0x0016, 0x00FE,
    0x07A5, 0x0125, 0x0506, 0x0292, 0x00BE, 0x0425, 0x0F73, 0x02F5,
    0x0056, 0x0233, 0x02A5, 0x0C25, 0x007E, 0x0026, 0x0355, 0x0033,
    0x0555, 0x01A5, 0x0306, 0x0046, 0x000A, 0x0225, 0x006E, 0x00A5,
    0x0012, 0x00F3, 0x0005, 0x0009, 0x073E, 0x0773, 0x00B3, 0x0032,
    0x0065, 0x0003, 0x0002, 0x000B, 0x0000,
};

static const uint8_t ac_vlc_descB_bits[101] = {
     8, 11, 12,  7,  7,  7,  6,  6,
     4,  3, 11,  9, 10,  8,  9,  6,
     4,  9, 12, 10, 11,  7,  5, 10,
    11, 11, 12,  8,  6,  9, 11, 11,
     9,  7, 11, 11,  9,  8, 10,  9,
     9, 12,  9,  9, 11,  9, 12, 10,
    11, 12, 12, 12, 12, 11, 10, 11,
    10, 11, 10, 10, 11, 11,  9, 10,
    11,  9, 11, 10,  8, 12, 12, 10,
     7, 11, 11, 12,  8,  6, 10, 10,
    12, 10, 10,  7,  5, 10,  8, 10,
     8,  9,  6,  4, 11, 12,  8,  6,
     7,  6,  5,  4,  2,
};

static const uint16_t ac_vlc_descC_syms[96] = {
    0x1000, 0xFF8, 0xFF7, 0xFF6, 0xFF5, 0xFF4, 0xFF3, 0xFF2,
    0xFF1, 0xFF0, 0xFE6, 0xFE5, 0xFE4, 0xFE3, 0xFE2, 0xFE1,
    0xFE0, 0xFD5, 0xFD4, 0xFD3, 0xFD2, 0xFD1, 0xFD0, 0xFC6,
    0xFC5, 0xFC3, 0xFC2, 0xFC1, 0xFC0, 0xFB6, 0xFB5, 0xFB3,
    0xFB1, 0xFB0, 0xFA6, 0xFA3, 0xFA1, 0xFA0, 0xF93, 0xF91,
    0xF90, 0xF81, 0xF80, 0xF71, 0xF70, 0xF61, 0xF60, 0xF51,
    0x0E1, 0x0C1, 0x0B1, 0x0A1, 0x0A0, 0x091, 0x090, 0x083,
    0x081, 0x080, 0x073, 0x071, 0x070, 0x063, 0x061, 0x060,
    0x055, 0x053, 0x051, 0x050, 0x045, 0x043, 0x042, 0x041,
    0x040, 0x036, 0x035, 0x034, 0x033, 0x032, 0x031, 0x030,
    0x026, 0x025, 0x024, 0x023, 0x022, 0x021, 0x020, 0x018,
    0x017, 0x016, 0x015, 0x014, 0x013, 0x012, 0x011, 0x010,
};

static const uint16_t ac_vlc_descC_codes[96] = {
    0x00DE, 0x072E, 0x0576, 0x006E, 0x0075, 0x0055, 0x0013, 0x0033,
    0x000D, 0x0007, 0x07D2, 0x0052, 0x0065, 0x00CE, 0x0183, 0x003E,
    0x0001, 0x002E, 0x0F35, 0x0003, 0x0243, 0x001A, 0x0006, 0x01A5,
    0x0043, 0x0012, 0x0E43, 0x00B6, 0x0016, 0x0135, 0x0176, 0x0643,
    0x0035, 0x001E, 0x0735, 0x0283, 0x0125, 0x00AE, 0x00D2, 0x0165,
    0x0103, 0x0603, 0x00E5, 0x0C43, 0x02B5, 0x04A5, 0x00A5, 0x0443,
    0x0265, 0x0476, 0x0212, 0x0112, 0x0376, 0x012E, 0x02D2, 0x0083,
    0x0483, 0x015E, 0x06A5, 0x0335, 0x005E, 0x0025, 0x01D2, 0x00F6,
    0x03D2, 0x032E, 0x03B5, 0x005A, 0x0203, 0x02A5, 0x0BD2, 0x004E,
    0x0032, 0x01B5, 0x00B5, 0x0A65, 0x0225, 0x0276, 0x000E, 0x000A,
    0x03E5, 0x0143, 0x01E5, 0x0036, 0x0092, 0x0005, 0x0009, 0x0665,
    0x0076, 0x00C3, 0x003A, 0x0015, 0x0023, 0x0002, 0x000B, 0x0000,
};

static const uint8_t ac_vlc_descC_bits[96] = {
     8, 11, 11,  7,  7,  7,  6,  6,
     4,  3, 11,  8, 10,  8,  9,  6,
     4,  9, 12, 10, 11,  7,  5,  9,
    11, 10, 12,  8,  6, 10, 11, 12,
     9,  7, 12, 10,  9,  8, 10,  9,
     9, 11,  9, 12, 10, 11, 11, 12,
    12, 11, 10,  9, 10, 10, 10, 11,
    11,  9, 11, 11,  9, 10, 10,  8,
    12, 11, 10,  7, 11, 11, 12,  8,
     6, 10, 10, 12, 10, 10,  7,  5,
    10,  9, 10,  8,  8,  6,  4, 11,
    11,  8,  6,  7,  6,  5,  4,  2,
};

static const int tscc2_ac_vlc_sizes[NUM_VLC_SETS] = {
    172, 169, 165, 162, 131, 132, 130, 125, 121, 114, 110, 101, 96
};

static const uint16_t * const tscc2_ac_vlc_syms[NUM_VLC_SETS] = {
    ac_vlc_desc0_syms, ac_vlc_desc1_syms, ac_vlc_desc2_syms, ac_vlc_desc3_syms,
    ac_vlc_desc4_syms, ac_vlc_desc5_syms, ac_vlc_desc6_syms, ac_vlc_desc7_syms,
    ac_vlc_desc8_syms, ac_vlc_desc9_syms, ac_vlc_descA_syms, ac_vlc_descB_syms,
    ac_vlc_descC_syms,
};

static const uint16_t * const tscc2_ac_vlc_codes[NUM_VLC_SETS] = {
    ac_vlc_desc0_codes, ac_vlc_desc1_codes, ac_vlc_desc2_codes,
    ac_vlc_desc3_codes, ac_vlc_desc4_codes, ac_vlc_desc5_codes,
    ac_vlc_desc6_codes, ac_vlc_desc7_codes, ac_vlc_desc8_codes,
    ac_vlc_desc9_codes, ac_vlc_descA_codes, ac_vlc_descB_codes,
    ac_vlc_descC_codes,
};

static const uint8_t * const tscc2_ac_vlc_bits[NUM_VLC_SETS] = {
    ac_vlc_desc0_bits, ac_vlc_desc1_bits, ac_vlc_desc2_bits, ac_vlc_desc3_bits,
    ac_vlc_desc4_bits, ac_vlc_desc5_bits, ac_vlc_desc6_bits, ac_vlc_desc7_bits,
    ac_vlc_desc8_bits, ac_vlc_desc9_bits, ac_vlc_descA_bits, ac_vlc_descB_bits,
    ac_vlc_descC_bits,
};

#endif /* AVCODEC_TSCC2DATA_H */
