
if(NOT "/srv/build/gridtools/gridtools-2.0.0/obj-x86_64-linux-gnu/_deps/cpp_bindgen-subbuild/cpp_bindgen-populate-prefix/src/cpp_bindgen-populate-stamp/cpp_bindgen-populate-gitinfo.txt" IS_NEWER_THAN "/srv/build/gridtools/gridtools-2.0.0/obj-x86_64-linux-gnu/_deps/cpp_bindgen-subbuild/cpp_bindgen-populate-prefix/src/cpp_bindgen-populate-stamp/cpp_bindgen-populate-gitclone-lastrun.txt")
  message(STATUS "Avoiding repeated git clone, stamp file is up to date: '/srv/build/gridtools/gridtools-2.0.0/obj-x86_64-linux-gnu/_deps/cpp_bindgen-subbuild/cpp_bindgen-populate-prefix/src/cpp_bindgen-populate-stamp/cpp_bindgen-populate-gitclone-lastrun.txt'")
  return()
endif()

execute_process(
  COMMAND ${CMAKE_COMMAND} -E rm -rf "/srv/build/gridtools/gridtools-2.0.0/obj-x86_64-linux-gnu/_deps/cpp_bindgen-src"
  RESULT_VARIABLE error_code
  )
if(error_code)
  message(FATAL_ERROR "Failed to remove directory: '/srv/build/gridtools/gridtools-2.0.0/obj-x86_64-linux-gnu/_deps/cpp_bindgen-src'")
endif()

# try the clone 3 times in case there is an odd git clone issue
set(error_code 1)
set(number_of_tries 0)
while(error_code AND number_of_tries LESS 3)
  execute_process(
    COMMAND "/usr/bin/git"  clone --no-checkout "https://github.com/GridTools/cpp_bindgen.git" "cpp_bindgen-src"
    WORKING_DIRECTORY "/srv/build/gridtools/gridtools-2.0.0/obj-x86_64-linux-gnu/_deps"
    RESULT_VARIABLE error_code
    )
  math(EXPR number_of_tries "${number_of_tries} + 1")
endwhile()
if(number_of_tries GREATER 1)
  message(STATUS "Had to git clone more than once:
          ${number_of_tries} times.")
endif()
if(error_code)
  message(FATAL_ERROR "Failed to clone repository: 'https://github.com/GridTools/cpp_bindgen.git'")
endif()

execute_process(
  COMMAND "/usr/bin/git"  checkout v1.0.1 --
  WORKING_DIRECTORY "/srv/build/gridtools/gridtools-2.0.0/obj-x86_64-linux-gnu/_deps/cpp_bindgen-src"
  RESULT_VARIABLE error_code
  )
if(error_code)
  message(FATAL_ERROR "Failed to checkout tag: 'v1.0.1'")
endif()

set(init_submodules TRUE)
if(init_submodules)
  execute_process(
    COMMAND "/usr/bin/git"  submodule update --recursive --init 
    WORKING_DIRECTORY "/srv/build/gridtools/gridtools-2.0.0/obj-x86_64-linux-gnu/_deps/cpp_bindgen-src"
    RESULT_VARIABLE error_code
    )
endif()
if(error_code)
  message(FATAL_ERROR "Failed to update submodules in: '/srv/build/gridtools/gridtools-2.0.0/obj-x86_64-linux-gnu/_deps/cpp_bindgen-src'")
endif()

# Complete success, update the script-last-run stamp file:
#
execute_process(
  COMMAND ${CMAKE_COMMAND} -E copy
    "/srv/build/gridtools/gridtools-2.0.0/obj-x86_64-linux-gnu/_deps/cpp_bindgen-subbuild/cpp_bindgen-populate-prefix/src/cpp_bindgen-populate-stamp/cpp_bindgen-populate-gitinfo.txt"
    "/srv/build/gridtools/gridtools-2.0.0/obj-x86_64-linux-gnu/_deps/cpp_bindgen-subbuild/cpp_bindgen-populate-prefix/src/cpp_bindgen-populate-stamp/cpp_bindgen-populate-gitclone-lastrun.txt"
  RESULT_VARIABLE error_code
  )
if(error_code)
  message(FATAL_ERROR "Failed to copy script-last-run stamp file: '/srv/build/gridtools/gridtools-2.0.0/obj-x86_64-linux-gnu/_deps/cpp_bindgen-subbuild/cpp_bindgen-populate-prefix/src/cpp_bindgen-populate-stamp/cpp_bindgen-populate-gitclone-lastrun.txt'")
endif()

